package org.lsst.sal.codegen;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import javax.lang.model.element.Modifier;
import javax.xml.parsers.ParserConfigurationException;
import org.lsst.sal.SAL;
import org.xml.sax.SAXException;

/**
 *
 * @author Farrukh Azfar
 */
public class JavaMainWriter {
    
    public JavaMainWriter(CodegenMojo mojo) throws ParserConfigurationException, SAXException, IOException {

        //ok now we have to use JavaPoet to write the program salMainJava to outputPath - 
        MethodSpec privateConstructor = MethodSpec.constructorBuilder()
                .addModifiers(Modifier.PRIVATE).build();

        ParameterizedTypeName returnType = ParameterizedTypeName.get(ClassName.get(SAL.class),
                ClassName.get(mojo.getBasePackageName(), mojo.getCommandParent()),
                ClassName.get(mojo.getBasePackageName(), mojo.getEventParent()),
                ClassName.get(mojo.getBasePackageName(), mojo.getTelemetryParent()));

        MethodSpec createMethod = MethodSpec.methodBuilder("create")
                .addModifiers(Modifier.PUBLIC, Modifier.STATIC)
                .addStatement("return SAL.create($N.class, $S)", mojo.getSalMain(), mojo.getSALFileName())
                .returns(returnType)
                .build();

        MethodSpec mainMethod = MethodSpec.methodBuilder("main")
                .addModifiers(Modifier.PUBLIC, Modifier.STATIC)
                .returns(void.class)
                .addParameter(String[].class, "args")
                .addStatement(mojo.getSalMain() + ".create()")
                .build();
        
        TypeSpec classDefinition = TypeSpec.classBuilder(mojo.getSalMain())
                .addModifiers(Modifier.PUBLIC)
                .addMethod(privateConstructor)
                .addMethod(createMethod)
                .addMethod(mainMethod)
                .build();

        JavaFile javaFile = JavaFile.builder(mojo.getBasePackageName(), classDefinition)
                .skipJavaLangImports(true)
                .build();
        javaFile.writeTo(mojo.getOutputDir());
    }

}
