package org.lsst.sal.codegen;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.xml.sax.SAXException;

/**
 *
 * @author tonyj
 */
@Mojo(name = "codegen", defaultPhase = LifecyclePhase.GENERATE_SOURCES)
public class CodegenMojo extends AbstractMojo {
    
    @Parameter(property = "project", defaultValue = "${project}")
    private MavenProject project;
    
    @Parameter(property ="salMain", defaultValue = "SALMain")
    private String salMain;
    
    @Parameter(property = "outputDir", defaultValue = "${project.build.directory}/generated-sources/sal-code")
    private File outputDir;

    @Parameter(property = "outputTestDir", defaultValue = "${project.build.directory}/generated-test-sources/sal-test")
    private File outputTestDir;
    
    @Parameter(property = "outputResourcesDir", defaultValue = "${project.build.directory}/generated-sources/sal-resources")
    private File outputResourcesDir;

    // specify an input directory 
    @Parameter(property = "inputDir", defaultValue = "${project.basedir}/src/main/resources/sal_xml")
    private File inputDir;

    @Parameter(property = "xmlFiles")
    private String[] xmlFiles;

    // specify a package name - this can be defined in the pom.xml when used for code generation elsewhere...
    @Parameter(property = "basePackageName", defaultValue = "org.lsst.sal.camera")
    private String basePackageName;
    
    // specify managerClass Name 
    @Parameter(property = "managerClassName", defaultValue = "org.lsst.sal.SAL_MTCamera")
    private String managerClassName;

    // specify the parent class from which all telemetry classes derive/extend from
    @Parameter(property = "telemetryParent", defaultValue = "org.lsst.sal.SALTelemetry")
    private String telemetryParent;

    // specify the parent class from which all event classes derive/extend from
    @Parameter(property = "stateParent", defaultValue = "org.lsst.sal.SALStateChangeEvent")
    private String stateParent;

    // specify the parent class from which all command classes derive/extend from 
    @Parameter(property = "eventParent", defaultValue = "org.lsst.sal.SALEvent")
    private String eventParent;

    //specify the parent class from which all state classes derive/extend from  
    @Parameter(property = "commandParent", defaultValue = "org.lsst.sal.SALCommand")
    private String commandParent;
    
    //specify the name of the generated .sal file
    @Parameter(property = "salFile", defaultValue = "salFile.sal")
    private String salFile;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        List<URL> xmlURLs = new ArrayList<>();
        for (String xmlFile : xmlFiles) {
            URL resource = this.getClass().getClassLoader().getResource(xmlFile);
            if (resource == null) throw new RuntimeException("XML files not found: "+xmlFile);
            xmlURLs.add(resource);
        }
        
        this.project.addCompileSourceRoot(this.outputDir.getAbsolutePath());
        this.project.addTestCompileSourceRoot(this.outputTestDir.getAbsolutePath());
        Resource generatedResources = new Resource();
        generatedResources.setDirectory(outputResourcesDir.getAbsolutePath());
        this.project.addResource(generatedResources);
       
        this.outputDir.mkdirs();
        try {
            JavaFromXML javaXML = new JavaFromXML(basePackageName, managerClassName, salFile, stateParent, eventParent, commandParent, telemetryParent, salMain, outputDir.getAbsolutePath(), outputTestDir.getAbsolutePath(), outputResourcesDir.getAbsolutePath(), xmlURLs);
        } catch (IOException | ParserConfigurationException | SAXException e) {
            throw new MojoExecutionException("Could not generate Java source code!", e);
        }   
        
        try {
            JavaMainWriter javaMain = new JavaMainWriter(salMain, basePackageName, outputDir.getAbsolutePath(), 
                    commandParent, eventParent, telemetryParent, salFile);
        } catch (IOException | ParserConfigurationException | SAXException e) {
            throw new MojoExecutionException("Could not generate Java source code!", e);
        }       
    }
    
}
