/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.codegen;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.lsst.sal.codegen.JavaFromXML;
import org.lsst.sal.codegen.JavaMainWriter;
import org.xml.sax.SAXException;

@Mojo(name="codegen", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class CodegenMojo
extends AbstractMojo {
    @Parameter(property="project", defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="salMain", defaultValue="SALMain")
    private String salMain;
    @Parameter(property="outputDir", defaultValue="${project.build.directory}/generated-sources/sal-code")
    private File outputDir;
    @Parameter(property="outputTestDir", defaultValue="${project.build.directory}/generated-test-sources/sal-test")
    private File outputTestDir;
    @Parameter(property="outputResourcesDir", defaultValue="${project.build.directory}/generated-sources/sal-resources")
    private File outputResourcesDir;
    @Parameter(property="inputDir", defaultValue="${project.basedir}/src/main/resources/sal_xml")
    private File inputDir;
    @Parameter(property="xmlFiles")
    private String[] xmlFiles;
    @Parameter(property="basePackageName", defaultValue="org.lsst.sal.camera")
    private String basePackageName;
    @Parameter(property="managerClassName", defaultValue="org.lsst.sal.SAL_MTCamera")
    private String managerClassName;
    @Parameter(property="telemetryParent", defaultValue="org.lsst.sal.SALTelemetry")
    private String telemetryParent;
    @Parameter(property="stateParent", defaultValue="org.lsst.sal.SALStateChangeEvent")
    private String stateParent;
    @Parameter(property="eventParent", defaultValue="org.lsst.sal.SALEvent")
    private String eventParent;
    @Parameter(property="commandParent", defaultValue="org.lsst.sal.SALCommand")
    private String commandParent;
    @Parameter(property="salFile", defaultValue="salFile.sal")
    private String salFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArrayList<URL> xmlURLs = new ArrayList<URL>();
        for (String xmlFile : this.xmlFiles) {
            URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(xmlFile);
            if (resource == null) {
                throw new RuntimeException("XML files not found: " + xmlFile);
            }
            xmlURLs.add(resource);
        }
        this.project.addCompileSourceRoot(this.outputDir.getAbsolutePath());
        this.project.addTestCompileSourceRoot(this.outputTestDir.getAbsolutePath());
        Resource generatedResources = new Resource();
        generatedResources.setDirectory(this.outputResourcesDir.getAbsolutePath());
        this.project.addResource(generatedResources);
        this.outputDir.mkdirs();
        try {
            JavaFromXML javaFromXML = new JavaFromXML(this.basePackageName, this.managerClassName, this.salFile, this.stateParent, this.eventParent, this.commandParent, this.telemetryParent, this.salMain, this.outputDir.getAbsolutePath(), this.outputTestDir.getAbsolutePath(), this.outputResourcesDir.getAbsolutePath(), xmlURLs);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new MojoExecutionException("Could not generate Java source code!", e);
        }
        try {
            JavaMainWriter e = new JavaMainWriter(this.salMain, this.basePackageName, this.outputDir.getAbsolutePath(), this.commandParent, this.eventParent, this.telemetryParent, this.salFile);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new MojoExecutionException("Could not generate Java source code!", e);
        }
    }
}

