/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.codegen;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.lsst.sal.SALEnum;
import org.lsst.sal.codegen.JavaFromXML;

final class ClassInfo {
    private final String className;
    private Map<String, TypeName> variableNamesAndTypesMap;
    private final Map<String, TypeName> superClassArguments = new LinkedHashMap<String, TypeName>();
    private final Map<String, JavaFromXML.Variable> variableNamesAndCounts = new LinkedHashMap<String, JavaFromXML.Variable>();
    private String packageName;
    private final String superClassName;
    private final Map<String, TypeSpec> enumerations;
    private final JavaFromXML.ClassType classType;
    private final String salClassName;
    private boolean isInherited = false;

    ClassInfo(String rawClassName, String className, String basePackageName, String stateParent, String eventParent, String commandParent, String telemetryParent, Map<String, JavaFromXML.Variable> variableNamesAndTypesMap, Map<String, JavaFromXML.EnumValues> enumMap, JavaFromXML.ClassType classType, String salClassName) {
        boolean isState;
        boolean hasPriority;
        this.className = ClassInfo.computeClassName(className, classType);
        this.packageName = ClassInfo.computePackageName(classType, basePackageName);
        this.superClassName = ClassInfo.computeSuperClass(classType, stateParent, eventParent, commandParent, telemetryParent);
        this.enumerations = ClassInfo.computeEnumerations(enumMap);
        this.variableNamesAndTypesMap = this.convertToTypeMap(variableNamesAndTypesMap);
        this.classType = classType;
        this.salClassName = salClassName;
        boolean bl = hasPriority = classType != JavaFromXML.ClassType.TELEMETRY && classType != JavaFromXML.ClassType.COMMAND;
        if (hasPriority) {
            this.superClassArguments.put("priority", TypeName.INT);
        }
        boolean bl2 = isState = classType == JavaFromXML.ClassType.STATE;
        if (isState) {
            String type2 = className.replace("Event", "").replace("Detailed", "");
            String values = enumMap.values().iterator().next().getEnumConstants();
            this.enumerations.clear();
            TypeSpec.Builder enumBuilder = TypeSpec.enumBuilder((String)type2).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(SALEnum.class);
            String[] stringArray = values.split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String value = stringArray[i];
                enumBuilder.addEnumConstant(value.trim());
            }
            this.enumerations.put("substate", enumBuilder.build());
            this.variableNamesAndTypesMap.clear();
            this.variableNamesAndTypesMap.put("substate", (TypeName)ClassName.bestGuess((String)type2));
        }
        if (this.packageName.contains("atcamera") || this.packageName.contains("cccamera")) {
            String inherited = this.packageName.replace("atcamera", "camera");
            inherited = inherited.replace("cccamera", "camera");
            try {
                Class<?> inheritedClass = Class.forName(inherited + "." + this.className);
                for (Constructor<?> constructor : inheritedClass.getConstructors()) {
                    Map<String, TypeName> constructorArguments = this.getConstructorArguments();
                    ArrayList<TypeName> argTypes = new ArrayList<TypeName>(constructorArguments.values());
                    if (constructor.getParameterCount() != constructorArguments.size()) continue;
                    boolean match = true;
                    for (int i = 0; i < constructor.getParameterCount(); ++i) {
                        if (constructor.getParameterTypes()[i].isArray() == argTypes.get(i) instanceof ArrayTypeName) continue;
                        match = false;
                    }
                    if (!match) continue;
                    this.packageName = inherited;
                    this.isInherited = true;
                    variableNamesAndTypesMap.forEach((name, type) -> {
                        if (this.enumerations.containsKey(name)) {
                            ClassName typeName = ClassName.get((String)(this.packageName + "." + this.className), (String)JavaFromXML.capitalize(type.getType()), (String[])new String[0]);
                            if (type.getCount() > 1) {
                                typeName = ArrayTypeName.of((TypeName)typeName);
                            }
                            this.variableNamesAndTypesMap.put((String)name, (TypeName)typeName);
                        }
                    });
                    break;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, TypeName> getVariableNamesAndTypesMap() {
        return this.variableNamesAndTypesMap;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public Set<TypeSpec> getEnumerations() {
        return new HashSet<TypeSpec>(this.enumerations.values());
    }

    JavaFromXML.ClassType getClassType() {
        return this.classType;
    }

    private static String computeClassName(String className, JavaFromXML.ClassType classType) {
        switch (classType) {
            case STATE: 
            case EVENT: {
                return className + "Event";
            }
            case TELEMETRY: {
                return className + "Telemetry";
            }
            case COMMAND: {
                return className + "Command";
            }
        }
        return className;
    }

    private static String computePackageName(JavaFromXML.ClassType classType, String basePackageName) {
        switch (classType) {
            case STATE: {
                return basePackageName + ".states";
            }
            case EVENT: {
                return basePackageName + ".event";
            }
            case TELEMETRY: {
                return basePackageName + ".telemetry";
            }
            case COMMAND: {
                return basePackageName + ".command";
            }
        }
        return basePackageName;
    }

    private static String computeSuperClass(JavaFromXML.ClassType classType, String stateParent, String eventParent, String commandParent, String telemetryParent) {
        switch (classType) {
            case STATE: {
                return stateParent;
            }
            case EVENT: {
                return eventParent;
            }
            case TELEMETRY: {
                return telemetryParent;
            }
            case COMMAND: {
                return commandParent;
            }
        }
        return commandParent;
    }

    private Map<String, TypeName> convertToTypeMap(Map<String, JavaFromXML.Variable> variableNamesAndTypesMap) {
        LinkedHashMap<String, TypeName> result = new LinkedHashMap<String, TypeName>();
        variableNamesAndTypesMap.forEach((name, type) -> {
            result.put((String)name, this.mapVariableTypeToJava((JavaFromXML.Variable)type, (String)name));
            this.variableNamesAndCounts.put((String)name, (JavaFromXML.Variable)type);
        });
        return result;
    }

    private TypeName mapVariableTypeToJava(JavaFromXML.Variable variable, String name) {
        String type = variable.getType();
        Object typeName = type.equals("string") ? TypeName.get(String.class) : (type.contains("long") ? TypeName.INT : (this.enumerations.containsKey(name) ? ClassName.get((String)(this.packageName + "." + this.className), (String)JavaFromXML.capitalize(type), (String[])new String[0]) : TypeVariableName.get((String)type)));
        if (variable.getCount() > 1) {
            typeName = ArrayTypeName.of((TypeName)typeName);
        }
        return typeName;
    }

    String getClassTypeName() {
        String whatClass = "";
        if (this.classType == JavaFromXML.ClassType.TELEMETRY) {
            whatClass = "telemetry";
        }
        if (this.classType == JavaFromXML.ClassType.COMMAND) {
            whatClass = "command";
        }
        if (this.classType == JavaFromXML.ClassType.EVENT) {
            whatClass = "event";
        }
        if (this.classType == JavaFromXML.ClassType.STATE) {
            whatClass = "state";
        }
        return whatClass;
    }

    String getSALClassName() {
        return this.salClassName;
    }

    Map<String, TypeName> getSuperClassArguments() {
        return this.superClassArguments;
    }

    Map<String, TypeName> getConstructorArguments() {
        LinkedHashMap<String, TypeName> map = new LinkedHashMap<String, TypeName>();
        map.putAll(this.superClassArguments);
        map.putAll(this.variableNamesAndTypesMap);
        return map;
    }

    private static Map<String, TypeSpec> computeEnumerations(Map<String, JavaFromXML.EnumValues> enumMap) {
        LinkedHashMap<String, TypeSpec> result = new LinkedHashMap<String, TypeSpec>();
        enumMap.forEach((name, values) -> {
            TypeSpec.Builder enumerationBuilder = TypeSpec.enumBuilder((String)JavaFromXML.capitalize(values.getType())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(SALEnum.class);
            for (String value : values.getEnumConstants().split(",")) {
                enumerationBuilder.addEnumConstant(value.trim());
            }
            result.put((String)name, enumerationBuilder.build());
        });
        return result;
    }

    boolean isEnumeration(String name) {
        return this.enumerations.containsKey(name);
    }

    boolean isArray(String name) {
        return this.variableNamesAndTypesMap.get(name) instanceof ArrayTypeName;
    }

    TypeSpec getEnumerationType(String name) {
        return this.enumerations.get(name);
    }

    int getCount(String name) {
        return this.variableNamesAndCounts.get(name).getCount();
    }

    int getSize(String name) {
        return this.variableNamesAndCounts.get(name).getSize();
    }

    String getGetter(String name) {
        TypeName type = this.variableNamesAndTypesMap.get(name);
        if (type == null) {
            type = TypeName.INT;
        }
        String stem = type.toString().equalsIgnoreCase("boolean") ? "is" : "get";
        return stem + JavaFromXML.capitalize(name);
    }

    boolean isInherited() {
        return this.isInherited;
    }
}

