/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.lsst.sal.codegen.ClassInfo;
import org.lsst.sal.codegen.JavaFromXML;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ReadXMLFillArray {
    private final List<ClassInfo> classInfoCollection = new ArrayList<ClassInfo>();
    private final String basePackageName;
    private final String stateParent;
    private final String eventParent;
    private final String commandParent;
    private final String telemetryParent;

    public ReadXMLFillArray(String basePackageName, String stateParent, String eventParent, String commandParent, String telemetryParent, Document document) {
        this.basePackageName = basePackageName;
        this.stateParent = stateParent;
        this.eventParent = eventParent;
        this.commandParent = commandParent;
        this.telemetryParent = telemetryParent;
        Element root = document.getDocumentElement();
        if ("SALObjects".equals(root.getTagName())) {
            NodeList childNodes = root.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node item = childNodes.item(i);
                if (!(item instanceof Element)) continue;
                Element element = (Element)item;
                JavaFromXML.ClassType classType = element.getTagName().contains("Event") ? JavaFromXML.ClassType.EVENT : (element.getTagName().contains("Telemetry") ? JavaFromXML.ClassType.TELEMETRY : JavaFromXML.ClassType.COMMAND);
                this.handleObjectsOfClass(element, classType);
            }
        } else {
            JavaFromXML.ClassType classType = root.getTagName().contains("Event") ? JavaFromXML.ClassType.EVENT : (root.getTagName().contains("Telemetry") ? JavaFromXML.ClassType.TELEMETRY : JavaFromXML.ClassType.COMMAND);
            this.handleObjectsOfClass(root, classType);
        }
    }

    private void handleObjectsOfClass(Element document, JavaFromXML.ClassType classType) throws NumberFormatException, DOMException {
        NodeList salClassNodes = document.getElementsByTagName(classType.getTag());
        for (int i = 0; i < salClassNodes.getLength(); ++i) {
            LinkedHashMap<String, JavaFromXML.Variable> variableNamesAndTypesMap = new LinkedHashMap<String, JavaFromXML.Variable>();
            LinkedHashMap<String, JavaFromXML.EnumValues> enumMap = new LinkedHashMap<String, JavaFromXML.EnumValues>();
            NodeList salClassContentNodes = salClassNodes.item(i).getChildNodes();
            if (!(salClassNodes.item(i) instanceof Element)) continue;
            Element eClass = (Element)salClassNodes.item(i);
            NodeList topicList = eClass.getElementsByTagName("EFDB_Topic");
            if (topicList.getLength() > 1) {
                System.out.println("More than one EFDB_Topic(Class Name) in class - incorrect xml \n");
                System.exit(0);
            }
            String className = topicList.item(0).getTextContent().trim();
            String rawClassName = className.split("_", 2)[0] + "." + className.split("_", 2)[1];
            className = className.split("_", 2)[1];
            className = className.replace("logevent_", "");
            className = (className = className.replace("command_", "")).contains("ccs") ? className.replace("ccs", "CCS") : className.substring(0, 1).toUpperCase() + className.substring(1);
            JavaFromXML.ClassType thisClassType = classType;
            NodeList itemList = eClass.getElementsByTagName("item");
            for (int iI = 0; iI < itemList.getLength(); ++iI) {
                if (!(itemList.item(iI) instanceof Element)) continue;
                Element eI = (Element)itemList.item(iI);
                NodeList efdbNameList = eI.getElementsByTagName("EFDB_Name");
                NodeList idlTypeList = eI.getElementsByTagName("IDL_Type");
                NodeList idlSizeList = eI.getElementsByTagName("IDL_Size");
                NodeList enumerationList = eI.getElementsByTagName("Enumeration");
                NodeList countList = eI.getElementsByTagName("Count");
                if (efdbNameList.getLength() > 1 || idlTypeList.getLength() > 1 || enumerationList.getLength() > 1 || efdbNameList.getLength() != idlTypeList.getLength()) {
                    System.out.println(" There should only be 1 EFDB_Name, IDL_Type, Enumeration List in an item \n ");
                    System.out.println(" Every EFDB_Name should have a corresponding IDL_Type");
                    System.exit(0);
                }
                int count = Integer.parseInt(countList.item(0).getTextContent().trim());
                int size = 0;
                if (idlSizeList.getLength() >= 1) {
                    size = Integer.parseInt(idlSizeList.item(0).getTextContent().trim());
                }
                if (className.endsWith("SummaryState")) {
                    enumMap.put(efdbNameList.item(0).getTextContent().trim(), new JavaFromXML.EnumValues("SummaryState", "DISABLED,ENABLED,FAULT,OFFLINE,STANDBY"));
                }
                if (enumerationList.getLength() > 0) {
                    String enumType = efdbNameList.item(0).getTextContent().trim();
                    enumMap.put(efdbNameList.item(0).getTextContent().trim(), new JavaFromXML.EnumValues(enumType, enumerationList.item(0).getTextContent().trim()));
                    variableNamesAndTypesMap.put(efdbNameList.item(0).getTextContent().trim(), new JavaFromXML.Variable(enumType, count, size));
                    continue;
                }
                if (efdbNameList.getLength() <= 0 || enumerationList.getLength() >= 1) continue;
                String type = idlTypeList.item(0).getTextContent().trim();
                if (classType.equals((Object)JavaFromXML.ClassType.COMMAND) && efdbNameList.item(0).getTextContent().trim().equals("value") && type.equals("boolean")) continue;
                variableNamesAndTypesMap.put(efdbNameList.item(0).getTextContent().trim(), new JavaFromXML.Variable(type, count, size));
            }
            this.classInfoCollection.add(new ClassInfo(rawClassName, className, this.basePackageName, this.stateParent, this.eventParent, this.commandParent, this.telemetryParent, variableNamesAndTypesMap, enumMap, thisClassType, rawClassName));
        }
    }

    public List<ClassInfo> getClassInfos() {
        return this.classInfoCollection;
    }

    static Map<String, Long> enumerationFromElement(Node node) {
        AtomicInteger inc = new AtomicInteger(0);
        return Arrays.stream(node.getTextContent().split("\\s*,\\s*")).map(e -> e.split("\\s*=\\s*")).collect(Collectors.toMap(e -> e[0], e -> ((String[])e).length < 2 ? (long)inc.getAndIncrement() : Long.decode(e[1].trim()), (e1, e2) -> e1, LinkedHashMap::new));
    }
}

