/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.codegen;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.lsst.sal.codegen.ClassInfo;
import org.lsst.sal.codegen.JavaClassWriter;
import org.lsst.sal.codegen.ReadXMLFillArray;
import org.lsst.sal.codegen.SalWriter;
import org.lsst.sal.codegen.TestGenerator;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class JavaFromXML {
    private final String basePackageName;
    private final String outputPath;
    private final File[] xmlFilelist;
    private final String managerClassName;
    private final String stateParent;
    private final String eventParent;
    private final String commandParent;
    private final String telemetryParent;
    private final String salFileName;

    public JavaFromXML(String basePackageName, String managerClassName, String salFileName, String stateParent, String eventParent, String commandParent, String telemetryParent, String salMainJava, String outputPath, String testOutputPath, String outputResoucesPath, File[] xmlFileList) throws ParserConfigurationException, SAXException, IOException {
        this.basePackageName = basePackageName;
        this.outputPath = outputPath;
        this.salFileName = salFileName;
        this.xmlFilelist = xmlFileList;
        this.managerClassName = managerClassName;
        this.stateParent = stateParent;
        this.eventParent = eventParent;
        this.commandParent = commandParent;
        this.telemetryParent = telemetryParent;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        ArrayList<ClassInfo> classInfos = new ArrayList<ClassInfo>();
        for (File xmlFile : xmlFileList) {
            Document document = builder.parse(xmlFile.toString());
            ReadXMLFillArray xmlContent = new ReadXMLFillArray(basePackageName, stateParent, eventParent, commandParent, telemetryParent, document);
            classInfos.addAll(xmlContent.getClassInfos());
        }
        for (ClassInfo info : classInfos) {
            if (info.isInherited()) continue;
            JavaClassWriter writer = new JavaClassWriter(info);
            writer.writeClasses(outputPath);
        }
        SalWriter salWriter = new SalWriter(classInfos, managerClassName);
        salWriter.writeSalFile(outputResoucesPath, salFileName, basePackageName);
        TestGenerator testGenerator = new TestGenerator(classInfos, basePackageName, salMainJava);
        testGenerator.writeTestFiles(testOutputPath);
    }

    static String capitalize(String in) {
        return in.substring(0, 1).toUpperCase() + in.substring(1);
    }

    static enum ClassType {
        TELEMETRY("SALTelemetry"),
        STATE("SALEvent"),
        EVENT("SALEvent"),
        COMMAND("SALCommand");

        private final String tag;

        private ClassType(String tag) {
            this.tag = tag;
        }

        public String getTag() {
            return this.tag;
        }
    }

    static class Variable {
        private final int count;
        private final int size;
        private final String type;

        public Variable(String type, int count, int size) {
            this.type = type;
            this.count = count;
            this.size = size;
        }

        public int getCount() {
            return this.count;
        }

        public String getType() {
            return this.type;
        }

        public int getSize() {
            return this.size;
        }
    }

    static class EnumValues {
        private final String type;
        private final String values;

        public EnumValues(String type, String values) {
            this.type = type;
            this.values = values;
        }

        public String getType() {
            return this.type;
        }

        public String getEnumConstants() {
            return this.values;
        }
    }
}

