/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.codegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.lsst.sal.codegen.ClassInfo;

class JavaClassWriter {
    private final ClassInfo classInfo;

    JavaClassWriter(ClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    void writeClasses(String outputPath) throws IOException {
        ArrayList fields = new ArrayList();
        this.classInfo.getVariableNamesAndTypesMap().forEach((name, type) -> fields.add(FieldSpec.builder((TypeName)type, (String)name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build()));
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        methods.add(this.constructConstructor());
        this.classInfo.getVariableNamesAndTypesMap().forEach((name, type) -> methods.add(this.constructGetter((String)name, (TypeName)type)));
        methods.add(this.constructToStringMethod());
        TypeSpec classDefinition = TypeSpec.classBuilder((String)this.classInfo.getClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ClassName.bestGuess((String)this.classInfo.getSuperClassName())).addMethods(methods).addFields(fields).addTypes(this.classInfo.getEnumerations()).build();
        JavaFile javaFile = JavaFile.builder((String)this.classInfo.getPackageName(), (TypeSpec)classDefinition).skipJavaLangImports(true).build();
        javaFile.writeTo(new File(outputPath));
    }

    private MethodSpec constructGetter(String name, TypeName type) {
        MethodSpec.Builder getterBuilder = MethodSpec.methodBuilder((String)this.classInfo.getGetter(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(type).addStatement("return $L", new Object[]{name});
        if (name.equals("substate")) {
            getterBuilder.addAnnotation(Override.class);
        }
        return getterBuilder.build();
    }

    private MethodSpec constructToStringMethod() {
        CodeBlock.Builder toStringCodeBuilder = CodeBlock.builder().add("return $S + ", new Object[]{this.classInfo.getClassName() + "{"});
        String delimiter = "";
        for (Map.Entry<String, TypeName> var : this.classInfo.getVariableNamesAndTypesMap().entrySet()) {
            String name = var.getKey();
            toStringCodeBuilder.add("$S + $N +$Z", new Object[]{delimiter + name + "=", name});
            delimiter = ", ";
        }
        CodeBlock toStringCode = toStringCodeBuilder.add("$S", new Object[]{"}"}).build();
        return MethodSpec.methodBuilder((String)"toString").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class).addStatement(toStringCode).build();
    }

    private MethodSpec constructConstructor() {
        ArrayList parameters = new ArrayList();
        this.classInfo.getConstructorArguments().forEach((name, type) -> parameters.add(ParameterSpec.builder((TypeName)type, (String)name, (Modifier[])new Modifier[0]).build()));
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameters(parameters);
        if (!this.classInfo.getSuperClassArguments().isEmpty()) {
            constructorBuilder.addStatement("super ($N)", new Object[]{String.join((CharSequence)",", this.classInfo.getSuperClassArguments().keySet())});
        }
        this.classInfo.getVariableNamesAndTypesMap().entrySet().forEach(var -> {
            String name = (String)var.getKey();
            constructorBuilder.addStatement("this.$1L = $1L", new Object[]{name});
        });
        return constructorBuilder.build();
    }
}

