/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.codegen;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.lsst.sal.codegen.ClassInfo;
import org.lsst.sal.codegen.JavaClassWriter;
import org.lsst.sal.codegen.SalWriter;
import org.lsst.sal.codegen.TestGenerator;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JavaFromXML {
    private final String basePackageName;
    private final String outputPath;
    private final File[] xmlFilelist;
    private final String managerClassName;
    private final String stateParent;
    private final String eventParent;
    private final String commandParent;
    private final String telemetryParent;
    private final String salFileName;

    public JavaFromXML(String basePackageName, String managerClassName, String salFileName, String stateParent, String eventParent, String commandParent, String telemetryParent, String salMainJava, String outputPath, String testOutputPath, String outputResoucesPath, File[] xmlFileList) throws ParserConfigurationException, SAXException, IOException {
        this.basePackageName = basePackageName;
        this.outputPath = outputPath;
        this.salFileName = salFileName;
        this.xmlFilelist = xmlFileList;
        this.managerClassName = managerClassName;
        this.stateParent = stateParent;
        this.eventParent = eventParent;
        this.commandParent = commandParent;
        this.telemetryParent = telemetryParent;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        ArrayList<ClassInfo> classInfos = new ArrayList<ClassInfo>();
        for (File xmlFile : xmlFileList) {
            ReadXMLFillArray xmlContent = new ReadXMLFillArray(builder, xmlFile.getAbsolutePath());
            classInfos.addAll(xmlContent.getClassInfos());
        }
        for (ClassInfo info : classInfos) {
            if (info.isInherited()) continue;
            JavaClassWriter writer = new JavaClassWriter(info);
            writer.writeClasses(outputPath);
        }
        SalWriter salWriter = new SalWriter(classInfos, managerClassName);
        salWriter.writeSalFile(outputResoucesPath, salFileName, basePackageName);
        TestGenerator testGenerator = new TestGenerator(classInfos, basePackageName, salMainJava);
        testGenerator.writeTestFiles(testOutputPath);
    }

    static String capitalize(String in) {
        return in.substring(0, 1).toUpperCase() + in.substring(1);
    }

    private class ReadXMLFillArray {
        private List<ClassInfo> classInfoCollection = new ArrayList<ClassInfo>();
        private boolean stateEvent;
        private String rawClassName;

        public ReadXMLFillArray(DocumentBuilder builder, String xmlFileName) throws SAXException {
            try {
                Document document = builder.parse(new InputSource(new FileReader(xmlFileName)));
                Element root = document.getDocumentElement();
                System.out.println("ROOT ELEMENT : " + root.getTagName());
                if ("SALObjects".equals(root.getTagName())) {
                    NodeList childNodes = root.getChildNodes();
                    for (int i = 0; i < childNodes.getLength(); ++i) {
                        Node item = childNodes.item(i);
                        if (!(item instanceof Element)) continue;
                        Element element = (Element)item;
                        ClassType classType = element.getTagName().contains("Event") ? ClassType.EVENT : (element.getTagName().contains("Telemetry") ? ClassType.TELEMETRY : ClassType.COMMAND);
                        System.out.println("***Handling classType " + (Object)((Object)classType));
                        this.handleObjectsOfClass(element, classType);
                    }
                } else {
                    ClassType classType = root.getTagName().contains("Event") ? ClassType.EVENT : (root.getTagName().contains("Telemetry") ? ClassType.TELEMETRY : ClassType.COMMAND);
                    this.handleObjectsOfClass(root, classType);
                }
            }
            catch (IOException ex) {
                System.out.println("Exception caught in readXMLFileArray: \n");
                Logger.getLogger(JavaFromXML.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        private void handleObjectsOfClass(Element document, ClassType classType) throws NumberFormatException, DOMException {
            NodeList salClassNodes = document.getElementsByTagName(classType.getTag());
            for (int i = 0; i < salClassNodes.getLength(); ++i) {
                LinkedHashMap<String, Variable> variableNamesAndTypesMap = new LinkedHashMap<String, Variable>();
                LinkedHashMap<String, EnumValues> enumMap = new LinkedHashMap<String, EnumValues>();
                NodeList salClassContentNodes = salClassNodes.item(i).getChildNodes();
                if (!(salClassNodes.item(i) instanceof Element)) continue;
                Element eClass = (Element)salClassNodes.item(i);
                NodeList topicList = eClass.getElementsByTagName("EFDB_Topic");
                if (topicList.getLength() > 1) {
                    System.out.println("More than one EFDB_Topic(Class Name) in class - incorrect xml \n");
                    System.exit(0);
                }
                String className = topicList.item(0).getTextContent().trim();
                this.rawClassName = className.split("_", 2)[0] + "." + className.split("_", 2)[1];
                className = (className = className.split("_", -1)[className.split("_", -1).length - 1]).contains("ccs") ? className.replace("ccs", "CCS") : className.substring(0, 1).toUpperCase() + className.substring(1);
                ClassType thisClassType = classType;
                if (className.endsWith("State")) {
                    thisClassType = ClassType.STATE;
                }
                NodeList itemList = eClass.getElementsByTagName("item");
                for (int iI = 0; iI < itemList.getLength(); ++iI) {
                    if (!(itemList.item(iI) instanceof Element)) continue;
                    Element eI = (Element)itemList.item(iI);
                    NodeList efdbNameList = eI.getElementsByTagName("EFDB_Name");
                    NodeList idlTypeList = eI.getElementsByTagName("IDL_Type");
                    NodeList idlSizeList = eI.getElementsByTagName("IDL_Size");
                    NodeList enumerationList = eI.getElementsByTagName("Enumeration");
                    NodeList countList = eI.getElementsByTagName("Count");
                    if (efdbNameList.getLength() > 1 || idlTypeList.getLength() > 1 || enumerationList.getLength() > 1 || efdbNameList.getLength() != idlTypeList.getLength()) {
                        System.out.println(" There should only be 1 EFDB_Name, IDL_Type, Enumeration List in an item \n ");
                        System.out.println(" Every EFDB_Name should have a corresponding IDL_Type");
                        System.exit(0);
                    }
                    int count = Integer.parseInt(countList.item(0).getTextContent().trim());
                    int size = 0;
                    if (idlSizeList.getLength() >= 1) {
                        size = Integer.parseInt(idlSizeList.item(0).getTextContent().trim());
                    }
                    if (className.endsWith("SummaryState")) {
                        enumMap.put(efdbNameList.item(0).getTextContent().trim(), new EnumValues("SummaryState", "DISABLED,ENABLED,FAULT,OFFLINE,STANDBY"));
                    }
                    if (enumerationList.getLength() > 0) {
                        String enumType = efdbNameList.item(0).getTextContent().trim();
                        enumMap.put(efdbNameList.item(0).getTextContent().trim(), new EnumValues(enumType, enumerationList.item(0).getTextContent().trim()));
                        variableNamesAndTypesMap.put(efdbNameList.item(0).getTextContent().trim(), new Variable(enumType, count, size));
                        continue;
                    }
                    if (efdbNameList.getLength() <= 0 || enumerationList.getLength() >= 1) continue;
                    String type = idlTypeList.item(0).getTextContent().trim();
                    if (classType.equals((Object)ClassType.COMMAND) && efdbNameList.item(0).getTextContent().trim().equals("value") && type.equals("boolean")) {
                        System.out.println("boolean variable value found for Command Class - thrown out");
                        continue;
                    }
                    variableNamesAndTypesMap.put(efdbNameList.item(0).getTextContent().trim(), new Variable(type, count, size));
                }
                this.classInfoCollection.add(new ClassInfo(this.rawClassName, className, JavaFromXML.this.basePackageName, JavaFromXML.this.stateParent, JavaFromXML.this.eventParent, JavaFromXML.this.commandParent, JavaFromXML.this.telemetryParent, variableNamesAndTypesMap, enumMap, thisClassType, this.rawClassName));
            }
        }

        public List<ClassInfo> getClassInfos() {
            return this.classInfoCollection;
        }
    }

    static enum ClassType {
        TELEMETRY("SALTelemetry"),
        STATE("SALEvent"),
        EVENT("SALEvent"),
        COMMAND("SALCommand");

        private final String tag;

        private ClassType(String tag) {
            this.tag = tag;
        }

        public String getTag() {
            return this.tag;
        }
    }

    static class Variable {
        private final int count;
        private final int size;
        private final String type;

        public Variable(String type, int count, int size) {
            this.type = type;
            this.count = count;
            this.size = size;
        }

        public int getCount() {
            return this.count;
        }

        public String getType() {
            return this.type;
        }

        public int getSize() {
            return this.size;
        }
    }

    static class EnumValues {
        private final String type;
        private final String values;

        public EnumValues(String type, String values) {
            this.type = type;
            this.values = values;
        }

        public String getType() {
            return this.type;
        }

        public String getEnumConstants() {
            return this.values;
        }
    }
}

