package org.lsst.sal.codegen;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import javax.lang.model.element.Modifier;
import javax.xml.parsers.ParserConfigurationException;
import org.lsst.sal.SALImplementation;
import org.xml.sax.SAXException;

/**
 *
 * @author Farrukh Azfar
 */
public class JavaMainWriter {

    private final String salMainJava;
    private final String basePackageName;
    private final String outputPath;
    private final String salFileName;
    private final String commandParent;
    private final String eventParent;
    private final String telemetryParent;
    
    public JavaMainWriter(String salMainJava, String basePackageName, String outputPath, String commandParent, String eventParent, String telemetryParent, String salFileName) throws ParserConfigurationException, SAXException, IOException {
        this.basePackageName = basePackageName;
        this.outputPath = outputPath;
        this.salFileName = salFileName;
        this.salMainJava = salMainJava;
        this.commandParent = commandParent;
        this.telemetryParent = telemetryParent;
        this.eventParent = eventParent;

        //ok now we have to use JavaPoet to write the program salMainJava to outputPath - 
        MethodSpec privateConstructor = MethodSpec.constructorBuilder()
                .addModifiers(Modifier.PRIVATE)
                .addStatement("super(" + salMainJava + ".class," + "\"" + salFileName + "\"" + ")").build();

        ClassName javaclassname = ClassName.get(basePackageName, salMainJava);
        MethodSpec createMethod = MethodSpec.methodBuilder("create")
                .addModifiers(Modifier.PUBLIC, Modifier.STATIC)
                .addStatement("return new " + salMainJava + "()")
                .returns(javaclassname)
                .build();

        MethodSpec mainMethod = MethodSpec.methodBuilder("main")
                .addModifiers(Modifier.PUBLIC, Modifier.STATIC)
                .returns(void.class)
                .addParameter(String[].class, "args")
                .addStatement(salMainJava + ".create()")
                .build();
        
        TypeSpec classDefinition = TypeSpec.classBuilder(salMainJava)
                .superclass(ParameterizedTypeName.get(ClassName.get(SALImplementation.class),
                        ClassName.get(basePackageName, commandParent),
                        ClassName.get(basePackageName, eventParent),
                        ClassName.get(basePackageName, telemetryParent)))
                .addModifiers(Modifier.PUBLIC)
                .addMethod(privateConstructor)
                .addMethod(createMethod)
                .addMethod(mainMethod)
                .build();

        JavaFile javaFile = JavaFile.builder(basePackageName, classDefinition)
                .skipJavaLangImports(true)
                .build();
        javaFile.writeTo(new File(outputPath));
    }

}
