package org.lsst.sal.ccheader.event;

import org.lsst.sal.SALEvent;

public class SoftwareVersionsEvent extends SALEvent {
  private final String salVersion;

  private final String xmlVersion;

  private final String openSpliceVersion;

  private final String cscVersion;

  private final String subsystemVersions;

  public SoftwareVersionsEvent(String salVersion, String xmlVersion, String openSpliceVersion,
      String cscVersion, String subsystemVersions) {
    this.salVersion = salVersion;
    this.xmlVersion = xmlVersion;
    this.openSpliceVersion = openSpliceVersion;
    this.cscVersion = cscVersion;
    this.subsystemVersions = subsystemVersions;
  }

  public String getSalVersion() {
    return salVersion;
  }

  public String getXmlVersion() {
    return xmlVersion;
  }

  public String getOpenSpliceVersion() {
    return openSpliceVersion;
  }

  public String getCscVersion() {
    return cscVersion;
  }

  public String getSubsystemVersions() {
    return subsystemVersions;
  }

  @Override
  public String toString() {
    return "SoftwareVersionsEvent{" + "salVersion=" + salVersion +", xmlVersion=" + xmlVersion +
        ", openSpliceVersion=" + openSpliceVersion +", cscVersion=" + cscVersion +
        ", subsystemVersions=" + subsystemVersions +"}";
  }
}
