package org.lsst.sal.ccheader.event;

import org.lsst.sal.SALEvent;

public class LogLevelEvent extends SALEvent {
  private final int level;

  private final String subsystem;

  public LogLevelEvent(int priority, int level, String subsystem) {
    super (priority);
    this.level = level;
    this.subsystem = subsystem;
  }

  public int getLevel() {
    return level;
  }

  public String getSubsystem() {
    return subsystem;
  }

  @Override
  public String toString() {
    return "LogLevelEvent{" + "level=" + level +", subsystem=" + subsystem +"}";
  }
}
