package org.lsst.sal.ccheader.event;

import org.lsst.sal.SALEvent;

public class SoftwareVersionsEvent extends SALEvent {
  private final String salVersion;

  private final String xmlVersion;

  private final String openSpliceVersion;

  private final String cscVersion;

  private final String subsystemVersions;

  public SoftwareVersionsEvent(int priority, String salVersion, String xmlVersion,
      String openSpliceVersion, String cscVersion, String subsystemVersions) {
    super (priority);
    this.salVersion = salVersion;
    this.xmlVersion = xmlVersion;
    this.openSpliceVersion = openSpliceVersion;
    this.cscVersion = cscVersion;
    this.subsystemVersions = subsystemVersions;
  }

  public String getSalVersion() {
    return salVersion;
  }

  public String getXmlVersion() {
    return xmlVersion;
  }

  public String getOpenSpliceVersion() {
    return openSpliceVersion;
  }

  public String getCscVersion() {
    return cscVersion;
  }

  public String getSubsystemVersions() {
    return subsystemVersions;
  }

  @Override
  public String toString() {
    return "SoftwareVersionsEvent{" + "salVersion=" + salVersion +", xmlVersion=" + xmlVersion +
        ", openSpliceVersion=" + openSpliceVersion +", cscVersion=" + cscVersion +
        ", subsystemVersions=" + subsystemVersions +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private String salVersion;

    private String xmlVersion;

    private String openSpliceVersion;

    private String cscVersion;

    private String subsystemVersions;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder salVersion(String salVersion) {
      this.salVersion = salVersion;
      return this;
    }

    public Builder xmlVersion(String xmlVersion) {
      this.xmlVersion = xmlVersion;
      return this;
    }

    public Builder openSpliceVersion(String openSpliceVersion) {
      this.openSpliceVersion = openSpliceVersion;
      return this;
    }

    public Builder cscVersion(String cscVersion) {
      this.cscVersion = cscVersion;
      return this;
    }

    public Builder subsystemVersions(String subsystemVersions) {
      this.subsystemVersions = subsystemVersions;
      return this;
    }

    public SoftwareVersionsEvent build() {
      return new SoftwareVersionsEvent(priority, salVersion, xmlVersion, openSpliceVersion, cscVersion, subsystemVersions);
    }
  }
}
