package org.lsst.sal.ccheader.event;

import org.lsst.sal.SALEvent;

public class ErrorCodeEvent extends SALEvent {
  private final int errorCode;

  private final String errorReport;

  private final String traceback;

  public ErrorCodeEvent(int priority, int errorCode, String errorReport, String traceback) {
    super (priority);
    this.errorCode = errorCode;
    this.errorReport = errorReport;
    this.traceback = traceback;
  }

  public int getErrorCode() {
    return errorCode;
  }

  public String getErrorReport() {
    return errorReport;
  }

  public String getTraceback() {
    return traceback;
  }

  @Override
  public String toString() {
    return "ErrorCodeEvent{" + "errorCode=" + errorCode +", errorReport=" + errorReport +
        ", traceback=" + traceback +"}";
  }
}
