package org.lsst.sal.ccheader.states;

import org.lsst.sal.SALEnum;
import org.lsst.sal.SALStateChangeEvent;

public class SummaryStateEvent extends SALStateChangeEvent {
  private final SummaryState substate;

  public SummaryStateEvent(int priority, SummaryState substate) {
    super (priority);
    this.substate = substate;
  }

  @Override
  public SummaryState getSubstate() {
    return substate;
  }

  @Override
  public String toString() {
    return "SummaryStateEvent{" + "substate=" + substate +"}";
  }

  public enum SummaryState implements SALEnum {
    DISABLED,

    ENABLED,

    FAULT,

    OFFLINE,

    STANDBY
  }
}
