package org.lsst.sal.ccheader.event;

import org.lsst.sal.SALEvent;

public class SettingsAppliedEvent extends SALEvent {
  private final String settingsVersion;

  private final String otherSettingsEvents;

  public SettingsAppliedEvent(int priority, String settingsVersion, String otherSettingsEvents) {
    super (priority);
    this.settingsVersion = settingsVersion;
    this.otherSettingsEvents = otherSettingsEvents;
  }

  public String getSettingsVersion() {
    return settingsVersion;
  }

  public String getOtherSettingsEvents() {
    return otherSettingsEvents;
  }

  @Override
  public String toString() {
    return "SettingsAppliedEvent{" + "settingsVersion=" + settingsVersion +
        ", otherSettingsEvents=" + otherSettingsEvents +"}";
  }
}
