/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.cccamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.telemetry.Daq_monitor_Reb_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_Sum_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebsAverageTemp6Telemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebpsTelemetry;
import org.lsst.sal.cccamera.CCCamera;
import org.lsst.sal.cccamera.telemetry.Bonn_shutter_DeviceTelemetry;
import org.lsst.sal.cccamera.telemetry.FcsTelemetry;
import org.lsst.sal.cccamera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.cccamera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.cccamera.telemetry.Pathfinder_refrig_Cold1Telemetry;
import org.lsst.sal.cccamera.telemetry.Pathfinder_refrig_Cold2Telemetry;
import org.lsst.sal.cccamera.telemetry.Pathfinder_refrig_Cryo1Telemetry;
import org.lsst.sal.cccamera.telemetry.Pathfinder_refrig_Cryo2Telemetry;
import org.lsst.sal.cccamera.telemetry.Pathfinder_refrig_Cryo3Telemetry;
import org.lsst.sal.cccamera.telemetry.Pathfinder_refrig_Cryo4Telemetry;
import org.lsst.sal.cccamera.telemetry.Pathfinder_refrig_Cryo5Telemetry;
import org.lsst.sal.cccamera.telemetry.Pathfinder_refrig_Cryo6Telemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_RebTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold1Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold2Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_IonPumpsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_RtdsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_TurboTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_VQMonitorTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = CCCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveFcsTelemetry() throws Exception {
        double linearencoder_LinearPosition = 0.16545891761779785;
        double steppermotor_MotorEncoder = 0.003666102886199951;
        double steppermotor_MotorTemperature = 0.9983981847763062;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new FcsTelemetry(linearencoder_LinearPosition, steppermotor_MotorEncoder, steppermotor_MotorTemperature));
        Assert.assertTrue((boolean)(item instanceof FcsTelemetry));
        FcsTelemetry item_ = (FcsTelemetry)item;
        Assert.assertEquals((double)linearencoder_LinearPosition, (double)item_.getLinearencoder_LinearPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)steppermotor_MotorEncoder, (double)item_.getSteppermotor_MotorEncoder(), (double)1.0E-6f);
        Assert.assertEquals((double)steppermotor_MotorTemperature, (double)item_.getSteppermotor_MotorTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveBonn_shutter_DeviceTelemetry() throws Exception {
        double bonn_V36 = 0.5480917096138;
        double bonn_V5 = 0.768664f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Bonn_shutter_DeviceTelemetry(bonn_V36, bonn_V5));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_DeviceTelemetry));
        Bonn_shutter_DeviceTelemetry item_ = (Bonn_shutter_DeviceTelemetry)item;
        Assert.assertEquals((double)bonn_V36, (double)item_.getBonn_V36(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5, (double)item_.getBonn_V5(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Reb_TrendingTelemetry() throws Exception {
        long[] driver_errors = TestHelper.generateLongArray((int)3, (int)354483233);
        long[] driver_received = TestHelper.generateLongArray((int)3, (int)-1277878635);
        long[] driver_rx0 = TestHelper.generateLongArray((int)3, (int)1190810361);
        long[] driver_rx1 = TestHelper.generateLongArray((int)3, (int)-1218495589);
        long[] driver_rx2 = TestHelper.generateLongArray((int)3, (int)-1115187842);
        long[] driver_rx3 = TestHelper.generateLongArray((int)3, (int)-2101551786);
        long[] firmware_cell_errors = TestHelper.generateLongArray((int)3, (int)1964550685);
        long[] firmware_last_rx = TestHelper.generateLongArray((int)3, (int)1391333742);
        long[] firmware_last_tx = TestHelper.generateLongArray((int)3, (int)1283293276);
        long[] firmware_link_down = TestHelper.generateLongArray((int)3, (int)536304122);
        long[] firmware_link_errors = TestHelper.generateLongArray((int)3, (int)-1419231456);
        long[] firmware_link_status = TestHelper.generateLongArray((int)3, (int)-474285130);
        long[] firmware_overflow_local0 = TestHelper.generateLongArray((int)3, (int)-1964182972);
        long[] firmware_overflow_local1 = TestHelper.generateLongArray((int)3, (int)1076093277);
        long[] firmware_overflow_local2 = TestHelper.generateLongArray((int)3, (int)1727251476);
        long[] firmware_overflow_local3 = TestHelper.generateLongArray((int)3, (int)-738551259);
        long[] firmware_overflow_remote0 = TestHelper.generateLongArray((int)3, (int)192755305);
        long[] firmware_overflow_remote1 = TestHelper.generateLongArray((int)3, (int)-1779536008);
        long[] firmware_overflow_remote2 = TestHelper.generateLongArray((int)3, (int)-1595627409);
        long[] firmware_overflow_remote3 = TestHelper.generateLongArray((int)3, (int)809799255);
        long[] firmware_rlink_data = TestHelper.generateLongArray((int)3, (int)-498134683);
        long[] firmware_rx_clock = TestHelper.generateLongArray((int)3, (int)1355406090);
        long[] firmware_rx_errors = TestHelper.generateLongArray((int)3, (int)2049770970);
        long[] firmware_rx_frames = TestHelper.generateLongArray((int)3, (int)-1792816622);
        long[] firmware_rx_op = TestHelper.generateLongArray((int)3, (int)-1871762392);
        long[] firmware_tx_clock = TestHelper.generateLongArray((int)3, (int)1504614260);
        long[] firmware_tx_errors = TestHelper.generateLongArray((int)3, (int)-249362873);
        long[] firmware_tx_frames = TestHelper.generateLongArray((int)3, (int)-1838744113);
        long[] firmware_tx_op = TestHelper.generateLongArray((int)3, (int)-368068051);
        String location = "";
        long[] rds_bdi_firsts = TestHelper.generateLongArray((int)3, (int)1931745097);
        long[] rds_bdi_frees = TestHelper.generateLongArray((int)3, (int)1999301497);
        long[] rds_bdi_lasts = TestHelper.generateLongArray((int)3, (int)-2114334995);
        long[] rds_bdi_nulls = TestHelper.generateLongArray((int)3, (int)856811190);
        long[] rds_bdi_overflows = TestHelper.generateLongArray((int)3, (int)-152600929);
        long[] rds_bdi_seq_errors = TestHelper.generateLongArray((int)3, (int)149987700);
        long[] rds_bdi_waits = TestHelper.generateLongArray((int)3, (int)1991906968);
        long[] rds_discards = TestHelper.generateLongArray((int)3, (int)-654768106);
        long[] rds_no_event = TestHelper.generateLongArray((int)3, (int)-1232264175);
        long[] rds_wakes = TestHelper.generateLongArray((int)3, (int)-324148768);
        long[] rms_in_reset = TestHelper.generateLongArray((int)3, (int)370402818);
        long[] rms_inv_tids = TestHelper.generateLongArray((int)3, (int)-1528170775);
        long[] rms_link_down = TestHelper.generateLongArray((int)3, (int)1139713151);
        long[] rms_lists_posted = TestHelper.generateLongArray((int)3, (int)317078046);
        long[] rms_ops_posted = TestHelper.generateLongArray((int)3, (int)-1803495973);
        long[] rms_orphans = TestHelper.generateLongArray((int)3, (int)-1050610451);
        long[] rms_probes = TestHelper.generateLongArray((int)3, (int)-1954151882);
        long[] rms_responses = TestHelper.generateLongArray((int)3, (int)-1681944942);
        long[] rms_rundowns = TestHelper.generateLongArray((int)3, (int)1882348835);
        long[] rms_tid_hwm = TestHelper.generateLongArray((int)3, (int)-663871714);
        long[] rms_unopened = TestHelper.generateLongArray((int)3, (int)-73496955);
        long[] rms_waits = TestHelper.generateLongArray((int)3, (int)-1108533590);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Reb_TrendingTelemetry(driver_errors, driver_received, driver_rx0, driver_rx1, driver_rx2, driver_rx3, firmware_cell_errors, firmware_last_rx, firmware_last_tx, firmware_link_down, firmware_link_errors, firmware_link_status, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_local3, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_overflow_remote3, firmware_rlink_data, firmware_rx_clock, firmware_rx_errors, firmware_rx_frames, firmware_rx_op, firmware_tx_clock, firmware_tx_errors, firmware_tx_frames, firmware_tx_op, location, rds_bdi_firsts, rds_bdi_frees, rds_bdi_lasts, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_bdi_waits, rds_discards, rds_no_event, rds_wakes, rms_in_reset, rms_inv_tids, rms_link_down, rms_lists_posted, rms_ops_posted, rms_orphans, rms_probes, rms_responses, rms_rundowns, rms_tid_hwm, rms_unopened, rms_waits));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Reb_TrendingTelemetry));
        Daq_monitor_Reb_TrendingTelemetry item_ = (Daq_monitor_Reb_TrendingTelemetry)item;
        Assert.assertArrayEquals((long[])driver_errors, (long[])item_.getDriver_errors());
        Assert.assertArrayEquals((long[])driver_received, (long[])item_.getDriver_received());
        Assert.assertArrayEquals((long[])driver_rx0, (long[])item_.getDriver_rx0());
        Assert.assertArrayEquals((long[])driver_rx1, (long[])item_.getDriver_rx1());
        Assert.assertArrayEquals((long[])driver_rx2, (long[])item_.getDriver_rx2());
        Assert.assertArrayEquals((long[])driver_rx3, (long[])item_.getDriver_rx3());
        Assert.assertArrayEquals((long[])firmware_cell_errors, (long[])item_.getFirmware_cell_errors());
        Assert.assertArrayEquals((long[])firmware_last_rx, (long[])item_.getFirmware_last_rx());
        Assert.assertArrayEquals((long[])firmware_last_tx, (long[])item_.getFirmware_last_tx());
        Assert.assertArrayEquals((long[])firmware_link_down, (long[])item_.getFirmware_link_down());
        Assert.assertArrayEquals((long[])firmware_link_errors, (long[])item_.getFirmware_link_errors());
        Assert.assertArrayEquals((long[])firmware_link_status, (long[])item_.getFirmware_link_status());
        Assert.assertArrayEquals((long[])firmware_overflow_local0, (long[])item_.getFirmware_overflow_local0());
        Assert.assertArrayEquals((long[])firmware_overflow_local1, (long[])item_.getFirmware_overflow_local1());
        Assert.assertArrayEquals((long[])firmware_overflow_local2, (long[])item_.getFirmware_overflow_local2());
        Assert.assertArrayEquals((long[])firmware_overflow_local3, (long[])item_.getFirmware_overflow_local3());
        Assert.assertArrayEquals((long[])firmware_overflow_remote0, (long[])item_.getFirmware_overflow_remote0());
        Assert.assertArrayEquals((long[])firmware_overflow_remote1, (long[])item_.getFirmware_overflow_remote1());
        Assert.assertArrayEquals((long[])firmware_overflow_remote2, (long[])item_.getFirmware_overflow_remote2());
        Assert.assertArrayEquals((long[])firmware_overflow_remote3, (long[])item_.getFirmware_overflow_remote3());
        Assert.assertArrayEquals((long[])firmware_rlink_data, (long[])item_.getFirmware_rlink_data());
        Assert.assertArrayEquals((long[])firmware_rx_clock, (long[])item_.getFirmware_rx_clock());
        Assert.assertArrayEquals((long[])firmware_rx_errors, (long[])item_.getFirmware_rx_errors());
        Assert.assertArrayEquals((long[])firmware_rx_frames, (long[])item_.getFirmware_rx_frames());
        Assert.assertArrayEquals((long[])firmware_rx_op, (long[])item_.getFirmware_rx_op());
        Assert.assertArrayEquals((long[])firmware_tx_clock, (long[])item_.getFirmware_tx_clock());
        Assert.assertArrayEquals((long[])firmware_tx_errors, (long[])item_.getFirmware_tx_errors());
        Assert.assertArrayEquals((long[])firmware_tx_frames, (long[])item_.getFirmware_tx_frames());
        Assert.assertArrayEquals((long[])firmware_tx_op, (long[])item_.getFirmware_tx_op());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])rds_bdi_firsts, (long[])item_.getRds_bdi_firsts());
        Assert.assertArrayEquals((long[])rds_bdi_frees, (long[])item_.getRds_bdi_frees());
        Assert.assertArrayEquals((long[])rds_bdi_lasts, (long[])item_.getRds_bdi_lasts());
        Assert.assertArrayEquals((long[])rds_bdi_nulls, (long[])item_.getRds_bdi_nulls());
        Assert.assertArrayEquals((long[])rds_bdi_overflows, (long[])item_.getRds_bdi_overflows());
        Assert.assertArrayEquals((long[])rds_bdi_seq_errors, (long[])item_.getRds_bdi_seq_errors());
        Assert.assertArrayEquals((long[])rds_bdi_waits, (long[])item_.getRds_bdi_waits());
        Assert.assertArrayEquals((long[])rds_discards, (long[])item_.getRds_discards());
        Assert.assertArrayEquals((long[])rds_no_event, (long[])item_.getRds_no_event());
        Assert.assertArrayEquals((long[])rds_wakes, (long[])item_.getRds_wakes());
        Assert.assertArrayEquals((long[])rms_in_reset, (long[])item_.getRms_in_reset());
        Assert.assertArrayEquals((long[])rms_inv_tids, (long[])item_.getRms_inv_tids());
        Assert.assertArrayEquals((long[])rms_link_down, (long[])item_.getRms_link_down());
        Assert.assertArrayEquals((long[])rms_lists_posted, (long[])item_.getRms_lists_posted());
        Assert.assertArrayEquals((long[])rms_ops_posted, (long[])item_.getRms_ops_posted());
        Assert.assertArrayEquals((long[])rms_orphans, (long[])item_.getRms_orphans());
        Assert.assertArrayEquals((long[])rms_probes, (long[])item_.getRms_probes());
        Assert.assertArrayEquals((long[])rms_responses, (long[])item_.getRms_responses());
        Assert.assertArrayEquals((long[])rms_rundowns, (long[])item_.getRms_rundowns());
        Assert.assertArrayEquals((long[])rms_tid_hwm, (long[])item_.getRms_tid_hwm());
        Assert.assertArrayEquals((long[])rms_unopened, (long[])item_.getRms_unopened());
        Assert.assertArrayEquals((long[])rms_waits, (long[])item_.getRms_waits());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.07980525493621826;
        double freeFraction = 0.28811997175216675;
        double freeSpace = 0.8270516395568848;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeFraction, freeSpace));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Sum_TrendingTelemetry() throws Exception {
        long driver_errors = 591L;
        long firmware_cell_errors = 632L;
        long firmware_link_down = 236L;
        long firmware_link_errors = 761L;
        long firmware_overflow_local0 = 45L;
        long firmware_overflow_local1 = 538L;
        long firmware_overflow_local2 = 27L;
        long firmware_overflow_remote0 = 332L;
        long firmware_overflow_remote1 = 141L;
        long firmware_overflow_remote2 = 15L;
        long firmware_rx_errors = 457L;
        long firmware_tx_errors = 631L;
        long rds_bdi_nulls = 90L;
        long rds_bdi_overflows = 242L;
        long rds_bdi_seq_errors = 909L;
        long rds_discards = 777L;
        long rds_no_event = 253L;
        long rms_in_reset = 955L;
        long rms_inv_tids = 963L;
        long rms_link_down = 704L;
        long rms_orphans = 943L;
        long rms_unopened = 583L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Sum_TrendingTelemetry(driver_errors, firmware_cell_errors, firmware_link_down, firmware_link_errors, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_rx_errors, firmware_tx_errors, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_discards, rds_no_event, rms_in_reset, rms_inv_tids, rms_link_down, rms_orphans, rms_unopened));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Sum_TrendingTelemetry));
        Daq_monitor_Sum_TrendingTelemetry item_ = (Daq_monitor_Sum_TrendingTelemetry)item;
        Assert.assertEquals((long)driver_errors, (long)item_.getDriver_errors());
        Assert.assertEquals((long)firmware_cell_errors, (long)item_.getFirmware_cell_errors());
        Assert.assertEquals((long)firmware_link_down, (long)item_.getFirmware_link_down());
        Assert.assertEquals((long)firmware_link_errors, (long)item_.getFirmware_link_errors());
        Assert.assertEquals((long)firmware_overflow_local0, (long)item_.getFirmware_overflow_local0());
        Assert.assertEquals((long)firmware_overflow_local1, (long)item_.getFirmware_overflow_local1());
        Assert.assertEquals((long)firmware_overflow_local2, (long)item_.getFirmware_overflow_local2());
        Assert.assertEquals((long)firmware_overflow_remote0, (long)item_.getFirmware_overflow_remote0());
        Assert.assertEquals((long)firmware_overflow_remote1, (long)item_.getFirmware_overflow_remote1());
        Assert.assertEquals((long)firmware_overflow_remote2, (long)item_.getFirmware_overflow_remote2());
        Assert.assertEquals((long)firmware_rx_errors, (long)item_.getFirmware_rx_errors());
        Assert.assertEquals((long)firmware_tx_errors, (long)item_.getFirmware_tx_errors());
        Assert.assertEquals((long)rds_bdi_nulls, (long)item_.getRds_bdi_nulls());
        Assert.assertEquals((long)rds_bdi_overflows, (long)item_.getRds_bdi_overflows());
        Assert.assertEquals((long)rds_bdi_seq_errors, (long)item_.getRds_bdi_seq_errors());
        Assert.assertEquals((long)rds_discards, (long)item_.getRds_discards());
        Assert.assertEquals((long)rds_no_event, (long)item_.getRds_no_event());
        Assert.assertEquals((long)rms_in_reset, (long)item_.getRms_in_reset());
        Assert.assertEquals((long)rms_inv_tids, (long)item_.getRms_inv_tids());
        Assert.assertEquals((long)rms_link_down, (long)item_.getRms_link_down());
        Assert.assertEquals((long)rms_orphans, (long)item_.getRms_orphans());
        Assert.assertEquals((long)rms_unopened, (long)item_.getRms_unopened());
    }

    @Test
    public void sendReceiveRebpower_RebTelemetry() throws Exception {
        double[] analog_IaftLDO = TestHelper.generateDoubleArray((int)6, (int)-976083771);
        double[] analog_IbefLDO = TestHelper.generateDoubleArray((int)6, (int)1334400560);
        double[] analog_VaftLDO = TestHelper.generateDoubleArray((int)6, (int)689235961);
        double[] analog_VaftSwch = TestHelper.generateDoubleArray((int)6, (int)-293475147);
        double[] analog_VbefLDO = TestHelper.generateDoubleArray((int)6, (int)2015297013);
        double[] clockhi_IaftLDO = TestHelper.generateDoubleArray((int)6, (int)-1571562072);
        double[] clockhi_IbefLDO = TestHelper.generateDoubleArray((int)6, (int)1209003913);
        double[] clockhi_VaftLDO = TestHelper.generateDoubleArray((int)6, (int)78272488);
        double[] clockhi_VaftSwch = TestHelper.generateDoubleArray((int)6, (int)-1832221866);
        double[] clockhi_VbefLDO = TestHelper.generateDoubleArray((int)6, (int)-111213096);
        double[] clocklo_IaftLDO = TestHelper.generateDoubleArray((int)6, (int)-1204460456);
        double[] clocklo_IbefLDO = TestHelper.generateDoubleArray((int)6, (int)-385429765);
        double[] clocklo_VaftLDO = TestHelper.generateDoubleArray((int)6, (int)-579014703);
        double[] clocklo_VaftLDO2 = TestHelper.generateDoubleArray((int)6, (int)1992917990);
        double[] clocklo_VaftSwch = TestHelper.generateDoubleArray((int)6, (int)-558369789);
        double[] clocklo_VbefLDO = TestHelper.generateDoubleArray((int)6, (int)-1241864771);
        double[] digital_IaftLDO = TestHelper.generateDoubleArray((int)6, (int)-941028522);
        double[] digital_IbefLDO = TestHelper.generateDoubleArray((int)6, (int)1826246614);
        double[] digital_VaftLDO = TestHelper.generateDoubleArray((int)6, (int)-1887925287);
        double[] digital_VaftSwch = TestHelper.generateDoubleArray((int)6, (int)2097234236);
        double[] digital_VbefLDO = TestHelper.generateDoubleArray((int)6, (int)-1773221564);
        double[] heater_IaftLDO = TestHelper.generateDoubleArray((int)6, (int)1746660639);
        double[] heater_IbefLDO = TestHelper.generateDoubleArray((int)6, (int)508114915);
        double[] heater_VaftLDO = TestHelper.generateDoubleArray((int)6, (int)-1003182981);
        double[] heater_VaftSwch = TestHelper.generateDoubleArray((int)6, (int)-2078349042);
        double[] heater_VbefLDO = TestHelper.generateDoubleArray((int)6, (int)1082861691);
        double[] hvbias_IbefSwch = TestHelper.generateDoubleArray((int)6, (int)-2049937884);
        double[] hvbias_VbefSwch = TestHelper.generateDoubleArray((int)6, (int)-1520200606);
        String location = "d";
        double[] od_IaftLDO = TestHelper.generateDoubleArray((int)6, (int)-515945951);
        double[] od_IbefLDO = TestHelper.generateDoubleArray((int)6, (int)-1345222923);
        double[] od_VaftLDO = TestHelper.generateDoubleArray((int)6, (int)-6587412);
        double[] od_VaftLDO2 = TestHelper.generateDoubleArray((int)6, (int)161456746);
        double[] od_VaftSwch = TestHelper.generateDoubleArray((int)6, (int)-1204716381);
        double[] od_VbefLDO = TestHelper.generateDoubleArray((int)6, (int)1755959752);
        double[] power = TestHelper.generateDoubleArray((int)6, (int)1188937603);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTelemetry(analog_IaftLDO, analog_IbefLDO, analog_VaftLDO, analog_VaftSwch, analog_VbefLDO, clockhi_IaftLDO, clockhi_IbefLDO, clockhi_VaftLDO, clockhi_VaftSwch, clockhi_VbefLDO, clocklo_IaftLDO, clocklo_IbefLDO, clocklo_VaftLDO, clocklo_VaftLDO2, clocklo_VaftSwch, clocklo_VbefLDO, digital_IaftLDO, digital_IbefLDO, digital_VaftLDO, digital_VaftSwch, digital_VbefLDO, heater_IaftLDO, heater_IbefLDO, heater_VaftLDO, heater_VaftSwch, heater_VbefLDO, hvbias_IbefSwch, hvbias_VbefSwch, location, od_IaftLDO, od_IbefLDO, od_VaftLDO, od_VaftLDO2, od_VaftSwch, od_VbefLDO, power));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTelemetry));
        Rebpower_RebTelemetry item_ = (Rebpower_RebTelemetry)item;
        Assert.assertArrayEquals((double[])analog_IaftLDO, (double[])item_.getAnalog_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO, (double[])item_.getAnalog_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO, (double[])item_.getAnalog_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch, (double[])item_.getAnalog_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO, (double[])item_.getAnalog_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO, (double[])item_.getClockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO, (double[])item_.getClockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO, (double[])item_.getClockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch, (double[])item_.getClockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO, (double[])item_.getClockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO, (double[])item_.getClocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO, (double[])item_.getClocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO, (double[])item_.getClocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2, (double[])item_.getClocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch, (double[])item_.getClocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO, (double[])item_.getClocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO, (double[])item_.getDigital_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO, (double[])item_.getDigital_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO, (double[])item_.getDigital_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch, (double[])item_.getDigital_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO, (double[])item_.getDigital_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO, (double[])item_.getHeater_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO, (double[])item_.getHeater_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO, (double[])item_.getHeater_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch, (double[])item_.getHeater_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO, (double[])item_.getHeater_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch, (double[])item_.getHvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch, (double[])item_.getHvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO, (double[])item_.getOd_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO, (double[])item_.getOd_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO, (double[])item_.getOd_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2, (double[])item_.getOd_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch, (double[])item_.getOd_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO, (double[])item_.getOd_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.666645884513855;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTotalPowerTelemetry));
        Rebpower_RebTotalPowerTelemetry item_ = (Rebpower_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebpsTelemetry() throws Exception {
        double[] boardTemp0 = TestHelper.generateDoubleArray((int)1, (int)1949692858);
        double[] boardTemp1 = TestHelper.generateDoubleArray((int)1, (int)2027080626);
        double[] boardTemp2 = TestHelper.generateDoubleArray((int)1, (int)361371395);
        double[] boardTemp3 = TestHelper.generateDoubleArray((int)1, (int)-224271078);
        double[] boardTemp4 = TestHelper.generateDoubleArray((int)1, (int)-1578402043);
        double[] boardTemp5 = TestHelper.generateDoubleArray((int)1, (int)-2006657599);
        double[] boardTemp6 = TestHelper.generateDoubleArray((int)1, (int)1000951443);
        double[] fPGATemp = TestHelper.generateDoubleArray((int)1, (int)2082422712);
        String location = "m";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebpsTelemetry(boardTemp0, boardTemp1, boardTemp2, boardTemp3, boardTemp4, boardTemp5, boardTemp6, fPGATemp, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebpsTelemetry));
        Rebpower_RebpsTelemetry item_ = (Rebpower_RebpsTelemetry)item;
        Assert.assertArrayEquals((double[])boardTemp0, (double[])item_.getBoardTemp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp1, (double[])item_.getBoardTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp2, (double[])item_.getBoardTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp3, (double[])item_.getBoardTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp4, (double[])item_.getBoardTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp5, (double[])item_.getBoardTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp6, (double[])item_.getBoardTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fPGATemp, (double[])item_.getFPGATemp(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_Cold1Telemetry() throws Exception {
        double autoOffEnabled = 0.1976214051246643;
        double autoOffTemperature = 0.2756111f;
        double autoOnTemperature = 0.3378385901451111;
        double power = 0.859836220741272;
        double rejectTemperature = 0.28822004795074463;
        double setPower = 0.9087362885475159;
        double setpoint = 0.640973f;
        double temperature = 0.20784467458724976;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Cold1Telemetry(autoOffEnabled, autoOffTemperature, autoOnTemperature, power, rejectTemperature, setPower, setpoint, temperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold1Telemetry));
        Vacuum_Cold1Telemetry item_ = (Vacuum_Cold1Telemetry)item;
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold2Telemetry() throws Exception {
        double autoOffEnabled = 0.014158666133880615;
        double autoOffTemperature = 0.8944817185401917;
        double autoOnTemperature = 0.17212438583374023;
        double power = 0.9838724136352539;
        double rejectTemperature = 0.890504777431488;
        double setPower = 0.11074632406234741;
        double setpoint = 0.6021215319633484;
        double temperature = 0.44235873222351074;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Cold2Telemetry(autoOffEnabled, autoOffTemperature, autoOnTemperature, power, rejectTemperature, setPower, setpoint, temperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold2Telemetry));
        Vacuum_Cold2Telemetry item_ = (Vacuum_Cold2Telemetry)item;
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoTelemetry() throws Exception {
        double autoOffEnabled = 0.5397210717201233;
        double autoOffTemperature = 0.6926897168159485;
        double autoOnTemperature = 0.10200345516204834;
        double power = 0.366751492023468;
        double rejectTemperature = 0.7805096507072449;
        double setPower = 0.8747261762619019;
        double setpoint = 0.9472829103469849;
        double temperature = 0.8885076642036438;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoTelemetry(autoOffEnabled, autoOffTemperature, autoOnTemperature, power, rejectTemperature, setPower, setpoint, temperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTelemetry));
        Vacuum_CryoTelemetry item_ = (Vacuum_CryoTelemetry)item;
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_IonPumpsTelemetry() throws Exception {
        double current = 0.556930422782898;
        double voltage = 0.5792065262794495;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_IonPumpsTelemetry(current, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumpsTelemetry));
        Vacuum_IonPumpsTelemetry item_ = (Vacuum_IonPumpsTelemetry)item;
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_RtdsTelemetry() throws Exception {
        double temperatureCold1 = 0.2961454391479492;
        double temperatureCold2 = 0.19636154174804688;
        double temperatureCryo = 0.0023627877235412598;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_RtdsTelemetry(temperatureCold1, temperatureCold2, temperatureCryo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_RtdsTelemetry));
        Vacuum_RtdsTelemetry item_ = (Vacuum_RtdsTelemetry)item;
        Assert.assertEquals((double)temperatureCold1, (double)item_.getTemperatureCold1(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatureCold2, (double)item_.getTemperatureCold2(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatureCryo, (double)item_.getTemperatureCryo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboTelemetry() throws Exception {
        double cntrlrAirTemperature = 0.28500616550445557;
        double cntrlrSinkTemperature = 0.6686477661132812;
        double current = 0.6660289168357849;
        double driveFrequency = 0.7577430605888367;
        double power = 0.578338623046875;
        double pumpTemperature = 0.9150266051292419;
        double rpm = 0.0884554386138916;
        double status = 0.36490005254745483;
        double voltage = 0.04228156805038452;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboTelemetry(cntrlrAirTemperature, cntrlrSinkTemperature, current, driveFrequency, power, pumpTemperature, rpm, status, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboTelemetry));
        Vacuum_TurboTelemetry item_ = (Vacuum_TurboTelemetry)item;
        Assert.assertEquals((double)cntrlrAirTemperature, (double)item_.getCntrlrAirTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrSinkTemperature, (double)item_.getCntrlrSinkTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)driveFrequency, (double)item_.getDriveFrequency(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpTemperature, (double)item_.getPumpTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)rpm, (double)item_.getRpm(), (double)1.0E-6f);
        Assert.assertEquals((double)status, (double)item_.getStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_VQMonitorTelemetry() throws Exception {
        double vqmpressure = 0.6637503504753113;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_VQMonitorTelemetry(vqmpressure));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VQMonitorTelemetry));
        Vacuum_VQMonitorTelemetry item_ = (Vacuum_VQMonitorTelemetry)item;
        Assert.assertEquals((double)vqmpressure, (double)item_.getVqmpressure(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double clean_5_24V_I = 0.036338627338409424;
        double dirty_24V_I = 0.26751482486724854;
        double dirty_28V_I = 0.8637517094612122;
        double dirty_48V_I = 0.9317817687988281;
        double heater_I = 0.1997787356376648;
        double protection_I = 0.6986638903617859;
        double rebps_0 = 0.8881232738494873;
        double sensor_PWS_17_I = 0.8241537809371948;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(clean_5_24V_I, dirty_24V_I, dirty_28V_I, dirty_48V_I, heater_I, protection_I, rebps_0, sensor_PWS_17_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I, (double)item_.getHeater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0, (double)item_.getRebps_0(), (double)1.0E-6f);
        Assert.assertEquals((double)sensor_PWS_17_I, (double)item_.getSensor_PWS_17_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double board_T = 0.1614902f;
        double body_Purge_I = 0.6801071166992188;
        double body_Purge_V = 0.3216143250465393;
        double bpu_Maq20_I = 0.876488f;
        double bpu_Maq20_V = 0.4421016573905945;
        double fpga_T = 0.06011462211608887;
        double fes_Shu_HCU_I = 0.9373458623886108;
        double fes_Shu_HCU_V = 0.4472420811653137;
        double gauges_I = 0.3018820285797119;
        double gauges_V = 0.1699813f;
        double ion_Pumps_I = 0.37811917066574097;
        double ion_Pumps_V = 0.756597f;
        double j11_I = 0.2650805711746216;
        double j11_V = 0.3713676333427429;
        double j12_I = 0.9410897493362427;
        double j12_V = 0.3219779133796692;
        double j6_I = 0.3683926463127136;
        double j6_V = 0.7247708439826965;
        double j7_I = 0.3784014f;
        double j7_V = 0.04783368110656738;
        double j8_I = 0.9104452133178711;
        double j8_V = 0.8519304394721985;
        double j9_I = 0.6333589553833008;
        double j9_V = 0.49671435356140137;
        double main_I = 0.8823203444480896;
        double main_T = 0.050605833530426025;
        double main_V = 0.7618787884712219;
        double pwr_Cry_HCU_I = 0.5727295875549316;
        double pwr_Cry_HCU_V = 0.1308283805847168;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(board_T, body_Purge_I, body_Purge_V, bpu_Maq20_I, bpu_Maq20_V, fpga_T, fes_Shu_HCU_I, fes_Shu_HCU_V, gauges_I, gauges_V, ion_Pumps_I, ion_Pumps_V, j11_I, j11_V, j12_I, j12_V, j6_I, j6_V, j7_I, j7_V, j8_I, j8_V, j9_I, j9_V, main_I, main_T, main_V, pwr_Cry_HCU_I, pwr_Cry_HCU_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I, (double)item_.getBody_Purge_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V, (double)item_.getBody_Purge_V(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I, (double)item_.getBpu_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V, (double)item_.getBpu_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I, (double)item_.getFes_Shu_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V, (double)item_.getFes_Shu_HCU_V(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_I, (double)item_.getJ11_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_V, (double)item_.getJ11_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_I, (double)item_.getJ12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_V, (double)item_.getJ12_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_I, (double)item_.getJ6_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_V, (double)item_.getJ6_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_I, (double)item_.getJ7_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_V, (double)item_.getJ7_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j8_I, (double)item_.getJ8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j8_V, (double)item_.getJ8_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_I, (double)item_.getJ9_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_V, (double)item_.getJ9_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I, (double)item_.getPwr_Cry_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V, (double)item_.getPwr_Cry_HCU_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double board_T = 0.998331f;
        double fes_I = 0.3498866558074951;
        double fes_V = 0.17562341690063477;
        double fpga_T = 0.6904461979866028;
        double main_I = 0.2425074f;
        double main_T = 0.6432969570159912;
        double main_V = 0.28806257247924805;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(board_T, fes_I, fes_V, fpga_T, main_I, main_T, main_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_I, (double)item_.getFes_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_V, (double)item_.getFes_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double board_T = 0.11362528800964355;
        double cryotel0_I = 0.7981902956962585;
        double cryotel0_V = 0.05058586597442627;
        double cryotel1_I = 0.410033f;
        double cryotel1_V = 0.2327372431755066;
        double cryotel2_I = 0.8834550380706787;
        double cryotel2_V = 0.17927193641662598;
        double fpga_T = 0.4878249168395996;
        double main_I = 0.7535895705223083;
        double main_T = 0.3272079825401306;
        double main_V = 0.7254730463027954;
        double reb_BULK_I = 0.25193703174591064;
        double reb_BULK_V = 0.7666507363319397;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(board_T, cryotel0_I, cryotel0_V, cryotel1_I, cryotel1_V, cryotel2_I, cryotel2_V, fpga_T, main_I, main_T, main_V, reb_BULK_I, reb_BULK_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_I, (double)item_.getCryotel0_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_V, (double)item_.getCryotel0_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_I, (double)item_.getCryotel1_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_V, (double)item_.getCryotel1_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_I, (double)item_.getCryotel2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_V, (double)item_.getCryotel2_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_I, (double)item_.getReb_BULK_I(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_V, (double)item_.getReb_BULK_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_3_B_I = 0.8382720947265625;
        double otm_3_B_V = 0.2768780589103699;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_3_B_I, otm_3_B_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_3_B_I, (double)item_.getOtm_3_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V, (double)item_.getOtm_3_B_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_CcdTelemetry() throws Exception {
        double[] gDV = TestHelper.generateDoubleArray((int)9, (int)-1310209629);
        String location = "";
        double[] oDV = TestHelper.generateDoubleArray((int)9, (int)-555372936);
        double[] oGV = TestHelper.generateDoubleArray((int)9, (int)-348593073);
        double[] rDV = TestHelper.generateDoubleArray((int)9, (int)-776638059);
        double[] temp = TestHelper.generateDoubleArray((int)9, (int)-1225368746);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_CcdTelemetry(gDV, location, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_CcdTelemetry));
        Focal_plane_CcdTelemetry item_ = (Focal_plane_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTelemetry() throws Exception {
        double[] anaI = TestHelper.generateDoubleArray((int)3, (int)-1536475712);
        double[] anaV = TestHelper.generateDoubleArray((int)3, (int)-928405829);
        double[] aspicl_Temp0 = TestHelper.generateDoubleArray((int)3, (int)-1877650420);
        double[] aspicl_Temp1 = TestHelper.generateDoubleArray((int)3, (int)-1977397293);
        double[] aspicl_Temp2 = TestHelper.generateDoubleArray((int)3, (int)1012239788);
        double[] aspicu_Temp0 = TestHelper.generateDoubleArray((int)3, (int)-998335387);
        double[] aspicu_Temp1 = TestHelper.generateDoubleArray((int)3, (int)1225127123);
        double[] aspicu_Temp2 = TestHelper.generateDoubleArray((int)3, (int)948578615);
        double[] clkHI = TestHelper.generateDoubleArray((int)3, (int)212871749);
        double[] clkHV = TestHelper.generateDoubleArray((int)3, (int)1241821685);
        double[] clkLI = TestHelper.generateDoubleArray((int)3, (int)1876535676);
        double[] clkLV = TestHelper.generateDoubleArray((int)3, (int)344331837);
        double[] digI = TestHelper.generateDoubleArray((int)3, (int)-105819244);
        double[] digV = TestHelper.generateDoubleArray((int)3, (int)-2075073321);
        double[] hVBiasSwitch = TestHelper.generateDoubleArray((int)3, (int)650545503);
        double[] htrV = TestHelper.generateDoubleArray((int)3, (int)329298277);
        double[] htrW = TestHelper.generateDoubleArray((int)3, (int)10721092);
        String location = "";
        double[] oDI = TestHelper.generateDoubleArray((int)3, (int)-701048350);
        double[] oDV = TestHelper.generateDoubleArray((int)3, (int)1136996835);
        double[] pClkL = TestHelper.generateDoubleArray((int)3, (int)-711139194);
        double[] pClkU = TestHelper.generateDoubleArray((int)3, (int)-212904391);
        double[] power = TestHelper.generateDoubleArray((int)3, (int)1224571641);
        double[] rGL = TestHelper.generateDoubleArray((int)3, (int)1757493210);
        double[] rGU = TestHelper.generateDoubleArray((int)3, (int)45883956);
        double[] rTDTemp = TestHelper.generateDoubleArray((int)3, (int)1846169352);
        double[] ref05V = TestHelper.generateDoubleArray((int)3, (int)46536688);
        double[] ref125V = TestHelper.generateDoubleArray((int)3, (int)-2104907831);
        double[] ref15V = TestHelper.generateDoubleArray((int)3, (int)-678101191);
        double[] ref25V = TestHelper.generateDoubleArray((int)3, (int)-1925501521);
        double[] refN12 = TestHelper.generateDoubleArray((int)3, (int)491855976);
        double[] refP12 = TestHelper.generateDoubleArray((int)3, (int)-382908091);
        double[] sClkL = TestHelper.generateDoubleArray((int)3, (int)-1341975249);
        double[] sClkU = TestHelper.generateDoubleArray((int)3, (int)884019915);
        double[] temp1 = TestHelper.generateDoubleArray((int)3, (int)-477639266);
        double[] temp10 = TestHelper.generateDoubleArray((int)3, (int)600186088);
        double[] temp2 = TestHelper.generateDoubleArray((int)3, (int)555011401);
        double[] temp3 = TestHelper.generateDoubleArray((int)3, (int)2143800179);
        double[] temp4 = TestHelper.generateDoubleArray((int)3, (int)259307507);
        double[] temp5 = TestHelper.generateDoubleArray((int)3, (int)-279601783);
        double[] temp6 = TestHelper.generateDoubleArray((int)3, (int)-78129294);
        double[] temp7 = TestHelper.generateDoubleArray((int)3, (int)801806217);
        double[] temp8 = TestHelper.generateDoubleArray((int)3, (int)905035944);
        double[] temp9 = TestHelper.generateDoubleArray((int)3, (int)-796434259);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicl_Temp1, aspicl_Temp2, aspicu_Temp0, aspicu_Temp1, aspicu_Temp2, clkHI, clkHV, clkLI, clkLV, digI, digV, hVBiasSwitch, htrV, htrW, location, oDI, oDV, pClkL, pClkU, power, rGL, rGU, rTDTemp, ref05V, ref125V, ref15V, ref25V, refN12, refP12, sClkL, sClkU, temp1, temp10, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTelemetry));
        Focal_plane_RebTelemetry item_ = (Focal_plane_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1, (double[])item_.getAspicl_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2, (double[])item_.getAspicl_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1, (double[])item_.getAspicu_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2, (double[])item_.getAspicu_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLI, (double[])item_.getClkLI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05V, (double[])item_.getRef05V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125V, (double[])item_.getRef125V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15V, (double[])item_.getRef15V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25V, (double[])item_.getRef25V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refN12, (double[])item_.getRefN12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refP12, (double[])item_.getRefP12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10, (double[])item_.getTemp10(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7, (double[])item_.getTemp7(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8, (double[])item_.getTemp8(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9, (double[])item_.getTemp9(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.7258254885673523;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPowerTelemetry));
        Focal_plane_RebTotalPowerTelemetry item_ = (Focal_plane_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebsAverageTemp6Telemetry() throws Exception {
        double rebsAverageTemp6 = 0.791206419467926;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebsAverageTemp6Telemetry(rebsAverageTemp6));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebsAverageTemp6Telemetry));
        Focal_plane_RebsAverageTemp6Telemetry item_ = (Focal_plane_RebsAverageTemp6Telemetry)item;
        Assert.assertEquals((double)rebsAverageTemp6, (double)item_.getRebsAverageTemp6(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_SegmentTelemetry() throws Exception {
        double[] i = TestHelper.generateDoubleArray((int)144, (int)-1062972440);
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_SegmentTelemetry(i, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SegmentTelemetry));
        Focal_plane_SegmentTelemetry item_ = (Focal_plane_SegmentTelemetry)item;
        Assert.assertArrayEquals((double[])i, (double[])item_.getI(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceivePathfinder_refrig_Cold1Telemetry() throws Exception {
        double ambientTmp = 0.46290475130081177;
        double cabinetTmp = 0.01742708683013916;
        double compCurrent = 0.34737056493759155;
        double compPower = 0.7279629111289978;
        double compVfdCurr = 0.3086232542991638;
        double compVfdFreq = 0.8943129181861877;
        double compVfdTemp = 0.8320593237876892;
        double compVfdVolt = 0.9500392079353333;
        double compVoltage = 0.8717734217643738;
        double coolFlowRate = 0.9418385624885559;
        double coolValvePosn = 0.3426443934440613;
        double dischrgPrs = 0.8763936161994934;
        double dischrgtmp_M = 0.10976654291152954;
        double dischrgtmp_P = 0.31328171491622925;
        double eEPRValvePosn = 0.17146307229995728;
        double fan1Speed = 0.5648835897445679;
        double fan2Speed = 0.03226763f;
        double fan3Speed = 0.8929800391197205;
        double hGBValvePosn = 0.007169842720031738;
        double liquidSubCooling = 0.6722826361656189;
        double liquidtmp_M = 0.9735507965087891;
        double liquidtmp_P = 0.3938329815864563;
        double priOilSepTmp = 0.15796732902526855;
        double secOilSepTmp = 0.513742208480835;
        double suctionPrs = 0.13346683979034424;
        double suctiontmp_P = 0.5879005789756775;
        double waterInTmp = 0.4709498882293701;
        double waterOutTmp = 0.7932596206665039;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Pathfinder_refrig_Cold1Telemetry(ambientTmp, cabinetTmp, compCurrent, compPower, compVfdCurr, compVfdFreq, compVfdTemp, compVfdVolt, compVoltage, coolFlowRate, coolValvePosn, dischrgPrs, dischrgtmp_M, dischrgtmp_P, eEPRValvePosn, fan1Speed, fan2Speed, fan3Speed, hGBValvePosn, liquidSubCooling, liquidtmp_M, liquidtmp_P, priOilSepTmp, secOilSepTmp, suctionPrs, suctiontmp_P, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cold1Telemetry));
        Pathfinder_refrig_Cold1Telemetry item_ = (Pathfinder_refrig_Cold1Telemetry)item;
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdCurr, (double)item_.getCompVfdCurr(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdFreq, (double)item_.getCompVfdFreq(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdTemp, (double)item_.getCompVfdTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdVolt, (double)item_.getCompVfdVolt(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)coolFlowRate, (double)item_.getCoolFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)coolValvePosn, (double)item_.getCoolValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)eEPRValvePosn, (double)item_.getEEPRValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1Speed, (double)item_.getFan1Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2Speed, (double)item_.getFan2Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3Speed, (double)item_.getFan3Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)hGBValvePosn, (double)item_.getHGBValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidSubCooling, (double)item_.getLiquidSubCooling(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M, (double)item_.getLiquidtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P, (double)item_.getLiquidtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)priOilSepTmp, (double)item_.getPriOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)secOilSepTmp, (double)item_.getSecOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_Cold2Telemetry() throws Exception {
        double ambientTmp = 0.8530024886131287;
        double cabinetTmp = 0.4846211075782776;
        double compCurrent = 0.2812246084213257;
        double compPower = 0.2088964f;
        double compVfdCurr = 0.33946776390075684;
        double compVfdFreq = 0.9399528503417969;
        double compVfdTemp = 0.4634294f;
        double compVfdVolt = 0.43860727548599243;
        double compVoltage = 0.8752903938293457;
        double coolFlowRate = 0.3097681999206543;
        double coolValvePosn = 0.6414281129837036;
        double dischrgPrs = 0.5263808965682983;
        double dischrgtmp_M = 0.6607657074928284;
        double dischrgtmp_P = 0.1538516879081726;
        double eEPRValvePosn = 0.730922f;
        double fan1Speed = 0.09853965044021606;
        double fan2Speed = 0.4730631709098816;
        double fan3Speed = 0.03276348114013672;
        double hGBValvePosn = 0.1517086625099182;
        double liquidSubCooling = 0.5341876149177551;
        double liquidtmp_M = 0.03012669086456299;
        double liquidtmp_P = 0.3266274929046631;
        double priOilSepTmp = 0.4241926074028015;
        double secOilSepTmp = 0.5327516794204712;
        double suctionPrs = 0.9782283902168274;
        double suctiontmp_P = 0.02872532606124878;
        double waterInTmp = 0.1469811201095581;
        double waterOutTmp = 0.009285271167755127;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Pathfinder_refrig_Cold2Telemetry(ambientTmp, cabinetTmp, compCurrent, compPower, compVfdCurr, compVfdFreq, compVfdTemp, compVfdVolt, compVoltage, coolFlowRate, coolValvePosn, dischrgPrs, dischrgtmp_M, dischrgtmp_P, eEPRValvePosn, fan1Speed, fan2Speed, fan3Speed, hGBValvePosn, liquidSubCooling, liquidtmp_M, liquidtmp_P, priOilSepTmp, secOilSepTmp, suctionPrs, suctiontmp_P, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cold2Telemetry));
        Pathfinder_refrig_Cold2Telemetry item_ = (Pathfinder_refrig_Cold2Telemetry)item;
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdCurr, (double)item_.getCompVfdCurr(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdFreq, (double)item_.getCompVfdFreq(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdTemp, (double)item_.getCompVfdTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdVolt, (double)item_.getCompVfdVolt(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)coolFlowRate, (double)item_.getCoolFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)coolValvePosn, (double)item_.getCoolValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)eEPRValvePosn, (double)item_.getEEPRValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1Speed, (double)item_.getFan1Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2Speed, (double)item_.getFan2Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3Speed, (double)item_.getFan3Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)hGBValvePosn, (double)item_.getHGBValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidSubCooling, (double)item_.getLiquidSubCooling(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M, (double)item_.getLiquidtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P, (double)item_.getLiquidtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)priOilSepTmp, (double)item_.getPriOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)secOilSepTmp, (double)item_.getSecOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo1Telemetry() throws Exception {
        double afterCoolTmp = 0.5658922791481018;
        double compCurrent = 0.24188333749771118;
        double compPower = 0.9930896759033203;
        double compVoltage = 0.9017523527145386;
        double dischrgPrs = 0.5053524374961853;
        double dischrgtmp_M = 0.8244085907936096;
        double dischrgtmp_P = 0.8311557173728943;
        double fanSpeed = 0.9940950870513916;
        double oilLevel = 0.07694637775421143;
        double oilSepTmp = 0.31527024507522583;
        double phaseSepTmp = 0.1104759f;
        double suctionPrs = 0.8978132009506226;
        double suctiontmp_M = 0.9137728214263916;
        double suctiontmp_P = 0.01397031545639038;
        double surgeTankTmp = 0.4956052899360657;
        double waterInTmp = 0.749509f;
        double waterOutTmp = 0.9661128520965576;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Pathfinder_refrig_Cryo1Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo1Telemetry));
        Pathfinder_refrig_Cryo1Telemetry item_ = (Pathfinder_refrig_Cryo1Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo2Telemetry() throws Exception {
        double afterCoolTmp = 0.32585716247558594;
        double ambientTmp = 0.4143051505088806;
        double cabinetTmp = 0.281935453414917;
        double compCurrent = 0.13068228960037231;
        double compPower = 0.21339058876037598;
        double compVoltage = 0.7240076065063477;
        double dischrgPrs = 0.7242322564125061;
        double dischrgtmp_M = 0.8225416541099548;
        double dischrgtmp_P = 0.6510754227638245;
        double fanSpeed = 0.4045470356941223;
        double oilLevel = 0.449058f;
        double oilSepTmp = 0.14185333251953125;
        double phaseSepTmp = 0.27757835388183594;
        double suctionPrs = 0.862157940864563;
        double suctiontmp_M = 0.5791764855384827;
        double suctiontmp_P = 0.15868091583251953;
        double surgeTankTmp = 0.21217858791351318;
        double waterInTmp = 0.6607599258422852;
        double waterOutTmp = 0.5157999396324158;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Pathfinder_refrig_Cryo2Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo2Telemetry));
        Pathfinder_refrig_Cryo2Telemetry item_ = (Pathfinder_refrig_Cryo2Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo3Telemetry() throws Exception {
        double afterCoolTmp = 0.5123403668403625;
        double ambientTmp = 0.07157433032989502;
        double cabinetTmp = 0.8760720491409302;
        double compCurrent = 0.880825936794281;
        double compPower = 0.9437201619148254;
        double compVoltage = 0.23266452550888062;
        double dischrgPrs = 0.6564675569534302;
        double dischrgtmp_M = 0.9533509612083435;
        double dischrgtmp_P = 0.38640785217285156;
        double fanSpeed = 0.06089651584625244;
        double oilLevel = 0.3476797342300415;
        double oilSepTmp = 0.8089441657066345;
        double phaseSepTmp = 0.812930703163147;
        double suctionPrs = 0.21386587619781494;
        double suctiontmp_M = 0.8380926251411438;
        double suctiontmp_P = 0.9726933836936951;
        double surgeTankTmp = 0.5340974926948547;
        double waterInTmp = 0.8659553527832031;
        double waterOutTmp = 0.7646315097808838;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Pathfinder_refrig_Cryo3Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo3Telemetry));
        Pathfinder_refrig_Cryo3Telemetry item_ = (Pathfinder_refrig_Cryo3Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo4Telemetry() throws Exception {
        double afterCoolTmp = 0.11168360710144043;
        double compCurrent = 0.09111642837524414;
        double compPower = 0.23992103338241577;
        double compVoltage = 0.3090554475784302;
        double dischrgPrs = 0.7101601958274841;
        double dischrgtmp_M = 0.16126281023025513;
        double dischrgtmp_P = 0.7116009593009949;
        double fanSpeed = 0.4492213f;
        double oilLevel = 0.5851067304611206;
        double oilSepTmp = 0.05842858552932739;
        double phaseSepTmp = 0.8385970592498779;
        double suctionPrs = 0.4137454628944397;
        double suctiontmp_M = 0.758403480052948;
        double suctiontmp_P = 0.8805614709854126;
        double surgeTankTmp = 0.3952442407608032;
        double waterInTmp = 0.4411519169807434;
        double waterOutTmp = 0.5543213486671448;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Pathfinder_refrig_Cryo4Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo4Telemetry));
        Pathfinder_refrig_Cryo4Telemetry item_ = (Pathfinder_refrig_Cryo4Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo5Telemetry() throws Exception {
        double afterCoolTmp = 0.20808666944503784;
        double compCurrent = 0.14494377374649048;
        double compPower = 0.7514247298240662;
        double compVoltage = 0.7411676049232483;
        double dischrgPrs = 0.45281195640563965;
        double dischrgtmp_M = 0.9956294894218445;
        double dischrgtmp_P = 0.3998481035232544;
        double fanSpeed = 0.1898796f;
        double oilLevel = 0.5980870723724365;
        double oilSepTmp = 0.04151439666748047;
        double phaseSepTmp = 0.6667261123657227;
        double suctionPrs = 0.43983322381973267;
        double suctiontmp_M = 0.6512831449508667;
        double suctiontmp_P = 0.04921752214431763;
        double surgeTankTmp = 0.12424784898757935;
        double waterInTmp = 0.005783796310424805;
        double waterOutTmp = 0.7827691435813904;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Pathfinder_refrig_Cryo5Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo5Telemetry));
        Pathfinder_refrig_Cryo5Telemetry item_ = (Pathfinder_refrig_Cryo5Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo6Telemetry() throws Exception {
        double afterCoolTmp = 0.2818986177444458;
        double compCurrent = 0.06125783920288086;
        double compPower = 0.44551634788513184;
        double compVoltage = 0.8759012222290039;
        double dischrgPrs = 0.3322707414627075;
        double dischrgtmp_M = 0.6014798283576965;
        double dischrgtmp_P = 0.5543889403343201;
        double fanSpeed = 0.22514891624450684;
        double oilLevel = 0.34356874227523804;
        double oilSepTmp = 0.4499297f;
        double phaseSepTmp = 0.432578980922699;
        double suctionPrs = 0.9500213265419006;
        double suctiontmp_M = 0.7041158676147461;
        double suctiontmp_P = 0.5905601978302002;
        double surgeTankTmp = 0.15868675708770752;
        double waterInTmp = 0.5372181534767151;
        double waterOutTmp = 0.9015504717826843;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Pathfinder_refrig_Cryo6Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo6Telemetry));
        Pathfinder_refrig_Cryo6Telemetry item_ = (Pathfinder_refrig_Cryo6Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }
}

