/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.cccamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.telemetry.Daq_monitor_Reb_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_Sum_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebsAverageTemp6Telemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebpsTelemetry;
import org.lsst.sal.cccamera.CCCamera;
import org.lsst.sal.cccamera.telemetry.Bonn_shutter_DeviceTelemetry;
import org.lsst.sal.cccamera.telemetry.FcsTelemetry;
import org.lsst.sal.cccamera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.cccamera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.cccamera.telemetry.Pathfinder_refrig_Cold1Telemetry;
import org.lsst.sal.cccamera.telemetry.Pathfinder_refrig_Cold2Telemetry;
import org.lsst.sal.cccamera.telemetry.Pathfinder_refrig_Cryo1Telemetry;
import org.lsst.sal.cccamera.telemetry.Pathfinder_refrig_Cryo2Telemetry;
import org.lsst.sal.cccamera.telemetry.Pathfinder_refrig_Cryo3Telemetry;
import org.lsst.sal.cccamera.telemetry.Pathfinder_refrig_Cryo4Telemetry;
import org.lsst.sal.cccamera.telemetry.Pathfinder_refrig_Cryo5Telemetry;
import org.lsst.sal.cccamera.telemetry.Pathfinder_refrig_Cryo6Telemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_RebTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold1Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold2Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_IonPumpsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_RtdsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_TurboTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_VQMonitorTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = CCCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveFcsTelemetry() throws Exception {
        double linearencoder_LinearPosition = 0.7422877550125122;
        double steppermotor_MotorEncoder = 0.045916974544525146;
        double steppermotor_MotorTemperature = 0.7550081610679626;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new FcsTelemetry(linearencoder_LinearPosition, steppermotor_MotorEncoder, steppermotor_MotorTemperature));
        Assert.assertTrue((boolean)(item instanceof FcsTelemetry));
        FcsTelemetry item_ = (FcsTelemetry)item;
        Assert.assertEquals((double)linearencoder_LinearPosition, (double)item_.getLinearencoder_LinearPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)steppermotor_MotorEncoder, (double)item_.getSteppermotor_MotorEncoder(), (double)1.0E-6f);
        Assert.assertEquals((double)steppermotor_MotorTemperature, (double)item_.getSteppermotor_MotorTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveBonn_shutter_DeviceTelemetry() throws Exception {
        double bonn_V36 = 0.27561044692993164;
        double bonn_V5 = 0.9586936831474304;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Bonn_shutter_DeviceTelemetry(bonn_V36, bonn_V5));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_DeviceTelemetry));
        Bonn_shutter_DeviceTelemetry item_ = (Bonn_shutter_DeviceTelemetry)item;
        Assert.assertEquals((double)bonn_V36, (double)item_.getBonn_V36(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5, (double)item_.getBonn_V5(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Reb_TrendingTelemetry() throws Exception {
        long[] driver_errors = TestHelper.generateLongArray((int)3, (int)-758848076);
        long[] driver_received = TestHelper.generateLongArray((int)3, (int)-585795211);
        long[] driver_rx0 = TestHelper.generateLongArray((int)3, (int)64981927);
        long[] driver_rx1 = TestHelper.generateLongArray((int)3, (int)-1543631484);
        long[] driver_rx2 = TestHelper.generateLongArray((int)3, (int)-1001337483);
        long[] driver_rx3 = TestHelper.generateLongArray((int)3, (int)-1341456887);
        long[] firmware_cell_errors = TestHelper.generateLongArray((int)3, (int)1501208754);
        long[] firmware_last_rx = TestHelper.generateLongArray((int)3, (int)42678250);
        long[] firmware_last_tx = TestHelper.generateLongArray((int)3, (int)-1329937215);
        long[] firmware_link_down = TestHelper.generateLongArray((int)3, (int)1242256475);
        long[] firmware_link_errors = TestHelper.generateLongArray((int)3, (int)1128941421);
        long[] firmware_link_status = TestHelper.generateLongArray((int)3, (int)1619796175);
        long[] firmware_overflow_local0 = TestHelper.generateLongArray((int)3, (int)-1408965899);
        long[] firmware_overflow_local1 = TestHelper.generateLongArray((int)3, (int)-995370049);
        long[] firmware_overflow_local2 = TestHelper.generateLongArray((int)3, (int)329719574);
        long[] firmware_overflow_local3 = TestHelper.generateLongArray((int)3, (int)1036764452);
        long[] firmware_overflow_remote0 = TestHelper.generateLongArray((int)3, (int)977292769);
        long[] firmware_overflow_remote1 = TestHelper.generateLongArray((int)3, (int)1985560532);
        long[] firmware_overflow_remote2 = TestHelper.generateLongArray((int)3, (int)-278962607);
        long[] firmware_overflow_remote3 = TestHelper.generateLongArray((int)3, (int)1991649579);
        long[] firmware_rlink_data = TestHelper.generateLongArray((int)3, (int)-1843699197);
        long[] firmware_rx_clock = TestHelper.generateLongArray((int)3, (int)686640801);
        long[] firmware_rx_errors = TestHelper.generateLongArray((int)3, (int)1259821184);
        long[] firmware_rx_frames = TestHelper.generateLongArray((int)3, (int)531273018);
        long[] firmware_rx_op = TestHelper.generateLongArray((int)3, (int)-567432713);
        long[] firmware_tx_clock = TestHelper.generateLongArray((int)3, (int)-565605126);
        long[] firmware_tx_errors = TestHelper.generateLongArray((int)3, (int)110920792);
        long[] firmware_tx_frames = TestHelper.generateLongArray((int)3, (int)665737918);
        long[] firmware_tx_op = TestHelper.generateLongArray((int)3, (int)935811374);
        String location = "";
        long[] rds_bdi_firsts = TestHelper.generateLongArray((int)3, (int)-95823951);
        long[] rds_bdi_frees = TestHelper.generateLongArray((int)3, (int)907568514);
        long[] rds_bdi_lasts = TestHelper.generateLongArray((int)3, (int)271662558);
        long[] rds_bdi_nulls = TestHelper.generateLongArray((int)3, (int)1680559048);
        long[] rds_bdi_overflows = TestHelper.generateLongArray((int)3, (int)-315257700);
        long[] rds_bdi_seq_errors = TestHelper.generateLongArray((int)3, (int)-1584521935);
        long[] rds_bdi_waits = TestHelper.generateLongArray((int)3, (int)-358261191);
        long[] rds_discards = TestHelper.generateLongArray((int)3, (int)-1529047309);
        long[] rds_no_event = TestHelper.generateLongArray((int)3, (int)365798330);
        long[] rds_wakes = TestHelper.generateLongArray((int)3, (int)-852600039);
        long[] rms_in_reset = TestHelper.generateLongArray((int)3, (int)689419488);
        long[] rms_inv_tids = TestHelper.generateLongArray((int)3, (int)913163167);
        long[] rms_link_down = TestHelper.generateLongArray((int)3, (int)722057163);
        long[] rms_lists_posted = TestHelper.generateLongArray((int)3, (int)-1555072975);
        long[] rms_ops_posted = TestHelper.generateLongArray((int)3, (int)1936310426);
        long[] rms_orphans = TestHelper.generateLongArray((int)3, (int)557086020);
        long[] rms_probes = TestHelper.generateLongArray((int)3, (int)799929989);
        long[] rms_responses = TestHelper.generateLongArray((int)3, (int)-2013153443);
        long[] rms_rundowns = TestHelper.generateLongArray((int)3, (int)320527168);
        long[] rms_tid_hwm = TestHelper.generateLongArray((int)3, (int)1937931202);
        long[] rms_unopened = TestHelper.generateLongArray((int)3, (int)478433958);
        long[] rms_waits = TestHelper.generateLongArray((int)3, (int)-1193832465);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Reb_TrendingTelemetry(driver_errors, driver_received, driver_rx0, driver_rx1, driver_rx2, driver_rx3, firmware_cell_errors, firmware_last_rx, firmware_last_tx, firmware_link_down, firmware_link_errors, firmware_link_status, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_local3, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_overflow_remote3, firmware_rlink_data, firmware_rx_clock, firmware_rx_errors, firmware_rx_frames, firmware_rx_op, firmware_tx_clock, firmware_tx_errors, firmware_tx_frames, firmware_tx_op, location, rds_bdi_firsts, rds_bdi_frees, rds_bdi_lasts, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_bdi_waits, rds_discards, rds_no_event, rds_wakes, rms_in_reset, rms_inv_tids, rms_link_down, rms_lists_posted, rms_ops_posted, rms_orphans, rms_probes, rms_responses, rms_rundowns, rms_tid_hwm, rms_unopened, rms_waits));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Reb_TrendingTelemetry));
        Daq_monitor_Reb_TrendingTelemetry item_ = (Daq_monitor_Reb_TrendingTelemetry)item;
        Assert.assertArrayEquals((long[])driver_errors, (long[])item_.getDriver_errors());
        Assert.assertArrayEquals((long[])driver_received, (long[])item_.getDriver_received());
        Assert.assertArrayEquals((long[])driver_rx0, (long[])item_.getDriver_rx0());
        Assert.assertArrayEquals((long[])driver_rx1, (long[])item_.getDriver_rx1());
        Assert.assertArrayEquals((long[])driver_rx2, (long[])item_.getDriver_rx2());
        Assert.assertArrayEquals((long[])driver_rx3, (long[])item_.getDriver_rx3());
        Assert.assertArrayEquals((long[])firmware_cell_errors, (long[])item_.getFirmware_cell_errors());
        Assert.assertArrayEquals((long[])firmware_last_rx, (long[])item_.getFirmware_last_rx());
        Assert.assertArrayEquals((long[])firmware_last_tx, (long[])item_.getFirmware_last_tx());
        Assert.assertArrayEquals((long[])firmware_link_down, (long[])item_.getFirmware_link_down());
        Assert.assertArrayEquals((long[])firmware_link_errors, (long[])item_.getFirmware_link_errors());
        Assert.assertArrayEquals((long[])firmware_link_status, (long[])item_.getFirmware_link_status());
        Assert.assertArrayEquals((long[])firmware_overflow_local0, (long[])item_.getFirmware_overflow_local0());
        Assert.assertArrayEquals((long[])firmware_overflow_local1, (long[])item_.getFirmware_overflow_local1());
        Assert.assertArrayEquals((long[])firmware_overflow_local2, (long[])item_.getFirmware_overflow_local2());
        Assert.assertArrayEquals((long[])firmware_overflow_local3, (long[])item_.getFirmware_overflow_local3());
        Assert.assertArrayEquals((long[])firmware_overflow_remote0, (long[])item_.getFirmware_overflow_remote0());
        Assert.assertArrayEquals((long[])firmware_overflow_remote1, (long[])item_.getFirmware_overflow_remote1());
        Assert.assertArrayEquals((long[])firmware_overflow_remote2, (long[])item_.getFirmware_overflow_remote2());
        Assert.assertArrayEquals((long[])firmware_overflow_remote3, (long[])item_.getFirmware_overflow_remote3());
        Assert.assertArrayEquals((long[])firmware_rlink_data, (long[])item_.getFirmware_rlink_data());
        Assert.assertArrayEquals((long[])firmware_rx_clock, (long[])item_.getFirmware_rx_clock());
        Assert.assertArrayEquals((long[])firmware_rx_errors, (long[])item_.getFirmware_rx_errors());
        Assert.assertArrayEquals((long[])firmware_rx_frames, (long[])item_.getFirmware_rx_frames());
        Assert.assertArrayEquals((long[])firmware_rx_op, (long[])item_.getFirmware_rx_op());
        Assert.assertArrayEquals((long[])firmware_tx_clock, (long[])item_.getFirmware_tx_clock());
        Assert.assertArrayEquals((long[])firmware_tx_errors, (long[])item_.getFirmware_tx_errors());
        Assert.assertArrayEquals((long[])firmware_tx_frames, (long[])item_.getFirmware_tx_frames());
        Assert.assertArrayEquals((long[])firmware_tx_op, (long[])item_.getFirmware_tx_op());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])rds_bdi_firsts, (long[])item_.getRds_bdi_firsts());
        Assert.assertArrayEquals((long[])rds_bdi_frees, (long[])item_.getRds_bdi_frees());
        Assert.assertArrayEquals((long[])rds_bdi_lasts, (long[])item_.getRds_bdi_lasts());
        Assert.assertArrayEquals((long[])rds_bdi_nulls, (long[])item_.getRds_bdi_nulls());
        Assert.assertArrayEquals((long[])rds_bdi_overflows, (long[])item_.getRds_bdi_overflows());
        Assert.assertArrayEquals((long[])rds_bdi_seq_errors, (long[])item_.getRds_bdi_seq_errors());
        Assert.assertArrayEquals((long[])rds_bdi_waits, (long[])item_.getRds_bdi_waits());
        Assert.assertArrayEquals((long[])rds_discards, (long[])item_.getRds_discards());
        Assert.assertArrayEquals((long[])rds_no_event, (long[])item_.getRds_no_event());
        Assert.assertArrayEquals((long[])rds_wakes, (long[])item_.getRds_wakes());
        Assert.assertArrayEquals((long[])rms_in_reset, (long[])item_.getRms_in_reset());
        Assert.assertArrayEquals((long[])rms_inv_tids, (long[])item_.getRms_inv_tids());
        Assert.assertArrayEquals((long[])rms_link_down, (long[])item_.getRms_link_down());
        Assert.assertArrayEquals((long[])rms_lists_posted, (long[])item_.getRms_lists_posted());
        Assert.assertArrayEquals((long[])rms_ops_posted, (long[])item_.getRms_ops_posted());
        Assert.assertArrayEquals((long[])rms_orphans, (long[])item_.getRms_orphans());
        Assert.assertArrayEquals((long[])rms_probes, (long[])item_.getRms_probes());
        Assert.assertArrayEquals((long[])rms_responses, (long[])item_.getRms_responses());
        Assert.assertArrayEquals((long[])rms_rundowns, (long[])item_.getRms_rundowns());
        Assert.assertArrayEquals((long[])rms_tid_hwm, (long[])item_.getRms_tid_hwm());
        Assert.assertArrayEquals((long[])rms_unopened, (long[])item_.getRms_unopened());
        Assert.assertArrayEquals((long[])rms_waits, (long[])item_.getRms_waits());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.8445212244987488;
        double freeFraction = 0.12191075086593628;
        double freeSpace = 0.30929964780807495;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeFraction, freeSpace));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Sum_TrendingTelemetry() throws Exception {
        long driver_errors = 952L;
        long firmware_cell_errors = 561L;
        long firmware_link_down = 572L;
        long firmware_link_errors = 258L;
        long firmware_overflow_local0 = 0L;
        long firmware_overflow_local1 = 790L;
        long firmware_overflow_local2 = 466L;
        long firmware_overflow_remote0 = 440L;
        long firmware_overflow_remote1 = 702L;
        long firmware_overflow_remote2 = 999L;
        long firmware_rx_errors = 753L;
        long firmware_tx_errors = 750L;
        long rds_bdi_nulls = 719L;
        long rds_bdi_overflows = 176L;
        long rds_bdi_seq_errors = 774L;
        long rds_discards = 289L;
        long rds_no_event = 965L;
        long rms_in_reset = 920L;
        long rms_inv_tids = 437L;
        long rms_link_down = 951L;
        long rms_orphans = 91L;
        long rms_unopened = 518L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Sum_TrendingTelemetry(driver_errors, firmware_cell_errors, firmware_link_down, firmware_link_errors, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_rx_errors, firmware_tx_errors, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_discards, rds_no_event, rms_in_reset, rms_inv_tids, rms_link_down, rms_orphans, rms_unopened));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Sum_TrendingTelemetry));
        Daq_monitor_Sum_TrendingTelemetry item_ = (Daq_monitor_Sum_TrendingTelemetry)item;
        Assert.assertEquals((long)driver_errors, (long)item_.getDriver_errors());
        Assert.assertEquals((long)firmware_cell_errors, (long)item_.getFirmware_cell_errors());
        Assert.assertEquals((long)firmware_link_down, (long)item_.getFirmware_link_down());
        Assert.assertEquals((long)firmware_link_errors, (long)item_.getFirmware_link_errors());
        Assert.assertEquals((long)firmware_overflow_local0, (long)item_.getFirmware_overflow_local0());
        Assert.assertEquals((long)firmware_overflow_local1, (long)item_.getFirmware_overflow_local1());
        Assert.assertEquals((long)firmware_overflow_local2, (long)item_.getFirmware_overflow_local2());
        Assert.assertEquals((long)firmware_overflow_remote0, (long)item_.getFirmware_overflow_remote0());
        Assert.assertEquals((long)firmware_overflow_remote1, (long)item_.getFirmware_overflow_remote1());
        Assert.assertEquals((long)firmware_overflow_remote2, (long)item_.getFirmware_overflow_remote2());
        Assert.assertEquals((long)firmware_rx_errors, (long)item_.getFirmware_rx_errors());
        Assert.assertEquals((long)firmware_tx_errors, (long)item_.getFirmware_tx_errors());
        Assert.assertEquals((long)rds_bdi_nulls, (long)item_.getRds_bdi_nulls());
        Assert.assertEquals((long)rds_bdi_overflows, (long)item_.getRds_bdi_overflows());
        Assert.assertEquals((long)rds_bdi_seq_errors, (long)item_.getRds_bdi_seq_errors());
        Assert.assertEquals((long)rds_discards, (long)item_.getRds_discards());
        Assert.assertEquals((long)rds_no_event, (long)item_.getRds_no_event());
        Assert.assertEquals((long)rms_in_reset, (long)item_.getRms_in_reset());
        Assert.assertEquals((long)rms_inv_tids, (long)item_.getRms_inv_tids());
        Assert.assertEquals((long)rms_link_down, (long)item_.getRms_link_down());
        Assert.assertEquals((long)rms_orphans, (long)item_.getRms_orphans());
        Assert.assertEquals((long)rms_unopened, (long)item_.getRms_unopened());
    }

    @Test
    public void sendReceiveRebpower_RebTelemetry() throws Exception {
        double[] analog_IaftLDO = TestHelper.generateDoubleArray((int)6, (int)738370138);
        double[] analog_IbefLDO = TestHelper.generateDoubleArray((int)6, (int)385493582);
        double[] analog_VaftLDO = TestHelper.generateDoubleArray((int)6, (int)-1269112854);
        double[] analog_VaftSwch = TestHelper.generateDoubleArray((int)6, (int)589418699);
        double[] analog_VbefLDO = TestHelper.generateDoubleArray((int)6, (int)201476298);
        double[] clockhi_IaftLDO = TestHelper.generateDoubleArray((int)6, (int)-784356181);
        double[] clockhi_IbefLDO = TestHelper.generateDoubleArray((int)6, (int)710640697);
        double[] clockhi_VaftLDO = TestHelper.generateDoubleArray((int)6, (int)15746044);
        double[] clockhi_VaftSwch = TestHelper.generateDoubleArray((int)6, (int)-6879595);
        double[] clockhi_VbefLDO = TestHelper.generateDoubleArray((int)6, (int)-1940931220);
        double[] clocklo_IaftLDO = TestHelper.generateDoubleArray((int)6, (int)-993580434);
        double[] clocklo_IbefLDO = TestHelper.generateDoubleArray((int)6, (int)354483233);
        double[] clocklo_VaftLDO = TestHelper.generateDoubleArray((int)6, (int)-1277878635);
        double[] clocklo_VaftLDO2 = TestHelper.generateDoubleArray((int)6, (int)1190810361);
        double[] clocklo_VaftSwch = TestHelper.generateDoubleArray((int)6, (int)-1218495589);
        double[] clocklo_VbefLDO = TestHelper.generateDoubleArray((int)6, (int)-1115187842);
        double[] digital_IaftLDO = TestHelper.generateDoubleArray((int)6, (int)-2101551786);
        double[] digital_IbefLDO = TestHelper.generateDoubleArray((int)6, (int)1964550685);
        double[] digital_VaftLDO = TestHelper.generateDoubleArray((int)6, (int)1391333742);
        double[] digital_VaftSwch = TestHelper.generateDoubleArray((int)6, (int)1283293276);
        double[] digital_VbefLDO = TestHelper.generateDoubleArray((int)6, (int)536304122);
        double[] heater_IaftLDO = TestHelper.generateDoubleArray((int)6, (int)-1419231456);
        double[] heater_IbefLDO = TestHelper.generateDoubleArray((int)6, (int)-474285130);
        double[] heater_VaftLDO = TestHelper.generateDoubleArray((int)6, (int)-1964182972);
        double[] heater_VaftSwch = TestHelper.generateDoubleArray((int)6, (int)1076093277);
        double[] heater_VbefLDO = TestHelper.generateDoubleArray((int)6, (int)1727251476);
        double[] hvbias_IbefSwch = TestHelper.generateDoubleArray((int)6, (int)-738551259);
        double[] hvbias_VbefSwch = TestHelper.generateDoubleArray((int)6, (int)192755305);
        String location = "l";
        double[] od_IaftLDO = TestHelper.generateDoubleArray((int)6, (int)809799255);
        double[] od_IbefLDO = TestHelper.generateDoubleArray((int)6, (int)-498134683);
        double[] od_VaftLDO = TestHelper.generateDoubleArray((int)6, (int)1355406090);
        double[] od_VaftLDO2 = TestHelper.generateDoubleArray((int)6, (int)2049770970);
        double[] od_VaftSwch = TestHelper.generateDoubleArray((int)6, (int)-1792816622);
        double[] od_VbefLDO = TestHelper.generateDoubleArray((int)6, (int)-1871762392);
        double[] power = TestHelper.generateDoubleArray((int)6, (int)1504614260);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTelemetry(analog_IaftLDO, analog_IbefLDO, analog_VaftLDO, analog_VaftSwch, analog_VbefLDO, clockhi_IaftLDO, clockhi_IbefLDO, clockhi_VaftLDO, clockhi_VaftSwch, clockhi_VbefLDO, clocklo_IaftLDO, clocklo_IbefLDO, clocklo_VaftLDO, clocklo_VaftLDO2, clocklo_VaftSwch, clocklo_VbefLDO, digital_IaftLDO, digital_IbefLDO, digital_VaftLDO, digital_VaftSwch, digital_VbefLDO, heater_IaftLDO, heater_IbefLDO, heater_VaftLDO, heater_VaftSwch, heater_VbefLDO, hvbias_IbefSwch, hvbias_VbefSwch, location, od_IaftLDO, od_IbefLDO, od_VaftLDO, od_VaftLDO2, od_VaftSwch, od_VbefLDO, power));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTelemetry));
        Rebpower_RebTelemetry item_ = (Rebpower_RebTelemetry)item;
        Assert.assertArrayEquals((double[])analog_IaftLDO, (double[])item_.getAnalog_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO, (double[])item_.getAnalog_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO, (double[])item_.getAnalog_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch, (double[])item_.getAnalog_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO, (double[])item_.getAnalog_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO, (double[])item_.getClockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO, (double[])item_.getClockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO, (double[])item_.getClockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch, (double[])item_.getClockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO, (double[])item_.getClockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO, (double[])item_.getClocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO, (double[])item_.getClocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO, (double[])item_.getClocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2, (double[])item_.getClocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch, (double[])item_.getClocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO, (double[])item_.getClocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO, (double[])item_.getDigital_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO, (double[])item_.getDigital_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO, (double[])item_.getDigital_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch, (double[])item_.getDigital_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO, (double[])item_.getDigital_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO, (double[])item_.getHeater_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO, (double[])item_.getHeater_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO, (double[])item_.getHeater_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch, (double[])item_.getHeater_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO, (double[])item_.getHeater_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch, (double[])item_.getHvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch, (double[])item_.getHvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO, (double[])item_.getOd_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO, (double[])item_.getOd_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO, (double[])item_.getOd_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2, (double[])item_.getOd_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch, (double[])item_.getOd_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO, (double[])item_.getOd_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.9419406652450562;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTotalPowerTelemetry));
        Rebpower_RebTotalPowerTelemetry item_ = (Rebpower_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebpsTelemetry() throws Exception {
        double[] boardTemp0 = TestHelper.generateDoubleArray((int)1, (int)-1838744113);
        double[] boardTemp1 = TestHelper.generateDoubleArray((int)1, (int)-368068051);
        double[] boardTemp2 = TestHelper.generateDoubleArray((int)1, (int)1961439460);
        double[] boardTemp3 = TestHelper.generateDoubleArray((int)1, (int)1931745097);
        double[] boardTemp4 = TestHelper.generateDoubleArray((int)1, (int)1999301497);
        double[] boardTemp5 = TestHelper.generateDoubleArray((int)1, (int)-2114334995);
        double[] boardTemp6 = TestHelper.generateDoubleArray((int)1, (int)856811190);
        double[] fPGATemp = TestHelper.generateDoubleArray((int)1, (int)-152600929);
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebpsTelemetry(boardTemp0, boardTemp1, boardTemp2, boardTemp3, boardTemp4, boardTemp5, boardTemp6, fPGATemp, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebpsTelemetry));
        Rebpower_RebpsTelemetry item_ = (Rebpower_RebpsTelemetry)item;
        Assert.assertArrayEquals((double[])boardTemp0, (double[])item_.getBoardTemp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp1, (double[])item_.getBoardTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp2, (double[])item_.getBoardTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp3, (double[])item_.getBoardTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp4, (double[])item_.getBoardTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp5, (double[])item_.getBoardTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp6, (double[])item_.getBoardTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fPGATemp, (double[])item_.getFPGATemp(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_Cold1Telemetry() throws Exception {
        double autoOffEnabled = 0.46377694606781006;
        double autoOffTemperature = 0.8475499153137207;
        double autoOnTemperature = 0.7130911350250244;
        double power = 0.924528181552887;
        double rejectTemperature = 0.08624112606048584;
        double setPower = 0.6441949605941772;
        double setpoint = 0.26536011695861816;
        double temperature = 0.07382547855377197;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Cold1Telemetry(autoOffEnabled, autoOffTemperature, autoOnTemperature, power, rejectTemperature, setPower, setpoint, temperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold1Telemetry));
        Vacuum_Cold1Telemetry item_ = (Vacuum_Cold1Telemetry)item;
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold2Telemetry() throws Exception {
        double autoOffEnabled = 0.5800908207893372;
        double autoOffTemperature = 0.7553856372833252;
        double autoOnTemperature = 0.5450135469436646;
        double power = 0.6083916425704956;
        double rejectTemperature = 0.4382684826850891;
        double setPower = 0.845430314540863;
        double setpoint = 0.9828876256942749;
        double temperature = 0.7418993711471558;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Cold2Telemetry(autoOffEnabled, autoOffTemperature, autoOnTemperature, power, rejectTemperature, setPower, setpoint, temperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold2Telemetry));
        Vacuum_Cold2Telemetry item_ = (Vacuum_Cold2Telemetry)item;
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoTelemetry() throws Exception {
        double autoOffEnabled = 0.07980525493621826;
        double autoOffTemperature = 0.28811997175216675;
        double autoOnTemperature = 0.8270516395568848;
        double power = 0.8729289174079895;
        double rejectTemperature = 0.9783458113670349;
        double setPower = 0.08606314659118652;
        double setpoint = 0.07951432466506958;
        double temperature = 0.38327741622924805;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoTelemetry(autoOffEnabled, autoOffTemperature, autoOnTemperature, power, rejectTemperature, setPower, setpoint, temperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTelemetry));
        Vacuum_CryoTelemetry item_ = (Vacuum_CryoTelemetry)item;
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_IonPumpsTelemetry() throws Exception {
        double current = 0.07689392566680908;
        double voltage = 0.3709811568260193;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_IonPumpsTelemetry(current, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumpsTelemetry));
        Vacuum_IonPumpsTelemetry item_ = (Vacuum_IonPumpsTelemetry)item;
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_RtdsTelemetry() throws Exception {
        double temperatureCold1 = 0.4337762f;
        double temperatureCold2 = 0.5407761931419373;
        double temperatureCryo = 0.42522042989730835;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_RtdsTelemetry(temperatureCold1, temperatureCold2, temperatureCryo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_RtdsTelemetry));
        Vacuum_RtdsTelemetry item_ = (Vacuum_RtdsTelemetry)item;
        Assert.assertEquals((double)temperatureCold1, (double)item_.getTemperatureCold1(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatureCold2, (double)item_.getTemperatureCold2(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatureCryo, (double)item_.getTemperatureCryo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboTelemetry() throws Exception {
        double cntrlrAirTemperature = 0.010773241519927979;
        double cntrlrSinkTemperature = 0.3226267099380493;
        double current = 0.2864617705345154;
        double driveFrequency = 0.08847993612289429;
        double power = 0.11408644914627075;
        double pumpTemperature = 0.9591028690338135;
        double rpm = 0.7161638736724854;
        double status = 0.8000139594078064;
        double voltage = 0.7493444085121155;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboTelemetry(cntrlrAirTemperature, cntrlrSinkTemperature, current, driveFrequency, power, pumpTemperature, rpm, status, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboTelemetry));
        Vacuum_TurboTelemetry item_ = (Vacuum_TurboTelemetry)item;
        Assert.assertEquals((double)cntrlrAirTemperature, (double)item_.getCntrlrAirTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrSinkTemperature, (double)item_.getCntrlrSinkTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)driveFrequency, (double)item_.getDriveFrequency(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpTemperature, (double)item_.getPumpTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)rpm, (double)item_.getRpm(), (double)1.0E-6f);
        Assert.assertEquals((double)status, (double)item_.getStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_VQMonitorTelemetry() throws Exception {
        double vqmpressure = 0.3515675663948059;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_VQMonitorTelemetry(vqmpressure));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VQMonitorTelemetry));
        Vacuum_VQMonitorTelemetry item_ = (Vacuum_VQMonitorTelemetry)item;
        Assert.assertEquals((double)vqmpressure, (double)item_.getVqmpressure(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double clean_5_24V_I = 0.4386467933654785;
        double dirty_24V_I = 0.11200529336929321;
        double dirty_28V_I = 0.7727377414703369;
        double dirty_48V_I = 0.3106893301010132;
        double heater_I = 0.1604752f;
        double protection_I = 0.9316699504852295;
        double rebps_0 = 0.4692228436470032;
        double sensor_PWS_17_I = 0.6340921521186829;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(clean_5_24V_I, dirty_24V_I, dirty_28V_I, dirty_48V_I, heater_I, protection_I, rebps_0, sensor_PWS_17_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I, (double)item_.getHeater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0, (double)item_.getRebps_0(), (double)1.0E-6f);
        Assert.assertEquals((double)sensor_PWS_17_I, (double)item_.getSensor_PWS_17_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double board_T = 0.2814931273460388;
        double body_Purge_I = 0.01822417974472046;
        double body_Purge_V = 0.5734025835990906;
        double bpu_Maq20_I = 0.9741061329841614;
        double bpu_Maq20_V = 0.71956467628479;
        double fpga_T = 0.9102600812911987;
        double fes_Shu_HCU_I = 0.8651875853538513;
        double fes_Shu_HCU_V = 0.4640123248100281;
        double gauges_I = 0.8699944019317627;
        double gauges_V = 0.7108557820320129;
        double ion_Pumps_I = 0.780899703502655;
        double ion_Pumps_V = 0.42520612478256226;
        double j11_I = 0.5604330897331238;
        double j11_V = 0.4883003830909729;
        double j12_I = 0.5871396660804749;
        double j12_V = 0.4066761f;
        double j6_I = 0.11830466985702515;
        double j6_V = 0.7664282321929932;
        double j7_I = 0.5160966515541077;
        double j7_V = 0.2521233558654785;
        double j8_I = 0.5227116346359253;
        double j8_V = 0.6460506916046143;
        double j9_I = 0.6314314007759094;
        double j9_V = 0.7600611448287964;
        double main_I = 0.8798719644546509;
        double main_T = 0.6867908239364624;
        double main_V = 0.9984661936759949;
        double pwr_Cry_HCU_I = 0.03759205341339111;
        double pwr_Cry_HCU_V = 0.7195050716400146;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(board_T, body_Purge_I, body_Purge_V, bpu_Maq20_I, bpu_Maq20_V, fpga_T, fes_Shu_HCU_I, fes_Shu_HCU_V, gauges_I, gauges_V, ion_Pumps_I, ion_Pumps_V, j11_I, j11_V, j12_I, j12_V, j6_I, j6_V, j7_I, j7_V, j8_I, j8_V, j9_I, j9_V, main_I, main_T, main_V, pwr_Cry_HCU_I, pwr_Cry_HCU_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I, (double)item_.getBody_Purge_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V, (double)item_.getBody_Purge_V(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I, (double)item_.getBpu_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V, (double)item_.getBpu_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I, (double)item_.getFes_Shu_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V, (double)item_.getFes_Shu_HCU_V(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_I, (double)item_.getJ11_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_V, (double)item_.getJ11_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_I, (double)item_.getJ12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_V, (double)item_.getJ12_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_I, (double)item_.getJ6_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_V, (double)item_.getJ6_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_I, (double)item_.getJ7_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_V, (double)item_.getJ7_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j8_I, (double)item_.getJ8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j8_V, (double)item_.getJ8_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_I, (double)item_.getJ9_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_V, (double)item_.getJ9_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I, (double)item_.getPwr_Cry_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V, (double)item_.getPwr_Cry_HCU_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double board_T = 0.4088412f;
        double fes_I = 0.2768210768699646;
        double fes_V = 0.666645884513855;
        double fpga_T = 0.4539481997489929;
        double main_I = 0.4719664454460144;
        double main_T = 0.08413833379745483;
        double main_V = 0.9477828145027161;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(board_T, fes_I, fes_V, fpga_T, main_I, main_T, main_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_I, (double)item_.getFes_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_V, (double)item_.getFes_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double board_T = 0.632499635219574;
        double cryotel0_I = 0.5327885746955872;
        double cryotel0_V = 0.23305213451385498;
        double cryotel1_I = 0.48485177755355835;
        double cryotel1_V = 0.7365257740020752;
        double cryotel2_I = 0.9524611830711365;
        double cryotel2_V = 0.1976214051246643;
        double fpga_T = 0.2756111f;
        double main_I = 0.3378385901451111;
        double main_T = 0.859836220741272;
        double main_V = 0.28822004795074463;
        double reb_BULK_I = 0.9087362885475159;
        double reb_BULK_V = 0.640973f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(board_T, cryotel0_I, cryotel0_V, cryotel1_I, cryotel1_V, cryotel2_I, cryotel2_V, fpga_T, main_I, main_T, main_V, reb_BULK_I, reb_BULK_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_I, (double)item_.getCryotel0_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_V, (double)item_.getCryotel0_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_I, (double)item_.getCryotel1_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_V, (double)item_.getCryotel1_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_I, (double)item_.getCryotel2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_V, (double)item_.getCryotel2_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_I, (double)item_.getReb_BULK_I(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_V, (double)item_.getReb_BULK_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_3_B_I = 0.20784467458724976;
        double otm_3_B_V = 0.014158666133880615;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_3_B_I, otm_3_B_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_3_B_I, (double)item_.getOtm_3_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V, (double)item_.getOtm_3_B_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_CcdTelemetry() throws Exception {
        double[] gDV = TestHelper.generateDoubleArray((int)9, (int)-453197374);
        String location = "";
        double[] oDV = TestHelper.generateDoubleArray((int)9, (int)-69267348);
        double[] oGV = TestHelper.generateDoubleArray((int)9, (int)-470278291);
        double[] rDV = TestHelper.generateDoubleArray((int)9, (int)475652079);
        double[] temp = TestHelper.generateDoubleArray((int)9, (int)-1708874932);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_CcdTelemetry(gDV, location, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_CcdTelemetry));
        Focal_plane_CcdTelemetry item_ = (Focal_plane_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTelemetry() throws Exception {
        double[] anaI = TestHelper.generateDoubleArray((int)3, (int)1899916488);
        double[] anaV = TestHelper.generateDoubleArray((int)3, (int)-1976882837);
        double[] aspicl_Temp0 = TestHelper.generateDoubleArray((int)3, (int)-1319887540);
        double[] aspicl_Temp1 = TestHelper.generateDoubleArray((int)3, (int)438101718);
        double[] aspicl_Temp2 = TestHelper.generateDoubleArray((int)3, (int)1575185668);
        double[] aspicu_Temp0 = TestHelper.generateDoubleArray((int)3, (int)-942703789);
        double[] aspicu_Temp1 = TestHelper.generateDoubleArray((int)3, (int)-538046794);
        double[] aspicu_Temp2 = TestHelper.generateDoubleArray((int)3, (int)-226418169);
        double[] clkHI = TestHelper.generateDoubleArray((int)3, (int)-478855838);
        double[] clkHV = TestHelper.generateDoubleArray((int)3, (int)-1902969239);
        double[] clkLI = TestHelper.generateDoubleArray((int)3, (int)-1807294017);
        double[] clkLV = TestHelper.generateDoubleArray((int)3, (int)1271935086);
        double[] digI = TestHelper.generateDoubleArray((int)3, (int)843366649);
        double[] digV = TestHelper.generateDoubleArray((int)3, (int)10148120);
        double[] hVBiasSwitch = TestHelper.generateDoubleArray((int)3, (int)1224092353);
        double[] htrV = TestHelper.generateDoubleArray((int)3, (int)-1423146805);
        double[] htrW = TestHelper.generateDoubleArray((int)3, (int)-1434394644);
        String location = "e";
        double[] oDI = TestHelper.generateDoubleArray((int)3, (int)-364957742);
        double[] oDV = TestHelper.generateDoubleArray((int)3, (int)379913438);
        double[] pClkL = TestHelper.generateDoubleArray((int)3, (int)1567233989);
        double[] pClkU = TestHelper.generateDoubleArray((int)3, (int)181598021);
        double[] power = TestHelper.generateDoubleArray((int)3, (int)-1444181202);
        double[] rGL = TestHelper.generateDoubleArray((int)3, (int)156073381);
        double[] rGU = TestHelper.generateDoubleArray((int)3, (int)1148967644);
        double[] rTDTemp = TestHelper.generateDoubleArray((int)3, (int)-585181793);
        double[] ref05V = TestHelper.generateDoubleArray((int)3, (int)-292994872);
        double[] ref125V = TestHelper.generateDoubleArray((int)3, (int)858043197);
        double[] ref15V = TestHelper.generateDoubleArray((int)3, (int)-1294228666);
        double[] ref25V = TestHelper.generateDoubleArray((int)3, (int)-480506741);
        double[] refN12 = TestHelper.generateDoubleArray((int)3, (int)-755253688);
        double[] refP12 = TestHelper.generateDoubleArray((int)3, (int)693595390);
        double[] sClkL = TestHelper.generateDoubleArray((int)3, (int)-1373929398);
        double[] sClkU = TestHelper.generateDoubleArray((int)3, (int)1381323071);
        double[] temp1 = TestHelper.generateDoubleArray((int)3, (int)-530479909);
        double[] temp10 = TestHelper.generateDoubleArray((int)3, (int)1898812177);
        double[] temp2 = TestHelper.generateDoubleArray((int)3, (int)258190571);
        double[] temp3 = TestHelper.generateDoubleArray((int)3, (int)-269097359);
        double[] temp4 = TestHelper.generateDoubleArray((int)3, (int)1920890167);
        double[] temp5 = TestHelper.generateDoubleArray((int)3, (int)1296573472);
        double[] temp6 = TestHelper.generateDoubleArray((int)3, (int)730064272);
        double[] temp7 = TestHelper.generateDoubleArray((int)3, (int)1624009518);
        double[] temp8 = TestHelper.generateDoubleArray((int)3, (int)-1045407781);
        double[] temp9 = TestHelper.generateDoubleArray((int)3, (int)1138512460);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicl_Temp1, aspicl_Temp2, aspicu_Temp0, aspicu_Temp1, aspicu_Temp2, clkHI, clkHV, clkLI, clkLV, digI, digV, hVBiasSwitch, htrV, htrW, location, oDI, oDV, pClkL, pClkU, power, rGL, rGU, rTDTemp, ref05V, ref125V, ref15V, ref25V, refN12, refP12, sClkL, sClkU, temp1, temp10, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTelemetry));
        Focal_plane_RebTelemetry item_ = (Focal_plane_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1, (double[])item_.getAspicl_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2, (double[])item_.getAspicl_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1, (double[])item_.getAspicu_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2, (double[])item_.getAspicu_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLI, (double[])item_.getClkLI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05V, (double[])item_.getRef05V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125V, (double[])item_.getRef125V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15V, (double[])item_.getRef15V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25V, (double[])item_.getRef25V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refN12, (double[])item_.getRefN12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refP12, (double[])item_.getRefP12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10, (double[])item_.getTemp10(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7, (double[])item_.getTemp7(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8, (double[])item_.getTemp8(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9, (double[])item_.getTemp9(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.3713676333427429;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPowerTelemetry));
        Focal_plane_RebTotalPowerTelemetry item_ = (Focal_plane_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebsAverageTemp6Telemetry() throws Exception {
        double rebsAverageTemp6 = 0.9410897493362427;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebsAverageTemp6Telemetry(rebsAverageTemp6));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebsAverageTemp6Telemetry));
        Focal_plane_RebsAverageTemp6Telemetry item_ = (Focal_plane_RebsAverageTemp6Telemetry)item;
        Assert.assertEquals((double)rebsAverageTemp6, (double)item_.getRebsAverageTemp6(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_SegmentTelemetry() throws Exception {
        double[] i = TestHelper.generateDoubleArray((int)144, (int)1382884763);
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_SegmentTelemetry(i, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SegmentTelemetry));
        Focal_plane_SegmentTelemetry item_ = (Focal_plane_SegmentTelemetry)item;
        Assert.assertArrayEquals((double[])i, (double[])item_.getI(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceivePathfinder_refrig_Cold1Telemetry() throws Exception {
        double ambientTmp = 0.7247708439826965;
        double cabinetTmp = 0.3784014f;
        double compCurrent = 0.04783368110656738;
        double compPower = 0.9104452133178711;
        double compVfdCurr = 0.8519304394721985;
        double compVfdFreq = 0.6333589553833008;
        double compVfdTemp = 0.49671435356140137;
        double compVfdVolt = 0.8823203444480896;
        double compVoltage = 0.050605833530426025;
        double coolFlowRate = 0.7618787884712219;
        double coolValvePosn = 0.5727295875549316;
        double dischrgPrs = 0.1308283805847168;
        double dischrgtmp_M = 0.998331f;
        double dischrgtmp_P = 0.3498866558074951;
        double eEPRValvePosn = 0.17562341690063477;
        double fan1Speed = 0.6904461979866028;
        double fan2Speed = 0.2425074f;
        double fan3Speed = 0.6432969570159912;
        double hGBValvePosn = 0.28806257247924805;
        double liquidSubCooling = 0.11362528800964355;
        double liquidtmp_M = 0.7981902956962585;
        double liquidtmp_P = 0.05058586597442627;
        double priOilSepTmp = 0.410033f;
        double secOilSepTmp = 0.2327372431755066;
        double suctionPrs = 0.8834550380706787;
        double suctiontmp_P = 0.17927193641662598;
        double waterInTmp = 0.4878249168395996;
        double waterOutTmp = 0.7535895705223083;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Pathfinder_refrig_Cold1Telemetry(ambientTmp, cabinetTmp, compCurrent, compPower, compVfdCurr, compVfdFreq, compVfdTemp, compVfdVolt, compVoltage, coolFlowRate, coolValvePosn, dischrgPrs, dischrgtmp_M, dischrgtmp_P, eEPRValvePosn, fan1Speed, fan2Speed, fan3Speed, hGBValvePosn, liquidSubCooling, liquidtmp_M, liquidtmp_P, priOilSepTmp, secOilSepTmp, suctionPrs, suctiontmp_P, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cold1Telemetry));
        Pathfinder_refrig_Cold1Telemetry item_ = (Pathfinder_refrig_Cold1Telemetry)item;
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdCurr, (double)item_.getCompVfdCurr(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdFreq, (double)item_.getCompVfdFreq(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdTemp, (double)item_.getCompVfdTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdVolt, (double)item_.getCompVfdVolt(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)coolFlowRate, (double)item_.getCoolFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)coolValvePosn, (double)item_.getCoolValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)eEPRValvePosn, (double)item_.getEEPRValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1Speed, (double)item_.getFan1Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2Speed, (double)item_.getFan2Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3Speed, (double)item_.getFan3Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)hGBValvePosn, (double)item_.getHGBValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidSubCooling, (double)item_.getLiquidSubCooling(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M, (double)item_.getLiquidtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P, (double)item_.getLiquidtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)priOilSepTmp, (double)item_.getPriOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)secOilSepTmp, (double)item_.getSecOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_Cold2Telemetry() throws Exception {
        double ambientTmp = 0.3272079825401306;
        double cabinetTmp = 0.7254730463027954;
        double compCurrent = 0.25193703174591064;
        double compPower = 0.7666507363319397;
        double compVfdCurr = 0.8382720947265625;
        double compVfdFreq = 0.2768780589103699;
        double compVfdTemp = 0.694943f;
        double compVfdVolt = 0.4774436354637146;
        double compVoltage = 0.8706921339035034;
        double coolFlowRate = 0.9188368320465088;
        double coolValvePosn = 0.8191748261451721;
        double dischrgPrs = 0.7146965861320496;
        double dischrgtmp_M = 0.6422613263130188;
        double dischrgtmp_P = 0.7838386297225952;
        double eEPRValvePosn = 0.5628254413604736;
        double fan1Speed = 0.5396012663841248;
        double fan2Speed = 0.2356804f;
        double fan3Speed = 0.76755690574646;
        double hGBValvePosn = 0.2852470874786377;
        double liquidSubCooling = 0.2208581566810608;
        double liquidtmp_M = 0.04956305f;
        double liquidtmp_P = 0.2891341f;
        double priOilSepTmp = 0.43691498041152954;
        double secOilSepTmp = 0.08017098903656006;
        double suctionPrs = 0.975362f;
        double suctiontmp_P = 0.5168592929840088;
        double waterInTmp = 0.1514669f;
        double waterOutTmp = 0.07667070627212524;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Pathfinder_refrig_Cold2Telemetry(ambientTmp, cabinetTmp, compCurrent, compPower, compVfdCurr, compVfdFreq, compVfdTemp, compVfdVolt, compVoltage, coolFlowRate, coolValvePosn, dischrgPrs, dischrgtmp_M, dischrgtmp_P, eEPRValvePosn, fan1Speed, fan2Speed, fan3Speed, hGBValvePosn, liquidSubCooling, liquidtmp_M, liquidtmp_P, priOilSepTmp, secOilSepTmp, suctionPrs, suctiontmp_P, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cold2Telemetry));
        Pathfinder_refrig_Cold2Telemetry item_ = (Pathfinder_refrig_Cold2Telemetry)item;
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdCurr, (double)item_.getCompVfdCurr(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdFreq, (double)item_.getCompVfdFreq(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdTemp, (double)item_.getCompVfdTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdVolt, (double)item_.getCompVfdVolt(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)coolFlowRate, (double)item_.getCoolFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)coolValvePosn, (double)item_.getCoolValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)eEPRValvePosn, (double)item_.getEEPRValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1Speed, (double)item_.getFan1Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2Speed, (double)item_.getFan2Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3Speed, (double)item_.getFan3Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)hGBValvePosn, (double)item_.getHGBValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidSubCooling, (double)item_.getLiquidSubCooling(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M, (double)item_.getLiquidtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P, (double)item_.getLiquidtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)priOilSepTmp, (double)item_.getPriOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)secOilSepTmp, (double)item_.getSecOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo1Telemetry() throws Exception {
        double afterCoolTmp = 0.002496182918548584;
        double compCurrent = 0.05834996700286865;
        double compPower = 0.8367744088172913;
        double compVoltage = 0.2647276520729065;
        double dischrgPrs = 0.834425f;
        double dischrgtmp_M = 0.9504293203353882;
        double dischrgtmp_P = 0.2851177453994751;
        double fanSpeed = 0.40919822454452515;
        double oilLevel = 0.010683178901672363;
        double oilSepTmp = 0.4298448f;
        double phaseSepTmp = 0.010835111141204834;
        double suctionPrs = 0.50991290807724;
        double suctiontmp_M = 0.8421172499656677;
        double suctiontmp_P = 0.5516842007637024;
        double surgeTankTmp = 0.11451911926269531;
        double waterInTmp = 0.9108472466468811;
        double waterOutTmp = 0.687547f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Pathfinder_refrig_Cryo1Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo1Telemetry));
        Pathfinder_refrig_Cryo1Telemetry item_ = (Pathfinder_refrig_Cryo1Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo2Telemetry() throws Exception {
        double afterCoolTmp = 0.20582687854766846;
        double ambientTmp = 0.8887909054756165;
        double cabinetTmp = 0.1397416591644287;
        double compCurrent = 0.12922364473342896;
        double compPower = 0.4991423487663269;
        double compVoltage = 0.060374677181243896;
        double dischrgPrs = 0.9349001049995422;
        double dischrgtmp_M = 0.9818090796470642;
        double dischrgtmp_P = 0.18668502569198608;
        double fanSpeed = 0.21072006225585938;
        double oilLevel = 0.8145656585693359;
        double oilSepTmp = 0.7258254885673523;
        double phaseSepTmp = 0.791206419467926;
        double suctionPrs = 0.7525073885917664;
        double suctiontmp_M = 0.480847f;
        double suctiontmp_P = 0.46290475130081177;
        double surgeTankTmp = 0.01742708683013916;
        double waterInTmp = 0.34737056493759155;
        double waterOutTmp = 0.7279629111289978;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Pathfinder_refrig_Cryo2Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo2Telemetry));
        Pathfinder_refrig_Cryo2Telemetry item_ = (Pathfinder_refrig_Cryo2Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo3Telemetry() throws Exception {
        double afterCoolTmp = 0.3086232542991638;
        double ambientTmp = 0.8943129181861877;
        double cabinetTmp = 0.8320593237876892;
        double compCurrent = 0.9500392079353333;
        double compPower = 0.8717734217643738;
        double compVoltage = 0.9418385624885559;
        double dischrgPrs = 0.3426443934440613;
        double dischrgtmp_M = 0.8763936161994934;
        double dischrgtmp_P = 0.10976654291152954;
        double fanSpeed = 0.31328171491622925;
        double oilLevel = 0.17146307229995728;
        double oilSepTmp = 0.5648835897445679;
        double phaseSepTmp = 0.03226763f;
        double suctionPrs = 0.8929800391197205;
        double suctiontmp_M = 0.007169842720031738;
        double suctiontmp_P = 0.6722826361656189;
        double surgeTankTmp = 0.9735507965087891;
        double waterInTmp = 0.3938329815864563;
        double waterOutTmp = 0.15796732902526855;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Pathfinder_refrig_Cryo3Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo3Telemetry));
        Pathfinder_refrig_Cryo3Telemetry item_ = (Pathfinder_refrig_Cryo3Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo4Telemetry() throws Exception {
        double afterCoolTmp = 0.513742208480835;
        double compCurrent = 0.13346683979034424;
        double compPower = 0.5879005789756775;
        double compVoltage = 0.4709498882293701;
        double dischrgPrs = 0.7932596206665039;
        double dischrgtmp_M = 0.8530024886131287;
        double dischrgtmp_P = 0.4846211075782776;
        double fanSpeed = 0.2812246084213257;
        double oilLevel = 0.2088964f;
        double oilSepTmp = 0.33946776390075684;
        double phaseSepTmp = 0.9399528503417969;
        double suctionPrs = 0.4634294f;
        double suctiontmp_M = 0.43860727548599243;
        double suctiontmp_P = 0.8752903938293457;
        double surgeTankTmp = 0.3097681999206543;
        double waterInTmp = 0.6414281129837036;
        double waterOutTmp = 0.5263808965682983;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Pathfinder_refrig_Cryo4Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo4Telemetry));
        Pathfinder_refrig_Cryo4Telemetry item_ = (Pathfinder_refrig_Cryo4Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo5Telemetry() throws Exception {
        double afterCoolTmp = 0.6607657074928284;
        double compCurrent = 0.1538516879081726;
        double compPower = 0.730922f;
        double compVoltage = 0.09853965044021606;
        double dischrgPrs = 0.4730631709098816;
        double dischrgtmp_M = 0.03276348114013672;
        double dischrgtmp_P = 0.1517086625099182;
        double fanSpeed = 0.5341876149177551;
        double oilLevel = 0.03012669086456299;
        double oilSepTmp = 0.3266274929046631;
        double phaseSepTmp = 0.4241926074028015;
        double suctionPrs = 0.5327516794204712;
        double suctiontmp_M = 0.9782283902168274;
        double suctiontmp_P = 0.02872532606124878;
        double surgeTankTmp = 0.1469811201095581;
        double waterInTmp = 0.009285271167755127;
        double waterOutTmp = 0.5658922791481018;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Pathfinder_refrig_Cryo5Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo5Telemetry));
        Pathfinder_refrig_Cryo5Telemetry item_ = (Pathfinder_refrig_Cryo5Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo6Telemetry() throws Exception {
        double afterCoolTmp = 0.24188333749771118;
        double compCurrent = 0.9930896759033203;
        double compPower = 0.9017523527145386;
        double compVoltage = 0.5053524374961853;
        double dischrgPrs = 0.8244085907936096;
        double dischrgtmp_M = 0.8311557173728943;
        double dischrgtmp_P = 0.9940950870513916;
        double fanSpeed = 0.07694637775421143;
        double oilLevel = 0.31527024507522583;
        double oilSepTmp = 0.1104759f;
        double phaseSepTmp = 0.8978132009506226;
        double suctionPrs = 0.9137728214263916;
        double suctiontmp_M = 0.01397031545639038;
        double suctiontmp_P = 0.4956052899360657;
        double surgeTankTmp = 0.749509f;
        double waterInTmp = 0.9661128520965576;
        double waterOutTmp = 0.32585716247558594;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Pathfinder_refrig_Cryo6Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo6Telemetry));
        Pathfinder_refrig_Cryo6Telemetry item_ = (Pathfinder_refrig_Cryo6Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }
}

