/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.cccamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.event.AlertRaisedEvent;
import org.lsst.sal.camera.event.AuthListEvent;
import org.lsst.sal.camera.event.CCSConfiguredEvent;
import org.lsst.sal.camera.event.ConfigurationAppliedEvent;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Stats_StatisticsConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_StoreConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_StoreConfigurationEvent;
import org.lsst.sal.camera.event.EndInitializeGuiderEvent;
import org.lsst.sal.camera.event.EndInitializeImageEvent;
import org.lsst.sal.camera.event.EndLoadFilterEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndTakeImageEvent;
import org.lsst.sal.camera.event.EndUnloadFilterEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.Fcs_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.FocalPlaneSummaryInfoEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_HardwareIdConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_ImageDatabaseService_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_ImageNameService_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_InstrumentConfig_InstrumentConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_MonitoringConfig_MonitoringConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_RaftTempControlStatusConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_RebTotalPower_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_HardwareIdConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsPowerConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_RebsAverageTemp6_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_RebsAverageTemp6_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Segment_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_DAQConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_GuiderConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_SequencerConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_WebHooksConfig_VisualizationConfigurationEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.Image_handling_FitsService_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_CommandsConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_DAQConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_FitsHandlingConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_GuiderConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_StatusAggregator_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.LargeFileObjectAvailableEvent;
import org.lsst.sal.camera.event.LogLevelEvent;
import org.lsst.sal.camera.event.LogMessageEvent;
import org.lsst.sal.camera.event.Mpm_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_Pluto_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Mpm_Pluto_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.NotReadyToTakeImageEvent;
import org.lsst.sal.camera.event.PrepareToTakeImageEvent;
import org.lsst.sal.camera.event.Quadbox_BFR_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_BFR_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VC_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VC_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VD_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VD_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_48V_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_48V_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_5V_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_5V_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.ReadyToTakeImageEvent;
import org.lsst.sal.camera.event.Rebpower_EmergencyResponseManager_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_RebTotalPower_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartLoadFilterEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartRotateCarouselEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.event.StartUnloadFilterEvent;
import org.lsst.sal.camera.event.SummaryStatusEvent;
import org.lsst.sal.camera.event.Vacuum_IonPumps_DevicesConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_VacPluto_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_VacPluto_DevicesConfigurationEvent;
import org.lsst.sal.cccamera.CCCamera;
import org.lsst.sal.cccamera.event.AvailableFiltersEvent;
import org.lsst.sal.cccamera.event.Bonn_shutter_Device_DevicesConfigurationEvent;
import org.lsst.sal.cccamera.event.Bonn_shutter_Device_GeneralConfigurationEvent;
import org.lsst.sal.cccamera.event.Bonn_shutter_Device_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Bonn_shutter_GeneralConfigurationEvent;
import org.lsst.sal.cccamera.event.Bonn_shutter_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.cccamera.event.Bonn_shutter_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.cccamera.event.Fcs_GeneralConfigurationEvent;
import org.lsst.sal.cccamera.event.Fcs_LinearEncoder_DevicesConfigurationEvent;
import org.lsst.sal.cccamera.event.Fcs_LinearEncoder_GeneralConfigurationEvent;
import org.lsst.sal.cccamera.event.Fcs_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.cccamera.event.Fcs_StepperMotor_DevicesConfigurationEvent;
import org.lsst.sal.cccamera.event.Fcs_StepperMotor_GeneralConfigurationEvent;
import org.lsst.sal.cccamera.event.Fcs_StepperMotor_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Fcs_StepperMotor_MotorConfigurationEvent;
import org.lsst.sal.cccamera.event.FileCommandExecutionEvent;
import org.lsst.sal.cccamera.event.FitsFilesWrittenEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Ccd_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Focal_plane_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Raft_HardwareIdConfigurationEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Raft_RaftTempControlConfigurationEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Reb_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Reb_timersConfigurationEvent;
import org.lsst.sal.cccamera.event.ImageStoredEvent;
import org.lsst.sal.cccamera.event.ImageVisualizationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cold1_DeviceConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cold1_DevicesConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cold1_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cold1_PicConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cold2_DeviceConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cold2_DevicesConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cold2_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cold2_PicConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_ColdCompLimits_CompLimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_CoolMaq20_DeviceConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_CoolMaq20_DevicesConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cryo1_DeviceConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cryo1_DevicesConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cryo1_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cryo2_DeviceConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cryo2_DevicesConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cryo2_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cryo2_PicConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cryo3_DeviceConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cryo3_DevicesConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cryo3_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cryo3_PicConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cryo4_DeviceConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cryo4_DevicesConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cryo4_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cryo5_DeviceConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cryo5_DevicesConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cryo5_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cryo6_DeviceConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cryo6_DevicesConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_Cryo6_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_CryoCompLimits_CompLimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_PeriodicTasks_PicConfigurationEvent;
import org.lsst.sal.cccamera.event.Pathfinder_refrig_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.cccamera.event.Quadbox_BFR_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Quadbox_PDU_24VC_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Quadbox_PDU_24VD_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Quadbox_PDU_48V_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Quadbox_PDU_5V_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Quadbox_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.cccamera.event.Quadbox_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.cccamera.event.Rebpower_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.cccamera.event.Rebpower_Reb_GeneralConfigurationEvent;
import org.lsst.sal.cccamera.event.Rebpower_Reb_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Rebpower_Rebps_GeneralConfigurationEvent;
import org.lsst.sal.cccamera.event.Rebpower_Rebps_PowerConfigurationEvent;
import org.lsst.sal.cccamera.event.Rebpower_Rebps_buildConfigurationEvent;
import org.lsst.sal.cccamera.event.ShutterBladeMotionProfileEvent;
import org.lsst.sal.cccamera.event.Vacuum_Cold1_CryoconConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_Cold1_DevicesConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_Cold1_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_Cold2_CryoconConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_Cold2_DevicesConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_Cold2_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_Cryo_CryoconConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_Cryo_DevicesConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_Cryo_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_IonPumps_CryoConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_IonPumps_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_Rtds_DeviceConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_Rtds_DevicesConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_Rtds_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_Turbo_DevicesConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_Turbo_GeneralConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_Turbo_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_VQMonitor_CryoConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_VQMonitor_DevicesConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_VQMonitor_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_VacuumConfigurationEvent;

public class EventSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = CCCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALEvent testSendReceive(SALEvent item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALEvent> future = executor.submit(() -> sal.getNextEvent(Duration.ofSeconds(10L)));
        try {
            sal.logEvent(item);
            SALEvent sALEvent = future.get(10L, TimeUnit.SECONDS);
            return sALEvent;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws Exception {
        String additionalKeys = "";
        String additionalValues = "k";
        int imagesInSequence = 321;
        String imageName = "fmnwkoekwxqcrkmftcfu";
        int imageIndex = 43;
        String imageSource = "l";
        String imageController = "j";
        String imageDate = "vjxwjbmw";
        int imageNumber = 313;
        double timestampAcquisitionStart = 0.536258f;
        double requestedExposureTime = 0.13944172859191895;
        double timestampEndOfReadout = 0.9737498164176941;
        SALEvent item = this.testSendReceive((SALEvent)new EndReadoutEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, requestedExposureTime, timestampEndOfReadout));
        Assert.assertTrue((boolean)(item instanceof EndReadoutEvent));
        EndReadoutEvent item_ = (EndReadoutEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)requestedExposureTime, (double)item_.getRequestedExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampEndOfReadout, (double)item_.getTimestampEndOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndTakeImageEvent() throws Exception {
        double timestampTransition = 0.5741432905197144;
        SALEvent item = this.testSendReceive((SALEvent)new EndTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndTakeImageEvent));
        EndTakeImageEvent item_ = (EndTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartSetFilterEvent() throws Exception {
        String filterName = "";
        String filterType = "";
        SALEvent item = this.testSendReceive((SALEvent)new StartSetFilterEvent(filterName, filterType));
        Assert.assertTrue((boolean)(item instanceof StartSetFilterEvent));
        StartSetFilterEvent item_ = (StartSetFilterEvent)item;
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
    }

    @Test
    public void sendReceiveStartUnloadFilterEvent() throws Exception {
        double timestampTransition = 0.05296283960342407;
        SALEvent item = this.testSendReceive((SALEvent)new StartUnloadFilterEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartUnloadFilterEvent));
        StartUnloadFilterEvent item_ = (StartUnloadFilterEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveNotReadyToTakeImageEvent() throws Exception {
        double timestampTransition = 0.07489949464797974;
        SALEvent item = this.testSendReceive((SALEvent)new NotReadyToTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof NotReadyToTakeImageEvent));
        NotReadyToTakeImageEvent item_ = (NotReadyToTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws Exception {
        double timestampTransition = 0.7162687182426453;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterCloseEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterCloseEvent));
        StartShutterCloseEvent item_ = (StartShutterCloseEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeGuiderEvent() throws Exception {
        double timestampTransition = 0.9309825897216797;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeGuiderEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndInitializeGuiderEvent));
        EndInitializeGuiderEvent item_ = (EndInitializeGuiderEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws Exception {
        double timestampTransition = 0.4938884377479553;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterCloseEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterCloseEvent));
        EndShutterCloseEvent item_ = (EndShutterCloseEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws Exception {
        String additionalKeys = "";
        String additionalValues = "p";
        int imagesInSequence = 934;
        String imageName = "jekwkiqze";
        int imageIndex = 114;
        String imageSource = "s";
        String imageController = "v";
        String imageDate = "";
        int imageNumber = 963;
        double timestampAcquisitionStart = 0.1568049192428589;
        double exposureTime = 0.8497532606124878;
        String imageTag = "nlkeqghnfuzovpreprkfuytkjuyhyzwirzilycbyllrzadpaeuerhlvukfvlofe";
        double timestampDateObs = 0.9596447348594666;
        double timestampDateEnd = 0.6999391317367554;
        double measuredShutterOpenTime = 0.13643884658813477;
        double darkTime = 0.5855968594551086;
        String emulatedImage = "p";
        SALEvent item = this.testSendReceive((SALEvent)new EndOfImageTelemetryEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, measuredShutterOpenTime, darkTime, emulatedImage));
        Assert.assertTrue((boolean)(item instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent item_ = (EndOfImageTelemetryEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageTag, (Object)item_.getImageTag());
        Assert.assertEquals((double)timestampDateObs, (double)item_.getTimestampDateObs(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampDateEnd, (double)item_.getTimestampDateEnd(), (double)1.0E-6f);
        Assert.assertEquals((double)measuredShutterOpenTime, (double)item_.getMeasuredShutterOpenTime(), (double)1.0E-6f);
        Assert.assertEquals((double)darkTime, (double)item_.getDarkTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)emulatedImage, (Object)item_.getEmulatedImage());
    }

    @Test
    public void sendReceiveEndUnloadFilterEvent() throws Exception {
        double timestampTransition = 0.29523491859436035;
        SALEvent item = this.testSendReceive((SALEvent)new EndUnloadFilterEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndUnloadFilterEvent));
        EndUnloadFilterEvent item_ = (EndUnloadFilterEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndRotateCarouselEvent() throws Exception {
        double timestampTransition = 0.6173826456069946;
        SALEvent item = this.testSendReceive((SALEvent)new EndRotateCarouselEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndRotateCarouselEvent));
        EndRotateCarouselEvent item_ = (EndRotateCarouselEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartLoadFilterEvent() throws Exception {
        double timestampTransition = 0.4313352704048157;
        SALEvent item = this.testSendReceive((SALEvent)new StartLoadFilterEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartLoadFilterEvent));
        StartLoadFilterEvent item_ = (StartLoadFilterEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveReadyToTakeImageEvent() throws Exception {
        double timestampTransition = 0.5078532695770264;
        SALEvent item = this.testSendReceive((SALEvent)new ReadyToTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof ReadyToTakeImageEvent));
        ReadyToTakeImageEvent item_ = (ReadyToTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePrepareToTakeImageEvent() throws Exception {
        double timestampTransition = 0.7547609210014343;
        SALEvent item = this.testSendReceive((SALEvent)new PrepareToTakeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof PrepareToTakeImageEvent));
        PrepareToTakeImageEvent item_ = (PrepareToTakeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveCCSConfiguredEvent() throws Exception {
        double timestampTransition = 0.347290575504303;
        SALEvent item = this.testSendReceive((SALEvent)new CCSConfiguredEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof CCSConfiguredEvent));
        CCSConfiguredEvent item_ = (CCSConfiguredEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndLoadFilterEvent() throws Exception {
        double timestampTransition = 0.4391133189201355;
        SALEvent item = this.testSendReceive((SALEvent)new EndLoadFilterEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndLoadFilterEvent));
        EndLoadFilterEvent item_ = (EndLoadFilterEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws Exception {
        double timestampTransition = 0.7533835172653198;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterOpenEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterOpenEvent));
        EndShutterOpenEvent item_ = (EndShutterOpenEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartIntegrationEvent() throws Exception {
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 909;
        String imageName = "fbcksxwvwdpuhjtouisg";
        int imageIndex = 303;
        String imageSource = "tr";
        String imageController = "";
        String imageDate = "qnmenq";
        int imageNumber = 686;
        double timestampAcquisitionStart = 0.7154474854469299;
        double exposureTime = 0.22857189178466797;
        String mode = "s";
        double timeout = 0.38384324312210083;
        SALEvent item = this.testSendReceive((SALEvent)new StartIntegrationEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, mode, timeout));
        Assert.assertTrue((boolean)(item instanceof StartIntegrationEvent));
        StartIntegrationEvent item_ = (StartIntegrationEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((double)timeout, (double)item_.getTimeout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeImageEvent() throws Exception {
        double timestampTransition = 0.05203276872634888;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeImageEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndInitializeImageEvent));
        EndInitializeImageEvent item_ = (EndInitializeImageEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndSetFilterEvent() throws Exception {
        String filterName = "d";
        String filterType = "e";
        int filterSlot = 495;
        double filterPosition = 0.28800106048583984;
        SALEvent item = this.testSendReceive((SALEvent)new EndSetFilterEvent(filterName, filterType, filterSlot, filterPosition));
        Assert.assertTrue((boolean)(item instanceof EndSetFilterEvent));
        EndSetFilterEvent item_ = (EndSetFilterEvent)item;
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
        Assert.assertEquals((long)filterSlot, (long)item_.getFilterSlot());
        Assert.assertEquals((double)filterPosition, (double)item_.getFilterPosition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws Exception {
        double timestampTransition = 0.22750800848007202;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterOpenEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterOpenEvent));
        StartShutterOpenEvent item_ = (StartShutterOpenEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAvailableFiltersEvent() throws Exception {
        String filterNames = "xirsmhnddyrhmpolaatatguejjmwmfeoaclwuexojmhlpkystpmanwcangdisqfvxuqwqysiafomtyjrzxwfucnamoaezfanauhnnootuhjusprpmldiutxsqcaageunvdyvuwxmpzbhnnlfaodrmazjfkyewrpjmwrtkaigzuaqyzmyymnpodojhymuggilkxlhgpseuuibuyrlojdhzqoveaoljumwx";
        SALEvent item = this.testSendReceive((SALEvent)new AvailableFiltersEvent(filterNames));
        Assert.assertTrue((boolean)(item instanceof AvailableFiltersEvent));
        AvailableFiltersEvent item_ = (AvailableFiltersEvent)item;
        Assert.assertEquals((Object)filterNames, (Object)item_.getFilterNames());
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws Exception {
        String additionalKeys = "u";
        String additionalValues = "";
        int imagesInSequence = 142;
        String imageName = "orfjzvnqofqitxyuovvualrabkzcmdp";
        int imageIndex = 634;
        String imageSource = "rm";
        String imageController = "b";
        String imageDate = "";
        int imageNumber = 935;
        double timestampAcquisitionStart = 0.263749361038208;
        double exposureTime = 0.8565203547477722;
        double timestampStartOfReadout = 0.6208995580673218;
        SALEvent item = this.testSendReceive((SALEvent)new StartReadoutEvent(additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, timestampStartOfReadout));
        Assert.assertTrue((boolean)(item instanceof StartReadoutEvent));
        StartReadoutEvent item_ = (StartReadoutEvent)item;
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampStartOfReadout, (double)item_.getTimestampStartOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartRotateCarouselEvent() throws Exception {
        double timestampTransition = 0.5267452597618103;
        SALEvent item = this.testSendReceive((SALEvent)new StartRotateCarouselEvent(timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartRotateCarouselEvent));
        StartRotateCarouselEvent item_ = (StartRotateCarouselEvent)item;
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws Exception {
        String imageName = "z";
        String ccdLocation = "";
        String raftBay = "a";
        String ccdSlot = "s";
        Object[] ccdType = new ImageReadoutParametersEvent.CcdType[]{ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL};
        int[] overRows = TestHelper.generateIntArray((int)9, (int)-83847564);
        int[] overCols = TestHelper.generateIntArray((int)9, (int)-997363620);
        int[] readRows = TestHelper.generateIntArray((int)9, (int)672700277);
        int[] readCols = TestHelper.generateIntArray((int)9, (int)-1310759371);
        int[] readCols2 = TestHelper.generateIntArray((int)9, (int)2024076555);
        int[] preCols = TestHelper.generateIntArray((int)9, (int)480633959);
        int[] preRows = TestHelper.generateIntArray((int)9, (int)396149372);
        int[] postCols = TestHelper.generateIntArray((int)9, (int)420310732);
        int[] underCols = TestHelper.generateIntArray((int)9, (int)395252757);
        String daqFolder = "";
        String daqAnnotation = "";
        SALEvent item = this.testSendReceive((SALEvent)new ImageReadoutParametersEvent(imageName, ccdLocation, raftBay, ccdSlot, (ImageReadoutParametersEvent.CcdType[])ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols, underCols, daqFolder, daqAnnotation));
        Assert.assertTrue((boolean)(item instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent item_ = (ImageReadoutParametersEvent)item;
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((int[])overRows, (int[])item_.getOverRows());
        Assert.assertArrayEquals((int[])overCols, (int[])item_.getOverCols());
        Assert.assertArrayEquals((int[])readRows, (int[])item_.getReadRows());
        Assert.assertArrayEquals((int[])readCols, (int[])item_.getReadCols());
        Assert.assertArrayEquals((int[])readCols2, (int[])item_.getReadCols2());
        Assert.assertArrayEquals((int[])preCols, (int[])item_.getPreCols());
        Assert.assertArrayEquals((int[])preRows, (int[])item_.getPreRows());
        Assert.assertArrayEquals((int[])postCols, (int[])item_.getPostCols());
        Assert.assertArrayEquals((int[])underCols, (int[])item_.getUnderCols());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqAnnotation, (Object)item_.getDaqAnnotation());
    }

    @Test
    public void sendReceiveFocalPlaneSummaryInfoEvent() throws Exception {
        String ccdLocation = "t";
        String raftBay = "";
        String ccdSlot = "";
        String rebSerialNumber = "v";
        String rebLSSTName = "d";
        String ccdLSSTName = "";
        String raftLSSTName = "";
        String ccdManSerNum = "b";
        String ccdManufacturer = "x";
        Object[] ccdType = new FocalPlaneSummaryInfoEvent.CcdType[]{FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL};
        double[] ccdTempSetPoint = TestHelper.generateDoubleArray((int)9, (int)-1142181782);
        String sequencerKey = "f";
        String sequencerChecksum = "";
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneSummaryInfoEvent(ccdLocation, raftBay, ccdSlot, rebSerialNumber, rebLSSTName, ccdLSSTName, raftLSSTName, ccdManSerNum, ccdManufacturer, (FocalPlaneSummaryInfoEvent.CcdType[])ccdType, ccdTempSetPoint, sequencerKey, sequencerChecksum));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneSummaryInfoEvent));
        FocalPlaneSummaryInfoEvent item_ = (FocalPlaneSummaryInfoEvent)item;
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)rebSerialNumber, (Object)item_.getRebSerialNumber());
        Assert.assertEquals((Object)rebLSSTName, (Object)item_.getRebLSSTName());
        Assert.assertEquals((Object)ccdLSSTName, (Object)item_.getCcdLSSTName());
        Assert.assertEquals((Object)raftLSSTName, (Object)item_.getRaftLSSTName());
        Assert.assertEquals((Object)ccdManSerNum, (Object)item_.getCcdManSerNum());
        Assert.assertEquals((Object)ccdManufacturer, (Object)item_.getCcdManufacturer());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((double[])ccdTempSetPoint, (double[])item_.getCcdTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((Object)sequencerKey, (Object)item_.getSequencerKey());
        Assert.assertEquals((Object)sequencerChecksum, (Object)item_.getSequencerChecksum());
    }

    @Test
    public void sendReceiveFcs_GeneralConfigurationEvent() throws Exception {
        String version = "g";
        String filterNames = "";
        String filterTypes = "";
        String nameFilter1 = "l";
        String nameFilter2 = "g";
        String nameFilter3 = "k";
        int positionFilter1 = 714;
        int positionFilter2 = 396;
        int positionFilter3 = 311;
        int positionLoad1 = 680;
        int positionLoad3 = 255;
        double tolerance = 0.4590691328048706;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_GeneralConfigurationEvent(version, filterNames, filterTypes, nameFilter1, nameFilter2, nameFilter3, positionFilter1, positionFilter2, positionFilter3, positionLoad1, positionLoad3, tolerance));
        Assert.assertTrue((boolean)(item instanceof Fcs_GeneralConfigurationEvent));
        Fcs_GeneralConfigurationEvent item_ = (Fcs_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)filterNames, (Object)item_.getFilterNames());
        Assert.assertEquals((Object)filterTypes, (Object)item_.getFilterTypes());
        Assert.assertEquals((Object)nameFilter1, (Object)item_.getNameFilter1());
        Assert.assertEquals((Object)nameFilter2, (Object)item_.getNameFilter2());
        Assert.assertEquals((Object)nameFilter3, (Object)item_.getNameFilter3());
        Assert.assertEquals((long)positionFilter1, (long)item_.getPositionFilter1());
        Assert.assertEquals((long)positionFilter2, (long)item_.getPositionFilter2());
        Assert.assertEquals((long)positionFilter3, (long)item_.getPositionFilter3());
        Assert.assertEquals((long)positionLoad1, (long)item_.getPositionLoad1());
        Assert.assertEquals((long)positionLoad3, (long)item_.getPositionLoad3());
        Assert.assertEquals((double)tolerance, (double)item_.getTolerance(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_LinearEncoder_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_LinearEncoder_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Fcs_LinearEncoder_DevicesConfigurationEvent));
        Fcs_LinearEncoder_DevicesConfigurationEvent item_ = (Fcs_LinearEncoder_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveFcs_LinearEncoder_GeneralConfigurationEvent() throws Exception {
        String version = "k";
        String devcId = "r";
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_LinearEncoder_GeneralConfigurationEvent(version, devcId));
        Assert.assertTrue((boolean)(item instanceof Fcs_LinearEncoder_GeneralConfigurationEvent));
        Fcs_LinearEncoder_GeneralConfigurationEvent item_ = (Fcs_LinearEncoder_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveFcs_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "k";
        int schedulers_default_nTasks = 246;
        int schedulers_default_nThreads = 50;
        int schedulers_monitor_update_publish_scheduler_nTasks = 459;
        int schedulers_monitor_update_publish_scheduler_nThreads = 692;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Fcs_PeriodicTasks_GeneralConfigurationEvent));
        Fcs_PeriodicTasks_GeneralConfigurationEvent item_ = (Fcs_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveFcs_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "k";
        long agentmonitorservice_taskPeriodMillis = 116L;
        long heartbeat_taskPeriodMillis = 305L;
        long monitor_check_taskPeriodMillis = 95L;
        long monitor_publish_taskPeriodMillis = 979L;
        long monitor_update_taskPeriodMillis = 907L;
        long runtimeinfo_taskPeriodMillis = 203L;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Fcs_PeriodicTasks_timersConfigurationEvent));
        Fcs_PeriodicTasks_timersConfigurationEvent item_ = (Fcs_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFcs_StepperMotor_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_StepperMotor_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Fcs_StepperMotor_DevicesConfigurationEvent));
        Fcs_StepperMotor_DevicesConfigurationEvent item_ = (Fcs_StepperMotor_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveFcs_StepperMotor_GeneralConfigurationEvent() throws Exception {
        String version = "";
        String devcId = "";
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_StepperMotor_GeneralConfigurationEvent(version, devcId));
        Assert.assertTrue((boolean)(item instanceof Fcs_StepperMotor_GeneralConfigurationEvent));
        Fcs_StepperMotor_GeneralConfigurationEvent item_ = (Fcs_StepperMotor_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveFcs_StepperMotor_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double motortemperature_warnHi = 0.5214723944664001;
        double motortemperature_limitHi = 0.4478017f;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_StepperMotor_LimitsConfigurationEvent(version, motortemperature_warnHi, motortemperature_limitHi));
        Assert.assertTrue((boolean)(item instanceof Fcs_StepperMotor_LimitsConfigurationEvent));
        Fcs_StepperMotor_LimitsConfigurationEvent item_ = (Fcs_StepperMotor_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)motortemperature_warnHi, (double)item_.getMotortemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)motortemperature_limitHi, (double)item_.getMotortemperature_limitHi(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_StepperMotor_MotorConfigurationEvent() throws Exception {
        String version = "p";
        int accelRamp = 97;
        boolean backOff = true;
        int brakeRamp = 218;
        int iPhase = 945;
        int iPhaseStill = 75;
        int maxJerkAccel = 796;
        int maxJerkBrake = 601;
        double maxRampTime = 0.7439114451408386;
        int minStepFreq = 507;
        int quickRamp = 570;
        int rampType = 852;
        int reverseClearance = 632;
        int stepFreq = 562;
        int stepMode = 505;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_StepperMotor_MotorConfigurationEvent(version, accelRamp, backOff, brakeRamp, iPhase, iPhaseStill, maxJerkAccel, maxJerkBrake, maxRampTime, minStepFreq, quickRamp, rampType, reverseClearance, stepFreq, stepMode));
        Assert.assertTrue((boolean)(item instanceof Fcs_StepperMotor_MotorConfigurationEvent));
        Fcs_StepperMotor_MotorConfigurationEvent item_ = (Fcs_StepperMotor_MotorConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)accelRamp, (long)item_.getAccelRamp());
        Assert.assertEquals((Object)backOff, (Object)item_.isBackOff());
        Assert.assertEquals((long)brakeRamp, (long)item_.getBrakeRamp());
        Assert.assertEquals((long)iPhase, (long)item_.getIPhase());
        Assert.assertEquals((long)iPhaseStill, (long)item_.getIPhaseStill());
        Assert.assertEquals((long)maxJerkAccel, (long)item_.getMaxJerkAccel());
        Assert.assertEquals((long)maxJerkBrake, (long)item_.getMaxJerkBrake());
        Assert.assertEquals((double)maxRampTime, (double)item_.getMaxRampTime(), (double)1.0E-6f);
        Assert.assertEquals((long)minStepFreq, (long)item_.getMinStepFreq());
        Assert.assertEquals((long)quickRamp, (long)item_.getQuickRamp());
        Assert.assertEquals((long)rampType, (long)item_.getRampType());
        Assert.assertEquals((long)reverseClearance, (long)item_.getReverseClearance());
        Assert.assertEquals((long)stepFreq, (long)item_.getStepFreq());
        Assert.assertEquals((long)stepMode, (long)item_.getStepMode());
    }

    @Test
    public void sendReceiveBonn_shutter_Device_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_Device_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_Device_DevicesConfigurationEvent));
        Bonn_shutter_Device_DevicesConfigurationEvent item_ = (Bonn_shutter_Device_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveBonn_shutter_Device_GeneralConfigurationEvent() throws Exception {
        String version = "e";
        String devcId = "p";
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_Device_GeneralConfigurationEvent(version, devcId));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_Device_GeneralConfigurationEvent));
        Bonn_shutter_Device_GeneralConfigurationEvent item_ = (Bonn_shutter_Device_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveBonn_shutter_Device_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double bonn_V36_warnHi = 0.5311670303344727;
        double bonn_V36_warnLo = 0.8110361695289612;
        double bonn_V36_limitHi = 0.283031165599823;
        double bonn_V36_limitLo = 0.7143215537071228;
        double bonn_V5_warnHi = 0.4298403859138489;
        double bonn_V5_warnLo = 0.4437502f;
        double bonn_V5_limitHi = 0.4124288558959961;
        double bonn_V5_limitLo = 0.16232693195343018;
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_Device_LimitsConfigurationEvent(version, bonn_V36_warnHi, bonn_V36_warnLo, bonn_V36_limitHi, bonn_V36_limitLo, bonn_V5_warnHi, bonn_V5_warnLo, bonn_V5_limitHi, bonn_V5_limitLo));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_Device_LimitsConfigurationEvent));
        Bonn_shutter_Device_LimitsConfigurationEvent item_ = (Bonn_shutter_Device_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)bonn_V36_warnHi, (double)item_.getBonn_V36_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V36_warnLo, (double)item_.getBonn_V36_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V36_limitHi, (double)item_.getBonn_V36_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V36_limitLo, (double)item_.getBonn_V36_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5_warnHi, (double)item_.getBonn_V5_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5_warnLo, (double)item_.getBonn_V5_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5_limitHi, (double)item_.getBonn_V5_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5_limitLo, (double)item_.getBonn_V5_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveBonn_shutter_GeneralConfigurationEvent() throws Exception {
        String version = "k";
        double maxExposureTime = 0.5712229609489441;
        double minExposureTime = 0.8883883357048035;
        int openCloseTimeMillis = 325;
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_GeneralConfigurationEvent(version, maxExposureTime, minExposureTime, openCloseTimeMillis));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_GeneralConfigurationEvent));
        Bonn_shutter_GeneralConfigurationEvent item_ = (Bonn_shutter_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)maxExposureTime, (double)item_.getMaxExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)minExposureTime, (double)item_.getMinExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((long)openCloseTimeMillis, (long)item_.getOpenCloseTimeMillis());
    }

    @Test
    public void sendReceiveBonn_shutter_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 108;
        int schedulers_default_nThreads = 197;
        int schedulers_monitor_update_publish_scheduler_nTasks = 853;
        int schedulers_monitor_update_publish_scheduler_nThreads = 73;
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_PeriodicTasks_GeneralConfigurationEvent));
        Bonn_shutter_PeriodicTasks_GeneralConfigurationEvent item_ = (Bonn_shutter_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveBonn_shutter_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "m";
        long agentmonitorservice_taskPeriodMillis = 762L;
        long heartbeat_taskPeriodMillis = 705L;
        long monitor_check_taskPeriodMillis = 160L;
        long monitor_publish_taskPeriodMillis = 322L;
        long monitor_update_taskPeriodMillis = 972L;
        long runtimeinfo_taskPeriodMillis = 539L;
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_PeriodicTasks_timersConfigurationEvent));
        Bonn_shutter_PeriodicTasks_timersConfigurationEvent item_ = (Bonn_shutter_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 712;
        int schedulers_default_nThreads = 67;
        int schedulers_monitor_update_publish_scheduler_nTasks = 521;
        int schedulers_monitor_update_publish_scheduler_nThreads = 647;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasks_GeneralConfigurationEvent));
        Daq_monitor_PeriodicTasks_GeneralConfigurationEvent item_ = (Daq_monitor_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "b";
        long agentmonitorservice_taskPeriodMillis = 984L;
        long heartbeat_taskPeriodMillis = 923L;
        long monitor_check_taskPeriodMillis = 822L;
        long monitor_publish_taskPeriodMillis = 293L;
        long monitor_update_taskPeriodMillis = 987L;
        long publishstats_taskPeriodMillis = 309L;
        long purgedaq_taskPeriodMillis = 173L;
        long runtimeinfo_taskPeriodMillis = 677L;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, publishstats_taskPeriodMillis, purgedaq_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasks_timersConfigurationEvent));
        Daq_monitor_PeriodicTasks_timersConfigurationEvent item_ = (Daq_monitor_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)publishstats_taskPeriodMillis, (long)item_.getPublishstats_taskPeriodMillis());
        Assert.assertEquals((long)purgedaq_taskPeriodMillis, (long)item_.getPurgedaq_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveDaq_monitor_Stats_StatisticsConfigurationEvent() throws Exception {
        String version = "";
        int minDiffAlertWarning = 137;
        int minDiffLogWarning = 444;
        String sumDriverChecks = "";
        String sumDriverStats = "";
        String sumFirmwareChecks = "g";
        String sumFirmwareStats = "";
        String sumRdsChecks = "";
        String sumRdsStats = "j";
        String sumRmsChecks = "a";
        String sumRmsStats = "";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Stats_StatisticsConfigurationEvent(version, minDiffAlertWarning, minDiffLogWarning, sumDriverChecks, sumDriverStats, sumFirmwareChecks, sumFirmwareStats, sumRdsChecks, sumRdsStats, sumRmsChecks, sumRmsStats));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Stats_StatisticsConfigurationEvent));
        Daq_monitor_Stats_StatisticsConfigurationEvent item_ = (Daq_monitor_Stats_StatisticsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)minDiffAlertWarning, (long)item_.getMinDiffAlertWarning());
        Assert.assertEquals((long)minDiffLogWarning, (long)item_.getMinDiffLogWarning());
        Assert.assertEquals((Object)sumDriverChecks, (Object)item_.getSumDriverChecks());
        Assert.assertEquals((Object)sumDriverStats, (Object)item_.getSumDriverStats());
        Assert.assertEquals((Object)sumFirmwareChecks, (Object)item_.getSumFirmwareChecks());
        Assert.assertEquals((Object)sumFirmwareStats, (Object)item_.getSumFirmwareStats());
        Assert.assertEquals((Object)sumRdsChecks, (Object)item_.getSumRdsChecks());
        Assert.assertEquals((Object)sumRdsStats, (Object)item_.getSumRdsStats());
        Assert.assertEquals((Object)sumRmsChecks, (Object)item_.getSumRmsChecks());
        Assert.assertEquals((Object)sumRmsStats, (Object)item_.getSumRmsStats());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreConfigurationEvent() throws Exception {
        String version = "x";
        int alarmPurgeFailures = 24;
        String daqPartition = "l";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_StoreConfigurationEvent(version, alarmPurgeFailures, daqPartition));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreConfigurationEvent));
        Daq_monitor_StoreConfigurationEvent item_ = (Daq_monitor_StoreConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)alarmPurgeFailures, (long)item_.getAlarmPurgeFailures());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
    }

    @Test
    public void sendReceiveDaq_monitor_Store_DevicesConfigurationEvent() throws Exception {
        String version = "i";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_DevicesConfigurationEvent));
        Daq_monitor_Store_DevicesConfigurationEvent item_ = (Daq_monitor_Store_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveDaq_monitor_Store_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double freefraction_warnLo = 0.5074688792228699;
        double freefraction_limitLo = 0.2082958221435547;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_LimitsConfigurationEvent(version, freefraction_warnLo, freefraction_limitLo));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_LimitsConfigurationEvent));
        Daq_monitor_Store_LimitsConfigurationEvent item_ = (Daq_monitor_Store_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)freefraction_warnLo, (double)item_.getFreefraction_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_limitLo, (double)item_.getFreefraction_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Store_StoreConfigurationEvent() throws Exception {
        String version = "v";
        String daqFolder = "e";
        boolean enableAutoPurge = false;
        double purgeTarget = 0.4344951f;
        double purgeThreshold = 0.5914474725723267;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_StoreConfigurationEvent(version, daqFolder, enableAutoPurge, purgeTarget, purgeThreshold));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_StoreConfigurationEvent));
        Daq_monitor_Store_StoreConfigurationEvent item_ = (Daq_monitor_Store_StoreConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)enableAutoPurge, (Object)item_.isEnableAutoPurge());
        Assert.assertEquals((double)purgeTarget, (double)item_.getPurgeTarget(), (double)1.0E-6f);
        Assert.assertEquals((double)purgeThreshold, (double)item_.getPurgeThreshold(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_EmergencyResponseManager_GeneralConfigurationEvent() throws Exception {
        String version = "";
        boolean processOnlyClearedAlerts = true;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_EmergencyResponseManager_GeneralConfigurationEvent(version, processOnlyClearedAlerts));
        Assert.assertTrue((boolean)(item instanceof Rebpower_EmergencyResponseManager_GeneralConfigurationEvent));
        Rebpower_EmergencyResponseManager_GeneralConfigurationEvent item_ = (Rebpower_EmergencyResponseManager_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)processOnlyClearedAlerts, (Object)item_.isProcessOnlyClearedAlerts());
    }

    @Test
    public void sendReceiveRebpower_GeneralConfigurationEvent() throws Exception {
        String version = "";
        long powerOffSleepMillis = 36L;
        int psDeviceExcepNumToOffline = 190;
        long psDeviceReadTimeout = 971L;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_GeneralConfigurationEvent(version, powerOffSleepMillis, psDeviceExcepNumToOffline, psDeviceReadTimeout));
        Assert.assertTrue((boolean)(item instanceof Rebpower_GeneralConfigurationEvent));
        Rebpower_GeneralConfigurationEvent item_ = (Rebpower_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)powerOffSleepMillis, (long)item_.getPowerOffSleepMillis());
        Assert.assertEquals((long)psDeviceExcepNumToOffline, (long)item_.getPsDeviceExcepNumToOffline());
        Assert.assertEquals((long)psDeviceReadTimeout, (long)item_.getPsDeviceReadTimeout());
    }

    @Test
    public void sendReceiveRebpower_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 743;
        int schedulers_default_nThreads = 788;
        int schedulers_monitor_check_scheduler_nTasks = 434;
        int schedulers_monitor_check_scheduler_nThreads = 291;
        int schedulers_monitor_update_publish_scheduler_nTasks = 638;
        int schedulers_monitor_update_publish_scheduler_nThreads = 127;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Rebpower_PeriodicTasks_GeneralConfigurationEvent));
        Rebpower_PeriodicTasks_GeneralConfigurationEvent item_ = (Rebpower_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveRebpower_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "s";
        long agentmonitorservice_taskPeriodMillis = 652L;
        long heartbeat_taskPeriodMillis = 186L;
        long monitor_check_RebPS_P00_taskPeriodMillis = 947L;
        long monitor_publish_RebPS_P00_taskPeriodMillis = 281L;
        long monitor_publish_taskPeriodMillis = 691L;
        long monitor_update_RebPS_P00_taskPeriodMillis = 84L;
        long monitor_update_taskPeriodMillis = 12L;
        long reb_power_state_taskPeriodMillis = 881L;
        long runtimeinfo_taskPeriodMillis = 910L;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_RebPS_P00_taskPeriodMillis, monitor_publish_RebPS_P00_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_RebPS_P00_taskPeriodMillis, monitor_update_taskPeriodMillis, reb_power_state_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Rebpower_PeriodicTasks_timersConfigurationEvent));
        Rebpower_PeriodicTasks_timersConfigurationEvent item_ = (Rebpower_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P00_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P00_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P00_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)reb_power_state_taskPeriodMillis, (long)item_.getReb_power_state_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveRebpower_RebTotalPower_LimitsConfigurationEvent() throws Exception {
        String version = "b";
        double warnHi = 0.7041372656822205;
        double warnLo = 0.5663792490959167;
        double limitHi = 0.5089836716651917;
        double limitLo = 0.4212055802345276;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_RebTotalPower_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTotalPower_LimitsConfigurationEvent));
        Rebpower_RebTotalPower_LimitsConfigurationEvent item_ = (Rebpower_RebTotalPower_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_Reb_GeneralConfigurationEvent() throws Exception {
        String version = "q";
        int[] hvBias = TestHelper.generateIntArray((int)6, (int)-1947213365);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Reb_GeneralConfigurationEvent(version, hvBias, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Reb_GeneralConfigurationEvent));
        Rebpower_Reb_GeneralConfigurationEvent item_ = (Rebpower_Reb_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((int[])hvBias, (int[])item_.getHvBias());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveRebpower_Reb_LimitsConfigurationEvent() throws Exception {
        String version = "w";
        double[] analog_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)826656145);
        double[] analog_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)-1336493410);
        double[] analog_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)-818683957);
        double[] analog_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)-1116182691);
        double[] analog_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)1133711120);
        double[] analog_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)-240806326);
        double[] analog_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)-2008129550);
        double[] analog_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)-1354571885);
        double[] analog_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)371020991);
        double[] analog_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)1693222528);
        double[] analog_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)708616116);
        double[] analog_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)-228832894);
        double[] analog_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)6, (int)-1480296753);
        double[] analog_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)6, (int)-1440176088);
        double[] analog_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)6, (int)-209515778);
        double[] analog_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)6, (int)-324011762);
        double[] analog_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)55276997);
        double[] analog_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)8116797);
        double[] analog_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)562658191);
        double[] analog_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)-1880502128);
        double[] clockhi_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)1497341512);
        double[] clockhi_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)1047191324);
        double[] clockhi_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)396524270);
        double[] clockhi_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)-507605578);
        double[] clockhi_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)-1777983941);
        double[] clockhi_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)-1341796865);
        double[] clockhi_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)1777348510);
        double[] clockhi_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)275873958);
        double[] clockhi_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)1317361422);
        double[] clockhi_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)-1201170237);
        double[] clockhi_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)2072930703);
        double[] clockhi_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)-1529081495);
        double[] clockhi_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)6, (int)2137030993);
        double[] clockhi_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)6, (int)-142497295);
        double[] clockhi_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)6, (int)-1444118058);
        double[] clockhi_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)6, (int)144553863);
        double[] clockhi_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)1259435401);
        double[] clockhi_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)1626660603);
        double[] clockhi_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)-1497824864);
        double[] clockhi_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)140593133);
        double[] clocklo_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)999665223);
        double[] clocklo_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)-452369723);
        double[] clocklo_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)23872612);
        double[] clocklo_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)-1852916457);
        double[] clocklo_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)2048972661);
        double[] clocklo_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)-1913967513);
        double[] clocklo_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)-929134249);
        double[] clocklo_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)1720638826);
        double[] clocklo_VaftLDO2_warnHi = TestHelper.generateDoubleArray((int)6, (int)1939373811);
        double[] clocklo_VaftLDO2_warnLo = TestHelper.generateDoubleArray((int)6, (int)-915855823);
        double[] clocklo_VaftLDO2_limitHi = TestHelper.generateDoubleArray((int)6, (int)489236517);
        double[] clocklo_VaftLDO2_limitLo = TestHelper.generateDoubleArray((int)6, (int)1194877921);
        double[] clocklo_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)-792610206);
        double[] clocklo_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)-825147154);
        double[] clocklo_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)81386717);
        double[] clocklo_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)1515491052);
        double[] clocklo_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)6, (int)-297609666);
        double[] clocklo_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)6, (int)-110889107);
        double[] clocklo_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)6, (int)1803181868);
        double[] clocklo_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)6, (int)-341624428);
        double[] clocklo_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)-668442062);
        double[] clocklo_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)-1635908036);
        double[] clocklo_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)777894093);
        double[] clocklo_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)-1650138398);
        double[] digital_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)-2017579353);
        double[] digital_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)1933532086);
        double[] digital_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)466095936);
        double[] digital_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)1911768961);
        double[] digital_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)-427683939);
        double[] digital_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)1549960256);
        double[] digital_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)-1013132103);
        double[] digital_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)-598249054);
        double[] digital_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)520059070);
        double[] digital_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)1684543183);
        double[] digital_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)-854944677);
        double[] digital_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)-296328417);
        double[] digital_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)6, (int)-1715452240);
        double[] digital_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)6, (int)879617452);
        double[] digital_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)6, (int)-1398092379);
        double[] digital_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)6, (int)1759231459);
        double[] digital_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)-898610774);
        double[] digital_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)1933703035);
        double[] digital_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)855610156);
        double[] digital_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)-1438904696);
        double[] heater_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)-1659476663);
        double[] heater_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)-927101831);
        double[] heater_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)-1818238838);
        double[] heater_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)1715379521);
        double[] heater_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)-299935324);
        double[] heater_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)1635038212);
        double[] heater_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)-2063672426);
        double[] heater_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)1719199993);
        double[] heater_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)1596164509);
        double[] heater_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)-460638624);
        double[] heater_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)-1362529068);
        double[] heater_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)692334780);
        double[] heater_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)6, (int)-15576454);
        double[] heater_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)6, (int)323475127);
        double[] heater_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)6, (int)1016666927);
        double[] heater_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)6, (int)-1489522858);
        double[] heater_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)1677904051);
        double[] heater_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)1007366497);
        double[] heater_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)2071033573);
        double[] heater_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)1217948985);
        double[] hvbias_IbefSwch_warnHi = TestHelper.generateDoubleArray((int)6, (int)-661459443);
        double[] hvbias_IbefSwch_limitHi = TestHelper.generateDoubleArray((int)6, (int)1222621798);
        double[] hvbias_VbefSwch_warnHi = TestHelper.generateDoubleArray((int)6, (int)-2056626238);
        double[] hvbias_VbefSwch_limitHi = TestHelper.generateDoubleArray((int)6, (int)-1076245341);
        String location = "";
        double[] od_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)1093443648);
        double[] od_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)927367824);
        double[] od_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)307770368);
        double[] od_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)-1986960173);
        double[] od_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)1584240356);
        double[] od_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)-1026922035);
        double[] od_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)925465228);
        double[] od_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)2060268648);
        double[] od_VaftLDO2_warnHi = TestHelper.generateDoubleArray((int)6, (int)1634586371);
        double[] od_VaftLDO2_warnLo = TestHelper.generateDoubleArray((int)6, (int)-575742562);
        double[] od_VaftLDO2_limitHi = TestHelper.generateDoubleArray((int)6, (int)-478872772);
        double[] od_VaftLDO2_limitLo = TestHelper.generateDoubleArray((int)6, (int)1769352277);
        double[] od_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)950312333);
        double[] od_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)-1153118460);
        double[] od_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)109015518);
        double[] od_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)-1882413127);
        double[] od_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)6, (int)-1791584394);
        double[] od_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)6, (int)227557964);
        double[] od_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)6, (int)733283966);
        double[] od_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)6, (int)352126386);
        double[] od_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)6, (int)453387707);
        double[] od_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)6, (int)1292037324);
        double[] od_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)6, (int)683551500);
        double[] od_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)6, (int)1985175603);
        double[] power_warnHi = TestHelper.generateDoubleArray((int)6, (int)90887591);
        double[] power_warnLo = TestHelper.generateDoubleArray((int)6, (int)-2091484725);
        double[] power_limitHi = TestHelper.generateDoubleArray((int)6, (int)-1085132997);
        double[] power_limitLo = TestHelper.generateDoubleArray((int)6, (int)-1393337317);
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Reb_LimitsConfigurationEvent(version, analog_IaftLDO_warnHi, analog_IaftLDO_warnLo, analog_IaftLDO_limitHi, analog_IaftLDO_limitLo, analog_IbefLDO_warnHi, analog_IbefLDO_warnLo, analog_IbefLDO_limitHi, analog_IbefLDO_limitLo, analog_VaftLDO_warnHi, analog_VaftLDO_warnLo, analog_VaftLDO_limitHi, analog_VaftLDO_limitLo, analog_VaftSwch_warnHi, analog_VaftSwch_warnLo, analog_VaftSwch_limitHi, analog_VaftSwch_limitLo, analog_VbefLDO_warnHi, analog_VbefLDO_warnLo, analog_VbefLDO_limitHi, analog_VbefLDO_limitLo, clockhi_IaftLDO_warnHi, clockhi_IaftLDO_warnLo, clockhi_IaftLDO_limitHi, clockhi_IaftLDO_limitLo, clockhi_IbefLDO_warnHi, clockhi_IbefLDO_warnLo, clockhi_IbefLDO_limitHi, clockhi_IbefLDO_limitLo, clockhi_VaftLDO_warnHi, clockhi_VaftLDO_warnLo, clockhi_VaftLDO_limitHi, clockhi_VaftLDO_limitLo, clockhi_VaftSwch_warnHi, clockhi_VaftSwch_warnLo, clockhi_VaftSwch_limitHi, clockhi_VaftSwch_limitLo, clockhi_VbefLDO_warnHi, clockhi_VbefLDO_warnLo, clockhi_VbefLDO_limitHi, clockhi_VbefLDO_limitLo, clocklo_IaftLDO_warnHi, clocklo_IaftLDO_warnLo, clocklo_IaftLDO_limitHi, clocklo_IaftLDO_limitLo, clocklo_IbefLDO_warnHi, clocklo_IbefLDO_warnLo, clocklo_IbefLDO_limitHi, clocklo_IbefLDO_limitLo, clocklo_VaftLDO2_warnHi, clocklo_VaftLDO2_warnLo, clocklo_VaftLDO2_limitHi, clocklo_VaftLDO2_limitLo, clocklo_VaftLDO_warnHi, clocklo_VaftLDO_warnLo, clocklo_VaftLDO_limitHi, clocklo_VaftLDO_limitLo, clocklo_VaftSwch_warnHi, clocklo_VaftSwch_warnLo, clocklo_VaftSwch_limitHi, clocklo_VaftSwch_limitLo, clocklo_VbefLDO_warnHi, clocklo_VbefLDO_warnLo, clocklo_VbefLDO_limitHi, clocklo_VbefLDO_limitLo, digital_IaftLDO_warnHi, digital_IaftLDO_warnLo, digital_IaftLDO_limitHi, digital_IaftLDO_limitLo, digital_IbefLDO_warnHi, digital_IbefLDO_warnLo, digital_IbefLDO_limitHi, digital_IbefLDO_limitLo, digital_VaftLDO_warnHi, digital_VaftLDO_warnLo, digital_VaftLDO_limitHi, digital_VaftLDO_limitLo, digital_VaftSwch_warnHi, digital_VaftSwch_warnLo, digital_VaftSwch_limitHi, digital_VaftSwch_limitLo, digital_VbefLDO_warnHi, digital_VbefLDO_warnLo, digital_VbefLDO_limitHi, digital_VbefLDO_limitLo, heater_IaftLDO_warnHi, heater_IaftLDO_warnLo, heater_IaftLDO_limitHi, heater_IaftLDO_limitLo, heater_IbefLDO_warnHi, heater_IbefLDO_warnLo, heater_IbefLDO_limitHi, heater_IbefLDO_limitLo, heater_VaftLDO_warnHi, heater_VaftLDO_warnLo, heater_VaftLDO_limitHi, heater_VaftLDO_limitLo, heater_VaftSwch_warnHi, heater_VaftSwch_warnLo, heater_VaftSwch_limitHi, heater_VaftSwch_limitLo, heater_VbefLDO_warnHi, heater_VbefLDO_warnLo, heater_VbefLDO_limitHi, heater_VbefLDO_limitLo, hvbias_IbefSwch_warnHi, hvbias_IbefSwch_limitHi, hvbias_VbefSwch_warnHi, hvbias_VbefSwch_limitHi, location, od_IaftLDO_warnHi, od_IaftLDO_warnLo, od_IaftLDO_limitHi, od_IaftLDO_limitLo, od_IbefLDO_warnHi, od_IbefLDO_warnLo, od_IbefLDO_limitHi, od_IbefLDO_limitLo, od_VaftLDO2_warnHi, od_VaftLDO2_warnLo, od_VaftLDO2_limitHi, od_VaftLDO2_limitLo, od_VaftLDO_warnHi, od_VaftLDO_warnLo, od_VaftLDO_limitHi, od_VaftLDO_limitLo, od_VaftSwch_warnHi, od_VaftSwch_warnLo, od_VaftSwch_limitHi, od_VaftSwch_limitLo, od_VbefLDO_warnHi, od_VbefLDO_warnLo, od_VbefLDO_limitHi, od_VbefLDO_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Reb_LimitsConfigurationEvent));
        Rebpower_Reb_LimitsConfigurationEvent item_ = (Rebpower_Reb_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])analog_IaftLDO_warnHi, (double[])item_.getAnalog_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_warnLo, (double[])item_.getAnalog_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_limitHi, (double[])item_.getAnalog_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_limitLo, (double[])item_.getAnalog_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_warnHi, (double[])item_.getAnalog_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_warnLo, (double[])item_.getAnalog_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_limitHi, (double[])item_.getAnalog_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_limitLo, (double[])item_.getAnalog_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_warnHi, (double[])item_.getAnalog_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_warnLo, (double[])item_.getAnalog_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_limitHi, (double[])item_.getAnalog_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_limitLo, (double[])item_.getAnalog_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_warnHi, (double[])item_.getAnalog_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_warnLo, (double[])item_.getAnalog_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_limitHi, (double[])item_.getAnalog_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_limitLo, (double[])item_.getAnalog_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_warnHi, (double[])item_.getAnalog_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_warnLo, (double[])item_.getAnalog_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_limitHi, (double[])item_.getAnalog_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_limitLo, (double[])item_.getAnalog_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_warnHi, (double[])item_.getClockhi_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_warnLo, (double[])item_.getClockhi_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_limitHi, (double[])item_.getClockhi_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_limitLo, (double[])item_.getClockhi_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_warnHi, (double[])item_.getClockhi_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_warnLo, (double[])item_.getClockhi_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_limitHi, (double[])item_.getClockhi_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_limitLo, (double[])item_.getClockhi_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_warnHi, (double[])item_.getClockhi_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_warnLo, (double[])item_.getClockhi_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_limitHi, (double[])item_.getClockhi_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_limitLo, (double[])item_.getClockhi_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_warnHi, (double[])item_.getClockhi_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_warnLo, (double[])item_.getClockhi_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_limitHi, (double[])item_.getClockhi_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_limitLo, (double[])item_.getClockhi_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_warnHi, (double[])item_.getClockhi_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_warnLo, (double[])item_.getClockhi_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_limitHi, (double[])item_.getClockhi_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_limitLo, (double[])item_.getClockhi_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_warnHi, (double[])item_.getClocklo_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_warnLo, (double[])item_.getClocklo_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_limitHi, (double[])item_.getClocklo_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_limitLo, (double[])item_.getClocklo_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_warnHi, (double[])item_.getClocklo_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_warnLo, (double[])item_.getClocklo_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_limitHi, (double[])item_.getClocklo_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_limitLo, (double[])item_.getClocklo_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_warnHi, (double[])item_.getClocklo_VaftLDO2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_warnLo, (double[])item_.getClocklo_VaftLDO2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_limitHi, (double[])item_.getClocklo_VaftLDO2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_limitLo, (double[])item_.getClocklo_VaftLDO2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_warnHi, (double[])item_.getClocklo_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_warnLo, (double[])item_.getClocklo_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_limitHi, (double[])item_.getClocklo_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_limitLo, (double[])item_.getClocklo_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_warnHi, (double[])item_.getClocklo_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_warnLo, (double[])item_.getClocklo_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_limitHi, (double[])item_.getClocklo_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_limitLo, (double[])item_.getClocklo_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_warnHi, (double[])item_.getClocklo_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_warnLo, (double[])item_.getClocklo_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_limitHi, (double[])item_.getClocklo_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_limitLo, (double[])item_.getClocklo_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_warnHi, (double[])item_.getDigital_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_warnLo, (double[])item_.getDigital_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_limitHi, (double[])item_.getDigital_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_limitLo, (double[])item_.getDigital_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_warnHi, (double[])item_.getDigital_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_warnLo, (double[])item_.getDigital_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_limitHi, (double[])item_.getDigital_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_limitLo, (double[])item_.getDigital_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_warnHi, (double[])item_.getDigital_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_warnLo, (double[])item_.getDigital_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_limitHi, (double[])item_.getDigital_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_limitLo, (double[])item_.getDigital_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_warnHi, (double[])item_.getDigital_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_warnLo, (double[])item_.getDigital_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_limitHi, (double[])item_.getDigital_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_limitLo, (double[])item_.getDigital_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_warnHi, (double[])item_.getDigital_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_warnLo, (double[])item_.getDigital_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_limitHi, (double[])item_.getDigital_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_limitLo, (double[])item_.getDigital_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_warnHi, (double[])item_.getHeater_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_warnLo, (double[])item_.getHeater_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_limitHi, (double[])item_.getHeater_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_limitLo, (double[])item_.getHeater_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_warnHi, (double[])item_.getHeater_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_warnLo, (double[])item_.getHeater_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_limitHi, (double[])item_.getHeater_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_limitLo, (double[])item_.getHeater_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_warnHi, (double[])item_.getHeater_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_warnLo, (double[])item_.getHeater_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_limitHi, (double[])item_.getHeater_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_limitLo, (double[])item_.getHeater_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_warnHi, (double[])item_.getHeater_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_warnLo, (double[])item_.getHeater_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_limitHi, (double[])item_.getHeater_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_limitLo, (double[])item_.getHeater_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_warnHi, (double[])item_.getHeater_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_warnLo, (double[])item_.getHeater_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_limitHi, (double[])item_.getHeater_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_limitLo, (double[])item_.getHeater_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_warnHi, (double[])item_.getHvbias_IbefSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_limitHi, (double[])item_.getHvbias_IbefSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_warnHi, (double[])item_.getHvbias_VbefSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_limitHi, (double[])item_.getHvbias_VbefSwch_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO_warnHi, (double[])item_.getOd_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_warnLo, (double[])item_.getOd_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_limitHi, (double[])item_.getOd_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_limitLo, (double[])item_.getOd_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_warnHi, (double[])item_.getOd_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_warnLo, (double[])item_.getOd_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_limitHi, (double[])item_.getOd_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_limitLo, (double[])item_.getOd_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_warnHi, (double[])item_.getOd_VaftLDO2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_warnLo, (double[])item_.getOd_VaftLDO2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_limitHi, (double[])item_.getOd_VaftLDO2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_limitLo, (double[])item_.getOd_VaftLDO2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_warnHi, (double[])item_.getOd_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_warnLo, (double[])item_.getOd_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_limitHi, (double[])item_.getOd_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_limitLo, (double[])item_.getOd_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_warnHi, (double[])item_.getOd_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_warnLo, (double[])item_.getOd_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_limitHi, (double[])item_.getOd_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_limitLo, (double[])item_.getOd_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_warnHi, (double[])item_.getOd_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_warnLo, (double[])item_.getOd_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_limitHi, (double[])item_.getOd_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_limitLo, (double[])item_.getOd_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnHi, (double[])item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnLo, (double[])item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitHi, (double[])item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitLo, (double[])item_.getPower_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_Rebps_DevicesConfigurationEvent() throws Exception {
        String version = "e";
        boolean[] disabled = new boolean[]{true};
        String location = "z";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_DevicesConfigurationEvent(version, disabled, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_DevicesConfigurationEvent));
        Rebpower_Rebps_DevicesConfigurationEvent item_ = (Rebpower_Rebps_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((boolean[])disabled, (boolean[])item_.getDisabled());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveRebpower_Rebps_GeneralConfigurationEvent() throws Exception {
        String version = "y";
        String location = "";
        String rebs = "";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_GeneralConfigurationEvent(version, location, rebs));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_GeneralConfigurationEvent));
        Rebpower_Rebps_GeneralConfigurationEvent item_ = (Rebpower_Rebps_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)rebs, (Object)item_.getRebs());
    }

    @Test
    public void sendReceiveRebpower_Rebps_LimitsConfigurationEvent() throws Exception {
        String version = "h";
        double[] boardtemp0_warnHi = TestHelper.generateDoubleArray((int)1, (int)120885540);
        double[] boardtemp0_warnLo = TestHelper.generateDoubleArray((int)1, (int)1641568725);
        double[] boardtemp0_limitHi = TestHelper.generateDoubleArray((int)1, (int)525213633);
        double[] boardtemp0_limitLo = TestHelper.generateDoubleArray((int)1, (int)-114569370);
        double[] boardtemp1_warnHi = TestHelper.generateDoubleArray((int)1, (int)1635378746);
        double[] boardtemp1_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1344745010);
        double[] boardtemp1_limitHi = TestHelper.generateDoubleArray((int)1, (int)-1661233251);
        double[] boardtemp1_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1747330230);
        double[] boardtemp2_warnHi = TestHelper.generateDoubleArray((int)1, (int)952036078);
        double[] boardtemp2_warnLo = TestHelper.generateDoubleArray((int)1, (int)203709381);
        double[] boardtemp2_limitHi = TestHelper.generateDoubleArray((int)1, (int)-1624753699);
        double[] boardtemp2_limitLo = TestHelper.generateDoubleArray((int)1, (int)541512625);
        double[] boardtemp3_warnHi = TestHelper.generateDoubleArray((int)1, (int)1776612664);
        double[] boardtemp3_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1419094134);
        double[] boardtemp3_limitHi = TestHelper.generateDoubleArray((int)1, (int)283344703);
        double[] boardtemp3_limitLo = TestHelper.generateDoubleArray((int)1, (int)76585643);
        double[] boardtemp4_warnHi = TestHelper.generateDoubleArray((int)1, (int)1850698118);
        double[] boardtemp4_warnLo = TestHelper.generateDoubleArray((int)1, (int)-2142329768);
        double[] boardtemp4_limitHi = TestHelper.generateDoubleArray((int)1, (int)1925909);
        double[] boardtemp4_limitLo = TestHelper.generateDoubleArray((int)1, (int)313495599);
        double[] boardtemp5_warnHi = TestHelper.generateDoubleArray((int)1, (int)608773328);
        double[] boardtemp5_warnLo = TestHelper.generateDoubleArray((int)1, (int)-833240229);
        double[] boardtemp5_limitHi = TestHelper.generateDoubleArray((int)1, (int)-1662800513);
        double[] boardtemp5_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1305877954);
        double[] boardtemp6_warnHi = TestHelper.generateDoubleArray((int)1, (int)1200485353);
        double[] boardtemp6_warnLo = TestHelper.generateDoubleArray((int)1, (int)-686678415);
        double[] boardtemp6_limitHi = TestHelper.generateDoubleArray((int)1, (int)-672322340);
        double[] boardtemp6_limitLo = TestHelper.generateDoubleArray((int)1, (int)166280007);
        double[] fpgatemp_warnHi = TestHelper.generateDoubleArray((int)1, (int)69446680);
        double[] fpgatemp_warnLo = TestHelper.generateDoubleArray((int)1, (int)1830319924);
        double[] fpgatemp_limitHi = TestHelper.generateDoubleArray((int)1, (int)1612354173);
        double[] fpgatemp_limitLo = TestHelper.generateDoubleArray((int)1, (int)1146254029);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_LimitsConfigurationEvent(version, boardtemp0_warnHi, boardtemp0_warnLo, boardtemp0_limitHi, boardtemp0_limitLo, boardtemp1_warnHi, boardtemp1_warnLo, boardtemp1_limitHi, boardtemp1_limitLo, boardtemp2_warnHi, boardtemp2_warnLo, boardtemp2_limitHi, boardtemp2_limitLo, boardtemp3_warnHi, boardtemp3_warnLo, boardtemp3_limitHi, boardtemp3_limitLo, boardtemp4_warnHi, boardtemp4_warnLo, boardtemp4_limitHi, boardtemp4_limitLo, boardtemp5_warnHi, boardtemp5_warnLo, boardtemp5_limitHi, boardtemp5_limitLo, boardtemp6_warnHi, boardtemp6_warnLo, boardtemp6_limitHi, boardtemp6_limitLo, fpgatemp_warnHi, fpgatemp_warnLo, fpgatemp_limitHi, fpgatemp_limitLo, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_LimitsConfigurationEvent));
        Rebpower_Rebps_LimitsConfigurationEvent item_ = (Rebpower_Rebps_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])boardtemp0_warnHi, (double[])item_.getBoardtemp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_warnLo, (double[])item_.getBoardtemp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_limitHi, (double[])item_.getBoardtemp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_limitLo, (double[])item_.getBoardtemp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_warnHi, (double[])item_.getBoardtemp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_warnLo, (double[])item_.getBoardtemp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_limitHi, (double[])item_.getBoardtemp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_limitLo, (double[])item_.getBoardtemp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_warnHi, (double[])item_.getBoardtemp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_warnLo, (double[])item_.getBoardtemp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_limitHi, (double[])item_.getBoardtemp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_limitLo, (double[])item_.getBoardtemp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_warnHi, (double[])item_.getBoardtemp3_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_warnLo, (double[])item_.getBoardtemp3_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_limitHi, (double[])item_.getBoardtemp3_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_limitLo, (double[])item_.getBoardtemp3_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_warnHi, (double[])item_.getBoardtemp4_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_warnLo, (double[])item_.getBoardtemp4_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_limitHi, (double[])item_.getBoardtemp4_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_limitLo, (double[])item_.getBoardtemp4_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_warnHi, (double[])item_.getBoardtemp5_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_warnLo, (double[])item_.getBoardtemp5_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_limitHi, (double[])item_.getBoardtemp5_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_limitLo, (double[])item_.getBoardtemp5_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_warnHi, (double[])item_.getBoardtemp6_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_warnLo, (double[])item_.getBoardtemp6_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_limitHi, (double[])item_.getBoardtemp6_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_limitLo, (double[])item_.getBoardtemp6_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fpgatemp_warnHi, (double[])item_.getFpgatemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fpgatemp_warnLo, (double[])item_.getFpgatemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fpgatemp_limitHi, (double[])item_.getFpgatemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fpgatemp_limitLo, (double[])item_.getFpgatemp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveRebpower_Rebps_PowerConfigurationEvent() throws Exception {
        String version = "";
        String ipAddr = "z";
        String location = "";
        int[] nPowerOnPub = TestHelper.generateIntArray((int)1, (int)-1291783535);
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_PowerConfigurationEvent(version, ipAddr, location, nPowerOnPub));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_PowerConfigurationEvent));
        Rebpower_Rebps_PowerConfigurationEvent item_ = (Rebpower_Rebps_PowerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)ipAddr, (Object)item_.getIpAddr());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((int[])nPowerOnPub, (int[])item_.getNPowerOnPub());
    }

    @Test
    public void sendReceiveRebpower_Rebps_buildConfigurationEvent() throws Exception {
        String version = "";
        String location = "x";
        String switchName = "r";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_buildConfigurationEvent(version, location, switchName));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_buildConfigurationEvent));
        Rebpower_Rebps_buildConfigurationEvent item_ = (Rebpower_Rebps_buildConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)switchName, (Object)item_.getSwitchName());
    }

    @Test
    public void sendReceiveVacuum_Cold1_CryoconConfigurationEvent() throws Exception {
        String version = "b";
        double d_gain = 0.6161421537399292;
        double i_gain = 0.6513291001319885;
        double p_gain = 0.7912827730178833;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cold1_CryoconConfigurationEvent(version, d_gain, i_gain, p_gain));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold1_CryoconConfigurationEvent));
        Vacuum_Cold1_CryoconConfigurationEvent item_ = (Vacuum_Cold1_CryoconConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)d_gain, (double)item_.getD_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)i_gain, (double)item_.getI_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)p_gain, (double)item_.getP_gain(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold1_DevicesConfigurationEvent() throws Exception {
        String version = "r";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cold1_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold1_DevicesConfigurationEvent));
        Vacuum_Cold1_DevicesConfigurationEvent item_ = (Vacuum_Cold1_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_Cold1_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double autooffenabled_warnHi = 0.7123373746871948;
        double autooffenabled_warnLo = 0.2191150188446045;
        double autooffenabled_limitHi = 0.5070011615753174;
        double autooffenabled_limitLo = 0.40193772315979004;
        double autoofftemperature_warnHi = 0.3482709527015686;
        double autoofftemperature_warnLo = 0.90446937084198;
        double autoofftemperature_limitHi = 0.5560566782951355;
        double autoofftemperature_limitLo = 0.02749556303024292;
        double autoontemperature_warnHi = 0.08437883853912354;
        double autoontemperature_warnLo = 0.7347772717475891;
        double autoontemperature_limitHi = 0.8349572420120239;
        double autoontemperature_limitLo = 0.05315440893173218;
        double power_warnHi = 0.8198965191841125;
        double power_warnLo = 0.5077343583106995;
        double power_limitHi = 0.7708647847175598;
        double power_limitLo = 0.2524857521057129;
        double rejecttemperature_warnHi = 0.9283267855644226;
        double rejecttemperature_warnLo = 0.4557059407234192;
        double rejecttemperature_limitHi = 0.08200287818908691;
        double rejecttemperature_limitLo = 0.8293628096580505;
        double setpower_warnHi = 0.8970068693161011;
        double setpower_warnLo = 0.2322337031364441;
        double setpower_limitHi = 0.659993f;
        double setpower_limitLo = 0.9325717687606812;
        double setpoint_warnHi = 0.4854145050048828;
        double setpoint_warnLo = 0.18520653247833252;
        double setpoint_limitHi = 0.35989898443222046;
        double setpoint_limitLo = 0.22506767511367798;
        double temp_Min_OFF = 0.14500826597213745;
        double temp_Min_ON = 0.10195744037628174;
        double temperature_warnHi = 0.7472650408744812;
        double temperature_warnLo = 0.7284701466560364;
        double temperature_limitHi = 0.5455885529518127;
        double temperature_limitLo = 0.8110129237174988;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cold1_LimitsConfigurationEvent(version, autooffenabled_warnHi, autooffenabled_warnLo, autooffenabled_limitHi, autooffenabled_limitLo, autoofftemperature_warnHi, autoofftemperature_warnLo, autoofftemperature_limitHi, autoofftemperature_limitLo, autoontemperature_warnHi, autoontemperature_warnLo, autoontemperature_limitHi, autoontemperature_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo, rejecttemperature_warnHi, rejecttemperature_warnLo, rejecttemperature_limitHi, rejecttemperature_limitLo, setpower_warnHi, setpower_warnLo, setpower_limitHi, setpower_limitLo, setpoint_warnHi, setpoint_warnLo, setpoint_limitHi, setpoint_limitLo, temp_Min_OFF, temp_Min_ON, temperature_warnHi, temperature_warnLo, temperature_limitHi, temperature_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold1_LimitsConfigurationEvent));
        Vacuum_Cold1_LimitsConfigurationEvent item_ = (Vacuum_Cold1_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)autooffenabled_warnHi, (double)item_.getAutooffenabled_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_warnLo, (double)item_.getAutooffenabled_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_limitHi, (double)item_.getAutooffenabled_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_limitLo, (double)item_.getAutooffenabled_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_warnHi, (double)item_.getAutoofftemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_warnLo, (double)item_.getAutoofftemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_limitHi, (double)item_.getAutoofftemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_limitLo, (double)item_.getAutoofftemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_warnHi, (double)item_.getAutoontemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_warnLo, (double)item_.getAutoontemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_limitHi, (double)item_.getAutoontemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_limitLo, (double)item_.getAutoontemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)power_warnHi, (double)item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)power_warnLo, (double)item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)power_limitHi, (double)item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)power_limitLo, (double)item_.getPower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_warnHi, (double)item_.getRejecttemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_warnLo, (double)item_.getRejecttemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_limitHi, (double)item_.getRejecttemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_limitLo, (double)item_.getRejecttemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_warnHi, (double)item_.getSetpower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_warnLo, (double)item_.getSetpower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_limitHi, (double)item_.getSetpower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_limitLo, (double)item_.getSetpower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_warnHi, (double)item_.getSetpoint_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_warnLo, (double)item_.getSetpoint_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_limitHi, (double)item_.getSetpoint_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_limitLo, (double)item_.getSetpoint_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temp_Min_OFF, (double)item_.getTemp_Min_OFF(), (double)1.0E-6f);
        Assert.assertEquals((double)temp_Min_ON, (double)item_.getTemp_Min_ON(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_warnHi, (double)item_.getTemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_warnLo, (double)item_.getTemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_limitHi, (double)item_.getTemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_limitLo, (double)item_.getTemperature_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold2_CryoconConfigurationEvent() throws Exception {
        String version = "";
        double d_gain = 0.7421621084213257;
        double i_gain = 0.09804767370223999;
        double p_gain = 0.4464316964149475;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cold2_CryoconConfigurationEvent(version, d_gain, i_gain, p_gain));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold2_CryoconConfigurationEvent));
        Vacuum_Cold2_CryoconConfigurationEvent item_ = (Vacuum_Cold2_CryoconConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)d_gain, (double)item_.getD_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)i_gain, (double)item_.getI_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)p_gain, (double)item_.getP_gain(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold2_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cold2_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold2_DevicesConfigurationEvent));
        Vacuum_Cold2_DevicesConfigurationEvent item_ = (Vacuum_Cold2_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_Cold2_LimitsConfigurationEvent() throws Exception {
        String version = "w";
        double autooffenabled_warnHi = 0.8688523173332214;
        double autooffenabled_warnLo = 0.05147433280944824;
        double autooffenabled_limitHi = 0.7004167437553406;
        double autooffenabled_limitLo = 0.6102726459503174;
        double autoofftemperature_warnHi = 0.16373854875564575;
        double autoofftemperature_warnLo = 0.2257222f;
        double autoofftemperature_limitHi = 0.6810241937637329;
        double autoofftemperature_limitLo = 0.1661999225616455;
        double autoontemperature_warnHi = 0.9088693857192993;
        double autoontemperature_warnLo = 0.11945706605911255;
        double autoontemperature_limitHi = 0.2741441f;
        double autoontemperature_limitLo = 0.766837f;
        double power_warnHi = 0.7217692732810974;
        double power_warnLo = 0.5272254347801208;
        double power_limitHi = 0.7229553461074829;
        double power_limitLo = 0.9956062436103821;
        double rejecttemperature_warnHi = 0.9965223670005798;
        double rejecttemperature_warnLo = 0.14721661806106567;
        double rejecttemperature_limitHi = 0.4042872190475464;
        double rejecttemperature_limitLo = 0.6199347376823425;
        double setpower_warnHi = 0.746765673160553;
        double setpower_warnLo = 0.9629706144332886;
        double setpower_limitHi = 0.8263643383979797;
        double setpower_limitLo = 0.6142929196357727;
        double setpoint_warnHi = 0.6880226731300354;
        double setpoint_warnLo = 0.6466214656829834;
        double setpoint_limitHi = 0.6851903200149536;
        double setpoint_limitLo = 0.41917216777801514;
        double temp_Min_OFF = 0.5601454377174377;
        double temp_Min_ON = 0.33406996726989746;
        double temperature_warnHi = 0.5312292575836182;
        double temperature_warnLo = 0.7347690463066101;
        double temperature_limitHi = 0.36329346895217896;
        double temperature_limitLo = 0.4870149f;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cold2_LimitsConfigurationEvent(version, autooffenabled_warnHi, autooffenabled_warnLo, autooffenabled_limitHi, autooffenabled_limitLo, autoofftemperature_warnHi, autoofftemperature_warnLo, autoofftemperature_limitHi, autoofftemperature_limitLo, autoontemperature_warnHi, autoontemperature_warnLo, autoontemperature_limitHi, autoontemperature_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo, rejecttemperature_warnHi, rejecttemperature_warnLo, rejecttemperature_limitHi, rejecttemperature_limitLo, setpower_warnHi, setpower_warnLo, setpower_limitHi, setpower_limitLo, setpoint_warnHi, setpoint_warnLo, setpoint_limitHi, setpoint_limitLo, temp_Min_OFF, temp_Min_ON, temperature_warnHi, temperature_warnLo, temperature_limitHi, temperature_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold2_LimitsConfigurationEvent));
        Vacuum_Cold2_LimitsConfigurationEvent item_ = (Vacuum_Cold2_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)autooffenabled_warnHi, (double)item_.getAutooffenabled_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_warnLo, (double)item_.getAutooffenabled_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_limitHi, (double)item_.getAutooffenabled_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_limitLo, (double)item_.getAutooffenabled_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_warnHi, (double)item_.getAutoofftemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_warnLo, (double)item_.getAutoofftemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_limitHi, (double)item_.getAutoofftemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_limitLo, (double)item_.getAutoofftemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_warnHi, (double)item_.getAutoontemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_warnLo, (double)item_.getAutoontemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_limitHi, (double)item_.getAutoontemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_limitLo, (double)item_.getAutoontemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)power_warnHi, (double)item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)power_warnLo, (double)item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)power_limitHi, (double)item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)power_limitLo, (double)item_.getPower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_warnHi, (double)item_.getRejecttemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_warnLo, (double)item_.getRejecttemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_limitHi, (double)item_.getRejecttemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_limitLo, (double)item_.getRejecttemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_warnHi, (double)item_.getSetpower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_warnLo, (double)item_.getSetpower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_limitHi, (double)item_.getSetpower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_limitLo, (double)item_.getSetpower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_warnHi, (double)item_.getSetpoint_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_warnLo, (double)item_.getSetpoint_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_limitHi, (double)item_.getSetpoint_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_limitLo, (double)item_.getSetpoint_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temp_Min_OFF, (double)item_.getTemp_Min_OFF(), (double)1.0E-6f);
        Assert.assertEquals((double)temp_Min_ON, (double)item_.getTemp_Min_ON(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_warnHi, (double)item_.getTemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_warnLo, (double)item_.getTemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_limitHi, (double)item_.getTemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_limitLo, (double)item_.getTemperature_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cryo_CryoconConfigurationEvent() throws Exception {
        String version = "";
        double d_gain = 0.6373441815376282;
        double i_gain = 0.6345996856689453;
        double p_gain = 0.276350736618042;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cryo_CryoconConfigurationEvent(version, d_gain, i_gain, p_gain));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cryo_CryoconConfigurationEvent));
        Vacuum_Cryo_CryoconConfigurationEvent item_ = (Vacuum_Cryo_CryoconConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)d_gain, (double)item_.getD_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)i_gain, (double)item_.getI_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)p_gain, (double)item_.getP_gain(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cryo_DevicesConfigurationEvent() throws Exception {
        String version = "v";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cryo_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cryo_DevicesConfigurationEvent));
        Vacuum_Cryo_DevicesConfigurationEvent item_ = (Vacuum_Cryo_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_Cryo_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double autooffenabled_warnHi = 0.2018665075302124;
        double autooffenabled_warnLo = 0.8623965978622437;
        double autooffenabled_limitHi = 0.2078021764755249;
        double autooffenabled_limitLo = 0.027436554431915283;
        double autoofftemperature_warnHi = 0.3213622570037842;
        double autoofftemperature_warnLo = 0.8489788770675659;
        double autoofftemperature_limitHi = 0.17418742179870605;
        double autoofftemperature_limitLo = 0.08984065055847168;
        double autoontemperature_warnHi = 0.4241867661476135;
        double autoontemperature_warnLo = 0.9418308734893799;
        double autoontemperature_limitHi = 0.9684880375862122;
        double autoontemperature_limitLo = 0.9527187347412109;
        double power_warnHi = 0.18455815315246582;
        double power_warnLo = 0.6065274477005005;
        double power_limitHi = 0.4981291890144348;
        double power_limitLo = 0.8888053894042969;
        double rejecttemperature_warnHi = 0.24716395139694214;
        double rejecttemperature_warnLo = 0.18402493000030518;
        double rejecttemperature_limitHi = 0.9244294762611389;
        double rejecttemperature_limitLo = 0.7530982494354248;
        double setpower_warnHi = 0.6354634165763855;
        double setpower_warnLo = 0.11419862508773804;
        double setpower_limitHi = 0.06763821840286255;
        double setpower_limitLo = 0.15208107233047485;
        double setpoint_warnHi = 0.502015f;
        double setpoint_warnLo = 0.4687958359718323;
        double setpoint_limitHi = 0.2776569128036499;
        double setpoint_limitLo = 0.8017957806587219;
        double temp_Min_OFF = 0.646397590637207;
        double temp_Min_ON = 0.11037266254425049;
        double temperature_warnHi = 0.4113478f;
        double temperature_warnLo = 0.2250347137451172;
        double temperature_limitHi = 0.3065752387046814;
        double temperature_limitLo = 0.4486308693885803;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cryo_LimitsConfigurationEvent(version, autooffenabled_warnHi, autooffenabled_warnLo, autooffenabled_limitHi, autooffenabled_limitLo, autoofftemperature_warnHi, autoofftemperature_warnLo, autoofftemperature_limitHi, autoofftemperature_limitLo, autoontemperature_warnHi, autoontemperature_warnLo, autoontemperature_limitHi, autoontemperature_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo, rejecttemperature_warnHi, rejecttemperature_warnLo, rejecttemperature_limitHi, rejecttemperature_limitLo, setpower_warnHi, setpower_warnLo, setpower_limitHi, setpower_limitLo, setpoint_warnHi, setpoint_warnLo, setpoint_limitHi, setpoint_limitLo, temp_Min_OFF, temp_Min_ON, temperature_warnHi, temperature_warnLo, temperature_limitHi, temperature_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cryo_LimitsConfigurationEvent));
        Vacuum_Cryo_LimitsConfigurationEvent item_ = (Vacuum_Cryo_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)autooffenabled_warnHi, (double)item_.getAutooffenabled_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_warnLo, (double)item_.getAutooffenabled_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_limitHi, (double)item_.getAutooffenabled_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_limitLo, (double)item_.getAutooffenabled_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_warnHi, (double)item_.getAutoofftemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_warnLo, (double)item_.getAutoofftemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_limitHi, (double)item_.getAutoofftemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_limitLo, (double)item_.getAutoofftemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_warnHi, (double)item_.getAutoontemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_warnLo, (double)item_.getAutoontemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_limitHi, (double)item_.getAutoontemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_limitLo, (double)item_.getAutoontemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)power_warnHi, (double)item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)power_warnLo, (double)item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)power_limitHi, (double)item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)power_limitLo, (double)item_.getPower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_warnHi, (double)item_.getRejecttemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_warnLo, (double)item_.getRejecttemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_limitHi, (double)item_.getRejecttemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_limitLo, (double)item_.getRejecttemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_warnHi, (double)item_.getSetpower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_warnLo, (double)item_.getSetpower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_limitHi, (double)item_.getSetpower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_limitLo, (double)item_.getSetpower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_warnHi, (double)item_.getSetpoint_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_warnLo, (double)item_.getSetpoint_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_limitHi, (double)item_.getSetpoint_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_limitLo, (double)item_.getSetpoint_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temp_Min_OFF, (double)item_.getTemp_Min_OFF(), (double)1.0E-6f);
        Assert.assertEquals((double)temp_Min_ON, (double)item_.getTemp_Min_ON(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_warnHi, (double)item_.getTemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_warnLo, (double)item_.getTemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_limitHi, (double)item_.getTemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_limitLo, (double)item_.getTemperature_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_IonPumps_CryoConfigurationEvent() throws Exception {
        String version = "i";
        double cip1c_current = 0.511311f;
        double cip1c_power = 0.8501695990562439;
        double cip1c_voltage = 0.10861527919769287;
        String ipAddr = "";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_IonPumps_CryoConfigurationEvent(version, cip1c_current, cip1c_power, cip1c_voltage, ipAddr));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumps_CryoConfigurationEvent));
        Vacuum_IonPumps_CryoConfigurationEvent item_ = (Vacuum_IonPumps_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cip1c_current, (double)item_.getCip1c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)cip1c_power, (double)item_.getCip1c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)cip1c_voltage, (double)item_.getCip1c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((Object)ipAddr, (Object)item_.getIpAddr());
    }

    @Test
    public void sendReceiveVacuum_IonPumps_DevicesConfigurationEvent() throws Exception {
        String version = "e";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_IonPumps_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumps_DevicesConfigurationEvent));
        Vacuum_IonPumps_DevicesConfigurationEvent item_ = (Vacuum_IonPumps_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_IonPumps_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double current_warnHi = 0.6954838037490845;
        double current_warnLo = 0.11287665367126465;
        double current_limitHi = 0.674673318862915;
        double current_limitLo = 0.06375402212142944;
        double voltage_warnHi = 0.5577300786972046;
        double voltage_warnLo = 0.0346936f;
        double voltage_limitHi = 0.25591927766799927;
        double voltage_limitLo = 0.861728f;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_IonPumps_LimitsConfigurationEvent(version, current_warnHi, current_warnLo, current_limitHi, current_limitLo, voltage_warnHi, voltage_warnLo, voltage_limitHi, voltage_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumps_LimitsConfigurationEvent));
        Vacuum_IonPumps_LimitsConfigurationEvent item_ = (Vacuum_IonPumps_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)current_warnHi, (double)item_.getCurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)current_warnLo, (double)item_.getCurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)current_limitHi, (double)item_.getCurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)current_limitLo, (double)item_.getCurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage_warnHi, (double)item_.getVoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage_warnLo, (double)item_.getVoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage_limitHi, (double)item_.getVoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage_limitLo, (double)item_.getVoltage_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "u";
        int schedulers_default_nTasks = 476;
        int schedulers_default_nThreads = 490;
        int schedulers_monitor_update_publish_scheduler_nTasks = 557;
        int schedulers_monitor_update_publish_scheduler_nThreads = 366;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PeriodicTasks_GeneralConfigurationEvent));
        Vacuum_PeriodicTasks_GeneralConfigurationEvent item_ = (Vacuum_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveVacuum_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "b";
        long agentmonitorservice_taskPeriodMillis = 565L;
        long heartbeat_taskPeriodMillis = 106L;
        long monitor_check_taskPeriodMillis = 583L;
        long monitor_publish_taskPeriodMillis = 249L;
        long monitor_update_taskPeriodMillis = 267L;
        long runtimeinfo_taskPeriodMillis = 515L;
        long vacuum_state_taskPeriodMillis = 222L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis, vacuum_state_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PeriodicTasks_timersConfigurationEvent));
        Vacuum_PeriodicTasks_timersConfigurationEvent item_ = (Vacuum_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)vacuum_state_taskPeriodMillis, (long)item_.getVacuum_state_taskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_Rtds_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String node = "";
        String serials = "";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Rtds_DeviceConfigurationEvent(version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Rtds_DeviceConfigurationEvent));
        Vacuum_Rtds_DeviceConfigurationEvent item_ = (Vacuum_Rtds_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveVacuum_Rtds_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Rtds_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Rtds_DevicesConfigurationEvent));
        Vacuum_Rtds_DevicesConfigurationEvent item_ = (Vacuum_Rtds_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_Rtds_LimitsConfigurationEvent() throws Exception {
        String version = "l";
        double temperaturecold1_warnHi = 0.18191653490066528;
        double temperaturecold1_warnLo = 0.16838771104812622;
        double temperaturecold1_limitHi = 0.9623038172721863;
        double temperaturecold1_limitLo = 0.15011334419250488;
        double temperaturecold2_warnHi = 0.48530107736587524;
        double temperaturecold2_warnLo = 0.4137721657752991;
        double temperaturecold2_limitHi = 0.0766598f;
        double temperaturecold2_limitLo = 0.7253578305244446;
        double temperaturecryo_warnHi = 0.1221545934677124;
        double temperaturecryo_warnLo = 0.779416024684906;
        double temperaturecryo_limitHi = 0.2768756151199341;
        double temperaturecryo_limitLo = 0.4441349506378174;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Rtds_LimitsConfigurationEvent(version, temperaturecold1_warnHi, temperaturecold1_warnLo, temperaturecold1_limitHi, temperaturecold1_limitLo, temperaturecold2_warnHi, temperaturecold2_warnLo, temperaturecold2_limitHi, temperaturecold2_limitLo, temperaturecryo_warnHi, temperaturecryo_warnLo, temperaturecryo_limitHi, temperaturecryo_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Rtds_LimitsConfigurationEvent));
        Vacuum_Rtds_LimitsConfigurationEvent item_ = (Vacuum_Rtds_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)temperaturecold1_warnHi, (double)item_.getTemperaturecold1_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecold1_warnLo, (double)item_.getTemperaturecold1_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecold1_limitHi, (double)item_.getTemperaturecold1_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecold1_limitLo, (double)item_.getTemperaturecold1_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecold2_warnHi, (double)item_.getTemperaturecold2_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecold2_warnLo, (double)item_.getTemperaturecold2_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecold2_limitHi, (double)item_.getTemperaturecold2_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecold2_limitLo, (double)item_.getTemperaturecold2_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecryo_warnHi, (double)item_.getTemperaturecryo_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecryo_warnLo, (double)item_.getTemperaturecryo_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecryo_limitHi, (double)item_.getTemperaturecryo_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecryo_limitLo, (double)item_.getTemperaturecryo_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Turbo_DevicesConfigurationEvent() throws Exception {
        String version = "g";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Turbo_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Turbo_DevicesConfigurationEvent));
        Vacuum_Turbo_DevicesConfigurationEvent item_ = (Vacuum_Turbo_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_Turbo_GeneralConfigurationEvent() throws Exception {
        String version = "a";
        boolean activeStopMode = false;
        String devcId = "x";
        boolean interlockType = true;
        boolean lowSpeedMode = false;
        boolean model304 = false;
        boolean softStartMode = false;
        boolean ventValveByCmnd = false;
        boolean waterCooling = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Turbo_GeneralConfigurationEvent(version, activeStopMode, devcId, interlockType, lowSpeedMode, model304, softStartMode, ventValveByCmnd, waterCooling));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Turbo_GeneralConfigurationEvent));
        Vacuum_Turbo_GeneralConfigurationEvent item_ = (Vacuum_Turbo_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)activeStopMode, (Object)item_.isActiveStopMode());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((Object)interlockType, (Object)item_.isInterlockType());
        Assert.assertEquals((Object)lowSpeedMode, (Object)item_.isLowSpeedMode());
        Assert.assertEquals((Object)model304, (Object)item_.isModel304());
        Assert.assertEquals((Object)softStartMode, (Object)item_.isSoftStartMode());
        Assert.assertEquals((Object)ventValveByCmnd, (Object)item_.isVentValveByCmnd());
        Assert.assertEquals((Object)waterCooling, (Object)item_.isWaterCooling());
    }

    @Test
    public void sendReceiveVacuum_Turbo_LimitsConfigurationEvent() throws Exception {
        String version = "o";
        double cntrlrairtemperature_warnHi = 0.30979394912719727;
        double cntrlrairtemperature_warnLo = 0.21112632751464844;
        double cntrlrairtemperature_limitHi = 0.3359434f;
        double cntrlrairtemperature_limitLo = 0.147347092628479;
        double cntrlrsinktemperature_warnHi = 0.9024807214736938;
        double cntrlrsinktemperature_warnLo = 0.9873150587081909;
        double cntrlrsinktemperature_limitHi = 0.7804882526397705;
        double cntrlrsinktemperature_limitLo = 0.21205365657806396;
        double power_warnHi = 0.19770705699920654;
        double power_limitHi = 0.0017998814582824707;
        double pumptemperature_warnHi = 0.893978476524353;
        double pumptemperature_warnLo = 0.5026865005493164;
        double pumptemperature_limitHi = 0.2176659107208252;
        double pumptemperature_limitLo = 0.6090694069862366;
        double status_warnHi = 0.9734766483306885;
        double status_warnLo = 0.8928537964820862;
        double status_limitHi = 0.0497211217880249;
        double status_limitLo = 0.2681116461753845;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Turbo_LimitsConfigurationEvent(version, cntrlrairtemperature_warnHi, cntrlrairtemperature_warnLo, cntrlrairtemperature_limitHi, cntrlrairtemperature_limitLo, cntrlrsinktemperature_warnHi, cntrlrsinktemperature_warnLo, cntrlrsinktemperature_limitHi, cntrlrsinktemperature_limitLo, power_warnHi, power_limitHi, pumptemperature_warnHi, pumptemperature_warnLo, pumptemperature_limitHi, pumptemperature_limitLo, status_warnHi, status_warnLo, status_limitHi, status_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Turbo_LimitsConfigurationEvent));
        Vacuum_Turbo_LimitsConfigurationEvent item_ = (Vacuum_Turbo_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cntrlrairtemperature_warnHi, (double)item_.getCntrlrairtemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrairtemperature_warnLo, (double)item_.getCntrlrairtemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrairtemperature_limitHi, (double)item_.getCntrlrairtemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrairtemperature_limitLo, (double)item_.getCntrlrairtemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrsinktemperature_warnHi, (double)item_.getCntrlrsinktemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrsinktemperature_warnLo, (double)item_.getCntrlrsinktemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrsinktemperature_limitHi, (double)item_.getCntrlrsinktemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrsinktemperature_limitLo, (double)item_.getCntrlrsinktemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)power_warnHi, (double)item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)power_limitHi, (double)item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumptemperature_warnHi, (double)item_.getPumptemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumptemperature_warnLo, (double)item_.getPumptemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumptemperature_limitHi, (double)item_.getPumptemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumptemperature_limitLo, (double)item_.getPumptemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)status_warnHi, (double)item_.getStatus_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)status_warnLo, (double)item_.getStatus_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)status_limitHi, (double)item_.getStatus_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)status_limitLo, (double)item_.getStatus_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_VQMonitor_CryoConfigurationEvent() throws Exception {
        String version = "r";
        int busAddr = 711;
        String devcId = "z";
        double[] relayTrip = TestHelper.generateDoubleArray((int)3, (int)1082463136);
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VQMonitor_CryoConfigurationEvent(version, busAddr, devcId, relayTrip));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VQMonitor_CryoConfigurationEvent));
        Vacuum_VQMonitor_CryoConfigurationEvent item_ = (Vacuum_VQMonitor_CryoConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertArrayEquals((double[])relayTrip, (double[])item_.getRelayTrip(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_VQMonitor_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VQMonitor_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VQMonitor_DevicesConfigurationEvent));
        Vacuum_VQMonitor_DevicesConfigurationEvent item_ = (Vacuum_VQMonitor_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_VQMonitor_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double vqmpressure_warnHi = 0.35309863090515137;
        double vqmpressure_warnLo = 0.937881f;
        double vqmpressure_limitHi = 0.7643618583679199;
        double vqmpressure_limitLo = 0.35663992166519165;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VQMonitor_LimitsConfigurationEvent(version, vqmpressure_warnHi, vqmpressure_warnLo, vqmpressure_limitHi, vqmpressure_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VQMonitor_LimitsConfigurationEvent));
        Vacuum_VQMonitor_LimitsConfigurationEvent item_ = (Vacuum_VQMonitor_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)vqmpressure_warnHi, (double)item_.getVqmpressure_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vqmpressure_warnLo, (double)item_.getVqmpressure_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vqmpressure_limitHi, (double)item_.getVqmpressure_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vqmpressure_limitLo, (double)item_.getVqmpressure_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_VacPluto_DeviceConfigurationEvent() throws Exception {
        String version = "z";
        String node = "j";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VacPluto_DeviceConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VacPluto_DeviceConfigurationEvent));
        Vacuum_VacPluto_DeviceConfigurationEvent item_ = (Vacuum_VacPluto_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
    }

    @Test
    public void sendReceiveVacuum_VacPluto_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VacPluto_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VacPluto_DevicesConfigurationEvent));
        Vacuum_VacPluto_DevicesConfigurationEvent item_ = (Vacuum_VacPluto_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveVacuum_VacuumConfigurationEvent() throws Exception {
        String version = "";
        double minVatOpenPress = 0.8843053579330444;
        double pressDiffHigh = 0.9963942170143127;
        double pressDiffLow = 0.4767602f;
        double pressForelineLow = 0.7324386835098267;
        double pressIonEnable = 0.0687408447265625;
        double pressIonOff = 0.14175671339035034;
        double pressTurboLow = 0.2010408f;
        double pressVacuum = 0.16168522834777832;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VacuumConfigurationEvent(version, minVatOpenPress, pressDiffHigh, pressDiffLow, pressForelineLow, pressIonEnable, pressIonOff, pressTurboLow, pressVacuum));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VacuumConfigurationEvent));
        Vacuum_VacuumConfigurationEvent item_ = (Vacuum_VacuumConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)minVatOpenPress, (double)item_.getMinVatOpenPress(), (double)1.0E-6f);
        Assert.assertEquals((double)pressDiffHigh, (double)item_.getPressDiffHigh(), (double)1.0E-6f);
        Assert.assertEquals((double)pressDiffLow, (double)item_.getPressDiffLow(), (double)1.0E-6f);
        Assert.assertEquals((double)pressForelineLow, (double)item_.getPressForelineLow(), (double)1.0E-6f);
        Assert.assertEquals((double)pressIonEnable, (double)item_.getPressIonEnable(), (double)1.0E-6f);
        Assert.assertEquals((double)pressIonOff, (double)item_.getPressIonOff(), (double)1.0E-6f);
        Assert.assertEquals((double)pressTurboLow, (double)item_.getPressTurboLow(), (double)1.0E-6f);
        Assert.assertEquals((double)pressVacuum, (double)item_.getPressVacuum(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_BFR_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_BFR_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFR_DevicesConfigurationEvent));
        Quadbox_BFR_DevicesConfigurationEvent item_ = (Quadbox_BFR_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_BFR_LimitsConfigurationEvent() throws Exception {
        String version = "b";
        double clean_5_24V_I_warnHi = 0.8524715900421143;
        double clean_5_24V_I_warnLo = 0.677761971950531;
        double clean_5_24V_I_limitHi = 0.6856864094734192;
        double clean_5_24V_I_limitLo = 0.15195822715759277;
        double dirty_24V_I_warnHi = 0.7192482352256775;
        double dirty_24V_I_warnLo = 0.8364443778991699;
        double dirty_24V_I_limitHi = 0.161748468875885;
        double dirty_24V_I_limitLo = 0.6321895122528076;
        double dirty_28V_I_warnHi = 0.10460102558135986;
        double dirty_28V_I_warnLo = 0.7797408103942871;
        double dirty_28V_I_limitHi = 0.7016832828521729;
        double dirty_28V_I_limitLo = 0.0922970175743103;
        double dirty_48V_I_warnHi = 0.8619933128356934;
        double dirty_48V_I_warnLo = 0.3623538017272949;
        double dirty_48V_I_limitHi = 0.33647865056991577;
        double dirty_48V_I_limitLo = 0.10063028335571289;
        double heater_I_warnHi = 0.710841f;
        double heater_I_warnLo = 0.6896804571151733;
        double heater_I_limitHi = 0.4579014182090759;
        double heater_I_limitLo = 0.2700703740119934;
        double protection_I_warnHi = 0.27534347772598267;
        double protection_I_warnLo = 0.5729556679725647;
        double protection_I_limitHi = 0.8949098587036133;
        double protection_I_limitLo = 0.7206348180770874;
        double rebps_0_warnHi = 0.8623384237289429;
        double rebps_0_warnLo = 0.4858793616294861;
        double rebps_0_limitHi = 0.45777201652526855;
        double rebps_0_limitLo = 0.5911467671394348;
        double sensor_PWS_17_I_warnHi = 0.393549382686615;
        double sensor_PWS_17_I_warnLo = 0.6219715476036072;
        double sensor_PWS_17_I_limitHi = 0.40645831823349;
        double sensor_PWS_17_I_limitLo = 0.0836363434791565;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_BFR_LimitsConfigurationEvent(version, clean_5_24V_I_warnHi, clean_5_24V_I_warnLo, clean_5_24V_I_limitHi, clean_5_24V_I_limitLo, dirty_24V_I_warnHi, dirty_24V_I_warnLo, dirty_24V_I_limitHi, dirty_24V_I_limitLo, dirty_28V_I_warnHi, dirty_28V_I_warnLo, dirty_28V_I_limitHi, dirty_28V_I_limitLo, dirty_48V_I_warnHi, dirty_48V_I_warnLo, dirty_48V_I_limitHi, dirty_48V_I_limitLo, heater_I_warnHi, heater_I_warnLo, heater_I_limitHi, heater_I_limitLo, protection_I_warnHi, protection_I_warnLo, protection_I_limitHi, protection_I_limitLo, rebps_0_warnHi, rebps_0_warnLo, rebps_0_limitHi, rebps_0_limitLo, sensor_PWS_17_I_warnHi, sensor_PWS_17_I_warnLo, sensor_PWS_17_I_limitHi, sensor_PWS_17_I_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFR_LimitsConfigurationEvent));
        Quadbox_BFR_LimitsConfigurationEvent item_ = (Quadbox_BFR_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)clean_5_24V_I_warnHi, (double)item_.getClean_5_24V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_warnLo, (double)item_.getClean_5_24V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_limitHi, (double)item_.getClean_5_24V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_limitLo, (double)item_.getClean_5_24V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_warnHi, (double)item_.getDirty_24V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_warnLo, (double)item_.getDirty_24V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_limitHi, (double)item_.getDirty_24V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_limitLo, (double)item_.getDirty_24V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_warnHi, (double)item_.getDirty_28V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_warnLo, (double)item_.getDirty_28V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_limitHi, (double)item_.getDirty_28V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_limitLo, (double)item_.getDirty_28V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_warnHi, (double)item_.getDirty_48V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_warnLo, (double)item_.getDirty_48V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_limitHi, (double)item_.getDirty_48V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_limitLo, (double)item_.getDirty_48V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_warnHi, (double)item_.getHeater_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_warnLo, (double)item_.getHeater_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_limitHi, (double)item_.getHeater_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_limitLo, (double)item_.getHeater_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_warnHi, (double)item_.getProtection_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_warnLo, (double)item_.getProtection_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_limitHi, (double)item_.getProtection_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_limitLo, (double)item_.getProtection_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_warnHi, (double)item_.getRebps_0_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_warnLo, (double)item_.getRebps_0_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_limitHi, (double)item_.getRebps_0_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_limitLo, (double)item_.getRebps_0_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)sensor_PWS_17_I_warnHi, (double)item_.getSensor_PWS_17_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)sensor_PWS_17_I_warnLo, (double)item_.getSensor_PWS_17_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)sensor_PWS_17_I_limitHi, (double)item_.getSensor_PWS_17_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)sensor_PWS_17_I_limitLo, (double)item_.getSensor_PWS_17_I_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_BFR_QuadboxConfigurationEvent() throws Exception {
        String version = "g";
        int node = 798;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_BFR_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFR_QuadboxConfigurationEvent));
        Quadbox_BFR_QuadboxConfigurationEvent item_ = (Quadbox_BFR_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VC_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VC_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VC_DevicesConfigurationEvent));
        Quadbox_PDU_24VC_DevicesConfigurationEvent item_ = (Quadbox_PDU_24VC_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VC_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double board_T_warnHi = 0.48851585388183594;
        double board_T_warnLo = 0.3681f;
        double board_T_limitHi = 0.177703857421875;
        double board_T_limitLo = 0.8507076501846313;
        double body_Purge_I_warnHi = 0.3890703320503235;
        double body_Purge_I_warnLo = 0.8853934407234192;
        double body_Purge_I_limitHi = 0.16424894332885742;
        double body_Purge_I_limitLo = 0.582197368144989;
        double body_Purge_V_warnHi = 0.5306582450866699;
        double body_Purge_V_warnLo = 0.2015218734741211;
        double body_Purge_V_limitHi = 0.5292513370513916;
        double body_Purge_V_limitLo = 0.5915347337722778;
        double bpu_Maq20_I_warnHi = 0.17069f;
        double bpu_Maq20_I_warnLo = 0.6826686859130859;
        double bpu_Maq20_I_limitHi = 0.6330636143684387;
        double bpu_Maq20_I_limitLo = 0.49333226680755615;
        double bpu_Maq20_V_warnHi = 0.05587393045425415;
        double bpu_Maq20_V_warnLo = 0.5080180764198303;
        double bpu_Maq20_V_limitHi = 0.3663373f;
        double bpu_Maq20_V_limitLo = 0.9903306365013123;
        double fpga_T_warnHi = 0.28888654708862305;
        double fpga_T_warnLo = 0.43917596340179443;
        double fpga_T_limitHi = 0.4342119097709656;
        double fpga_T_limitLo = 0.5887249112129211;
        double fes_Shu_HCU_I_warnHi = 0.47140854597091675;
        double fes_Shu_HCU_I_warnLo = 0.10862231254577637;
        double fes_Shu_HCU_I_limitHi = 0.3732417821884155;
        double fes_Shu_HCU_I_limitLo = 0.376612f;
        double fes_Shu_HCU_V_warnHi = 0.562292f;
        double fes_Shu_HCU_V_warnLo = 0.11836177110671997;
        double fes_Shu_HCU_V_limitHi = 0.11182254552841187;
        double fes_Shu_HCU_V_limitLo = 0.32439786195755005;
        double gauges_I_warnHi = 0.630763053894043;
        double gauges_I_warnLo = 0.2564527988433838;
        double gauges_I_limitHi = 0.018869996070861816;
        double gauges_I_limitLo = 0.5753469467163086;
        double gauges_V_warnHi = 0.7712225317955017;
        double gauges_V_warnLo = 0.03604203462600708;
        double gauges_V_limitHi = 0.3303477168083191;
        double gauges_V_limitLo = 0.5554215312004089;
        double ion_Pumps_I_warnHi = 0.4535815119743347;
        double ion_Pumps_I_warnLo = 0.7351964116096497;
        double ion_Pumps_I_limitHi = 0.49444258213043213;
        double ion_Pumps_I_limitLo = 0.5544989109039307;
        double ion_Pumps_V_warnHi = 0.03947758674621582;
        double ion_Pumps_V_warnLo = 0.2531300187110901;
        double ion_Pumps_V_limitHi = 0.307384f;
        double ion_Pumps_V_limitLo = 0.3419477939605713;
        double j11_I_warnHi = 0.8316075205802917;
        double j11_I_warnLo = 0.6268974542617798;
        double j11_I_limitHi = 0.02484762668609619;
        double j11_I_limitLo = 0.7699902057647705;
        double j11_V_warnHi = 0.025355935096740723;
        double j11_V_warnLo = 0.590442f;
        double j11_V_limitHi = 0.808464765548706;
        double j11_V_limitLo = 0.5955008864402771;
        double j12_I_warnHi = 0.18658453226089478;
        double j12_I_warnLo = 0.3638281226158142;
        double j12_I_limitHi = 0.6111805438995361;
        double j12_I_limitLo = 0.5877537727355957;
        double j12_V_warnHi = 0.22770464420318604;
        double j12_V_warnLo = 0.08397293090820312;
        double j12_V_limitHi = 0.705195426940918;
        double j12_V_limitLo = 0.5745881199836731;
        double j6_I_warnHi = 0.3399214f;
        double j6_I_warnLo = 0.2192559838294983;
        double j6_I_limitHi = 0.6262549161911011;
        double j6_I_limitLo = 0.3666437268257141;
        double j6_V_warnHi = 0.45988816022872925;
        double j6_V_warnLo = 0.6296939253807068;
        double j6_V_limitHi = 0.040489912033081055;
        double j6_V_limitLo = 0.45842164754867554;
        double j7_I_warnHi = 0.8041380643844604;
        double j7_I_warnLo = 0.963213324546814;
        double j7_I_limitHi = 0.4553758502006531;
        double j7_I_limitLo = 0.2713279128074646;
        double j7_V_warnHi = 0.947884738445282;
        double j7_V_warnLo = 0.0288409f;
        double j7_V_limitHi = 0.39329564571380615;
        double j7_V_limitLo = 0.22851771116256714;
        double j8_I_warnHi = 0.21255344152450562;
        double j8_I_warnLo = 0.011912405490875244;
        double j8_I_limitHi = 0.5514242649078369;
        double j8_I_limitLo = 0.6508852243423462;
        double j8_V_warnHi = 0.568288266658783;
        double j8_V_warnLo = 0.637826144695282;
        double j8_V_limitHi = 0.09007900953292847;
        double j8_V_limitLo = 0.8701666593551636;
        double j9_I_warnHi = 0.36637115478515625;
        double j9_I_warnLo = 0.03323858976364136;
        double j9_I_limitHi = 0.8563101887702942;
        double j9_I_limitLo = 0.8666839003562927;
        double j9_V_warnHi = 0.45781224966049194;
        double j9_V_warnLo = 0.3513185381889343;
        double j9_V_limitHi = 0.4714767336845398;
        double j9_V_limitLo = 0.46924442052841187;
        double main_I_warnHi = 0.2972654700279236;
        double main_I_warnLo = 0.6357949376106262;
        double main_I_limitHi = 0.5301083922386169;
        double main_I_limitLo = 0.7822174429893494;
        double main_T_warnHi = 0.5979655385017395;
        double main_T_warnLo = 0.7027034163475037;
        double main_T_limitHi = 0.9898995161056519;
        double main_T_limitLo = 0.12456047534942627;
        double main_V_warnHi = 0.8187646269798279;
        double main_V_warnLo = 0.4652571678161621;
        double main_V_limitHi = 0.3246997594833374;
        double main_V_limitLo = 0.7379271984100342;
        double pwr_Cry_HCU_I_warnHi = 0.006887316703796387;
        double pwr_Cry_HCU_I_warnLo = 0.4530452489852905;
        double pwr_Cry_HCU_I_limitHi = 0.3875085115432739;
        double pwr_Cry_HCU_I_limitLo = 0.721917450428009;
        double pwr_Cry_HCU_V_warnHi = 0.27117353677749634;
        double pwr_Cry_HCU_V_warnLo = 0.7593408823013306;
        double pwr_Cry_HCU_V_limitHi = 0.7404987812042236;
        double pwr_Cry_HCU_V_limitLo = 0.7256408929824829;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VC_LimitsConfigurationEvent(version, board_T_warnHi, board_T_warnLo, board_T_limitHi, board_T_limitLo, body_Purge_I_warnHi, body_Purge_I_warnLo, body_Purge_I_limitHi, body_Purge_I_limitLo, body_Purge_V_warnHi, body_Purge_V_warnLo, body_Purge_V_limitHi, body_Purge_V_limitLo, bpu_Maq20_I_warnHi, bpu_Maq20_I_warnLo, bpu_Maq20_I_limitHi, bpu_Maq20_I_limitLo, bpu_Maq20_V_warnHi, bpu_Maq20_V_warnLo, bpu_Maq20_V_limitHi, bpu_Maq20_V_limitLo, fpga_T_warnHi, fpga_T_warnLo, fpga_T_limitHi, fpga_T_limitLo, fes_Shu_HCU_I_warnHi, fes_Shu_HCU_I_warnLo, fes_Shu_HCU_I_limitHi, fes_Shu_HCU_I_limitLo, fes_Shu_HCU_V_warnHi, fes_Shu_HCU_V_warnLo, fes_Shu_HCU_V_limitHi, fes_Shu_HCU_V_limitLo, gauges_I_warnHi, gauges_I_warnLo, gauges_I_limitHi, gauges_I_limitLo, gauges_V_warnHi, gauges_V_warnLo, gauges_V_limitHi, gauges_V_limitLo, ion_Pumps_I_warnHi, ion_Pumps_I_warnLo, ion_Pumps_I_limitHi, ion_Pumps_I_limitLo, ion_Pumps_V_warnHi, ion_Pumps_V_warnLo, ion_Pumps_V_limitHi, ion_Pumps_V_limitLo, j11_I_warnHi, j11_I_warnLo, j11_I_limitHi, j11_I_limitLo, j11_V_warnHi, j11_V_warnLo, j11_V_limitHi, j11_V_limitLo, j12_I_warnHi, j12_I_warnLo, j12_I_limitHi, j12_I_limitLo, j12_V_warnHi, j12_V_warnLo, j12_V_limitHi, j12_V_limitLo, j6_I_warnHi, j6_I_warnLo, j6_I_limitHi, j6_I_limitLo, j6_V_warnHi, j6_V_warnLo, j6_V_limitHi, j6_V_limitLo, j7_I_warnHi, j7_I_warnLo, j7_I_limitHi, j7_I_limitLo, j7_V_warnHi, j7_V_warnLo, j7_V_limitHi, j7_V_limitLo, j8_I_warnHi, j8_I_warnLo, j8_I_limitHi, j8_I_limitLo, j8_V_warnHi, j8_V_warnLo, j8_V_limitHi, j8_V_limitLo, j9_I_warnHi, j9_I_warnLo, j9_I_limitHi, j9_I_limitLo, j9_V_warnHi, j9_V_warnLo, j9_V_limitHi, j9_V_limitLo, main_I_warnHi, main_I_warnLo, main_I_limitHi, main_I_limitLo, main_T_warnHi, main_T_warnLo, main_T_limitHi, main_T_limitLo, main_V_warnHi, main_V_warnLo, main_V_limitHi, main_V_limitLo, pwr_Cry_HCU_I_warnHi, pwr_Cry_HCU_I_warnLo, pwr_Cry_HCU_I_limitHi, pwr_Cry_HCU_I_limitLo, pwr_Cry_HCU_V_warnHi, pwr_Cry_HCU_V_warnLo, pwr_Cry_HCU_V_limitHi, pwr_Cry_HCU_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VC_LimitsConfigurationEvent));
        Quadbox_PDU_24VC_LimitsConfigurationEvent item_ = (Quadbox_PDU_24VC_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)board_T_warnHi, (double)item_.getBoard_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_warnLo, (double)item_.getBoard_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitHi, (double)item_.getBoard_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitLo, (double)item_.getBoard_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_warnHi, (double)item_.getBody_Purge_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_warnLo, (double)item_.getBody_Purge_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_limitHi, (double)item_.getBody_Purge_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_limitLo, (double)item_.getBody_Purge_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_warnHi, (double)item_.getBody_Purge_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_warnLo, (double)item_.getBody_Purge_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_limitHi, (double)item_.getBody_Purge_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_limitLo, (double)item_.getBody_Purge_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_warnHi, (double)item_.getBpu_Maq20_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_warnLo, (double)item_.getBpu_Maq20_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_limitHi, (double)item_.getBpu_Maq20_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_limitLo, (double)item_.getBpu_Maq20_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_warnHi, (double)item_.getBpu_Maq20_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_warnLo, (double)item_.getBpu_Maq20_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_limitHi, (double)item_.getBpu_Maq20_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_limitLo, (double)item_.getBpu_Maq20_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnHi, (double)item_.getFpga_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnLo, (double)item_.getFpga_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitHi, (double)item_.getFpga_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitLo, (double)item_.getFpga_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_warnHi, (double)item_.getFes_Shu_HCU_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_warnLo, (double)item_.getFes_Shu_HCU_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_limitHi, (double)item_.getFes_Shu_HCU_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_limitLo, (double)item_.getFes_Shu_HCU_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_warnHi, (double)item_.getFes_Shu_HCU_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_warnLo, (double)item_.getFes_Shu_HCU_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_limitHi, (double)item_.getFes_Shu_HCU_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_limitLo, (double)item_.getFes_Shu_HCU_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_warnHi, (double)item_.getGauges_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_warnLo, (double)item_.getGauges_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_limitHi, (double)item_.getGauges_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_limitLo, (double)item_.getGauges_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_warnHi, (double)item_.getGauges_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_warnLo, (double)item_.getGauges_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_limitHi, (double)item_.getGauges_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_limitLo, (double)item_.getGauges_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_warnHi, (double)item_.getIon_Pumps_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_warnLo, (double)item_.getIon_Pumps_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_limitHi, (double)item_.getIon_Pumps_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_limitLo, (double)item_.getIon_Pumps_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_warnHi, (double)item_.getIon_Pumps_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_warnLo, (double)item_.getIon_Pumps_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_limitHi, (double)item_.getIon_Pumps_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_limitLo, (double)item_.getIon_Pumps_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_I_warnHi, (double)item_.getJ11_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_I_warnLo, (double)item_.getJ11_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_I_limitHi, (double)item_.getJ11_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_I_limitLo, (double)item_.getJ11_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_V_warnHi, (double)item_.getJ11_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_V_warnLo, (double)item_.getJ11_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_V_limitHi, (double)item_.getJ11_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_V_limitLo, (double)item_.getJ11_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_I_warnHi, (double)item_.getJ12_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_I_warnLo, (double)item_.getJ12_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_I_limitHi, (double)item_.getJ12_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_I_limitLo, (double)item_.getJ12_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_V_warnHi, (double)item_.getJ12_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_V_warnLo, (double)item_.getJ12_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_V_limitHi, (double)item_.getJ12_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_V_limitLo, (double)item_.getJ12_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_I_warnHi, (double)item_.getJ6_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_I_warnLo, (double)item_.getJ6_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_I_limitHi, (double)item_.getJ6_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_I_limitLo, (double)item_.getJ6_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_V_warnHi, (double)item_.getJ6_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_V_warnLo, (double)item_.getJ6_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_V_limitHi, (double)item_.getJ6_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_V_limitLo, (double)item_.getJ6_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_I_warnHi, (double)item_.getJ7_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_I_warnLo, (double)item_.getJ7_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_I_limitHi, (double)item_.getJ7_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_I_limitLo, (double)item_.getJ7_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_V_warnHi, (double)item_.getJ7_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_V_warnLo, (double)item_.getJ7_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_V_limitHi, (double)item_.getJ7_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_V_limitLo, (double)item_.getJ7_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j8_I_warnHi, (double)item_.getJ8_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j8_I_warnLo, (double)item_.getJ8_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j8_I_limitHi, (double)item_.getJ8_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j8_I_limitLo, (double)item_.getJ8_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j8_V_warnHi, (double)item_.getJ8_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j8_V_warnLo, (double)item_.getJ8_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j8_V_limitHi, (double)item_.getJ8_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j8_V_limitLo, (double)item_.getJ8_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_I_warnHi, (double)item_.getJ9_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_I_warnLo, (double)item_.getJ9_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_I_limitHi, (double)item_.getJ9_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_I_limitLo, (double)item_.getJ9_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_V_warnHi, (double)item_.getJ9_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_V_warnLo, (double)item_.getJ9_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_V_limitHi, (double)item_.getJ9_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_V_limitLo, (double)item_.getJ9_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnHi, (double)item_.getMain_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnLo, (double)item_.getMain_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitHi, (double)item_.getMain_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitLo, (double)item_.getMain_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnHi, (double)item_.getMain_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnLo, (double)item_.getMain_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitHi, (double)item_.getMain_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitLo, (double)item_.getMain_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnHi, (double)item_.getMain_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnLo, (double)item_.getMain_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitHi, (double)item_.getMain_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitLo, (double)item_.getMain_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_warnHi, (double)item_.getPwr_Cry_HCU_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_warnLo, (double)item_.getPwr_Cry_HCU_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_limitHi, (double)item_.getPwr_Cry_HCU_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_limitLo, (double)item_.getPwr_Cry_HCU_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_warnHi, (double)item_.getPwr_Cry_HCU_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_warnLo, (double)item_.getPwr_Cry_HCU_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_limitHi, (double)item_.getPwr_Cry_HCU_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_limitLo, (double)item_.getPwr_Cry_HCU_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VC_QuadboxConfigurationEvent() throws Exception {
        String version = "i";
        int node = 217;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VC_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VC_QuadboxConfigurationEvent));
        Quadbox_PDU_24VC_QuadboxConfigurationEvent item_ = (Quadbox_PDU_24VC_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VD_DevicesConfigurationEvent() throws Exception {
        String version = "v";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VD_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VD_DevicesConfigurationEvent));
        Quadbox_PDU_24VD_DevicesConfigurationEvent item_ = (Quadbox_PDU_24VD_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VD_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double board_T_warnHi = 0.6501095294952393;
        double board_T_warnLo = 0.161163330078125;
        double board_T_limitHi = 0.8502786159515381;
        double board_T_limitLo = 0.1887073516845703;
        double fes_I_warnHi = 0.21293115615844727;
        double fes_I_warnLo = 0.07158505916595459;
        double fes_I_limitHi = 0.4632687568664551;
        double fes_I_limitLo = 0.9889718294143677;
        double fes_V_warnHi = 0.019225597381591797;
        double fes_V_warnLo = 0.7258667349815369;
        double fes_V_limitHi = 0.16032713651657104;
        double fes_V_limitLo = 0.747619f;
        double fpga_T_warnHi = 0.5122162699699402;
        double fpga_T_warnLo = 0.9605627059936523;
        double fpga_T_limitHi = 0.487312376499176;
        double fpga_T_limitLo = 0.576705813407898;
        double main_I_warnHi = 0.13985759019851685;
        double main_I_warnLo = 0.6057502627372742;
        double main_I_limitHi = 0.9010071754455566;
        double main_I_limitLo = 0.9271302223205566;
        double main_T_warnHi = 0.7254574298858643;
        double main_T_warnLo = 0.7387614846229553;
        double main_T_limitHi = 0.7340636253356934;
        double main_T_limitLo = 0.6733422875404358;
        double main_V_warnHi = 0.912837028503418;
        double main_V_warnLo = 0.7502734661102295;
        double main_V_limitHi = 0.3962177038192749;
        double main_V_limitLo = 0.8504967093467712;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VD_LimitsConfigurationEvent(version, board_T_warnHi, board_T_warnLo, board_T_limitHi, board_T_limitLo, fes_I_warnHi, fes_I_warnLo, fes_I_limitHi, fes_I_limitLo, fes_V_warnHi, fes_V_warnLo, fes_V_limitHi, fes_V_limitLo, fpga_T_warnHi, fpga_T_warnLo, fpga_T_limitHi, fpga_T_limitLo, main_I_warnHi, main_I_warnLo, main_I_limitHi, main_I_limitLo, main_T_warnHi, main_T_warnLo, main_T_limitHi, main_T_limitLo, main_V_warnHi, main_V_warnLo, main_V_limitHi, main_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VD_LimitsConfigurationEvent));
        Quadbox_PDU_24VD_LimitsConfigurationEvent item_ = (Quadbox_PDU_24VD_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)board_T_warnHi, (double)item_.getBoard_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_warnLo, (double)item_.getBoard_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitHi, (double)item_.getBoard_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitLo, (double)item_.getBoard_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_I_warnHi, (double)item_.getFes_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_I_warnLo, (double)item_.getFes_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_I_limitHi, (double)item_.getFes_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_I_limitLo, (double)item_.getFes_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_V_warnHi, (double)item_.getFes_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_V_warnLo, (double)item_.getFes_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_V_limitHi, (double)item_.getFes_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_V_limitLo, (double)item_.getFes_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnHi, (double)item_.getFpga_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnLo, (double)item_.getFpga_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitHi, (double)item_.getFpga_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitLo, (double)item_.getFpga_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnHi, (double)item_.getMain_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnLo, (double)item_.getMain_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitHi, (double)item_.getMain_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitLo, (double)item_.getMain_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnHi, (double)item_.getMain_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnLo, (double)item_.getMain_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitHi, (double)item_.getMain_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitLo, (double)item_.getMain_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnHi, (double)item_.getMain_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnLo, (double)item_.getMain_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitHi, (double)item_.getMain_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitLo, (double)item_.getMain_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VD_QuadboxConfigurationEvent() throws Exception {
        String version = "w";
        int node = 441;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VD_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VD_QuadboxConfigurationEvent));
        Quadbox_PDU_24VD_QuadboxConfigurationEvent item_ = (Quadbox_PDU_24VD_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_48V_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_48V_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48V_DevicesConfigurationEvent));
        Quadbox_PDU_48V_DevicesConfigurationEvent item_ = (Quadbox_PDU_48V_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_PDU_48V_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double board_T_warnHi = 0.5990188121795654;
        double board_T_warnLo = 0.7066761255264282;
        double board_T_limitHi = 0.7915622591972351;
        double board_T_limitLo = 0.9401387572288513;
        double cryotel0_I_warnHi = 0.4550822377204895;
        double cryotel0_I_warnLo = 0.8304072618484497;
        double cryotel0_I_limitHi = 0.6631735563278198;
        double cryotel0_I_limitLo = 0.3236621022224426;
        double cryotel0_V_warnHi = 0.3548798f;
        double cryotel0_V_warnLo = 0.5723358392715454;
        double cryotel0_V_limitHi = 0.48923712968826294;
        double cryotel0_V_limitLo = 0.09669744968414307;
        double cryotel1_I_warnHi = 0.512495f;
        double cryotel1_I_warnLo = 0.014815092086791992;
        double cryotel1_I_limitHi = 0.11774694919586182;
        double cryotel1_I_limitLo = 0.7637425661087036;
        double cryotel1_V_warnHi = 0.0013309121131896973;
        double cryotel1_V_warnLo = 0.1103748083114624;
        double cryotel1_V_limitHi = 0.7935634851455688;
        double cryotel1_V_limitLo = 0.695536732673645;
        double cryotel2_I_warnHi = 0.5241841077804565;
        double cryotel2_I_warnLo = 0.8185601234436035;
        double cryotel2_I_limitHi = 0.02027106285095215;
        double cryotel2_I_limitLo = 0.8648861050605774;
        double cryotel2_V_warnHi = 0.86362f;
        double cryotel2_V_warnLo = 0.4383272f;
        double cryotel2_V_limitHi = 0.7694481611251831;
        double cryotel2_V_limitLo = 0.20988517999649048;
        double fpga_T_warnHi = 0.28067994117736816;
        double fpga_T_warnLo = 0.16905808448791504;
        double fpga_T_limitHi = 0.83838f;
        double fpga_T_limitLo = 0.23789077997207642;
        double main_I_warnHi = 0.1053884f;
        double main_I_warnLo = 0.9961449503898621;
        double main_I_limitHi = 0.697284996509552;
        double main_I_limitLo = 0.0728883147239685;
        double main_T_warnHi = 0.976794421672821;
        double main_T_warnLo = 0.4362572431564331;
        double main_T_limitHi = 0.1906307339668274;
        double main_T_limitLo = 0.5290064215660095;
        double main_V_warnHi = 0.8240458965301514;
        double main_V_warnLo = 0.6852403879165649;
        double main_V_limitHi = 0.43380147218704224;
        double main_V_limitLo = 0.6640772223472595;
        double reb_BULK_I_warnHi = 0.5545397996902466;
        double reb_BULK_I_warnLo = 0.3085957169532776;
        double reb_BULK_I_limitHi = 0.9116076231002808;
        double reb_BULK_I_limitLo = 0.2826339602470398;
        double reb_BULK_V_warnHi = 0.2424364686012268;
        double reb_BULK_V_warnLo = 0.8993031978607178;
        double reb_BULK_V_limitHi = 0.389864444732666;
        double reb_BULK_V_limitLo = 0.87402f;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_48V_LimitsConfigurationEvent(version, board_T_warnHi, board_T_warnLo, board_T_limitHi, board_T_limitLo, cryotel0_I_warnHi, cryotel0_I_warnLo, cryotel0_I_limitHi, cryotel0_I_limitLo, cryotel0_V_warnHi, cryotel0_V_warnLo, cryotel0_V_limitHi, cryotel0_V_limitLo, cryotel1_I_warnHi, cryotel1_I_warnLo, cryotel1_I_limitHi, cryotel1_I_limitLo, cryotel1_V_warnHi, cryotel1_V_warnLo, cryotel1_V_limitHi, cryotel1_V_limitLo, cryotel2_I_warnHi, cryotel2_I_warnLo, cryotel2_I_limitHi, cryotel2_I_limitLo, cryotel2_V_warnHi, cryotel2_V_warnLo, cryotel2_V_limitHi, cryotel2_V_limitLo, fpga_T_warnHi, fpga_T_warnLo, fpga_T_limitHi, fpga_T_limitLo, main_I_warnHi, main_I_warnLo, main_I_limitHi, main_I_limitLo, main_T_warnHi, main_T_warnLo, main_T_limitHi, main_T_limitLo, main_V_warnHi, main_V_warnLo, main_V_limitHi, main_V_limitLo, reb_BULK_I_warnHi, reb_BULK_I_warnLo, reb_BULK_I_limitHi, reb_BULK_I_limitLo, reb_BULK_V_warnHi, reb_BULK_V_warnLo, reb_BULK_V_limitHi, reb_BULK_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48V_LimitsConfigurationEvent));
        Quadbox_PDU_48V_LimitsConfigurationEvent item_ = (Quadbox_PDU_48V_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)board_T_warnHi, (double)item_.getBoard_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_warnLo, (double)item_.getBoard_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitHi, (double)item_.getBoard_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitLo, (double)item_.getBoard_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_I_warnHi, (double)item_.getCryotel0_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_I_warnLo, (double)item_.getCryotel0_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_I_limitHi, (double)item_.getCryotel0_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_I_limitLo, (double)item_.getCryotel0_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_V_warnHi, (double)item_.getCryotel0_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_V_warnLo, (double)item_.getCryotel0_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_V_limitHi, (double)item_.getCryotel0_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_V_limitLo, (double)item_.getCryotel0_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_I_warnHi, (double)item_.getCryotel1_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_I_warnLo, (double)item_.getCryotel1_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_I_limitHi, (double)item_.getCryotel1_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_I_limitLo, (double)item_.getCryotel1_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_V_warnHi, (double)item_.getCryotel1_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_V_warnLo, (double)item_.getCryotel1_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_V_limitHi, (double)item_.getCryotel1_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_V_limitLo, (double)item_.getCryotel1_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_I_warnHi, (double)item_.getCryotel2_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_I_warnLo, (double)item_.getCryotel2_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_I_limitHi, (double)item_.getCryotel2_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_I_limitLo, (double)item_.getCryotel2_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_V_warnHi, (double)item_.getCryotel2_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_V_warnLo, (double)item_.getCryotel2_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_V_limitHi, (double)item_.getCryotel2_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_V_limitLo, (double)item_.getCryotel2_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnHi, (double)item_.getFpga_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnLo, (double)item_.getFpga_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitHi, (double)item_.getFpga_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitLo, (double)item_.getFpga_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnHi, (double)item_.getMain_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnLo, (double)item_.getMain_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitHi, (double)item_.getMain_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitLo, (double)item_.getMain_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnHi, (double)item_.getMain_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnLo, (double)item_.getMain_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitHi, (double)item_.getMain_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitLo, (double)item_.getMain_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnHi, (double)item_.getMain_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnLo, (double)item_.getMain_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitHi, (double)item_.getMain_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitLo, (double)item_.getMain_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_I_warnHi, (double)item_.getReb_BULK_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_I_warnLo, (double)item_.getReb_BULK_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_I_limitHi, (double)item_.getReb_BULK_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_I_limitLo, (double)item_.getReb_BULK_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_V_warnHi, (double)item_.getReb_BULK_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_V_warnLo, (double)item_.getReb_BULK_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_V_limitHi, (double)item_.getReb_BULK_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_V_limitLo, (double)item_.getReb_BULK_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48V_QuadboxConfigurationEvent() throws Exception {
        String version = "";
        int node = 989;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_48V_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48V_QuadboxConfigurationEvent));
        Quadbox_PDU_48V_QuadboxConfigurationEvent item_ = (Quadbox_PDU_48V_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_5V_DevicesConfigurationEvent() throws Exception {
        String version = "t";
        boolean disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_5V_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5V_DevicesConfigurationEvent));
        Quadbox_PDU_5V_DevicesConfigurationEvent item_ = (Quadbox_PDU_5V_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceiveQuadbox_PDU_5V_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double otm_3_B_I_warnHi = 0.9028640389442444;
        double otm_3_B_I_warnLo = 0.17943823337554932;
        double otm_3_B_I_limitHi = 0.6503531336784363;
        double otm_3_B_I_limitLo = 0.00792855f;
        double otm_3_B_V_warnHi = 0.03374302387237549;
        double otm_3_B_V_warnLo = 0.9140632152557373;
        double otm_3_B_V_limitHi = 0.3034737f;
        double otm_3_B_V_limitLo = 0.5301044583320618;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_5V_LimitsConfigurationEvent(version, otm_3_B_I_warnHi, otm_3_B_I_warnLo, otm_3_B_I_limitHi, otm_3_B_I_limitLo, otm_3_B_V_warnHi, otm_3_B_V_warnLo, otm_3_B_V_limitHi, otm_3_B_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5V_LimitsConfigurationEvent));
        Quadbox_PDU_5V_LimitsConfigurationEvent item_ = (Quadbox_PDU_5V_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)otm_3_B_I_warnHi, (double)item_.getOtm_3_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_warnLo, (double)item_.getOtm_3_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_limitHi, (double)item_.getOtm_3_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_limitLo, (double)item_.getOtm_3_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_warnHi, (double)item_.getOtm_3_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_warnLo, (double)item_.getOtm_3_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_limitHi, (double)item_.getOtm_3_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_limitLo, (double)item_.getOtm_3_B_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5V_QuadboxConfigurationEvent() throws Exception {
        String version = "y";
        int node = 916;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_5V_QuadboxConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5V_QuadboxConfigurationEvent));
        Quadbox_PDU_5V_QuadboxConfigurationEvent item_ = (Quadbox_PDU_5V_QuadboxConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 517;
        int schedulers_default_nThreads = 772;
        int schedulers_monitor_update_publish_scheduler_nTasks = 511;
        int schedulers_monitor_update_publish_scheduler_nThreads = 202;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PeriodicTasks_GeneralConfigurationEvent));
        Quadbox_PeriodicTasks_GeneralConfigurationEvent item_ = (Quadbox_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveQuadbox_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 864L;
        long heartbeat_taskPeriodMillis = 368L;
        long monitor_check_taskPeriodMillis = 966L;
        long monitor_publish_taskPeriodMillis = 247L;
        long monitor_update_taskPeriodMillis = 789L;
        long runtimeinfo_taskPeriodMillis = 147L;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PeriodicTasks_timersConfigurationEvent));
        Quadbox_PeriodicTasks_timersConfigurationEvent item_ = (Quadbox_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_HardwareIdConfigurationEvent() throws Exception {
        String version = "";
        String location = "q";
        String manSerNum = "e";
        String name = "c";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_HardwareIdConfigurationEvent(version, location, manSerNum, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_HardwareIdConfigurationEvent));
        Focal_plane_Ccd_HardwareIdConfigurationEvent item_ = (Focal_plane_Ccd_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)manSerNum, (Object)item_.getManSerNum());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_LimitsConfigurationEvent() throws Exception {
        String version = "u";
        double[] gdv_warnHi = TestHelper.generateDoubleArray((int)9, (int)1954140628);
        double[] gdv_warnLo = TestHelper.generateDoubleArray((int)9, (int)363866554);
        double[] gdv_limitHi = TestHelper.generateDoubleArray((int)9, (int)1904905178);
        double[] gdv_limitLo = TestHelper.generateDoubleArray((int)9, (int)750478916);
        String location = "";
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)9, (int)861684539);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)9, (int)-2038782702);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)9, (int)2134864051);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)9, (int)768412326);
        double[] ogv_warnHi = TestHelper.generateDoubleArray((int)9, (int)-331934514);
        double[] ogv_warnLo = TestHelper.generateDoubleArray((int)9, (int)911422229);
        double[] ogv_limitHi = TestHelper.generateDoubleArray((int)9, (int)701163257);
        double[] ogv_limitLo = TestHelper.generateDoubleArray((int)9, (int)-1927111224);
        double[] rdv_warnHi = TestHelper.generateDoubleArray((int)9, (int)596607169);
        double[] rdv_warnLo = TestHelper.generateDoubleArray((int)9, (int)922425108);
        double[] rdv_limitHi = TestHelper.generateDoubleArray((int)9, (int)1328226658);
        double[] rdv_limitLo = TestHelper.generateDoubleArray((int)9, (int)-1675318181);
        double[] temp_warnHi = TestHelper.generateDoubleArray((int)9, (int)-1713816509);
        double[] temp_warnLo = TestHelper.generateDoubleArray((int)9, (int)931014788);
        double[] temp_limitHi = TestHelper.generateDoubleArray((int)9, (int)347920369);
        double[] temp_limitLo = TestHelper.generateDoubleArray((int)9, (int)-333012064);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_LimitsConfigurationEvent(version, gdv_warnHi, gdv_warnLo, gdv_limitHi, gdv_limitLo, location, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, ogv_warnHi, ogv_warnLo, ogv_limitHi, ogv_limitLo, rdv_warnHi, rdv_warnLo, rdv_limitHi, rdv_limitLo, temp_warnHi, temp_warnLo, temp_limitHi, temp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_LimitsConfigurationEvent));
        Focal_plane_Ccd_LimitsConfigurationEvent item_ = (Focal_plane_Ccd_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])gdv_warnHi, (double[])item_.getGdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_warnLo, (double[])item_.getGdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitHi, (double[])item_.getGdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitLo, (double[])item_.getGdv_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnHi, (double[])item_.getOgv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnLo, (double[])item_.getOgv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitHi, (double[])item_.getOgv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitLo, (double[])item_.getOgv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnHi, (double[])item_.getRdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnLo, (double[])item_.getRdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitHi, (double[])item_.getRdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitLo, (double[])item_.getRdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnHi, (double[])item_.getTemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnLo, (double[])item_.getTemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitHi, (double[])item_.getTemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitLo, (double[])item_.getTemp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_ImageDatabaseService_GeneralConfigurationEvent() throws Exception {
        String version = "";
        String dbURL = "";
        boolean enabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageDatabaseService_GeneralConfigurationEvent(version, dbURL, enabled));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageDatabaseService_GeneralConfigurationEvent));
        Focal_plane_ImageDatabaseService_GeneralConfigurationEvent item_ = (Focal_plane_ImageDatabaseService_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)enabled, (Object)item_.isEnabled());
    }

    @Test
    public void sendReceiveFocal_plane_ImageNameService_GeneralConfigurationEvent() throws Exception {
        String version = "o";
        String controller = "";
        String dbURL = "";
        String offset = "k";
        String source = "u";
        String timeZoneId = "s";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageNameService_GeneralConfigurationEvent(version, controller, dbURL, offset, source, timeZoneId));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageNameService_GeneralConfigurationEvent));
        Focal_plane_ImageNameService_GeneralConfigurationEvent item_ = (Focal_plane_ImageNameService_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)controller, (Object)item_.getController());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)offset, (Object)item_.getOffset());
        Assert.assertEquals((Object)source, (Object)item_.getSource());
        Assert.assertEquals((Object)timeZoneId, (Object)item_.getTimeZoneId());
    }

    @Test
    public void sendReceiveFocal_plane_InstrumentConfig_InstrumentConfigurationEvent() throws Exception {
        String version = "";
        String instrument = "d";
        String telescope = "";
        String testStand = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_InstrumentConfig_InstrumentConfigurationEvent(version, instrument, telescope, testStand));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_InstrumentConfig_InstrumentConfigurationEvent));
        Focal_plane_InstrumentConfig_InstrumentConfigurationEvent item_ = (Focal_plane_InstrumentConfig_InstrumentConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)instrument, (Object)item_.getInstrument());
        Assert.assertEquals((Object)telescope, (Object)item_.getTelescope());
        Assert.assertEquals((Object)testStand, (Object)item_.getTestStand());
    }

    @Test
    public void sendReceiveFocal_plane_MonitoringConfig_MonitoringConfigurationEvent() throws Exception {
        String version = "";
        String postReadoutTriggerTasks = "";
        String readoutPauseTasks = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_MonitoringConfig_MonitoringConfigurationEvent(version, postReadoutTriggerTasks, readoutPauseTasks));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_MonitoringConfig_MonitoringConfigurationEvent));
        Focal_plane_MonitoringConfig_MonitoringConfigurationEvent item_ = (Focal_plane_MonitoringConfig_MonitoringConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)postReadoutTriggerTasks, (Object)item_.getPostReadoutTriggerTasks());
        Assert.assertEquals((Object)readoutPauseTasks, (Object)item_.getReadoutPauseTasks());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 205;
        int schedulers_default_nThreads = 411;
        int schedulers_monitor_check_scheduler_nTasks = 692;
        int schedulers_monitor_check_scheduler_nThreads = 368;
        int schedulers_monitor_update_publish_scheduler_nTasks = 562;
        int schedulers_monitor_update_publish_scheduler_nThreads = 46;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasks_GeneralConfigurationEvent));
        Focal_plane_PeriodicTasks_GeneralConfigurationEvent item_ = (Focal_plane_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 244L;
        long heartbeat_taskPeriodMillis = 48L;
        long monitor_publish_taskPeriodMillis = 643L;
        long monitor_update_taskPeriodMillis = 574L;
        long runtimeinfo_taskPeriodMillis = 154L;
        long tempcontrol_R22_taskPeriodMillis = 592L;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis, tempcontrol_R22_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasks_timersConfigurationEvent));
        Focal_plane_PeriodicTasks_timersConfigurationEvent item_ = (Focal_plane_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R22_taskPeriodMillis, (long)item_.getTempcontrol_R22_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_HardwareIdConfigurationEvent() throws Exception {
        String version = "";
        String location = "";
        String name = "n";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_HardwareIdConfigurationEvent(version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_HardwareIdConfigurationEvent));
        Focal_plane_Raft_HardwareIdConfigurationEvent item_ = (Focal_plane_Raft_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlConfigurationEvent() throws Exception {
        String version = "s";
        String location = "";
        double[] tempcontrol_basePower = TestHelper.generateDoubleArray((int)1, (int)-378012576);
        double[] tempcontrol_coefD = TestHelper.generateDoubleArray((int)1, (int)-814993367);
        double[] tempcontrol_coefI = TestHelper.generateDoubleArray((int)1, (int)1072785543);
        double[] tempcontrol_coefP = TestHelper.generateDoubleArray((int)1, (int)-401186905);
        double[] tempcontrol_maxInput = TestHelper.generateDoubleArray((int)1, (int)-799728293);
        double[] tempcontrol_maxOutput = TestHelper.generateDoubleArray((int)1, (int)-519860606);
        double[] tempcontrol_minInput = TestHelper.generateDoubleArray((int)1, (int)-422118589);
        double[] tempcontrol_minOutput = TestHelper.generateDoubleArray((int)1, (int)1865980670);
        String tempcontrol_rebs = "";
        double[] tempcontrol_setTemp = TestHelper.generateDoubleArray((int)1, (int)-756599334);
        double[] tempcontrol_smoothTime = TestHelper.generateDoubleArray((int)1, (int)-1192020434);
        String tempcontrol_tempChans = "a";
        double[] tempcontrol_timeConst = TestHelper.generateDoubleArray((int)1, (int)1436232895);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlConfigurationEvent(version, location, tempcontrol_basePower, tempcontrol_coefD, tempcontrol_coefI, tempcontrol_coefP, tempcontrol_maxInput, tempcontrol_maxOutput, tempcontrol_minInput, tempcontrol_minOutput, tempcontrol_rebs, tempcontrol_setTemp, tempcontrol_smoothTime, tempcontrol_tempChans, tempcontrol_timeConst));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlConfigurationEvent));
        Focal_plane_Raft_RaftTempControlConfigurationEvent item_ = (Focal_plane_Raft_RaftTempControlConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])tempcontrol_basePower, (double[])item_.getTempcontrol_basePower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefD, (double[])item_.getTempcontrol_coefD(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefI, (double[])item_.getTempcontrol_coefI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefP, (double[])item_.getTempcontrol_coefP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxInput, (double[])item_.getTempcontrol_maxInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxOutput, (double[])item_.getTempcontrol_maxOutput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minInput, (double[])item_.getTempcontrol_minInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minOutput, (double[])item_.getTempcontrol_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_rebs, (Object)item_.getTempcontrol_rebs());
        Assert.assertArrayEquals((double[])tempcontrol_setTemp, (double[])item_.getTempcontrol_setTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_smoothTime, (double[])item_.getTempcontrol_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_tempChans, (Object)item_.getTempcontrol_tempChans());
        Assert.assertArrayEquals((double[])tempcontrol_timeConst, (double[])item_.getTempcontrol_timeConst(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlStatusConfigurationEvent() throws Exception {
        String version = "";
        String location = "";
        boolean[] tempcontrol_active = new boolean[]{true};
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlStatusConfigurationEvent(version, location, tempcontrol_active));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlStatusConfigurationEvent));
        Focal_plane_Raft_RaftTempControlStatusConfigurationEvent item_ = (Focal_plane_Raft_RaftTempControlStatusConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((boolean[])tempcontrol_active, (boolean[])item_.getTempcontrol_active());
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPower_LimitsConfigurationEvent() throws Exception {
        String version = "w";
        double warnHi = 0.8761265277862549;
        double warnLo = 0.46057581901550293;
        double limitHi = 0.9353818297386169;
        double limitLo = 0.19551920890808105;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_RebTotalPower_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPower_LimitsConfigurationEvent));
        Focal_plane_RebTotalPower_LimitsConfigurationEvent item_ = (Focal_plane_RebTotalPower_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean[] disabled = new boolean[]{false, true, true};
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_DevicesConfigurationEvent(version, disabled, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_DevicesConfigurationEvent));
        Focal_plane_Reb_DevicesConfigurationEvent item_ = (Focal_plane_Reb_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((boolean[])disabled, (boolean[])item_.getDisabled());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_HardwareIdConfigurationEvent() throws Exception {
        String version = "c";
        String location = "t";
        String name = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_HardwareIdConfigurationEvent(version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_HardwareIdConfigurationEvent));
        Focal_plane_Reb_HardwareIdConfigurationEvent item_ = (Focal_plane_Reb_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double[] anai_warnHi = TestHelper.generateDoubleArray((int)3, (int)639418088);
        double[] anai_warnLo = TestHelper.generateDoubleArray((int)3, (int)2013467549);
        double[] anai_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1307455252);
        double[] anai_limitLo = TestHelper.generateDoubleArray((int)3, (int)328977206);
        double[] anav_warnHi = TestHelper.generateDoubleArray((int)3, (int)-2100221899);
        double[] anav_warnLo = TestHelper.generateDoubleArray((int)3, (int)56504754);
        double[] anav_limitHi = TestHelper.generateDoubleArray((int)3, (int)1673514815);
        double[] anav_limitLo = TestHelper.generateDoubleArray((int)3, (int)1393596098);
        double[] aspicl_Temp0_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1545785992);
        double[] aspicl_Temp0_warnLo = TestHelper.generateDoubleArray((int)3, (int)2132543447);
        double[] aspicl_Temp0_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1760192352);
        double[] aspicl_Temp0_limitLo = TestHelper.generateDoubleArray((int)3, (int)-869769270);
        double[] aspicl_Temp1_warnHi = TestHelper.generateDoubleArray((int)3, (int)-470155428);
        double[] aspicl_Temp1_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1099478714);
        double[] aspicl_Temp1_limitHi = TestHelper.generateDoubleArray((int)3, (int)197809642);
        double[] aspicl_Temp1_limitLo = TestHelper.generateDoubleArray((int)3, (int)-932422568);
        double[] aspicl_Temp2_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1897436847);
        double[] aspicl_Temp2_warnLo = TestHelper.generateDoubleArray((int)3, (int)1627716056);
        double[] aspicl_Temp2_limitHi = TestHelper.generateDoubleArray((int)3, (int)-242333044);
        double[] aspicl_Temp2_limitLo = TestHelper.generateDoubleArray((int)3, (int)997141376);
        double[] aspicu_Temp0_warnHi = TestHelper.generateDoubleArray((int)3, (int)-2121076101);
        double[] aspicu_Temp0_warnLo = TestHelper.generateDoubleArray((int)3, (int)602451439);
        double[] aspicu_Temp0_limitHi = TestHelper.generateDoubleArray((int)3, (int)182509727);
        double[] aspicu_Temp0_limitLo = TestHelper.generateDoubleArray((int)3, (int)1631187433);
        double[] aspicu_Temp1_warnHi = TestHelper.generateDoubleArray((int)3, (int)1742445037);
        double[] aspicu_Temp1_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1590532971);
        double[] aspicu_Temp1_limitHi = TestHelper.generateDoubleArray((int)3, (int)-885857734);
        double[] aspicu_Temp1_limitLo = TestHelper.generateDoubleArray((int)3, (int)63978123);
        double[] aspicu_Temp2_warnHi = TestHelper.generateDoubleArray((int)3, (int)-27745770);
        double[] aspicu_Temp2_warnLo = TestHelper.generateDoubleArray((int)3, (int)322789349);
        double[] aspicu_Temp2_limitHi = TestHelper.generateDoubleArray((int)3, (int)-253594619);
        double[] aspicu_Temp2_limitLo = TestHelper.generateDoubleArray((int)3, (int)-955605063);
        double[] clkhi_warnHi = TestHelper.generateDoubleArray((int)3, (int)436019067);
        double[] clkhi_warnLo = TestHelper.generateDoubleArray((int)3, (int)762945449);
        double[] clkhi_limitHi = TestHelper.generateDoubleArray((int)3, (int)509846796);
        double[] clkhi_limitLo = TestHelper.generateDoubleArray((int)3, (int)1065648226);
        double[] clkhv_warnHi = TestHelper.generateDoubleArray((int)3, (int)249118374);
        double[] clkhv_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1770003900);
        double[] clkhv_limitHi = TestHelper.generateDoubleArray((int)3, (int)1472309205);
        double[] clkhv_limitLo = TestHelper.generateDoubleArray((int)3, (int)1918453139);
        double[] clkli_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1378519715);
        double[] clkli_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1830137902);
        double[] clkli_limitHi = TestHelper.generateDoubleArray((int)3, (int)1741818035);
        double[] clkli_limitLo = TestHelper.generateDoubleArray((int)3, (int)-600703937);
        double[] clklv_warnHi = TestHelper.generateDoubleArray((int)3, (int)911414039);
        double[] clklv_warnLo = TestHelper.generateDoubleArray((int)3, (int)-345361523);
        double[] clklv_limitHi = TestHelper.generateDoubleArray((int)3, (int)-63670948);
        double[] clklv_limitLo = TestHelper.generateDoubleArray((int)3, (int)2129413954);
        double[] digi_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1218386773);
        double[] digi_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1657444494);
        double[] digi_limitHi = TestHelper.generateDoubleArray((int)3, (int)-2050037319);
        double[] digi_limitLo = TestHelper.generateDoubleArray((int)3, (int)842001827);
        double[] digv_warnHi = TestHelper.generateDoubleArray((int)3, (int)-605429942);
        double[] digv_warnLo = TestHelper.generateDoubleArray((int)3, (int)-395553245);
        double[] digv_limitHi = TestHelper.generateDoubleArray((int)3, (int)1981765117);
        double[] digv_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1931966183);
        double[] hvbiasswitch_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1724971345);
        double[] hvbiasswitch_warnLo = TestHelper.generateDoubleArray((int)3, (int)1858320143);
        double[] hvbiasswitch_limitHi = TestHelper.generateDoubleArray((int)3, (int)1975063033);
        double[] hvbiasswitch_limitLo = TestHelper.generateDoubleArray((int)3, (int)-143845168);
        double[] htrv_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1103297900);
        double[] htrv_warnLo = TestHelper.generateDoubleArray((int)3, (int)1271621839);
        double[] htrv_limitHi = TestHelper.generateDoubleArray((int)3, (int)1859498413);
        double[] htrv_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1690862484);
        double[] htrw_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1189013657);
        double[] htrw_warnLo = TestHelper.generateDoubleArray((int)3, (int)31329747);
        double[] htrw_limitHi = TestHelper.generateDoubleArray((int)3, (int)1430654753);
        double[] htrw_limitLo = TestHelper.generateDoubleArray((int)3, (int)-97903794);
        String location = "g";
        double[] odi_warnHi = TestHelper.generateDoubleArray((int)3, (int)478780790);
        double[] odi_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1713226731);
        double[] odi_limitHi = TestHelper.generateDoubleArray((int)3, (int)-290449401);
        double[] odi_limitLo = TestHelper.generateDoubleArray((int)3, (int)-309794292);
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)3, (int)1251957047);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1543909273);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1128622077);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)3, (int)-107681155);
        double[] pclkl_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1685788172);
        double[] pclkl_warnLo = TestHelper.generateDoubleArray((int)3, (int)130267376);
        double[] pclkl_limitHi = TestHelper.generateDoubleArray((int)3, (int)-974864012);
        double[] pclkl_limitLo = TestHelper.generateDoubleArray((int)3, (int)989182381);
        double[] pclku_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1685206767);
        double[] pclku_warnLo = TestHelper.generateDoubleArray((int)3, (int)565822890);
        double[] pclku_limitHi = TestHelper.generateDoubleArray((int)3, (int)296273044);
        double[] pclku_limitLo = TestHelper.generateDoubleArray((int)3, (int)587915650);
        double[] power_warnHi = TestHelper.generateDoubleArray((int)3, (int)1996849627);
        double[] power_warnLo = TestHelper.generateDoubleArray((int)3, (int)1402205791);
        double[] power_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1385478455);
        double[] power_limitLo = TestHelper.generateDoubleArray((int)3, (int)313240268);
        double[] rgl_warnHi = TestHelper.generateDoubleArray((int)3, (int)1227710171);
        double[] rgl_warnLo = TestHelper.generateDoubleArray((int)3, (int)829734763);
        double[] rgl_limitHi = TestHelper.generateDoubleArray((int)3, (int)181191191);
        double[] rgl_limitLo = TestHelper.generateDoubleArray((int)3, (int)897513894);
        double[] rgu_warnHi = TestHelper.generateDoubleArray((int)3, (int)1423382639);
        double[] rgu_warnLo = TestHelper.generateDoubleArray((int)3, (int)-586262842);
        double[] rgu_limitHi = TestHelper.generateDoubleArray((int)3, (int)-915609642);
        double[] rgu_limitLo = TestHelper.generateDoubleArray((int)3, (int)181013538);
        double[] rtdtemp_warnHi = TestHelper.generateDoubleArray((int)3, (int)-85763947);
        double[] rtdtemp_warnLo = TestHelper.generateDoubleArray((int)3, (int)56708417);
        double[] rtdtemp_limitHi = TestHelper.generateDoubleArray((int)3, (int)1098185380);
        double[] rtdtemp_limitLo = TestHelper.generateDoubleArray((int)3, (int)874118948);
        double[] ref05v_warnHi = TestHelper.generateDoubleArray((int)3, (int)1074014218);
        double[] ref05v_warnLo = TestHelper.generateDoubleArray((int)3, (int)1693775888);
        double[] ref05v_limitHi = TestHelper.generateDoubleArray((int)3, (int)-266775652);
        double[] ref05v_limitLo = TestHelper.generateDoubleArray((int)3, (int)-368689778);
        double[] ref125v_warnHi = TestHelper.generateDoubleArray((int)3, (int)-527394669);
        double[] ref125v_warnLo = TestHelper.generateDoubleArray((int)3, (int)1332637320);
        double[] ref125v_limitHi = TestHelper.generateDoubleArray((int)3, (int)-846100793);
        double[] ref125v_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1165476451);
        double[] ref15v_warnHi = TestHelper.generateDoubleArray((int)3, (int)-2143797095);
        double[] ref15v_warnLo = TestHelper.generateDoubleArray((int)3, (int)1920147496);
        double[] ref15v_limitHi = TestHelper.generateDoubleArray((int)3, (int)1208605394);
        double[] ref15v_limitLo = TestHelper.generateDoubleArray((int)3, (int)-985190254);
        double[] ref25v_warnHi = TestHelper.generateDoubleArray((int)3, (int)2033867771);
        double[] ref25v_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1123006755);
        double[] ref25v_limitHi = TestHelper.generateDoubleArray((int)3, (int)-938997759);
        double[] ref25v_limitLo = TestHelper.generateDoubleArray((int)3, (int)1056737428);
        double[] refn12_warnHi = TestHelper.generateDoubleArray((int)3, (int)1152230943);
        double[] refn12_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1263486591);
        double[] refn12_limitHi = TestHelper.generateDoubleArray((int)3, (int)468218467);
        double[] refn12_limitLo = TestHelper.generateDoubleArray((int)3, (int)2013296852);
        double[] refp12_warnHi = TestHelper.generateDoubleArray((int)3, (int)-660389558);
        double[] refp12_warnLo = TestHelper.generateDoubleArray((int)3, (int)-12655963);
        double[] refp12_limitHi = TestHelper.generateDoubleArray((int)3, (int)1085821767);
        double[] refp12_limitLo = TestHelper.generateDoubleArray((int)3, (int)828101618);
        double[] sclkl_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1430241487);
        double[] sclkl_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1347887217);
        double[] sclkl_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1174108690);
        double[] sclkl_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1716589409);
        double[] sclku_warnHi = TestHelper.generateDoubleArray((int)3, (int)462331600);
        double[] sclku_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1831269499);
        double[] sclku_limitHi = TestHelper.generateDoubleArray((int)3, (int)-8655999);
        double[] sclku_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1642898302);
        double[] temp10_warnHi = TestHelper.generateDoubleArray((int)3, (int)-780151943);
        double[] temp10_warnLo = TestHelper.generateDoubleArray((int)3, (int)328563532);
        double[] temp10_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1581278651);
        double[] temp10_limitLo = TestHelper.generateDoubleArray((int)3, (int)1025037663);
        double[] temp1_warnHi = TestHelper.generateDoubleArray((int)3, (int)933767471);
        double[] temp1_warnLo = TestHelper.generateDoubleArray((int)3, (int)-505598741);
        double[] temp1_limitHi = TestHelper.generateDoubleArray((int)3, (int)1185565708);
        double[] temp1_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1990500234);
        double[] temp2_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1126458828);
        double[] temp2_warnLo = TestHelper.generateDoubleArray((int)3, (int)-159256652);
        double[] temp2_limitHi = TestHelper.generateDoubleArray((int)3, (int)-738476050);
        double[] temp2_limitLo = TestHelper.generateDoubleArray((int)3, (int)-130830295);
        double[] temp3_warnHi = TestHelper.generateDoubleArray((int)3, (int)961145312);
        double[] temp3_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1440069500);
        double[] temp3_limitHi = TestHelper.generateDoubleArray((int)3, (int)1424753465);
        double[] temp3_limitLo = TestHelper.generateDoubleArray((int)3, (int)1307076576);
        double[] temp4_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1002366797);
        double[] temp4_warnLo = TestHelper.generateDoubleArray((int)3, (int)-942221751);
        double[] temp4_limitHi = TestHelper.generateDoubleArray((int)3, (int)-688532059);
        double[] temp4_limitLo = TestHelper.generateDoubleArray((int)3, (int)-305037776);
        double[] temp5_warnHi = TestHelper.generateDoubleArray((int)3, (int)1318749614);
        double[] temp5_warnLo = TestHelper.generateDoubleArray((int)3, (int)-356844860);
        double[] temp5_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1821991732);
        double[] temp5_limitLo = TestHelper.generateDoubleArray((int)3, (int)-397599430);
        double[] temp6_warnHi = TestHelper.generateDoubleArray((int)3, (int)700993758);
        double[] temp6_warnLo = TestHelper.generateDoubleArray((int)3, (int)1039190927);
        double[] temp6_limitHi = TestHelper.generateDoubleArray((int)3, (int)-516580648);
        double[] temp6_limitLo = TestHelper.generateDoubleArray((int)3, (int)-730356399);
        double[] temp7_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1262628040);
        double[] temp7_warnLo = TestHelper.generateDoubleArray((int)3, (int)1183616865);
        double[] temp7_limitHi = TestHelper.generateDoubleArray((int)3, (int)881548413);
        double[] temp7_limitLo = TestHelper.generateDoubleArray((int)3, (int)1049540063);
        double[] temp8_warnHi = TestHelper.generateDoubleArray((int)3, (int)1078411180);
        double[] temp8_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1374401647);
        double[] temp8_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1434611159);
        double[] temp8_limitLo = TestHelper.generateDoubleArray((int)3, (int)1073832072);
        double[] temp9_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1190018701);
        double[] temp9_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1062984232);
        double[] temp9_limitHi = TestHelper.generateDoubleArray((int)3, (int)-2028812166);
        double[] temp9_limitLo = TestHelper.generateDoubleArray((int)3, (int)565045903);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_LimitsConfigurationEvent(version, anai_warnHi, anai_warnLo, anai_limitHi, anai_limitLo, anav_warnHi, anav_warnLo, anav_limitHi, anav_limitLo, aspicl_Temp0_warnHi, aspicl_Temp0_warnLo, aspicl_Temp0_limitHi, aspicl_Temp0_limitLo, aspicl_Temp1_warnHi, aspicl_Temp1_warnLo, aspicl_Temp1_limitHi, aspicl_Temp1_limitLo, aspicl_Temp2_warnHi, aspicl_Temp2_warnLo, aspicl_Temp2_limitHi, aspicl_Temp2_limitLo, aspicu_Temp0_warnHi, aspicu_Temp0_warnLo, aspicu_Temp0_limitHi, aspicu_Temp0_limitLo, aspicu_Temp1_warnHi, aspicu_Temp1_warnLo, aspicu_Temp1_limitHi, aspicu_Temp1_limitLo, aspicu_Temp2_warnHi, aspicu_Temp2_warnLo, aspicu_Temp2_limitHi, aspicu_Temp2_limitLo, clkhi_warnHi, clkhi_warnLo, clkhi_limitHi, clkhi_limitLo, clkhv_warnHi, clkhv_warnLo, clkhv_limitHi, clkhv_limitLo, clkli_warnHi, clkli_warnLo, clkli_limitHi, clkli_limitLo, clklv_warnHi, clklv_warnLo, clklv_limitHi, clklv_limitLo, digi_warnHi, digi_warnLo, digi_limitHi, digi_limitLo, digv_warnHi, digv_warnLo, digv_limitHi, digv_limitLo, hvbiasswitch_warnHi, hvbiasswitch_warnLo, hvbiasswitch_limitHi, hvbiasswitch_limitLo, htrv_warnHi, htrv_warnLo, htrv_limitHi, htrv_limitLo, htrw_warnHi, htrw_warnLo, htrw_limitHi, htrw_limitLo, location, odi_warnHi, odi_warnLo, odi_limitHi, odi_limitLo, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, pclkl_warnHi, pclkl_warnLo, pclkl_limitHi, pclkl_limitLo, pclku_warnHi, pclku_warnLo, pclku_limitHi, pclku_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo, rgl_warnHi, rgl_warnLo, rgl_limitHi, rgl_limitLo, rgu_warnHi, rgu_warnLo, rgu_limitHi, rgu_limitLo, rtdtemp_warnHi, rtdtemp_warnLo, rtdtemp_limitHi, rtdtemp_limitLo, ref05v_warnHi, ref05v_warnLo, ref05v_limitHi, ref05v_limitLo, ref125v_warnHi, ref125v_warnLo, ref125v_limitHi, ref125v_limitLo, ref15v_warnHi, ref15v_warnLo, ref15v_limitHi, ref15v_limitLo, ref25v_warnHi, ref25v_warnLo, ref25v_limitHi, ref25v_limitLo, refn12_warnHi, refn12_warnLo, refn12_limitHi, refn12_limitLo, refp12_warnHi, refp12_warnLo, refp12_limitHi, refp12_limitLo, sclkl_warnHi, sclkl_warnLo, sclkl_limitHi, sclkl_limitLo, sclku_warnHi, sclku_warnLo, sclku_limitHi, sclku_limitLo, temp10_warnHi, temp10_warnLo, temp10_limitHi, temp10_limitLo, temp1_warnHi, temp1_warnLo, temp1_limitHi, temp1_limitLo, temp2_warnHi, temp2_warnLo, temp2_limitHi, temp2_limitLo, temp3_warnHi, temp3_warnLo, temp3_limitHi, temp3_limitLo, temp4_warnHi, temp4_warnLo, temp4_limitHi, temp4_limitLo, temp5_warnHi, temp5_warnLo, temp5_limitHi, temp5_limitLo, temp6_warnHi, temp6_warnLo, temp6_limitHi, temp6_limitLo, temp7_warnHi, temp7_warnLo, temp7_limitHi, temp7_limitLo, temp8_warnHi, temp8_warnLo, temp8_limitHi, temp8_limitLo, temp9_warnHi, temp9_warnLo, temp9_limitHi, temp9_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_LimitsConfigurationEvent));
        Focal_plane_Reb_LimitsConfigurationEvent item_ = (Focal_plane_Reb_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])anai_warnHi, (double[])item_.getAnai_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_warnLo, (double[])item_.getAnai_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitHi, (double[])item_.getAnai_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitLo, (double[])item_.getAnai_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnHi, (double[])item_.getAnav_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnLo, (double[])item_.getAnav_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitHi, (double[])item_.getAnav_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitLo, (double[])item_.getAnav_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnHi, (double[])item_.getAspicl_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnLo, (double[])item_.getAspicl_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitHi, (double[])item_.getAspicl_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitLo, (double[])item_.getAspicl_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_warnHi, (double[])item_.getAspicl_Temp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_warnLo, (double[])item_.getAspicl_Temp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_limitHi, (double[])item_.getAspicl_Temp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_limitLo, (double[])item_.getAspicl_Temp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_warnHi, (double[])item_.getAspicl_Temp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_warnLo, (double[])item_.getAspicl_Temp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_limitHi, (double[])item_.getAspicl_Temp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_limitLo, (double[])item_.getAspicl_Temp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnHi, (double[])item_.getAspicu_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnLo, (double[])item_.getAspicu_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitHi, (double[])item_.getAspicu_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitLo, (double[])item_.getAspicu_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_warnHi, (double[])item_.getAspicu_Temp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_warnLo, (double[])item_.getAspicu_Temp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_limitHi, (double[])item_.getAspicu_Temp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_limitLo, (double[])item_.getAspicu_Temp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_warnHi, (double[])item_.getAspicu_Temp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_warnLo, (double[])item_.getAspicu_Temp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_limitHi, (double[])item_.getAspicu_Temp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_limitLo, (double[])item_.getAspicu_Temp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnHi, (double[])item_.getClkhi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnLo, (double[])item_.getClkhi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitHi, (double[])item_.getClkhi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitLo, (double[])item_.getClkhi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnHi, (double[])item_.getClkhv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnLo, (double[])item_.getClkhv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitHi, (double[])item_.getClkhv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitLo, (double[])item_.getClkhv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_warnHi, (double[])item_.getClkli_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_warnLo, (double[])item_.getClkli_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_limitHi, (double[])item_.getClkli_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_limitLo, (double[])item_.getClkli_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnHi, (double[])item_.getClklv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnLo, (double[])item_.getClklv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitHi, (double[])item_.getClklv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitLo, (double[])item_.getClklv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnHi, (double[])item_.getDigi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnLo, (double[])item_.getDigi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitHi, (double[])item_.getDigi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitLo, (double[])item_.getDigi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnHi, (double[])item_.getDigv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnLo, (double[])item_.getDigv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitHi, (double[])item_.getDigv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitLo, (double[])item_.getDigv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnHi, (double[])item_.getHvbiasswitch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnLo, (double[])item_.getHvbiasswitch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitHi, (double[])item_.getHvbiasswitch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitLo, (double[])item_.getHvbiasswitch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnHi, (double[])item_.getHtrv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnLo, (double[])item_.getHtrv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitHi, (double[])item_.getHtrv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitLo, (double[])item_.getHtrv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnHi, (double[])item_.getHtrw_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnLo, (double[])item_.getHtrw_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitHi, (double[])item_.getHtrw_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitLo, (double[])item_.getHtrw_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odi_warnHi, (double[])item_.getOdi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_warnLo, (double[])item_.getOdi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitHi, (double[])item_.getOdi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitLo, (double[])item_.getOdi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnHi, (double[])item_.getPclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnLo, (double[])item_.getPclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitHi, (double[])item_.getPclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitLo, (double[])item_.getPclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnHi, (double[])item_.getPclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnLo, (double[])item_.getPclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitHi, (double[])item_.getPclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitLo, (double[])item_.getPclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnHi, (double[])item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnLo, (double[])item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitHi, (double[])item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitLo, (double[])item_.getPower_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnHi, (double[])item_.getRgl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnLo, (double[])item_.getRgl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitHi, (double[])item_.getRgl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitLo, (double[])item_.getRgl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnHi, (double[])item_.getRgu_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnLo, (double[])item_.getRgu_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitHi, (double[])item_.getRgu_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitLo, (double[])item_.getRgu_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnHi, (double[])item_.getRtdtemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnLo, (double[])item_.getRtdtemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitHi, (double[])item_.getRtdtemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitLo, (double[])item_.getRtdtemp_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_warnHi, (double[])item_.getRef05v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_warnLo, (double[])item_.getRef05v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_limitHi, (double[])item_.getRef05v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_limitLo, (double[])item_.getRef05v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_warnHi, (double[])item_.getRef125v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_warnLo, (double[])item_.getRef125v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_limitHi, (double[])item_.getRef125v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_limitLo, (double[])item_.getRef125v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_warnHi, (double[])item_.getRef15v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_warnLo, (double[])item_.getRef15v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_limitHi, (double[])item_.getRef15v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_limitLo, (double[])item_.getRef15v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_warnHi, (double[])item_.getRef25v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_warnLo, (double[])item_.getRef25v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_limitHi, (double[])item_.getRef25v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_limitLo, (double[])item_.getRef25v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_warnHi, (double[])item_.getRefn12_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_warnLo, (double[])item_.getRefn12_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_limitHi, (double[])item_.getRefn12_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_limitLo, (double[])item_.getRefn12_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_warnHi, (double[])item_.getRefp12_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_warnLo, (double[])item_.getRefp12_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_limitHi, (double[])item_.getRefp12_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_limitLo, (double[])item_.getRefp12_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnHi, (double[])item_.getSclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnLo, (double[])item_.getSclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitHi, (double[])item_.getSclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitLo, (double[])item_.getSclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnHi, (double[])item_.getSclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnLo, (double[])item_.getSclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitHi, (double[])item_.getSclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitLo, (double[])item_.getSclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_warnHi, (double[])item_.getTemp10_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_warnLo, (double[])item_.getTemp10_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_limitHi, (double[])item_.getTemp10_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_limitLo, (double[])item_.getTemp10_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnHi, (double[])item_.getTemp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnLo, (double[])item_.getTemp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitHi, (double[])item_.getTemp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitLo, (double[])item_.getTemp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnHi, (double[])item_.getTemp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnLo, (double[])item_.getTemp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitHi, (double[])item_.getTemp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitLo, (double[])item_.getTemp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnHi, (double[])item_.getTemp3_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnLo, (double[])item_.getTemp3_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitHi, (double[])item_.getTemp3_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitLo, (double[])item_.getTemp3_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnHi, (double[])item_.getTemp4_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnLo, (double[])item_.getTemp4_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitHi, (double[])item_.getTemp4_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitLo, (double[])item_.getTemp4_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnHi, (double[])item_.getTemp5_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnLo, (double[])item_.getTemp5_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitHi, (double[])item_.getTemp5_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitLo, (double[])item_.getTemp5_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnHi, (double[])item_.getTemp6_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnLo, (double[])item_.getTemp6_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitHi, (double[])item_.getTemp6_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitLo, (double[])item_.getTemp6_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_warnHi, (double[])item_.getTemp7_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_warnLo, (double[])item_.getTemp7_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_limitHi, (double[])item_.getTemp7_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_limitLo, (double[])item_.getTemp7_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_warnHi, (double[])item_.getTemp8_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_warnLo, (double[])item_.getTemp8_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_limitHi, (double[])item_.getTemp8_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_limitLo, (double[])item_.getTemp8_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_warnHi, (double[])item_.getTemp9_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_warnLo, (double[])item_.getTemp9_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_limitHi, (double[])item_.getTemp9_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_limitLo, (double[])item_.getTemp9_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsConfigurationEvent() throws Exception {
        String version = "";
        double[] bias0_csGateP = TestHelper.generateDoubleArray((int)3, (int)928030298);
        double[] bias0_gdP = TestHelper.generateDoubleArray((int)3, (int)-1796951056);
        double[] bias0_odP = TestHelper.generateDoubleArray((int)3, (int)-974143367);
        double[] bias0_ogP = TestHelper.generateDoubleArray((int)3, (int)-2051961306);
        double[] bias0_rdP = TestHelper.generateDoubleArray((int)3, (int)-253499929);
        double[] bias1_csGateP = TestHelper.generateDoubleArray((int)3, (int)1743717347);
        double[] bias1_gdP = TestHelper.generateDoubleArray((int)3, (int)-47808529);
        double[] bias1_odP = TestHelper.generateDoubleArray((int)3, (int)1108493183);
        double[] bias1_ogP = TestHelper.generateDoubleArray((int)3, (int)-383527811);
        double[] bias1_rdP = TestHelper.generateDoubleArray((int)3, (int)998502583);
        double[] bias2_csGateP = TestHelper.generateDoubleArray((int)3, (int)-292996120);
        double[] bias2_gdP = TestHelper.generateDoubleArray((int)3, (int)1572424813);
        double[] bias2_odP = TestHelper.generateDoubleArray((int)3, (int)1436697617);
        double[] bias2_ogP = TestHelper.generateDoubleArray((int)3, (int)222230861);
        double[] bias2_rdP = TestHelper.generateDoubleArray((int)3, (int)-425238777);
        double[] dac_pclkHighP = TestHelper.generateDoubleArray((int)3, (int)1054739547);
        double[] dac_pclkLowP = TestHelper.generateDoubleArray((int)3, (int)-1762536562);
        double[] dac_rgHighP = TestHelper.generateDoubleArray((int)3, (int)-144604228);
        double[] dac_rgLowP = TestHelper.generateDoubleArray((int)3, (int)1193988161);
        double[] dac_sclkHighP = TestHelper.generateDoubleArray((int)3, (int)1124318007);
        double[] dac_sclkLowP = TestHelper.generateDoubleArray((int)3, (int)842356254);
        boolean[] disableRTDHardwareCheck = new boolean[]{true, false, true};
        String location = "";
        long[] serialNum = TestHelper.generateLongArray((int)3, (int)-1769728654);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsConfigurationEvent(version, bias0_csGateP, bias0_gdP, bias0_odP, bias0_ogP, bias0_rdP, bias1_csGateP, bias1_gdP, bias1_odP, bias1_ogP, bias1_rdP, bias2_csGateP, bias2_gdP, bias2_odP, bias2_ogP, bias2_rdP, dac_pclkHighP, dac_pclkLowP, dac_rgHighP, dac_rgLowP, dac_sclkHighP, dac_sclkLowP, disableRTDHardwareCheck, location, serialNum));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsConfigurationEvent));
        Focal_plane_Reb_RaftsConfigurationEvent item_ = (Focal_plane_Reb_RaftsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_csGateP, (double[])item_.getBias0_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdP, (double[])item_.getBias0_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odP, (double[])item_.getBias0_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogP, (double[])item_.getBias0_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdP, (double[])item_.getBias0_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_csGateP, (double[])item_.getBias1_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdP, (double[])item_.getBias1_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odP, (double[])item_.getBias1_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogP, (double[])item_.getBias1_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdP, (double[])item_.getBias1_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_csGateP, (double[])item_.getBias2_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdP, (double[])item_.getBias2_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odP, (double[])item_.getBias2_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogP, (double[])item_.getBias2_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdP, (double[])item_.getBias2_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighP, (double[])item_.getDac_pclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowP, (double[])item_.getDac_pclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighP, (double[])item_.getDac_rgHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowP, (double[])item_.getDac_rgLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighP, (double[])item_.getDac_sclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowP, (double[])item_.getDac_sclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((boolean[])disableRTDHardwareCheck, (boolean[])item_.getDisableRTDHardwareCheck());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])serialNum, (long[])item_.getSerialNum());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsLimitsConfigurationEvent() throws Exception {
        String version = "";
        double[] bias0_gdMax = TestHelper.generateDoubleArray((int)3, (int)-1134793784);
        double[] bias0_gdMin = TestHelper.generateDoubleArray((int)3, (int)2128885655);
        double[] bias0_odMax = TestHelper.generateDoubleArray((int)3, (int)366891193);
        double[] bias0_odMin = TestHelper.generateDoubleArray((int)3, (int)531224433);
        double[] bias0_ogMax = TestHelper.generateDoubleArray((int)3, (int)-124404247);
        double[] bias0_ogMin = TestHelper.generateDoubleArray((int)3, (int)-655710492);
        double[] bias0_rdMax = TestHelper.generateDoubleArray((int)3, (int)1415032320);
        double[] bias0_rdMin = TestHelper.generateDoubleArray((int)3, (int)-1795388022);
        double[] bias1_gdMax = TestHelper.generateDoubleArray((int)3, (int)-1738524616);
        double[] bias1_gdMin = TestHelper.generateDoubleArray((int)3, (int)-890208690);
        double[] bias1_odMax = TestHelper.generateDoubleArray((int)3, (int)7031721);
        double[] bias1_odMin = TestHelper.generateDoubleArray((int)3, (int)1409398089);
        double[] bias1_ogMax = TestHelper.generateDoubleArray((int)3, (int)-1078549398);
        double[] bias1_ogMin = TestHelper.generateDoubleArray((int)3, (int)1446821863);
        double[] bias1_rdMax = TestHelper.generateDoubleArray((int)3, (int)500070336);
        double[] bias1_rdMin = TestHelper.generateDoubleArray((int)3, (int)1078941443);
        double[] bias2_gdMax = TestHelper.generateDoubleArray((int)3, (int)377883121);
        double[] bias2_gdMin = TestHelper.generateDoubleArray((int)3, (int)-1784037676);
        double[] bias2_odMax = TestHelper.generateDoubleArray((int)3, (int)2096314227);
        double[] bias2_odMin = TestHelper.generateDoubleArray((int)3, (int)548046560);
        double[] bias2_ogMax = TestHelper.generateDoubleArray((int)3, (int)1107412114);
        double[] bias2_ogMin = TestHelper.generateDoubleArray((int)3, (int)455849045);
        double[] bias2_rdMax = TestHelper.generateDoubleArray((int)3, (int)1323782593);
        double[] bias2_rdMin = TestHelper.generateDoubleArray((int)3, (int)-292770954);
        double[] dac_pclkHighMax = TestHelper.generateDoubleArray((int)3, (int)-720768972);
        double[] dac_pclkHighMin = TestHelper.generateDoubleArray((int)3, (int)-1883430654);
        double[] dac_pclkLowMax = TestHelper.generateDoubleArray((int)3, (int)1057804658);
        double[] dac_pclkLowMin = TestHelper.generateDoubleArray((int)3, (int)-211547468);
        double[] dac_rgHighMax = TestHelper.generateDoubleArray((int)3, (int)1567374843);
        double[] dac_rgHighMin = TestHelper.generateDoubleArray((int)3, (int)1574534742);
        double[] dac_rgLowMax = TestHelper.generateDoubleArray((int)3, (int)1652830790);
        double[] dac_rgLowMin = TestHelper.generateDoubleArray((int)3, (int)-514473727);
        double[] dac_sclkHighMax = TestHelper.generateDoubleArray((int)3, (int)1068795541);
        double[] dac_sclkHighMin = TestHelper.generateDoubleArray((int)3, (int)1781728369);
        double[] dac_sclkLowMax = TestHelper.generateDoubleArray((int)3, (int)1978641777);
        double[] dac_sclkLowMin = TestHelper.generateDoubleArray((int)3, (int)-1459255644);
        String location = "q";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsLimitsConfigurationEvent(version, bias0_gdMax, bias0_gdMin, bias0_odMax, bias0_odMin, bias0_ogMax, bias0_ogMin, bias0_rdMax, bias0_rdMin, bias1_gdMax, bias1_gdMin, bias1_odMax, bias1_odMin, bias1_ogMax, bias1_ogMin, bias1_rdMax, bias1_rdMin, bias2_gdMax, bias2_gdMin, bias2_odMax, bias2_odMin, bias2_ogMax, bias2_ogMin, bias2_rdMax, bias2_rdMin, dac_pclkHighMax, dac_pclkHighMin, dac_pclkLowMax, dac_pclkLowMin, dac_rgHighMax, dac_rgHighMin, dac_rgLowMax, dac_rgLowMin, dac_sclkHighMax, dac_sclkHighMin, dac_sclkLowMax, dac_sclkLowMin, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsLimitsConfigurationEvent));
        Focal_plane_Reb_RaftsLimitsConfigurationEvent item_ = (Focal_plane_Reb_RaftsLimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdMax, (double[])item_.getBias0_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdMin, (double[])item_.getBias0_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMax, (double[])item_.getBias0_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMin, (double[])item_.getBias0_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMax, (double[])item_.getBias0_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMin, (double[])item_.getBias0_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMax, (double[])item_.getBias0_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMin, (double[])item_.getBias0_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdMax, (double[])item_.getBias1_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdMin, (double[])item_.getBias1_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odMax, (double[])item_.getBias1_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odMin, (double[])item_.getBias1_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogMax, (double[])item_.getBias1_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogMin, (double[])item_.getBias1_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdMax, (double[])item_.getBias1_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdMin, (double[])item_.getBias1_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdMax, (double[])item_.getBias2_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdMin, (double[])item_.getBias2_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odMax, (double[])item_.getBias2_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odMin, (double[])item_.getBias2_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogMax, (double[])item_.getBias2_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogMin, (double[])item_.getBias2_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdMax, (double[])item_.getBias2_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdMin, (double[])item_.getBias2_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMax, (double[])item_.getDac_pclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMin, (double[])item_.getDac_pclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMax, (double[])item_.getDac_pclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMin, (double[])item_.getDac_pclkLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMax, (double[])item_.getDac_rgHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMin, (double[])item_.getDac_rgHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMax, (double[])item_.getDac_rgLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMin, (double[])item_.getDac_rgLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMax, (double[])item_.getDac_sclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMin, (double[])item_.getDac_sclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMax, (double[])item_.getDac_sclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMin, (double[])item_.getDac_sclkLowMin(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsPowerConfigurationEvent() throws Exception {
        String version = "y";
        double[] bias0_gdCal = TestHelper.generateDoubleArray((int)3, (int)12102523);
        double[] bias0_gdTestVolts = TestHelper.generateDoubleArray((int)3, (int)1422701825);
        double[] bias0_gdTol = TestHelper.generateDoubleArray((int)3, (int)814026801);
        double[] bias0_gdValueErr = TestHelper.generateDoubleArray((int)3, (int)-1158033292);
        double[] bias0_gdZeroErr = TestHelper.generateDoubleArray((int)3, (int)1461767516);
        double[] bias0_odCal = TestHelper.generateDoubleArray((int)3, (int)-1134548914);
        double[] bias0_odIMax = TestHelper.generateDoubleArray((int)3, (int)1929794281);
        double[] bias0_odTol = TestHelper.generateDoubleArray((int)3, (int)-295004022);
        double[] bias0_odZeroErr = TestHelper.generateDoubleArray((int)3, (int)572622497);
        double[] bias0_ogCal = TestHelper.generateDoubleArray((int)3, (int)297021270);
        double[] bias0_ogTestVolts = TestHelper.generateDoubleArray((int)3, (int)-808871450);
        double[] bias0_ogTol = TestHelper.generateDoubleArray((int)3, (int)-536615346);
        double[] bias0_ogValueErr = TestHelper.generateDoubleArray((int)3, (int)1654612074);
        double[] bias0_ogZeroErr = TestHelper.generateDoubleArray((int)3, (int)-85709142);
        double[] bias0_rdCal = TestHelper.generateDoubleArray((int)3, (int)1225640465);
        double[] bias0_rdTestVolts = TestHelper.generateDoubleArray((int)3, (int)1002510585);
        double[] bias0_rdTol = TestHelper.generateDoubleArray((int)3, (int)596303768);
        double[] bias0_rdValueErr = TestHelper.generateDoubleArray((int)3, (int)-1867516586);
        double[] bias0_rdZeroErr = TestHelper.generateDoubleArray((int)3, (int)-1832271686);
        double[] bias1_gdCal = TestHelper.generateDoubleArray((int)3, (int)1791891260);
        double[] bias1_gdTestVolts = TestHelper.generateDoubleArray((int)3, (int)1135965160);
        double[] bias1_gdTol = TestHelper.generateDoubleArray((int)3, (int)1533116518);
        double[] bias1_gdValueErr = TestHelper.generateDoubleArray((int)3, (int)-472306993);
        double[] bias1_gdZeroErr = TestHelper.generateDoubleArray((int)3, (int)1760012384);
        double[] bias1_odCal = TestHelper.generateDoubleArray((int)3, (int)1159578691);
        double[] bias1_odIMax = TestHelper.generateDoubleArray((int)3, (int)1481437868);
        double[] bias1_odTol = TestHelper.generateDoubleArray((int)3, (int)-1497162935);
        double[] bias1_odZeroErr = TestHelper.generateDoubleArray((int)3, (int)-1090143313);
        double[] bias1_ogCal = TestHelper.generateDoubleArray((int)3, (int)-1950094253);
        double[] bias1_ogTestVolts = TestHelper.generateDoubleArray((int)3, (int)-2047753023);
        double[] bias1_ogTol = TestHelper.generateDoubleArray((int)3, (int)-1330703127);
        double[] bias1_ogValueErr = TestHelper.generateDoubleArray((int)3, (int)441991698);
        double[] bias1_ogZeroErr = TestHelper.generateDoubleArray((int)3, (int)-1374978215);
        double[] bias1_rdCal = TestHelper.generateDoubleArray((int)3, (int)-1615826616);
        double[] bias1_rdTestVolts = TestHelper.generateDoubleArray((int)3, (int)758414116);
        double[] bias1_rdTol = TestHelper.generateDoubleArray((int)3, (int)-872055301);
        double[] bias1_rdValueErr = TestHelper.generateDoubleArray((int)3, (int)851076157);
        double[] bias1_rdZeroErr = TestHelper.generateDoubleArray((int)3, (int)930619769);
        double[] bias2_gdCal = TestHelper.generateDoubleArray((int)3, (int)402366043);
        double[] bias2_gdTestVolts = TestHelper.generateDoubleArray((int)3, (int)-1683821180);
        double[] bias2_gdTol = TestHelper.generateDoubleArray((int)3, (int)-503259418);
        double[] bias2_gdValueErr = TestHelper.generateDoubleArray((int)3, (int)-536601123);
        double[] bias2_gdZeroErr = TestHelper.generateDoubleArray((int)3, (int)1491523406);
        double[] bias2_odCal = TestHelper.generateDoubleArray((int)3, (int)-1706020136);
        double[] bias2_odIMax = TestHelper.generateDoubleArray((int)3, (int)-924296501);
        double[] bias2_odTol = TestHelper.generateDoubleArray((int)3, (int)1165559638);
        double[] bias2_odZeroErr = TestHelper.generateDoubleArray((int)3, (int)-2014485038);
        double[] bias2_ogCal = TestHelper.generateDoubleArray((int)3, (int)-1863475502);
        double[] bias2_ogTestVolts = TestHelper.generateDoubleArray((int)3, (int)776719050);
        double[] bias2_ogTol = TestHelper.generateDoubleArray((int)3, (int)-793895838);
        double[] bias2_ogValueErr = TestHelper.generateDoubleArray((int)3, (int)439944898);
        double[] bias2_ogZeroErr = TestHelper.generateDoubleArray((int)3, (int)-1621212701);
        double[] bias2_rdCal = TestHelper.generateDoubleArray((int)3, (int)123056696);
        double[] bias2_rdTestVolts = TestHelper.generateDoubleArray((int)3, (int)862916256);
        double[] bias2_rdTol = TestHelper.generateDoubleArray((int)3, (int)-1917684429);
        double[] bias2_rdValueErr = TestHelper.generateDoubleArray((int)3, (int)929015608);
        double[] bias2_rdZeroErr = TestHelper.generateDoubleArray((int)3, (int)1420634936);
        double[] clkhiAmin = TestHelper.generateDoubleArray((int)3, (int)902245522);
        double[] clkhiQmax = TestHelper.generateDoubleArray((int)3, (int)-768062742);
        double[] clkliAmin = TestHelper.generateDoubleArray((int)3, (int)-1182818789);
        double[] clkliQmax = TestHelper.generateDoubleArray((int)3, (int)708607568);
        double[] dac_clkhIMax = TestHelper.generateDoubleArray((int)3, (int)-2043747421);
        double[] dac_clklIMax = TestHelper.generateDoubleArray((int)3, (int)595522578);
        double[] dac_pclkHighCal = TestHelper.generateDoubleArray((int)3, (int)811251096);
        double[] dac_pclkHighTestV = TestHelper.generateDoubleArray((int)3, (int)-1089396935);
        double[] dac_pclkHighTol = TestHelper.generateDoubleArray((int)3, (int)-1535058324);
        double[] dac_pclkHighValueErr = TestHelper.generateDoubleArray((int)3, (int)726641193);
        double[] dac_pclkHighZeroErr = TestHelper.generateDoubleArray((int)3, (int)1809075812);
        double[] dac_pclkLowCal = TestHelper.generateDoubleArray((int)3, (int)-1703009547);
        double[] dac_pclkLowTestV = TestHelper.generateDoubleArray((int)3, (int)1110197042);
        double[] dac_pclkLowTol = TestHelper.generateDoubleArray((int)3, (int)885500475);
        double[] dac_pclkLowValueErr = TestHelper.generateDoubleArray((int)3, (int)-1381800198);
        double[] dac_pclkLowZeroErr = TestHelper.generateDoubleArray((int)3, (int)-190348505);
        double[] dac_rgHighCal = TestHelper.generateDoubleArray((int)3, (int)1701697203);
        double[] dac_rgHighTestV = TestHelper.generateDoubleArray((int)3, (int)-2053629357);
        double[] dac_rgHighTol = TestHelper.generateDoubleArray((int)3, (int)815629831);
        double[] dac_rgHighValueErr = TestHelper.generateDoubleArray((int)3, (int)1814938270);
        double[] dac_rgHighZeroErr = TestHelper.generateDoubleArray((int)3, (int)162662178);
        double[] dac_rgLowCal = TestHelper.generateDoubleArray((int)3, (int)1566200365);
        double[] dac_rgLowTestV = TestHelper.generateDoubleArray((int)3, (int)-1227135224);
        double[] dac_rgLowTol = TestHelper.generateDoubleArray((int)3, (int)-568932558);
        double[] dac_rgLowValueErr = TestHelper.generateDoubleArray((int)3, (int)-388095122);
        double[] dac_rgLowZeroErr = TestHelper.generateDoubleArray((int)3, (int)1544780592);
        double[] dac_sclkHighCal = TestHelper.generateDoubleArray((int)3, (int)2120830256);
        double[] dac_sclkHighTestV = TestHelper.generateDoubleArray((int)3, (int)562691283);
        double[] dac_sclkHighTol = TestHelper.generateDoubleArray((int)3, (int)543113930);
        double[] dac_sclkHighValueErr = TestHelper.generateDoubleArray((int)3, (int)322812826);
        double[] dac_sclkHighZeroErr = TestHelper.generateDoubleArray((int)3, (int)720314510);
        double[] dac_sclkLowCal = TestHelper.generateDoubleArray((int)3, (int)-1547495970);
        double[] dac_sclkLowTestV = TestHelper.generateDoubleArray((int)3, (int)-708730775);
        double[] dac_sclkLowTol = TestHelper.generateDoubleArray((int)3, (int)-1487118083);
        double[] dac_sclkLowValueErr = TestHelper.generateDoubleArray((int)3, (int)1792719215);
        double[] dac_sclkLowZeroErr = TestHelper.generateDoubleArray((int)3, (int)-218104654);
        String location = "";
        double[] maxDelta = TestHelper.generateDoubleArray((int)3, (int)-1098662423);
        double[] maxStep = TestHelper.generateDoubleArray((int)3, (int)307822080);
        double[] minTol = TestHelper.generateDoubleArray((int)3, (int)-1771844989);
        int[] nPowerOnPub = TestHelper.generateIntArray((int)3, (int)-1748866125);
        double[] odiAmin = TestHelper.generateDoubleArray((int)3, (int)-1986744598);
        double[] odiQmax = TestHelper.generateDoubleArray((int)3, (int)-1408190920);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsPowerConfigurationEvent(version, bias0_gdCal, bias0_gdTestVolts, bias0_gdTol, bias0_gdValueErr, bias0_gdZeroErr, bias0_odCal, bias0_odIMax, bias0_odTol, bias0_odZeroErr, bias0_ogCal, bias0_ogTestVolts, bias0_ogTol, bias0_ogValueErr, bias0_ogZeroErr, bias0_rdCal, bias0_rdTestVolts, bias0_rdTol, bias0_rdValueErr, bias0_rdZeroErr, bias1_gdCal, bias1_gdTestVolts, bias1_gdTol, bias1_gdValueErr, bias1_gdZeroErr, bias1_odCal, bias1_odIMax, bias1_odTol, bias1_odZeroErr, bias1_ogCal, bias1_ogTestVolts, bias1_ogTol, bias1_ogValueErr, bias1_ogZeroErr, bias1_rdCal, bias1_rdTestVolts, bias1_rdTol, bias1_rdValueErr, bias1_rdZeroErr, bias2_gdCal, bias2_gdTestVolts, bias2_gdTol, bias2_gdValueErr, bias2_gdZeroErr, bias2_odCal, bias2_odIMax, bias2_odTol, bias2_odZeroErr, bias2_ogCal, bias2_ogTestVolts, bias2_ogTol, bias2_ogValueErr, bias2_ogZeroErr, bias2_rdCal, bias2_rdTestVolts, bias2_rdTol, bias2_rdValueErr, bias2_rdZeroErr, clkhiAmin, clkhiQmax, clkliAmin, clkliQmax, dac_clkhIMax, dac_clklIMax, dac_pclkHighCal, dac_pclkHighTestV, dac_pclkHighTol, dac_pclkHighValueErr, dac_pclkHighZeroErr, dac_pclkLowCal, dac_pclkLowTestV, dac_pclkLowTol, dac_pclkLowValueErr, dac_pclkLowZeroErr, dac_rgHighCal, dac_rgHighTestV, dac_rgHighTol, dac_rgHighValueErr, dac_rgHighZeroErr, dac_rgLowCal, dac_rgLowTestV, dac_rgLowTol, dac_rgLowValueErr, dac_rgLowZeroErr, dac_sclkHighCal, dac_sclkHighTestV, dac_sclkHighTol, dac_sclkHighValueErr, dac_sclkHighZeroErr, dac_sclkLowCal, dac_sclkLowTestV, dac_sclkLowTol, dac_sclkLowValueErr, dac_sclkLowZeroErr, location, maxDelta, maxStep, minTol, nPowerOnPub, odiAmin, odiQmax));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsPowerConfigurationEvent));
        Focal_plane_Reb_RaftsPowerConfigurationEvent item_ = (Focal_plane_Reb_RaftsPowerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdCal, (double[])item_.getBias0_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTestVolts, (double[])item_.getBias0_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTol, (double[])item_.getBias0_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdValueErr, (double[])item_.getBias0_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdZeroErr, (double[])item_.getBias0_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odCal, (double[])item_.getBias0_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odIMax, (double[])item_.getBias0_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odTol, (double[])item_.getBias0_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odZeroErr, (double[])item_.getBias0_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogCal, (double[])item_.getBias0_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTestVolts, (double[])item_.getBias0_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTol, (double[])item_.getBias0_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogValueErr, (double[])item_.getBias0_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogZeroErr, (double[])item_.getBias0_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdCal, (double[])item_.getBias0_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTestVolts, (double[])item_.getBias0_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTol, (double[])item_.getBias0_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdValueErr, (double[])item_.getBias0_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdZeroErr, (double[])item_.getBias0_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdCal, (double[])item_.getBias1_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdTestVolts, (double[])item_.getBias1_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdTol, (double[])item_.getBias1_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdValueErr, (double[])item_.getBias1_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdZeroErr, (double[])item_.getBias1_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odCal, (double[])item_.getBias1_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odIMax, (double[])item_.getBias1_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odTol, (double[])item_.getBias1_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odZeroErr, (double[])item_.getBias1_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogCal, (double[])item_.getBias1_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogTestVolts, (double[])item_.getBias1_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogTol, (double[])item_.getBias1_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogValueErr, (double[])item_.getBias1_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogZeroErr, (double[])item_.getBias1_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdCal, (double[])item_.getBias1_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdTestVolts, (double[])item_.getBias1_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdTol, (double[])item_.getBias1_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdValueErr, (double[])item_.getBias1_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdZeroErr, (double[])item_.getBias1_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdCal, (double[])item_.getBias2_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdTestVolts, (double[])item_.getBias2_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdTol, (double[])item_.getBias2_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdValueErr, (double[])item_.getBias2_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdZeroErr, (double[])item_.getBias2_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odCal, (double[])item_.getBias2_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odIMax, (double[])item_.getBias2_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odTol, (double[])item_.getBias2_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odZeroErr, (double[])item_.getBias2_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogCal, (double[])item_.getBias2_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogTestVolts, (double[])item_.getBias2_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogTol, (double[])item_.getBias2_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogValueErr, (double[])item_.getBias2_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogZeroErr, (double[])item_.getBias2_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdCal, (double[])item_.getBias2_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdTestVolts, (double[])item_.getBias2_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdTol, (double[])item_.getBias2_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdValueErr, (double[])item_.getBias2_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdZeroErr, (double[])item_.getBias2_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiAmin, (double[])item_.getClkhiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiQmax, (double[])item_.getClkhiQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliAmin, (double[])item_.getClkliAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliQmax, (double[])item_.getClkliQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clkhIMax, (double[])item_.getDac_clkhIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clklIMax, (double[])item_.getDac_clklIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighCal, (double[])item_.getDac_pclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTestV, (double[])item_.getDac_pclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTol, (double[])item_.getDac_pclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighValueErr, (double[])item_.getDac_pclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighZeroErr, (double[])item_.getDac_pclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowCal, (double[])item_.getDac_pclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTestV, (double[])item_.getDac_pclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTol, (double[])item_.getDac_pclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowValueErr, (double[])item_.getDac_pclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowZeroErr, (double[])item_.getDac_pclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighCal, (double[])item_.getDac_rgHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTestV, (double[])item_.getDac_rgHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTol, (double[])item_.getDac_rgHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighValueErr, (double[])item_.getDac_rgHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighZeroErr, (double[])item_.getDac_rgHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowCal, (double[])item_.getDac_rgLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTestV, (double[])item_.getDac_rgLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTol, (double[])item_.getDac_rgLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowValueErr, (double[])item_.getDac_rgLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowZeroErr, (double[])item_.getDac_rgLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighCal, (double[])item_.getDac_sclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTestV, (double[])item_.getDac_sclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTol, (double[])item_.getDac_sclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighValueErr, (double[])item_.getDac_sclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighZeroErr, (double[])item_.getDac_sclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowCal, (double[])item_.getDac_sclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTestV, (double[])item_.getDac_sclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTol, (double[])item_.getDac_sclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowValueErr, (double[])item_.getDac_sclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowZeroErr, (double[])item_.getDac_sclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])maxDelta, (double[])item_.getMaxDelta(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])maxStep, (double[])item_.getMaxStep(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])minTol, (double[])item_.getMinTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((int[])nPowerOnPub, (int[])item_.getNPowerOnPub());
        Assert.assertArrayEquals((double[])odiAmin, (double[])item_.getOdiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odiQmax, (double[])item_.getOdiQmax(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_timersConfigurationEvent() throws Exception {
        String version = "y";
        String location = "k";
        long[] periodictasks_monitor_check_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)-1621018676);
        long[] periodictasks_monitor_publish_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)1971939871);
        long[] periodictasks_monitor_publish_biasVolt_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)2124218780);
        long[] periodictasks_monitor_publish_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)401431907);
        long[] periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)507132618);
        long[] periodictasks_monitor_publish_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)118684372);
        long[] periodictasks_monitor_publish_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)-154242998);
        long[] periodictasks_monitor_update_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)-879149149);
        long[] periodictasks_monitor_update_biasVolt_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)733265464);
        long[] periodictasks_monitor_update_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)-1537287229);
        long[] periodictasks_monitor_update_ccdCurrent_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)-488707667);
        long[] periodictasks_monitor_update_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)-1497374804);
        long[] periodictasks_monitor_update_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)472345506);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_timersConfigurationEvent(version, location, periodictasks_monitor_check_taskPeriodMillis, periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, periodictasks_monitor_publish_biasVolt_taskPeriodMillis, periodictasks_monitor_publish_boardPower_taskPeriodMillis, periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis, periodictasks_monitor_publish_rebTemp_taskPeriodMillis, periodictasks_monitor_publish_taskPeriodMillis, periodictasks_monitor_update_aspicTemp_taskPeriodMillis, periodictasks_monitor_update_biasVolt_taskPeriodMillis, periodictasks_monitor_update_boardPower_taskPeriodMillis, periodictasks_monitor_update_ccdCurrent_taskPeriodMillis, periodictasks_monitor_update_rebTemp_taskPeriodMillis, periodictasks_monitor_update_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_timersConfigurationEvent));
        Focal_plane_Reb_timersConfigurationEvent item_ = (Focal_plane_Reb_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])periodictasks_monitor_check_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_check_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_biasVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_biasVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_ccdCurrent_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_biasVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_biasVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_ccdCurrent_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_ccdCurrent_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_RebsAverageTemp6_GeneralConfigurationEvent() throws Exception {
        String version = "";
        String chanNames = "";
        String chanWeights = "";
        boolean ignoreNaN = false;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_RebsAverageTemp6_GeneralConfigurationEvent(version, chanNames, chanWeights, ignoreNaN));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebsAverageTemp6_GeneralConfigurationEvent));
        Focal_plane_RebsAverageTemp6_GeneralConfigurationEvent item_ = (Focal_plane_RebsAverageTemp6_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)chanNames, (Object)item_.getChanNames());
        Assert.assertEquals((Object)chanWeights, (Object)item_.getChanWeights());
        Assert.assertEquals((Object)ignoreNaN, (Object)item_.isIgnoreNaN());
    }

    @Test
    public void sendReceiveFocal_plane_RebsAverageTemp6_LimitsConfigurationEvent() throws Exception {
        String version = "j";
        double warnHi = 0.426071f;
        double warnLo = 0.5660336017608643;
        double limitHi = 0.978637158870697;
        double limitLo = 0.0295704f;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_RebsAverageTemp6_LimitsConfigurationEvent(version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebsAverageTemp6_LimitsConfigurationEvent));
        Focal_plane_RebsAverageTemp6_LimitsConfigurationEvent item_ = (Focal_plane_RebsAverageTemp6_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Segment_LimitsConfigurationEvent() throws Exception {
        String version = "a";
        double[] i_warnHi = TestHelper.generateDoubleArray((int)144, (int)512412775);
        double[] i_warnLo = TestHelper.generateDoubleArray((int)144, (int)-944533747);
        double[] i_limitHi = TestHelper.generateDoubleArray((int)144, (int)-157151746);
        double[] i_limitLo = TestHelper.generateDoubleArray((int)144, (int)-1545575539);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Segment_LimitsConfigurationEvent(version, i_warnHi, i_warnLo, i_limitHi, i_limitLo, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Segment_LimitsConfigurationEvent));
        Focal_plane_Segment_LimitsConfigurationEvent item_ = (Focal_plane_Segment_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])i_warnHi, (double[])item_.getI_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_warnLo, (double[])item_.getI_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_limitHi, (double[])item_.getI_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_limitLo, (double[])item_.getI_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_DAQConfigurationEvent() throws Exception {
        String version = "c";
        int badPixelAlarmLimit = 102;
        String daqFolder = "";
        String daqPartition = "";
        boolean emulatedDAQ = true;
        String scienceLocations = "";
        boolean simulatedDAQ = false;
        String simulatedDataFolder = "s";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_DAQConfigurationEvent(version, badPixelAlarmLimit, daqFolder, daqPartition, emulatedDAQ, scienceLocations, simulatedDAQ, simulatedDataFolder));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_DAQConfigurationEvent));
        Focal_plane_SequencerConfig_DAQConfigurationEvent item_ = (Focal_plane_SequencerConfig_DAQConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)badPixelAlarmLimit, (long)item_.getBadPixelAlarmLimit());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
        Assert.assertEquals((Object)emulatedDAQ, (Object)item_.isEmulatedDAQ());
        Assert.assertEquals((Object)scienceLocations, (Object)item_.getScienceLocations());
        Assert.assertEquals((Object)simulatedDAQ, (Object)item_.isSimulatedDAQ());
        Assert.assertEquals((Object)simulatedDataFolder, (Object)item_.getSimulatedDataFolder());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_GuiderConfigurationEvent() throws Exception {
        String version = "";
        String guiderLocations = "";
        String guiderPartition = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_GuiderConfigurationEvent(version, guiderLocations, guiderPartition));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_GuiderConfigurationEvent));
        Focal_plane_SequencerConfig_GuiderConfigurationEvent item_ = (Focal_plane_SequencerConfig_GuiderConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)guiderLocations, (Object)item_.getGuiderLocations());
        Assert.assertEquals((Object)guiderPartition, (Object)item_.getGuiderPartition());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_SequencerConfigurationEvent() throws Exception {
        String version = "h";
        String clearCountParameter = "s";
        String clearMain = "";
        String idleFlushMain = "h";
        long idleFlushTimeout = 921L;
        String integrateMain = "";
        String metaDataRegisters = "f";
        int overCols = 928;
        int overRows = 714;
        int postCols = 555;
        int postRows = 895;
        int preCols = 133;
        int preRows = 111;
        String pseudoReadMain = "";
        int readCols = 213;
        int readCols2 = 30;
        String readMain = "t";
        int readRows = 164;
        String rowShiftForwardMain = "";
        String rowShiftReverseMain = "t";
        boolean scanMode = false;
        String sequencer = "r";
        String sequencerChecksums = "";
        String shiftCountParameter = "p";
        boolean stepAfterIntegrate = true;
        int transparentMode = 604;
        int underCols = 624;
        boolean useParallelRegisters = false;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_SequencerConfigurationEvent(version, clearCountParameter, clearMain, idleFlushMain, idleFlushTimeout, integrateMain, metaDataRegisters, overCols, overRows, postCols, postRows, preCols, preRows, pseudoReadMain, readCols, readCols2, readMain, readRows, rowShiftForwardMain, rowShiftReverseMain, scanMode, sequencer, sequencerChecksums, shiftCountParameter, stepAfterIntegrate, transparentMode, underCols, useParallelRegisters));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_SequencerConfigurationEvent));
        Focal_plane_SequencerConfig_SequencerConfigurationEvent item_ = (Focal_plane_SequencerConfig_SequencerConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)clearCountParameter, (Object)item_.getClearCountParameter());
        Assert.assertEquals((Object)clearMain, (Object)item_.getClearMain());
        Assert.assertEquals((Object)idleFlushMain, (Object)item_.getIdleFlushMain());
        Assert.assertEquals((long)idleFlushTimeout, (long)item_.getIdleFlushTimeout());
        Assert.assertEquals((Object)integrateMain, (Object)item_.getIntegrateMain());
        Assert.assertEquals((Object)metaDataRegisters, (Object)item_.getMetaDataRegisters());
        Assert.assertEquals((long)overCols, (long)item_.getOverCols());
        Assert.assertEquals((long)overRows, (long)item_.getOverRows());
        Assert.assertEquals((long)postCols, (long)item_.getPostCols());
        Assert.assertEquals((long)postRows, (long)item_.getPostRows());
        Assert.assertEquals((long)preCols, (long)item_.getPreCols());
        Assert.assertEquals((long)preRows, (long)item_.getPreRows());
        Assert.assertEquals((Object)pseudoReadMain, (Object)item_.getPseudoReadMain());
        Assert.assertEquals((long)readCols, (long)item_.getReadCols());
        Assert.assertEquals((long)readCols2, (long)item_.getReadCols2());
        Assert.assertEquals((Object)readMain, (Object)item_.getReadMain());
        Assert.assertEquals((long)readRows, (long)item_.getReadRows());
        Assert.assertEquals((Object)rowShiftForwardMain, (Object)item_.getRowShiftForwardMain());
        Assert.assertEquals((Object)rowShiftReverseMain, (Object)item_.getRowShiftReverseMain());
        Assert.assertEquals((Object)scanMode, (Object)item_.isScanMode());
        Assert.assertEquals((Object)sequencer, (Object)item_.getSequencer());
        Assert.assertEquals((Object)sequencerChecksums, (Object)item_.getSequencerChecksums());
        Assert.assertEquals((Object)shiftCountParameter, (Object)item_.getShiftCountParameter());
        Assert.assertEquals((Object)stepAfterIntegrate, (Object)item_.isStepAfterIntegrate());
        Assert.assertEquals((long)transparentMode, (long)item_.getTransparentMode());
        Assert.assertEquals((long)underCols, (long)item_.getUnderCols());
        Assert.assertEquals((Object)useParallelRegisters, (Object)item_.isUseParallelRegisters());
    }

    @Test
    public void sendReceiveFocal_plane_WebHooksConfig_VisualizationConfigurationEvent() throws Exception {
        String version = "";
        String webHooks = "u";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_WebHooksConfig_VisualizationConfigurationEvent(version, webHooks));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_WebHooksConfig_VisualizationConfigurationEvent));
        Focal_plane_WebHooksConfig_VisualizationConfigurationEvent item_ = (Focal_plane_WebHooksConfig_VisualizationConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)webHooks, (Object)item_.getWebHooks());
    }

    @Test
    public void sendReceiveImage_handling_FitsService_GeneralConfigurationEvent() throws Exception {
        String version = "";
        String guider_headerFilesList = "c";
        String science_headerFilesList = "";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_FitsService_GeneralConfigurationEvent(version, guider_headerFilesList, science_headerFilesList));
        Assert.assertTrue((boolean)(item instanceof Image_handling_FitsService_GeneralConfigurationEvent));
        Image_handling_FitsService_GeneralConfigurationEvent item_ = (Image_handling_FitsService_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)guider_headerFilesList, (Object)item_.getGuider_headerFilesList());
        Assert.assertEquals((Object)science_headerFilesList, (Object)item_.getScience_headerFilesList());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_CommandsConfigurationEvent() throws Exception {
        String version = "a";
        String imagehandlingconfig_additionalFileCommands = "v";
        String imagehandlingconfig_additionalFileFilter = "p";
        String imagehandlingconfig_commands = "";
        String imagehandlingconfig_currentDirectory = "";
        String imagehandlingconfig_environment = "";
        String imagehandlingconfig_logDirectory = "";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_CommandsConfigurationEvent(version, imagehandlingconfig_additionalFileCommands, imagehandlingconfig_additionalFileFilter, imagehandlingconfig_commands, imagehandlingconfig_currentDirectory, imagehandlingconfig_environment, imagehandlingconfig_logDirectory));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_CommandsConfigurationEvent));
        Image_handling_ImageHandler_CommandsConfigurationEvent item_ = (Image_handling_ImageHandler_CommandsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)imagehandlingconfig_additionalFileCommands, (Object)item_.getImagehandlingconfig_additionalFileCommands());
        Assert.assertEquals((Object)imagehandlingconfig_additionalFileFilter, (Object)item_.getImagehandlingconfig_additionalFileFilter());
        Assert.assertEquals((Object)imagehandlingconfig_commands, (Object)item_.getImagehandlingconfig_commands());
        Assert.assertEquals((Object)imagehandlingconfig_currentDirectory, (Object)item_.getImagehandlingconfig_currentDirectory());
        Assert.assertEquals((Object)imagehandlingconfig_environment, (Object)item_.getImagehandlingconfig_environment());
        Assert.assertEquals((Object)imagehandlingconfig_logDirectory, (Object)item_.getImagehandlingconfig_logDirectory());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_DAQConfigurationEvent() throws Exception {
        String version = "";
        int imagehandlingconfig_badPixelAlarmLevel = 243;
        int imagehandlingconfig_badPixelHighThreshold = 587;
        int imagehandlingconfig_badPixelLowThreshold = 88;
        int imagehandlingconfig_badPixelWarningLevel = 35;
        boolean imagehandlingconfig_checkForBadPixels = true;
        String imagehandlingconfig_daqFolder = "";
        String imagehandlingconfig_daqPartition = "d";
        int imagehandlingconfig_daqThreads = 272;
        String imagehandlingconfig_locations = "h";
        boolean imagehandlingconfig_useStreaming = true;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_DAQConfigurationEvent(version, imagehandlingconfig_badPixelAlarmLevel, imagehandlingconfig_badPixelHighThreshold, imagehandlingconfig_badPixelLowThreshold, imagehandlingconfig_badPixelWarningLevel, imagehandlingconfig_checkForBadPixels, imagehandlingconfig_daqFolder, imagehandlingconfig_daqPartition, imagehandlingconfig_daqThreads, imagehandlingconfig_locations, imagehandlingconfig_useStreaming));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_DAQConfigurationEvent));
        Image_handling_ImageHandler_DAQConfigurationEvent item_ = (Image_handling_ImageHandler_DAQConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)imagehandlingconfig_badPixelAlarmLevel, (long)item_.getImagehandlingconfig_badPixelAlarmLevel());
        Assert.assertEquals((long)imagehandlingconfig_badPixelHighThreshold, (long)item_.getImagehandlingconfig_badPixelHighThreshold());
        Assert.assertEquals((long)imagehandlingconfig_badPixelLowThreshold, (long)item_.getImagehandlingconfig_badPixelLowThreshold());
        Assert.assertEquals((long)imagehandlingconfig_badPixelWarningLevel, (long)item_.getImagehandlingconfig_badPixelWarningLevel());
        Assert.assertEquals((Object)imagehandlingconfig_checkForBadPixels, (Object)item_.isImagehandlingconfig_checkForBadPixels());
        Assert.assertEquals((Object)imagehandlingconfig_daqFolder, (Object)item_.getImagehandlingconfig_daqFolder());
        Assert.assertEquals((Object)imagehandlingconfig_daqPartition, (Object)item_.getImagehandlingconfig_daqPartition());
        Assert.assertEquals((long)imagehandlingconfig_daqThreads, (long)item_.getImagehandlingconfig_daqThreads());
        Assert.assertEquals((Object)imagehandlingconfig_locations, (Object)item_.getImagehandlingconfig_locations());
        Assert.assertEquals((Object)imagehandlingconfig_useStreaming, (Object)item_.isImagehandlingconfig_useStreaming());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_FitsHandlingConfigurationEvent() throws Exception {
        String version = "a";
        boolean imagehandlingconfig_FITSAutoSave = true;
        String imagehandlingconfig_FITSDirectoryPattern = "u";
        String imagehandlingconfig_FITSFilePattern = "";
        String imagehandlingconfig_FITSRootDirectory = "a";
        boolean imagehandlingconfig_raiseAlertOnMissingOrBadHeaderServiceData = true;
        String imagehandlingconfig_subsystemsToClearOnNewRun = "x";
        String imagehandlingconfig_tempFileRelativeLocation = "i";
        boolean imagehandlingconfig_useTempFile = false;
        String imagehandlingconfig_waitForHeaderService = "r";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_FitsHandlingConfigurationEvent(version, imagehandlingconfig_FITSAutoSave, imagehandlingconfig_FITSDirectoryPattern, imagehandlingconfig_FITSFilePattern, imagehandlingconfig_FITSRootDirectory, imagehandlingconfig_raiseAlertOnMissingOrBadHeaderServiceData, imagehandlingconfig_subsystemsToClearOnNewRun, imagehandlingconfig_tempFileRelativeLocation, imagehandlingconfig_useTempFile, imagehandlingconfig_waitForHeaderService));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_FitsHandlingConfigurationEvent));
        Image_handling_ImageHandler_FitsHandlingConfigurationEvent item_ = (Image_handling_ImageHandler_FitsHandlingConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)imagehandlingconfig_FITSAutoSave, (Object)item_.isImagehandlingconfig_FITSAutoSave());
        Assert.assertEquals((Object)imagehandlingconfig_FITSDirectoryPattern, (Object)item_.getImagehandlingconfig_FITSDirectoryPattern());
        Assert.assertEquals((Object)imagehandlingconfig_FITSFilePattern, (Object)item_.getImagehandlingconfig_FITSFilePattern());
        Assert.assertEquals((Object)imagehandlingconfig_FITSRootDirectory, (Object)item_.getImagehandlingconfig_FITSRootDirectory());
        Assert.assertEquals((Object)imagehandlingconfig_raiseAlertOnMissingOrBadHeaderServiceData, (Object)item_.isImagehandlingconfig_raiseAlertOnMissingOrBadHeaderServiceData());
        Assert.assertEquals((Object)imagehandlingconfig_subsystemsToClearOnNewRun, (Object)item_.getImagehandlingconfig_subsystemsToClearOnNewRun());
        Assert.assertEquals((Object)imagehandlingconfig_tempFileRelativeLocation, (Object)item_.getImagehandlingconfig_tempFileRelativeLocation());
        Assert.assertEquals((Object)imagehandlingconfig_useTempFile, (Object)item_.isImagehandlingconfig_useTempFile());
        Assert.assertEquals((Object)imagehandlingconfig_waitForHeaderService, (Object)item_.getImagehandlingconfig_waitForHeaderService());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_GuiderConfigurationEvent() throws Exception {
        String version = "";
        String imagehandlingconfig_guiderFITSFilePattern = "d";
        String imagehandlingconfig_guiderLocations = "z";
        String imagehandlingconfig_guiderPartition = "";
        boolean imagehandlingconfig_includeRawStamps = true;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_GuiderConfigurationEvent(version, imagehandlingconfig_guiderFITSFilePattern, imagehandlingconfig_guiderLocations, imagehandlingconfig_guiderPartition, imagehandlingconfig_includeRawStamps));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_GuiderConfigurationEvent));
        Image_handling_ImageHandler_GuiderConfigurationEvent item_ = (Image_handling_ImageHandler_GuiderConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)imagehandlingconfig_guiderFITSFilePattern, (Object)item_.getImagehandlingconfig_guiderFITSFilePattern());
        Assert.assertEquals((Object)imagehandlingconfig_guiderLocations, (Object)item_.getImagehandlingconfig_guiderLocations());
        Assert.assertEquals((Object)imagehandlingconfig_guiderPartition, (Object)item_.getImagehandlingconfig_guiderPartition());
        Assert.assertEquals((Object)imagehandlingconfig_includeRawStamps, (Object)item_.isImagehandlingconfig_includeRawStamps());
    }

    @Test
    public void sendReceiveImage_handling_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "e";
        int schedulers_default_nTasks = 600;
        int schedulers_default_nThreads = 477;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads));
        Assert.assertTrue((boolean)(item instanceof Image_handling_PeriodicTasks_GeneralConfigurationEvent));
        Image_handling_PeriodicTasks_GeneralConfigurationEvent item_ = (Image_handling_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
    }

    @Test
    public void sendReceiveImage_handling_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 202L;
        long heartbeat_taskPeriodMillis = 834L;
        long runtimeinfo_taskPeriodMillis = 462L;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Image_handling_PeriodicTasks_timersConfigurationEvent));
        Image_handling_PeriodicTasks_timersConfigurationEvent item_ = (Image_handling_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveImage_handling_StatusAggregator_GeneralConfigurationEvent() throws Exception {
        String version = "v";
        String patternConfigList = "k";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_StatusAggregator_GeneralConfigurationEvent(version, patternConfigList));
        Assert.assertTrue((boolean)(item instanceof Image_handling_StatusAggregator_GeneralConfigurationEvent));
        Image_handling_StatusAggregator_GeneralConfigurationEvent item_ = (Image_handling_StatusAggregator_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)patternConfigList, (Object)item_.getPatternConfigList());
    }

    @Test
    public void sendReceiveMpm_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "";
        int schedulers_default_nTasks = 539;
        int schedulers_default_nThreads = 765;
        int schedulers_monitor_update_publish_scheduler_nTasks = 902;
        int schedulers_monitor_update_publish_scheduler_nThreads = 43;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Mpm_PeriodicTasks_GeneralConfigurationEvent));
        Mpm_PeriodicTasks_GeneralConfigurationEvent item_ = (Mpm_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveMpm_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 529L;
        long heartbeat_taskPeriodMillis = 187L;
        long monitor_check_taskPeriodMillis = 292L;
        long monitor_publish_taskPeriodMillis = 430L;
        long monitor_update_taskPeriodMillis = 99L;
        long protection_state_taskPeriodMillis = 216L;
        long runtimeinfo_taskPeriodMillis = 177L;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, protection_state_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Mpm_PeriodicTasks_timersConfigurationEvent));
        Mpm_PeriodicTasks_timersConfigurationEvent item_ = (Mpm_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)protection_state_taskPeriodMillis, (long)item_.getProtection_state_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveMpm_Pluto_DeviceConfigurationEvent() throws Exception {
        String version = "c";
        String node = "l";
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_Pluto_DeviceConfigurationEvent(version, node));
        Assert.assertTrue((boolean)(item instanceof Mpm_Pluto_DeviceConfigurationEvent));
        Mpm_Pluto_DeviceConfigurationEvent item_ = (Mpm_Pluto_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
    }

    @Test
    public void sendReceiveMpm_Pluto_DevicesConfigurationEvent() throws Exception {
        String version = "e";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Mpm_Pluto_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Mpm_Pluto_DevicesConfigurationEvent));
        Mpm_Pluto_DevicesConfigurationEvent item_ = (Mpm_Pluto_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceivePathfinder_refrig_Cold1_DeviceConfigurationEvent() throws Exception {
        String version = "b";
        String maq20_node = "";
        String maq20_serials = "";
        String plc_node = "x";
        int vfd_address = 522;
        int vfd_baudRate = 453;
        String vfd_devcName = "z";
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cold1_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node, vfd_address, vfd_baudRate, vfd_devcName));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cold1_DeviceConfigurationEvent));
        Pathfinder_refrig_Cold1_DeviceConfigurationEvent item_ = (Pathfinder_refrig_Cold1_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
        Assert.assertEquals((long)vfd_address, (long)item_.getVfd_address());
        Assert.assertEquals((long)vfd_baudRate, (long)item_.getVfd_baudRate());
        Assert.assertEquals((Object)vfd_devcName, (Object)item_.getVfd_devcName());
    }

    @Test
    public void sendReceivePathfinder_refrig_Cold1_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean maq20_disabled = false;
        boolean plc_disabled = false;
        boolean vfd_disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cold1_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled, vfd_disabled));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cold1_DevicesConfigurationEvent));
        Pathfinder_refrig_Cold1_DevicesConfigurationEvent item_ = (Pathfinder_refrig_Cold1_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
        Assert.assertEquals((Object)vfd_disabled, (Object)item_.isVfd_disabled());
    }

    @Test
    public void sendReceivePathfinder_refrig_Cold1_LimitsConfigurationEvent() throws Exception {
        String version = "s";
        double ambienttmp_warnHi = 0.1419163942337036;
        double ambienttmp_warnLo = 0.23200958967208862;
        double ambienttmp_limitHi = 0.621763288974762;
        double ambienttmp_limitLo = 0.1554107666015625;
        double cabinettmp_warnHi = 0.5610649585723877;
        double cabinettmp_warnLo = 0.37559783458709717;
        double cabinettmp_limitHi = 0.32896852493286133;
        double cabinettmp_limitLo = 0.8055156469345093;
        double compcurrent_warnHi = 0.08459645509719849;
        double compcurrent_warnLo = 0.33248448371887207;
        double compcurrent_limitHi = 0.5507811307907104;
        double compcurrent_limitLo = 0.9486668705940247;
        double comppower_warnHi = 0.6936050653457642;
        double comppower_warnLo = 0.5140964984893799;
        double comppower_limitHi = 0.7448531985282898;
        double comppower_limitLo = 0.941771388053894;
        double compvfdcurr_warnHi = 0.7484720349311829;
        double compvfdcurr_warnLo = 0.7645028829574585;
        double compvfdcurr_limitHi = 0.010468602180480957;
        double compvfdcurr_limitLo = 0.6878884434700012;
        double compvfdfreq_warnHi = 0.6218031644821167;
        double compvfdfreq_warnLo = 0.6412501335144043;
        double compvfdfreq_limitHi = 0.8648171424865723;
        double compvfdfreq_limitLo = 0.8498541712760925;
        double compvfdtemp_warnHi = 0.26377958059310913;
        double compvfdtemp_warnLo = 0.3724910616874695;
        double compvfdtemp_limitHi = 0.37040263414382935;
        double compvfdtemp_limitLo = 0.47953593730926514;
        double compvfdvolt_warnHi = 0.7584148049354553;
        double compvfdvolt_warnLo = 0.3092666268348694;
        double compvfdvolt_limitHi = 0.9946192502975464;
        double compvfdvolt_limitLo = 0.8228532075881958;
        double compvoltage_warnHi = 0.8266887664794922;
        double compvoltage_warnLo = 0.140167236328125;
        double compvoltage_limitHi = 0.36675918102264404;
        double compvoltage_limitLo = 0.9616162776947021;
        double coolflowrate_warnHi = 0.20355886220932007;
        double coolflowrate_warnLo = 0.06938314437866211;
        double coolflowrate_limitHi = 0.885668f;
        double coolflowrate_limitLo = 0.4787197709083557;
        double coolvalveposn_warnHi = 0.7090548872947693;
        double coolvalveposn_warnLo = 0.5793200731277466;
        double coolvalveposn_limitHi = 0.5293838381767273;
        double coolvalveposn_limitLo = 0.0858263373374939;
        double dischrgprs_warnHi = 0.8258102536201477;
        double dischrgprs_warnLo = 0.0721203088760376;
        double dischrgprs_limitHi = 0.2859575152397156;
        double dischrgprs_limitLo = 0.12554824352264404;
        double dischrgtmp_M_warnHi = 0.4413476586341858;
        double dischrgtmp_M_warnLo = 0.3928038477897644;
        double dischrgtmp_M_limitHi = 0.1249426007270813;
        double dischrgtmp_M_limitLo = 0.6870742440223694;
        double dischrgtmp_P_warnHi = 0.6962341070175171;
        double dischrgtmp_P_warnLo = 0.02819424867630005;
        double dischrgtmp_P_limitHi = 0.07759493589401245;
        double dischrgtmp_P_limitLo = 0.2796071767807007;
        double eeprvalveposn_warnHi = 0.25997406244277954;
        double eeprvalveposn_warnLo = 0.21378272771835327;
        double eeprvalveposn_limitHi = 0.7095667123794556;
        double eeprvalveposn_limitLo = 0.2569117546081543;
        double fan1speed_warnHi = 0.8244872093200684;
        double fan1speed_warnLo = 0.5943259000778198;
        double fan1speed_limitHi = 0.4248991012573242;
        double fan1speed_limitLo = 0.5343916416168213;
        double fan2speed_warnHi = 0.7275944948196411;
        double fan2speed_warnLo = 0.8179831504821777;
        double fan2speed_limitHi = 0.7096013426780701;
        double fan2speed_limitLo = 0.2837026119232178;
        double fan3speed_warnHi = 0.7916221618652344;
        double fan3speed_warnLo = 0.10853838920593262;
        double fan3speed_limitHi = 0.6353712677955627;
        double fan3speed_limitLo = 0.8158840537071228;
        double hgbvalveposn_warnHi = 0.15866601467132568;
        double hgbvalveposn_warnLo = 0.58169f;
        double hgbvalveposn_limitHi = 0.9305132627487183;
        double hgbvalveposn_limitLo = 0.49988818168640137;
        double liquidsubcooling_warnHi = 0.9259874224662781;
        double liquidsubcooling_warnLo = 0.7411353588104248;
        double liquidsubcooling_limitHi = 0.370410680770874;
        double liquidsubcooling_limitLo = 0.4273747205734253;
        double liquidtmp_M_warnHi = 0.11232644319534302;
        double liquidtmp_M_warnLo = 0.11544859409332275;
        double liquidtmp_M_limitHi = 0.531707f;
        double liquidtmp_M_limitLo = 0.3855026960372925;
        double liquidtmp_P_warnHi = 0.12662345170974731;
        double liquidtmp_P_warnLo = 0.55040442943573;
        double liquidtmp_P_limitHi = 0.4334644079208374;
        double liquidtmp_P_limitLo = 0.18660622835159302;
        double prioilseptmp_warnHi = 0.7508691549301147;
        double prioilseptmp_warnLo = 0.941911518573761;
        double prioilseptmp_limitHi = 0.798945963382721;
        double prioilseptmp_limitLo = 0.3171289563179016;
        double secoilseptmp_warnHi = 0.3028132915496826;
        double secoilseptmp_warnLo = 0.6361914873123169;
        double secoilseptmp_limitHi = 0.610375702381134;
        double secoilseptmp_limitLo = 0.38867151737213135;
        double suctionprs_warnHi = 0.3044389f;
        double suctionprs_warnLo = 0.8059951663017273;
        double suctionprs_limitHi = 0.996269166469574;
        double suctionprs_limitLo = 0.8227730989456177;
        double suctiontmp_P_warnHi = 0.6689545512199402;
        double suctiontmp_P_warnLo = 0.5698431730270386;
        double suctiontmp_P_limitHi = 0.9400115013122559;
        double suctiontmp_P_limitLo = 0.2900077f;
        double waterintmp_warnHi = 0.23121285438537598;
        double waterintmp_warnLo = 0.706488f;
        double waterintmp_limitHi = 0.685739f;
        double waterintmp_limitLo = 0.5056788325309753;
        double waterouttmp_warnHi = 0.810676f;
        double waterouttmp_warnLo = 0.545616090297699;
        double waterouttmp_limitHi = 0.35282236337661743;
        double waterouttmp_limitLo = 0.30199337005615234;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cold1_LimitsConfigurationEvent(version, ambienttmp_warnHi, ambienttmp_warnLo, ambienttmp_limitHi, ambienttmp_limitLo, cabinettmp_warnHi, cabinettmp_warnLo, cabinettmp_limitHi, cabinettmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvfdcurr_warnHi, compvfdcurr_warnLo, compvfdcurr_limitHi, compvfdcurr_limitLo, compvfdfreq_warnHi, compvfdfreq_warnLo, compvfdfreq_limitHi, compvfdfreq_limitLo, compvfdtemp_warnHi, compvfdtemp_warnLo, compvfdtemp_limitHi, compvfdtemp_limitLo, compvfdvolt_warnHi, compvfdvolt_warnLo, compvfdvolt_limitHi, compvfdvolt_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, coolflowrate_warnHi, coolflowrate_warnLo, coolflowrate_limitHi, coolflowrate_limitLo, coolvalveposn_warnHi, coolvalveposn_warnLo, coolvalveposn_limitHi, coolvalveposn_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, eeprvalveposn_warnHi, eeprvalveposn_warnLo, eeprvalveposn_limitHi, eeprvalveposn_limitLo, fan1speed_warnHi, fan1speed_warnLo, fan1speed_limitHi, fan1speed_limitLo, fan2speed_warnHi, fan2speed_warnLo, fan2speed_limitHi, fan2speed_limitLo, fan3speed_warnHi, fan3speed_warnLo, fan3speed_limitHi, fan3speed_limitLo, hgbvalveposn_warnHi, hgbvalveposn_warnLo, hgbvalveposn_limitHi, hgbvalveposn_limitLo, liquidsubcooling_warnHi, liquidsubcooling_warnLo, liquidsubcooling_limitHi, liquidsubcooling_limitLo, liquidtmp_M_warnHi, liquidtmp_M_warnLo, liquidtmp_M_limitHi, liquidtmp_M_limitLo, liquidtmp_P_warnHi, liquidtmp_P_warnLo, liquidtmp_P_limitHi, liquidtmp_P_limitLo, prioilseptmp_warnHi, prioilseptmp_warnLo, prioilseptmp_limitHi, prioilseptmp_limitLo, secoilseptmp_warnHi, secoilseptmp_warnLo, secoilseptmp_limitHi, secoilseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cold1_LimitsConfigurationEvent));
        Pathfinder_refrig_Cold1_LimitsConfigurationEvent item_ = (Pathfinder_refrig_Cold1_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)ambienttmp_warnHi, (double)item_.getAmbienttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnLo, (double)item_.getAmbienttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitHi, (double)item_.getAmbienttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitLo, (double)item_.getAmbienttmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnHi, (double)item_.getCabinettmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnLo, (double)item_.getCabinettmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitHi, (double)item_.getCabinettmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitLo, (double)item_.getCabinettmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_warnHi, (double)item_.getCompvfdcurr_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_warnLo, (double)item_.getCompvfdcurr_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_limitHi, (double)item_.getCompvfdcurr_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_limitLo, (double)item_.getCompvfdcurr_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_warnHi, (double)item_.getCompvfdfreq_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_warnLo, (double)item_.getCompvfdfreq_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_limitHi, (double)item_.getCompvfdfreq_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_limitLo, (double)item_.getCompvfdfreq_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdtemp_warnHi, (double)item_.getCompvfdtemp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdtemp_warnLo, (double)item_.getCompvfdtemp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdtemp_limitHi, (double)item_.getCompvfdtemp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdtemp_limitLo, (double)item_.getCompvfdtemp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_warnHi, (double)item_.getCompvfdvolt_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_warnLo, (double)item_.getCompvfdvolt_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_limitHi, (double)item_.getCompvfdvolt_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_limitLo, (double)item_.getCompvfdvolt_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_warnHi, (double)item_.getCoolflowrate_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_warnLo, (double)item_.getCoolflowrate_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_limitHi, (double)item_.getCoolflowrate_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_limitLo, (double)item_.getCoolflowrate_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_warnHi, (double)item_.getCoolvalveposn_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_warnLo, (double)item_.getCoolvalveposn_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_limitHi, (double)item_.getCoolvalveposn_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_limitLo, (double)item_.getCoolvalveposn_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)eeprvalveposn_warnHi, (double)item_.getEeprvalveposn_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)eeprvalveposn_warnLo, (double)item_.getEeprvalveposn_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)eeprvalveposn_limitHi, (double)item_.getEeprvalveposn_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)eeprvalveposn_limitLo, (double)item_.getEeprvalveposn_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_warnHi, (double)item_.getFan1speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_warnLo, (double)item_.getFan1speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_limitHi, (double)item_.getFan1speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_limitLo, (double)item_.getFan1speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_warnHi, (double)item_.getFan2speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_warnLo, (double)item_.getFan2speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_limitHi, (double)item_.getFan2speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_limitLo, (double)item_.getFan2speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_warnHi, (double)item_.getFan3speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_warnLo, (double)item_.getFan3speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_limitHi, (double)item_.getFan3speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_limitLo, (double)item_.getFan3speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_warnHi, (double)item_.getHgbvalveposn_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_warnLo, (double)item_.getHgbvalveposn_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_limitHi, (double)item_.getHgbvalveposn_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_limitLo, (double)item_.getHgbvalveposn_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_warnHi, (double)item_.getLiquidsubcooling_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_warnLo, (double)item_.getLiquidsubcooling_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_limitHi, (double)item_.getLiquidsubcooling_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_limitLo, (double)item_.getLiquidsubcooling_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_warnHi, (double)item_.getLiquidtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_warnLo, (double)item_.getLiquidtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_limitHi, (double)item_.getLiquidtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_limitLo, (double)item_.getLiquidtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_warnHi, (double)item_.getLiquidtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_warnLo, (double)item_.getLiquidtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_limitHi, (double)item_.getLiquidtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_limitLo, (double)item_.getLiquidtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prioilseptmp_warnHi, (double)item_.getPrioilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prioilseptmp_warnLo, (double)item_.getPrioilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prioilseptmp_limitHi, (double)item_.getPrioilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prioilseptmp_limitLo, (double)item_.getPrioilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)secoilseptmp_warnHi, (double)item_.getSecoilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)secoilseptmp_warnLo, (double)item_.getSecoilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)secoilseptmp_limitHi, (double)item_.getSecoilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)secoilseptmp_limitLo, (double)item_.getSecoilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_Cold1_PicConfigurationEvent() throws Exception {
        String version = "g";
        double fanctrl_awGain = 0.1660524f;
        double fanctrl_baseDuty = 0.3338874578475952;
        double fanctrl_gain = 0.521131f;
        double fanctrl_maxInput = 0.2465037703514099;
        double fanctrl_maxOutput = 0.830807626247406;
        double fanctrl_minInput = 0.10707056522369385;
        double fanctrl_minOutput = 0.9210320711135864;
        double fanctrl_setTemp = 0.1554531455039978;
        double fanctrl_smoothTime = 0.09999215602874756;
        double fanctrl_timeConst = 0.1573919f;
        double fanctrl_tolerance = 0.895658016204834;
        boolean fanctrl_useAbsTemp = false;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cold1_PicConfigurationEvent(version, fanctrl_awGain, fanctrl_baseDuty, fanctrl_gain, fanctrl_maxInput, fanctrl_maxOutput, fanctrl_minInput, fanctrl_minOutput, fanctrl_setTemp, fanctrl_smoothTime, fanctrl_timeConst, fanctrl_tolerance, fanctrl_useAbsTemp));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cold1_PicConfigurationEvent));
        Pathfinder_refrig_Cold1_PicConfigurationEvent item_ = (Pathfinder_refrig_Cold1_PicConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)fanctrl_awGain, (double)item_.getFanctrl_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_baseDuty, (double)item_.getFanctrl_baseDuty(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_gain, (double)item_.getFanctrl_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxInput, (double)item_.getFanctrl_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxOutput, (double)item_.getFanctrl_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minInput, (double)item_.getFanctrl_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minOutput, (double)item_.getFanctrl_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_setTemp, (double)item_.getFanctrl_setTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_smoothTime, (double)item_.getFanctrl_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_timeConst, (double)item_.getFanctrl_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_tolerance, (double)item_.getFanctrl_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((Object)fanctrl_useAbsTemp, (Object)item_.isFanctrl_useAbsTemp());
    }

    @Test
    public void sendReceivePathfinder_refrig_Cold2_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String maq20_node = "";
        String maq20_serials = "w";
        String plc_node = "u";
        int vfd_address = 40;
        int vfd_baudRate = 934;
        String vfd_devcName = "k";
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cold2_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node, vfd_address, vfd_baudRate, vfd_devcName));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cold2_DeviceConfigurationEvent));
        Pathfinder_refrig_Cold2_DeviceConfigurationEvent item_ = (Pathfinder_refrig_Cold2_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
        Assert.assertEquals((long)vfd_address, (long)item_.getVfd_address());
        Assert.assertEquals((long)vfd_baudRate, (long)item_.getVfd_baudRate());
        Assert.assertEquals((Object)vfd_devcName, (Object)item_.getVfd_devcName());
    }

    @Test
    public void sendReceivePathfinder_refrig_Cold2_DevicesConfigurationEvent() throws Exception {
        String version = "p";
        boolean maq20_disabled = true;
        boolean plc_disabled = true;
        boolean vfd_disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cold2_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled, vfd_disabled));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cold2_DevicesConfigurationEvent));
        Pathfinder_refrig_Cold2_DevicesConfigurationEvent item_ = (Pathfinder_refrig_Cold2_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
        Assert.assertEquals((Object)vfd_disabled, (Object)item_.isVfd_disabled());
    }

    @Test
    public void sendReceivePathfinder_refrig_Cold2_LimitsConfigurationEvent() throws Exception {
        String version = "o";
        double ambienttmp_warnHi = 0.42300945520401;
        double ambienttmp_warnLo = 0.6953703761100769;
        double ambienttmp_limitHi = 0.9652260541915894;
        double ambienttmp_limitLo = 0.14212846755981445;
        double cabinettmp_warnHi = 0.733724f;
        double cabinettmp_warnLo = 0.6471393704414368;
        double cabinettmp_limitHi = 0.9887987971305847;
        double cabinettmp_limitLo = 0.9968788623809814;
        double compcurrent_warnHi = 0.8430869579315186;
        double compcurrent_warnLo = 0.3988179f;
        double compcurrent_limitHi = 0.4897953271865845;
        double compcurrent_limitLo = 0.26867908239364624;
        double comppower_warnHi = 0.8790637850761414;
        double comppower_warnLo = 0.2067958116531372;
        double comppower_limitHi = 0.8197957873344421;
        double comppower_limitLo = 0.5233194828033447;
        double compvfdcurr_warnHi = 0.4429087f;
        double compvfdcurr_warnLo = 0.07633805274963379;
        double compvfdcurr_limitHi = 0.021564245223999023;
        double compvfdcurr_limitLo = 0.1617315411567688;
        double compvfdfreq_warnHi = 0.0942736268043518;
        double compvfdfreq_warnLo = 0.15730106830596924;
        double compvfdfreq_limitHi = 0.3211820721626282;
        double compvfdfreq_limitLo = 0.87872f;
        double compvfdtemp_warnHi = 0.04913193f;
        double compvfdtemp_warnLo = 0.9343748688697815;
        double compvfdtemp_limitHi = 0.11765807867050171;
        double compvfdtemp_limitLo = 0.9988874793052673;
        double compvfdvolt_warnHi = 0.7465725541114807;
        double compvfdvolt_warnLo = 0.3558666706085205;
        double compvfdvolt_limitHi = 0.3533428907394409;
        double compvfdvolt_limitLo = 0.996278703212738;
        double compvoltage_warnHi = 0.8528434634208679;
        double compvoltage_warnLo = 0.291401743888855;
        double compvoltage_limitHi = 0.4994316101074219;
        double compvoltage_limitLo = 0.04557693004608154;
        double coolflowrate_warnHi = 0.5686679482460022;
        double coolflowrate_warnLo = 0.2983502149581909;
        double coolflowrate_limitHi = 0.6061123609542847;
        double coolflowrate_limitLo = 0.2985035181045532;
        double coolvalveposn_warnHi = 0.813226f;
        double coolvalveposn_warnLo = 0.7704379558563232;
        double coolvalveposn_limitHi = 0.009990692138671875;
        double coolvalveposn_limitLo = 0.14833104610443115;
        double dischrgprs_warnHi = 0.14033353328704834;
        double dischrgprs_warnLo = 0.6291144490242004;
        double dischrgprs_limitHi = 0.19138479232788086;
        double dischrgprs_limitLo = 0.910206f;
        double dischrgtmp_M_warnHi = 0.6549215912818909;
        double dischrgtmp_M_warnLo = 0.8662184476852417;
        double dischrgtmp_M_limitHi = 0.7756784558296204;
        double dischrgtmp_M_limitLo = 0.6804755330085754;
        double dischrgtmp_P_warnHi = 0.9372109174728394;
        double dischrgtmp_P_warnLo = 0.3508124351501465;
        double dischrgtmp_P_limitHi = 0.8864843845367432;
        double dischrgtmp_P_limitLo = 0.1727469563484192;
        double eeprvalveposn_warnHi = 0.13490456342697144;
        double eeprvalveposn_warnLo = 0.3473753333091736;
        double eeprvalveposn_limitHi = 0.6098875999450684;
        double eeprvalveposn_limitLo = 0.7934238314628601;
        double fan1speed_warnHi = 0.1778220534324646;
        double fan1speed_warnLo = 0.4586156f;
        double fan1speed_limitHi = 0.6101097464561462;
        double fan1speed_limitLo = 0.299530029296875;
        double fan2speed_warnHi = 0.12283968925476074;
        double fan2speed_warnLo = 0.08387166261672974;
        double fan2speed_limitHi = 0.35478538274765015;
        double fan2speed_limitLo = 0.9644457697868347;
        double fan3speed_warnHi = 0.20856934785842896;
        double fan3speed_warnLo = 0.6814109086990356;
        double fan3speed_limitHi = 0.6355234384536743;
        double fan3speed_limitLo = 0.10355937480926514;
        double hgbvalveposn_warnHi = 0.4383151f;
        double hgbvalveposn_warnLo = 0.9260600805282593;
        double hgbvalveposn_limitHi = 0.295015811920166;
        double hgbvalveposn_limitLo = 0.12573248147964478;
        double liquidsubcooling_warnHi = 0.7065396308898926;
        double liquidsubcooling_warnLo = 0.3767498731613159;
        double liquidsubcooling_limitHi = 0.24975663423538208;
        double liquidsubcooling_limitLo = 0.4749488830566406;
        double liquidtmp_M_warnHi = 0.3190044164657593;
        double liquidtmp_M_warnLo = 0.20412278175354004;
        double liquidtmp_M_limitHi = 0.9971677660942078;
        double liquidtmp_M_limitLo = 0.10977274179458618;
        double liquidtmp_P_warnHi = 0.5512157082557678;
        double liquidtmp_P_warnLo = 0.396841824054718;
        double liquidtmp_P_limitHi = 0.052951693534851074;
        double liquidtmp_P_limitLo = 0.6895899176597595;
        double prioilseptmp_warnHi = 0.855726f;
        double prioilseptmp_warnLo = 0.2652818560600281;
        double prioilseptmp_limitHi = 0.9297782182693481;
        double prioilseptmp_limitLo = 0.7525027394294739;
        double secoilseptmp_warnHi = 0.8187400698661804;
        double secoilseptmp_warnLo = 0.9196393489837646;
        double secoilseptmp_limitHi = 0.8585658669471741;
        double secoilseptmp_limitLo = 0.6897554993629456;
        double suctionprs_warnHi = 0.7235310673713684;
        double suctionprs_warnLo = 0.2210521101951599;
        double suctionprs_limitHi = 8.614659309387207E-4;
        double suctionprs_limitLo = 0.758385f;
        double suctiontmp_P_warnHi = 0.986163318157196;
        double suctiontmp_P_warnLo = 0.8220734000205994;
        double suctiontmp_P_limitHi = 0.2030126452445984;
        double suctiontmp_P_limitLo = 0.1932382583618164;
        double waterintmp_warnHi = 0.062367022037506104;
        double waterintmp_warnLo = 0.7379392981529236;
        double waterintmp_limitHi = 0.7134362459182739;
        double waterintmp_limitLo = 0.3505188226699829;
        double waterouttmp_warnHi = 0.09814947843551636;
        double waterouttmp_warnLo = 0.16175276041030884;
        double waterouttmp_limitHi = 0.8024162650108337;
        double waterouttmp_limitLo = 0.8596912026405334;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cold2_LimitsConfigurationEvent(version, ambienttmp_warnHi, ambienttmp_warnLo, ambienttmp_limitHi, ambienttmp_limitLo, cabinettmp_warnHi, cabinettmp_warnLo, cabinettmp_limitHi, cabinettmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvfdcurr_warnHi, compvfdcurr_warnLo, compvfdcurr_limitHi, compvfdcurr_limitLo, compvfdfreq_warnHi, compvfdfreq_warnLo, compvfdfreq_limitHi, compvfdfreq_limitLo, compvfdtemp_warnHi, compvfdtemp_warnLo, compvfdtemp_limitHi, compvfdtemp_limitLo, compvfdvolt_warnHi, compvfdvolt_warnLo, compvfdvolt_limitHi, compvfdvolt_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, coolflowrate_warnHi, coolflowrate_warnLo, coolflowrate_limitHi, coolflowrate_limitLo, coolvalveposn_warnHi, coolvalveposn_warnLo, coolvalveposn_limitHi, coolvalveposn_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, eeprvalveposn_warnHi, eeprvalveposn_warnLo, eeprvalveposn_limitHi, eeprvalveposn_limitLo, fan1speed_warnHi, fan1speed_warnLo, fan1speed_limitHi, fan1speed_limitLo, fan2speed_warnHi, fan2speed_warnLo, fan2speed_limitHi, fan2speed_limitLo, fan3speed_warnHi, fan3speed_warnLo, fan3speed_limitHi, fan3speed_limitLo, hgbvalveposn_warnHi, hgbvalveposn_warnLo, hgbvalveposn_limitHi, hgbvalveposn_limitLo, liquidsubcooling_warnHi, liquidsubcooling_warnLo, liquidsubcooling_limitHi, liquidsubcooling_limitLo, liquidtmp_M_warnHi, liquidtmp_M_warnLo, liquidtmp_M_limitHi, liquidtmp_M_limitLo, liquidtmp_P_warnHi, liquidtmp_P_warnLo, liquidtmp_P_limitHi, liquidtmp_P_limitLo, prioilseptmp_warnHi, prioilseptmp_warnLo, prioilseptmp_limitHi, prioilseptmp_limitLo, secoilseptmp_warnHi, secoilseptmp_warnLo, secoilseptmp_limitHi, secoilseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cold2_LimitsConfigurationEvent));
        Pathfinder_refrig_Cold2_LimitsConfigurationEvent item_ = (Pathfinder_refrig_Cold2_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)ambienttmp_warnHi, (double)item_.getAmbienttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnLo, (double)item_.getAmbienttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitHi, (double)item_.getAmbienttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitLo, (double)item_.getAmbienttmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnHi, (double)item_.getCabinettmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnLo, (double)item_.getCabinettmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitHi, (double)item_.getCabinettmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitLo, (double)item_.getCabinettmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_warnHi, (double)item_.getCompvfdcurr_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_warnLo, (double)item_.getCompvfdcurr_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_limitHi, (double)item_.getCompvfdcurr_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_limitLo, (double)item_.getCompvfdcurr_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_warnHi, (double)item_.getCompvfdfreq_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_warnLo, (double)item_.getCompvfdfreq_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_limitHi, (double)item_.getCompvfdfreq_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_limitLo, (double)item_.getCompvfdfreq_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdtemp_warnHi, (double)item_.getCompvfdtemp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdtemp_warnLo, (double)item_.getCompvfdtemp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdtemp_limitHi, (double)item_.getCompvfdtemp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdtemp_limitLo, (double)item_.getCompvfdtemp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_warnHi, (double)item_.getCompvfdvolt_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_warnLo, (double)item_.getCompvfdvolt_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_limitHi, (double)item_.getCompvfdvolt_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_limitLo, (double)item_.getCompvfdvolt_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_warnHi, (double)item_.getCoolflowrate_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_warnLo, (double)item_.getCoolflowrate_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_limitHi, (double)item_.getCoolflowrate_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_limitLo, (double)item_.getCoolflowrate_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_warnHi, (double)item_.getCoolvalveposn_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_warnLo, (double)item_.getCoolvalveposn_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_limitHi, (double)item_.getCoolvalveposn_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_limitLo, (double)item_.getCoolvalveposn_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)eeprvalveposn_warnHi, (double)item_.getEeprvalveposn_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)eeprvalveposn_warnLo, (double)item_.getEeprvalveposn_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)eeprvalveposn_limitHi, (double)item_.getEeprvalveposn_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)eeprvalveposn_limitLo, (double)item_.getEeprvalveposn_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_warnHi, (double)item_.getFan1speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_warnLo, (double)item_.getFan1speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_limitHi, (double)item_.getFan1speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_limitLo, (double)item_.getFan1speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_warnHi, (double)item_.getFan2speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_warnLo, (double)item_.getFan2speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_limitHi, (double)item_.getFan2speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_limitLo, (double)item_.getFan2speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_warnHi, (double)item_.getFan3speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_warnLo, (double)item_.getFan3speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_limitHi, (double)item_.getFan3speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_limitLo, (double)item_.getFan3speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_warnHi, (double)item_.getHgbvalveposn_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_warnLo, (double)item_.getHgbvalveposn_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_limitHi, (double)item_.getHgbvalveposn_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_limitLo, (double)item_.getHgbvalveposn_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_warnHi, (double)item_.getLiquidsubcooling_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_warnLo, (double)item_.getLiquidsubcooling_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_limitHi, (double)item_.getLiquidsubcooling_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_limitLo, (double)item_.getLiquidsubcooling_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_warnHi, (double)item_.getLiquidtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_warnLo, (double)item_.getLiquidtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_limitHi, (double)item_.getLiquidtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_limitLo, (double)item_.getLiquidtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_warnHi, (double)item_.getLiquidtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_warnLo, (double)item_.getLiquidtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_limitHi, (double)item_.getLiquidtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_limitLo, (double)item_.getLiquidtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prioilseptmp_warnHi, (double)item_.getPrioilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prioilseptmp_warnLo, (double)item_.getPrioilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prioilseptmp_limitHi, (double)item_.getPrioilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prioilseptmp_limitLo, (double)item_.getPrioilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)secoilseptmp_warnHi, (double)item_.getSecoilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)secoilseptmp_warnLo, (double)item_.getSecoilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)secoilseptmp_limitHi, (double)item_.getSecoilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)secoilseptmp_limitLo, (double)item_.getSecoilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_Cold2_PicConfigurationEvent() throws Exception {
        String version = "";
        double fanctrl_awGain = 0.27237361669540405;
        double fanctrl_baseDuty = 0.9842463135719299;
        double fanctrl_gain = 0.8040790557861328;
        double fanctrl_maxInput = 0.344898521900177;
        double fanctrl_maxOutput = 0.7289501428604126;
        double fanctrl_minInput = 0.9045096039772034;
        double fanctrl_minOutput = 0.7711588144302368;
        double fanctrl_setTemp = 0.22900527715682983;
        double fanctrl_smoothTime = 0.6242959499359131;
        double fanctrl_timeConst = 0.796847939491272;
        double fanctrl_tolerance = 0.19282597303390503;
        boolean fanctrl_useAbsTemp = false;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cold2_PicConfigurationEvent(version, fanctrl_awGain, fanctrl_baseDuty, fanctrl_gain, fanctrl_maxInput, fanctrl_maxOutput, fanctrl_minInput, fanctrl_minOutput, fanctrl_setTemp, fanctrl_smoothTime, fanctrl_timeConst, fanctrl_tolerance, fanctrl_useAbsTemp));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cold2_PicConfigurationEvent));
        Pathfinder_refrig_Cold2_PicConfigurationEvent item_ = (Pathfinder_refrig_Cold2_PicConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)fanctrl_awGain, (double)item_.getFanctrl_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_baseDuty, (double)item_.getFanctrl_baseDuty(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_gain, (double)item_.getFanctrl_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxInput, (double)item_.getFanctrl_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxOutput, (double)item_.getFanctrl_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minInput, (double)item_.getFanctrl_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minOutput, (double)item_.getFanctrl_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_setTemp, (double)item_.getFanctrl_setTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_smoothTime, (double)item_.getFanctrl_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_timeConst, (double)item_.getFanctrl_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_tolerance, (double)item_.getFanctrl_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((Object)fanctrl_useAbsTemp, (Object)item_.isFanctrl_useAbsTemp());
    }

    @Test
    public void sendReceivePathfinder_refrig_ColdCompLimits_CompLimitsConfigurationEvent() throws Exception {
        String version = "";
        double cmprPowerDelayLimit = 0.3753041625022888;
        int cmprPowerDelayTime = 669;
        double cmprPowerImmedLimit = 0.5050604343414307;
        double discPressDelayLimit = 0.06370240449905396;
        int discPressDelayTime = 438;
        double discPressImmedLimit = 0.06612330675125122;
        double discTempDelayLimit = 0.24641722440719604;
        int discTempDelayTime = 865;
        double discTempImmedLimit = 0.5330145359039307;
        double liquidTempDelayLimit = 0.7250893115997314;
        int liquidTempDelayTime = 390;
        double liquidTempImmedLimit = 0.5705804228782654;
        double suctTempImmedLimit = 0.3904784321784973;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_ColdCompLimits_CompLimitsConfigurationEvent(version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_ColdCompLimits_CompLimitsConfigurationEvent));
        Pathfinder_refrig_ColdCompLimits_CompLimitsConfigurationEvent item_ = (Pathfinder_refrig_ColdCompLimits_CompLimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_CoolMaq20_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String node = "j";
        String serials = "";
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_CoolMaq20_DeviceConfigurationEvent(version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_CoolMaq20_DeviceConfigurationEvent));
        Pathfinder_refrig_CoolMaq20_DeviceConfigurationEvent item_ = (Pathfinder_refrig_CoolMaq20_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceivePathfinder_refrig_CoolMaq20_DevicesConfigurationEvent() throws Exception {
        String version = "l";
        boolean disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_CoolMaq20_DevicesConfigurationEvent(version, disabled));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_CoolMaq20_DevicesConfigurationEvent));
        Pathfinder_refrig_CoolMaq20_DevicesConfigurationEvent item_ = (Pathfinder_refrig_CoolMaq20_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)disabled, (Object)item_.isDisabled());
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo1_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String maq20_node = "";
        String maq20_serials = "";
        String plc_node = "w";
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cryo1_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo1_DeviceConfigurationEvent));
        Pathfinder_refrig_Cryo1_DeviceConfigurationEvent item_ = (Pathfinder_refrig_Cryo1_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo1_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean maq20_disabled = true;
        boolean plc_disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cryo1_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo1_DevicesConfigurationEvent));
        Pathfinder_refrig_Cryo1_DevicesConfigurationEvent item_ = (Pathfinder_refrig_Cryo1_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo1_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double aftercooltmp_warnHi = 0.3604347f;
        double aftercooltmp_warnLo = 0.716579020023346;
        double aftercooltmp_limitHi = 0.8807411193847656;
        double aftercooltmp_limitLo = 0.22478598356246948;
        double compcurrent_warnHi = 0.01323777437210083;
        double compcurrent_warnLo = 0.48775774240493774;
        double compcurrent_limitHi = 0.3348802924156189;
        double compcurrent_limitLo = 0.03337627649307251;
        double comppower_warnHi = 0.5512261986732483;
        double comppower_warnLo = 0.3685334324836731;
        double comppower_limitHi = 0.14840304851531982;
        double comppower_limitLo = 0.5868754982948303;
        double compvoltage_warnHi = 0.2468433380126953;
        double compvoltage_warnLo = 0.5710065364837646;
        double compvoltage_limitHi = 0.1229315996170044;
        double compvoltage_limitLo = 0.36650723218917847;
        double dischrgprs_warnHi = 0.3143569827079773;
        double dischrgprs_warnLo = 0.7865678668022156;
        double dischrgprs_limitHi = 0.7533522248268127;
        double dischrgprs_limitLo = 0.189189612865448;
        double dischrgtmp_M_warnHi = 0.4931233525276184;
        double dischrgtmp_M_warnLo = 0.5774151682853699;
        double dischrgtmp_M_limitHi = 0.10885119438171387;
        double dischrgtmp_M_limitLo = 0.18275481462478638;
        double dischrgtmp_P_warnHi = 0.6625542044639587;
        double dischrgtmp_P_warnLo = 0.65358f;
        double dischrgtmp_P_limitHi = 0.4216992259025574;
        double dischrgtmp_P_limitLo = 0.49060964584350586;
        double fanspeed_warnHi = 0.576188862323761;
        double fanspeed_warnLo = 0.7076285481452942;
        double fanspeed_limitHi = 0.8091249465942383;
        double fanspeed_limitLo = 0.5208961963653564;
        double oillevel_warnHi = 0.745803952217102;
        double oillevel_warnLo = 0.4315042495727539;
        double oillevel_limitHi = 0.06382858753204346;
        double oillevel_limitLo = 0.44760453701019287;
        double oilseptmp_warnHi = 0.22132503986358643;
        double oilseptmp_warnLo = 0.582874059677124;
        double oilseptmp_limitHi = 0.47678375244140625;
        double oilseptmp_limitLo = 0.9815229177474976;
        double phaseseptmp_warnHi = 0.8861351013183594;
        double phaseseptmp_warnLo = 0.26060914993286133;
        double phaseseptmp_limitHi = 0.40995967388153076;
        double phaseseptmp_limitLo = 0.3302185535430908;
        double suctionprs_warnHi = 0.2610187530517578;
        double suctionprs_warnLo = 0.540095865726471;
        double suctionprs_limitHi = 0.1026091f;
        double suctionprs_limitLo = 0.4469099f;
        double suctiontmp_M_warnHi = 0.22739005088806152;
        double suctiontmp_M_warnLo = 0.09896194934844971;
        double suctiontmp_M_limitHi = 0.5870565176010132;
        double suctiontmp_M_limitLo = 0.5822194218635559;
        double suctiontmp_P_warnHi = 0.5386918187141418;
        double suctiontmp_P_warnLo = 0.6131938695907593;
        double suctiontmp_P_limitHi = 0.8008796572685242;
        double suctiontmp_P_limitLo = 0.2701093554496765;
        double surgetanktmp_warnHi = 0.18812376260757446;
        double surgetanktmp_warnLo = 0.3437894f;
        double surgetanktmp_limitHi = 0.0325050950050354;
        double surgetanktmp_limitLo = 0.9351528882980347;
        double waterintmp_warnHi = 0.2944710850715637;
        double waterintmp_warnLo = 0.17696022987365723;
        double waterintmp_limitHi = 0.8251739144325256;
        double waterintmp_limitLo = 0.5536596179008484;
        double waterouttmp_warnHi = 0.012217521667480469;
        double waterouttmp_warnLo = 0.2790037989616394;
        double waterouttmp_limitHi = 0.8167297840118408;
        double waterouttmp_limitLo = 0.2526538372039795;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cryo1_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo1_LimitsConfigurationEvent));
        Pathfinder_refrig_Cryo1_LimitsConfigurationEvent item_ = (Pathfinder_refrig_Cryo1_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo2_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String maq20_node = "d";
        String maq20_serials = "";
        String plc_node = "u";
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cryo2_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo2_DeviceConfigurationEvent));
        Pathfinder_refrig_Cryo2_DeviceConfigurationEvent item_ = (Pathfinder_refrig_Cryo2_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo2_DevicesConfigurationEvent() throws Exception {
        String version = "b";
        boolean maq20_disabled = true;
        boolean plc_disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cryo2_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo2_DevicesConfigurationEvent));
        Pathfinder_refrig_Cryo2_DevicesConfigurationEvent item_ = (Pathfinder_refrig_Cryo2_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo2_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double aftercooltmp_warnHi = 0.24338674545288086;
        double aftercooltmp_warnLo = 0.2175209f;
        double aftercooltmp_limitHi = 0.24748414754867554;
        double aftercooltmp_limitLo = 0.3773950934410095;
        double ambienttmp_warnHi = 0.0967077f;
        double ambienttmp_warnLo = 0.3596503f;
        double ambienttmp_limitHi = 0.41401517391204834;
        double ambienttmp_limitLo = 0.8236048221588135;
        double cabinettmp_warnHi = 0.64303f;
        double cabinettmp_warnLo = 0.7711450457572937;
        double cabinettmp_limitHi = 0.6237296462059021;
        double cabinettmp_limitLo = 0.023287057876586914;
        double compcurrent_warnHi = 0.40233057737350464;
        double compcurrent_warnLo = 0.4228951930999756;
        double compcurrent_limitHi = 0.2748332f;
        double compcurrent_limitLo = 0.30031102895736694;
        double comppower_warnHi = 0.6927521824836731;
        double comppower_warnLo = 0.037424683570861816;
        double comppower_limitHi = 0.2015022f;
        double comppower_limitLo = 0.024693548679351807;
        double compvoltage_warnHi = 0.7132042646408081;
        double compvoltage_warnLo = 0.4456857442855835;
        double compvoltage_limitHi = 0.9054670929908752;
        double compvoltage_limitLo = 0.3275317f;
        double dischrgprs_warnHi = 0.17269080877304077;
        double dischrgprs_warnLo = 0.9117224216461182;
        double dischrgprs_limitHi = 0.9080513715744019;
        double dischrgprs_limitLo = 0.40556687116622925;
        double dischrgtmp_M_warnHi = 0.7757561802864075;
        double dischrgtmp_M_warnLo = 0.793748f;
        double dischrgtmp_M_limitHi = 0.250373f;
        double dischrgtmp_M_limitLo = 0.08731728792190552;
        double dischrgtmp_P_warnHi = 0.9066471457481384;
        double dischrgtmp_P_warnLo = 0.7543467879295349;
        double dischrgtmp_P_limitHi = 0.6659121513366699;
        double dischrgtmp_P_limitLo = 0.03457885980606079;
        double fanspeed_warnHi = 0.012080729007720947;
        double fanspeed_warnLo = 0.1956343650817871;
        double fanspeed_limitHi = 0.1312609314918518;
        double fanspeed_limitLo = 0.17674553394317627;
        double oillevel_warnHi = 0.1836094856262207;
        double oillevel_warnLo = 0.6274861693382263;
        double oillevel_limitHi = 0.4388948678970337;
        double oillevel_limitLo = 0.9913501739501953;
        double oilseptmp_warnHi = 0.27084267139434814;
        double oilseptmp_warnLo = 0.18169403076171875;
        double oilseptmp_limitHi = 0.09214985370635986;
        double oilseptmp_limitLo = 0.4011055827140808;
        double phaseseptmp_warnHi = 0.017182588577270508;
        double phaseseptmp_warnLo = 0.568577766418457;
        double phaseseptmp_limitHi = 0.2997971177101135;
        double phaseseptmp_limitLo = 0.03229391574859619;
        double suctionprs_warnHi = 0.46688413619995117;
        double suctionprs_warnLo = 0.9947351813316345;
        double suctionprs_limitHi = 0.6388403177261353;
        double suctionprs_limitLo = 0.6264894604682922;
        double suctiontmp_M_warnHi = 0.5283551812171936;
        double suctiontmp_M_warnLo = 0.18395566940307617;
        double suctiontmp_M_limitHi = 0.1932077407836914;
        double suctiontmp_M_limitLo = 0.6003178954124451;
        double suctiontmp_P_warnHi = 0.6415472626686096;
        double suctiontmp_P_warnLo = 0.8836649656295776;
        double suctiontmp_P_limitHi = 0.6872890591621399;
        double suctiontmp_P_limitLo = 0.26738274097442627;
        double surgetanktmp_warnHi = 0.05051279067993164;
        double surgetanktmp_warnLo = 0.5155674815177917;
        double surgetanktmp_limitHi = 0.4818124771118164;
        double surgetanktmp_limitLo = 0.5618872046470642;
        double waterintmp_warnHi = 0.05482828617095947;
        double waterintmp_warnLo = 0.8134623169898987;
        double waterintmp_limitHi = 0.8410322666168213;
        double waterintmp_limitLo = 0.3022293448448181;
        double waterouttmp_warnHi = 0.6503296494483948;
        double waterouttmp_warnLo = 0.9587438702583313;
        double waterouttmp_limitHi = 0.8108999133110046;
        double waterouttmp_limitLo = 4.579425E-4f;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cryo2_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, ambienttmp_warnHi, ambienttmp_warnLo, ambienttmp_limitHi, ambienttmp_limitLo, cabinettmp_warnHi, cabinettmp_warnLo, cabinettmp_limitHi, cabinettmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo2_LimitsConfigurationEvent));
        Pathfinder_refrig_Cryo2_LimitsConfigurationEvent item_ = (Pathfinder_refrig_Cryo2_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnHi, (double)item_.getAmbienttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnLo, (double)item_.getAmbienttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitHi, (double)item_.getAmbienttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitLo, (double)item_.getAmbienttmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnHi, (double)item_.getCabinettmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnLo, (double)item_.getCabinettmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitHi, (double)item_.getCabinettmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitLo, (double)item_.getCabinettmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo2_PicConfigurationEvent() throws Exception {
        String version = "";
        double fanctrl_awGain = 0.4031602740287781;
        double fanctrl_baseDuty = 0.4547199010848999;
        double fanctrl_gain = 0.9335781931877136;
        double fanctrl_maxInput = 0.6341502070426941;
        double fanctrl_maxOutput = 0.9904511570930481;
        double fanctrl_minInput = 0.30330485105514526;
        double fanctrl_minOutput = 0.9470493793487549;
        double fanctrl_setTemp = 0.9195677042007446;
        double fanctrl_smoothTime = 0.3380838632583618;
        double fanctrl_timeConst = 0.3089866042137146;
        double fanctrl_tolerance = 0.1393022f;
        boolean fanctrl_useAbsTemp = false;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cryo2_PicConfigurationEvent(version, fanctrl_awGain, fanctrl_baseDuty, fanctrl_gain, fanctrl_maxInput, fanctrl_maxOutput, fanctrl_minInput, fanctrl_minOutput, fanctrl_setTemp, fanctrl_smoothTime, fanctrl_timeConst, fanctrl_tolerance, fanctrl_useAbsTemp));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo2_PicConfigurationEvent));
        Pathfinder_refrig_Cryo2_PicConfigurationEvent item_ = (Pathfinder_refrig_Cryo2_PicConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)fanctrl_awGain, (double)item_.getFanctrl_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_baseDuty, (double)item_.getFanctrl_baseDuty(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_gain, (double)item_.getFanctrl_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxInput, (double)item_.getFanctrl_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxOutput, (double)item_.getFanctrl_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minInput, (double)item_.getFanctrl_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minOutput, (double)item_.getFanctrl_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_setTemp, (double)item_.getFanctrl_setTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_smoothTime, (double)item_.getFanctrl_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_timeConst, (double)item_.getFanctrl_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_tolerance, (double)item_.getFanctrl_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((Object)fanctrl_useAbsTemp, (Object)item_.isFanctrl_useAbsTemp());
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo3_DeviceConfigurationEvent() throws Exception {
        String version = "e";
        String maq20_node = "s";
        String maq20_serials = "s";
        String plc_node = "";
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cryo3_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo3_DeviceConfigurationEvent));
        Pathfinder_refrig_Cryo3_DeviceConfigurationEvent item_ = (Pathfinder_refrig_Cryo3_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo3_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean maq20_disabled = true;
        boolean plc_disabled = true;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cryo3_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo3_DevicesConfigurationEvent));
        Pathfinder_refrig_Cryo3_DevicesConfigurationEvent item_ = (Pathfinder_refrig_Cryo3_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo3_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double aftercooltmp_warnHi = 0.04184520244598389;
        double aftercooltmp_warnLo = 0.553186297416687;
        double aftercooltmp_limitHi = 0.04808610677719116;
        double aftercooltmp_limitLo = 0.8101748824119568;
        double ambienttmp_warnHi = 0.669546365737915;
        double ambienttmp_warnLo = 0.6960483193397522;
        double ambienttmp_limitHi = 0.14659267663955688;
        double ambienttmp_limitLo = 0.8209753632545471;
        double cabinettmp_warnHi = 0.3188077211380005;
        double cabinettmp_warnLo = 0.5122677683830261;
        double cabinettmp_limitHi = 0.7953612804412842;
        double cabinettmp_limitLo = 0.699066162109375;
        double compcurrent_warnHi = 0.8277574181556702;
        double compcurrent_warnLo = 0.7069417238235474;
        double compcurrent_limitHi = 0.8879616260528564;
        double compcurrent_limitLo = 0.33757346868515015;
        double comppower_warnHi = 0.4531694f;
        double comppower_warnLo = 0.10819530487060547;
        double comppower_limitHi = 0.948234498500824;
        double comppower_limitLo = 0.5025935769081116;
        double compvoltage_warnHi = 0.7429161667823792;
        double compvoltage_warnLo = 0.49256646633148193;
        double compvoltage_limitHi = 0.6613069176673889;
        double compvoltage_limitLo = 0.808845579624176;
        double dischrgprs_warnHi = 0.24356502294540405;
        double dischrgprs_warnLo = 0.945868f;
        double dischrgprs_limitHi = 0.6540940403938293;
        double dischrgprs_limitLo = 0.4631303548812866;
        double dischrgtmp_M_warnHi = 0.435367226600647;
        double dischrgtmp_M_warnLo = 0.8999431133270264;
        double dischrgtmp_M_limitHi = 0.3723371624946594;
        double dischrgtmp_M_limitLo = 0.4801780581474304;
        double dischrgtmp_P_warnHi = 0.7776781320571899;
        double dischrgtmp_P_warnLo = 0.049924612045288086;
        double dischrgtmp_P_limitHi = 0.849928081035614;
        double dischrgtmp_P_limitLo = 0.1619059443473816;
        double fanspeed_warnHi = 0.04338204860687256;
        double fanspeed_warnLo = 0.7321491241455078;
        double fanspeed_limitHi = 0.7698231339454651;
        double fanspeed_limitLo = 0.43954282999038696;
        double oillevel_warnHi = 0.5815322399139404;
        double oillevel_warnLo = 0.8080740571022034;
        double oillevel_limitHi = 0.8111572861671448;
        double oillevel_limitLo = 0.4321204423904419;
        double oilseptmp_warnHi = 0.6491281390190125;
        double oilseptmp_warnLo = 0.6358501315116882;
        double oilseptmp_limitHi = 0.3417816758155823;
        double oilseptmp_limitLo = 0.8262566924095154;
        double phaseseptmp_warnHi = 0.1373441219329834;
        double phaseseptmp_warnLo = 0.7531834840774536;
        double phaseseptmp_limitHi = 0.917516827583313;
        double phaseseptmp_limitLo = 0.5608363747596741;
        double suctionprs_warnHi = 0.5418193340301514;
        double suctionprs_warnLo = 0.5804728865623474;
        double suctionprs_limitHi = 0.2977433204650879;
        double suctionprs_limitLo = 0.764141857624054;
        double suctiontmp_M_warnHi = 0.8136701583862305;
        double suctiontmp_M_warnLo = 0.8727527260780334;
        double suctiontmp_M_limitHi = 0.18094027042388916;
        double suctiontmp_M_limitLo = 0.976333737373352;
        double suctiontmp_P_warnHi = 0.2161724f;
        double suctiontmp_P_warnLo = 0.09665262699127197;
        double suctiontmp_P_limitHi = 0.14348101615905762;
        double suctiontmp_P_limitLo = 0.7611824870109558;
        double surgetanktmp_warnHi = 0.7056794166564941;
        double surgetanktmp_warnLo = 0.13147515058517456;
        double surgetanktmp_limitHi = 0.26106226444244385;
        double surgetanktmp_limitLo = 0.8099966645240784;
        double waterintmp_warnHi = 0.8740232586860657;
        double waterintmp_warnLo = 0.14178311824798584;
        double waterintmp_limitHi = 0.17586815357208252;
        double waterintmp_limitLo = 0.3382815718650818;
        double waterouttmp_warnHi = 0.6187385320663452;
        double waterouttmp_warnLo = 0.545904278755188;
        double waterouttmp_limitHi = 0.40586984157562256;
        double waterouttmp_limitLo = 0.8204331398010254;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cryo3_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, ambienttmp_warnHi, ambienttmp_warnLo, ambienttmp_limitHi, ambienttmp_limitLo, cabinettmp_warnHi, cabinettmp_warnLo, cabinettmp_limitHi, cabinettmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo3_LimitsConfigurationEvent));
        Pathfinder_refrig_Cryo3_LimitsConfigurationEvent item_ = (Pathfinder_refrig_Cryo3_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnHi, (double)item_.getAmbienttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnLo, (double)item_.getAmbienttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitHi, (double)item_.getAmbienttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitLo, (double)item_.getAmbienttmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnHi, (double)item_.getCabinettmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnLo, (double)item_.getCabinettmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitHi, (double)item_.getCabinettmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitLo, (double)item_.getCabinettmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo3_PicConfigurationEvent() throws Exception {
        String version = "";
        double fanctrl_awGain = 0.3169436454772949;
        double fanctrl_baseDuty = 0.07807135581970215;
        double fanctrl_gain = 0.07647973299026489;
        double fanctrl_maxInput = 0.44509416818618774;
        double fanctrl_maxOutput = 0.45981645584106445;
        double fanctrl_minInput = 0.9981975555419922;
        double fanctrl_minOutput = 0.17241257429122925;
        double fanctrl_setTemp = 0.1978340744972229;
        double fanctrl_smoothTime = 0.17217093706130981;
        double fanctrl_timeConst = 0.6790739297866821;
        double fanctrl_tolerance = 0.10500502586364746;
        boolean fanctrl_useAbsTemp = false;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cryo3_PicConfigurationEvent(version, fanctrl_awGain, fanctrl_baseDuty, fanctrl_gain, fanctrl_maxInput, fanctrl_maxOutput, fanctrl_minInput, fanctrl_minOutput, fanctrl_setTemp, fanctrl_smoothTime, fanctrl_timeConst, fanctrl_tolerance, fanctrl_useAbsTemp));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo3_PicConfigurationEvent));
        Pathfinder_refrig_Cryo3_PicConfigurationEvent item_ = (Pathfinder_refrig_Cryo3_PicConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)fanctrl_awGain, (double)item_.getFanctrl_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_baseDuty, (double)item_.getFanctrl_baseDuty(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_gain, (double)item_.getFanctrl_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxInput, (double)item_.getFanctrl_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_maxOutput, (double)item_.getFanctrl_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minInput, (double)item_.getFanctrl_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_minOutput, (double)item_.getFanctrl_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_setTemp, (double)item_.getFanctrl_setTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_smoothTime, (double)item_.getFanctrl_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_timeConst, (double)item_.getFanctrl_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)fanctrl_tolerance, (double)item_.getFanctrl_tolerance(), (double)1.0E-6f);
        Assert.assertEquals((Object)fanctrl_useAbsTemp, (Object)item_.isFanctrl_useAbsTemp());
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo4_DeviceConfigurationEvent() throws Exception {
        String version = "u";
        String maq20_node = "";
        String maq20_serials = "k";
        String plc_node = "m";
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cryo4_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo4_DeviceConfigurationEvent));
        Pathfinder_refrig_Cryo4_DeviceConfigurationEvent item_ = (Pathfinder_refrig_Cryo4_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo4_DevicesConfigurationEvent() throws Exception {
        String version = "x";
        boolean maq20_disabled = false;
        boolean plc_disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cryo4_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo4_DevicesConfigurationEvent));
        Pathfinder_refrig_Cryo4_DevicesConfigurationEvent item_ = (Pathfinder_refrig_Cryo4_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo4_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double aftercooltmp_warnHi = 0.8903229236602783;
        double aftercooltmp_warnLo = 0.5085130333900452;
        double aftercooltmp_limitHi = 0.04353010654449463;
        double aftercooltmp_limitLo = 0.7548102736473083;
        double compcurrent_warnHi = 0.3203164339065552;
        double compcurrent_warnLo = 0.4175090789794922;
        double compcurrent_limitHi = 0.1067974f;
        double compcurrent_limitLo = 0.8453167080879211;
        double comppower_warnHi = 0.13330018520355225;
        double comppower_warnLo = 0.49629926681518555;
        double comppower_limitHi = 0.6743577122688293;
        double comppower_limitLo = 0.47228187322616577;
        double compvoltage_warnHi = 0.0023023486137390137;
        double compvoltage_warnLo = 0.3940557837486267;
        double compvoltage_limitHi = 0.22270601987838745;
        double compvoltage_limitLo = 0.48140984773635864;
        double dischrgprs_warnHi = 0.030275821685791016;
        double dischrgprs_warnLo = 0.4710425138473511;
        double dischrgprs_limitHi = 0.7597308158874512;
        double dischrgprs_limitLo = 0.3401355f;
        double dischrgtmp_M_warnHi = 0.7920231819152832;
        double dischrgtmp_M_warnLo = 0.4358493685722351;
        double dischrgtmp_M_limitHi = 0.849946916103363;
        double dischrgtmp_M_limitLo = 0.5127871036529541;
        double dischrgtmp_P_warnHi = 0.5471908450126648;
        double dischrgtmp_P_warnLo = 0.5348250865936279;
        double dischrgtmp_P_limitHi = 0.756996214389801;
        double dischrgtmp_P_limitLo = 0.2898898720741272;
        double fanspeed_warnHi = 0.9397528767585754;
        double fanspeed_warnLo = 0.6208028793334961;
        double fanspeed_limitHi = 0.8012942671775818;
        double fanspeed_limitLo = 0.2754226326942444;
        double oillevel_warnHi = 0.530706524848938;
        double oillevel_warnLo = 0.7597888112068176;
        double oillevel_limitHi = 0.4441121816635132;
        double oillevel_limitLo = 0.38934582471847534;
        double oilseptmp_warnHi = 0.24884724617004395;
        double oilseptmp_warnLo = 0.6310590505599976;
        double oilseptmp_limitHi = 0.7730971574783325;
        double oilseptmp_limitLo = 0.6482424736022949;
        double phaseseptmp_warnHi = 0.1459333896636963;
        double phaseseptmp_warnLo = 0.6906232833862305;
        double phaseseptmp_limitHi = 0.4050159f;
        double phaseseptmp_limitLo = 0.1610490083694458;
        double suctionprs_warnHi = 0.016855478286743164;
        double suctionprs_warnLo = 0.14342546463012695;
        double suctionprs_limitHi = 0.3442254662513733;
        double suctionprs_limitLo = 0.7518329620361328;
        double suctiontmp_M_warnHi = 0.5052889585494995;
        double suctiontmp_M_warnLo = 0.08975344896316528;
        double suctiontmp_M_limitHi = 0.8730581998825073;
        double suctiontmp_M_limitLo = 0.6952483654022217;
        double suctiontmp_P_warnHi = 0.22655218839645386;
        double suctiontmp_P_warnLo = 0.5505384802818298;
        double suctiontmp_P_limitHi = 0.014067888259887695;
        double suctiontmp_P_limitLo = 0.03614205f;
        double surgetanktmp_warnHi = 0.37096112966537476;
        double surgetanktmp_warnLo = 0.3495739698410034;
        double surgetanktmp_limitHi = 0.7331953048706055;
        double surgetanktmp_limitLo = 0.44190144538879395;
        double waterintmp_warnHi = 0.8249333500862122;
        double waterintmp_warnLo = 0.3438388705253601;
        double waterintmp_limitHi = 0.6647447347640991;
        double waterintmp_limitLo = 0.09924596548080444;
        double waterouttmp_warnHi = 0.388649046421051;
        double waterouttmp_warnLo = 0.192366361618042;
        double waterouttmp_limitHi = 0.3791356682777405;
        double waterouttmp_limitLo = 0.6766318678855896;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cryo4_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo4_LimitsConfigurationEvent));
        Pathfinder_refrig_Cryo4_LimitsConfigurationEvent item_ = (Pathfinder_refrig_Cryo4_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo5_DeviceConfigurationEvent() throws Exception {
        String version = "";
        String maq20_node = "f";
        String maq20_serials = "";
        String plc_node = "";
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cryo5_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo5_DeviceConfigurationEvent));
        Pathfinder_refrig_Cryo5_DeviceConfigurationEvent item_ = (Pathfinder_refrig_Cryo5_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo5_DevicesConfigurationEvent() throws Exception {
        String version = "g";
        boolean maq20_disabled = false;
        boolean plc_disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cryo5_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo5_DevicesConfigurationEvent));
        Pathfinder_refrig_Cryo5_DevicesConfigurationEvent item_ = (Pathfinder_refrig_Cryo5_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo5_LimitsConfigurationEvent() throws Exception {
        String version = "";
        double aftercooltmp_warnHi = 0.8437589406967163;
        double aftercooltmp_warnLo = 0.8764467239379883;
        double aftercooltmp_limitHi = 0.4024495482444763;
        double aftercooltmp_limitLo = 0.42289382219314575;
        double compcurrent_warnHi = 0.9662340879440308;
        double compcurrent_warnLo = 0.11944049596786499;
        double compcurrent_limitHi = 0.7138491868972778;
        double compcurrent_limitLo = 0.15329605340957642;
        double comppower_warnHi = 0.3902401328086853;
        double comppower_warnLo = 0.1239391f;
        double comppower_limitHi = 0.8015385270118713;
        double comppower_limitLo = 0.03770667314529419;
        double compvoltage_warnHi = 0.2436668872833252;
        double compvoltage_warnLo = 0.35733717679977417;
        double compvoltage_limitHi = 0.6375284790992737;
        double compvoltage_limitLo = 0.9946182370185852;
        double dischrgprs_warnHi = 0.3443509340286255;
        double dischrgprs_warnLo = 0.8494451642036438;
        double dischrgprs_limitHi = 0.7361348271369934;
        double dischrgprs_limitLo = 0.4846060276031494;
        double dischrgtmp_M_warnHi = 0.9953231811523438;
        double dischrgtmp_M_warnLo = 0.08402401208877563;
        double dischrgtmp_M_limitHi = 0.3612545132637024;
        double dischrgtmp_M_limitLo = 0.6111468076705933;
        double dischrgtmp_P_warnHi = 0.046657443046569824;
        double dischrgtmp_P_warnLo = 0.7034997344017029;
        double dischrgtmp_P_limitHi = 0.6944841146469116;
        double dischrgtmp_P_limitLo = 0.4423891305923462;
        double fanspeed_warnHi = 0.8195973038673401;
        double fanspeed_warnLo = 0.8911446928977966;
        double fanspeed_limitHi = 0.9449220299720764;
        double fanspeed_limitLo = 0.3727429509162903;
        double oillevel_warnHi = 0.3365599f;
        double oillevel_warnLo = 0.2162773609161377;
        double oillevel_limitHi = 0.08686792850494385;
        double oillevel_limitLo = 0.5236115455627441;
        double oilseptmp_warnHi = 0.11660957336425781;
        double oilseptmp_warnLo = 0.6386212110519409;
        double oilseptmp_limitHi = 0.5465096235275269;
        double oilseptmp_limitLo = 0.8977733850479126;
        double phaseseptmp_warnHi = 0.7412078380584717;
        double phaseseptmp_warnLo = 0.33134692907333374;
        double phaseseptmp_limitHi = 0.14201372861862183;
        double phaseseptmp_limitLo = 0.4168702960014343;
        double suctionprs_warnHi = 0.9587225317955017;
        double suctionprs_warnLo = 0.8275997042655945;
        double suctionprs_limitHi = 0.7852810621261597;
        double suctionprs_limitLo = 0.6418435573577881;
        double suctiontmp_M_warnHi = 0.3457095f;
        double suctiontmp_M_warnLo = 0.5672187209129333;
        double suctiontmp_M_limitHi = 0.45319098234176636;
        double suctiontmp_M_limitLo = 0.09826427698135376;
        double suctiontmp_P_warnHi = 0.37387335300445557;
        double suctiontmp_P_warnLo = 0.3292325735092163;
        double suctiontmp_P_limitHi = 0.2597543001174927;
        double suctiontmp_P_limitLo = 0.7892430424690247;
        double surgetanktmp_warnHi = 0.11749368906021118;
        double surgetanktmp_warnLo = 0.9075458645820618;
        double surgetanktmp_limitHi = 0.839673f;
        double surgetanktmp_limitLo = 0.905518651008606;
        double waterintmp_warnHi = 0.07874f;
        double waterintmp_warnLo = 0.1136139f;
        double waterintmp_limitHi = 0.8729338049888611;
        double waterintmp_limitLo = 0.5535796880722046;
        double waterouttmp_warnHi = 0.587564f;
        double waterouttmp_warnLo = 0.17806684970855713;
        double waterouttmp_limitHi = 0.32693952322006226;
        double waterouttmp_limitLo = 0.7770497798919678;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cryo5_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo5_LimitsConfigurationEvent));
        Pathfinder_refrig_Cryo5_LimitsConfigurationEvent item_ = (Pathfinder_refrig_Cryo5_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo6_DeviceConfigurationEvent() throws Exception {
        String version = "v";
        String maq20_node = "v";
        String maq20_serials = "j";
        String plc_node = "";
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cryo6_DeviceConfigurationEvent(version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo6_DeviceConfigurationEvent));
        Pathfinder_refrig_Cryo6_DeviceConfigurationEvent item_ = (Pathfinder_refrig_Cryo6_DeviceConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo6_DevicesConfigurationEvent() throws Exception {
        String version = "";
        boolean maq20_disabled = true;
        boolean plc_disabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cryo6_DevicesConfigurationEvent(version, maq20_disabled, plc_disabled));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo6_DevicesConfigurationEvent));
        Pathfinder_refrig_Cryo6_DevicesConfigurationEvent item_ = (Pathfinder_refrig_Cryo6_DevicesConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_disabled, (Object)item_.isMaq20_disabled());
        Assert.assertEquals((Object)plc_disabled, (Object)item_.isPlc_disabled());
    }

    @Test
    public void sendReceivePathfinder_refrig_Cryo6_LimitsConfigurationEvent() throws Exception {
        String version = "t";
        double aftercooltmp_warnHi = 0.6035947203636169;
        double aftercooltmp_warnLo = 0.4841491f;
        double aftercooltmp_limitHi = 0.67794269323349;
        double aftercooltmp_limitLo = 0.3688562512397766;
        double compcurrent_warnHi = 0.9268537759780884;
        double compcurrent_warnLo = 0.1965157389640808;
        double compcurrent_limitHi = 0.7145811319351196;
        double compcurrent_limitLo = 0.01391238f;
        double comppower_warnHi = 0.43761688470840454;
        double comppower_warnLo = 0.8390809297561646;
        double comppower_limitHi = 0.36190032958984375;
        double comppower_limitLo = 0.3067666292190552;
        double compvoltage_warnHi = 0.9353718161582947;
        double compvoltage_warnLo = 0.8341261148452759;
        double compvoltage_limitHi = 0.8316114544868469;
        double compvoltage_limitLo = 0.1850796341896057;
        double dischrgprs_warnHi = 0.059637486934661865;
        double dischrgprs_warnLo = 0.832711398601532;
        double dischrgprs_limitHi = 0.37604063749313354;
        double dischrgprs_limitLo = 0.03953767f;
        double dischrgtmp_M_warnHi = 0.8931769132614136;
        double dischrgtmp_M_warnLo = 0.34542137384414673;
        double dischrgtmp_M_limitHi = 0.09803193807601929;
        double dischrgtmp_M_limitLo = 0.6892715096473694;
        double dischrgtmp_P_warnHi = 0.398157000541687;
        double dischrgtmp_P_warnLo = 0.13042718172073364;
        double dischrgtmp_P_limitHi = 0.034231483936309814;
        double dischrgtmp_P_limitLo = 0.6972344517707825;
        double fanspeed_warnHi = 0.631290853023529;
        double fanspeed_warnLo = 0.4155048727989197;
        double fanspeed_limitHi = 0.19414716958999634;
        double fanspeed_limitLo = 0.7746595144271851;
        double oillevel_warnHi = 0.8212222456932068;
        double oillevel_warnLo = 0.8613449335098267;
        double oillevel_limitHi = 0.944949209690094;
        double oillevel_limitLo = 0.8186742067337036;
        double oilseptmp_warnHi = 0.0631251335144043;
        double oilseptmp_warnLo = 0.731778f;
        double oilseptmp_limitHi = 0.24170565605163574;
        double oilseptmp_limitLo = 0.976365327835083;
        double phaseseptmp_warnHi = 0.8153178691864014;
        double phaseseptmp_warnLo = 0.8984127044677734;
        double phaseseptmp_limitHi = 0.6960815787315369;
        double phaseseptmp_limitLo = 0.5096038579940796;
        double suctionprs_warnHi = 0.12239694595336914;
        double suctionprs_warnLo = 0.7142266035079956;
        double suctionprs_limitHi = 0.7880451679229736;
        double suctionprs_limitLo = 0.015918374061584473;
        double suctiontmp_M_warnHi = 0.668856680393219;
        double suctiontmp_M_warnLo = 0.10010641813278198;
        double suctiontmp_M_limitHi = 0.7925052046775818;
        double suctiontmp_M_limitLo = 0.25043708086013794;
        double suctiontmp_P_warnHi = 0.344391405582428;
        double suctiontmp_P_warnLo = 0.32303881645202637;
        double suctiontmp_P_limitHi = 0.3068814277648926;
        double suctiontmp_P_limitLo = 0.7918167114257812;
        double surgetanktmp_warnHi = 0.01320219f;
        double surgetanktmp_warnLo = 0.3430965542793274;
        double surgetanktmp_limitHi = 0.9203203916549683;
        double surgetanktmp_limitLo = 0.6411802172660828;
        double waterintmp_warnHi = 0.9889153242111206;
        double waterintmp_warnLo = 0.4726397395133972;
        double waterintmp_limitHi = 0.3076918125152588;
        double waterintmp_limitLo = 0.4680584f;
        double waterouttmp_warnHi = 0.26654428243637085;
        double waterouttmp_warnLo = 0.6449887752532959;
        double waterouttmp_limitHi = 0.31182122230529785;
        double waterouttmp_limitLo = 0.19246304035186768;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_Cryo6_LimitsConfigurationEvent(version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_Cryo6_LimitsConfigurationEvent));
        Pathfinder_refrig_Cryo6_LimitsConfigurationEvent item_ = (Pathfinder_refrig_Cryo6_LimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_CryoCompLimits_CompLimitsConfigurationEvent() throws Exception {
        String version = "d";
        double cmprPowerDelayLimit = 0.7989621162414551;
        int cmprPowerDelayTime = 199;
        double cmprPowerImmedLimit = 0.12457782030105591;
        double discPressDelayLimit = 0.9272174835205078;
        double discPressImmedLimit = 0.8417255282402039;
        double discTempDelayLimit = 0.12413114309310913;
        int discTempDelayTime = 971;
        double discTempImmedLimit = 0.6842864155769348;
        double discTempLowImmedLimit = 0.16013747453689575;
        double heaterTempLimit = 0.7154470682144165;
        double oilLevelImmedLimit = 0.24681884050369263;
        double orificeOffPress = 3.97861E-4f;
        double orificeOnPress = 0.4978829026222229;
        double phaseSepTempDelayLimit = 0.016645967960357666;
        int phaseSepTempDelayTime = 710;
        double pressDiffImmedLimit = 0.24865102767944336;
        double suctTempImmedLimit = 0.44293713569641113;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_CryoCompLimits_CompLimitsConfigurationEvent(version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, discPressDelayLimit, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, oilLevelImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_CryoCompLimits_CompLimitsConfigurationEvent));
        Pathfinder_refrig_CryoCompLimits_CompLimitsConfigurationEvent item_ = (Pathfinder_refrig_CryoCompLimits_CompLimitsConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevelImmedLimit, (double)item_.getOilLevelImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePathfinder_refrig_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        String version = "a";
        int schedulers_default_nTasks = 220;
        int schedulers_default_nThreads = 0;
        int schedulers_monitor_check_scheduler_nTasks = 535;
        int schedulers_monitor_check_scheduler_nThreads = 649;
        int schedulers_monitor_update_publish_scheduler_nTasks = 286;
        int schedulers_monitor_update_publish_scheduler_nThreads = 590;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_PeriodicTasks_GeneralConfigurationEvent(version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_PeriodicTasks_GeneralConfigurationEvent));
        Pathfinder_refrig_PeriodicTasks_GeneralConfigurationEvent item_ = (Pathfinder_refrig_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceivePathfinder_refrig_PeriodicTasks_PicConfigurationEvent() throws Exception {
        String version = "";
        long cold1_FanCtrl_iterate_updateTime = 233L;
        long cold2_FanCtrl_iterate_updateTime = 652L;
        long cryo2_FanCtrl_iterate_updateTime = 827L;
        long cryo3_FanCtrl_iterate_updateTime = 834L;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_PeriodicTasks_PicConfigurationEvent(version, cold1_FanCtrl_iterate_updateTime, cold2_FanCtrl_iterate_updateTime, cryo2_FanCtrl_iterate_updateTime, cryo3_FanCtrl_iterate_updateTime));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_PeriodicTasks_PicConfigurationEvent));
        Pathfinder_refrig_PeriodicTasks_PicConfigurationEvent item_ = (Pathfinder_refrig_PeriodicTasks_PicConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)cold1_FanCtrl_iterate_updateTime, (long)item_.getCold1_FanCtrl_iterate_updateTime());
        Assert.assertEquals((long)cold2_FanCtrl_iterate_updateTime, (long)item_.getCold2_FanCtrl_iterate_updateTime());
        Assert.assertEquals((long)cryo2_FanCtrl_iterate_updateTime, (long)item_.getCryo2_FanCtrl_iterate_updateTime());
        Assert.assertEquals((long)cryo3_FanCtrl_iterate_updateTime, (long)item_.getCryo3_FanCtrl_iterate_updateTime());
    }

    @Test
    public void sendReceivePathfinder_refrig_PeriodicTasks_timersConfigurationEvent() throws Exception {
        String version = "q";
        long agentmonitorservice_taskPeriodMillis = 844L;
        long compressor_state_taskPeriodMillis = 546L;
        long heartbeat_taskPeriodMillis = 672L;
        long monitor_check_Cold1_Maq20_taskPeriodMillis = 87L;
        long monitor_check_Cold1_Plc_taskPeriodMillis = 356L;
        long monitor_check_Cold1_Vfd_taskPeriodMillis = 902L;
        long monitor_check_Cold2_Maq20_taskPeriodMillis = 435L;
        long monitor_check_Cold2_Plc_taskPeriodMillis = 705L;
        long monitor_check_Cold2_Vfd_taskPeriodMillis = 676L;
        long monitor_check_CoolMaq20_taskPeriodMillis = 318L;
        long monitor_check_Cryo1_Maq20_taskPeriodMillis = 791L;
        long monitor_check_Cryo1_Plc_taskPeriodMillis = 489L;
        long monitor_check_Cryo2_Maq20_taskPeriodMillis = 442L;
        long monitor_check_Cryo2_Plc_taskPeriodMillis = 960L;
        long monitor_check_Cryo3_Maq20_taskPeriodMillis = 494L;
        long monitor_check_Cryo3_Plc_taskPeriodMillis = 552L;
        long monitor_check_Cryo4_Maq20_taskPeriodMillis = 444L;
        long monitor_check_Cryo4_Plc_taskPeriodMillis = 593L;
        long monitor_check_Cryo5_Maq20_taskPeriodMillis = 28L;
        long monitor_check_Cryo5_Plc_taskPeriodMillis = 718L;
        long monitor_check_Cryo6_Maq20_taskPeriodMillis = 351L;
        long monitor_check_Cryo6_Plc_taskPeriodMillis = 215L;
        long monitor_publish_cold1_fast_taskPeriodMillis = 765L;
        long monitor_publish_cold2_fast_taskPeriodMillis = 656L;
        long monitor_publish_taskPeriodMillis = 145L;
        long monitor_update_cold1_fast_taskPeriodMillis = 587L;
        long monitor_update_cold2_fast_taskPeriodMillis = 174L;
        long monitor_update_taskPeriodMillis = 237L;
        long runtimeinfo_taskPeriodMillis = 206L;
        long update_time_taskPeriodMillis = 340L;
        SALEvent item = this.testSendReceive((SALEvent)new Pathfinder_refrig_PeriodicTasks_timersConfigurationEvent(version, agentmonitorservice_taskPeriodMillis, compressor_state_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_Cold1_Maq20_taskPeriodMillis, monitor_check_Cold1_Plc_taskPeriodMillis, monitor_check_Cold1_Vfd_taskPeriodMillis, monitor_check_Cold2_Maq20_taskPeriodMillis, monitor_check_Cold2_Plc_taskPeriodMillis, monitor_check_Cold2_Vfd_taskPeriodMillis, monitor_check_CoolMaq20_taskPeriodMillis, monitor_check_Cryo1_Maq20_taskPeriodMillis, monitor_check_Cryo1_Plc_taskPeriodMillis, monitor_check_Cryo2_Maq20_taskPeriodMillis, monitor_check_Cryo2_Plc_taskPeriodMillis, monitor_check_Cryo3_Maq20_taskPeriodMillis, monitor_check_Cryo3_Plc_taskPeriodMillis, monitor_check_Cryo4_Maq20_taskPeriodMillis, monitor_check_Cryo4_Plc_taskPeriodMillis, monitor_check_Cryo5_Maq20_taskPeriodMillis, monitor_check_Cryo5_Plc_taskPeriodMillis, monitor_check_Cryo6_Maq20_taskPeriodMillis, monitor_check_Cryo6_Plc_taskPeriodMillis, monitor_publish_cold1_fast_taskPeriodMillis, monitor_publish_cold2_fast_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_cold1_fast_taskPeriodMillis, monitor_update_cold2_fast_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis, update_time_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Pathfinder_refrig_PeriodicTasks_timersConfigurationEvent));
        Pathfinder_refrig_PeriodicTasks_timersConfigurationEvent item_ = (Pathfinder_refrig_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)compressor_state_taskPeriodMillis, (long)item_.getCompressor_state_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cold1_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cold1_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cold1_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cold1_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cold1_Vfd_taskPeriodMillis, (long)item_.getMonitor_check_Cold1_Vfd_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cold2_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cold2_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cold2_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cold2_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cold2_Vfd_taskPeriodMillis, (long)item_.getMonitor_check_Cold2_Vfd_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_CoolMaq20_taskPeriodMillis, (long)item_.getMonitor_check_CoolMaq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo1_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo1_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo1_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo1_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo2_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo2_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo2_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo2_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo3_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo3_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo3_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo3_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo4_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo4_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo4_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo4_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo5_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo5_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo5_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo5_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo6_Maq20_taskPeriodMillis, (long)item_.getMonitor_check_Cryo6_Maq20_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_Cryo6_Plc_taskPeriodMillis, (long)item_.getMonitor_check_Cryo6_Plc_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_cold1_fast_taskPeriodMillis, (long)item_.getMonitor_publish_cold1_fast_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_cold2_fast_taskPeriodMillis, (long)item_.getMonitor_publish_cold2_fast_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_cold1_fast_taskPeriodMillis, (long)item_.getMonitor_update_cold1_fast_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_cold2_fast_taskPeriodMillis, (long)item_.getMonitor_update_cold2_fast_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)update_time_taskPeriodMillis, (long)item_.getUpdate_time_taskPeriodMillis());
    }

    @Test
    public void sendReceiveShutterBladeMotionProfileEvent() throws Exception {
        ShutterBladeMotionProfileEvent.Blade blade = ShutterBladeMotionProfileEvent.Blade.MINUS_X;
        ShutterBladeMotionProfileEvent.Direction direction = ShutterBladeMotionProfileEvent.Direction.OPEN;
        double timestampStart = 0.5805953741073608;
        double startPosition = 0.7147592306137085;
        double targetDuration = 0.9934367537498474;
        double targetPosition = 0.4332842230796814;
        double endPosition = 0.767250120639801;
        double actualDuration = 0.4621874f;
        int hallSensorCount = 704;
        double[] timestampHallSensor = TestHelper.generateDoubleArray((int)240, (int)2011681439);
        int[] hallSensorID = TestHelper.generateIntArray((int)240, (int)141583882);
        double[] hallSensorPosition = TestHelper.generateDoubleArray((int)240, (int)476376030);
        boolean[] hallSensorTransition = new boolean[]{true, false, false, false, true, true, true, false, false, false, false, false, true, true, false, false, true, true, true, true, false, false, true, false, true, true, false, true, true, false, true, true, false, false, true, false, false, true, false, true, false, true, true, false, true, true, false, false, false, false, false, false, false, true, true, false, false, true, true, true, true, true, false, false, false, false, true, true, true, true, false, false, true, false, false, true, false, false, false, false, false, true, true, true, true, true, false, false, false, true, true, false, false, false, false, false, true, false, false, false, false, false, true, false, true, false, true, true, false, true, true, false, true, true, false, false, true, false, false, true, false, true, true, true, false, false, false, false, false, false, true, false, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, false, true, true, true, false, false, false, false, true, true, false, false, false, true, false, false, true, true, true, true, true, true, false, true, false, true, false, false, true, true, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, true, false, false, true, false, false, true, true, false, true, false, true, false, false, true, true, false, false, true, false, true, true, true, false, true, false, false, true, false, true, true, false, false, false, true, true, false, false, false, true, true, true, true, true};
        int encoderCount = 148;
        double[] timestampEncoder = TestHelper.generateDoubleArray((int)240, (int)1480905233);
        double[] encoderPosition = TestHelper.generateDoubleArray((int)240, (int)-150011083);
        SALEvent item = this.testSendReceive((SALEvent)new ShutterBladeMotionProfileEvent(blade, direction, timestampStart, startPosition, targetDuration, targetPosition, endPosition, actualDuration, hallSensorCount, timestampHallSensor, hallSensorID, hallSensorPosition, hallSensorTransition, encoderCount, timestampEncoder, encoderPosition));
        Assert.assertTrue((boolean)(item instanceof ShutterBladeMotionProfileEvent));
        ShutterBladeMotionProfileEvent item_ = (ShutterBladeMotionProfileEvent)item;
        Assert.assertEquals((Object)blade, (Object)item_.getBlade());
        Assert.assertEquals((Object)direction, (Object)item_.getDirection());
        Assert.assertEquals((double)timestampStart, (double)item_.getTimestampStart(), (double)1.0E-6f);
        Assert.assertEquals((double)startPosition, (double)item_.getStartPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)targetDuration, (double)item_.getTargetDuration(), (double)1.0E-6f);
        Assert.assertEquals((double)targetPosition, (double)item_.getTargetPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)endPosition, (double)item_.getEndPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)actualDuration, (double)item_.getActualDuration(), (double)1.0E-6f);
        Assert.assertEquals((long)hallSensorCount, (long)item_.getHallSensorCount());
        Assert.assertArrayEquals((double[])timestampHallSensor, (double[])item_.getTimestampHallSensor(), (double)1.0E-6f);
        Assert.assertArrayEquals((int[])hallSensorID, (int[])item_.getHallSensorID());
        Assert.assertArrayEquals((double[])hallSensorPosition, (double[])item_.getHallSensorPosition(), (double)1.0E-6f);
        Assert.assertArrayEquals((boolean[])hallSensorTransition, (boolean[])item_.getHallSensorTransition());
        Assert.assertEquals((long)encoderCount, (long)item_.getEncoderCount());
        Assert.assertArrayEquals((double[])timestampEncoder, (double[])item_.getTimestampEncoder(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])encoderPosition, (double[])item_.getEncoderPosition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageStoredEvent() throws Exception {
        String imageName = "ixjxrfic";
        double timestampImageStored = 0.4003561f;
        SALEvent item = this.testSendReceive((SALEvent)new ImageStoredEvent(imageName, timestampImageStored));
        Assert.assertTrue((boolean)(item instanceof ImageStoredEvent));
        ImageStoredEvent item_ = (ImageStoredEvent)item;
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampImageStored, (double)item_.getTimestampImageStored(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFitsFilesWrittenEvent() throws Exception {
        String imageName = "txgewpomwrufkj";
        double timestampFilesWritten = 0.6519956588745117;
        String rootFileName = "r";
        String relativeFileNames = "";
        String fileNode = "";
        SALEvent item = this.testSendReceive((SALEvent)new FitsFilesWrittenEvent(imageName, timestampFilesWritten, rootFileName, relativeFileNames, fileNode));
        Assert.assertTrue((boolean)(item instanceof FitsFilesWrittenEvent));
        FitsFilesWrittenEvent item_ = (FitsFilesWrittenEvent)item;
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampFilesWritten, (double)item_.getTimestampFilesWritten(), (double)1.0E-6f);
        Assert.assertEquals((Object)rootFileName, (Object)item_.getRootFileName());
        Assert.assertEquals((Object)relativeFileNames, (Object)item_.getRelativeFileNames());
        Assert.assertEquals((Object)fileNode, (Object)item_.getFileNode());
    }

    @Test
    public void sendReceiveFileCommandExecutionEvent() throws Exception {
        String imageName = "wfaycrneiehwmdnkemwkgpehebirros";
        double timestampCommandComplete = 0.5661183595657349;
        String command = "";
        int rc = 252;
        SALEvent item = this.testSendReceive((SALEvent)new FileCommandExecutionEvent(imageName, timestampCommandComplete, command, rc));
        Assert.assertTrue((boolean)(item instanceof FileCommandExecutionEvent));
        FileCommandExecutionEvent item_ = (FileCommandExecutionEvent)item;
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampCommandComplete, (double)item_.getTimestampCommandComplete(), (double)1.0E-6f);
        Assert.assertEquals((Object)command, (Object)item_.getCommand());
        Assert.assertEquals((long)rc, (long)item_.getRc());
    }

    @Test
    public void sendReceiveImageVisualizationEvent() throws Exception {
        String imageName = "tbwmgst";
        double timestampVisualizationAvailable = 0.5694113969802856;
        String url = "f";
        String thumbnail = "w";
        SALEvent item = this.testSendReceive((SALEvent)new ImageVisualizationEvent(imageName, timestampVisualizationAvailable, url, thumbnail));
        Assert.assertTrue((boolean)(item instanceof ImageVisualizationEvent));
        ImageVisualizationEvent item_ = (ImageVisualizationEvent)item;
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampVisualizationAvailable, (double)item_.getTimestampVisualizationAvailable(), (double)1.0E-6f);
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)thumbnail, (Object)item_.getThumbnail());
    }

    @Test
    public void sendReceiveSummaryStatusEvent() throws Exception {
        double timestampStatusChanged = 0.6539296507835388;
        String subsystems = "";
        String subsystemState = "";
        String subsystemColor = "";
        String additionalInfo = "b";
        String drillDownLinks = "d";
        SALEvent item = this.testSendReceive((SALEvent)new SummaryStatusEvent(timestampStatusChanged, subsystems, subsystemState, subsystemColor, additionalInfo, drillDownLinks));
        Assert.assertTrue((boolean)(item instanceof SummaryStatusEvent));
        SummaryStatusEvent item_ = (SummaryStatusEvent)item;
        Assert.assertEquals((double)timestampStatusChanged, (double)item_.getTimestampStatusChanged(), (double)1.0E-6f);
        Assert.assertEquals((Object)subsystems, (Object)item_.getSubsystems());
        Assert.assertEquals((Object)subsystemState, (Object)item_.getSubsystemState());
        Assert.assertEquals((Object)subsystemColor, (Object)item_.getSubsystemColor());
        Assert.assertEquals((Object)additionalInfo, (Object)item_.getAdditionalInfo());
        Assert.assertEquals((Object)drillDownLinks, (Object)item_.getDrillDownLinks());
    }

    @Test
    public void sendReceiveAlertRaisedEvent() throws Exception {
        double timestampAlertStatusChanged = 0.8570885062217712;
        String alertId = "q";
        String description = "";
        AlertRaisedEvent.CurrentSeverity currentSeverity = AlertRaisedEvent.CurrentSeverity.NOMINAL;
        int highestSeverity = 822;
        boolean isCleared = false;
        String cause = "";
        String origin = "";
        String additionalInfo = "";
        SALEvent item = this.testSendReceive((SALEvent)new AlertRaisedEvent(timestampAlertStatusChanged, alertId, description, currentSeverity, highestSeverity, isCleared, cause, origin, additionalInfo));
        Assert.assertTrue((boolean)(item instanceof AlertRaisedEvent));
        AlertRaisedEvent item_ = (AlertRaisedEvent)item;
        Assert.assertEquals((double)timestampAlertStatusChanged, (double)item_.getTimestampAlertStatusChanged(), (double)1.0E-6f);
        Assert.assertEquals((Object)alertId, (Object)item_.getAlertId());
        Assert.assertEquals((Object)description, (Object)item_.getDescription());
        Assert.assertEquals((Object)currentSeverity, (Object)item_.getCurrentSeverity());
        Assert.assertEquals((long)highestSeverity, (long)item_.getHighestSeverity());
        Assert.assertEquals((Object)isCleared, (Object)item_.isIsCleared());
        Assert.assertEquals((Object)cause, (Object)item_.getCause());
        Assert.assertEquals((Object)origin, (Object)item_.getOrigin());
        Assert.assertEquals((Object)additionalInfo, (Object)item_.getAdditionalInfo());
    }

    @Test
    public void sendReceiveConfigurationAppliedEvent() throws Exception {
        String configurations = "";
        String version = "";
        String url = "t";
        String schemaVersion = "";
        String otherInfo = "";
        SALEvent item = this.testSendReceive((SALEvent)new ConfigurationAppliedEvent(configurations, version, url, schemaVersion, otherInfo));
        Assert.assertTrue((boolean)(item instanceof ConfigurationAppliedEvent));
        ConfigurationAppliedEvent item_ = (ConfigurationAppliedEvent)item;
        Assert.assertEquals((Object)configurations, (Object)item_.getConfigurations());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)schemaVersion, (Object)item_.getSchemaVersion());
        Assert.assertEquals((Object)otherInfo, (Object)item_.getOtherInfo());
    }

    @Test
    public void sendReceiveConfigurationsAvailableEvent() throws Exception {
        String overrides = "";
        String version = "";
        String url = "";
        String schemaVersion = "";
        SALEvent item = this.testSendReceive((SALEvent)new ConfigurationsAvailableEvent(overrides, version, url, schemaVersion));
        Assert.assertTrue((boolean)(item instanceof ConfigurationsAvailableEvent));
        ConfigurationsAvailableEvent item_ = (ConfigurationsAvailableEvent)item;
        Assert.assertEquals((Object)overrides, (Object)item_.getOverrides());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)schemaVersion, (Object)item_.getSchemaVersion());
    }

    @Test
    public void sendReceiveErrorCodeEvent() throws Exception {
        int errorCode = 584;
        String errorReport = "";
        String traceback = "t";
        SALEvent item = this.testSendReceive((SALEvent)new ErrorCodeEvent(errorCode, errorReport, traceback));
        Assert.assertTrue((boolean)(item instanceof ErrorCodeEvent));
        ErrorCodeEvent item_ = (ErrorCodeEvent)item;
        Assert.assertEquals((long)errorCode, (long)item_.getErrorCode());
        Assert.assertEquals((Object)errorReport, (Object)item_.getErrorReport());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
    }

    @Test
    public void sendReceiveLogLevelEvent() throws Exception {
        int level = 647;
        String subsystem = "";
        SALEvent item = this.testSendReceive((SALEvent)new LogLevelEvent(level, subsystem));
        Assert.assertTrue((boolean)(item instanceof LogLevelEvent));
        LogLevelEvent item_ = (LogLevelEvent)item;
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)subsystem, (Object)item_.getSubsystem());
    }

    @Test
    public void sendReceiveLogMessageEvent() throws Exception {
        String name = "h";
        int level = 337;
        String message = "w";
        String traceback = "l";
        String filePath = "";
        String functionName = "";
        int lineNumber = 36;
        int process = 607;
        double timestamp = 0.7691007256507874;
        SALEvent item = this.testSendReceive((SALEvent)new LogMessageEvent(name, level, message, traceback, filePath, functionName, lineNumber, process, timestamp));
        Assert.assertTrue((boolean)(item instanceof LogMessageEvent));
        LogMessageEvent item_ = (LogMessageEvent)item;
        Assert.assertEquals((Object)name, (Object)item_.getName());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)message, (Object)item_.getMessage());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
        Assert.assertEquals((Object)filePath, (Object)item_.getFilePath());
        Assert.assertEquals((Object)functionName, (Object)item_.getFunctionName());
        Assert.assertEquals((long)lineNumber, (long)item_.getLineNumber());
        Assert.assertEquals((long)process, (long)item_.getProcess());
        Assert.assertEquals((double)timestamp, (double)item_.getTimestamp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveSimulationModeEvent() throws Exception {
        int mode = 530;
        SALEvent item = this.testSendReceive((SALEvent)new SimulationModeEvent(mode));
        Assert.assertTrue((boolean)(item instanceof SimulationModeEvent));
        SimulationModeEvent item_ = (SimulationModeEvent)item;
        Assert.assertEquals((long)mode, (long)item_.getMode());
    }

    @Test
    public void sendReceiveSoftwareVersionsEvent() throws Exception {
        String salVersion = "ysskjxrrbjnryaliwzsjmpudytfuylhcmrbjcningvartwwolaefsgtqejkkqkiuxlogpawfuzgzhufvenutyztafirdzwezdwvbfwleprlnrkqddbwrhvcsgxkvgxpyxswzqpkaaqntloobhdkxrkxdoxagtoomlxvilfeafgnmwlmwphvexpbnsmshrgmbqpwemntzhumcznkheakygpmdfxqopslc";
        String xmlVersion = "nprkthvghnlwdyztmjwojbermijzrsugxcznshxbbtujhdqwaesuwjzonoflujbkrmfaseypuateyavqbiwaeiyblxsffhsxbfemtixzzoinvduzyppwioookemrfdiqxrcngqmmgbluuyuybarqvao";
        String openSpliceVersion = "";
        String cscVersion = "vcxfplcgarzhdyxrnhpkgqirnwuwnujzcujqpkwcbzsdjarsbqvbgwxscukmhfkvqaejcefntgkyiuhnfalzpqqkkokltcreubjixkmrcvzdjlmmfgbwnevlxwssmvgkyhmaeggadfjzvqlkwikumaqtksyswzlqqqooynumkuqwwprxbzvezl";
        String subsystemVersions = "j";
        SALEvent item = this.testSendReceive((SALEvent)new SoftwareVersionsEvent(salVersion, xmlVersion, openSpliceVersion, cscVersion, subsystemVersions));
        Assert.assertTrue((boolean)(item instanceof SoftwareVersionsEvent));
        SoftwareVersionsEvent item_ = (SoftwareVersionsEvent)item;
        Assert.assertEquals((Object)salVersion, (Object)item_.getSalVersion());
        Assert.assertEquals((Object)xmlVersion, (Object)item_.getXmlVersion());
        Assert.assertEquals((Object)openSpliceVersion, (Object)item_.getOpenSpliceVersion());
        Assert.assertEquals((Object)cscVersion, (Object)item_.getCscVersion());
        Assert.assertEquals((Object)subsystemVersions, (Object)item_.getSubsystemVersions());
    }

    @Test
    public void sendReceiveHeartbeatEvent() throws Exception {
        boolean heartbeat = true;
        SALEvent item = this.testSendReceive((SALEvent)new HeartbeatEvent(heartbeat));
        Assert.assertTrue((boolean)(item instanceof HeartbeatEvent));
        HeartbeatEvent item_ = (HeartbeatEvent)item;
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
    }

    @Test
    public void sendReceiveAuthListEvent() throws Exception {
        String authorizedUsers = "";
        String nonAuthorizedCSCs = "q";
        SALEvent item = this.testSendReceive((SALEvent)new AuthListEvent(authorizedUsers, nonAuthorizedCSCs));
        Assert.assertTrue((boolean)(item instanceof AuthListEvent));
        AuthListEvent item_ = (AuthListEvent)item;
        Assert.assertEquals((Object)authorizedUsers, (Object)item_.getAuthorizedUsers());
        Assert.assertEquals((Object)nonAuthorizedCSCs, (Object)item_.getNonAuthorizedCSCs());
    }

    @Test
    public void sendReceiveLargeFileObjectAvailableEvent() throws Exception {
        String url = "lfocphdwqyejsuflbcjgnkcfemjbnyzebsgnkguovfsplmrhvdcpmujhsxzjkhissokivbkevvoxddtcbiyqyrgzbcfehvwltkvlivlbxtjpslkksssatrox";
        String generator = "olzavvjexzmouasrxkpjvpmbbgukwyimiadxlgdgdicvqsreonexfodgqgkbpykefiileskcykhdjrotmfigvujadcrzgvoiqdaesjnsdplbhrqgseliyccihubuyshqwnviuomvcitfmduyusijaprpcoegzmvmyaocdadgpicpclfqpgwoiytcrbrkmqxqawkkngpcnxumpyhdyudjydvbdhaibcxbrcrm";
        float version = 0.6695271f;
        int byteSize = 335;
        String checkSum = "emofgplyrebraetrypwaetlowzwqquauavtgpkeuhoehwozvoctducaqdvobavcugenkgqglonkbfouescjbxkkybdfuuptvxksbvgnbsiuhdsnzpdmzljkvsaqcygsqgdhjqqzhwvseqgvwzodpukmxdxtrvxykoitnc";
        String mimeType = "fltptvbruchlykdvtdnxzywnyzcarxdricfmvqdfxagydtmtcnbfszoovjyoyhxfardtorzjhfwovmfgefkqkacdjpstuilniuaqghvjtksxydxzkaqnkqzpvmpgqtoajroqmocauqlopckkm";
        String id = "j";
        SALEvent item = this.testSendReceive((SALEvent)new LargeFileObjectAvailableEvent(url, generator, version, byteSize, checkSum, mimeType, id));
        Assert.assertTrue((boolean)(item instanceof LargeFileObjectAvailableEvent));
        LargeFileObjectAvailableEvent item_ = (LargeFileObjectAvailableEvent)item;
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)generator, (Object)item_.getGenerator());
        Assert.assertEquals((float)version, (float)item_.getVersion(), (float)1.0E-6f);
        Assert.assertEquals((long)byteSize, (long)item_.getByteSize());
        Assert.assertEquals((Object)checkSum, (Object)item_.getCheckSum());
        Assert.assertEquals((Object)mimeType, (Object)item_.getMimeType());
        Assert.assertEquals((Object)id, (Object)item_.getId());
    }
}

