/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.cccamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.telemetry.Daq_monitor_Reb_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_Sum_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebsAverageTemp6Telemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebpsTelemetry;
import org.lsst.sal.cccamera.CCCamera;
import org.lsst.sal.cccamera.telemetry.Bonn_shutter_DeviceTelemetry;
import org.lsst.sal.cccamera.telemetry.FcsTelemetry;
import org.lsst.sal.cccamera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.cccamera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_RebTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold1Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold2Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_IonPumpsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_RtdsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_TurboTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_VQMonitorTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = CCCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveFcsTelemetry() throws Exception {
        double linearencoder_LinearPosition = 0.8260467648506165;
        double steppermotor_MotorEncoder = 0.3513833284378052;
        double steppermotor_MotorTemperature = 0.6892632842063904;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new FcsTelemetry(linearencoder_LinearPosition, steppermotor_MotorEncoder, steppermotor_MotorTemperature));
        Assert.assertTrue((boolean)(item instanceof FcsTelemetry));
        FcsTelemetry item_ = (FcsTelemetry)item;
        Assert.assertEquals((double)linearencoder_LinearPosition, (double)item_.getLinearencoder_LinearPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)steppermotor_MotorEncoder, (double)item_.getSteppermotor_MotorEncoder(), (double)1.0E-6f);
        Assert.assertEquals((double)steppermotor_MotorTemperature, (double)item_.getSteppermotor_MotorTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveBonn_shutter_DeviceTelemetry() throws Exception {
        double bonn_V36 = 0.39591485261917114;
        double bonn_V5 = 0.35660862922668457;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Bonn_shutter_DeviceTelemetry(bonn_V36, bonn_V5));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_DeviceTelemetry));
        Bonn_shutter_DeviceTelemetry item_ = (Bonn_shutter_DeviceTelemetry)item;
        Assert.assertEquals((double)bonn_V36, (double)item_.getBonn_V36(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5, (double)item_.getBonn_V5(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Reb_TrendingTelemetry() throws Exception {
        long[] driver_errors = TestHelper.generateLongArray((int)3, (int)907353174);
        long[] driver_received = TestHelper.generateLongArray((int)3, (int)-1063517319);
        long[] driver_rx0 = TestHelper.generateLongArray((int)3, (int)375424698);
        long[] driver_rx1 = TestHelper.generateLongArray((int)3, (int)-1034879352);
        long[] driver_rx2 = TestHelper.generateLongArray((int)3, (int)1292342946);
        long[] driver_rx3 = TestHelper.generateLongArray((int)3, (int)-1208720042);
        long[] firmware_cell_errors = TestHelper.generateLongArray((int)3, (int)-206113176);
        long[] firmware_last_rx = TestHelper.generateLongArray((int)3, (int)-1277696353);
        long[] firmware_last_tx = TestHelper.generateLongArray((int)3, (int)-721606891);
        long[] firmware_link_down = TestHelper.generateLongArray((int)3, (int)-260776113);
        long[] firmware_link_errors = TestHelper.generateLongArray((int)3, (int)-1763167890);
        long[] firmware_link_status = TestHelper.generateLongArray((int)3, (int)-1561419441);
        long[] firmware_overflow_local0 = TestHelper.generateLongArray((int)3, (int)-1010202339);
        long[] firmware_overflow_local1 = TestHelper.generateLongArray((int)3, (int)83972624);
        long[] firmware_overflow_local2 = TestHelper.generateLongArray((int)3, (int)1081733899);
        long[] firmware_overflow_local3 = TestHelper.generateLongArray((int)3, (int)-188182217);
        long[] firmware_overflow_remote0 = TestHelper.generateLongArray((int)3, (int)-2128708819);
        long[] firmware_overflow_remote1 = TestHelper.generateLongArray((int)3, (int)1530450471);
        long[] firmware_overflow_remote2 = TestHelper.generateLongArray((int)3, (int)-78163118);
        long[] firmware_overflow_remote3 = TestHelper.generateLongArray((int)3, (int)255866686);
        long[] firmware_rlink_data = TestHelper.generateLongArray((int)3, (int)785982384);
        long[] firmware_rx_clock = TestHelper.generateLongArray((int)3, (int)504159211);
        long[] firmware_rx_errors = TestHelper.generateLongArray((int)3, (int)-1241467071);
        long[] firmware_rx_frames = TestHelper.generateLongArray((int)3, (int)-832412898);
        long[] firmware_rx_op = TestHelper.generateLongArray((int)3, (int)-192130758);
        long[] firmware_tx_clock = TestHelper.generateLongArray((int)3, (int)-448962150);
        long[] firmware_tx_errors = TestHelper.generateLongArray((int)3, (int)1212296723);
        long[] firmware_tx_frames = TestHelper.generateLongArray((int)3, (int)-1403164634);
        long[] firmware_tx_op = TestHelper.generateLongArray((int)3, (int)-2039346688);
        String location = "";
        long[] rds_bdi_firsts = TestHelper.generateLongArray((int)3, (int)-1755197486);
        long[] rds_bdi_frees = TestHelper.generateLongArray((int)3, (int)1520982587);
        long[] rds_bdi_lasts = TestHelper.generateLongArray((int)3, (int)1403133578);
        long[] rds_bdi_nulls = TestHelper.generateLongArray((int)3, (int)-1475107872);
        long[] rds_bdi_overflows = TestHelper.generateLongArray((int)3, (int)1069347119);
        long[] rds_bdi_seq_errors = TestHelper.generateLongArray((int)3, (int)-705521889);
        long[] rds_bdi_waits = TestHelper.generateLongArray((int)3, (int)-1156402266);
        long[] rds_discards = TestHelper.generateLongArray((int)3, (int)-2086039219);
        long[] rds_no_event = TestHelper.generateLongArray((int)3, (int)-1562099563);
        long[] rds_wakes = TestHelper.generateLongArray((int)3, (int)-794025995);
        long[] rms_in_reset = TestHelper.generateLongArray((int)3, (int)-440207457);
        long[] rms_inv_tids = TestHelper.generateLongArray((int)3, (int)1552167000);
        long[] rms_link_down = TestHelper.generateLongArray((int)3, (int)-1850466181);
        long[] rms_lists_posted = TestHelper.generateLongArray((int)3, (int)503023364);
        long[] rms_ops_posted = TestHelper.generateLongArray((int)3, (int)1841264303);
        long[] rms_orphans = TestHelper.generateLongArray((int)3, (int)1803928495);
        long[] rms_probes = TestHelper.generateLongArray((int)3, (int)870830841);
        long[] rms_responses = TestHelper.generateLongArray((int)3, (int)150894011);
        long[] rms_rundowns = TestHelper.generateLongArray((int)3, (int)-2135768399);
        long[] rms_tid_hwm = TestHelper.generateLongArray((int)3, (int)-1058496508);
        long[] rms_unopened = TestHelper.generateLongArray((int)3, (int)1333480094);
        long[] rms_waits = TestHelper.generateLongArray((int)3, (int)-159510796);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Reb_TrendingTelemetry(driver_errors, driver_received, driver_rx0, driver_rx1, driver_rx2, driver_rx3, firmware_cell_errors, firmware_last_rx, firmware_last_tx, firmware_link_down, firmware_link_errors, firmware_link_status, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_local3, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_overflow_remote3, firmware_rlink_data, firmware_rx_clock, firmware_rx_errors, firmware_rx_frames, firmware_rx_op, firmware_tx_clock, firmware_tx_errors, firmware_tx_frames, firmware_tx_op, location, rds_bdi_firsts, rds_bdi_frees, rds_bdi_lasts, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_bdi_waits, rds_discards, rds_no_event, rds_wakes, rms_in_reset, rms_inv_tids, rms_link_down, rms_lists_posted, rms_ops_posted, rms_orphans, rms_probes, rms_responses, rms_rundowns, rms_tid_hwm, rms_unopened, rms_waits));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Reb_TrendingTelemetry));
        Daq_monitor_Reb_TrendingTelemetry item_ = (Daq_monitor_Reb_TrendingTelemetry)item;
        Assert.assertArrayEquals((long[])driver_errors, (long[])item_.getDriver_errors());
        Assert.assertArrayEquals((long[])driver_received, (long[])item_.getDriver_received());
        Assert.assertArrayEquals((long[])driver_rx0, (long[])item_.getDriver_rx0());
        Assert.assertArrayEquals((long[])driver_rx1, (long[])item_.getDriver_rx1());
        Assert.assertArrayEquals((long[])driver_rx2, (long[])item_.getDriver_rx2());
        Assert.assertArrayEquals((long[])driver_rx3, (long[])item_.getDriver_rx3());
        Assert.assertArrayEquals((long[])firmware_cell_errors, (long[])item_.getFirmware_cell_errors());
        Assert.assertArrayEquals((long[])firmware_last_rx, (long[])item_.getFirmware_last_rx());
        Assert.assertArrayEquals((long[])firmware_last_tx, (long[])item_.getFirmware_last_tx());
        Assert.assertArrayEquals((long[])firmware_link_down, (long[])item_.getFirmware_link_down());
        Assert.assertArrayEquals((long[])firmware_link_errors, (long[])item_.getFirmware_link_errors());
        Assert.assertArrayEquals((long[])firmware_link_status, (long[])item_.getFirmware_link_status());
        Assert.assertArrayEquals((long[])firmware_overflow_local0, (long[])item_.getFirmware_overflow_local0());
        Assert.assertArrayEquals((long[])firmware_overflow_local1, (long[])item_.getFirmware_overflow_local1());
        Assert.assertArrayEquals((long[])firmware_overflow_local2, (long[])item_.getFirmware_overflow_local2());
        Assert.assertArrayEquals((long[])firmware_overflow_local3, (long[])item_.getFirmware_overflow_local3());
        Assert.assertArrayEquals((long[])firmware_overflow_remote0, (long[])item_.getFirmware_overflow_remote0());
        Assert.assertArrayEquals((long[])firmware_overflow_remote1, (long[])item_.getFirmware_overflow_remote1());
        Assert.assertArrayEquals((long[])firmware_overflow_remote2, (long[])item_.getFirmware_overflow_remote2());
        Assert.assertArrayEquals((long[])firmware_overflow_remote3, (long[])item_.getFirmware_overflow_remote3());
        Assert.assertArrayEquals((long[])firmware_rlink_data, (long[])item_.getFirmware_rlink_data());
        Assert.assertArrayEquals((long[])firmware_rx_clock, (long[])item_.getFirmware_rx_clock());
        Assert.assertArrayEquals((long[])firmware_rx_errors, (long[])item_.getFirmware_rx_errors());
        Assert.assertArrayEquals((long[])firmware_rx_frames, (long[])item_.getFirmware_rx_frames());
        Assert.assertArrayEquals((long[])firmware_rx_op, (long[])item_.getFirmware_rx_op());
        Assert.assertArrayEquals((long[])firmware_tx_clock, (long[])item_.getFirmware_tx_clock());
        Assert.assertArrayEquals((long[])firmware_tx_errors, (long[])item_.getFirmware_tx_errors());
        Assert.assertArrayEquals((long[])firmware_tx_frames, (long[])item_.getFirmware_tx_frames());
        Assert.assertArrayEquals((long[])firmware_tx_op, (long[])item_.getFirmware_tx_op());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])rds_bdi_firsts, (long[])item_.getRds_bdi_firsts());
        Assert.assertArrayEquals((long[])rds_bdi_frees, (long[])item_.getRds_bdi_frees());
        Assert.assertArrayEquals((long[])rds_bdi_lasts, (long[])item_.getRds_bdi_lasts());
        Assert.assertArrayEquals((long[])rds_bdi_nulls, (long[])item_.getRds_bdi_nulls());
        Assert.assertArrayEquals((long[])rds_bdi_overflows, (long[])item_.getRds_bdi_overflows());
        Assert.assertArrayEquals((long[])rds_bdi_seq_errors, (long[])item_.getRds_bdi_seq_errors());
        Assert.assertArrayEquals((long[])rds_bdi_waits, (long[])item_.getRds_bdi_waits());
        Assert.assertArrayEquals((long[])rds_discards, (long[])item_.getRds_discards());
        Assert.assertArrayEquals((long[])rds_no_event, (long[])item_.getRds_no_event());
        Assert.assertArrayEquals((long[])rds_wakes, (long[])item_.getRds_wakes());
        Assert.assertArrayEquals((long[])rms_in_reset, (long[])item_.getRms_in_reset());
        Assert.assertArrayEquals((long[])rms_inv_tids, (long[])item_.getRms_inv_tids());
        Assert.assertArrayEquals((long[])rms_link_down, (long[])item_.getRms_link_down());
        Assert.assertArrayEquals((long[])rms_lists_posted, (long[])item_.getRms_lists_posted());
        Assert.assertArrayEquals((long[])rms_ops_posted, (long[])item_.getRms_ops_posted());
        Assert.assertArrayEquals((long[])rms_orphans, (long[])item_.getRms_orphans());
        Assert.assertArrayEquals((long[])rms_probes, (long[])item_.getRms_probes());
        Assert.assertArrayEquals((long[])rms_responses, (long[])item_.getRms_responses());
        Assert.assertArrayEquals((long[])rms_rundowns, (long[])item_.getRms_rundowns());
        Assert.assertArrayEquals((long[])rms_tid_hwm, (long[])item_.getRms_tid_hwm());
        Assert.assertArrayEquals((long[])rms_unopened, (long[])item_.getRms_unopened());
        Assert.assertArrayEquals((long[])rms_waits, (long[])item_.getRms_waits());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.346380352973938;
        double freeFraction = 0.2991047501564026;
        double freeSpace = 0.7620956897735596;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeFraction, freeSpace));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Sum_TrendingTelemetry() throws Exception {
        long driver_errors = 774L;
        long firmware_cell_errors = 228L;
        long firmware_link_down = 829L;
        long firmware_link_errors = 889L;
        long firmware_overflow_local0 = 841L;
        long firmware_overflow_local1 = 926L;
        long firmware_overflow_local2 = 678L;
        long firmware_overflow_remote0 = 335L;
        long firmware_overflow_remote1 = 327L;
        long firmware_overflow_remote2 = 27L;
        long firmware_rx_errors = 866L;
        long firmware_tx_errors = 141L;
        long rds_bdi_nulls = 955L;
        long rds_bdi_overflows = 624L;
        long rds_bdi_seq_errors = 29L;
        long rds_discards = 407L;
        long rds_no_event = 750L;
        long rms_in_reset = 223L;
        long rms_inv_tids = 40L;
        long rms_link_down = 924L;
        long rms_orphans = 797L;
        long rms_unopened = 896L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Sum_TrendingTelemetry(driver_errors, firmware_cell_errors, firmware_link_down, firmware_link_errors, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_rx_errors, firmware_tx_errors, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_discards, rds_no_event, rms_in_reset, rms_inv_tids, rms_link_down, rms_orphans, rms_unopened));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Sum_TrendingTelemetry));
        Daq_monitor_Sum_TrendingTelemetry item_ = (Daq_monitor_Sum_TrendingTelemetry)item;
        Assert.assertEquals((long)driver_errors, (long)item_.getDriver_errors());
        Assert.assertEquals((long)firmware_cell_errors, (long)item_.getFirmware_cell_errors());
        Assert.assertEquals((long)firmware_link_down, (long)item_.getFirmware_link_down());
        Assert.assertEquals((long)firmware_link_errors, (long)item_.getFirmware_link_errors());
        Assert.assertEquals((long)firmware_overflow_local0, (long)item_.getFirmware_overflow_local0());
        Assert.assertEquals((long)firmware_overflow_local1, (long)item_.getFirmware_overflow_local1());
        Assert.assertEquals((long)firmware_overflow_local2, (long)item_.getFirmware_overflow_local2());
        Assert.assertEquals((long)firmware_overflow_remote0, (long)item_.getFirmware_overflow_remote0());
        Assert.assertEquals((long)firmware_overflow_remote1, (long)item_.getFirmware_overflow_remote1());
        Assert.assertEquals((long)firmware_overflow_remote2, (long)item_.getFirmware_overflow_remote2());
        Assert.assertEquals((long)firmware_rx_errors, (long)item_.getFirmware_rx_errors());
        Assert.assertEquals((long)firmware_tx_errors, (long)item_.getFirmware_tx_errors());
        Assert.assertEquals((long)rds_bdi_nulls, (long)item_.getRds_bdi_nulls());
        Assert.assertEquals((long)rds_bdi_overflows, (long)item_.getRds_bdi_overflows());
        Assert.assertEquals((long)rds_bdi_seq_errors, (long)item_.getRds_bdi_seq_errors());
        Assert.assertEquals((long)rds_discards, (long)item_.getRds_discards());
        Assert.assertEquals((long)rds_no_event, (long)item_.getRds_no_event());
        Assert.assertEquals((long)rms_in_reset, (long)item_.getRms_in_reset());
        Assert.assertEquals((long)rms_inv_tids, (long)item_.getRms_inv_tids());
        Assert.assertEquals((long)rms_link_down, (long)item_.getRms_link_down());
        Assert.assertEquals((long)rms_orphans, (long)item_.getRms_orphans());
        Assert.assertEquals((long)rms_unopened, (long)item_.getRms_unopened());
    }

    @Test
    public void sendReceiveRebpower_RebTelemetry() throws Exception {
        double[] analog_IaftLDO = TestHelper.generateDoubleArray((int)6, (int)-706430264);
        double[] analog_IbefLDO = TestHelper.generateDoubleArray((int)6, (int)-2024826723);
        double[] analog_VaftLDO = TestHelper.generateDoubleArray((int)6, (int)226610770);
        double[] analog_VaftSwch = TestHelper.generateDoubleArray((int)6, (int)1090344627);
        double[] analog_VbefLDO = TestHelper.generateDoubleArray((int)6, (int)-1421096878);
        double[] clockhi_IaftLDO = TestHelper.generateDoubleArray((int)6, (int)-221279324);
        double[] clockhi_IbefLDO = TestHelper.generateDoubleArray((int)6, (int)279604959);
        double[] clockhi_VaftLDO = TestHelper.generateDoubleArray((int)6, (int)-2041764593);
        double[] clockhi_VaftSwch = TestHelper.generateDoubleArray((int)6, (int)1594183144);
        double[] clockhi_VbefLDO = TestHelper.generateDoubleArray((int)6, (int)-1258849587);
        double[] clocklo_IaftLDO = TestHelper.generateDoubleArray((int)6, (int)-2004607681);
        double[] clocklo_IbefLDO = TestHelper.generateDoubleArray((int)6, (int)-222612607);
        double[] clocklo_VaftLDO = TestHelper.generateDoubleArray((int)6, (int)-1645159538);
        double[] clocklo_VaftLDO2 = TestHelper.generateDoubleArray((int)6, (int)1954003400);
        double[] clocklo_VaftSwch = TestHelper.generateDoubleArray((int)6, (int)-824276443);
        double[] clocklo_VbefLDO = TestHelper.generateDoubleArray((int)6, (int)1011753935);
        double[] digital_IaftLDO = TestHelper.generateDoubleArray((int)6, (int)463363028);
        double[] digital_IbefLDO = TestHelper.generateDoubleArray((int)6, (int)957741140);
        double[] digital_VaftLDO = TestHelper.generateDoubleArray((int)6, (int)-641722085);
        double[] digital_VaftSwch = TestHelper.generateDoubleArray((int)6, (int)1742735191);
        double[] digital_VbefLDO = TestHelper.generateDoubleArray((int)6, (int)-551451010);
        double[] heater_IaftLDO = TestHelper.generateDoubleArray((int)6, (int)31746581);
        double[] heater_IbefLDO = TestHelper.generateDoubleArray((int)6, (int)1310346694);
        double[] heater_VaftLDO = TestHelper.generateDoubleArray((int)6, (int)-1932788486);
        double[] heater_VaftSwch = TestHelper.generateDoubleArray((int)6, (int)-992519834);
        double[] heater_VbefLDO = TestHelper.generateDoubleArray((int)6, (int)-1692198998);
        double[] hvbias_IbefSwch = TestHelper.generateDoubleArray((int)6, (int)369183085);
        double[] hvbias_VbefSwch = TestHelper.generateDoubleArray((int)6, (int)-754763176);
        String location = "";
        double[] od_IaftLDO = TestHelper.generateDoubleArray((int)6, (int)-1430475521);
        double[] od_IbefLDO = TestHelper.generateDoubleArray((int)6, (int)-526443333);
        double[] od_VaftLDO = TestHelper.generateDoubleArray((int)6, (int)-506661827);
        double[] od_VaftLDO2 = TestHelper.generateDoubleArray((int)6, (int)1443606241);
        double[] od_VaftSwch = TestHelper.generateDoubleArray((int)6, (int)1469143262);
        double[] od_VbefLDO = TestHelper.generateDoubleArray((int)6, (int)375648708);
        double[] power = TestHelper.generateDoubleArray((int)6, (int)1371003482);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTelemetry(analog_IaftLDO, analog_IbefLDO, analog_VaftLDO, analog_VaftSwch, analog_VbefLDO, clockhi_IaftLDO, clockhi_IbefLDO, clockhi_VaftLDO, clockhi_VaftSwch, clockhi_VbefLDO, clocklo_IaftLDO, clocklo_IbefLDO, clocklo_VaftLDO, clocklo_VaftLDO2, clocklo_VaftSwch, clocklo_VbefLDO, digital_IaftLDO, digital_IbefLDO, digital_VaftLDO, digital_VaftSwch, digital_VbefLDO, heater_IaftLDO, heater_IbefLDO, heater_VaftLDO, heater_VaftSwch, heater_VbefLDO, hvbias_IbefSwch, hvbias_VbefSwch, location, od_IaftLDO, od_IbefLDO, od_VaftLDO, od_VaftLDO2, od_VaftSwch, od_VbefLDO, power));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTelemetry));
        Rebpower_RebTelemetry item_ = (Rebpower_RebTelemetry)item;
        Assert.assertArrayEquals((double[])analog_IaftLDO, (double[])item_.getAnalog_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO, (double[])item_.getAnalog_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO, (double[])item_.getAnalog_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch, (double[])item_.getAnalog_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO, (double[])item_.getAnalog_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO, (double[])item_.getClockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO, (double[])item_.getClockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO, (double[])item_.getClockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch, (double[])item_.getClockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO, (double[])item_.getClockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO, (double[])item_.getClocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO, (double[])item_.getClocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO, (double[])item_.getClocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2, (double[])item_.getClocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch, (double[])item_.getClocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO, (double[])item_.getClocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO, (double[])item_.getDigital_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO, (double[])item_.getDigital_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO, (double[])item_.getDigital_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch, (double[])item_.getDigital_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO, (double[])item_.getDigital_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO, (double[])item_.getHeater_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO, (double[])item_.getHeater_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO, (double[])item_.getHeater_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch, (double[])item_.getHeater_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO, (double[])item_.getHeater_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch, (double[])item_.getHvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch, (double[])item_.getHvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO, (double[])item_.getOd_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO, (double[])item_.getOd_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO, (double[])item_.getOd_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2, (double[])item_.getOd_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch, (double[])item_.getOd_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO, (double[])item_.getOd_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.1792404055595398;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTotalPowerTelemetry));
        Rebpower_RebTotalPowerTelemetry item_ = (Rebpower_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebpsTelemetry() throws Exception {
        double[] boardTemp0 = TestHelper.generateDoubleArray((int)1, (int)1742180812);
        double[] boardTemp1 = TestHelper.generateDoubleArray((int)1, (int)75518533);
        double[] boardTemp2 = TestHelper.generateDoubleArray((int)1, (int)-914679241);
        double[] boardTemp3 = TestHelper.generateDoubleArray((int)1, (int)-521650074);
        double[] boardTemp4 = TestHelper.generateDoubleArray((int)1, (int)-1895574510);
        double[] boardTemp5 = TestHelper.generateDoubleArray((int)1, (int)-809038289);
        double[] boardTemp6 = TestHelper.generateDoubleArray((int)1, (int)1458576744);
        double[] fPGATemp = TestHelper.generateDoubleArray((int)1, (int)-1470858451);
        String location = "z";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebpsTelemetry(boardTemp0, boardTemp1, boardTemp2, boardTemp3, boardTemp4, boardTemp5, boardTemp6, fPGATemp, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebpsTelemetry));
        Rebpower_RebpsTelemetry item_ = (Rebpower_RebpsTelemetry)item;
        Assert.assertArrayEquals((double[])boardTemp0, (double[])item_.getBoardTemp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp1, (double[])item_.getBoardTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp2, (double[])item_.getBoardTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp3, (double[])item_.getBoardTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp4, (double[])item_.getBoardTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp5, (double[])item_.getBoardTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp6, (double[])item_.getBoardTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fPGATemp, (double[])item_.getFPGATemp(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_Cold1Telemetry() throws Exception {
        double autoOffEnabled = 0.883506178855896;
        double autoOffTemperature = 0.4668201208114624;
        double autoOnTemperature = 0.13173907995224;
        double power = 0.38600724935531616;
        double rejectTemperature = 0.5483200550079346;
        double setPower = 0.7548995018005371;
        double setpoint = 0.04621785879135132;
        double temperature = 0.43778812885284424;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Cold1Telemetry(autoOffEnabled, autoOffTemperature, autoOnTemperature, power, rejectTemperature, setPower, setpoint, temperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold1Telemetry));
        Vacuum_Cold1Telemetry item_ = (Vacuum_Cold1Telemetry)item;
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold2Telemetry() throws Exception {
        double autoOffEnabled = 0.6151735782623291;
        double autoOffTemperature = 0.11285722255706787;
        double autoOnTemperature = 0.41614866256713867;
        double power = 0.6166310906410217;
        double rejectTemperature = 0.745116f;
        double setPower = 0.20814841985702515;
        double setpoint = 0.9986693263053894;
        double temperature = 0.24381285905838013;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Cold2Telemetry(autoOffEnabled, autoOffTemperature, autoOnTemperature, power, rejectTemperature, setPower, setpoint, temperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold2Telemetry));
        Vacuum_Cold2Telemetry item_ = (Vacuum_Cold2Telemetry)item;
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoTelemetry() throws Exception {
        double autoOffEnabled = 0.5113597512245178;
        double autoOffTemperature = 0.4800183176994324;
        double autoOnTemperature = 0.11721396446228027;
        double power = 0.7590519189834595;
        double rejectTemperature = 0.23517823219299316;
        double setPower = 0.7652957439422607;
        double setpoint = 0.03028369f;
        double temperature = 0.8887019157409668;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoTelemetry(autoOffEnabled, autoOffTemperature, autoOnTemperature, power, rejectTemperature, setPower, setpoint, temperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTelemetry));
        Vacuum_CryoTelemetry item_ = (Vacuum_CryoTelemetry)item;
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_IonPumpsTelemetry() throws Exception {
        double current = 0.3824140429496765;
        double voltage = 0.4457968f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_IonPumpsTelemetry(current, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumpsTelemetry));
        Vacuum_IonPumpsTelemetry item_ = (Vacuum_IonPumpsTelemetry)item;
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_RtdsTelemetry() throws Exception {
        double temperatureCold1 = 0.04528224468231201;
        double temperatureCold2 = 0.24748897552490234;
        double temperatureCryo = 0.027725934982299805;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_RtdsTelemetry(temperatureCold1, temperatureCold2, temperatureCryo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_RtdsTelemetry));
        Vacuum_RtdsTelemetry item_ = (Vacuum_RtdsTelemetry)item;
        Assert.assertEquals((double)temperatureCold1, (double)item_.getTemperatureCold1(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatureCold2, (double)item_.getTemperatureCold2(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatureCryo, (double)item_.getTemperatureCryo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboTelemetry() throws Exception {
        double cntrlrAirTemperature = 0.0847016f;
        double cntrlrSinkTemperature = 0.37607938051223755;
        double current = 0.8977767825126648;
        double driveFrequency = 0.3214273452758789;
        double power = 0.4672391414642334;
        double pumpTemperature = 0.6245750784873962;
        double rpm = 0.7339740991592407;
        double status = 0.3867373f;
        double voltage = 0.7396143078804016;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboTelemetry(cntrlrAirTemperature, cntrlrSinkTemperature, current, driveFrequency, power, pumpTemperature, rpm, status, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboTelemetry));
        Vacuum_TurboTelemetry item_ = (Vacuum_TurboTelemetry)item;
        Assert.assertEquals((double)cntrlrAirTemperature, (double)item_.getCntrlrAirTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrSinkTemperature, (double)item_.getCntrlrSinkTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)driveFrequency, (double)item_.getDriveFrequency(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpTemperature, (double)item_.getPumpTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)rpm, (double)item_.getRpm(), (double)1.0E-6f);
        Assert.assertEquals((double)status, (double)item_.getStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_VQMonitorTelemetry() throws Exception {
        double vqmpressure = 0.5302886962890625;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_VQMonitorTelemetry(vqmpressure));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VQMonitorTelemetry));
        Vacuum_VQMonitorTelemetry item_ = (Vacuum_VQMonitorTelemetry)item;
        Assert.assertEquals((double)vqmpressure, (double)item_.getVqmpressure(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double clean_5_24V_I = 0.52546226978302;
        double dirty_24V_I = 0.4743010997772217;
        double dirty_28V_I = 0.09875047206878662;
        double dirty_48V_I = 0.06402587890625;
        double heater_I = 0.2277928f;
        double protection_I = 0.5498886704444885;
        double rebps_0 = 0.5141436457633972;
        double sensor_PWS_17_I = 0.15622997283935547;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(clean_5_24V_I, dirty_24V_I, dirty_28V_I, dirty_48V_I, heater_I, protection_I, rebps_0, sensor_PWS_17_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I, (double)item_.getHeater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0, (double)item_.getRebps_0(), (double)1.0E-6f);
        Assert.assertEquals((double)sensor_PWS_17_I, (double)item_.getSensor_PWS_17_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double board_T = 0.7129836082458496;
        double body_Purge_I = 0.2873063087463379;
        double body_Purge_V = 0.9425868988037109;
        double bpu_Maq20_I = 0.04010009765625;
        double bpu_Maq20_V = 0.3452610969543457;
        double fpga_T = 0.8819695115089417;
        double fes_Shu_HCU_I = 0.7480261325836182;
        double fes_Shu_HCU_V = 0.8744506239891052;
        double gauges_I = 0.07389664649963379;
        double gauges_V = 0.3445904850959778;
        double ion_Pumps_I = 0.7742528319358826;
        double ion_Pumps_V = 0.5902373194694519;
        double j11_I = 0.68085777759552;
        double j11_V = 0.33548396825790405;
        double j12_I = 0.09007406234741211;
        double j12_V = 0.7044384479522705;
        double j6_I = 0.02442491054534912;
        double j6_V = 0.967660129070282;
        double j7_I = 0.5781850814819336;
        double j7_V = 0.6704366207122803;
        double j8_I = 0.0929533839225769;
        double j8_V = 0.8538467884063721;
        double j9_I = 0.6539929509162903;
        double j9_V = 0.5182100534439087;
        double main_I = 0.22342896461486816;
        double main_T = 0.46468567848205566;
        double main_V = 0.7535201907157898;
        double pwr_Cry_HCU_I = 0.49164074659347534;
        double pwr_Cry_HCU_V = 0.2608568072319031;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(board_T, body_Purge_I, body_Purge_V, bpu_Maq20_I, bpu_Maq20_V, fpga_T, fes_Shu_HCU_I, fes_Shu_HCU_V, gauges_I, gauges_V, ion_Pumps_I, ion_Pumps_V, j11_I, j11_V, j12_I, j12_V, j6_I, j6_V, j7_I, j7_V, j8_I, j8_V, j9_I, j9_V, main_I, main_T, main_V, pwr_Cry_HCU_I, pwr_Cry_HCU_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I, (double)item_.getBody_Purge_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V, (double)item_.getBody_Purge_V(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I, (double)item_.getBpu_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V, (double)item_.getBpu_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I, (double)item_.getFes_Shu_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V, (double)item_.getFes_Shu_HCU_V(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_I, (double)item_.getJ11_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_V, (double)item_.getJ11_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_I, (double)item_.getJ12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_V, (double)item_.getJ12_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_I, (double)item_.getJ6_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_V, (double)item_.getJ6_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_I, (double)item_.getJ7_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_V, (double)item_.getJ7_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j8_I, (double)item_.getJ8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j8_V, (double)item_.getJ8_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_I, (double)item_.getJ9_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_V, (double)item_.getJ9_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I, (double)item_.getPwr_Cry_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V, (double)item_.getPwr_Cry_HCU_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double board_T = 0.2715240716934204;
        double fes_I = 0.23528772592544556;
        double fes_V = 0.8533391356468201;
        double fpga_T = 0.815934956073761;
        double main_I = 0.2895486354827881;
        double main_T = 0.8054046630859375;
        double main_V = 0.31695497035980225;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(board_T, fes_I, fes_V, fpga_T, main_I, main_T, main_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_I, (double)item_.getFes_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_V, (double)item_.getFes_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double board_T = 0.21462613344192505;
        double cryotel0_I = 0.34066665172576904;
        double cryotel0_V = 0.94427f;
        double cryotel1_I = 0.828498899936676;
        double cryotel1_V = 0.5845011472702026;
        double cryotel2_I = 0.39886826276779175;
        double cryotel2_V = 0.4242229461669922;
        double fpga_T = 0.8753719329833984;
        double main_I = 0.6650663018226624;
        double main_T = 0.7452285289764404;
        double main_V = 0.33771592378616333;
        double reb_BULK_I = 0.7063472867012024;
        double reb_BULK_V = 0.004302442f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(board_T, cryotel0_I, cryotel0_V, cryotel1_I, cryotel1_V, cryotel2_I, cryotel2_V, fpga_T, main_I, main_T, main_V, reb_BULK_I, reb_BULK_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_I, (double)item_.getCryotel0_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_V, (double)item_.getCryotel0_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_I, (double)item_.getCryotel1_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_V, (double)item_.getCryotel1_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_I, (double)item_.getCryotel2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_V, (double)item_.getCryotel2_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_I, (double)item_.getReb_BULK_I(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_V, (double)item_.getReb_BULK_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_3_B_I = 0.7798169255256653;
        double otm_3_B_V = 0.9732813239097595;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_3_B_I, otm_3_B_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_3_B_I, (double)item_.getOtm_3_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V, (double)item_.getOtm_3_B_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_CcdTelemetry() throws Exception {
        double[] gDV = TestHelper.generateDoubleArray((int)9, (int)-311147673);
        String location = "b";
        double[] oDV = TestHelper.generateDoubleArray((int)9, (int)-470243363);
        double[] oGV = TestHelper.generateDoubleArray((int)9, (int)-615919827);
        double[] rDV = TestHelper.generateDoubleArray((int)9, (int)1591992533);
        double[] temp = TestHelper.generateDoubleArray((int)9, (int)1985793845);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_CcdTelemetry(gDV, location, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_CcdTelemetry));
        Focal_plane_CcdTelemetry item_ = (Focal_plane_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTelemetry() throws Exception {
        double[] anaI = TestHelper.generateDoubleArray((int)3, (int)235793704);
        double[] anaV = TestHelper.generateDoubleArray((int)3, (int)-835941860);
        double[] aspicl_Temp0 = TestHelper.generateDoubleArray((int)3, (int)1932240234);
        double[] aspicl_Temp1 = TestHelper.generateDoubleArray((int)3, (int)2087325367);
        double[] aspicl_Temp2 = TestHelper.generateDoubleArray((int)3, (int)1884096494);
        double[] aspicu_Temp0 = TestHelper.generateDoubleArray((int)3, (int)2088857353);
        double[] aspicu_Temp1 = TestHelper.generateDoubleArray((int)3, (int)-1624007357);
        double[] aspicu_Temp2 = TestHelper.generateDoubleArray((int)3, (int)1402627939);
        double[] clkHI = TestHelper.generateDoubleArray((int)3, (int)23749610);
        double[] clkHV = TestHelper.generateDoubleArray((int)3, (int)-261094871);
        double[] clkLI = TestHelper.generateDoubleArray((int)3, (int)325500859);
        double[] clkLV = TestHelper.generateDoubleArray((int)3, (int)-1122721646);
        double[] digI = TestHelper.generateDoubleArray((int)3, (int)199263127);
        double[] digV = TestHelper.generateDoubleArray((int)3, (int)-2038628892);
        double[] hVBiasSwitch = TestHelper.generateDoubleArray((int)3, (int)925560920);
        double[] htrV = TestHelper.generateDoubleArray((int)3, (int)-1420766733);
        double[] htrW = TestHelper.generateDoubleArray((int)3, (int)-504987111);
        String location = "";
        double[] oDI = TestHelper.generateDoubleArray((int)3, (int)529476946);
        double[] oDV = TestHelper.generateDoubleArray((int)3, (int)-1581463101);
        double[] pClkL = TestHelper.generateDoubleArray((int)3, (int)-1707978915);
        double[] pClkU = TestHelper.generateDoubleArray((int)3, (int)2063325593);
        double[] power = TestHelper.generateDoubleArray((int)3, (int)1859101270);
        double[] rGL = TestHelper.generateDoubleArray((int)3, (int)-846978502);
        double[] rGU = TestHelper.generateDoubleArray((int)3, (int)-1084224898);
        double[] rTDTemp = TestHelper.generateDoubleArray((int)3, (int)749546084);
        double[] ref05V = TestHelper.generateDoubleArray((int)3, (int)-2067684473);
        double[] ref125V = TestHelper.generateDoubleArray((int)3, (int)-2034255288);
        double[] ref15V = TestHelper.generateDoubleArray((int)3, (int)1435115114);
        double[] ref25V = TestHelper.generateDoubleArray((int)3, (int)-401431594);
        double[] refN12 = TestHelper.generateDoubleArray((int)3, (int)-925510460);
        double[] refP12 = TestHelper.generateDoubleArray((int)3, (int)-313031295);
        double[] sClkL = TestHelper.generateDoubleArray((int)3, (int)-734788411);
        double[] sClkU = TestHelper.generateDoubleArray((int)3, (int)1715371921);
        double[] temp1 = TestHelper.generateDoubleArray((int)3, (int)-1132527312);
        double[] temp10 = TestHelper.generateDoubleArray((int)3, (int)1243408212);
        double[] temp2 = TestHelper.generateDoubleArray((int)3, (int)1482937101);
        double[] temp3 = TestHelper.generateDoubleArray((int)3, (int)1637378209);
        double[] temp4 = TestHelper.generateDoubleArray((int)3, (int)-995072274);
        double[] temp5 = TestHelper.generateDoubleArray((int)3, (int)575868291);
        double[] temp6 = TestHelper.generateDoubleArray((int)3, (int)1910830590);
        double[] temp7 = TestHelper.generateDoubleArray((int)3, (int)1741888789);
        double[] temp8 = TestHelper.generateDoubleArray((int)3, (int)-1961985236);
        double[] temp9 = TestHelper.generateDoubleArray((int)3, (int)-1791099442);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicl_Temp1, aspicl_Temp2, aspicu_Temp0, aspicu_Temp1, aspicu_Temp2, clkHI, clkHV, clkLI, clkLV, digI, digV, hVBiasSwitch, htrV, htrW, location, oDI, oDV, pClkL, pClkU, power, rGL, rGU, rTDTemp, ref05V, ref125V, ref15V, ref25V, refN12, refP12, sClkL, sClkU, temp1, temp10, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTelemetry));
        Focal_plane_RebTelemetry item_ = (Focal_plane_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1, (double[])item_.getAspicl_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2, (double[])item_.getAspicl_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1, (double[])item_.getAspicu_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2, (double[])item_.getAspicu_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLI, (double[])item_.getClkLI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05V, (double[])item_.getRef05V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125V, (double[])item_.getRef125V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15V, (double[])item_.getRef15V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25V, (double[])item_.getRef25V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refN12, (double[])item_.getRefN12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refP12, (double[])item_.getRefP12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10, (double[])item_.getTemp10(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7, (double[])item_.getTemp7(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8, (double[])item_.getTemp8(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9, (double[])item_.getTemp9(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.2243766188621521;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPowerTelemetry));
        Focal_plane_RebTotalPowerTelemetry item_ = (Focal_plane_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebsAverageTemp6Telemetry() throws Exception {
        double rebsAverageTemp6 = 0.5141918659210205;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebsAverageTemp6Telemetry(rebsAverageTemp6));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebsAverageTemp6Telemetry));
        Focal_plane_RebsAverageTemp6Telemetry item_ = (Focal_plane_RebsAverageTemp6Telemetry)item;
        Assert.assertEquals((double)rebsAverageTemp6, (double)item_.getRebsAverageTemp6(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_SegmentTelemetry() throws Exception {
        double[] i = TestHelper.generateDoubleArray((int)144, (int)395930211);
        String location = "q";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_SegmentTelemetry(i, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SegmentTelemetry));
        Focal_plane_SegmentTelemetry item_ = (Focal_plane_SegmentTelemetry)item;
        Assert.assertArrayEquals((double[])i, (double[])item_.getI(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }
}

