package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class Vacuum_VacuumConfigurationEvent extends CameraEvent {
  private final String version;

  private final double pressDiffHigh;

  private final double pressDiffLow;

  private final double pressForelineLow;

  private final double pressIonEnable;

  private final double pressIonOff;

  private final double pressTurboLow;

  private final double pressVacuum;

  public Vacuum_VacuumConfigurationEvent(String version, double pressDiffHigh, double pressDiffLow,
      double pressForelineLow, double pressIonEnable, double pressIonOff, double pressTurboLow,
      double pressVacuum) {
    this.version = version;
    this.pressDiffHigh = pressDiffHigh;
    this.pressDiffLow = pressDiffLow;
    this.pressForelineLow = pressForelineLow;
    this.pressIonEnable = pressIonEnable;
    this.pressIonOff = pressIonOff;
    this.pressTurboLow = pressTurboLow;
    this.pressVacuum = pressVacuum;
  }

  public String getVersion() {
    return version;
  }

  public double getPressDiffHigh() {
    return pressDiffHigh;
  }

  public double getPressDiffLow() {
    return pressDiffLow;
  }

  public double getPressForelineLow() {
    return pressForelineLow;
  }

  public double getPressIonEnable() {
    return pressIonEnable;
  }

  public double getPressIonOff() {
    return pressIonOff;
  }

  public double getPressTurboLow() {
    return pressTurboLow;
  }

  public double getPressVacuum() {
    return pressVacuum;
  }

  @Override
  public String toString() {
    return "Vacuum_VacuumConfigurationEvent{" + "version=" + version +
        ", pressDiffHigh=" + pressDiffHigh +", pressDiffLow=" + pressDiffLow +
        ", pressForelineLow=" + pressForelineLow +", pressIonEnable=" + pressIonEnable +
        ", pressIonOff=" + pressIonOff +", pressTurboLow=" + pressTurboLow +
        ", pressVacuum=" + pressVacuum +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private String version;

    private double pressDiffHigh;

    private double pressDiffLow;

    private double pressForelineLow;

    private double pressIonEnable;

    private double pressIonOff;

    private double pressTurboLow;

    private double pressVacuum;

    private Builder() {
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder pressDiffHigh(double pressDiffHigh) {
      this.pressDiffHigh = pressDiffHigh;
      return this;
    }

    public Builder pressDiffLow(double pressDiffLow) {
      this.pressDiffLow = pressDiffLow;
      return this;
    }

    public Builder pressForelineLow(double pressForelineLow) {
      this.pressForelineLow = pressForelineLow;
      return this;
    }

    public Builder pressIonEnable(double pressIonEnable) {
      this.pressIonEnable = pressIonEnable;
      return this;
    }

    public Builder pressIonOff(double pressIonOff) {
      this.pressIonOff = pressIonOff;
      return this;
    }

    public Builder pressTurboLow(double pressTurboLow) {
      this.pressTurboLow = pressTurboLow;
      return this;
    }

    public Builder pressVacuum(double pressVacuum) {
      this.pressVacuum = pressVacuum;
      return this;
    }

    public Vacuum_VacuumConfigurationEvent build() {
      return new Vacuum_VacuumConfigurationEvent(version, pressDiffHigh, pressDiffLow, pressForelineLow, pressIonEnable, pressIonOff, pressTurboLow, pressVacuum);
    }
  }
}
