package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class Vacuum_VQMonitor_CryoConfigurationEvent extends CameraEvent {
  private final String version;

  private final int busAddr;

  private final String devcId;

  private final double relayTrip;

  public Vacuum_VQMonitor_CryoConfigurationEvent(String version, int busAddr, String devcId,
      double relayTrip) {
    this.version = version;
    this.busAddr = busAddr;
    this.devcId = devcId;
    this.relayTrip = relayTrip;
  }

  public String getVersion() {
    return version;
  }

  public int getBusAddr() {
    return busAddr;
  }

  public String getDevcId() {
    return devcId;
  }

  public double getRelayTrip() {
    return relayTrip;
  }

  @Override
  public String toString() {
    return "Vacuum_VQMonitor_CryoConfigurationEvent{" + "version=" + version +
        ", busAddr=" + busAddr +", devcId=" + devcId +", relayTrip=" + relayTrip +"}";
  }
}
