package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class Vacuum_IonPumps_CryoConfigurationEvent extends CameraEvent {
  private final String version;

  private final double cip1c_current;

  private final double cip1c_power;

  private final double cip1c_voltage;

  private final String ipAddr;

  public Vacuum_IonPumps_CryoConfigurationEvent(String version, double cip1c_current,
      double cip1c_power, double cip1c_voltage, String ipAddr) {
    this.version = version;
    this.cip1c_current = cip1c_current;
    this.cip1c_power = cip1c_power;
    this.cip1c_voltage = cip1c_voltage;
    this.ipAddr = ipAddr;
  }

  public String getVersion() {
    return version;
  }

  public double getCip1c_current() {
    return cip1c_current;
  }

  public double getCip1c_power() {
    return cip1c_power;
  }

  public double getCip1c_voltage() {
    return cip1c_voltage;
  }

  public String getIpAddr() {
    return ipAddr;
  }

  @Override
  public String toString() {
    return "Vacuum_IonPumps_CryoConfigurationEvent{" + "version=" + version +
        ", cip1c_current=" + cip1c_current +", cip1c_power=" + cip1c_power +
        ", cip1c_voltage=" + cip1c_voltage +", ipAddr=" + ipAddr +"}";
  }
}
