package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class Quadbox_PDU_5V_LimitsConfigurationEvent extends CameraEvent {
  private final String version;

  private final double otm_3_B_I_warnHi;

  private final double otm_3_B_I_warnLo;

  private final double otm_3_B_I_limitHi;

  private final double otm_3_B_I_limitLo;

  private final double otm_3_B_V_warnHi;

  private final double otm_3_B_V_warnLo;

  private final double otm_3_B_V_limitHi;

  private final double otm_3_B_V_limitLo;

  public Quadbox_PDU_5V_LimitsConfigurationEvent(String version, double otm_3_B_I_warnHi,
      double otm_3_B_I_warnLo, double otm_3_B_I_limitHi, double otm_3_B_I_limitLo,
      double otm_3_B_V_warnHi, double otm_3_B_V_warnLo, double otm_3_B_V_limitHi,
      double otm_3_B_V_limitLo) {
    this.version = version;
    this.otm_3_B_I_warnHi = otm_3_B_I_warnHi;
    this.otm_3_B_I_warnLo = otm_3_B_I_warnLo;
    this.otm_3_B_I_limitHi = otm_3_B_I_limitHi;
    this.otm_3_B_I_limitLo = otm_3_B_I_limitLo;
    this.otm_3_B_V_warnHi = otm_3_B_V_warnHi;
    this.otm_3_B_V_warnLo = otm_3_B_V_warnLo;
    this.otm_3_B_V_limitHi = otm_3_B_V_limitHi;
    this.otm_3_B_V_limitLo = otm_3_B_V_limitLo;
  }

  public String getVersion() {
    return version;
  }

  public double getOtm_3_B_I_warnHi() {
    return otm_3_B_I_warnHi;
  }

  public double getOtm_3_B_I_warnLo() {
    return otm_3_B_I_warnLo;
  }

  public double getOtm_3_B_I_limitHi() {
    return otm_3_B_I_limitHi;
  }

  public double getOtm_3_B_I_limitLo() {
    return otm_3_B_I_limitLo;
  }

  public double getOtm_3_B_V_warnHi() {
    return otm_3_B_V_warnHi;
  }

  public double getOtm_3_B_V_warnLo() {
    return otm_3_B_V_warnLo;
  }

  public double getOtm_3_B_V_limitHi() {
    return otm_3_B_V_limitHi;
  }

  public double getOtm_3_B_V_limitLo() {
    return otm_3_B_V_limitLo;
  }

  @Override
  public String toString() {
    return "Quadbox_PDU_5V_LimitsConfigurationEvent{" + "version=" + version +
        ", otm_3_B_I_warnHi=" + otm_3_B_I_warnHi +", otm_3_B_I_warnLo=" + otm_3_B_I_warnLo +
        ", otm_3_B_I_limitHi=" + otm_3_B_I_limitHi +", otm_3_B_I_limitLo=" + otm_3_B_I_limitLo +
        ", otm_3_B_V_warnHi=" + otm_3_B_V_warnHi +", otm_3_B_V_warnLo=" + otm_3_B_V_warnLo +
        ", otm_3_B_V_limitHi=" + otm_3_B_V_limitHi +", otm_3_B_V_limitLo=" + otm_3_B_V_limitLo +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private String version;

    private double otm_3_B_I_warnHi;

    private double otm_3_B_I_warnLo;

    private double otm_3_B_I_limitHi;

    private double otm_3_B_I_limitLo;

    private double otm_3_B_V_warnHi;

    private double otm_3_B_V_warnLo;

    private double otm_3_B_V_limitHi;

    private double otm_3_B_V_limitLo;

    private Builder() {
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder otm_3_B_I_warnHi(double otm_3_B_I_warnHi) {
      this.otm_3_B_I_warnHi = otm_3_B_I_warnHi;
      return this;
    }

    public Builder otm_3_B_I_warnLo(double otm_3_B_I_warnLo) {
      this.otm_3_B_I_warnLo = otm_3_B_I_warnLo;
      return this;
    }

    public Builder otm_3_B_I_limitHi(double otm_3_B_I_limitHi) {
      this.otm_3_B_I_limitHi = otm_3_B_I_limitHi;
      return this;
    }

    public Builder otm_3_B_I_limitLo(double otm_3_B_I_limitLo) {
      this.otm_3_B_I_limitLo = otm_3_B_I_limitLo;
      return this;
    }

    public Builder otm_3_B_V_warnHi(double otm_3_B_V_warnHi) {
      this.otm_3_B_V_warnHi = otm_3_B_V_warnHi;
      return this;
    }

    public Builder otm_3_B_V_warnLo(double otm_3_B_V_warnLo) {
      this.otm_3_B_V_warnLo = otm_3_B_V_warnLo;
      return this;
    }

    public Builder otm_3_B_V_limitHi(double otm_3_B_V_limitHi) {
      this.otm_3_B_V_limitHi = otm_3_B_V_limitHi;
      return this;
    }

    public Builder otm_3_B_V_limitLo(double otm_3_B_V_limitLo) {
      this.otm_3_B_V_limitLo = otm_3_B_V_limitLo;
      return this;
    }

    public Quadbox_PDU_5V_LimitsConfigurationEvent build() {
      return new Quadbox_PDU_5V_LimitsConfigurationEvent(version, otm_3_B_I_warnHi, otm_3_B_I_warnLo, otm_3_B_I_limitHi, otm_3_B_I_limitLo, otm_3_B_V_warnHi, otm_3_B_V_warnLo, otm_3_B_V_limitHi, otm_3_B_V_limitLo);
    }
  }
}
