package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class Bonn_shutter_GeneralConfigurationEvent extends CameraEvent {
  private final String version;

  private final double maxExposureTime;

  private final double minExposureTime;

  private final int openCloseTimeMillis;

  public Bonn_shutter_GeneralConfigurationEvent(String version, double maxExposureTime,
      double minExposureTime, int openCloseTimeMillis) {
    this.version = version;
    this.maxExposureTime = maxExposureTime;
    this.minExposureTime = minExposureTime;
    this.openCloseTimeMillis = openCloseTimeMillis;
  }

  public String getVersion() {
    return version;
  }

  public double getMaxExposureTime() {
    return maxExposureTime;
  }

  public double getMinExposureTime() {
    return minExposureTime;
  }

  public int getOpenCloseTimeMillis() {
    return openCloseTimeMillis;
  }

  @Override
  public String toString() {
    return "Bonn_shutter_GeneralConfigurationEvent{" + "version=" + version +
        ", maxExposureTime=" + maxExposureTime +", minExposureTime=" + minExposureTime +
        ", openCloseTimeMillis=" + openCloseTimeMillis +"}";
  }
}
