/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.cccamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.telemetry.Daq_monitor_Reb_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_Sum_TrendingTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebsAverageTemp6Telemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry;
import org.lsst.sal.cccamera.CCCamera;
import org.lsst.sal.cccamera.telemetry.Bonn_shutter_DeviceTelemetry;
import org.lsst.sal.cccamera.telemetry.FcsTelemetry;
import org.lsst.sal.cccamera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.cccamera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_RebTelemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_RebpsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold1Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold2Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_IonPumpsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_RtdsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_TurboTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_VQMonitorTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = CCCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveFcsTelemetry() throws Exception {
        double linearencoder_LinearPosition = 0.8744506239891052;
        double steppermotor_MotorEncoder = 0.07389664649963379;
        double steppermotor_MotorTemperature = 0.3445904850959778;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new FcsTelemetry(linearencoder_LinearPosition, steppermotor_MotorEncoder, steppermotor_MotorTemperature));
        Assert.assertTrue((boolean)(item instanceof FcsTelemetry));
        FcsTelemetry item_ = (FcsTelemetry)item;
        Assert.assertEquals((double)linearencoder_LinearPosition, (double)item_.getLinearencoder_LinearPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)steppermotor_MotorEncoder, (double)item_.getSteppermotor_MotorEncoder(), (double)1.0E-6f);
        Assert.assertEquals((double)steppermotor_MotorTemperature, (double)item_.getSteppermotor_MotorTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveBonn_shutter_DeviceTelemetry() throws Exception {
        double bonn_V36 = 0.7742528319358826;
        double bonn_V5 = 0.5902373194694519;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Bonn_shutter_DeviceTelemetry(bonn_V36, bonn_V5));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_DeviceTelemetry));
        Bonn_shutter_DeviceTelemetry item_ = (Bonn_shutter_DeviceTelemetry)item;
        Assert.assertEquals((double)bonn_V36, (double)item_.getBonn_V36(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5, (double)item_.getBonn_V5(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Reb_TrendingTelemetry() throws Exception {
        long[] driver_errors = TestHelper.generateLongArray((int)3, (int)-1370705225);
        long[] driver_received = TestHelper.generateLongArray((int)3, (int)1440892806);
        long[] driver_rx0 = TestHelper.generateLongArray((int)3, (int)386865374);
        long[] driver_rx1 = TestHelper.generateLongArray((int)3, (int)-1269427024);
        long[] driver_rx2 = TestHelper.generateLongArray((int)3, (int)104904402);
        long[] driver_rx3 = TestHelper.generateLongArray((int)3, (int)-138898637);
        long[] firmware_cell_errors = TestHelper.generateLongArray((int)3, (int)-1811681082);
        long[] firmware_last_rx = TestHelper.generateLongArray((int)3, (int)-1415463780);
        long[] firmware_last_tx = TestHelper.generateLongArray((int)3, (int)399231864);
        long[] firmware_link_down = TestHelper.generateLongArray((int)3, (int)-627723039);
        long[] firmware_link_errors = TestHelper.generateLongArray((int)3, (int)-1486088851);
        long[] firmware_link_status = TestHelper.generateLongArray((int)3, (int)-2069271943);
        long[] firmware_overflow_local0 = TestHelper.generateLongArray((int)3, (int)959620261);
        long[] firmware_overflow_local1 = TestHelper.generateLongArray((int)3, (int)1995809808);
        long[] firmware_overflow_local2 = TestHelper.generateLongArray((int)3, (int)-1058622478);
        long[] firmware_overflow_local3 = TestHelper.generateLongArray((int)3, (int)2111581107);
        long[] firmware_overflow_remote0 = TestHelper.generateLongArray((int)3, (int)1120371541);
        long[] firmware_overflow_remote1 = TestHelper.generateLongArray((int)3, (int)1166187230);
        long[] firmware_overflow_remote2 = TestHelper.generateLongArray((int)3, (int)1010553104);
        long[] firmware_overflow_remote3 = TestHelper.generateLongArray((int)3, (int)-629903390);
        long[] firmware_rlink_data = TestHelper.generateLongArray((int)3, (int)-790553270);
        long[] firmware_rx_clock = TestHelper.generateLongArray((int)3, (int)1243602036);
        long[] firmware_rx_errors = TestHelper.generateLongArray((int)3, (int)-835780481);
        long[] firmware_rx_frames = TestHelper.generateLongArray((int)3, (int)1361311330);
        long[] firmware_rx_op = TestHelper.generateLongArray((int)3, (int)921812236);
        long[] firmware_tx_clock = TestHelper.generateLongArray((int)3, (int)1463152323);
        long[] firmware_tx_errors = TestHelper.generateLongArray((int)3, (int)-239358311);
        long[] firmware_tx_frames = TestHelper.generateLongArray((int)3, (int)-736591581);
        long[] firmware_tx_op = TestHelper.generateLongArray((int)3, (int)-1784553935);
        String location = "";
        long[] rds_bdi_firsts = TestHelper.generateLongArray((int)3, (int)1822023745);
        long[] rds_bdi_frees = TestHelper.generateLongArray((int)3, (int)-535273283);
        long[] rds_bdi_lasts = TestHelper.generateLongArray((int)3, (int)-1438529058);
        long[] rds_bdi_nulls = TestHelper.generateLongArray((int)3, (int)-1094235124);
        long[] rds_bdi_overflows = TestHelper.generateLongArray((int)3, (int)1450478848);
        long[] rds_bdi_seq_errors = TestHelper.generateLongArray((int)3, (int)-1261228602);
        long[] rds_bdi_waits = TestHelper.generateLongArray((int)3, (int)18478989);
        long[] rds_discards = TestHelper.generateLongArray((int)3, (int)-945678968);
        long[] rds_no_event = TestHelper.generateLongArray((int)3, (int)-114755728);
        long[] rds_wakes = TestHelper.generateLongArray((int)3, (int)-311147673);
        long[] rms_in_reset = TestHelper.generateLongArray((int)3, (int)-564513264);
        long[] rms_inv_tids = TestHelper.generateLongArray((int)3, (int)1508640487);
        long[] rms_link_down = TestHelper.generateLongArray((int)3, (int)-470243363);
        long[] rms_lists_posted = TestHelper.generateLongArray((int)3, (int)-615919827);
        long[] rms_ops_posted = TestHelper.generateLongArray((int)3, (int)1591992533);
        long[] rms_orphans = TestHelper.generateLongArray((int)3, (int)1985793845);
        long[] rms_probes = TestHelper.generateLongArray((int)3, (int)235793704);
        long[] rms_responses = TestHelper.generateLongArray((int)3, (int)-835941860);
        long[] rms_rundowns = TestHelper.generateLongArray((int)3, (int)1932240234);
        long[] rms_tid_hwm = TestHelper.generateLongArray((int)3, (int)2087325367);
        long[] rms_unopened = TestHelper.generateLongArray((int)3, (int)1884096494);
        long[] rms_waits = TestHelper.generateLongArray((int)3, (int)2088857353);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Reb_TrendingTelemetry(driver_errors, driver_received, driver_rx0, driver_rx1, driver_rx2, driver_rx3, firmware_cell_errors, firmware_last_rx, firmware_last_tx, firmware_link_down, firmware_link_errors, firmware_link_status, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_local3, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_overflow_remote3, firmware_rlink_data, firmware_rx_clock, firmware_rx_errors, firmware_rx_frames, firmware_rx_op, firmware_tx_clock, firmware_tx_errors, firmware_tx_frames, firmware_tx_op, location, rds_bdi_firsts, rds_bdi_frees, rds_bdi_lasts, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_bdi_waits, rds_discards, rds_no_event, rds_wakes, rms_in_reset, rms_inv_tids, rms_link_down, rms_lists_posted, rms_ops_posted, rms_orphans, rms_probes, rms_responses, rms_rundowns, rms_tid_hwm, rms_unopened, rms_waits));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Reb_TrendingTelemetry));
        Daq_monitor_Reb_TrendingTelemetry item_ = (Daq_monitor_Reb_TrendingTelemetry)item;
        Assert.assertArrayEquals((long[])driver_errors, (long[])item_.getDriver_errors());
        Assert.assertArrayEquals((long[])driver_received, (long[])item_.getDriver_received());
        Assert.assertArrayEquals((long[])driver_rx0, (long[])item_.getDriver_rx0());
        Assert.assertArrayEquals((long[])driver_rx1, (long[])item_.getDriver_rx1());
        Assert.assertArrayEquals((long[])driver_rx2, (long[])item_.getDriver_rx2());
        Assert.assertArrayEquals((long[])driver_rx3, (long[])item_.getDriver_rx3());
        Assert.assertArrayEquals((long[])firmware_cell_errors, (long[])item_.getFirmware_cell_errors());
        Assert.assertArrayEquals((long[])firmware_last_rx, (long[])item_.getFirmware_last_rx());
        Assert.assertArrayEquals((long[])firmware_last_tx, (long[])item_.getFirmware_last_tx());
        Assert.assertArrayEquals((long[])firmware_link_down, (long[])item_.getFirmware_link_down());
        Assert.assertArrayEquals((long[])firmware_link_errors, (long[])item_.getFirmware_link_errors());
        Assert.assertArrayEquals((long[])firmware_link_status, (long[])item_.getFirmware_link_status());
        Assert.assertArrayEquals((long[])firmware_overflow_local0, (long[])item_.getFirmware_overflow_local0());
        Assert.assertArrayEquals((long[])firmware_overflow_local1, (long[])item_.getFirmware_overflow_local1());
        Assert.assertArrayEquals((long[])firmware_overflow_local2, (long[])item_.getFirmware_overflow_local2());
        Assert.assertArrayEquals((long[])firmware_overflow_local3, (long[])item_.getFirmware_overflow_local3());
        Assert.assertArrayEquals((long[])firmware_overflow_remote0, (long[])item_.getFirmware_overflow_remote0());
        Assert.assertArrayEquals((long[])firmware_overflow_remote1, (long[])item_.getFirmware_overflow_remote1());
        Assert.assertArrayEquals((long[])firmware_overflow_remote2, (long[])item_.getFirmware_overflow_remote2());
        Assert.assertArrayEquals((long[])firmware_overflow_remote3, (long[])item_.getFirmware_overflow_remote3());
        Assert.assertArrayEquals((long[])firmware_rlink_data, (long[])item_.getFirmware_rlink_data());
        Assert.assertArrayEquals((long[])firmware_rx_clock, (long[])item_.getFirmware_rx_clock());
        Assert.assertArrayEquals((long[])firmware_rx_errors, (long[])item_.getFirmware_rx_errors());
        Assert.assertArrayEquals((long[])firmware_rx_frames, (long[])item_.getFirmware_rx_frames());
        Assert.assertArrayEquals((long[])firmware_rx_op, (long[])item_.getFirmware_rx_op());
        Assert.assertArrayEquals((long[])firmware_tx_clock, (long[])item_.getFirmware_tx_clock());
        Assert.assertArrayEquals((long[])firmware_tx_errors, (long[])item_.getFirmware_tx_errors());
        Assert.assertArrayEquals((long[])firmware_tx_frames, (long[])item_.getFirmware_tx_frames());
        Assert.assertArrayEquals((long[])firmware_tx_op, (long[])item_.getFirmware_tx_op());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])rds_bdi_firsts, (long[])item_.getRds_bdi_firsts());
        Assert.assertArrayEquals((long[])rds_bdi_frees, (long[])item_.getRds_bdi_frees());
        Assert.assertArrayEquals((long[])rds_bdi_lasts, (long[])item_.getRds_bdi_lasts());
        Assert.assertArrayEquals((long[])rds_bdi_nulls, (long[])item_.getRds_bdi_nulls());
        Assert.assertArrayEquals((long[])rds_bdi_overflows, (long[])item_.getRds_bdi_overflows());
        Assert.assertArrayEquals((long[])rds_bdi_seq_errors, (long[])item_.getRds_bdi_seq_errors());
        Assert.assertArrayEquals((long[])rds_bdi_waits, (long[])item_.getRds_bdi_waits());
        Assert.assertArrayEquals((long[])rds_discards, (long[])item_.getRds_discards());
        Assert.assertArrayEquals((long[])rds_no_event, (long[])item_.getRds_no_event());
        Assert.assertArrayEquals((long[])rds_wakes, (long[])item_.getRds_wakes());
        Assert.assertArrayEquals((long[])rms_in_reset, (long[])item_.getRms_in_reset());
        Assert.assertArrayEquals((long[])rms_inv_tids, (long[])item_.getRms_inv_tids());
        Assert.assertArrayEquals((long[])rms_link_down, (long[])item_.getRms_link_down());
        Assert.assertArrayEquals((long[])rms_lists_posted, (long[])item_.getRms_lists_posted());
        Assert.assertArrayEquals((long[])rms_ops_posted, (long[])item_.getRms_ops_posted());
        Assert.assertArrayEquals((long[])rms_orphans, (long[])item_.getRms_orphans());
        Assert.assertArrayEquals((long[])rms_probes, (long[])item_.getRms_probes());
        Assert.assertArrayEquals((long[])rms_responses, (long[])item_.getRms_responses());
        Assert.assertArrayEquals((long[])rms_rundowns, (long[])item_.getRms_rundowns());
        Assert.assertArrayEquals((long[])rms_tid_hwm, (long[])item_.getRms_tid_hwm());
        Assert.assertArrayEquals((long[])rms_unopened, (long[])item_.getRms_unopened());
        Assert.assertArrayEquals((long[])rms_waits, (long[])item_.getRms_waits());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.6218813061714172;
        double freeFraction = 0.32657474279403687;
        double freeSpace = 0.005529582500457764;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeFraction, freeSpace));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Sum_TrendingTelemetry() throws Exception {
        long driver_errors = 212L;
        long firmware_cell_errors = 429L;
        long firmware_link_down = 825L;
        long firmware_link_errors = 563L;
        long firmware_overflow_local0 = 202L;
        long firmware_overflow_local1 = 460L;
        long firmware_overflow_local2 = 281L;
        long firmware_overflow_remote0 = 92L;
        long firmware_overflow_remote1 = 135L;
        long firmware_overflow_remote2 = 473L;
        long firmware_rx_errors = 97L;
        long firmware_tx_errors = 190L;
        long rds_bdi_nulls = 796L;
        long rds_bdi_overflows = 635L;
        long rds_bdi_seq_errors = 397L;
        long rds_discards = 199L;
        long rds_no_event = 42L;
        long rms_in_reset = 411L;
        long rms_inv_tids = 4L;
        long rms_link_down = 557L;
        long rms_orphans = 851L;
        long rms_unopened = 418L;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_Sum_TrendingTelemetry(driver_errors, firmware_cell_errors, firmware_link_down, firmware_link_errors, firmware_overflow_local0, firmware_overflow_local1, firmware_overflow_local2, firmware_overflow_remote0, firmware_overflow_remote1, firmware_overflow_remote2, firmware_rx_errors, firmware_tx_errors, rds_bdi_nulls, rds_bdi_overflows, rds_bdi_seq_errors, rds_discards, rds_no_event, rms_in_reset, rms_inv_tids, rms_link_down, rms_orphans, rms_unopened));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Sum_TrendingTelemetry));
        Daq_monitor_Sum_TrendingTelemetry item_ = (Daq_monitor_Sum_TrendingTelemetry)item;
        Assert.assertEquals((long)driver_errors, (long)item_.getDriver_errors());
        Assert.assertEquals((long)firmware_cell_errors, (long)item_.getFirmware_cell_errors());
        Assert.assertEquals((long)firmware_link_down, (long)item_.getFirmware_link_down());
        Assert.assertEquals((long)firmware_link_errors, (long)item_.getFirmware_link_errors());
        Assert.assertEquals((long)firmware_overflow_local0, (long)item_.getFirmware_overflow_local0());
        Assert.assertEquals((long)firmware_overflow_local1, (long)item_.getFirmware_overflow_local1());
        Assert.assertEquals((long)firmware_overflow_local2, (long)item_.getFirmware_overflow_local2());
        Assert.assertEquals((long)firmware_overflow_remote0, (long)item_.getFirmware_overflow_remote0());
        Assert.assertEquals((long)firmware_overflow_remote1, (long)item_.getFirmware_overflow_remote1());
        Assert.assertEquals((long)firmware_overflow_remote2, (long)item_.getFirmware_overflow_remote2());
        Assert.assertEquals((long)firmware_rx_errors, (long)item_.getFirmware_rx_errors());
        Assert.assertEquals((long)firmware_tx_errors, (long)item_.getFirmware_tx_errors());
        Assert.assertEquals((long)rds_bdi_nulls, (long)item_.getRds_bdi_nulls());
        Assert.assertEquals((long)rds_bdi_overflows, (long)item_.getRds_bdi_overflows());
        Assert.assertEquals((long)rds_bdi_seq_errors, (long)item_.getRds_bdi_seq_errors());
        Assert.assertEquals((long)rds_discards, (long)item_.getRds_discards());
        Assert.assertEquals((long)rds_no_event, (long)item_.getRds_no_event());
        Assert.assertEquals((long)rms_in_reset, (long)item_.getRms_in_reset());
        Assert.assertEquals((long)rms_inv_tids, (long)item_.getRms_inv_tids());
        Assert.assertEquals((long)rms_link_down, (long)item_.getRms_link_down());
        Assert.assertEquals((long)rms_orphans, (long)item_.getRms_orphans());
        Assert.assertEquals((long)rms_unopened, (long)item_.getRms_unopened());
    }

    @Test
    public void sendReceiveRebpower_RebTelemetry() throws Exception {
        double[] analog_IaftLDO = TestHelper.generateDoubleArray((int)3, (int)-313031295);
        double[] analog_IbefLDO = TestHelper.generateDoubleArray((int)3, (int)-734788411);
        double[] analog_VaftLDO = TestHelper.generateDoubleArray((int)3, (int)1715371921);
        double[] analog_VaftSwch = TestHelper.generateDoubleArray((int)3, (int)-1132527312);
        double[] analog_VbefLDO = TestHelper.generateDoubleArray((int)3, (int)1243408212);
        double[] clockhi_IaftLDO = TestHelper.generateDoubleArray((int)3, (int)1482937101);
        double[] clockhi_IbefLDO = TestHelper.generateDoubleArray((int)3, (int)1637378209);
        double[] clockhi_VaftLDO = TestHelper.generateDoubleArray((int)3, (int)-995072274);
        double[] clockhi_VaftSwch = TestHelper.generateDoubleArray((int)3, (int)575868291);
        double[] clockhi_VbefLDO = TestHelper.generateDoubleArray((int)3, (int)1910830590);
        double[] clocklo_IaftLDO = TestHelper.generateDoubleArray((int)3, (int)1741888789);
        double[] clocklo_IbefLDO = TestHelper.generateDoubleArray((int)3, (int)-1961985236);
        double[] clocklo_VaftLDO = TestHelper.generateDoubleArray((int)3, (int)-1791099442);
        double[] clocklo_VaftLDO2 = TestHelper.generateDoubleArray((int)3, (int)963690295);
        double[] clocklo_VaftSwch = TestHelper.generateDoubleArray((int)3, (int)-2086529840);
        double[] clocklo_VbefLDO = TestHelper.generateDoubleArray((int)3, (int)395930211);
        double[] digital_IaftLDO = TestHelper.generateDoubleArray((int)3, (int)-1347925263);
        double[] digital_IbefLDO = TestHelper.generateDoubleArray((int)3, (int)1780459804);
        double[] digital_VaftLDO = TestHelper.generateDoubleArray((int)3, (int)589447584);
        double[] digital_VaftSwch = TestHelper.generateDoubleArray((int)3, (int)1917376732);
        double[] digital_VbefLDO = TestHelper.generateDoubleArray((int)3, (int)467313873);
        double[] heater_IaftLDO = TestHelper.generateDoubleArray((int)3, (int)-1051691778);
        double[] heater_IbefLDO = TestHelper.generateDoubleArray((int)3, (int)-1819919217);
        double[] heater_VaftLDO = TestHelper.generateDoubleArray((int)3, (int)-1652250763);
        double[] heater_VaftSwch = TestHelper.generateDoubleArray((int)3, (int)-1535133711);
        double[] heater_VbefLDO = TestHelper.generateDoubleArray((int)3, (int)190875513);
        double[] hvbias_IbefSwch = TestHelper.generateDoubleArray((int)3, (int)-221809543);
        double[] hvbias_VbefSwch = TestHelper.generateDoubleArray((int)3, (int)-153173852);
        String location = "a";
        double[] od_IaftLDO = TestHelper.generateDoubleArray((int)3, (int)-903663138);
        double[] od_IbefLDO = TestHelper.generateDoubleArray((int)3, (int)-1355927108);
        double[] od_VaftLDO = TestHelper.generateDoubleArray((int)3, (int)2140730011);
        double[] od_VaftLDO2 = TestHelper.generateDoubleArray((int)3, (int)-1363443376);
        double[] od_VaftSwch = TestHelper.generateDoubleArray((int)3, (int)-381451271);
        double[] od_VbefLDO = TestHelper.generateDoubleArray((int)3, (int)-965995409);
        double[] power = TestHelper.generateDoubleArray((int)3, (int)-1550556451);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTelemetry(analog_IaftLDO, analog_IbefLDO, analog_VaftLDO, analog_VaftSwch, analog_VbefLDO, clockhi_IaftLDO, clockhi_IbefLDO, clockhi_VaftLDO, clockhi_VaftSwch, clockhi_VbefLDO, clocklo_IaftLDO, clocklo_IbefLDO, clocklo_VaftLDO, clocklo_VaftLDO2, clocklo_VaftSwch, clocklo_VbefLDO, digital_IaftLDO, digital_IbefLDO, digital_VaftLDO, digital_VaftSwch, digital_VbefLDO, heater_IaftLDO, heater_IbefLDO, heater_VaftLDO, heater_VaftSwch, heater_VbefLDO, hvbias_IbefSwch, hvbias_VbefSwch, location, od_IaftLDO, od_IbefLDO, od_VaftLDO, od_VaftLDO2, od_VaftSwch, od_VbefLDO, power));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTelemetry));
        Rebpower_RebTelemetry item_ = (Rebpower_RebTelemetry)item;
        Assert.assertArrayEquals((double[])analog_IaftLDO, (double[])item_.getAnalog_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO, (double[])item_.getAnalog_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO, (double[])item_.getAnalog_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch, (double[])item_.getAnalog_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO, (double[])item_.getAnalog_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO, (double[])item_.getClockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO, (double[])item_.getClockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO, (double[])item_.getClockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch, (double[])item_.getClockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO, (double[])item_.getClockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO, (double[])item_.getClocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO, (double[])item_.getClocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO, (double[])item_.getClocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2, (double[])item_.getClocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch, (double[])item_.getClocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO, (double[])item_.getClocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO, (double[])item_.getDigital_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO, (double[])item_.getDigital_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO, (double[])item_.getDigital_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch, (double[])item_.getDigital_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO, (double[])item_.getDigital_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO, (double[])item_.getHeater_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO, (double[])item_.getHeater_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO, (double[])item_.getHeater_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch, (double[])item_.getHeater_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO, (double[])item_.getHeater_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch, (double[])item_.getHvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch, (double[])item_.getHvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO, (double[])item_.getOd_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO, (double[])item_.getOd_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO, (double[])item_.getOd_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2, (double[])item_.getOd_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch, (double[])item_.getOd_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO, (double[])item_.getOd_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebpsTelemetry() throws Exception {
        double[] boardTemp0 = TestHelper.generateDoubleArray((int)1, (int)760715634);
        double[] boardTemp1 = TestHelper.generateDoubleArray((int)1, (int)794913553);
        double[] boardTemp2 = TestHelper.generateDoubleArray((int)1, (int)1052183699);
        double[] boardTemp3 = TestHelper.generateDoubleArray((int)1, (int)-1077426309);
        double[] boardTemp4 = TestHelper.generateDoubleArray((int)1, (int)1116243522);
        double[] boardTemp5 = TestHelper.generateDoubleArray((int)1, (int)-424750066);
        double[] boardTemp6 = TestHelper.generateDoubleArray((int)1, (int)-2065015255);
        double[] fPGATemp = TestHelper.generateDoubleArray((int)1, (int)355852705);
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebpsTelemetry(boardTemp0, boardTemp1, boardTemp2, boardTemp3, boardTemp4, boardTemp5, boardTemp6, fPGATemp, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebpsTelemetry));
        Rebpower_RebpsTelemetry item_ = (Rebpower_RebpsTelemetry)item;
        Assert.assertArrayEquals((double[])boardTemp0, (double[])item_.getBoardTemp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp1, (double[])item_.getBoardTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp2, (double[])item_.getBoardTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp3, (double[])item_.getBoardTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp4, (double[])item_.getBoardTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp5, (double[])item_.getBoardTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp6, (double[])item_.getBoardTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fPGATemp, (double[])item_.getFPGATemp(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_Cold1Telemetry() throws Exception {
        double autoOffEnabled = 0.2037997841835022;
        double autoOffTemperature = 0.09573167562484741;
        double autoOnTemperature = 0.1956794261932373;
        double power = 0.20298081636428833;
        double rejectTemperature = 0.9842374324798584;
        double setPower = 0.5325362682342529;
        double setpoint = 0.48837214708328247;
        double temperature = 0.5973848104476929;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Cold1Telemetry(autoOffEnabled, autoOffTemperature, autoOnTemperature, power, rejectTemperature, setPower, setpoint, temperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold1Telemetry));
        Vacuum_Cold1Telemetry item_ = (Vacuum_Cold1Telemetry)item;
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold2Telemetry() throws Exception {
        double autoOffEnabled = 0.8959168791770935;
        double autoOffTemperature = 0.9150654673576355;
        double autoOnTemperature = 0.3657575249671936;
        double power = 0.5928830504417419;
        double rejectTemperature = 0.8896746635437012;
        double setPower = 0.06854617595672607;
        double setpoint = 0.058166325092315674;
        double temperature = 0.22311514616012573;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Cold2Telemetry(autoOffEnabled, autoOffTemperature, autoOnTemperature, power, rejectTemperature, setPower, setpoint, temperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold2Telemetry));
        Vacuum_Cold2Telemetry item_ = (Vacuum_Cold2Telemetry)item;
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoTelemetry() throws Exception {
        double autoOffEnabled = 0.653375f;
        double autoOffTemperature = 0.24384957551956177;
        double autoOnTemperature = 0.6420167684555054;
        double power = 0.4715088f;
        double rejectTemperature = 0.5090200304985046;
        double setPower = 0.6322002410888672;
        double setpoint = 0.5558463931083679;
        double temperature = 0.1021713f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoTelemetry(autoOffEnabled, autoOffTemperature, autoOnTemperature, power, rejectTemperature, setPower, setpoint, temperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTelemetry));
        Vacuum_CryoTelemetry item_ = (Vacuum_CryoTelemetry)item;
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_IonPumpsTelemetry() throws Exception {
        double current = 0.902158260345459;
        double voltage = 0.4317305088043213;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_IonPumpsTelemetry(current, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumpsTelemetry));
        Vacuum_IonPumpsTelemetry item_ = (Vacuum_IonPumpsTelemetry)item;
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_RtdsTelemetry() throws Exception {
        double temperatureCold1 = 0.5601807236671448;
        double temperatureCold2 = 0.7510571479797363;
        double temperatureCryo = 0.43343013525009155;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_RtdsTelemetry(temperatureCold1, temperatureCold2, temperatureCryo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_RtdsTelemetry));
        Vacuum_RtdsTelemetry item_ = (Vacuum_RtdsTelemetry)item;
        Assert.assertEquals((double)temperatureCold1, (double)item_.getTemperatureCold1(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatureCold2, (double)item_.getTemperatureCold2(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatureCryo, (double)item_.getTemperatureCryo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboTelemetry() throws Exception {
        double cntrlrAirTemperature = 0.8926216959953308;
        double cntrlrSinkTemperature = 0.9593026041984558;
        double current = 0.04695213f;
        double driveFrequency = 0.07528221607208252;
        double power = 0.6676658987998962;
        double pumpTemperature = 0.2685765027999878;
        double rpm = 0.26970362663269043;
        double status = 0.5119476318359375;
        double voltage = 0.2674948573112488;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboTelemetry(cntrlrAirTemperature, cntrlrSinkTemperature, current, driveFrequency, power, pumpTemperature, rpm, status, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboTelemetry));
        Vacuum_TurboTelemetry item_ = (Vacuum_TurboTelemetry)item;
        Assert.assertEquals((double)cntrlrAirTemperature, (double)item_.getCntrlrAirTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrSinkTemperature, (double)item_.getCntrlrSinkTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)driveFrequency, (double)item_.getDriveFrequency(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpTemperature, (double)item_.getPumpTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)rpm, (double)item_.getRpm(), (double)1.0E-6f);
        Assert.assertEquals((double)status, (double)item_.getStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_VQMonitorTelemetry() throws Exception {
        double vqmpressure = 0.853928f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_VQMonitorTelemetry(vqmpressure));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VQMonitorTelemetry));
        Vacuum_VQMonitorTelemetry item_ = (Vacuum_VQMonitorTelemetry)item;
        Assert.assertEquals((double)vqmpressure, (double)item_.getVqmpressure(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double clean_5_24V_I = 0.041564106941223145;
        double dirty_24V_I = 0.4894769787788391;
        double dirty_28V_I = 0.6060689091682434;
        double dirty_48V_I = 0.32494717836380005;
        double heater_I = 0.1546655297279358;
        double protection_I = 0.2948017716407776;
        double rebps_0 = 0.6795167922973633;
        double sensor_PWS_17_I = 0.2675807476043701;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(clean_5_24V_I, dirty_24V_I, dirty_28V_I, dirty_48V_I, heater_I, protection_I, rebps_0, sensor_PWS_17_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I, (double)item_.getHeater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0, (double)item_.getRebps_0(), (double)1.0E-6f);
        Assert.assertEquals((double)sensor_PWS_17_I, (double)item_.getSensor_PWS_17_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double board_T = 0.872297f;
        double body_Purge_I = 0.4565240740776062;
        double body_Purge_V = 0.7729224562644958;
        double bpu_Maq20_I = 0.8473111987113953;
        double bpu_Maq20_V = 0.8032259345054626;
        double fpga_T = 0.011489689350128174;
        double fes_Shu_HCU_I = 0.1736438274383545;
        double fes_Shu_HCU_V = 0.6930426955223083;
        double gauges_I = 0.7768311500549316;
        double gauges_V = 0.07446908950805664;
        double ion_Pumps_I = 0.8903203010559082;
        double ion_Pumps_V = 0.5326936841011047;
        double j11_I = 0.4729587435722351;
        double j11_V = 0.4258297085762024;
        double j12_I = 0.053610384464263916;
        double j12_V = 0.2439296841621399;
        double j6_I = 0.9554680585861206;
        double j6_V = 0.664438009262085;
        double j7_I = 0.49324584007263184;
        double j7_V = 0.21087270975112915;
        double j8_I = 0.6843093633651733;
        double j8_V = 0.5088151097297668;
        double j9_I = 0.9471758008003235;
        double j9_V = 0.24645012617111206;
        double main_I = 0.14021533727645874;
        double main_T = 0.7455449104309082;
        double main_V = 0.7289993166923523;
        double pwr_Cry_HCU_I = 0.4098575711250305;
        double pwr_Cry_HCU_V = 0.3818510174751282;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(board_T, body_Purge_I, body_Purge_V, bpu_Maq20_I, bpu_Maq20_V, fpga_T, fes_Shu_HCU_I, fes_Shu_HCU_V, gauges_I, gauges_V, ion_Pumps_I, ion_Pumps_V, j11_I, j11_V, j12_I, j12_V, j6_I, j6_V, j7_I, j7_V, j8_I, j8_V, j9_I, j9_V, main_I, main_T, main_V, pwr_Cry_HCU_I, pwr_Cry_HCU_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I, (double)item_.getBody_Purge_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V, (double)item_.getBody_Purge_V(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I, (double)item_.getBpu_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V, (double)item_.getBpu_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I, (double)item_.getFes_Shu_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V, (double)item_.getFes_Shu_HCU_V(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_I, (double)item_.getJ11_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_V, (double)item_.getJ11_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_I, (double)item_.getJ12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_V, (double)item_.getJ12_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_I, (double)item_.getJ6_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_V, (double)item_.getJ6_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_I, (double)item_.getJ7_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_V, (double)item_.getJ7_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j8_I, (double)item_.getJ8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j8_V, (double)item_.getJ8_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_I, (double)item_.getJ9_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_V, (double)item_.getJ9_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I, (double)item_.getPwr_Cry_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V, (double)item_.getPwr_Cry_HCU_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double board_T = 0.3749760389328003;
        double fes_I = 0.7417784333229065;
        double fes_V = 0.0821070671081543;
        double fpga_T = 0.8013471364974976;
        double main_I = 0.773384f;
        double main_T = 0.02753680944442749;
        double main_V = 0.8756334185600281;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(board_T, fes_I, fes_V, fpga_T, main_I, main_T, main_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_I, (double)item_.getFes_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_V, (double)item_.getFes_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double board_T = 0.07495027780532837;
        double cryotel0_I = 0.33909255266189575;
        double cryotel0_V = 0.6457557678222656;
        double cryotel1_I = 0.7653827667236328;
        double cryotel1_V = 0.9860984086990356;
        double cryotel2_I = 0.6068593859672546;
        double cryotel2_V = 0.4100852f;
        double fpga_T = 0.11077779531478882;
        double main_I = 0.9842397570610046;
        double main_T = 0.2674836f;
        double main_V = 0.725014f;
        double reb_BULK_I = 0.5656404495239258;
        double reb_BULK_V = 0.23044276237487793;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(board_T, cryotel0_I, cryotel0_V, cryotel1_I, cryotel1_V, cryotel2_I, cryotel2_V, fpga_T, main_I, main_T, main_V, reb_BULK_I, reb_BULK_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_I, (double)item_.getCryotel0_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_V, (double)item_.getCryotel0_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_I, (double)item_.getCryotel1_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_V, (double)item_.getCryotel1_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_I, (double)item_.getCryotel2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_V, (double)item_.getCryotel2_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_I, (double)item_.getReb_BULK_I(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_V, (double)item_.getReb_BULK_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_3_A_I = 0.8136123418807983;
        double otm_3_A_V = 0.5637492537498474;
        double otm_3_B_I = 0.7748758792877197;
        double otm_3_B_V = 0.5572089552879333;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_3_A_I, otm_3_A_V, otm_3_B_I, otm_3_B_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_3_A_I, (double)item_.getOtm_3_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V, (double)item_.getOtm_3_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I, (double)item_.getOtm_3_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V, (double)item_.getOtm_3_B_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_CcdTelemetry() throws Exception {
        double[] gDV = TestHelper.generateDoubleArray((int)9, (int)-1624663169);
        String location = "";
        double[] oDV = TestHelper.generateDoubleArray((int)9, (int)-154950248);
        double[] oGV = TestHelper.generateDoubleArray((int)9, (int)1986165958);
        double[] rDV = TestHelper.generateDoubleArray((int)9, (int)2044675061);
        double[] temp = TestHelper.generateDoubleArray((int)9, (int)1938871534);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_CcdTelemetry(gDV, location, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_CcdTelemetry));
        Focal_plane_CcdTelemetry item_ = (Focal_plane_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTelemetry() throws Exception {
        double[] anaI = TestHelper.generateDoubleArray((int)3, (int)963062301);
        double[] anaV = TestHelper.generateDoubleArray((int)3, (int)-1785030333);
        double[] aspicl_Temp0 = TestHelper.generateDoubleArray((int)3, (int)-1191579156);
        double[] aspicl_Temp1 = TestHelper.generateDoubleArray((int)3, (int)-115466941);
        double[] aspicl_Temp2 = TestHelper.generateDoubleArray((int)3, (int)1602122726);
        double[] aspicu_Temp0 = TestHelper.generateDoubleArray((int)3, (int)1393427458);
        double[] aspicu_Temp1 = TestHelper.generateDoubleArray((int)3, (int)507207629);
        double[] aspicu_Temp2 = TestHelper.generateDoubleArray((int)3, (int)640869772);
        double[] clkHI = TestHelper.generateDoubleArray((int)3, (int)-1893298119);
        double[] clkHV = TestHelper.generateDoubleArray((int)3, (int)-1945496720);
        double[] clkLI = TestHelper.generateDoubleArray((int)3, (int)-868334277);
        double[] clkLV = TestHelper.generateDoubleArray((int)3, (int)-227710011);
        double[] digI = TestHelper.generateDoubleArray((int)3, (int)1473815896);
        double[] digV = TestHelper.generateDoubleArray((int)3, (int)-509379467);
        double[] hVBiasSwitch = TestHelper.generateDoubleArray((int)3, (int)-1131058845);
        double[] htrV = TestHelper.generateDoubleArray((int)3, (int)-826641267);
        double[] htrW = TestHelper.generateDoubleArray((int)3, (int)1264566005);
        String location = "g";
        double[] oDI = TestHelper.generateDoubleArray((int)3, (int)-1674598103);
        double[] oDV = TestHelper.generateDoubleArray((int)3, (int)1828351460);
        double[] pClkL = TestHelper.generateDoubleArray((int)3, (int)1091312099);
        double[] pClkU = TestHelper.generateDoubleArray((int)3, (int)-1318169826);
        double[] power = TestHelper.generateDoubleArray((int)3, (int)505369038);
        double[] rGL = TestHelper.generateDoubleArray((int)3, (int)734670610);
        double[] rGU = TestHelper.generateDoubleArray((int)3, (int)1365712962);
        double[] rTDTemp = TestHelper.generateDoubleArray((int)3, (int)-29473979);
        double[] ref05V = TestHelper.generateDoubleArray((int)3, (int)2134306847);
        double[] ref125V = TestHelper.generateDoubleArray((int)3, (int)2036190645);
        double[] ref15V = TestHelper.generateDoubleArray((int)3, (int)1366014513);
        double[] ref25V = TestHelper.generateDoubleArray((int)3, (int)1699600569);
        double[] refN12 = TestHelper.generateDoubleArray((int)3, (int)1854832116);
        double[] refP12 = TestHelper.generateDoubleArray((int)3, (int)-1337772860);
        double[] sClkL = TestHelper.generateDoubleArray((int)3, (int)-395620651);
        double[] sClkU = TestHelper.generateDoubleArray((int)3, (int)2080084760);
        double[] temp1 = TestHelper.generateDoubleArray((int)3, (int)-1683598244);
        double[] temp10 = TestHelper.generateDoubleArray((int)3, (int)-329227350);
        double[] temp2 = TestHelper.generateDoubleArray((int)3, (int)1045857769);
        double[] temp3 = TestHelper.generateDoubleArray((int)3, (int)1238029765);
        double[] temp4 = TestHelper.generateDoubleArray((int)3, (int)-1146224923);
        double[] temp5 = TestHelper.generateDoubleArray((int)3, (int)-1499825611);
        double[] temp6 = TestHelper.generateDoubleArray((int)3, (int)-209021284);
        double[] temp7 = TestHelper.generateDoubleArray((int)3, (int)-1310763269);
        double[] temp8 = TestHelper.generateDoubleArray((int)3, (int)391020314);
        double[] temp9 = TestHelper.generateDoubleArray((int)3, (int)-2108878892);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicl_Temp1, aspicl_Temp2, aspicu_Temp0, aspicu_Temp1, aspicu_Temp2, clkHI, clkHV, clkLI, clkLV, digI, digV, hVBiasSwitch, htrV, htrW, location, oDI, oDV, pClkL, pClkU, power, rGL, rGU, rTDTemp, ref05V, ref125V, ref15V, ref25V, refN12, refP12, sClkL, sClkU, temp1, temp10, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTelemetry));
        Focal_plane_RebTelemetry item_ = (Focal_plane_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1, (double[])item_.getAspicl_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2, (double[])item_.getAspicl_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1, (double[])item_.getAspicu_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2, (double[])item_.getAspicu_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLI, (double[])item_.getClkLI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05V, (double[])item_.getRef05V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125V, (double[])item_.getRef125V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15V, (double[])item_.getRef15V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25V, (double[])item_.getRef25V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refN12, (double[])item_.getRefN12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refP12, (double[])item_.getRefP12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10, (double[])item_.getTemp10(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7, (double[])item_.getTemp7(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8, (double[])item_.getTemp8(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9, (double[])item_.getTemp9(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.3160724639892578;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPowerTelemetry));
        Focal_plane_RebTotalPowerTelemetry item_ = (Focal_plane_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebsAverageTemp6Telemetry() throws Exception {
        double rebsAverageTemp6 = 0.6478259563446045;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebsAverageTemp6Telemetry(rebsAverageTemp6));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebsAverageTemp6Telemetry));
        Focal_plane_RebsAverageTemp6Telemetry item_ = (Focal_plane_RebsAverageTemp6Telemetry)item;
        Assert.assertEquals((double)rebsAverageTemp6, (double)item_.getRebsAverageTemp6(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_SegmentTelemetry() throws Exception {
        double[] i = TestHelper.generateDoubleArray((int)144, (int)-86588340);
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_SegmentTelemetry(i, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SegmentTelemetry));
        Focal_plane_SegmentTelemetry item_ = (Focal_plane_SegmentTelemetry)item;
        Assert.assertArrayEquals((double[])i, (double[])item_.getI(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }
}

