package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class Fcs_GeneralConfigurationEvent extends CameraEvent {
  private final String version;

  private final String filterNames;

  private final String filterTypes;

  private final String nameFilter1;

  private final String nameFilter2;

  private final String nameFilter3;

  private final int positionFilter1;

  private final int positionFilter2;

  private final int positionFilter3;

  private final int positionLoad1;

  private final int positionLoad3;

  private final double tolerance;

  public Fcs_GeneralConfigurationEvent(String version, String filterNames, String filterTypes,
      String nameFilter1, String nameFilter2, String nameFilter3, int positionFilter1,
      int positionFilter2, int positionFilter3, int positionLoad1, int positionLoad3,
      double tolerance) {
    this.version = version;
    this.filterNames = filterNames;
    this.filterTypes = filterTypes;
    this.nameFilter1 = nameFilter1;
    this.nameFilter2 = nameFilter2;
    this.nameFilter3 = nameFilter3;
    this.positionFilter1 = positionFilter1;
    this.positionFilter2 = positionFilter2;
    this.positionFilter3 = positionFilter3;
    this.positionLoad1 = positionLoad1;
    this.positionLoad3 = positionLoad3;
    this.tolerance = tolerance;
  }

  public String getVersion() {
    return version;
  }

  public String getFilterNames() {
    return filterNames;
  }

  public String getFilterTypes() {
    return filterTypes;
  }

  public String getNameFilter1() {
    return nameFilter1;
  }

  public String getNameFilter2() {
    return nameFilter2;
  }

  public String getNameFilter3() {
    return nameFilter3;
  }

  public int getPositionFilter1() {
    return positionFilter1;
  }

  public int getPositionFilter2() {
    return positionFilter2;
  }

  public int getPositionFilter3() {
    return positionFilter3;
  }

  public int getPositionLoad1() {
    return positionLoad1;
  }

  public int getPositionLoad3() {
    return positionLoad3;
  }

  public double getTolerance() {
    return tolerance;
  }

  @Override
  public String toString() {
    return "Fcs_GeneralConfigurationEvent{" + "version=" + version +", filterNames=" + filterNames +
        ", filterTypes=" + filterTypes +", nameFilter1=" + nameFilter1 +
        ", nameFilter2=" + nameFilter2 +", nameFilter3=" + nameFilter3 +
        ", positionFilter1=" + positionFilter1 +", positionFilter2=" + positionFilter2 +
        ", positionFilter3=" + positionFilter3 +", positionLoad1=" + positionLoad1 +
        ", positionLoad3=" + positionLoad3 +", tolerance=" + tolerance +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private String version;

    private String filterNames;

    private String filterTypes;

    private String nameFilter1;

    private String nameFilter2;

    private String nameFilter3;

    private int positionFilter1;

    private int positionFilter2;

    private int positionFilter3;

    private int positionLoad1;

    private int positionLoad3;

    private double tolerance;

    private Builder() {
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder filterNames(String filterNames) {
      this.filterNames = filterNames;
      return this;
    }

    public Builder filterTypes(String filterTypes) {
      this.filterTypes = filterTypes;
      return this;
    }

    public Builder nameFilter1(String nameFilter1) {
      this.nameFilter1 = nameFilter1;
      return this;
    }

    public Builder nameFilter2(String nameFilter2) {
      this.nameFilter2 = nameFilter2;
      return this;
    }

    public Builder nameFilter3(String nameFilter3) {
      this.nameFilter3 = nameFilter3;
      return this;
    }

    public Builder positionFilter1(int positionFilter1) {
      this.positionFilter1 = positionFilter1;
      return this;
    }

    public Builder positionFilter2(int positionFilter2) {
      this.positionFilter2 = positionFilter2;
      return this;
    }

    public Builder positionFilter3(int positionFilter3) {
      this.positionFilter3 = positionFilter3;
      return this;
    }

    public Builder positionLoad1(int positionLoad1) {
      this.positionLoad1 = positionLoad1;
      return this;
    }

    public Builder positionLoad3(int positionLoad3) {
      this.positionLoad3 = positionLoad3;
      return this;
    }

    public Builder tolerance(double tolerance) {
      this.tolerance = tolerance;
      return this;
    }

    public Fcs_GeneralConfigurationEvent build() {
      return new Fcs_GeneralConfigurationEvent(version, filterNames, filterTypes, nameFilter1, nameFilter2, nameFilter3, positionFilter1, positionFilter2, positionFilter3, positionLoad1, positionLoad3, tolerance);
    }
  }
}
