/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.cccamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry;
import org.lsst.sal.cccamera.CCCamera;
import org.lsst.sal.cccamera.telemetry.Bonn_shutter_DeviceTelemetry;
import org.lsst.sal.cccamera.telemetry.FcsTelemetry;
import org.lsst.sal.cccamera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.cccamera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_RebTelemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_RebpsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold1Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold2Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_IonPumpsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_RtdsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_TurboTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_VQMonitorTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = CCCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveFcsTelemetry() throws Exception {
        double linearencoder_LinearPosition = 0.7878716588020325;
        double steppermotor_MotorEncoder = 0.6480438709259033;
        double steppermotor_MotorTemperature = 0.4282214641571045;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new FcsTelemetry(linearencoder_LinearPosition, steppermotor_MotorEncoder, steppermotor_MotorTemperature));
        Assert.assertTrue((boolean)(item instanceof FcsTelemetry));
        FcsTelemetry item_ = (FcsTelemetry)item;
        Assert.assertEquals((double)linearencoder_LinearPosition, (double)item_.getLinearencoder_LinearPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)steppermotor_MotorEncoder, (double)item_.getSteppermotor_MotorEncoder(), (double)1.0E-6f);
        Assert.assertEquals((double)steppermotor_MotorTemperature, (double)item_.getSteppermotor_MotorTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveBonn_shutter_DeviceTelemetry() throws Exception {
        double bonn_V36 = 0.2704923152923584;
        double bonn_V5 = 0.8609157204627991;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Bonn_shutter_DeviceTelemetry(bonn_V36, bonn_V5));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_DeviceTelemetry));
        Bonn_shutter_DeviceTelemetry item_ = (Bonn_shutter_DeviceTelemetry)item;
        Assert.assertEquals((double)bonn_V36, (double)item_.getBonn_V36(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5, (double)item_.getBonn_V5(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.08427679538726807;
        double freeFraction = 0.2948005199432373;
        double freeSpace = 0.9217108488082886;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeFraction, freeSpace));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTelemetry() throws Exception {
        double[] analog_IaftLDO = TestHelper.generateDoubleArray((int)3, (int)-1916801175);
        double[] analog_IbefLDO = TestHelper.generateDoubleArray((int)3, (int)-1776498061);
        double[] analog_VaftLDO = TestHelper.generateDoubleArray((int)3, (int)278109906);
        double[] analog_VaftSwch = TestHelper.generateDoubleArray((int)3, (int)85441244);
        double[] analog_VbefLDO = TestHelper.generateDoubleArray((int)3, (int)842409536);
        double[] clockhi_IaftLDO = TestHelper.generateDoubleArray((int)3, (int)-1726177224);
        double[] clockhi_IbefLDO = TestHelper.generateDoubleArray((int)3, (int)-1515240082);
        double[] clockhi_VaftLDO = TestHelper.generateDoubleArray((int)3, (int)-991704740);
        double[] clockhi_VaftSwch = TestHelper.generateDoubleArray((int)3, (int)-825340236);
        double[] clockhi_VbefLDO = TestHelper.generateDoubleArray((int)3, (int)1564315758);
        double[] clocklo_IaftLDO = TestHelper.generateDoubleArray((int)3, (int)438662221);
        double[] clocklo_IbefLDO = TestHelper.generateDoubleArray((int)3, (int)-156787708);
        double[] clocklo_VaftLDO = TestHelper.generateDoubleArray((int)3, (int)-1247997204);
        double[] clocklo_VaftLDO2 = TestHelper.generateDoubleArray((int)3, (int)-1243889219);
        double[] clocklo_VaftSwch = TestHelper.generateDoubleArray((int)3, (int)-912061309);
        double[] clocklo_VbefLDO = TestHelper.generateDoubleArray((int)3, (int)2079393570);
        double[] digital_IaftLDO = TestHelper.generateDoubleArray((int)3, (int)-1268841353);
        double[] digital_IbefLDO = TestHelper.generateDoubleArray((int)3, (int)880393939);
        double[] digital_VaftLDO = TestHelper.generateDoubleArray((int)3, (int)34920083);
        double[] digital_VaftSwch = TestHelper.generateDoubleArray((int)3, (int)-1200798902);
        double[] digital_VbefLDO = TestHelper.generateDoubleArray((int)3, (int)724108399);
        double[] heater_IaftLDO = TestHelper.generateDoubleArray((int)3, (int)-2002967109);
        double[] heater_IbefLDO = TestHelper.generateDoubleArray((int)3, (int)-1819041484);
        double[] heater_VaftLDO = TestHelper.generateDoubleArray((int)3, (int)1371938517);
        double[] heater_VaftSwch = TestHelper.generateDoubleArray((int)3, (int)-1493923365);
        double[] heater_VbefLDO = TestHelper.generateDoubleArray((int)3, (int)-252282763);
        double[] hvbias_IbefSwch = TestHelper.generateDoubleArray((int)3, (int)1680672856);
        double[] hvbias_VbefSwch = TestHelper.generateDoubleArray((int)3, (int)1855738507);
        String location = "j";
        double[] od_IaftLDO = TestHelper.generateDoubleArray((int)3, (int)-758962071);
        double[] od_IbefLDO = TestHelper.generateDoubleArray((int)3, (int)92663199);
        double[] od_VaftLDO = TestHelper.generateDoubleArray((int)3, (int)-1756559124);
        double[] od_VaftLDO2 = TestHelper.generateDoubleArray((int)3, (int)-731903682);
        double[] od_VaftSwch = TestHelper.generateDoubleArray((int)3, (int)-1222786603);
        double[] od_VbefLDO = TestHelper.generateDoubleArray((int)3, (int)2146634971);
        double[] power = TestHelper.generateDoubleArray((int)3, (int)1477513035);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTelemetry(analog_IaftLDO, analog_IbefLDO, analog_VaftLDO, analog_VaftSwch, analog_VbefLDO, clockhi_IaftLDO, clockhi_IbefLDO, clockhi_VaftLDO, clockhi_VaftSwch, clockhi_VbefLDO, clocklo_IaftLDO, clocklo_IbefLDO, clocklo_VaftLDO, clocklo_VaftLDO2, clocklo_VaftSwch, clocklo_VbefLDO, digital_IaftLDO, digital_IbefLDO, digital_VaftLDO, digital_VaftSwch, digital_VbefLDO, heater_IaftLDO, heater_IbefLDO, heater_VaftLDO, heater_VaftSwch, heater_VbefLDO, hvbias_IbefSwch, hvbias_VbefSwch, location, od_IaftLDO, od_IbefLDO, od_VaftLDO, od_VaftLDO2, od_VaftSwch, od_VbefLDO, power));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTelemetry));
        Rebpower_RebTelemetry item_ = (Rebpower_RebTelemetry)item;
        Assert.assertArrayEquals((double[])analog_IaftLDO, (double[])item_.getAnalog_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO, (double[])item_.getAnalog_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO, (double[])item_.getAnalog_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch, (double[])item_.getAnalog_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO, (double[])item_.getAnalog_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO, (double[])item_.getClockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO, (double[])item_.getClockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO, (double[])item_.getClockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch, (double[])item_.getClockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO, (double[])item_.getClockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO, (double[])item_.getClocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO, (double[])item_.getClocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO, (double[])item_.getClocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2, (double[])item_.getClocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch, (double[])item_.getClocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO, (double[])item_.getClocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO, (double[])item_.getDigital_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO, (double[])item_.getDigital_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO, (double[])item_.getDigital_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch, (double[])item_.getDigital_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO, (double[])item_.getDigital_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO, (double[])item_.getHeater_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO, (double[])item_.getHeater_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO, (double[])item_.getHeater_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch, (double[])item_.getHeater_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO, (double[])item_.getHeater_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch, (double[])item_.getHvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch, (double[])item_.getHvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO, (double[])item_.getOd_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO, (double[])item_.getOd_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO, (double[])item_.getOd_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2, (double[])item_.getOd_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch, (double[])item_.getOd_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO, (double[])item_.getOd_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebpsTelemetry() throws Exception {
        double[] boardTemp0 = TestHelper.generateDoubleArray((int)1, (int)1858024884);
        double[] boardTemp1 = TestHelper.generateDoubleArray((int)1, (int)904630476);
        double[] boardTemp2 = TestHelper.generateDoubleArray((int)1, (int)340414747);
        double[] boardTemp3 = TestHelper.generateDoubleArray((int)1, (int)1168774426);
        double[] boardTemp4 = TestHelper.generateDoubleArray((int)1, (int)1815508141);
        double[] boardTemp5 = TestHelper.generateDoubleArray((int)1, (int)-2045059768);
        double[] boardTemp6 = TestHelper.generateDoubleArray((int)1, (int)-1716401921);
        double[] fPGATemp = TestHelper.generateDoubleArray((int)1, (int)-892020317);
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebpsTelemetry(boardTemp0, boardTemp1, boardTemp2, boardTemp3, boardTemp4, boardTemp5, boardTemp6, fPGATemp, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebpsTelemetry));
        Rebpower_RebpsTelemetry item_ = (Rebpower_RebpsTelemetry)item;
        Assert.assertArrayEquals((double[])boardTemp0, (double[])item_.getBoardTemp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp1, (double[])item_.getBoardTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp2, (double[])item_.getBoardTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp3, (double[])item_.getBoardTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp4, (double[])item_.getBoardTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp5, (double[])item_.getBoardTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp6, (double[])item_.getBoardTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])fPGATemp, (double[])item_.getFPGATemp(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveVacuum_Cold1Telemetry() throws Exception {
        double autoOffEnabled = 0.5228962302207947;
        double autoOffTemperature = 0.9924355149269104;
        double autoOnTemperature = 0.15684431791305542;
        double power = 0.9987385272979736;
        double rejectTemperature = 0.47297781705856323;
        double setPower = 0.9340545535087585;
        double setpoint = 0.48599404096603394;
        double temperature = 0.013784825801849365;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Cold1Telemetry(autoOffEnabled, autoOffTemperature, autoOnTemperature, power, rejectTemperature, setPower, setpoint, temperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold1Telemetry));
        Vacuum_Cold1Telemetry item_ = (Vacuum_Cold1Telemetry)item;
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold2Telemetry() throws Exception {
        double autoOffEnabled = 0.14531677961349487;
        double autoOffTemperature = 0.12934476137161255;
        double autoOnTemperature = 0.6772377490997314;
        double power = 0.42665135860443115;
        double rejectTemperature = 0.3735013008117676;
        double setPower = 0.04779643f;
        double setpoint = 0.2569039f;
        double temperature = 0.6709095239639282;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Cold2Telemetry(autoOffEnabled, autoOffTemperature, autoOnTemperature, power, rejectTemperature, setPower, setpoint, temperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold2Telemetry));
        Vacuum_Cold2Telemetry item_ = (Vacuum_Cold2Telemetry)item;
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoTelemetry() throws Exception {
        double autoOffEnabled = 0.9702103137969971;
        double autoOffTemperature = 0.07868212461471558;
        double autoOnTemperature = 0.24574816226959229;
        double power = 0.6333491206169128;
        double rejectTemperature = 0.13586270809173584;
        double setPower = 0.11974668502807617;
        double setpoint = 0.0889168381690979;
        double temperature = 0.5261692404747009;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoTelemetry(autoOffEnabled, autoOffTemperature, autoOnTemperature, power, rejectTemperature, setPower, setpoint, temperature));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoTelemetry));
        Vacuum_CryoTelemetry item_ = (Vacuum_CryoTelemetry)item;
        Assert.assertEquals((double)autoOffEnabled, (double)item_.getAutoOffEnabled(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOffTemperature, (double)item_.getAutoOffTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)autoOnTemperature, (double)item_.getAutoOnTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)rejectTemperature, (double)item_.getRejectTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)setPower, (double)item_.getSetPower(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint, (double)item_.getSetpoint(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature, (double)item_.getTemperature(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_IonPumpsTelemetry() throws Exception {
        double current = 0.3023141026496887;
        double voltage = 0.4013763666152954;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_IonPumpsTelemetry(current, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumpsTelemetry));
        Vacuum_IonPumpsTelemetry item_ = (Vacuum_IonPumpsTelemetry)item;
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_RtdsTelemetry() throws Exception {
        double temperatureCold1 = 0.5835314989089966;
        double temperatureCold2 = 0.03028053045272827;
        double temperatureCryo = 0.9788787961006165;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_RtdsTelemetry(temperatureCold1, temperatureCold2, temperatureCryo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_RtdsTelemetry));
        Vacuum_RtdsTelemetry item_ = (Vacuum_RtdsTelemetry)item;
        Assert.assertEquals((double)temperatureCold1, (double)item_.getTemperatureCold1(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatureCold2, (double)item_.getTemperatureCold2(), (double)1.0E-6f);
        Assert.assertEquals((double)temperatureCryo, (double)item_.getTemperatureCryo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboTelemetry() throws Exception {
        double cntrlrAirTemperature = 0.29183292388916016;
        double cntrlrSinkTemperature = 0.09507143497467041;
        double current = 0.19555652141571045;
        double driveFrequency = 0.09001445770263672;
        double power = 0.33974742889404297;
        double pumpTemperature = 0.6487502455711365;
        double rpm = 0.3559845f;
        double status = 0.5149582624435425;
        double voltage = 0.4933440685272217;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboTelemetry(cntrlrAirTemperature, cntrlrSinkTemperature, current, driveFrequency, power, pumpTemperature, rpm, status, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboTelemetry));
        Vacuum_TurboTelemetry item_ = (Vacuum_TurboTelemetry)item;
        Assert.assertEquals((double)cntrlrAirTemperature, (double)item_.getCntrlrAirTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrSinkTemperature, (double)item_.getCntrlrSinkTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)driveFrequency, (double)item_.getDriveFrequency(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)pumpTemperature, (double)item_.getPumpTemperature(), (double)1.0E-6f);
        Assert.assertEquals((double)rpm, (double)item_.getRpm(), (double)1.0E-6f);
        Assert.assertEquals((double)status, (double)item_.getStatus(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_VQMonitorTelemetry() throws Exception {
        double vqmpressure = 0.31671005487442017;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_VQMonitorTelemetry(vqmpressure));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VQMonitorTelemetry));
        Vacuum_VQMonitorTelemetry item_ = (Vacuum_VQMonitorTelemetry)item;
        Assert.assertEquals((double)vqmpressure, (double)item_.getVqmpressure(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double clean_5_24V_I = 0.2512192726135254;
        double dirty_24V_I = 0.8260467648506165;
        double dirty_28V_I = 0.3513833284378052;
        double dirty_48V_I = 0.6892632842063904;
        double heater_I = 0.39591485261917114;
        double protection_I = 0.35660862922668457;
        double rebps_0 = 0.2112596035003662;
        double sensor_PWS_17_I = 0.7523805499076843;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(clean_5_24V_I, dirty_24V_I, dirty_28V_I, dirty_48V_I, heater_I, protection_I, rebps_0, sensor_PWS_17_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I, (double)item_.getHeater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0, (double)item_.getRebps_0(), (double)1.0E-6f);
        Assert.assertEquals((double)sensor_PWS_17_I, (double)item_.getSensor_PWS_17_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double board_T = 0.0874103307723999;
        double body_Purge_I = 0.759048342704773;
        double body_Purge_V = 0.300897f;
        double bpu_Maq20_I = 0.7185729146003723;
        double bpu_Maq20_V = 0.9520105123519897;
        double fpga_T = 0.7025130987167358;
        double fes_Shu_HCU_I = 0.8319877982139587;
        double fes_Shu_HCU_V = 0.9392833113670349;
        double gauges_I = 0.589480459690094;
        double gauges_V = 0.6364536881446838;
        double ion_Pumps_I = 0.7647939324378967;
        double ion_Pumps_V = 0.019551396369934082;
        double j11_I = 0.2518607974052429;
        double j11_V = 0.9561854004859924;
        double j12_I = 0.5043713450431824;
        double j12_V = 0.35633575916290283;
        double j6_I = 0.9818012118339539;
        double j6_V = 0.05957359f;
        double j7_I = 0.18300074338912964;
        double j7_V = 0.11738365888595581;
        double j8_I = 0.7109484076499939;
        double j8_V = 0.8061887621879578;
        double j9_I = 0.9552660584449768;
        double j9_V = 0.8954678177833557;
        double main_I = 0.28225982189178467;
        double main_T = 0.6733002662658691;
        double main_V = 0.5251775979995728;
        double pwr_Cry_HCU_I = 0.031327664852142334;
        double pwr_Cry_HCU_V = 0.591336190700531;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(board_T, body_Purge_I, body_Purge_V, bpu_Maq20_I, bpu_Maq20_V, fpga_T, fes_Shu_HCU_I, fes_Shu_HCU_V, gauges_I, gauges_V, ion_Pumps_I, ion_Pumps_V, j11_I, j11_V, j12_I, j12_V, j6_I, j6_V, j7_I, j7_V, j8_I, j8_V, j9_I, j9_V, main_I, main_T, main_V, pwr_Cry_HCU_I, pwr_Cry_HCU_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I, (double)item_.getBody_Purge_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V, (double)item_.getBody_Purge_V(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I, (double)item_.getBpu_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V, (double)item_.getBpu_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I, (double)item_.getFes_Shu_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V, (double)item_.getFes_Shu_HCU_V(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_I, (double)item_.getJ11_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_V, (double)item_.getJ11_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_I, (double)item_.getJ12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_V, (double)item_.getJ12_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_I, (double)item_.getJ6_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_V, (double)item_.getJ6_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_I, (double)item_.getJ7_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_V, (double)item_.getJ7_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j8_I, (double)item_.getJ8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j8_V, (double)item_.getJ8_V(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_I, (double)item_.getJ9_I(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_V, (double)item_.getJ9_V(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I, (double)item_.getPwr_Cry_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V, (double)item_.getPwr_Cry_HCU_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double board_T = 0.3541313409805298;
        double fes_I = 0.32669246196746826;
        double fes_V = 0.6565496325492859;
        double fpga_T = 0.24897676706314087;
        double main_I = 0.8357328772544861;
        double main_T = 0.7307540774345398;
        double main_V = 0.5143061280250549;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(board_T, fes_I, fes_V, fpga_T, main_I, main_T, main_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_I, (double)item_.getFes_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_V, (double)item_.getFes_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double board_T = 0.6362953186035156;
        double cryotel0_I = 0.815126359462738;
        double cryotel0_V = 0.8975061774253845;
        double cryotel1_I = 0.3613920211791992;
        double cryotel1_V = 0.5691547393798828;
        double cryotel2_I = 0.11711925268173218;
        double cryotel2_V = 0.428702712059021;
        double fpga_T = 0.4200097918510437;
        double main_I = 0.20275604724884033;
        double main_T = 0.03513270616531372;
        double main_V = 0.5027276277542114;
        double reb_BULK_I = 0.7535495758056641;
        double reb_BULK_V = 0.310475f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(board_T, cryotel0_I, cryotel0_V, cryotel1_I, cryotel1_V, cryotel2_I, cryotel2_V, fpga_T, main_I, main_T, main_V, reb_BULK_I, reb_BULK_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)board_T, (double)item_.getBoard_T(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_I, (double)item_.getCryotel0_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_V, (double)item_.getCryotel0_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_I, (double)item_.getCryotel1_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_V, (double)item_.getCryotel1_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_I, (double)item_.getCryotel2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_V, (double)item_.getCryotel2_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T, (double)item_.getFpga_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I, (double)item_.getMain_I(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T, (double)item_.getMain_T(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V, (double)item_.getMain_V(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_I, (double)item_.getReb_BULK_I(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_V, (double)item_.getReb_BULK_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_3_A_I = 0.9628609418869019;
        double otm_3_A_V = 0.346380352973938;
        double otm_3_B_I = 0.2991047501564026;
        double otm_3_B_V = 0.7620956897735596;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_3_A_I, otm_3_A_V, otm_3_B_I, otm_3_B_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_3_A_I, (double)item_.getOtm_3_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V, (double)item_.getOtm_3_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I, (double)item_.getOtm_3_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V, (double)item_.getOtm_3_B_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_CcdTelemetry() throws Exception {
        double[] gDV = TestHelper.generateDoubleArray((int)9, (int)-1844399748);
        String location = "n";
        double[] oDV = TestHelper.generateDoubleArray((int)9, (int)1426853779);
        double[] oGV = TestHelper.generateDoubleArray((int)9, (int)523689683);
        double[] rDV = TestHelper.generateDoubleArray((int)9, (int)1616373853);
        double[] temp = TestHelper.generateDoubleArray((int)9, (int)-776097940);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_CcdTelemetry(gDV, location, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_CcdTelemetry));
        Focal_plane_CcdTelemetry item_ = (Focal_plane_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTelemetry() throws Exception {
        double[] anaI = TestHelper.generateDoubleArray((int)3, (int)-452434626);
        double[] anaV = TestHelper.generateDoubleArray((int)3, (int)1536772655);
        double[] aspicl_Temp0 = TestHelper.generateDoubleArray((int)3, (int)-187777241);
        double[] aspicl_Temp1 = TestHelper.generateDoubleArray((int)3, (int)-557807564);
        double[] aspicl_Temp2 = TestHelper.generateDoubleArray((int)3, (int)1873770283);
        double[] aspicu_Temp0 = TestHelper.generateDoubleArray((int)3, (int)-43363386);
        double[] aspicu_Temp1 = TestHelper.generateDoubleArray((int)3, (int)2086689249);
        double[] aspicu_Temp2 = TestHelper.generateDoubleArray((int)3, (int)-1595791238);
        double[] clkHI = TestHelper.generateDoubleArray((int)3, (int)277214814);
        double[] clkHV = TestHelper.generateDoubleArray((int)3, (int)273511501);
        double[] clkLI = TestHelper.generateDoubleArray((int)3, (int)788200446);
        double[] clkLV = TestHelper.generateDoubleArray((int)3, (int)-244867215);
        double[] digI = TestHelper.generateDoubleArray((int)3, (int)-2029283447);
        double[] digV = TestHelper.generateDoubleArray((int)3, (int)-666149701);
        double[] hVBiasSwitch = TestHelper.generateDoubleArray((int)3, (int)-2036453503);
        double[] htrV = TestHelper.generateDoubleArray((int)3, (int)-706430264);
        double[] htrW = TestHelper.generateDoubleArray((int)3, (int)-2024826723);
        String location = "";
        double[] oDI = TestHelper.generateDoubleArray((int)3, (int)1090344627);
        double[] oDV = TestHelper.generateDoubleArray((int)3, (int)-1421096878);
        double[] pClkL = TestHelper.generateDoubleArray((int)3, (int)-221279324);
        double[] pClkU = TestHelper.generateDoubleArray((int)3, (int)279604959);
        double[] power = TestHelper.generateDoubleArray((int)3, (int)-2041764593);
        double[] rGL = TestHelper.generateDoubleArray((int)3, (int)1594183144);
        double[] rGU = TestHelper.generateDoubleArray((int)3, (int)-1258849587);
        double[] rTDTemp = TestHelper.generateDoubleArray((int)3, (int)-2004607681);
        double[] ref05V = TestHelper.generateDoubleArray((int)3, (int)-222612607);
        double[] ref125V = TestHelper.generateDoubleArray((int)3, (int)-1645159538);
        double[] ref15V = TestHelper.generateDoubleArray((int)3, (int)1954003400);
        double[] ref25V = TestHelper.generateDoubleArray((int)3, (int)-824276443);
        double[] refN12 = TestHelper.generateDoubleArray((int)3, (int)1011753935);
        double[] refP12 = TestHelper.generateDoubleArray((int)3, (int)463363028);
        double[] sClkL = TestHelper.generateDoubleArray((int)3, (int)957741140);
        double[] sClkU = TestHelper.generateDoubleArray((int)3, (int)-641722085);
        double[] temp1 = TestHelper.generateDoubleArray((int)3, (int)1742735191);
        double[] temp10 = TestHelper.generateDoubleArray((int)3, (int)-551451010);
        double[] temp2 = TestHelper.generateDoubleArray((int)3, (int)31746581);
        double[] temp3 = TestHelper.generateDoubleArray((int)3, (int)1310346694);
        double[] temp4 = TestHelper.generateDoubleArray((int)3, (int)-1932788486);
        double[] temp5 = TestHelper.generateDoubleArray((int)3, (int)-992519834);
        double[] temp6 = TestHelper.generateDoubleArray((int)3, (int)-1692198998);
        double[] temp7 = TestHelper.generateDoubleArray((int)3, (int)369183085);
        double[] temp8 = TestHelper.generateDoubleArray((int)3, (int)-754763176);
        double[] temp9 = TestHelper.generateDoubleArray((int)3, (int)663731105);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicl_Temp1, aspicl_Temp2, aspicu_Temp0, aspicu_Temp1, aspicu_Temp2, clkHI, clkHV, clkLI, clkLV, digI, digV, hVBiasSwitch, htrV, htrW, location, oDI, oDV, pClkL, pClkU, power, rGL, rGU, rTDTemp, ref05V, ref125V, ref15V, ref25V, refN12, refP12, sClkL, sClkU, temp1, temp10, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTelemetry));
        Focal_plane_RebTelemetry item_ = (Focal_plane_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1, (double[])item_.getAspicl_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2, (double[])item_.getAspicl_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1, (double[])item_.getAspicu_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2, (double[])item_.getAspicu_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLI, (double[])item_.getClkLI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05V, (double[])item_.getRef05V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125V, (double[])item_.getRef125V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15V, (double[])item_.getRef15V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25V, (double[])item_.getRef25V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refN12, (double[])item_.getRefN12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refP12, (double[])item_.getRefP12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10, (double[])item_.getTemp10(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7, (double[])item_.getTemp7(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8, (double[])item_.getTemp8(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9, (double[])item_.getTemp9(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.6669414043426514;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPowerTelemetry));
        Focal_plane_RebTotalPowerTelemetry item_ = (Focal_plane_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_SegmentTelemetry() throws Exception {
        double[] i = TestHelper.generateDoubleArray((int)144, (int)-526443333);
        String location = "m";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_SegmentTelemetry(i, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SegmentTelemetry));
        Focal_plane_SegmentTelemetry item_ = (Focal_plane_SegmentTelemetry)item;
        Assert.assertArrayEquals((double[])i, (double[])item_.getI(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }
}

