package org.lsst.sal.cccamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Quadbox_PDU_24VDTelemetry extends CameraTelemetry {
  private final double board_T;

  private final double fes_I;

  private final double fes_V;

  private final double fpga_T;

  private final double main_I;

  private final double main_T;

  private final double main_V;

  public Quadbox_PDU_24VDTelemetry(double board_T, double fes_I, double fes_V, double fpga_T,
      double main_I, double main_T, double main_V) {
    this.board_T = board_T;
    this.fes_I = fes_I;
    this.fes_V = fes_V;
    this.fpga_T = fpga_T;
    this.main_I = main_I;
    this.main_T = main_T;
    this.main_V = main_V;
  }

  public double getBoard_T() {
    return board_T;
  }

  public double getFes_I() {
    return fes_I;
  }

  public double getFes_V() {
    return fes_V;
  }

  public double getFpga_T() {
    return fpga_T;
  }

  public double getMain_I() {
    return main_I;
  }

  public double getMain_T() {
    return main_T;
  }

  public double getMain_V() {
    return main_V;
  }

  @Override
  public String toString() {
    return "Quadbox_PDU_24VDTelemetry{" + "board_T=" + board_T +", fes_I=" + fes_I +
        ", fes_V=" + fes_V +", fpga_T=" + fpga_T +", main_I=" + main_I +", main_T=" + main_T +
        ", main_V=" + main_V +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double board_T;

    private double fes_I;

    private double fes_V;

    private double fpga_T;

    private double main_I;

    private double main_T;

    private double main_V;

    private Builder() {
    }

    public Builder board_T(double board_T) {
      this.board_T = board_T;
      return this;
    }

    public Builder fes_I(double fes_I) {
      this.fes_I = fes_I;
      return this;
    }

    public Builder fes_V(double fes_V) {
      this.fes_V = fes_V;
      return this;
    }

    public Builder fpga_T(double fpga_T) {
      this.fpga_T = fpga_T;
      return this;
    }

    public Builder main_I(double main_I) {
      this.main_I = main_I;
      return this;
    }

    public Builder main_T(double main_T) {
      this.main_T = main_T;
      return this;
    }

    public Builder main_V(double main_V) {
      this.main_V = main_V;
      return this;
    }

    public Quadbox_PDU_24VDTelemetry build() {
      return new Quadbox_PDU_24VDTelemetry(board_T, fes_I, fes_V, fpga_T, main_I, main_T, main_V);
    }
  }
}
