package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class Vacuum_IonPumps_LimitsConfigurationEvent extends CameraEvent {
  private final String version;

  private final double current_warnHi;

  private final double current_warnLo;

  private final double current_limitHi;

  private final double current_limitLo;

  private final double voltage_warnHi;

  private final double voltage_warnLo;

  private final double voltage_limitHi;

  private final double voltage_limitLo;

  public Vacuum_IonPumps_LimitsConfigurationEvent(String version, double current_warnHi,
      double current_warnLo, double current_limitHi, double current_limitLo, double voltage_warnHi,
      double voltage_warnLo, double voltage_limitHi, double voltage_limitLo) {
    this.version = version;
    this.current_warnHi = current_warnHi;
    this.current_warnLo = current_warnLo;
    this.current_limitHi = current_limitHi;
    this.current_limitLo = current_limitLo;
    this.voltage_warnHi = voltage_warnHi;
    this.voltage_warnLo = voltage_warnLo;
    this.voltage_limitHi = voltage_limitHi;
    this.voltage_limitLo = voltage_limitLo;
  }

  public String getVersion() {
    return version;
  }

  public double getCurrent_warnHi() {
    return current_warnHi;
  }

  public double getCurrent_warnLo() {
    return current_warnLo;
  }

  public double getCurrent_limitHi() {
    return current_limitHi;
  }

  public double getCurrent_limitLo() {
    return current_limitLo;
  }

  public double getVoltage_warnHi() {
    return voltage_warnHi;
  }

  public double getVoltage_warnLo() {
    return voltage_warnLo;
  }

  public double getVoltage_limitHi() {
    return voltage_limitHi;
  }

  public double getVoltage_limitLo() {
    return voltage_limitLo;
  }

  @Override
  public String toString() {
    return "Vacuum_IonPumps_LimitsConfigurationEvent{" + "version=" + version +
        ", current_warnHi=" + current_warnHi +", current_warnLo=" + current_warnLo +
        ", current_limitHi=" + current_limitHi +", current_limitLo=" + current_limitLo +
        ", voltage_warnHi=" + voltage_warnHi +", voltage_warnLo=" + voltage_warnLo +
        ", voltage_limitHi=" + voltage_limitHi +", voltage_limitLo=" + voltage_limitLo +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private String version;

    private double current_warnHi;

    private double current_warnLo;

    private double current_limitHi;

    private double current_limitLo;

    private double voltage_warnHi;

    private double voltage_warnLo;

    private double voltage_limitHi;

    private double voltage_limitLo;

    private Builder() {
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder current_warnHi(double current_warnHi) {
      this.current_warnHi = current_warnHi;
      return this;
    }

    public Builder current_warnLo(double current_warnLo) {
      this.current_warnLo = current_warnLo;
      return this;
    }

    public Builder current_limitHi(double current_limitHi) {
      this.current_limitHi = current_limitHi;
      return this;
    }

    public Builder current_limitLo(double current_limitLo) {
      this.current_limitLo = current_limitLo;
      return this;
    }

    public Builder voltage_warnHi(double voltage_warnHi) {
      this.voltage_warnHi = voltage_warnHi;
      return this;
    }

    public Builder voltage_warnLo(double voltage_warnLo) {
      this.voltage_warnLo = voltage_warnLo;
      return this;
    }

    public Builder voltage_limitHi(double voltage_limitHi) {
      this.voltage_limitHi = voltage_limitHi;
      return this;
    }

    public Builder voltage_limitLo(double voltage_limitLo) {
      this.voltage_limitLo = voltage_limitLo;
      return this;
    }

    public Vacuum_IonPumps_LimitsConfigurationEvent build() {
      return new Vacuum_IonPumps_LimitsConfigurationEvent(version, current_warnHi, current_warnLo, current_limitHi, current_limitLo, voltage_warnHi, voltage_warnLo, voltage_limitHi, voltage_limitLo);
    }
  }
}
