/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.cccamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.event.AuthListEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.CCSConfiguredEvent;
import org.lsst.sal.camera.event.ConfigurationAppliedEvent;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasksConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Stats_StatisticsConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Stats_buildConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_StoreConfigurationEvent;
import org.lsst.sal.camera.event.EndInitializeGuiderEvent;
import org.lsst.sal.camera.event.EndInitializeImageEvent;
import org.lsst.sal.camera.event.EndLoadFilterEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndUnloadFilterEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.FocalPlaneSummaryInfoEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_RaftsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_ImageDatabaseServiceConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_ImageNameServiceConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_InstrumentConfig_InstrumentConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_PeriodicTasksConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_RaftTempControlStatusConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_RebTotalPower_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsPowerConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Segment_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_SequencerConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_WebHooksConfig_VisualizationConfigurationEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_FitsHandlingConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_Reb_FitsHandlingConfigurationEvent;
import org.lsst.sal.camera.event.LargeFileObjectAvailableEvent;
import org.lsst.sal.camera.event.LogLevelEvent;
import org.lsst.sal.camera.event.LogMessageEvent;
import org.lsst.sal.camera.event.NotReadyToTakeImageEvent;
import org.lsst.sal.camera.event.PrepareToTakeImageEvent;
import org.lsst.sal.camera.event.Quadbox_BFR_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VC_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VD_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_48V_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_5V_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PeriodicTasksConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.ReadyToTakeImageEvent;
import org.lsst.sal.camera.event.RebpowerConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_EmergencyResponseManagerConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartLoadFilterEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartRotateCarouselEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.event.StartUnloadFilterEvent;
import org.lsst.sal.cccamera.CCCamera;
import org.lsst.sal.cccamera.event.Bonn_shutter_Device_GeneralConfigurationEvent;
import org.lsst.sal.cccamera.event.Bonn_shutter_Device_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Bonn_shutter_GeneralConfigurationEvent;
import org.lsst.sal.cccamera.event.Bonn_shutter_PeriodicTasksConfigurationEvent;
import org.lsst.sal.cccamera.event.Bonn_shutter_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.cccamera.event.Daq_monitor_StoreConfigurationEvent;
import org.lsst.sal.cccamera.event.EndTakeImageEvent;
import org.lsst.sal.cccamera.event.FcsConfigurationEvent;
import org.lsst.sal.cccamera.event.Fcs_LinearEncoderConfigurationEvent;
import org.lsst.sal.cccamera.event.Fcs_LinearEncoder_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Fcs_PeriodicTasksConfigurationEvent;
import org.lsst.sal.cccamera.event.Fcs_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.cccamera.event.Fcs_StepperMotorConfigurationEvent;
import org.lsst.sal.cccamera.event.Fcs_StepperMotor_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Fcs_StepperMotor_MotorConfigurationEvent;
import org.lsst.sal.cccamera.event.FileCommandExecutionEvent;
import org.lsst.sal.cccamera.event.FitsFilesWrittenEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Ccd_HardwareIdConfigurationEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Ccd_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Focal_plane_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Raft_HardwareIdConfigurationEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Raft_RaftTempControlConfigurationEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Reb_HardwareIdConfigurationEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Reb_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Reb_timersConfigurationEvent;
import org.lsst.sal.cccamera.event.Focal_plane_SequencerConfig_DAQConfigurationEvent;
import org.lsst.sal.cccamera.event.ImageStoredEvent;
import org.lsst.sal.cccamera.event.ImageVisualizationEvent;
import org.lsst.sal.cccamera.event.Image_handling_ImageHandler_DAQConfigurationEvent;
import org.lsst.sal.cccamera.event.Image_handling_PeriodicTasksConfigurationEvent;
import org.lsst.sal.cccamera.event.Image_handling_RebConfigurationEvent;
import org.lsst.sal.cccamera.event.Quadbox_BFR_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Quadbox_PDU_24VC_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Quadbox_PDU_24VD_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Quadbox_PDU_48V_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Quadbox_PDU_5V_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Rebpower_PeriodicTasksConfigurationEvent;
import org.lsst.sal.cccamera.event.Rebpower_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.cccamera.event.Rebpower_RebConfigurationEvent;
import org.lsst.sal.cccamera.event.Rebpower_Reb_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Rebpower_Rebps_PowerConfigurationEvent;
import org.lsst.sal.cccamera.event.ShutterBladeMotionProfileEvent;
import org.lsst.sal.cccamera.event.Vacuum_Cold1_CryoconConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_Cold1_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_Cold2_CryoconConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_Cold2_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_Cryo_CryoconConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_Cryo_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_IonPumps_CryoConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_IonPumps_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_PeriodicTasksConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_Rtds_DeviceConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_Rtds_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_TurboConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_Turbo_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_VQMonitor_CryoConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_VQMonitor_LimitsConfigurationEvent;
import org.lsst.sal.cccamera.event.Vacuum_VacPluto_DeviceConfigurationEvent;

public class EventSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = CCCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALEvent testSendReceive(SALEvent item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALEvent> future = executor.submit(() -> sal.getNextEvent(Duration.ofSeconds(10L)));
        try {
            sal.logEvent(item);
            SALEvent sALEvent = future.get(10L, TimeUnit.SECONDS);
            return sALEvent;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws Exception {
        int priority = 379;
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 977;
        String imageName = "kpffmnwkoekwxqcrkm";
        int imageIndex = 389;
        String imageSource = "";
        String imageController = "";
        String imageDate = "udwlsjy";
        int imageNumber = 299;
        double timestampAcquisitionStart = 0.5973697304725647;
        double requestedExposureTime = 0.5855571627616882;
        double timestampEndOfReadout = 0.20897942781448364;
        SALEvent item = this.testSendReceive((SALEvent)new EndReadoutEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, requestedExposureTime, timestampEndOfReadout));
        Assert.assertTrue((boolean)(item instanceof EndReadoutEvent));
        EndReadoutEvent item_ = (EndReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)requestedExposureTime, (double)item_.getRequestedExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampEndOfReadout, (double)item_.getTimestampEndOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndTakeImageEvent() throws Exception {
        int priority = 267;
        SALEvent item = this.testSendReceive((SALEvent)new EndTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndTakeImageEvent));
        EndTakeImageEvent item_ = (EndTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartSetFilterEvent() throws Exception {
        int priority = 559;
        String filterName = "";
        String filterType = "l";
        SALEvent item = this.testSendReceive((SALEvent)new StartSetFilterEvent(priority, filterName, filterType));
        Assert.assertTrue((boolean)(item instanceof StartSetFilterEvent));
        StartSetFilterEvent item_ = (StartSetFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
    }

    @Test
    public void sendReceiveStartUnloadFilterEvent() throws Exception {
        int priority = 257;
        double timestampTransition = 0.13944172859191895;
        SALEvent item = this.testSendReceive((SALEvent)new StartUnloadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartUnloadFilterEvent));
        StartUnloadFilterEvent item_ = (StartUnloadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveNotReadyToTakeImageEvent() throws Exception {
        int priority = 819;
        double timestampTransition = 0.5741432905197144;
        SALEvent item = this.testSendReceive((SALEvent)new NotReadyToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof NotReadyToTakeImageEvent));
        NotReadyToTakeImageEvent item_ = (NotReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws Exception {
        int priority = 166;
        double timestampTransition = 0.2913547158241272;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterCloseEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterCloseEvent));
        StartShutterCloseEvent item_ = (StartShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeGuiderEvent() throws Exception {
        int priority = 874;
        double timestampTransition = 0.07489949464797974;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeGuiderEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndInitializeGuiderEvent));
        EndInitializeGuiderEvent item_ = (EndInitializeGuiderEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws Exception {
        int priority = 418;
        double timestampTransition = 0.9309825897216797;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterCloseEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterCloseEvent));
        EndShutterCloseEvent item_ = (EndShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws Exception {
        int priority = 376;
        String additionalKeys = "";
        String additionalValues = "p";
        int imagesInSequence = 934;
        String imageName = "jekwkiqze";
        int imageIndex = 114;
        String imageSource = "s";
        String imageController = "v";
        String imageDate = "";
        int imageNumber = 963;
        double timestampAcquisitionStart = 0.1568049192428589;
        double exposureTime = 0.8497532606124878;
        String imageTag = "nlkeqghnfuzovpreprkfuytkjuyhyzwirzilycbyllrzadpaeuerhlvukfvlofe";
        double timestampDateObs = 0.9596447348594666;
        double timestampDateEnd = 0.6999391317367554;
        double measuredShutterOpenTime = 0.13643884658813477;
        double darkTime = 0.5855968594551086;
        String emulatedImage = "p";
        SALEvent item = this.testSendReceive((SALEvent)new EndOfImageTelemetryEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, measuredShutterOpenTime, darkTime, emulatedImage));
        Assert.assertTrue((boolean)(item instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent item_ = (EndOfImageTelemetryEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageTag, (Object)item_.getImageTag());
        Assert.assertEquals((double)timestampDateObs, (double)item_.getTimestampDateObs(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampDateEnd, (double)item_.getTimestampDateEnd(), (double)1.0E-6f);
        Assert.assertEquals((double)measuredShutterOpenTime, (double)item_.getMeasuredShutterOpenTime(), (double)1.0E-6f);
        Assert.assertEquals((double)darkTime, (double)item_.getDarkTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)emulatedImage, (Object)item_.getEmulatedImage());
    }

    @Test
    public void sendReceiveEndUnloadFilterEvent() throws Exception {
        int priority = 167;
        double timestampTransition = 0.6173826456069946;
        SALEvent item = this.testSendReceive((SALEvent)new EndUnloadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndUnloadFilterEvent));
        EndUnloadFilterEvent item_ = (EndUnloadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndRotateCarouselEvent() throws Exception {
        int priority = 525;
        double timestampTransition = 0.5078532695770264;
        SALEvent item = this.testSendReceive((SALEvent)new EndRotateCarouselEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndRotateCarouselEvent));
        EndRotateCarouselEvent item_ = (EndRotateCarouselEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartLoadFilterEvent() throws Exception {
        int priority = 787;
        double timestampTransition = 0.347290575504303;
        SALEvent item = this.testSendReceive((SALEvent)new StartLoadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartLoadFilterEvent));
        StartLoadFilterEvent item_ = (StartLoadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveReadyToTakeImageEvent() throws Exception {
        int priority = 755;
        double timestampTransition = 0.7533835172653198;
        SALEvent item = this.testSendReceive((SALEvent)new ReadyToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof ReadyToTakeImageEvent));
        ReadyToTakeImageEvent item_ = (ReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePrepareToTakeImageEvent() throws Exception {
        int priority = 664;
        double timestampTransition = 0.4689059257507324;
        SALEvent item = this.testSendReceive((SALEvent)new PrepareToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof PrepareToTakeImageEvent));
        PrepareToTakeImageEvent item_ = (PrepareToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveCCSConfiguredEvent() throws Exception {
        int priority = 909;
        double timestampTransition = 0.405245304107666;
        SALEvent item = this.testSendReceive((SALEvent)new CCSConfiguredEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof CCSConfiguredEvent));
        CCSConfiguredEvent item_ = (CCSConfiguredEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndLoadFilterEvent() throws Exception {
        int priority = 431;
        double timestampTransition = 0.0863904356956482;
        SALEvent item = this.testSendReceive((SALEvent)new EndLoadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndLoadFilterEvent));
        EndLoadFilterEvent item_ = (EndLoadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws Exception {
        int priority = 600;
        double timestampTransition = 0.9034f;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterOpenEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterOpenEvent));
        EndShutterOpenEvent item_ = (EndShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartIntegrationEvent() throws Exception {
        int priority = 546;
        String additionalKeys = "w";
        String additionalValues = "w";
        int imagesInSequence = 81;
        String imageName = "uhjtouisgx";
        int imageIndex = 215;
        String imageSource = "r";
        String imageController = "";
        String imageDate = "qnmenq";
        int imageNumber = 686;
        double timestampAcquisitionStart = 0.7154474854469299;
        double exposureTime = 0.22857189178466797;
        String mode = "s";
        double timeout = 0.38384324312210083;
        SALEvent item = this.testSendReceive((SALEvent)new StartIntegrationEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, mode, timeout));
        Assert.assertTrue((boolean)(item instanceof StartIntegrationEvent));
        StartIntegrationEvent item_ = (StartIntegrationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((double)timeout, (double)item_.getTimeout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeImageEvent() throws Exception {
        int priority = 529;
        double timestampTransition = 0.8565526604652405;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndInitializeImageEvent));
        EndInitializeImageEvent item_ = (EndInitializeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndSetFilterEvent() throws Exception {
        int priority = 79;
        String filterName = "e";
        String filterType = "o";
        int filterSlot = 840;
        double filterPosition = 0.7784445881843567;
        SALEvent item = this.testSendReceive((SALEvent)new EndSetFilterEvent(priority, filterName, filterType, filterSlot, filterPosition));
        Assert.assertTrue((boolean)(item instanceof EndSetFilterEvent));
        EndSetFilterEvent item_ = (EndSetFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
        Assert.assertEquals((long)filterSlot, (long)item_.getFilterSlot());
        Assert.assertEquals((double)filterPosition, (double)item_.getFilterPosition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws Exception {
        int priority = 51;
        double timestampTransition = 0.9931433200836182;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterOpenEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterOpenEvent));
        StartShutterOpenEvent item_ = (StartShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAvailableFiltersEvent() throws Exception {
        int priority = 75;
        String filterNames = "mhnddyrhmpolaatatguejjmwmfeoaclwuexojmhlpkystpmanwcangdisqfvxuqwqysiafomtyjrzxwfucnamoaezfanauhnnootuh";
        SALEvent item = this.testSendReceive((SALEvent)new AvailableFiltersEvent(priority, filterNames));
        Assert.assertTrue((boolean)(item instanceof AvailableFiltersEvent));
        AvailableFiltersEvent item_ = (AvailableFiltersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterNames, (Object)item_.getFilterNames());
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws Exception {
        int priority = 573;
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 349;
        String imageName = "pmldiutxsqc";
        int imageIndex = 754;
        String imageSource = "ge";
        String imageController = "n";
        String imageDate = "dyvuwxm";
        int imageNumber = 53;
        double timestampAcquisitionStart = 0.33388835191726685;
        double exposureTime = 0.19930672645568848;
        double timestampStartOfReadout = 0.002245903f;
        SALEvent item = this.testSendReceive((SALEvent)new StartReadoutEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, timestampStartOfReadout));
        Assert.assertTrue((boolean)(item instanceof StartReadoutEvent));
        StartReadoutEvent item_ = (StartReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampStartOfReadout, (double)item_.getTimestampStartOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartRotateCarouselEvent() throws Exception {
        int priority = 721;
        double timestampTransition = 0.21695858240127563;
        SALEvent item = this.testSendReceive((SALEvent)new StartRotateCarouselEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartRotateCarouselEvent));
        StartRotateCarouselEvent item_ = (StartRotateCarouselEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws Exception {
        int priority = 343;
        String imageName = "a";
        String ccdLocation = "d";
        String raftBay = "";
        String ccdSlot = "a";
        Object[] ccdType = new ImageReadoutParametersEvent.CcdType[]{ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL};
        int[] overRows = TestHelper.generateIntArray((int)9, (int)-513719574);
        int[] overCols = TestHelper.generateIntArray((int)9, (int)-1531151360);
        int[] readRows = TestHelper.generateIntArray((int)9, (int)-1860824840);
        int[] readCols = TestHelper.generateIntArray((int)9, (int)-345247305);
        int[] readCols2 = TestHelper.generateIntArray((int)9, (int)-809512818);
        int[] preCols = TestHelper.generateIntArray((int)9, (int)-2090954088);
        int[] preRows = TestHelper.generateIntArray((int)9, (int)1890166409);
        int[] postCols = TestHelper.generateIntArray((int)9, (int)759431936);
        int[] underCols = TestHelper.generateIntArray((int)9, (int)-1566290996);
        String daqFolder = "";
        String daqAnnotation = "a";
        SALEvent item = this.testSendReceive((SALEvent)new ImageReadoutParametersEvent(priority, imageName, ccdLocation, raftBay, ccdSlot, (ImageReadoutParametersEvent.CcdType[])ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols, underCols, daqFolder, daqAnnotation));
        Assert.assertTrue((boolean)(item instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent item_ = (ImageReadoutParametersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((int[])overRows, (int[])item_.getOverRows());
        Assert.assertArrayEquals((int[])overCols, (int[])item_.getOverCols());
        Assert.assertArrayEquals((int[])readRows, (int[])item_.getReadRows());
        Assert.assertArrayEquals((int[])readCols, (int[])item_.getReadCols());
        Assert.assertArrayEquals((int[])readCols2, (int[])item_.getReadCols2());
        Assert.assertArrayEquals((int[])preCols, (int[])item_.getPreCols());
        Assert.assertArrayEquals((int[])preRows, (int[])item_.getPreRows());
        Assert.assertArrayEquals((int[])postCols, (int[])item_.getPostCols());
        Assert.assertArrayEquals((int[])underCols, (int[])item_.getUnderCols());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqAnnotation, (Object)item_.getDaqAnnotation());
    }

    @Test
    public void sendReceiveFocalPlaneSummaryInfoEvent() throws Exception {
        int priority = 988;
        String ccdLocation = "";
        String raftBay = "";
        String ccdSlot = "";
        String rebSerialNumber = "";
        String rebLSSTName = "m";
        String ccdLSSTName = "p";
        String raftLSSTName = "";
        String ccdManSerNum = "o";
        String ccdManufacturer = "h";
        Object[] ccdType = new FocalPlaneSummaryInfoEvent.CcdType[]{FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V};
        double[] ccdTempSetPoint = TestHelper.generateDoubleArray((int)9, (int)1884345550);
        String sequencerKey = "";
        String sequencerChecksum = "p";
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneSummaryInfoEvent(priority, ccdLocation, raftBay, ccdSlot, rebSerialNumber, rebLSSTName, ccdLSSTName, raftLSSTName, ccdManSerNum, ccdManufacturer, (FocalPlaneSummaryInfoEvent.CcdType[])ccdType, ccdTempSetPoint, sequencerKey, sequencerChecksum));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneSummaryInfoEvent));
        FocalPlaneSummaryInfoEvent item_ = (FocalPlaneSummaryInfoEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)rebSerialNumber, (Object)item_.getRebSerialNumber());
        Assert.assertEquals((Object)rebLSSTName, (Object)item_.getRebLSSTName());
        Assert.assertEquals((Object)ccdLSSTName, (Object)item_.getCcdLSSTName());
        Assert.assertEquals((Object)raftLSSTName, (Object)item_.getRaftLSSTName());
        Assert.assertEquals((Object)ccdManSerNum, (Object)item_.getCcdManSerNum());
        Assert.assertEquals((Object)ccdManufacturer, (Object)item_.getCcdManufacturer());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((double[])ccdTempSetPoint, (double[])item_.getCcdTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((Object)sequencerKey, (Object)item_.getSequencerKey());
        Assert.assertEquals((Object)sequencerChecksum, (Object)item_.getSequencerChecksum());
    }

    @Test
    public void sendReceiveFcsConfigurationEvent() throws Exception {
        int priority = 660;
        String version = "";
        String filterNames = "";
        String filterTypes = "";
        String nameFilter1 = "";
        String nameFilter2 = "u";
        String nameFilter3 = "r";
        int positionFilter1 = 625;
        int positionFilter2 = 604;
        int positionFilter3 = 231;
        int positionLoad1 = 819;
        int positionLoad3 = 495;
        double tolerance = 0.6207301020622253;
        SALEvent item = this.testSendReceive((SALEvent)new FcsConfigurationEvent(priority, version, filterNames, filterTypes, nameFilter1, nameFilter2, nameFilter3, positionFilter1, positionFilter2, positionFilter3, positionLoad1, positionLoad3, tolerance));
        Assert.assertTrue((boolean)(item instanceof FcsConfigurationEvent));
        FcsConfigurationEvent item_ = (FcsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)filterNames, (Object)item_.getFilterNames());
        Assert.assertEquals((Object)filterTypes, (Object)item_.getFilterTypes());
        Assert.assertEquals((Object)nameFilter1, (Object)item_.getNameFilter1());
        Assert.assertEquals((Object)nameFilter2, (Object)item_.getNameFilter2());
        Assert.assertEquals((Object)nameFilter3, (Object)item_.getNameFilter3());
        Assert.assertEquals((long)positionFilter1, (long)item_.getPositionFilter1());
        Assert.assertEquals((long)positionFilter2, (long)item_.getPositionFilter2());
        Assert.assertEquals((long)positionFilter3, (long)item_.getPositionFilter3());
        Assert.assertEquals((long)positionLoad1, (long)item_.getPositionLoad1());
        Assert.assertEquals((long)positionLoad3, (long)item_.getPositionLoad3());
        Assert.assertEquals((double)tolerance, (double)item_.getTolerance(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_LinearEncoderConfigurationEvent() throws Exception {
        int priority = 798;
        String version = "v";
        String devcId = "a";
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_LinearEncoderConfigurationEvent(priority, version, devcId));
        Assert.assertTrue((boolean)(item instanceof Fcs_LinearEncoderConfigurationEvent));
        Fcs_LinearEncoderConfigurationEvent item_ = (Fcs_LinearEncoderConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveFcs_LinearEncoder_LimitsConfigurationEvent() throws Exception {
        int priority = 314;
        String version = "";
        double linearposition_warnHi = 0.19236081838607788;
        double linearposition_warnLo = 0.7246916890144348;
        double linearposition_limitHi = 0.6344510316848755;
        double linearposition_limitLo = 0.16350728273391724;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_LinearEncoder_LimitsConfigurationEvent(priority, version, linearposition_warnHi, linearposition_warnLo, linearposition_limitHi, linearposition_limitLo));
        Assert.assertTrue((boolean)(item instanceof Fcs_LinearEncoder_LimitsConfigurationEvent));
        Fcs_LinearEncoder_LimitsConfigurationEvent item_ = (Fcs_LinearEncoder_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)linearposition_warnHi, (double)item_.getLinearposition_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)linearposition_warnLo, (double)item_.getLinearposition_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)linearposition_limitHi, (double)item_.getLinearposition_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)linearposition_limitLo, (double)item_.getLinearposition_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_PeriodicTasksConfigurationEvent() throws Exception {
        int priority = 73;
        String version = "u";
        int schedulers_default_nTasks = 842;
        int schedulers_default_nThreads = 142;
        int schedulers_monitor_update_publish_scheduler_nTasks = 272;
        int schedulers_monitor_update_publish_scheduler_nThreads = 912;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_PeriodicTasksConfigurationEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Fcs_PeriodicTasksConfigurationEvent));
        Fcs_PeriodicTasksConfigurationEvent item_ = (Fcs_PeriodicTasksConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveFcs_PeriodicTasks_timersConfigurationEvent() throws Exception {
        int priority = 587;
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 901L;
        long heartbeat_taskPeriodMillis = 423L;
        long monitor_check_taskPeriodMillis = 717L;
        long monitor_publish_taskPeriodMillis = 607L;
        long monitor_update_taskPeriodMillis = 186L;
        long runtimeinfo_taskPeriodMillis = 672L;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_PeriodicTasks_timersConfigurationEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Fcs_PeriodicTasks_timersConfigurationEvent));
        Fcs_PeriodicTasks_timersConfigurationEvent item_ = (Fcs_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFcs_StepperMotorConfigurationEvent() throws Exception {
        int priority = 551;
        String version = "";
        String devcId = "";
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_StepperMotorConfigurationEvent(priority, version, devcId));
        Assert.assertTrue((boolean)(item instanceof Fcs_StepperMotorConfigurationEvent));
        Fcs_StepperMotorConfigurationEvent item_ = (Fcs_StepperMotorConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveFcs_StepperMotor_LimitsConfigurationEvent() throws Exception {
        int priority = 167;
        String version = "";
        double motorencoder_warnHi = 0.8401934504508972;
        double motorencoder_warnLo = 0.9367903470993042;
        double motorencoder_limitHi = 0.36026543378829956;
        double motorencoder_limitLo = 0.9548732042312622;
        double motortemperature_warnHi = 0.846602737903595;
        double motortemperature_warnLo = 0.7819063067436218;
        double motortemperature_limitHi = 0.6360480785369873;
        double motortemperature_limitLo = 0.7582656741142273;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_StepperMotor_LimitsConfigurationEvent(priority, version, motorencoder_warnHi, motorencoder_warnLo, motorencoder_limitHi, motorencoder_limitLo, motortemperature_warnHi, motortemperature_warnLo, motortemperature_limitHi, motortemperature_limitLo));
        Assert.assertTrue((boolean)(item instanceof Fcs_StepperMotor_LimitsConfigurationEvent));
        Fcs_StepperMotor_LimitsConfigurationEvent item_ = (Fcs_StepperMotor_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)motorencoder_warnHi, (double)item_.getMotorencoder_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)motorencoder_warnLo, (double)item_.getMotorencoder_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)motorencoder_limitHi, (double)item_.getMotorencoder_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)motorencoder_limitLo, (double)item_.getMotorencoder_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)motortemperature_warnHi, (double)item_.getMotortemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)motortemperature_warnLo, (double)item_.getMotortemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)motortemperature_limitHi, (double)item_.getMotortemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)motortemperature_limitLo, (double)item_.getMotortemperature_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_StepperMotor_MotorConfigurationEvent() throws Exception {
        int priority = 347;
        String version = "";
        int accelRamp = 755;
        boolean backOff = true;
        int brakeRamp = 985;
        int iPhase = 558;
        int iPhaseStill = 404;
        int maxJerkAccel = 683;
        int maxJerkBrake = 801;
        double maxRampTime = 0.6933475732803345;
        int minStepFreq = 649;
        int quickRamp = 441;
        int rampType = 754;
        int reverseClearance = 416;
        int stepFreq = 23;
        int stepMode = 894;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_StepperMotor_MotorConfigurationEvent(priority, version, accelRamp, backOff, brakeRamp, iPhase, iPhaseStill, maxJerkAccel, maxJerkBrake, maxRampTime, minStepFreq, quickRamp, rampType, reverseClearance, stepFreq, stepMode));
        Assert.assertTrue((boolean)(item instanceof Fcs_StepperMotor_MotorConfigurationEvent));
        Fcs_StepperMotor_MotorConfigurationEvent item_ = (Fcs_StepperMotor_MotorConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)accelRamp, (long)item_.getAccelRamp());
        Assert.assertEquals((Object)backOff, (Object)item_.isBackOff());
        Assert.assertEquals((long)brakeRamp, (long)item_.getBrakeRamp());
        Assert.assertEquals((long)iPhase, (long)item_.getIPhase());
        Assert.assertEquals((long)iPhaseStill, (long)item_.getIPhaseStill());
        Assert.assertEquals((long)maxJerkAccel, (long)item_.getMaxJerkAccel());
        Assert.assertEquals((long)maxJerkBrake, (long)item_.getMaxJerkBrake());
        Assert.assertEquals((double)maxRampTime, (double)item_.getMaxRampTime(), (double)1.0E-6f);
        Assert.assertEquals((long)minStepFreq, (long)item_.getMinStepFreq());
        Assert.assertEquals((long)quickRamp, (long)item_.getQuickRamp());
        Assert.assertEquals((long)rampType, (long)item_.getRampType());
        Assert.assertEquals((long)reverseClearance, (long)item_.getReverseClearance());
        Assert.assertEquals((long)stepFreq, (long)item_.getStepFreq());
        Assert.assertEquals((long)stepMode, (long)item_.getStepMode());
    }

    @Test
    public void sendReceiveBonn_shutter_Device_GeneralConfigurationEvent() throws Exception {
        int priority = 935;
        String version = "";
        String devcId = "t";
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_Device_GeneralConfigurationEvent(priority, version, devcId));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_Device_GeneralConfigurationEvent));
        Bonn_shutter_Device_GeneralConfigurationEvent item_ = (Bonn_shutter_Device_GeneralConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveBonn_shutter_Device_LimitsConfigurationEvent() throws Exception {
        int priority = 874;
        String version = "z";
        double bonn_V36_warnHi = 0.3869706988334656;
        double bonn_V36_warnLo = 0.575219452381134;
        double bonn_V36_limitHi = 0.4674455523490906;
        double bonn_V36_limitLo = 0.5843941569328308;
        double bonn_V5_warnHi = 0.1316300630569458;
        double bonn_V5_warnLo = 0.026497721672058105;
        double bonn_V5_limitHi = 0.7373479604721069;
        double bonn_V5_limitLo = 0.4780054f;
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_Device_LimitsConfigurationEvent(priority, version, bonn_V36_warnHi, bonn_V36_warnLo, bonn_V36_limitHi, bonn_V36_limitLo, bonn_V5_warnHi, bonn_V5_warnLo, bonn_V5_limitHi, bonn_V5_limitLo));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_Device_LimitsConfigurationEvent));
        Bonn_shutter_Device_LimitsConfigurationEvent item_ = (Bonn_shutter_Device_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)bonn_V36_warnHi, (double)item_.getBonn_V36_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V36_warnLo, (double)item_.getBonn_V36_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V36_limitHi, (double)item_.getBonn_V36_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V36_limitLo, (double)item_.getBonn_V36_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5_warnHi, (double)item_.getBonn_V5_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5_warnLo, (double)item_.getBonn_V5_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5_limitHi, (double)item_.getBonn_V5_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5_limitLo, (double)item_.getBonn_V5_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveBonn_shutter_GeneralConfigurationEvent() throws Exception {
        int priority = 913;
        String version = "";
        double maxExposureTime = 0.6932491064071655;
        double minExposureTime = 0.43241333961486816;
        int openCloseTimeMillis = 446;
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_GeneralConfigurationEvent(priority, version, maxExposureTime, minExposureTime, openCloseTimeMillis));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_GeneralConfigurationEvent));
        Bonn_shutter_GeneralConfigurationEvent item_ = (Bonn_shutter_GeneralConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)maxExposureTime, (double)item_.getMaxExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)minExposureTime, (double)item_.getMinExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((long)openCloseTimeMillis, (long)item_.getOpenCloseTimeMillis());
    }

    @Test
    public void sendReceiveBonn_shutter_PeriodicTasksConfigurationEvent() throws Exception {
        int priority = 658;
        String version = "i";
        int schedulers_default_nTasks = 138;
        int schedulers_default_nThreads = 962;
        int schedulers_monitor_update_publish_scheduler_nTasks = 277;
        int schedulers_monitor_update_publish_scheduler_nThreads = 979;
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_PeriodicTasksConfigurationEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_PeriodicTasksConfigurationEvent));
        Bonn_shutter_PeriodicTasksConfigurationEvent item_ = (Bonn_shutter_PeriodicTasksConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveBonn_shutter_PeriodicTasks_timersConfigurationEvent() throws Exception {
        int priority = 686;
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 378L;
        long heartbeat_taskPeriodMillis = 923L;
        long monitor_check_taskPeriodMillis = 751L;
        long monitor_publish_taskPeriodMillis = 299L;
        long monitor_update_taskPeriodMillis = 529L;
        long runtimeinfo_taskPeriodMillis = 171L;
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_PeriodicTasks_timersConfigurationEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_PeriodicTasks_timersConfigurationEvent));
        Bonn_shutter_PeriodicTasks_timersConfigurationEvent item_ = (Bonn_shutter_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasksConfigurationEvent() throws Exception {
        int priority = 412;
        String version = "v";
        int schedulers_default_nTasks = 375;
        int schedulers_default_nThreads = 653;
        int schedulers_monitor_update_publish_scheduler_nTasks = 264;
        int schedulers_monitor_update_publish_scheduler_nThreads = 100;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasksConfigurationEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasksConfigurationEvent));
        Daq_monitor_PeriodicTasksConfigurationEvent item_ = (Daq_monitor_PeriodicTasksConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasks_timersConfigurationEvent() throws Exception {
        int priority = 943;
        String version = "t";
        long agentmonitorservice_taskPeriodMillis = 299L;
        long heartbeat_taskPeriodMillis = 56L;
        long monitor_check_taskPeriodMillis = 404L;
        long monitor_publish_taskPeriodMillis = 560L;
        long monitor_update_taskPeriodMillis = 283L;
        long publishstats_taskPeriodMillis = 288L;
        long purgedaq_taskPeriodMillis = 935L;
        long runtimeinfo_taskPeriodMillis = 822L;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasks_timersConfigurationEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, publishstats_taskPeriodMillis, purgedaq_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasks_timersConfigurationEvent));
        Daq_monitor_PeriodicTasks_timersConfigurationEvent item_ = (Daq_monitor_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)publishstats_taskPeriodMillis, (long)item_.getPublishstats_taskPeriodMillis());
        Assert.assertEquals((long)purgedaq_taskPeriodMillis, (long)item_.getPurgedaq_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveDaq_monitor_Stats_StatisticsConfigurationEvent() throws Exception {
        int priority = 888;
        String version = "r";
        int minDiffAlertWarning = 270;
        int minDiffLogWarning = 991;
        String sumDriverChecks = "";
        String sumDriverStats = "g";
        String sumFirmwareChecks = "";
        String sumFirmwareStats = "";
        String sumRdsChecks = "l";
        String sumRdsStats = "g";
        String sumRmsChecks = "k";
        String sumRmsStats = "";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Stats_StatisticsConfigurationEvent(priority, version, minDiffAlertWarning, minDiffLogWarning, sumDriverChecks, sumDriverStats, sumFirmwareChecks, sumFirmwareStats, sumRdsChecks, sumRdsStats, sumRmsChecks, sumRmsStats));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Stats_StatisticsConfigurationEvent));
        Daq_monitor_Stats_StatisticsConfigurationEvent item_ = (Daq_monitor_Stats_StatisticsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)minDiffAlertWarning, (long)item_.getMinDiffAlertWarning());
        Assert.assertEquals((long)minDiffLogWarning, (long)item_.getMinDiffLogWarning());
        Assert.assertEquals((Object)sumDriverChecks, (Object)item_.getSumDriverChecks());
        Assert.assertEquals((Object)sumDriverStats, (Object)item_.getSumDriverStats());
        Assert.assertEquals((Object)sumFirmwareChecks, (Object)item_.getSumFirmwareChecks());
        Assert.assertEquals((Object)sumFirmwareStats, (Object)item_.getSumFirmwareStats());
        Assert.assertEquals((Object)sumRdsChecks, (Object)item_.getSumRdsChecks());
        Assert.assertEquals((Object)sumRdsStats, (Object)item_.getSumRdsStats());
        Assert.assertEquals((Object)sumRmsChecks, (Object)item_.getSumRmsChecks());
        Assert.assertEquals((Object)sumRmsStats, (Object)item_.getSumRmsStats());
    }

    @Test
    public void sendReceiveDaq_monitor_Stats_buildConfigurationEvent() throws Exception {
        int priority = 396;
        String version = "";
        boolean enablePeriodicPublication = true;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Stats_buildConfigurationEvent(priority, version, enablePeriodicPublication));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Stats_buildConfigurationEvent));
        Daq_monitor_Stats_buildConfigurationEvent item_ = (Daq_monitor_Stats_buildConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)enablePeriodicPublication, (Object)item_.isEnablePeriodicPublication());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreConfigurationEvent() throws Exception {
        int priority = 255;
        String version = "";
        int alarmPurgeFailures = 635;
        String daqPartition = "";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_StoreConfigurationEvent(priority, version, alarmPurgeFailures, daqPartition));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreConfigurationEvent));
        Daq_monitor_StoreConfigurationEvent item_ = (Daq_monitor_StoreConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)alarmPurgeFailures, (long)item_.getAlarmPurgeFailures());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
    }

    @Test
    public void sendReceiveDaq_monitor_Store_LimitsConfigurationEvent() throws Exception {
        int priority = 871;
        String version = "i";
        double capacity_warnHi = 0.5233348608016968;
        double capacity_warnLo = 0.6257666945457458;
        double capacity_limitHi = 0.17463302612304688;
        double capacity_limitLo = 0.6843522191047668;
        double freefraction_warnHi = 0.3546783924102783;
        double freefraction_warnLo = 0.46490478515625;
        double freefraction_limitHi = 0.10239458084106445;
        double freefraction_limitLo = 0.711392879486084;
        double freespace_warnHi = 0.16704648733139038;
        double freespace_warnLo = 0.2358495593070984;
        double freespace_limitHi = 0.6809166073799133;
        double freespace_limitLo = 0.5276538729667664;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_LimitsConfigurationEvent(priority, version, capacity_warnHi, capacity_warnLo, capacity_limitHi, capacity_limitLo, freefraction_warnHi, freefraction_warnLo, freefraction_limitHi, freefraction_limitLo, freespace_warnHi, freespace_warnLo, freespace_limitHi, freespace_limitLo));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_LimitsConfigurationEvent));
        Daq_monitor_Store_LimitsConfigurationEvent item_ = (Daq_monitor_Store_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)capacity_warnHi, (double)item_.getCapacity_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_warnLo, (double)item_.getCapacity_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_limitHi, (double)item_.getCapacity_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_limitLo, (double)item_.getCapacity_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_warnHi, (double)item_.getFreefraction_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_warnLo, (double)item_.getFreefraction_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_limitHi, (double)item_.getFreefraction_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_limitLo, (double)item_.getFreefraction_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_warnHi, (double)item_.getFreespace_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_warnLo, (double)item_.getFreespace_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_limitHi, (double)item_.getFreespace_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_limitLo, (double)item_.getFreespace_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Store_StoreConfigurationEvent() throws Exception {
        int priority = 979;
        String version = "t";
        String daqFolder = "";
        boolean enableAutoPurge = false;
        double purgeTarget = 0.08863133192062378;
        double purgeThreshold = 0.1820812225341797;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_StoreConfigurationEvent(priority, version, daqFolder, enableAutoPurge, purgeTarget, purgeThreshold));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_StoreConfigurationEvent));
        Daq_monitor_Store_StoreConfigurationEvent item_ = (Daq_monitor_Store_StoreConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)enableAutoPurge, (Object)item_.isEnableAutoPurge());
        Assert.assertEquals((double)purgeTarget, (double)item_.getPurgeTarget(), (double)1.0E-6f);
        Assert.assertEquals((double)purgeThreshold, (double)item_.getPurgeThreshold(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpowerConfigurationEvent() throws Exception {
        int priority = 523;
        String version = "u";
        long powerOffSleepMillis = 449L;
        SALEvent item = this.testSendReceive((SALEvent)new RebpowerConfigurationEvent(priority, version, powerOffSleepMillis));
        Assert.assertTrue((boolean)(item instanceof RebpowerConfigurationEvent));
        RebpowerConfigurationEvent item_ = (RebpowerConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)powerOffSleepMillis, (long)item_.getPowerOffSleepMillis());
    }

    @Test
    public void sendReceiveRebpower_EmergencyResponseManagerConfigurationEvent() throws Exception {
        int priority = 177;
        String version = "k";
        boolean processOnlyClearedAlerts = true;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_EmergencyResponseManagerConfigurationEvent(priority, version, processOnlyClearedAlerts));
        Assert.assertTrue((boolean)(item instanceof Rebpower_EmergencyResponseManagerConfigurationEvent));
        Rebpower_EmergencyResponseManagerConfigurationEvent item_ = (Rebpower_EmergencyResponseManagerConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)processOnlyClearedAlerts, (Object)item_.isProcessOnlyClearedAlerts());
    }

    @Test
    public void sendReceiveRebpower_PeriodicTasksConfigurationEvent() throws Exception {
        int priority = 945;
        String version = "";
        int schedulers_default_nTasks = 796;
        int schedulers_default_nThreads = 601;
        int schedulers_monitor_update_publish_scheduler_nTasks = 751;
        int schedulers_monitor_update_publish_scheduler_nThreads = 507;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_PeriodicTasksConfigurationEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Rebpower_PeriodicTasksConfigurationEvent));
        Rebpower_PeriodicTasksConfigurationEvent item_ = (Rebpower_PeriodicTasksConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveRebpower_PeriodicTasks_timersConfigurationEvent() throws Exception {
        int priority = 570;
        String version = "e";
        long agentmonitorservice_taskPeriodMillis = 562L;
        long heartbeat_taskPeriodMillis = 505L;
        long monitor_check_taskPeriodMillis = 704L;
        long monitor_publish_taskPeriodMillis = 523L;
        long monitor_update_taskPeriodMillis = 317L;
        long reb_power_state_taskPeriodMillis = 118L;
        long runtimeinfo_taskPeriodMillis = 268L;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_PeriodicTasks_timersConfigurationEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, reb_power_state_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Rebpower_PeriodicTasks_timersConfigurationEvent));
        Rebpower_PeriodicTasks_timersConfigurationEvent item_ = (Rebpower_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)reb_power_state_taskPeriodMillis, (long)item_.getReb_power_state_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveRebpower_RebConfigurationEvent() throws Exception {
        int priority = 923;
        String version = "";
        int[] hvBias = TestHelper.generateIntArray((int)3, (int)-2013622268);
        String location = "q";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_RebConfigurationEvent(priority, version, hvBias, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebConfigurationEvent));
        Rebpower_RebConfigurationEvent item_ = (Rebpower_RebConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((int[])hvBias, (int[])item_.getHvBias());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveRebpower_Reb_LimitsConfigurationEvent() throws Exception {
        int priority = 924;
        String version = "";
        double[] analog_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)1905892850);
        double[] analog_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)1771368512);
        double[] analog_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)697189083);
        double[] analog_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1574474500);
        double[] analog_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1518358220);
        double[] analog_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1841583134);
        double[] analog_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-479368371);
        double[] analog_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)43412650);
        double[] analog_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)1786689215);
        double[] analog_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)777614216);
        double[] analog_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-2127934901);
        double[] analog_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)10723707);
        double[] analog_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)3, (int)1376996146);
        double[] analog_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)3, (int)-2012597537);
        double[] analog_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1052850471);
        double[] analog_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)3, (int)1694557525);
        double[] analog_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)676255411);
        double[] analog_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)1906888320);
        double[] analog_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)228040645);
        double[] analog_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1761243351);
        double[] clockhi_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)1560491078);
        double[] clockhi_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)1596644030);
        double[] clockhi_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)579163424);
        double[] clockhi_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-235925162);
        double[] clockhi_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)19987042);
        double[] clockhi_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1548060002);
        double[] clockhi_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1756515094);
        double[] clockhi_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)2100861519);
        double[] clockhi_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)-843499327);
        double[] clockhi_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-748639450);
        double[] clockhi_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-839057652);
        double[] clockhi_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1411736710);
        double[] clockhi_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1223901321);
        double[] clockhi_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)3, (int)-51216678);
        double[] clockhi_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)3, (int)378590346);
        double[] clockhi_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)3, (int)-2072683941);
        double[] clockhi_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)1252016966);
        double[] clockhi_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)580390275);
        double[] clockhi_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)1015440888);
        double[] clockhi_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)260173809);
        double[] clocklo_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)1200485168);
        double[] clocklo_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1620304846);
        double[] clocklo_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1736927955);
        double[] clocklo_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)333404768);
        double[] clocklo_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)960648012);
        double[] clocklo_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-484458108);
        double[] clocklo_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)1628569142);
        double[] clocklo_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-623147825);
        double[] clocklo_VaftLDO2_warnHi = TestHelper.generateDoubleArray((int)3, (int)177959133);
        double[] clocklo_VaftLDO2_warnLo = TestHelper.generateDoubleArray((int)3, (int)2038270502);
        double[] clocklo_VaftLDO2_limitHi = TestHelper.generateDoubleArray((int)3, (int)-765322355);
        double[] clocklo_VaftLDO2_limitLo = TestHelper.generateDoubleArray((int)3, (int)-437622381);
        double[] clocklo_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1631665248);
        double[] clocklo_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-681844325);
        double[] clocklo_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-941360757);
        double[] clocklo_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1884638580);
        double[] clocklo_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)3, (int)475746404);
        double[] clocklo_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)3, (int)155632444);
        double[] clocklo_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)3, (int)930622746);
        double[] clocklo_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)3, (int)-2115404849);
        double[] clocklo_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)894623968);
        double[] clocklo_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1910179968);
        double[] clocklo_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)830144942);
        double[] clocklo_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1588781947);
        double[] digital_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)-652319552);
        double[] digital_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)1369268605);
        double[] digital_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)1866142325);
        double[] digital_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1754719726);
        double[] digital_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)1223610368);
        double[] digital_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1824186194);
        double[] digital_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)1285800652);
        double[] digital_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-344217223);
        double[] digital_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)-489878915);
        double[] digital_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)1223133942);
        double[] digital_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)1060260341);
        double[] digital_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1288215810);
        double[] digital_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)3, (int)1913701577);
        double[] digital_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)3, (int)801456869);
        double[] digital_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)3, (int)1518552583);
        double[] digital_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)3, (int)1174539276);
        double[] digital_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1062255042);
        double[] digital_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-893915591);
        double[] digital_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)1429342757);
        double[] digital_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)540777305);
        double[] heater_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)861964373);
        double[] heater_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)1039945894);
        double[] heater_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)1453464562);
        double[] heater_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-944841913);
        double[] heater_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1414909128);
        double[] heater_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1656959271);
        double[] heater_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-488729533);
        double[] heater_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)679431821);
        double[] heater_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)-742043755);
        double[] heater_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)1636998586);
        double[] heater_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1270720746);
        double[] heater_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1862386922);
        double[] heater_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)3, (int)-2108898892);
        double[] heater_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)3, (int)1809064433);
        double[] heater_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1504225597);
        double[] heater_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)3, (int)1426784040);
        double[] heater_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1947213365);
        double[] heater_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)132858796);
        double[] heater_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-511027599);
        double[] heater_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-985590583);
        double[] hvbias_IbefSwch_warnHi = TestHelper.generateDoubleArray((int)3, (int)826656145);
        double[] hvbias_IbefSwch_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1336493410);
        double[] hvbias_IbefSwch_limitHi = TestHelper.generateDoubleArray((int)3, (int)-818683957);
        double[] hvbias_IbefSwch_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1116182691);
        double[] hvbias_VbefSwch_warnHi = TestHelper.generateDoubleArray((int)3, (int)1133711120);
        double[] hvbias_VbefSwch_warnLo = TestHelper.generateDoubleArray((int)3, (int)-240806326);
        double[] hvbias_VbefSwch_limitHi = TestHelper.generateDoubleArray((int)3, (int)-2008129550);
        double[] hvbias_VbefSwch_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1354571885);
        String location = "";
        double[] od_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)1693222528);
        double[] od_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)708616116);
        double[] od_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-228832894);
        double[] od_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1480296753);
        double[] od_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1440176088);
        double[] od_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-209515778);
        double[] od_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-324011762);
        double[] od_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)55276997);
        double[] od_VaftLDO2_warnHi = TestHelper.generateDoubleArray((int)3, (int)8116797);
        double[] od_VaftLDO2_warnLo = TestHelper.generateDoubleArray((int)3, (int)562658191);
        double[] od_VaftLDO2_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1880502128);
        double[] od_VaftLDO2_limitLo = TestHelper.generateDoubleArray((int)3, (int)1497341512);
        double[] od_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)1047191324);
        double[] od_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)396524270);
        double[] od_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-507605578);
        double[] od_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1777983941);
        double[] od_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1341796865);
        double[] od_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)3, (int)1777348510);
        double[] od_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)3, (int)275873958);
        double[] od_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)3, (int)1317361422);
        double[] od_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1201170237);
        double[] od_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)2072930703);
        double[] od_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1529081495);
        double[] od_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)2137030993);
        double[] power_warnHi = TestHelper.generateDoubleArray((int)3, (int)-142497295);
        double[] power_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1444118058);
        double[] power_limitHi = TestHelper.generateDoubleArray((int)3, (int)144553863);
        double[] power_limitLo = TestHelper.generateDoubleArray((int)3, (int)1259435401);
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Reb_LimitsConfigurationEvent(priority, version, analog_IaftLDO_warnHi, analog_IaftLDO_warnLo, analog_IaftLDO_limitHi, analog_IaftLDO_limitLo, analog_IbefLDO_warnHi, analog_IbefLDO_warnLo, analog_IbefLDO_limitHi, analog_IbefLDO_limitLo, analog_VaftLDO_warnHi, analog_VaftLDO_warnLo, analog_VaftLDO_limitHi, analog_VaftLDO_limitLo, analog_VaftSwch_warnHi, analog_VaftSwch_warnLo, analog_VaftSwch_limitHi, analog_VaftSwch_limitLo, analog_VbefLDO_warnHi, analog_VbefLDO_warnLo, analog_VbefLDO_limitHi, analog_VbefLDO_limitLo, clockhi_IaftLDO_warnHi, clockhi_IaftLDO_warnLo, clockhi_IaftLDO_limitHi, clockhi_IaftLDO_limitLo, clockhi_IbefLDO_warnHi, clockhi_IbefLDO_warnLo, clockhi_IbefLDO_limitHi, clockhi_IbefLDO_limitLo, clockhi_VaftLDO_warnHi, clockhi_VaftLDO_warnLo, clockhi_VaftLDO_limitHi, clockhi_VaftLDO_limitLo, clockhi_VaftSwch_warnHi, clockhi_VaftSwch_warnLo, clockhi_VaftSwch_limitHi, clockhi_VaftSwch_limitLo, clockhi_VbefLDO_warnHi, clockhi_VbefLDO_warnLo, clockhi_VbefLDO_limitHi, clockhi_VbefLDO_limitLo, clocklo_IaftLDO_warnHi, clocklo_IaftLDO_warnLo, clocklo_IaftLDO_limitHi, clocklo_IaftLDO_limitLo, clocklo_IbefLDO_warnHi, clocklo_IbefLDO_warnLo, clocklo_IbefLDO_limitHi, clocklo_IbefLDO_limitLo, clocklo_VaftLDO2_warnHi, clocklo_VaftLDO2_warnLo, clocklo_VaftLDO2_limitHi, clocklo_VaftLDO2_limitLo, clocklo_VaftLDO_warnHi, clocklo_VaftLDO_warnLo, clocklo_VaftLDO_limitHi, clocklo_VaftLDO_limitLo, clocklo_VaftSwch_warnHi, clocklo_VaftSwch_warnLo, clocklo_VaftSwch_limitHi, clocklo_VaftSwch_limitLo, clocklo_VbefLDO_warnHi, clocklo_VbefLDO_warnLo, clocklo_VbefLDO_limitHi, clocklo_VbefLDO_limitLo, digital_IaftLDO_warnHi, digital_IaftLDO_warnLo, digital_IaftLDO_limitHi, digital_IaftLDO_limitLo, digital_IbefLDO_warnHi, digital_IbefLDO_warnLo, digital_IbefLDO_limitHi, digital_IbefLDO_limitLo, digital_VaftLDO_warnHi, digital_VaftLDO_warnLo, digital_VaftLDO_limitHi, digital_VaftLDO_limitLo, digital_VaftSwch_warnHi, digital_VaftSwch_warnLo, digital_VaftSwch_limitHi, digital_VaftSwch_limitLo, digital_VbefLDO_warnHi, digital_VbefLDO_warnLo, digital_VbefLDO_limitHi, digital_VbefLDO_limitLo, heater_IaftLDO_warnHi, heater_IaftLDO_warnLo, heater_IaftLDO_limitHi, heater_IaftLDO_limitLo, heater_IbefLDO_warnHi, heater_IbefLDO_warnLo, heater_IbefLDO_limitHi, heater_IbefLDO_limitLo, heater_VaftLDO_warnHi, heater_VaftLDO_warnLo, heater_VaftLDO_limitHi, heater_VaftLDO_limitLo, heater_VaftSwch_warnHi, heater_VaftSwch_warnLo, heater_VaftSwch_limitHi, heater_VaftSwch_limitLo, heater_VbefLDO_warnHi, heater_VbefLDO_warnLo, heater_VbefLDO_limitHi, heater_VbefLDO_limitLo, hvbias_IbefSwch_warnHi, hvbias_IbefSwch_warnLo, hvbias_IbefSwch_limitHi, hvbias_IbefSwch_limitLo, hvbias_VbefSwch_warnHi, hvbias_VbefSwch_warnLo, hvbias_VbefSwch_limitHi, hvbias_VbefSwch_limitLo, location, od_IaftLDO_warnHi, od_IaftLDO_warnLo, od_IaftLDO_limitHi, od_IaftLDO_limitLo, od_IbefLDO_warnHi, od_IbefLDO_warnLo, od_IbefLDO_limitHi, od_IbefLDO_limitLo, od_VaftLDO2_warnHi, od_VaftLDO2_warnLo, od_VaftLDO2_limitHi, od_VaftLDO2_limitLo, od_VaftLDO_warnHi, od_VaftLDO_warnLo, od_VaftLDO_limitHi, od_VaftLDO_limitLo, od_VaftSwch_warnHi, od_VaftSwch_warnLo, od_VaftSwch_limitHi, od_VaftSwch_limitLo, od_VbefLDO_warnHi, od_VbefLDO_warnLo, od_VbefLDO_limitHi, od_VbefLDO_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Reb_LimitsConfigurationEvent));
        Rebpower_Reb_LimitsConfigurationEvent item_ = (Rebpower_Reb_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])analog_IaftLDO_warnHi, (double[])item_.getAnalog_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_warnLo, (double[])item_.getAnalog_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_limitHi, (double[])item_.getAnalog_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_limitLo, (double[])item_.getAnalog_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_warnHi, (double[])item_.getAnalog_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_warnLo, (double[])item_.getAnalog_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_limitHi, (double[])item_.getAnalog_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_limitLo, (double[])item_.getAnalog_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_warnHi, (double[])item_.getAnalog_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_warnLo, (double[])item_.getAnalog_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_limitHi, (double[])item_.getAnalog_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_limitLo, (double[])item_.getAnalog_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_warnHi, (double[])item_.getAnalog_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_warnLo, (double[])item_.getAnalog_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_limitHi, (double[])item_.getAnalog_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_limitLo, (double[])item_.getAnalog_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_warnHi, (double[])item_.getAnalog_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_warnLo, (double[])item_.getAnalog_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_limitHi, (double[])item_.getAnalog_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_limitLo, (double[])item_.getAnalog_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_warnHi, (double[])item_.getClockhi_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_warnLo, (double[])item_.getClockhi_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_limitHi, (double[])item_.getClockhi_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_limitLo, (double[])item_.getClockhi_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_warnHi, (double[])item_.getClockhi_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_warnLo, (double[])item_.getClockhi_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_limitHi, (double[])item_.getClockhi_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_limitLo, (double[])item_.getClockhi_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_warnHi, (double[])item_.getClockhi_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_warnLo, (double[])item_.getClockhi_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_limitHi, (double[])item_.getClockhi_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_limitLo, (double[])item_.getClockhi_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_warnHi, (double[])item_.getClockhi_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_warnLo, (double[])item_.getClockhi_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_limitHi, (double[])item_.getClockhi_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_limitLo, (double[])item_.getClockhi_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_warnHi, (double[])item_.getClockhi_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_warnLo, (double[])item_.getClockhi_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_limitHi, (double[])item_.getClockhi_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_limitLo, (double[])item_.getClockhi_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_warnHi, (double[])item_.getClocklo_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_warnLo, (double[])item_.getClocklo_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_limitHi, (double[])item_.getClocklo_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_limitLo, (double[])item_.getClocklo_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_warnHi, (double[])item_.getClocklo_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_warnLo, (double[])item_.getClocklo_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_limitHi, (double[])item_.getClocklo_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_limitLo, (double[])item_.getClocklo_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_warnHi, (double[])item_.getClocklo_VaftLDO2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_warnLo, (double[])item_.getClocklo_VaftLDO2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_limitHi, (double[])item_.getClocklo_VaftLDO2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_limitLo, (double[])item_.getClocklo_VaftLDO2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_warnHi, (double[])item_.getClocklo_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_warnLo, (double[])item_.getClocklo_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_limitHi, (double[])item_.getClocklo_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_limitLo, (double[])item_.getClocklo_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_warnHi, (double[])item_.getClocklo_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_warnLo, (double[])item_.getClocklo_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_limitHi, (double[])item_.getClocklo_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_limitLo, (double[])item_.getClocklo_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_warnHi, (double[])item_.getClocklo_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_warnLo, (double[])item_.getClocklo_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_limitHi, (double[])item_.getClocklo_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_limitLo, (double[])item_.getClocklo_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_warnHi, (double[])item_.getDigital_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_warnLo, (double[])item_.getDigital_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_limitHi, (double[])item_.getDigital_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_limitLo, (double[])item_.getDigital_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_warnHi, (double[])item_.getDigital_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_warnLo, (double[])item_.getDigital_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_limitHi, (double[])item_.getDigital_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_limitLo, (double[])item_.getDigital_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_warnHi, (double[])item_.getDigital_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_warnLo, (double[])item_.getDigital_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_limitHi, (double[])item_.getDigital_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_limitLo, (double[])item_.getDigital_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_warnHi, (double[])item_.getDigital_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_warnLo, (double[])item_.getDigital_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_limitHi, (double[])item_.getDigital_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_limitLo, (double[])item_.getDigital_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_warnHi, (double[])item_.getDigital_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_warnLo, (double[])item_.getDigital_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_limitHi, (double[])item_.getDigital_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_limitLo, (double[])item_.getDigital_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_warnHi, (double[])item_.getHeater_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_warnLo, (double[])item_.getHeater_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_limitHi, (double[])item_.getHeater_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_limitLo, (double[])item_.getHeater_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_warnHi, (double[])item_.getHeater_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_warnLo, (double[])item_.getHeater_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_limitHi, (double[])item_.getHeater_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_limitLo, (double[])item_.getHeater_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_warnHi, (double[])item_.getHeater_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_warnLo, (double[])item_.getHeater_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_limitHi, (double[])item_.getHeater_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_limitLo, (double[])item_.getHeater_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_warnHi, (double[])item_.getHeater_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_warnLo, (double[])item_.getHeater_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_limitHi, (double[])item_.getHeater_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_limitLo, (double[])item_.getHeater_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_warnHi, (double[])item_.getHeater_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_warnLo, (double[])item_.getHeater_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_limitHi, (double[])item_.getHeater_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_limitLo, (double[])item_.getHeater_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_warnHi, (double[])item_.getHvbias_IbefSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_warnLo, (double[])item_.getHvbias_IbefSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_limitHi, (double[])item_.getHvbias_IbefSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_limitLo, (double[])item_.getHvbias_IbefSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_warnHi, (double[])item_.getHvbias_VbefSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_warnLo, (double[])item_.getHvbias_VbefSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_limitHi, (double[])item_.getHvbias_VbefSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_limitLo, (double[])item_.getHvbias_VbefSwch_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO_warnHi, (double[])item_.getOd_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_warnLo, (double[])item_.getOd_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_limitHi, (double[])item_.getOd_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_limitLo, (double[])item_.getOd_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_warnHi, (double[])item_.getOd_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_warnLo, (double[])item_.getOd_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_limitHi, (double[])item_.getOd_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_limitLo, (double[])item_.getOd_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_warnHi, (double[])item_.getOd_VaftLDO2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_warnLo, (double[])item_.getOd_VaftLDO2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_limitHi, (double[])item_.getOd_VaftLDO2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_limitLo, (double[])item_.getOd_VaftLDO2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_warnHi, (double[])item_.getOd_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_warnLo, (double[])item_.getOd_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_limitHi, (double[])item_.getOd_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_limitLo, (double[])item_.getOd_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_warnHi, (double[])item_.getOd_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_warnLo, (double[])item_.getOd_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_limitHi, (double[])item_.getOd_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_limitLo, (double[])item_.getOd_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_warnHi, (double[])item_.getOd_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_warnLo, (double[])item_.getOd_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_limitHi, (double[])item_.getOd_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_limitLo, (double[])item_.getOd_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnHi, (double[])item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnLo, (double[])item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitHi, (double[])item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitLo, (double[])item_.getPower_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_Rebps_LimitsConfigurationEvent() throws Exception {
        int priority = 301;
        String version = "c";
        double[] boardtemp0_warnHi = TestHelper.generateDoubleArray((int)1, (int)999665223);
        double[] boardtemp0_warnLo = TestHelper.generateDoubleArray((int)1, (int)-452369723);
        double[] boardtemp0_limitHi = TestHelper.generateDoubleArray((int)1, (int)23872612);
        double[] boardtemp0_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1852916457);
        double[] boardtemp1_warnHi = TestHelper.generateDoubleArray((int)1, (int)2048972661);
        double[] boardtemp1_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1913967513);
        double[] boardtemp1_limitHi = TestHelper.generateDoubleArray((int)1, (int)-929134249);
        double[] boardtemp1_limitLo = TestHelper.generateDoubleArray((int)1, (int)1720638826);
        double[] boardtemp2_warnHi = TestHelper.generateDoubleArray((int)1, (int)1939373811);
        double[] boardtemp2_warnLo = TestHelper.generateDoubleArray((int)1, (int)-915855823);
        double[] boardtemp2_limitHi = TestHelper.generateDoubleArray((int)1, (int)489236517);
        double[] boardtemp2_limitLo = TestHelper.generateDoubleArray((int)1, (int)1194877921);
        double[] boardtemp3_warnHi = TestHelper.generateDoubleArray((int)1, (int)-792610206);
        double[] boardtemp3_warnLo = TestHelper.generateDoubleArray((int)1, (int)-825147154);
        double[] boardtemp3_limitHi = TestHelper.generateDoubleArray((int)1, (int)81386717);
        double[] boardtemp3_limitLo = TestHelper.generateDoubleArray((int)1, (int)1515491052);
        double[] boardtemp4_warnHi = TestHelper.generateDoubleArray((int)1, (int)-297609666);
        double[] boardtemp4_warnLo = TestHelper.generateDoubleArray((int)1, (int)-110889107);
        double[] boardtemp4_limitHi = TestHelper.generateDoubleArray((int)1, (int)1803181868);
        double[] boardtemp4_limitLo = TestHelper.generateDoubleArray((int)1, (int)-341624428);
        double[] boardtemp5_warnHi = TestHelper.generateDoubleArray((int)1, (int)-668442062);
        double[] boardtemp5_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1635908036);
        double[] boardtemp5_limitHi = TestHelper.generateDoubleArray((int)1, (int)777894093);
        double[] boardtemp5_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1650138398);
        double[] boardtemp6_warnHi = TestHelper.generateDoubleArray((int)1, (int)-2017579353);
        double[] boardtemp6_warnLo = TestHelper.generateDoubleArray((int)1, (int)1933532086);
        double[] boardtemp6_limitHi = TestHelper.generateDoubleArray((int)1, (int)466095936);
        double[] boardtemp6_limitLo = TestHelper.generateDoubleArray((int)1, (int)1911768961);
        String location = "a";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_LimitsConfigurationEvent(priority, version, boardtemp0_warnHi, boardtemp0_warnLo, boardtemp0_limitHi, boardtemp0_limitLo, boardtemp1_warnHi, boardtemp1_warnLo, boardtemp1_limitHi, boardtemp1_limitLo, boardtemp2_warnHi, boardtemp2_warnLo, boardtemp2_limitHi, boardtemp2_limitLo, boardtemp3_warnHi, boardtemp3_warnLo, boardtemp3_limitHi, boardtemp3_limitLo, boardtemp4_warnHi, boardtemp4_warnLo, boardtemp4_limitHi, boardtemp4_limitLo, boardtemp5_warnHi, boardtemp5_warnLo, boardtemp5_limitHi, boardtemp5_limitLo, boardtemp6_warnHi, boardtemp6_warnLo, boardtemp6_limitHi, boardtemp6_limitLo, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_LimitsConfigurationEvent));
        Rebpower_Rebps_LimitsConfigurationEvent item_ = (Rebpower_Rebps_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])boardtemp0_warnHi, (double[])item_.getBoardtemp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_warnLo, (double[])item_.getBoardtemp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_limitHi, (double[])item_.getBoardtemp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_limitLo, (double[])item_.getBoardtemp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_warnHi, (double[])item_.getBoardtemp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_warnLo, (double[])item_.getBoardtemp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_limitHi, (double[])item_.getBoardtemp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_limitLo, (double[])item_.getBoardtemp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_warnHi, (double[])item_.getBoardtemp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_warnLo, (double[])item_.getBoardtemp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_limitHi, (double[])item_.getBoardtemp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_limitLo, (double[])item_.getBoardtemp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_warnHi, (double[])item_.getBoardtemp3_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_warnLo, (double[])item_.getBoardtemp3_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_limitHi, (double[])item_.getBoardtemp3_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_limitLo, (double[])item_.getBoardtemp3_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_warnHi, (double[])item_.getBoardtemp4_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_warnLo, (double[])item_.getBoardtemp4_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_limitHi, (double[])item_.getBoardtemp4_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_limitLo, (double[])item_.getBoardtemp4_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_warnHi, (double[])item_.getBoardtemp5_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_warnLo, (double[])item_.getBoardtemp5_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_limitHi, (double[])item_.getBoardtemp5_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_limitLo, (double[])item_.getBoardtemp5_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_warnHi, (double[])item_.getBoardtemp6_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_warnLo, (double[])item_.getBoardtemp6_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_limitHi, (double[])item_.getBoardtemp6_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_limitLo, (double[])item_.getBoardtemp6_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveRebpower_Rebps_PowerConfigurationEvent() throws Exception {
        int priority = 596;
        String version = "z";
        String ipAddr = "";
        String location = "n";
        int[] nPowerOnPub = TestHelper.generateIntArray((int)1, (int)-1715452240);
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_PowerConfigurationEvent(priority, version, ipAddr, location, nPowerOnPub));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_PowerConfigurationEvent));
        Rebpower_Rebps_PowerConfigurationEvent item_ = (Rebpower_Rebps_PowerConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)ipAddr, (Object)item_.getIpAddr());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((int[])nPowerOnPub, (int[])item_.getNPowerOnPub());
    }

    @Test
    public void sendReceiveVacuum_Cold1_CryoconConfigurationEvent() throws Exception {
        int priority = 726;
        String version = "f";
        double d_gain = 0.7907758355140686;
        double i_gain = 0.450225293636322;
        double p_gain = 0.19921225309371948;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cold1_CryoconConfigurationEvent(priority, version, d_gain, i_gain, p_gain));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold1_CryoconConfigurationEvent));
        Vacuum_Cold1_CryoconConfigurationEvent item_ = (Vacuum_Cold1_CryoconConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)d_gain, (double)item_.getD_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)i_gain, (double)item_.getI_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)p_gain, (double)item_.getP_gain(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold1_LimitsConfigurationEvent() throws Exception {
        int priority = 300;
        String version = "o";
        double autooffenabled_warnHi = 0.5766582489013672;
        double autooffenabled_warnLo = 0.3993929f;
        double autooffenabled_limitHi = 0.9301658272743225;
        double autooffenabled_limitLo = 0.380687f;
        double autoofftemperature_warnHi = 0.5195137858390808;
        double autoofftemperature_warnLo = 0.4002823829650879;
        double autoofftemperature_limitHi = 0.37163597345352173;
        double autoofftemperature_limitLo = 0.8927491903305054;
        double autoontemperature_warnHi = 0.6827614307403564;
        double autoontemperature_warnLo = 0.16119670867919922;
        double autoontemperature_limitHi = 0.9963732957839966;
        double autoontemperature_limitLo = 0.07531487941741943;
        double power_warnHi = 0.2367112f;
        double power_warnLo = 0.6531934142112732;
        double power_limitHi = 0.3906674385070801;
        double power_limitLo = 0.2345457673072815;
        double rejecttemperature_warnHi = 0.482200026512146;
        double rejecttemperature_warnLo = 0.2835758328437805;
        double rejecttemperature_limitHi = 0.8459919691085815;
        double rejecttemperature_limitLo = 0.2846637964248657;
        double setpower_warnHi = 0.5211543440818787;
        double setpower_warnLo = 0.7494170665740967;
        double setpower_limitHi = 0.29583287239074707;
        double setpower_limitLo = 0.25458717346191406;
        double setpoint_warnHi = 0.2159196138381958;
        double setpoint_warnLo = 0.07165837287902832;
        double setpoint_limitHi = 0.53737473487854;
        double setpoint_limitLo = 0.3688596487045288;
        double temp_Min_OFF = 0.7609010338783264;
        double temp_Min_ON = 0.2154766321182251;
        double temperature_warnHi = 0.4796936511993408;
        double temperature_warnLo = 0.380581796169281;
        double temperature_limitHi = 0.8659494519233704;
        double temperature_limitLo = 0.8885037302970886;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cold1_LimitsConfigurationEvent(priority, version, autooffenabled_warnHi, autooffenabled_warnLo, autooffenabled_limitHi, autooffenabled_limitLo, autoofftemperature_warnHi, autoofftemperature_warnLo, autoofftemperature_limitHi, autoofftemperature_limitLo, autoontemperature_warnHi, autoontemperature_warnLo, autoontemperature_limitHi, autoontemperature_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo, rejecttemperature_warnHi, rejecttemperature_warnLo, rejecttemperature_limitHi, rejecttemperature_limitLo, setpower_warnHi, setpower_warnLo, setpower_limitHi, setpower_limitLo, setpoint_warnHi, setpoint_warnLo, setpoint_limitHi, setpoint_limitLo, temp_Min_OFF, temp_Min_ON, temperature_warnHi, temperature_warnLo, temperature_limitHi, temperature_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold1_LimitsConfigurationEvent));
        Vacuum_Cold1_LimitsConfigurationEvent item_ = (Vacuum_Cold1_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)autooffenabled_warnHi, (double)item_.getAutooffenabled_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_warnLo, (double)item_.getAutooffenabled_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_limitHi, (double)item_.getAutooffenabled_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_limitLo, (double)item_.getAutooffenabled_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_warnHi, (double)item_.getAutoofftemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_warnLo, (double)item_.getAutoofftemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_limitHi, (double)item_.getAutoofftemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_limitLo, (double)item_.getAutoofftemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_warnHi, (double)item_.getAutoontemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_warnLo, (double)item_.getAutoontemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_limitHi, (double)item_.getAutoontemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_limitLo, (double)item_.getAutoontemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)power_warnHi, (double)item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)power_warnLo, (double)item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)power_limitHi, (double)item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)power_limitLo, (double)item_.getPower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_warnHi, (double)item_.getRejecttemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_warnLo, (double)item_.getRejecttemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_limitHi, (double)item_.getRejecttemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_limitLo, (double)item_.getRejecttemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_warnHi, (double)item_.getSetpower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_warnLo, (double)item_.getSetpower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_limitHi, (double)item_.getSetpower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_limitLo, (double)item_.getSetpower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_warnHi, (double)item_.getSetpoint_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_warnLo, (double)item_.getSetpoint_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_limitHi, (double)item_.getSetpoint_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_limitLo, (double)item_.getSetpoint_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temp_Min_OFF, (double)item_.getTemp_Min_OFF(), (double)1.0E-6f);
        Assert.assertEquals((double)temp_Min_ON, (double)item_.getTemp_Min_ON(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_warnHi, (double)item_.getTemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_warnLo, (double)item_.getTemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_limitHi, (double)item_.getTemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_limitLo, (double)item_.getTemperature_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold2_CryoconConfigurationEvent() throws Exception {
        int priority = 138;
        String version = "";
        double d_gain = 0.7315186858177185;
        double i_gain = 0.02538210153579712;
        double p_gain = 0.5617164969444275;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cold2_CryoconConfigurationEvent(priority, version, d_gain, i_gain, p_gain));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold2_CryoconConfigurationEvent));
        Vacuum_Cold2_CryoconConfigurationEvent item_ = (Vacuum_Cold2_CryoconConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)d_gain, (double)item_.getD_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)i_gain, (double)item_.getI_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)p_gain, (double)item_.getP_gain(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold2_LimitsConfigurationEvent() throws Exception {
        int priority = 451;
        String version = "";
        double autooffenabled_warnHi = 0.17073094844818115;
        double autooffenabled_warnLo = 0.08198577165603638;
        double autooffenabled_limitHi = 0.10556250810623169;
        double autooffenabled_limitLo = 0.300825834274292;
        double autoofftemperature_warnHi = 0.15915173292160034;
        double autoofftemperature_warnLo = 0.4622097f;
        double autoofftemperature_limitHi = 0.021161377429962158;
        double autoofftemperature_limitLo = 0.5130382180213928;
        double autoontemperature_warnHi = 0.7473477721214294;
        double autoontemperature_warnLo = 0.6755883693695068;
        double autoontemperature_limitHi = 0.5228105187416077;
        double autoontemperature_limitLo = 0.037378907203674316;
        double power_warnHi = 0.9072979688644409;
        double power_warnLo = 0.9558776617050171;
        double power_limitHi = 0.688093900680542;
        double power_limitLo = 0.7588313817977905;
        double rejecttemperature_warnHi = 0.4588811993598938;
        double rejecttemperature_warnLo = 0.3201286196708679;
        double rejecttemperature_limitHi = 0.3820696473121643;
        double rejecttemperature_limitLo = 0.7292030453681946;
        double setpower_warnHi = 0.36418086290359497;
        double setpower_warnLo = 0.02814584970474243;
        double setpower_limitHi = 0.382207453250885;
        double setpower_limitLo = 0.12228578329086304;
        double setpoint_warnHi = 0.973324716091156;
        double setpoint_warnLo = 0.38076627254486084;
        double setpoint_limitHi = 0.6869021058082581;
        double setpoint_limitLo = 0.6132139563560486;
        double temp_Min_OFF = 0.5931679606437683;
        double temp_Min_ON = 0.22166311740875244;
        double temperature_warnHi = 0.04742974042892456;
        double temperature_warnLo = 0.6217074990272522;
        double temperature_limitHi = 0.1260806918144226;
        double temperature_limitLo = 0.41364985704421997;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cold2_LimitsConfigurationEvent(priority, version, autooffenabled_warnHi, autooffenabled_warnLo, autooffenabled_limitHi, autooffenabled_limitLo, autoofftemperature_warnHi, autoofftemperature_warnLo, autoofftemperature_limitHi, autoofftemperature_limitLo, autoontemperature_warnHi, autoontemperature_warnLo, autoontemperature_limitHi, autoontemperature_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo, rejecttemperature_warnHi, rejecttemperature_warnLo, rejecttemperature_limitHi, rejecttemperature_limitLo, setpower_warnHi, setpower_warnLo, setpower_limitHi, setpower_limitLo, setpoint_warnHi, setpoint_warnLo, setpoint_limitHi, setpoint_limitLo, temp_Min_OFF, temp_Min_ON, temperature_warnHi, temperature_warnLo, temperature_limitHi, temperature_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold2_LimitsConfigurationEvent));
        Vacuum_Cold2_LimitsConfigurationEvent item_ = (Vacuum_Cold2_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)autooffenabled_warnHi, (double)item_.getAutooffenabled_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_warnLo, (double)item_.getAutooffenabled_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_limitHi, (double)item_.getAutooffenabled_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_limitLo, (double)item_.getAutooffenabled_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_warnHi, (double)item_.getAutoofftemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_warnLo, (double)item_.getAutoofftemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_limitHi, (double)item_.getAutoofftemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_limitLo, (double)item_.getAutoofftemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_warnHi, (double)item_.getAutoontemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_warnLo, (double)item_.getAutoontemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_limitHi, (double)item_.getAutoontemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_limitLo, (double)item_.getAutoontemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)power_warnHi, (double)item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)power_warnLo, (double)item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)power_limitHi, (double)item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)power_limitLo, (double)item_.getPower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_warnHi, (double)item_.getRejecttemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_warnLo, (double)item_.getRejecttemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_limitHi, (double)item_.getRejecttemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_limitLo, (double)item_.getRejecttemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_warnHi, (double)item_.getSetpower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_warnLo, (double)item_.getSetpower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_limitHi, (double)item_.getSetpower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_limitLo, (double)item_.getSetpower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_warnHi, (double)item_.getSetpoint_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_warnLo, (double)item_.getSetpoint_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_limitHi, (double)item_.getSetpoint_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_limitLo, (double)item_.getSetpoint_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temp_Min_OFF, (double)item_.getTemp_Min_OFF(), (double)1.0E-6f);
        Assert.assertEquals((double)temp_Min_ON, (double)item_.getTemp_Min_ON(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_warnHi, (double)item_.getTemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_warnLo, (double)item_.getTemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_limitHi, (double)item_.getTemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_limitLo, (double)item_.getTemperature_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cryo_CryoconConfigurationEvent() throws Exception {
        int priority = 581;
        String version = "";
        double d_gain = 0.01783144474029541;
        double i_gain = 0.4308992028236389;
        double p_gain = 0.5011999607086182;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cryo_CryoconConfigurationEvent(priority, version, d_gain, i_gain, p_gain));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cryo_CryoconConfigurationEvent));
        Vacuum_Cryo_CryoconConfigurationEvent item_ = (Vacuum_Cryo_CryoconConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)d_gain, (double)item_.getD_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)i_gain, (double)item_.getI_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)p_gain, (double)item_.getP_gain(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cryo_LimitsConfigurationEvent() throws Exception {
        int priority = 954;
        String version = "";
        double autooffenabled_warnHi = 0.14174103736877441;
        double autooffenabled_warnLo = 0.8059961199760437;
        double autooffenabled_limitHi = 0.6128490567207336;
        double autooffenabled_limitLo = 0.6959515810012817;
        double autoofftemperature_warnHi = 0.2795097231864929;
        double autoofftemperature_warnLo = 0.8401201963424683;
        double autoofftemperature_limitHi = 0.8434627056121826;
        double autoofftemperature_limitLo = 0.03871506452560425;
        double autoontemperature_warnHi = 0.01616931f;
        double autoontemperature_warnLo = 0.42615455389022827;
        double autoontemperature_limitHi = 0.3754054307937622;
        double autoontemperature_limitLo = 0.2668830156326294;
        double power_warnHi = 0.29815244674682617;
        double power_warnLo = 0.3598290681838989;
        double power_limitHi = 0.8939803838729858;
        double power_limitLo = 0.4671194553375244;
        double rejecttemperature_warnHi = 0.08714598417282104;
        double rejecttemperature_warnLo = 0.6992331743240356;
        double rejecttemperature_limitHi = 0.4956783652305603;
        double rejecttemperature_limitLo = 0.5278825759887695;
        double setpower_warnHi = 0.6096928715705872;
        double setpower_warnLo = 0.6548991799354553;
        double setpower_limitHi = 0.564589f;
        double setpower_limitLo = 0.9360262751579285;
        double setpoint_warnHi = 0.9758511185646057;
        double setpoint_warnLo = 0.6161421537399292;
        double setpoint_limitHi = 0.6513291001319885;
        double setpoint_limitLo = 0.7912827730178833;
        double temp_Min_OFF = 0.7242476940155029;
        double temp_Min_ON = 0.674912691116333;
        double temperature_warnHi = 0.16533923149108887;
        double temperature_warnLo = 0.2855575f;
        double temperature_limitHi = 0.7123373746871948;
        double temperature_limitLo = 0.2191150188446045;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cryo_LimitsConfigurationEvent(priority, version, autooffenabled_warnHi, autooffenabled_warnLo, autooffenabled_limitHi, autooffenabled_limitLo, autoofftemperature_warnHi, autoofftemperature_warnLo, autoofftemperature_limitHi, autoofftemperature_limitLo, autoontemperature_warnHi, autoontemperature_warnLo, autoontemperature_limitHi, autoontemperature_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo, rejecttemperature_warnHi, rejecttemperature_warnLo, rejecttemperature_limitHi, rejecttemperature_limitLo, setpower_warnHi, setpower_warnLo, setpower_limitHi, setpower_limitLo, setpoint_warnHi, setpoint_warnLo, setpoint_limitHi, setpoint_limitLo, temp_Min_OFF, temp_Min_ON, temperature_warnHi, temperature_warnLo, temperature_limitHi, temperature_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cryo_LimitsConfigurationEvent));
        Vacuum_Cryo_LimitsConfigurationEvent item_ = (Vacuum_Cryo_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)autooffenabled_warnHi, (double)item_.getAutooffenabled_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_warnLo, (double)item_.getAutooffenabled_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_limitHi, (double)item_.getAutooffenabled_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_limitLo, (double)item_.getAutooffenabled_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_warnHi, (double)item_.getAutoofftemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_warnLo, (double)item_.getAutoofftemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_limitHi, (double)item_.getAutoofftemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_limitLo, (double)item_.getAutoofftemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_warnHi, (double)item_.getAutoontemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_warnLo, (double)item_.getAutoontemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_limitHi, (double)item_.getAutoontemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_limitLo, (double)item_.getAutoontemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)power_warnHi, (double)item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)power_warnLo, (double)item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)power_limitHi, (double)item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)power_limitLo, (double)item_.getPower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_warnHi, (double)item_.getRejecttemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_warnLo, (double)item_.getRejecttemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_limitHi, (double)item_.getRejecttemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_limitLo, (double)item_.getRejecttemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_warnHi, (double)item_.getSetpower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_warnLo, (double)item_.getSetpower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_limitHi, (double)item_.getSetpower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_limitLo, (double)item_.getSetpower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_warnHi, (double)item_.getSetpoint_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_warnLo, (double)item_.getSetpoint_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_limitHi, (double)item_.getSetpoint_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_limitLo, (double)item_.getSetpoint_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temp_Min_OFF, (double)item_.getTemp_Min_OFF(), (double)1.0E-6f);
        Assert.assertEquals((double)temp_Min_ON, (double)item_.getTemp_Min_ON(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_warnHi, (double)item_.getTemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_warnLo, (double)item_.getTemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_limitHi, (double)item_.getTemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_limitLo, (double)item_.getTemperature_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_IonPumps_CryoConfigurationEvent() throws Exception {
        int priority = 722;
        String version = "";
        double cip1c_current = 0.3482709527015686;
        double cip1c_power = 0.90446937084198;
        double cip1c_voltage = 0.5560566782951355;
        String ipAddr = "";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_IonPumps_CryoConfigurationEvent(priority, version, cip1c_current, cip1c_power, cip1c_voltage, ipAddr));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumps_CryoConfigurationEvent));
        Vacuum_IonPumps_CryoConfigurationEvent item_ = (Vacuum_IonPumps_CryoConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cip1c_current, (double)item_.getCip1c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)cip1c_power, (double)item_.getCip1c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)cip1c_voltage, (double)item_.getCip1c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((Object)ipAddr, (Object)item_.getIpAddr());
    }

    @Test
    public void sendReceiveVacuum_IonPumps_LimitsConfigurationEvent() throws Exception {
        int priority = 178;
        String version = "x";
        double current_warnHi = 0.05315440893173218;
        double current_warnLo = 0.8198965191841125;
        double current_limitHi = 0.5077343583106995;
        double current_limitLo = 0.7708647847175598;
        double voltage_warnHi = 0.2524857521057129;
        double voltage_warnLo = 0.9283267855644226;
        double voltage_limitHi = 0.4557059407234192;
        double voltage_limitLo = 0.08200287818908691;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_IonPumps_LimitsConfigurationEvent(priority, version, current_warnHi, current_warnLo, current_limitHi, current_limitLo, voltage_warnHi, voltage_warnLo, voltage_limitHi, voltage_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumps_LimitsConfigurationEvent));
        Vacuum_IonPumps_LimitsConfigurationEvent item_ = (Vacuum_IonPumps_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)current_warnHi, (double)item_.getCurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)current_warnLo, (double)item_.getCurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)current_limitHi, (double)item_.getCurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)current_limitLo, (double)item_.getCurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage_warnHi, (double)item_.getVoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage_warnLo, (double)item_.getVoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage_limitHi, (double)item_.getVoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage_limitLo, (double)item_.getVoltage_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_PeriodicTasksConfigurationEvent() throws Exception {
        int priority = 181;
        String version = "p";
        int schedulers_default_nTasks = 277;
        int schedulers_default_nThreads = 692;
        int schedulers_monitor_update_publish_scheduler_nTasks = 813;
        int schedulers_monitor_update_publish_scheduler_nThreads = 84;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PeriodicTasksConfigurationEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PeriodicTasksConfigurationEvent));
        Vacuum_PeriodicTasksConfigurationEvent item_ = (Vacuum_PeriodicTasksConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveVacuum_PeriodicTasks_timersConfigurationEvent() throws Exception {
        int priority = 219;
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 913L;
        long heartbeat_taskPeriodMillis = 951L;
        long monitor_check_taskPeriodMillis = 512L;
        long monitor_publish_taskPeriodMillis = 735L;
        long monitor_update_taskPeriodMillis = 600L;
        long runtimeinfo_taskPeriodMillis = 106L;
        long vacuum_state_taskPeriodMillis = 485L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PeriodicTasks_timersConfigurationEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis, vacuum_state_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PeriodicTasks_timersConfigurationEvent));
        Vacuum_PeriodicTasks_timersConfigurationEvent item_ = (Vacuum_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)vacuum_state_taskPeriodMillis, (long)item_.getVacuum_state_taskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_Rtds_DeviceConfigurationEvent() throws Exception {
        int priority = 11;
        String version = "";
        String node = "";
        String serials = "";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Rtds_DeviceConfigurationEvent(priority, version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Rtds_DeviceConfigurationEvent));
        Vacuum_Rtds_DeviceConfigurationEvent item_ = (Vacuum_Rtds_DeviceConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveVacuum_Rtds_LimitsConfigurationEvent() throws Exception {
        int priority = 704;
        String version = "w";
        double temperaturecold1_warnHi = 0.8688523173332214;
        double temperaturecold1_warnLo = 0.05147433280944824;
        double temperaturecold1_limitHi = 0.7004167437553406;
        double temperaturecold1_limitLo = 0.6102726459503174;
        double temperaturecold2_warnHi = 0.16373854875564575;
        double temperaturecold2_warnLo = 0.2257222f;
        double temperaturecold2_limitHi = 0.6810241937637329;
        double temperaturecold2_limitLo = 0.1661999225616455;
        double temperaturecryo_warnHi = 0.9088693857192993;
        double temperaturecryo_warnLo = 0.11945706605911255;
        double temperaturecryo_limitHi = 0.2741441f;
        double temperaturecryo_limitLo = 0.766837f;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Rtds_LimitsConfigurationEvent(priority, version, temperaturecold1_warnHi, temperaturecold1_warnLo, temperaturecold1_limitHi, temperaturecold1_limitLo, temperaturecold2_warnHi, temperaturecold2_warnLo, temperaturecold2_limitHi, temperaturecold2_limitLo, temperaturecryo_warnHi, temperaturecryo_warnLo, temperaturecryo_limitHi, temperaturecryo_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Rtds_LimitsConfigurationEvent));
        Vacuum_Rtds_LimitsConfigurationEvent item_ = (Vacuum_Rtds_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)temperaturecold1_warnHi, (double)item_.getTemperaturecold1_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecold1_warnLo, (double)item_.getTemperaturecold1_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecold1_limitHi, (double)item_.getTemperaturecold1_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecold1_limitLo, (double)item_.getTemperaturecold1_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecold2_warnHi, (double)item_.getTemperaturecold2_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecold2_warnLo, (double)item_.getTemperaturecold2_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecold2_limitHi, (double)item_.getTemperaturecold2_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecold2_limitLo, (double)item_.getTemperaturecold2_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecryo_warnHi, (double)item_.getTemperaturecryo_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecryo_warnLo, (double)item_.getTemperaturecryo_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecryo_limitHi, (double)item_.getTemperaturecryo_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecryo_limitLo, (double)item_.getTemperaturecryo_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboConfigurationEvent() throws Exception {
        int priority = 802;
        String version = "o";
        boolean activeStopMode = true;
        String devcId = "l";
        boolean interlockType = false;
        boolean lowSpeedMode = true;
        boolean model304 = true;
        boolean softStartMode = true;
        boolean ventValveByCmnd = true;
        boolean waterCooling = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboConfigurationEvent(priority, version, activeStopMode, devcId, interlockType, lowSpeedMode, model304, softStartMode, ventValveByCmnd, waterCooling));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboConfigurationEvent));
        Vacuum_TurboConfigurationEvent item_ = (Vacuum_TurboConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)activeStopMode, (Object)item_.isActiveStopMode());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((Object)interlockType, (Object)item_.isInterlockType());
        Assert.assertEquals((Object)lowSpeedMode, (Object)item_.isLowSpeedMode());
        Assert.assertEquals((Object)model304, (Object)item_.isModel304());
        Assert.assertEquals((Object)softStartMode, (Object)item_.isSoftStartMode());
        Assert.assertEquals((Object)ventValveByCmnd, (Object)item_.isVentValveByCmnd());
        Assert.assertEquals((Object)waterCooling, (Object)item_.isWaterCooling());
    }

    @Test
    public void sendReceiveVacuum_Turbo_LimitsConfigurationEvent() throws Exception {
        int priority = 540;
        String version = "z";
        double cntrlrairtemperature_warnHi = 0.41917216777801514;
        double cntrlrairtemperature_warnLo = 0.5601454377174377;
        double cntrlrairtemperature_limitHi = 0.33406996726989746;
        double cntrlrairtemperature_limitLo = 0.5312292575836182;
        double cntrlrsinktemperature_warnHi = 0.7347690463066101;
        double cntrlrsinktemperature_warnLo = 0.36329346895217896;
        double cntrlrsinktemperature_limitHi = 0.4870149f;
        double cntrlrsinktemperature_limitLo = 0.22898507118225098;
        double current_warnHi = 0.6373441815376282;
        double current_warnLo = 0.6345996856689453;
        double current_limitHi = 0.276350736618042;
        double current_limitLo = 0.5662907958030701;
        double drivefrequency_warnHi = 0.4810322f;
        double drivefrequency_warnLo = 0.17140984535217285;
        double drivefrequency_limitHi = 0.2860983610153198;
        double drivefrequency_limitLo = 0.2018665075302124;
        double power_warnHi = 0.8623965978622437;
        double power_warnLo = 0.2078021764755249;
        double power_limitHi = 0.027436554431915283;
        double power_limitLo = 0.3213622570037842;
        double pumptemperature_warnHi = 0.8489788770675659;
        double pumptemperature_warnLo = 0.17418742179870605;
        double pumptemperature_limitHi = 0.08984065055847168;
        double pumptemperature_limitLo = 0.4241867661476135;
        double rpm_warnHi = 0.9418308734893799;
        double rpm_warnLo = 0.9684880375862122;
        double rpm_limitHi = 0.9527187347412109;
        double rpm_limitLo = 0.18455815315246582;
        double status_warnHi = 0.6065274477005005;
        double status_warnLo = 0.4981291890144348;
        double status_limitHi = 0.8888053894042969;
        double status_limitLo = 0.24716395139694214;
        double voltage_warnHi = 0.18402493000030518;
        double voltage_warnLo = 0.9244294762611389;
        double voltage_limitHi = 0.7530982494354248;
        double voltage_limitLo = 0.6354634165763855;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Turbo_LimitsConfigurationEvent(priority, version, cntrlrairtemperature_warnHi, cntrlrairtemperature_warnLo, cntrlrairtemperature_limitHi, cntrlrairtemperature_limitLo, cntrlrsinktemperature_warnHi, cntrlrsinktemperature_warnLo, cntrlrsinktemperature_limitHi, cntrlrsinktemperature_limitLo, current_warnHi, current_warnLo, current_limitHi, current_limitLo, drivefrequency_warnHi, drivefrequency_warnLo, drivefrequency_limitHi, drivefrequency_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo, pumptemperature_warnHi, pumptemperature_warnLo, pumptemperature_limitHi, pumptemperature_limitLo, rpm_warnHi, rpm_warnLo, rpm_limitHi, rpm_limitLo, status_warnHi, status_warnLo, status_limitHi, status_limitLo, voltage_warnHi, voltage_warnLo, voltage_limitHi, voltage_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Turbo_LimitsConfigurationEvent));
        Vacuum_Turbo_LimitsConfigurationEvent item_ = (Vacuum_Turbo_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cntrlrairtemperature_warnHi, (double)item_.getCntrlrairtemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrairtemperature_warnLo, (double)item_.getCntrlrairtemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrairtemperature_limitHi, (double)item_.getCntrlrairtemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrairtemperature_limitLo, (double)item_.getCntrlrairtemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrsinktemperature_warnHi, (double)item_.getCntrlrsinktemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrsinktemperature_warnLo, (double)item_.getCntrlrsinktemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrsinktemperature_limitHi, (double)item_.getCntrlrsinktemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrsinktemperature_limitLo, (double)item_.getCntrlrsinktemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)current_warnHi, (double)item_.getCurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)current_warnLo, (double)item_.getCurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)current_limitHi, (double)item_.getCurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)current_limitLo, (double)item_.getCurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)drivefrequency_warnHi, (double)item_.getDrivefrequency_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)drivefrequency_warnLo, (double)item_.getDrivefrequency_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)drivefrequency_limitHi, (double)item_.getDrivefrequency_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)drivefrequency_limitLo, (double)item_.getDrivefrequency_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)power_warnHi, (double)item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)power_warnLo, (double)item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)power_limitHi, (double)item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)power_limitLo, (double)item_.getPower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumptemperature_warnHi, (double)item_.getPumptemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumptemperature_warnLo, (double)item_.getPumptemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumptemperature_limitHi, (double)item_.getPumptemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumptemperature_limitLo, (double)item_.getPumptemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rpm_warnHi, (double)item_.getRpm_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rpm_warnLo, (double)item_.getRpm_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rpm_limitHi, (double)item_.getRpm_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rpm_limitLo, (double)item_.getRpm_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)status_warnHi, (double)item_.getStatus_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)status_warnLo, (double)item_.getStatus_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)status_limitHi, (double)item_.getStatus_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)status_limitLo, (double)item_.getStatus_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage_warnHi, (double)item_.getVoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage_warnLo, (double)item_.getVoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage_limitHi, (double)item_.getVoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage_limitLo, (double)item_.getVoltage_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_VQMonitor_CryoConfigurationEvent() throws Exception {
        int priority = 764;
        String version = "";
        int busAddr = 624;
        String devcId = "f";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VQMonitor_CryoConfigurationEvent(priority, version, busAddr, devcId));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VQMonitor_CryoConfigurationEvent));
        Vacuum_VQMonitor_CryoConfigurationEvent item_ = (Vacuum_VQMonitor_CryoConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveVacuum_VQMonitor_LimitsConfigurationEvent() throws Exception {
        int priority = 715;
        String version = "j";
        double vqmpressure_warnHi = 0.11037266254425049;
        double vqmpressure_warnLo = 0.4113478f;
        double vqmpressure_limitHi = 0.2250347137451172;
        double vqmpressure_limitLo = 0.3065752387046814;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VQMonitor_LimitsConfigurationEvent(priority, version, vqmpressure_warnHi, vqmpressure_warnLo, vqmpressure_limitHi, vqmpressure_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VQMonitor_LimitsConfigurationEvent));
        Vacuum_VQMonitor_LimitsConfigurationEvent item_ = (Vacuum_VQMonitor_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)vqmpressure_warnHi, (double)item_.getVqmpressure_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vqmpressure_warnLo, (double)item_.getVqmpressure_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vqmpressure_limitHi, (double)item_.getVqmpressure_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vqmpressure_limitLo, (double)item_.getVqmpressure_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_VacPluto_DeviceConfigurationEvent() throws Exception {
        int priority = 529;
        String version = "i";
        String node = "j";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VacPluto_DeviceConfigurationEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VacPluto_DeviceConfigurationEvent));
        Vacuum_VacPluto_DeviceConfigurationEvent item_ = (Vacuum_VacPluto_DeviceConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_BFR_LimitsConfigurationEvent() throws Exception {
        int priority = 598;
        String version = "";
        double clean_5_24V_I_warnHi = 0.909978985786438;
        double clean_5_24V_I_warnLo = 0.632366418838501;
        double clean_5_24V_I_limitHi = 0.8650884032249451;
        double clean_5_24V_I_limitLo = 0.033549726009368896;
        double dirty_24V_I_warnHi = 0.6954838037490845;
        double dirty_24V_I_warnLo = 0.11287665367126465;
        double dirty_24V_I_limitHi = 0.674673318862915;
        double dirty_24V_I_limitLo = 0.06375402212142944;
        double dirty_28V_I_warnHi = 0.5577300786972046;
        double dirty_28V_I_warnLo = 0.0346936f;
        double dirty_28V_I_limitHi = 0.25591927766799927;
        double dirty_28V_I_limitLo = 0.861728f;
        double dirty_48V_I_warnHi = 0.6790806651115417;
        double dirty_48V_I_warnLo = 0.500071f;
        double dirty_48V_I_limitHi = 0.0706256628036499;
        double dirty_48V_I_limitLo = 0.5492081046104431;
        double heater_I_warnHi = 0.5675011873245239;
        double heater_I_warnLo = 0.2477231f;
        double heater_I_limitHi = 0.6511227488517761;
        double heater_I_limitLo = 0.25721925497055054;
        double protection_I_warnHi = 0.053745925426483154;
        double protection_I_warnLo = 0.13506555557250977;
        double protection_I_limitHi = 0.5684199333190918;
        double protection_I_limitLo = 0.1792144775390625;
        double rebps_0_warnHi = 0.420258f;
        double rebps_0_warnLo = 0.24494272470474243;
        double rebps_0_limitHi = 0.3861231803894043;
        double rebps_0_limitLo = 0.47374796867370605;
        double sensor_PWS_17_I_warnHi = 0.32380956411361694;
        double sensor_PWS_17_I_warnLo = 0.34402942657470703;
        double sensor_PWS_17_I_limitHi = 0.40112733840942383;
        double sensor_PWS_17_I_limitLo = 0.4736320972442627;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_BFR_LimitsConfigurationEvent(priority, version, clean_5_24V_I_warnHi, clean_5_24V_I_warnLo, clean_5_24V_I_limitHi, clean_5_24V_I_limitLo, dirty_24V_I_warnHi, dirty_24V_I_warnLo, dirty_24V_I_limitHi, dirty_24V_I_limitLo, dirty_28V_I_warnHi, dirty_28V_I_warnLo, dirty_28V_I_limitHi, dirty_28V_I_limitLo, dirty_48V_I_warnHi, dirty_48V_I_warnLo, dirty_48V_I_limitHi, dirty_48V_I_limitLo, heater_I_warnHi, heater_I_warnLo, heater_I_limitHi, heater_I_limitLo, protection_I_warnHi, protection_I_warnLo, protection_I_limitHi, protection_I_limitLo, rebps_0_warnHi, rebps_0_warnLo, rebps_0_limitHi, rebps_0_limitLo, sensor_PWS_17_I_warnHi, sensor_PWS_17_I_warnLo, sensor_PWS_17_I_limitHi, sensor_PWS_17_I_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFR_LimitsConfigurationEvent));
        Quadbox_BFR_LimitsConfigurationEvent item_ = (Quadbox_BFR_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)clean_5_24V_I_warnHi, (double)item_.getClean_5_24V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_warnLo, (double)item_.getClean_5_24V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_limitHi, (double)item_.getClean_5_24V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_limitLo, (double)item_.getClean_5_24V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_warnHi, (double)item_.getDirty_24V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_warnLo, (double)item_.getDirty_24V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_limitHi, (double)item_.getDirty_24V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_limitLo, (double)item_.getDirty_24V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_warnHi, (double)item_.getDirty_28V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_warnLo, (double)item_.getDirty_28V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_limitHi, (double)item_.getDirty_28V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_limitLo, (double)item_.getDirty_28V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_warnHi, (double)item_.getDirty_48V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_warnLo, (double)item_.getDirty_48V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_limitHi, (double)item_.getDirty_48V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_limitLo, (double)item_.getDirty_48V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_warnHi, (double)item_.getHeater_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_warnLo, (double)item_.getHeater_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_limitHi, (double)item_.getHeater_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_limitLo, (double)item_.getHeater_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_warnHi, (double)item_.getProtection_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_warnLo, (double)item_.getProtection_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_limitHi, (double)item_.getProtection_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_limitLo, (double)item_.getProtection_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_warnHi, (double)item_.getRebps_0_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_warnLo, (double)item_.getRebps_0_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_limitHi, (double)item_.getRebps_0_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_limitLo, (double)item_.getRebps_0_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)sensor_PWS_17_I_warnHi, (double)item_.getSensor_PWS_17_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)sensor_PWS_17_I_warnLo, (double)item_.getSensor_PWS_17_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)sensor_PWS_17_I_limitHi, (double)item_.getSensor_PWS_17_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)sensor_PWS_17_I_limitLo, (double)item_.getSensor_PWS_17_I_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_BFR_QuadboxConfigurationEvent() throws Exception {
        int priority = 819;
        String version = "y";
        int node = 927;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_BFR_QuadboxConfigurationEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFR_QuadboxConfigurationEvent));
        Quadbox_BFR_QuadboxConfigurationEvent item_ = (Quadbox_BFR_QuadboxConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VC_LimitsConfigurationEvent() throws Exception {
        int priority = 780;
        String version = "";
        double board_T_warnHi = 0.48530107736587524;
        double board_T_warnLo = 0.4137721657752991;
        double board_T_limitHi = 0.0766598f;
        double board_T_limitLo = 0.7253578305244446;
        double body_Purge_I_warnHi = 0.1221545934677124;
        double body_Purge_I_warnLo = 0.779416024684906;
        double body_Purge_I_limitHi = 0.2768756151199341;
        double body_Purge_I_limitLo = 0.4441349506378174;
        double body_Purge_V_warnHi = 0.5148841738700867;
        double body_Purge_V_warnLo = 0.00691455602645874;
        double body_Purge_V_limitHi = 0.5889905095100403;
        double body_Purge_V_limitLo = 0.862678587436676;
        double bpu_Maq20_I_warnHi = 0.759788f;
        double bpu_Maq20_I_warnLo = 0.24051225185394287;
        double bpu_Maq20_I_limitHi = 0.5518115162849426;
        double bpu_Maq20_I_limitLo = 0.5088573098182678;
        double bpu_Maq20_V_warnHi = 0.8950796723365784;
        double bpu_Maq20_V_warnLo = 0.17582905292510986;
        double bpu_Maq20_V_limitHi = 0.26496803760528564;
        double bpu_Maq20_V_limitLo = 0.4779793620109558;
        double fpga_T_warnHi = 0.15224981307983398;
        double fpga_T_warnLo = 0.10457044839859009;
        double fpga_T_limitHi = 0.7497748136520386;
        double fpga_T_limitLo = 0.1686194f;
        double fes_Shu_HCU_I_warnHi = 0.30979394912719727;
        double fes_Shu_HCU_I_warnLo = 0.21112632751464844;
        double fes_Shu_HCU_I_limitHi = 0.3359434f;
        double fes_Shu_HCU_I_limitLo = 0.147347092628479;
        double fes_Shu_HCU_V_warnHi = 0.9024807214736938;
        double fes_Shu_HCU_V_warnLo = 0.9873150587081909;
        double fes_Shu_HCU_V_limitHi = 0.7804882526397705;
        double fes_Shu_HCU_V_limitLo = 0.21205365657806396;
        double gauges_I_warnHi = 0.19770705699920654;
        double gauges_I_warnLo = 0.0017998814582824707;
        double gauges_I_limitHi = 0.893978476524353;
        double gauges_I_limitLo = 0.5026865005493164;
        double gauges_V_warnHi = 0.2176659107208252;
        double gauges_V_warnLo = 0.6090694069862366;
        double gauges_V_limitHi = 0.9734766483306885;
        double gauges_V_limitLo = 0.8928537964820862;
        double ion_Pumps_I_warnHi = 0.0497211217880249;
        double ion_Pumps_I_warnLo = 0.2681116461753845;
        double ion_Pumps_I_limitHi = 0.529084324836731;
        double ion_Pumps_I_limitLo = 0.05878615379333496;
        double ion_Pumps_V_warnHi = 0.5883772969245911;
        double ion_Pumps_V_warnLo = 0.6124424338340759;
        double ion_Pumps_V_limitHi = 0.928119f;
        double ion_Pumps_V_limitLo = 0.25203055143356323;
        double j10_I_warnHi = 0.23448187112808228;
        double j10_I_warnLo = 0.06101113557815552;
        double j10_I_limitHi = 0.2818338871002197;
        double j10_I_limitLo = 0.35309863090515137;
        double j10_V_warnHi = 0.937881f;
        double j10_V_warnLo = 0.7643618583679199;
        double j10_V_limitHi = 0.35663992166519165;
        double j10_V_limitLo = 0.7248210906982422;
        double j11_I_warnHi = 0.00886458158493042;
        double j11_I_warnLo = 0.8635683059692383;
        double j11_I_limitHi = 0.525514f;
        double j11_I_limitLo = 0.4517327547073364;
        double j11_V_warnHi = 0.9946938753128052;
        double j11_V_warnLo = 0.11279827356338501;
        double j11_V_limitHi = 0.8843053579330444;
        double j11_V_limitLo = 0.9963942170143127;
        double j12_I_warnHi = 0.4767602f;
        double j12_I_warnLo = 0.7324386835098267;
        double j12_I_limitHi = 0.0687408447265625;
        double j12_I_limitLo = 0.14175671339035034;
        double j12_V_warnHi = 0.2010408f;
        double j12_V_warnLo = 0.16168522834777832;
        double j12_V_limitHi = 0.02596902847290039;
        double j12_V_limitLo = 0.35271936655044556;
        double j6_I_warnHi = 0.522193193435669;
        double j6_I_warnLo = 0.05116891860961914;
        double j6_I_limitHi = 0.8524715900421143;
        double j6_I_limitLo = 0.677761971950531;
        double j6_V_warnHi = 0.6856864094734192;
        double j6_V_warnLo = 0.15195822715759277;
        double j6_V_limitHi = 0.7192482352256775;
        double j6_V_limitLo = 0.8364443778991699;
        double j7_I_warnHi = 0.161748468875885;
        double j7_I_warnLo = 0.6321895122528076;
        double j7_I_limitHi = 0.10460102558135986;
        double j7_I_limitLo = 0.7797408103942871;
        double j7_V_warnHi = 0.7016832828521729;
        double j7_V_warnLo = 0.0922970175743103;
        double j7_V_limitHi = 0.8619933128356934;
        double j7_V_limitLo = 0.3623538017272949;
        double j9_I_warnHi = 0.33647865056991577;
        double j9_I_warnLo = 0.10063028335571289;
        double j9_I_limitHi = 0.710841f;
        double j9_I_limitLo = 0.6896804571151733;
        double j9_V_warnHi = 0.4579014182090759;
        double j9_V_warnLo = 0.2700703740119934;
        double j9_V_limitHi = 0.27534347772598267;
        double j9_V_limitLo = 0.5729556679725647;
        double main_I_warnHi = 0.8949098587036133;
        double main_I_warnLo = 0.7206348180770874;
        double main_I_limitHi = 0.8623384237289429;
        double main_I_limitLo = 0.4858793616294861;
        double main_T_warnHi = 0.45777201652526855;
        double main_T_warnLo = 0.5911467671394348;
        double main_T_limitHi = 0.393549382686615;
        double main_T_limitLo = 0.6219715476036072;
        double main_V_warnHi = 0.40645831823349;
        double main_V_warnLo = 0.0836363434791565;
        double main_V_limitHi = 0.748494029045105;
        double main_V_limitLo = 0.5268413424491882;
        double pwr_Cry_HCU_I_warnHi = 0.29950016736984253;
        double pwr_Cry_HCU_I_warnLo = 0.24664908647537231;
        double pwr_Cry_HCU_I_limitHi = 0.767871618270874;
        double pwr_Cry_HCU_I_limitLo = 0.2619808316230774;
        double pwr_Cry_HCU_V_warnHi = 0.48851585388183594;
        double pwr_Cry_HCU_V_warnLo = 0.3681f;
        double pwr_Cry_HCU_V_limitHi = 0.177703857421875;
        double pwr_Cry_HCU_V_limitLo = 0.8507076501846313;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VC_LimitsConfigurationEvent(priority, version, board_T_warnHi, board_T_warnLo, board_T_limitHi, board_T_limitLo, body_Purge_I_warnHi, body_Purge_I_warnLo, body_Purge_I_limitHi, body_Purge_I_limitLo, body_Purge_V_warnHi, body_Purge_V_warnLo, body_Purge_V_limitHi, body_Purge_V_limitLo, bpu_Maq20_I_warnHi, bpu_Maq20_I_warnLo, bpu_Maq20_I_limitHi, bpu_Maq20_I_limitLo, bpu_Maq20_V_warnHi, bpu_Maq20_V_warnLo, bpu_Maq20_V_limitHi, bpu_Maq20_V_limitLo, fpga_T_warnHi, fpga_T_warnLo, fpga_T_limitHi, fpga_T_limitLo, fes_Shu_HCU_I_warnHi, fes_Shu_HCU_I_warnLo, fes_Shu_HCU_I_limitHi, fes_Shu_HCU_I_limitLo, fes_Shu_HCU_V_warnHi, fes_Shu_HCU_V_warnLo, fes_Shu_HCU_V_limitHi, fes_Shu_HCU_V_limitLo, gauges_I_warnHi, gauges_I_warnLo, gauges_I_limitHi, gauges_I_limitLo, gauges_V_warnHi, gauges_V_warnLo, gauges_V_limitHi, gauges_V_limitLo, ion_Pumps_I_warnHi, ion_Pumps_I_warnLo, ion_Pumps_I_limitHi, ion_Pumps_I_limitLo, ion_Pumps_V_warnHi, ion_Pumps_V_warnLo, ion_Pumps_V_limitHi, ion_Pumps_V_limitLo, j10_I_warnHi, j10_I_warnLo, j10_I_limitHi, j10_I_limitLo, j10_V_warnHi, j10_V_warnLo, j10_V_limitHi, j10_V_limitLo, j11_I_warnHi, j11_I_warnLo, j11_I_limitHi, j11_I_limitLo, j11_V_warnHi, j11_V_warnLo, j11_V_limitHi, j11_V_limitLo, j12_I_warnHi, j12_I_warnLo, j12_I_limitHi, j12_I_limitLo, j12_V_warnHi, j12_V_warnLo, j12_V_limitHi, j12_V_limitLo, j6_I_warnHi, j6_I_warnLo, j6_I_limitHi, j6_I_limitLo, j6_V_warnHi, j6_V_warnLo, j6_V_limitHi, j6_V_limitLo, j7_I_warnHi, j7_I_warnLo, j7_I_limitHi, j7_I_limitLo, j7_V_warnHi, j7_V_warnLo, j7_V_limitHi, j7_V_limitLo, j9_I_warnHi, j9_I_warnLo, j9_I_limitHi, j9_I_limitLo, j9_V_warnHi, j9_V_warnLo, j9_V_limitHi, j9_V_limitLo, main_I_warnHi, main_I_warnLo, main_I_limitHi, main_I_limitLo, main_T_warnHi, main_T_warnLo, main_T_limitHi, main_T_limitLo, main_V_warnHi, main_V_warnLo, main_V_limitHi, main_V_limitLo, pwr_Cry_HCU_I_warnHi, pwr_Cry_HCU_I_warnLo, pwr_Cry_HCU_I_limitHi, pwr_Cry_HCU_I_limitLo, pwr_Cry_HCU_V_warnHi, pwr_Cry_HCU_V_warnLo, pwr_Cry_HCU_V_limitHi, pwr_Cry_HCU_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VC_LimitsConfigurationEvent));
        Quadbox_PDU_24VC_LimitsConfigurationEvent item_ = (Quadbox_PDU_24VC_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)board_T_warnHi, (double)item_.getBoard_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_warnLo, (double)item_.getBoard_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitHi, (double)item_.getBoard_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitLo, (double)item_.getBoard_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_warnHi, (double)item_.getBody_Purge_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_warnLo, (double)item_.getBody_Purge_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_limitHi, (double)item_.getBody_Purge_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_limitLo, (double)item_.getBody_Purge_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_warnHi, (double)item_.getBody_Purge_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_warnLo, (double)item_.getBody_Purge_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_limitHi, (double)item_.getBody_Purge_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_limitLo, (double)item_.getBody_Purge_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_warnHi, (double)item_.getBpu_Maq20_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_warnLo, (double)item_.getBpu_Maq20_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_limitHi, (double)item_.getBpu_Maq20_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_limitLo, (double)item_.getBpu_Maq20_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_warnHi, (double)item_.getBpu_Maq20_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_warnLo, (double)item_.getBpu_Maq20_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_limitHi, (double)item_.getBpu_Maq20_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_limitLo, (double)item_.getBpu_Maq20_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnHi, (double)item_.getFpga_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnLo, (double)item_.getFpga_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitHi, (double)item_.getFpga_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitLo, (double)item_.getFpga_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_warnHi, (double)item_.getFes_Shu_HCU_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_warnLo, (double)item_.getFes_Shu_HCU_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_limitHi, (double)item_.getFes_Shu_HCU_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_limitLo, (double)item_.getFes_Shu_HCU_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_warnHi, (double)item_.getFes_Shu_HCU_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_warnLo, (double)item_.getFes_Shu_HCU_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_limitHi, (double)item_.getFes_Shu_HCU_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_limitLo, (double)item_.getFes_Shu_HCU_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_warnHi, (double)item_.getGauges_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_warnLo, (double)item_.getGauges_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_limitHi, (double)item_.getGauges_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_limitLo, (double)item_.getGauges_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_warnHi, (double)item_.getGauges_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_warnLo, (double)item_.getGauges_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_limitHi, (double)item_.getGauges_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_limitLo, (double)item_.getGauges_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_warnHi, (double)item_.getIon_Pumps_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_warnLo, (double)item_.getIon_Pumps_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_limitHi, (double)item_.getIon_Pumps_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_limitLo, (double)item_.getIon_Pumps_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_warnHi, (double)item_.getIon_Pumps_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_warnLo, (double)item_.getIon_Pumps_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_limitHi, (double)item_.getIon_Pumps_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_limitLo, (double)item_.getIon_Pumps_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j10_I_warnHi, (double)item_.getJ10_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j10_I_warnLo, (double)item_.getJ10_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j10_I_limitHi, (double)item_.getJ10_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j10_I_limitLo, (double)item_.getJ10_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j10_V_warnHi, (double)item_.getJ10_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j10_V_warnLo, (double)item_.getJ10_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j10_V_limitHi, (double)item_.getJ10_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j10_V_limitLo, (double)item_.getJ10_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_I_warnHi, (double)item_.getJ11_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_I_warnLo, (double)item_.getJ11_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_I_limitHi, (double)item_.getJ11_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_I_limitLo, (double)item_.getJ11_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_V_warnHi, (double)item_.getJ11_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_V_warnLo, (double)item_.getJ11_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_V_limitHi, (double)item_.getJ11_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_V_limitLo, (double)item_.getJ11_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_I_warnHi, (double)item_.getJ12_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_I_warnLo, (double)item_.getJ12_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_I_limitHi, (double)item_.getJ12_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_I_limitLo, (double)item_.getJ12_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_V_warnHi, (double)item_.getJ12_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_V_warnLo, (double)item_.getJ12_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_V_limitHi, (double)item_.getJ12_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_V_limitLo, (double)item_.getJ12_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_I_warnHi, (double)item_.getJ6_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_I_warnLo, (double)item_.getJ6_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_I_limitHi, (double)item_.getJ6_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_I_limitLo, (double)item_.getJ6_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_V_warnHi, (double)item_.getJ6_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_V_warnLo, (double)item_.getJ6_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_V_limitHi, (double)item_.getJ6_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_V_limitLo, (double)item_.getJ6_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_I_warnHi, (double)item_.getJ7_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_I_warnLo, (double)item_.getJ7_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_I_limitHi, (double)item_.getJ7_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_I_limitLo, (double)item_.getJ7_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_V_warnHi, (double)item_.getJ7_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_V_warnLo, (double)item_.getJ7_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_V_limitHi, (double)item_.getJ7_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_V_limitLo, (double)item_.getJ7_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_I_warnHi, (double)item_.getJ9_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_I_warnLo, (double)item_.getJ9_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_I_limitHi, (double)item_.getJ9_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_I_limitLo, (double)item_.getJ9_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_V_warnHi, (double)item_.getJ9_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_V_warnLo, (double)item_.getJ9_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_V_limitHi, (double)item_.getJ9_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_V_limitLo, (double)item_.getJ9_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnHi, (double)item_.getMain_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnLo, (double)item_.getMain_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitHi, (double)item_.getMain_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitLo, (double)item_.getMain_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnHi, (double)item_.getMain_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnLo, (double)item_.getMain_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitHi, (double)item_.getMain_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitLo, (double)item_.getMain_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnHi, (double)item_.getMain_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnLo, (double)item_.getMain_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitHi, (double)item_.getMain_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitLo, (double)item_.getMain_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_warnHi, (double)item_.getPwr_Cry_HCU_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_warnLo, (double)item_.getPwr_Cry_HCU_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_limitHi, (double)item_.getPwr_Cry_HCU_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_limitLo, (double)item_.getPwr_Cry_HCU_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_warnHi, (double)item_.getPwr_Cry_HCU_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_warnLo, (double)item_.getPwr_Cry_HCU_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_limitHi, (double)item_.getPwr_Cry_HCU_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_limitLo, (double)item_.getPwr_Cry_HCU_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VC_QuadboxConfigurationEvent() throws Exception {
        int priority = 205;
        String version = "u";
        int node = 344;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VC_QuadboxConfigurationEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VC_QuadboxConfigurationEvent));
        Quadbox_PDU_24VC_QuadboxConfigurationEvent item_ = (Quadbox_PDU_24VC_QuadboxConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VD_LimitsConfigurationEvent() throws Exception {
        int priority = 909;
        String version = "";
        double board_T_warnHi = 0.5292513370513916;
        double board_T_warnLo = 0.5915347337722778;
        double board_T_limitHi = 0.17069f;
        double board_T_limitLo = 0.6826686859130859;
        double fes_I_warnHi = 0.6330636143684387;
        double fes_I_warnLo = 0.49333226680755615;
        double fes_I_limitHi = 0.05587393045425415;
        double fes_I_limitLo = 0.5080180764198303;
        double fes_V_warnHi = 0.3663373f;
        double fes_V_warnLo = 0.9903306365013123;
        double fes_V_limitHi = 0.28888654708862305;
        double fes_V_limitLo = 0.43917596340179443;
        double fpga_T_warnHi = 0.4342119097709656;
        double fpga_T_warnLo = 0.5887249112129211;
        double fpga_T_limitHi = 0.47140854597091675;
        double fpga_T_limitLo = 0.10862231254577637;
        double main_I_warnHi = 0.3732417821884155;
        double main_I_warnLo = 0.376612f;
        double main_I_limitHi = 0.562292f;
        double main_I_limitLo = 0.11836177110671997;
        double main_T_warnHi = 0.11182254552841187;
        double main_T_warnLo = 0.32439786195755005;
        double main_T_limitHi = 0.630763053894043;
        double main_T_limitLo = 0.2564527988433838;
        double main_V_warnHi = 0.018869996070861816;
        double main_V_warnLo = 0.5753469467163086;
        double main_V_limitHi = 0.7712225317955017;
        double main_V_limitLo = 0.03604203462600708;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VD_LimitsConfigurationEvent(priority, version, board_T_warnHi, board_T_warnLo, board_T_limitHi, board_T_limitLo, fes_I_warnHi, fes_I_warnLo, fes_I_limitHi, fes_I_limitLo, fes_V_warnHi, fes_V_warnLo, fes_V_limitHi, fes_V_limitLo, fpga_T_warnHi, fpga_T_warnLo, fpga_T_limitHi, fpga_T_limitLo, main_I_warnHi, main_I_warnLo, main_I_limitHi, main_I_limitLo, main_T_warnHi, main_T_warnLo, main_T_limitHi, main_T_limitLo, main_V_warnHi, main_V_warnLo, main_V_limitHi, main_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VD_LimitsConfigurationEvent));
        Quadbox_PDU_24VD_LimitsConfigurationEvent item_ = (Quadbox_PDU_24VD_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)board_T_warnHi, (double)item_.getBoard_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_warnLo, (double)item_.getBoard_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitHi, (double)item_.getBoard_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitLo, (double)item_.getBoard_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_I_warnHi, (double)item_.getFes_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_I_warnLo, (double)item_.getFes_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_I_limitHi, (double)item_.getFes_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_I_limitLo, (double)item_.getFes_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_V_warnHi, (double)item_.getFes_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_V_warnLo, (double)item_.getFes_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_V_limitHi, (double)item_.getFes_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_V_limitLo, (double)item_.getFes_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnHi, (double)item_.getFpga_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnLo, (double)item_.getFpga_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitHi, (double)item_.getFpga_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitLo, (double)item_.getFpga_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnHi, (double)item_.getMain_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnLo, (double)item_.getMain_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitHi, (double)item_.getMain_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitLo, (double)item_.getMain_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnHi, (double)item_.getMain_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnLo, (double)item_.getMain_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitHi, (double)item_.getMain_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitLo, (double)item_.getMain_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnHi, (double)item_.getMain_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnLo, (double)item_.getMain_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitHi, (double)item_.getMain_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitLo, (double)item_.getMain_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VD_QuadboxConfigurationEvent() throws Exception {
        int priority = 330;
        String version = "y";
        int node = 358;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VD_QuadboxConfigurationEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VD_QuadboxConfigurationEvent));
        Quadbox_PDU_24VD_QuadboxConfigurationEvent item_ = (Quadbox_PDU_24VD_QuadboxConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_48V_LimitsConfigurationEvent() throws Exception {
        int priority = 422;
        String version = "y";
        double board_T_warnHi = 0.2531300187110901;
        double board_T_warnLo = 0.307384f;
        double board_T_limitHi = 0.3419477939605713;
        double board_T_limitLo = 0.8316075205802917;
        double cryotel0_I_warnHi = 0.6268974542617798;
        double cryotel0_I_warnLo = 0.02484762668609619;
        double cryotel0_I_limitHi = 0.7699902057647705;
        double cryotel0_I_limitLo = 0.025355935096740723;
        double cryotel0_V_warnHi = 0.590442f;
        double cryotel0_V_warnLo = 0.808464765548706;
        double cryotel0_V_limitHi = 0.5955008864402771;
        double cryotel0_V_limitLo = 0.18658453226089478;
        double cryotel1_I_warnHi = 0.3638281226158142;
        double cryotel1_I_warnLo = 0.6111805438995361;
        double cryotel1_I_limitHi = 0.5877537727355957;
        double cryotel1_I_limitLo = 0.22770464420318604;
        double cryotel1_V_warnHi = 0.08397293090820312;
        double cryotel1_V_warnLo = 0.705195426940918;
        double cryotel1_V_limitHi = 0.5745881199836731;
        double cryotel1_V_limitLo = 0.3399214f;
        double cryotel2_I_warnHi = 0.2192559838294983;
        double cryotel2_I_warnLo = 0.6262549161911011;
        double cryotel2_I_limitHi = 0.3666437268257141;
        double cryotel2_I_limitLo = 0.45988816022872925;
        double cryotel2_V_warnHi = 0.6296939253807068;
        double cryotel2_V_warnLo = 0.040489912033081055;
        double cryotel2_V_limitHi = 0.45842164754867554;
        double cryotel2_V_limitLo = 0.8041380643844604;
        double fpga_T_warnHi = 0.963213324546814;
        double fpga_T_warnLo = 0.4553758502006531;
        double fpga_T_limitHi = 0.2713279128074646;
        double fpga_T_limitLo = 0.947884738445282;
        double main_I_warnHi = 0.0288409f;
        double main_I_warnLo = 0.39329564571380615;
        double main_I_limitHi = 0.22851771116256714;
        double main_I_limitLo = 0.21255344152450562;
        double main_T_warnHi = 0.011912405490875244;
        double main_T_warnLo = 0.5514242649078369;
        double main_T_limitHi = 0.6508852243423462;
        double main_T_limitLo = 0.568288266658783;
        double main_V_warnHi = 0.637826144695282;
        double main_V_warnLo = 0.09007900953292847;
        double main_V_limitHi = 0.8701666593551636;
        double main_V_limitLo = 0.36637115478515625;
        double reb_BULK_I_warnHi = 0.03323858976364136;
        double reb_BULK_I_warnLo = 0.8563101887702942;
        double reb_BULK_I_limitHi = 0.8666839003562927;
        double reb_BULK_I_limitLo = 0.45781224966049194;
        double reb_BULK_V_warnHi = 0.3513185381889343;
        double reb_BULK_V_warnLo = 0.4714767336845398;
        double reb_BULK_V_limitHi = 0.46924442052841187;
        double reb_BULK_V_limitLo = 0.2972654700279236;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_48V_LimitsConfigurationEvent(priority, version, board_T_warnHi, board_T_warnLo, board_T_limitHi, board_T_limitLo, cryotel0_I_warnHi, cryotel0_I_warnLo, cryotel0_I_limitHi, cryotel0_I_limitLo, cryotel0_V_warnHi, cryotel0_V_warnLo, cryotel0_V_limitHi, cryotel0_V_limitLo, cryotel1_I_warnHi, cryotel1_I_warnLo, cryotel1_I_limitHi, cryotel1_I_limitLo, cryotel1_V_warnHi, cryotel1_V_warnLo, cryotel1_V_limitHi, cryotel1_V_limitLo, cryotel2_I_warnHi, cryotel2_I_warnLo, cryotel2_I_limitHi, cryotel2_I_limitLo, cryotel2_V_warnHi, cryotel2_V_warnLo, cryotel2_V_limitHi, cryotel2_V_limitLo, fpga_T_warnHi, fpga_T_warnLo, fpga_T_limitHi, fpga_T_limitLo, main_I_warnHi, main_I_warnLo, main_I_limitHi, main_I_limitLo, main_T_warnHi, main_T_warnLo, main_T_limitHi, main_T_limitLo, main_V_warnHi, main_V_warnLo, main_V_limitHi, main_V_limitLo, reb_BULK_I_warnHi, reb_BULK_I_warnLo, reb_BULK_I_limitHi, reb_BULK_I_limitLo, reb_BULK_V_warnHi, reb_BULK_V_warnLo, reb_BULK_V_limitHi, reb_BULK_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48V_LimitsConfigurationEvent));
        Quadbox_PDU_48V_LimitsConfigurationEvent item_ = (Quadbox_PDU_48V_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)board_T_warnHi, (double)item_.getBoard_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_warnLo, (double)item_.getBoard_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitHi, (double)item_.getBoard_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitLo, (double)item_.getBoard_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_I_warnHi, (double)item_.getCryotel0_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_I_warnLo, (double)item_.getCryotel0_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_I_limitHi, (double)item_.getCryotel0_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_I_limitLo, (double)item_.getCryotel0_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_V_warnHi, (double)item_.getCryotel0_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_V_warnLo, (double)item_.getCryotel0_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_V_limitHi, (double)item_.getCryotel0_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_V_limitLo, (double)item_.getCryotel0_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_I_warnHi, (double)item_.getCryotel1_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_I_warnLo, (double)item_.getCryotel1_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_I_limitHi, (double)item_.getCryotel1_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_I_limitLo, (double)item_.getCryotel1_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_V_warnHi, (double)item_.getCryotel1_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_V_warnLo, (double)item_.getCryotel1_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_V_limitHi, (double)item_.getCryotel1_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_V_limitLo, (double)item_.getCryotel1_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_I_warnHi, (double)item_.getCryotel2_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_I_warnLo, (double)item_.getCryotel2_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_I_limitHi, (double)item_.getCryotel2_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_I_limitLo, (double)item_.getCryotel2_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_V_warnHi, (double)item_.getCryotel2_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_V_warnLo, (double)item_.getCryotel2_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_V_limitHi, (double)item_.getCryotel2_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_V_limitLo, (double)item_.getCryotel2_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnHi, (double)item_.getFpga_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnLo, (double)item_.getFpga_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitHi, (double)item_.getFpga_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitLo, (double)item_.getFpga_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnHi, (double)item_.getMain_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnLo, (double)item_.getMain_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitHi, (double)item_.getMain_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitLo, (double)item_.getMain_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnHi, (double)item_.getMain_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnLo, (double)item_.getMain_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitHi, (double)item_.getMain_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitLo, (double)item_.getMain_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnHi, (double)item_.getMain_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnLo, (double)item_.getMain_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitHi, (double)item_.getMain_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitLo, (double)item_.getMain_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_I_warnHi, (double)item_.getReb_BULK_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_I_warnLo, (double)item_.getReb_BULK_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_I_limitHi, (double)item_.getReb_BULK_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_I_limitLo, (double)item_.getReb_BULK_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_V_warnHi, (double)item_.getReb_BULK_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_V_warnLo, (double)item_.getReb_BULK_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_V_limitHi, (double)item_.getReb_BULK_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_V_limitLo, (double)item_.getReb_BULK_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48V_QuadboxConfigurationEvent() throws Exception {
        int priority = 257;
        String version = "k";
        int node = 297;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_48V_QuadboxConfigurationEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48V_QuadboxConfigurationEvent));
        Quadbox_PDU_48V_QuadboxConfigurationEvent item_ = (Quadbox_PDU_48V_QuadboxConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_5V_LimitsConfigurationEvent() throws Exception {
        int priority = 96;
        String version = "i";
        double otm_3_A_I_warnHi = 0.8187646269798279;
        double otm_3_A_I_warnLo = 0.4652571678161621;
        double otm_3_A_I_limitHi = 0.3246997594833374;
        double otm_3_A_I_limitLo = 0.7379271984100342;
        double otm_3_A_V_warnHi = 0.006887316703796387;
        double otm_3_A_V_warnLo = 0.4530452489852905;
        double otm_3_A_V_limitHi = 0.3875085115432739;
        double otm_3_A_V_limitLo = 0.721917450428009;
        double otm_3_B_I_warnHi = 0.27117353677749634;
        double otm_3_B_I_warnLo = 0.7593408823013306;
        double otm_3_B_I_limitHi = 0.7404987812042236;
        double otm_3_B_I_limitLo = 0.7256408929824829;
        double otm_3_B_V_warnHi = 0.854900598526001;
        double otm_3_B_V_warnLo = 0.157843f;
        double otm_3_B_V_limitHi = 0.583867609500885;
        double otm_3_B_V_limitLo = 0.5232800841331482;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_5V_LimitsConfigurationEvent(priority, version, otm_3_A_I_warnHi, otm_3_A_I_warnLo, otm_3_A_I_limitHi, otm_3_A_I_limitLo, otm_3_A_V_warnHi, otm_3_A_V_warnLo, otm_3_A_V_limitHi, otm_3_A_V_limitLo, otm_3_B_I_warnHi, otm_3_B_I_warnLo, otm_3_B_I_limitHi, otm_3_B_I_limitLo, otm_3_B_V_warnHi, otm_3_B_V_warnLo, otm_3_B_V_limitHi, otm_3_B_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5V_LimitsConfigurationEvent));
        Quadbox_PDU_5V_LimitsConfigurationEvent item_ = (Quadbox_PDU_5V_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)otm_3_A_I_warnHi, (double)item_.getOtm_3_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_warnLo, (double)item_.getOtm_3_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_limitHi, (double)item_.getOtm_3_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_limitLo, (double)item_.getOtm_3_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_warnHi, (double)item_.getOtm_3_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_warnLo, (double)item_.getOtm_3_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_limitHi, (double)item_.getOtm_3_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_limitLo, (double)item_.getOtm_3_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_warnHi, (double)item_.getOtm_3_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_warnLo, (double)item_.getOtm_3_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_limitHi, (double)item_.getOtm_3_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_limitLo, (double)item_.getOtm_3_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_warnHi, (double)item_.getOtm_3_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_warnLo, (double)item_.getOtm_3_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_limitHi, (double)item_.getOtm_3_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_limitLo, (double)item_.getOtm_3_B_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5V_QuadboxConfigurationEvent() throws Exception {
        int priority = 875;
        String version = "";
        int node = 97;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_5V_QuadboxConfigurationEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5V_QuadboxConfigurationEvent));
        Quadbox_PDU_5V_QuadboxConfigurationEvent item_ = (Quadbox_PDU_5V_QuadboxConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PeriodicTasksConfigurationEvent() throws Exception {
        int priority = 634;
        String version = "";
        int schedulers_default_nTasks = 461;
        int schedulers_default_nThreads = 987;
        int schedulers_monitor_update_publish_scheduler_nTasks = 277;
        int schedulers_monitor_update_publish_scheduler_nThreads = 806;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PeriodicTasksConfigurationEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PeriodicTasksConfigurationEvent));
        Quadbox_PeriodicTasksConfigurationEvent item_ = (Quadbox_PeriodicTasksConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveQuadbox_PeriodicTasks_timersConfigurationEvent() throws Exception {
        int priority = 120;
        String version = "m";
        long agentmonitorservice_taskPeriodMillis = 3L;
        long heartbeat_taskPeriodMillis = 921L;
        long monitor_check_taskPeriodMillis = 614L;
        long monitor_publish_taskPeriodMillis = 146L;
        long monitor_update_taskPeriodMillis = 796L;
        long runtimeinfo_taskPeriodMillis = 447L;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PeriodicTasks_timersConfigurationEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PeriodicTasks_timersConfigurationEvent));
        Quadbox_PeriodicTasks_timersConfigurationEvent item_ = (Quadbox_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PS_QuadboxConfigurationEvent() throws Exception {
        int priority = 407;
        String version = "";
        int node = 799;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent));
        Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent item_ = (Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_HardwareIdConfigurationEvent() throws Exception {
        int priority = 243;
        String version = "o";
        String location = "p";
        String manSerNum = "s";
        String name = "v";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_HardwareIdConfigurationEvent(priority, version, location, manSerNum, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_HardwareIdConfigurationEvent));
        Focal_plane_Ccd_HardwareIdConfigurationEvent item_ = (Focal_plane_Ccd_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)manSerNum, (Object)item_.getManSerNum());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_LimitsConfigurationEvent() throws Exception {
        int priority = 784;
        String version = "w";
        double[] gdv_warnHi = TestHelper.generateDoubleArray((int)9, (int)-1714684414);
        double[] gdv_warnLo = TestHelper.generateDoubleArray((int)9, (int)1354985125);
        double[] gdv_limitHi = TestHelper.generateDoubleArray((int)9, (int)-1638591183);
        double[] gdv_limitLo = TestHelper.generateDoubleArray((int)9, (int)1638982911);
        String location = "c";
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)9, (int)-895233117);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)9, (int)-257101977);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)9, (int)1954563438);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)9, (int)-728395100);
        double[] ogv_warnHi = TestHelper.generateDoubleArray((int)9, (int)-1446658328);
        double[] ogv_warnLo = TestHelper.generateDoubleArray((int)9, (int)1390118205);
        double[] ogv_limitHi = TestHelper.generateDoubleArray((int)9, (int)1524197295);
        double[] ogv_limitLo = TestHelper.generateDoubleArray((int)9, (int)-1836803446);
        double[] rdv_warnHi = TestHelper.generateDoubleArray((int)9, (int)2101257498);
        double[] rdv_warnLo = TestHelper.generateDoubleArray((int)9, (int)415312498);
        double[] rdv_limitHi = TestHelper.generateDoubleArray((int)9, (int)-2093817922);
        double[] rdv_limitLo = TestHelper.generateDoubleArray((int)9, (int)63630387);
        double[] temp_warnHi = TestHelper.generateDoubleArray((int)9, (int)505719461);
        double[] temp_warnLo = TestHelper.generateDoubleArray((int)9, (int)-1014717709);
        double[] temp_limitHi = TestHelper.generateDoubleArray((int)9, (int)5716337);
        double[] temp_limitLo = TestHelper.generateDoubleArray((int)9, (int)474056220);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_LimitsConfigurationEvent(priority, version, gdv_warnHi, gdv_warnLo, gdv_limitHi, gdv_limitLo, location, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, ogv_warnHi, ogv_warnLo, ogv_limitHi, ogv_limitLo, rdv_warnHi, rdv_warnLo, rdv_limitHi, rdv_limitLo, temp_warnHi, temp_warnLo, temp_limitHi, temp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_LimitsConfigurationEvent));
        Focal_plane_Ccd_LimitsConfigurationEvent item_ = (Focal_plane_Ccd_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])gdv_warnHi, (double[])item_.getGdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_warnLo, (double[])item_.getGdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitHi, (double[])item_.getGdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitLo, (double[])item_.getGdv_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnHi, (double[])item_.getOgv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnLo, (double[])item_.getOgv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitHi, (double[])item_.getOgv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitLo, (double[])item_.getOgv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnHi, (double[])item_.getRdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnLo, (double[])item_.getRdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitHi, (double[])item_.getRdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitLo, (double[])item_.getRdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnHi, (double[])item_.getTemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnLo, (double[])item_.getTemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitHi, (double[])item_.getTemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitLo, (double[])item_.getTemp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_RaftsConfigurationEvent() throws Exception {
        int priority = 704;
        String version = "d";
        String location = "g";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_RaftsConfigurationEvent(priority, version, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_RaftsConfigurationEvent));
        Focal_plane_Ccd_RaftsConfigurationEvent item_ = (Focal_plane_Ccd_RaftsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_ImageDatabaseServiceConfigurationEvent() throws Exception {
        int priority = 867;
        String version = "p";
        String dbURL = "s";
        boolean enabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageDatabaseServiceConfigurationEvent(priority, version, dbURL, enabled));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageDatabaseServiceConfigurationEvent));
        Focal_plane_ImageDatabaseServiceConfigurationEvent item_ = (Focal_plane_ImageDatabaseServiceConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)enabled, (Object)item_.isEnabled());
    }

    @Test
    public void sendReceiveFocal_plane_ImageNameServiceConfigurationEvent() throws Exception {
        int priority = 539;
        String version = "j";
        String controller = "";
        String dbURL = "v";
        String offset = "";
        String source = "a";
        String timeZoneId = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageNameServiceConfigurationEvent(priority, version, controller, dbURL, offset, source, timeZoneId));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageNameServiceConfigurationEvent));
        Focal_plane_ImageNameServiceConfigurationEvent item_ = (Focal_plane_ImageNameServiceConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)controller, (Object)item_.getController());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)offset, (Object)item_.getOffset());
        Assert.assertEquals((Object)source, (Object)item_.getSource());
        Assert.assertEquals((Object)timeZoneId, (Object)item_.getTimeZoneId());
    }

    @Test
    public void sendReceiveFocal_plane_InstrumentConfig_InstrumentConfigurationEvent() throws Exception {
        int priority = 717;
        String version = "g";
        String instrument = "";
        String telescope = "x";
        String testStand = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_InstrumentConfig_InstrumentConfigurationEvent(priority, version, instrument, telescope, testStand));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_InstrumentConfig_InstrumentConfigurationEvent));
        Focal_plane_InstrumentConfig_InstrumentConfigurationEvent item_ = (Focal_plane_InstrumentConfig_InstrumentConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)instrument, (Object)item_.getInstrument());
        Assert.assertEquals((Object)telescope, (Object)item_.getTelescope());
        Assert.assertEquals((Object)testStand, (Object)item_.getTestStand());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasksConfigurationEvent() throws Exception {
        int priority = 507;
        String version = "";
        int schedulers_default_nTasks = 455;
        int schedulers_default_nThreads = 979;
        int schedulers_monitor_check_scheduler_nTasks = 629;
        int schedulers_monitor_check_scheduler_nThreads = 719;
        int schedulers_monitor_update_publish_scheduler_nTasks = 857;
        int schedulers_monitor_update_publish_scheduler_nThreads = 989;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasksConfigurationEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasksConfigurationEvent));
        Focal_plane_PeriodicTasksConfigurationEvent item_ = (Focal_plane_PeriodicTasksConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasks_timersConfigurationEvent() throws Exception {
        int priority = 2;
        String version = "i";
        long agentmonitorservice_taskPeriodMillis = 120L;
        long heartbeat_taskPeriodMillis = 846L;
        long monitor_publish_taskPeriodMillis = 799L;
        long monitor_update_taskPeriodMillis = 842L;
        long runtimeinfo_taskPeriodMillis = 551L;
        long tempcontrol_R22_taskPeriodMillis = 644L;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasks_timersConfigurationEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis, tempcontrol_R22_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasks_timersConfigurationEvent));
        Focal_plane_PeriodicTasks_timersConfigurationEvent item_ = (Focal_plane_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R22_taskPeriodMillis, (long)item_.getTempcontrol_R22_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_HardwareIdConfigurationEvent() throws Exception {
        int priority = 915;
        String version = "";
        String location = "c";
        String name = "g";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_HardwareIdConfigurationEvent(priority, version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_HardwareIdConfigurationEvent));
        Focal_plane_Raft_HardwareIdConfigurationEvent item_ = (Focal_plane_Raft_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlConfigurationEvent() throws Exception {
        int priority = 395;
        String version = "s";
        String location = "c";
        double[] tempcontrol_basePower = TestHelper.generateDoubleArray((int)1, (int)651483309);
        double[] tempcontrol_coefD = TestHelper.generateDoubleArray((int)1, (int)1388627728);
        double[] tempcontrol_coefI = TestHelper.generateDoubleArray((int)1, (int)-1400398560);
        double[] tempcontrol_coefP = TestHelper.generateDoubleArray((int)1, (int)-857651363);
        double[] tempcontrol_maxInput = TestHelper.generateDoubleArray((int)1, (int)-497956802);
        double[] tempcontrol_maxOutput = TestHelper.generateDoubleArray((int)1, (int)858873578);
        double[] tempcontrol_minInput = TestHelper.generateDoubleArray((int)1, (int)1564192294);
        double[] tempcontrol_minOutput = TestHelper.generateDoubleArray((int)1, (int)449233408);
        String tempcontrol_rebs = "q";
        double[] tempcontrol_setTemp = TestHelper.generateDoubleArray((int)1, (int)-1372397901);
        double[] tempcontrol_smoothTime = TestHelper.generateDoubleArray((int)1, (int)1812028044);
        String tempcontrol_tempChans = "c";
        double[] tempcontrol_timeConst = TestHelper.generateDoubleArray((int)1, (int)-865855271);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlConfigurationEvent(priority, version, location, tempcontrol_basePower, tempcontrol_coefD, tempcontrol_coefI, tempcontrol_coefP, tempcontrol_maxInput, tempcontrol_maxOutput, tempcontrol_minInput, tempcontrol_minOutput, tempcontrol_rebs, tempcontrol_setTemp, tempcontrol_smoothTime, tempcontrol_tempChans, tempcontrol_timeConst));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlConfigurationEvent));
        Focal_plane_Raft_RaftTempControlConfigurationEvent item_ = (Focal_plane_Raft_RaftTempControlConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])tempcontrol_basePower, (double[])item_.getTempcontrol_basePower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefD, (double[])item_.getTempcontrol_coefD(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefI, (double[])item_.getTempcontrol_coefI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefP, (double[])item_.getTempcontrol_coefP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxInput, (double[])item_.getTempcontrol_maxInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxOutput, (double[])item_.getTempcontrol_maxOutput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minInput, (double[])item_.getTempcontrol_minInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minOutput, (double[])item_.getTempcontrol_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_rebs, (Object)item_.getTempcontrol_rebs());
        Assert.assertArrayEquals((double[])tempcontrol_setTemp, (double[])item_.getTempcontrol_setTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_smoothTime, (double[])item_.getTempcontrol_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_tempChans, (Object)item_.getTempcontrol_tempChans());
        Assert.assertArrayEquals((double[])tempcontrol_timeConst, (double[])item_.getTempcontrol_timeConst(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlStatusConfigurationEvent() throws Exception {
        int priority = 736;
        String version = "";
        String location = "";
        boolean[] tempcontrol_active = new boolean[]{false};
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlStatusConfigurationEvent(priority, version, location, tempcontrol_active));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlStatusConfigurationEvent));
        Focal_plane_Raft_RaftTempControlStatusConfigurationEvent item_ = (Focal_plane_Raft_RaftTempControlStatusConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((boolean[])tempcontrol_active, (boolean[])item_.getTempcontrol_active());
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPower_LimitsConfigurationEvent() throws Exception {
        int priority = 458;
        String version = "";
        double warnHi = 0.20062655210494995;
        double warnLo = 0.5253089070320129;
        double limitHi = 0.49706172943115234;
        double limitLo = 0.1789099f;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_RebTotalPower_LimitsConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPower_LimitsConfigurationEvent));
        Focal_plane_RebTotalPower_LimitsConfigurationEvent item_ = (Focal_plane_RebTotalPower_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_HardwareIdConfigurationEvent() throws Exception {
        int priority = 391;
        String version = "";
        String location = "";
        String name = "u";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_HardwareIdConfigurationEvent(priority, version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_HardwareIdConfigurationEvent));
        Focal_plane_Reb_HardwareIdConfigurationEvent item_ = (Focal_plane_Reb_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_LimitsConfigurationEvent() throws Exception {
        int priority = 554;
        String version = "";
        double[] anai_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1675318181);
        double[] anai_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1713816509);
        double[] anai_limitHi = TestHelper.generateDoubleArray((int)3, (int)931014788);
        double[] anai_limitLo = TestHelper.generateDoubleArray((int)3, (int)347920369);
        double[] anav_warnHi = TestHelper.generateDoubleArray((int)3, (int)-333012064);
        double[] anav_warnLo = TestHelper.generateDoubleArray((int)3, (int)185291358);
        double[] anav_limitHi = TestHelper.generateDoubleArray((int)3, (int)149040896);
        double[] anav_limitLo = TestHelper.generateDoubleArray((int)3, (int)1942839409);
        double[] aspicl_Temp0_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1262948602);
        double[] aspicl_Temp0_warnLo = TestHelper.generateDoubleArray((int)3, (int)862937636);
        double[] aspicl_Temp0_limitHi = TestHelper.generateDoubleArray((int)3, (int)1278678638);
        double[] aspicl_Temp0_limitLo = TestHelper.generateDoubleArray((int)3, (int)780745161);
        double[] aspicl_Temp1_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1210596624);
        double[] aspicl_Temp1_warnLo = TestHelper.generateDoubleArray((int)3, (int)-429257688);
        double[] aspicl_Temp1_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1221344927);
        double[] aspicl_Temp1_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1745389420);
        double[] aspicl_Temp2_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1141551173);
        double[] aspicl_Temp2_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1369947344);
        double[] aspicl_Temp2_limitHi = TestHelper.generateDoubleArray((int)3, (int)2044927422);
        double[] aspicl_Temp2_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1637422863);
        double[] aspicu_Temp0_warnHi = TestHelper.generateDoubleArray((int)3, (int)272998655);
        double[] aspicu_Temp0_warnLo = TestHelper.generateDoubleArray((int)3, (int)371487784);
        double[] aspicu_Temp0_limitHi = TestHelper.generateDoubleArray((int)3, (int)33251233);
        double[] aspicu_Temp0_limitLo = TestHelper.generateDoubleArray((int)3, (int)1487600022);
        double[] aspicu_Temp1_warnHi = TestHelper.generateDoubleArray((int)3, (int)2035461396);
        double[] aspicu_Temp1_warnLo = TestHelper.generateDoubleArray((int)3, (int)804370776);
        double[] aspicu_Temp1_limitHi = TestHelper.generateDoubleArray((int)3, (int)1840481921);
        double[] aspicu_Temp1_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1244412885);
        double[] aspicu_Temp2_warnHi = TestHelper.generateDoubleArray((int)3, (int)-549234473);
        double[] aspicu_Temp2_warnLo = TestHelper.generateDoubleArray((int)3, (int)124423385);
        double[] aspicu_Temp2_limitHi = TestHelper.generateDoubleArray((int)3, (int)109678737);
        double[] aspicu_Temp2_limitLo = TestHelper.generateDoubleArray((int)3, (int)-303184171);
        double[] clkhi_warnHi = TestHelper.generateDoubleArray((int)3, (int)-56069203);
        double[] clkhi_warnLo = TestHelper.generateDoubleArray((int)3, (int)86224453);
        double[] clkhi_limitHi = TestHelper.generateDoubleArray((int)3, (int)1185808489);
        double[] clkhi_limitLo = TestHelper.generateDoubleArray((int)3, (int)-703913200);
        double[] clkhv_warnHi = TestHelper.generateDoubleArray((int)3, (int)944697287);
        double[] clkhv_warnLo = TestHelper.generateDoubleArray((int)3, (int)1650143149);
        double[] clkhv_limitHi = TestHelper.generateDoubleArray((int)3, (int)1341102309);
        double[] clkhv_limitLo = TestHelper.generateDoubleArray((int)3, (int)1000437185);
        double[] clkli_warnHi = TestHelper.generateDoubleArray((int)3, (int)1724308135);
        double[] clkli_warnLo = TestHelper.generateDoubleArray((int)3, (int)1684463055);
        double[] clkli_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1823706291);
        double[] clkli_limitLo = TestHelper.generateDoubleArray((int)3, (int)946117771);
        double[] clklv_warnHi = TestHelper.generateDoubleArray((int)3, (int)-851256861);
        double[] clklv_warnLo = TestHelper.generateDoubleArray((int)3, (int)1554282376);
        double[] clklv_limitHi = TestHelper.generateDoubleArray((int)3, (int)1392235446);
        double[] clklv_limitLo = TestHelper.generateDoubleArray((int)3, (int)-378012576);
        double[] digi_warnHi = TestHelper.generateDoubleArray((int)3, (int)-814993367);
        double[] digi_warnLo = TestHelper.generateDoubleArray((int)3, (int)1072785543);
        double[] digi_limitHi = TestHelper.generateDoubleArray((int)3, (int)-401186905);
        double[] digi_limitLo = TestHelper.generateDoubleArray((int)3, (int)-799728293);
        double[] digv_warnHi = TestHelper.generateDoubleArray((int)3, (int)-519860606);
        double[] digv_warnLo = TestHelper.generateDoubleArray((int)3, (int)-422118589);
        double[] digv_limitHi = TestHelper.generateDoubleArray((int)3, (int)1865980670);
        double[] digv_limitLo = TestHelper.generateDoubleArray((int)3, (int)710913997);
        double[] hvbiasswitch_warnHi = TestHelper.generateDoubleArray((int)3, (int)-756599334);
        double[] hvbiasswitch_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1192020434);
        double[] hvbiasswitch_limitHi = TestHelper.generateDoubleArray((int)3, (int)-19542252);
        double[] hvbiasswitch_limitLo = TestHelper.generateDoubleArray((int)3, (int)-619950443);
        double[] htrv_warnHi = TestHelper.generateDoubleArray((int)3, (int)1436232895);
        double[] htrv_warnLo = TestHelper.generateDoubleArray((int)3, (int)703977514);
        double[] htrv_limitHi = TestHelper.generateDoubleArray((int)3, (int)2091892767);
        double[] htrv_limitLo = TestHelper.generateDoubleArray((int)3, (int)-855600459);
        double[] htrw_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1980199575);
        double[] htrw_warnLo = TestHelper.generateDoubleArray((int)3, (int)940320828);
        double[] htrw_limitHi = TestHelper.generateDoubleArray((int)3, (int)-532032296);
        double[] htrw_limitLo = TestHelper.generateDoubleArray((int)3, (int)1978158113);
        String location = "d";
        double[] odi_warnHi = TestHelper.generateDoubleArray((int)3, (int)1685361757);
        double[] odi_warnLo = TestHelper.generateDoubleArray((int)3, (int)136639448);
        double[] odi_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1362807546);
        double[] odi_limitLo = TestHelper.generateDoubleArray((int)3, (int)-899277734);
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)3, (int)880320087);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1036408008);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1414777772);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1311006219);
        double[] pclkl_warnHi = TestHelper.generateDoubleArray((int)3, (int)1077313887);
        double[] pclkl_warnLo = TestHelper.generateDoubleArray((int)3, (int)925326478);
        double[] pclkl_limitHi = TestHelper.generateDoubleArray((int)3, (int)2045514726);
        double[] pclkl_limitLo = TestHelper.generateDoubleArray((int)3, (int)639418088);
        double[] pclku_warnHi = TestHelper.generateDoubleArray((int)3, (int)2013467549);
        double[] pclku_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1307455252);
        double[] pclku_limitHi = TestHelper.generateDoubleArray((int)3, (int)328977206);
        double[] pclku_limitLo = TestHelper.generateDoubleArray((int)3, (int)-2100221899);
        double[] power_warnHi = TestHelper.generateDoubleArray((int)3, (int)56504754);
        double[] power_warnLo = TestHelper.generateDoubleArray((int)3, (int)1673514815);
        double[] power_limitHi = TestHelper.generateDoubleArray((int)3, (int)1393596098);
        double[] power_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1545785992);
        double[] rgl_warnHi = TestHelper.generateDoubleArray((int)3, (int)2132543447);
        double[] rgl_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1760192352);
        double[] rgl_limitHi = TestHelper.generateDoubleArray((int)3, (int)-869769270);
        double[] rgl_limitLo = TestHelper.generateDoubleArray((int)3, (int)-470155428);
        double[] rgu_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1099478714);
        double[] rgu_warnLo = TestHelper.generateDoubleArray((int)3, (int)197809642);
        double[] rgu_limitHi = TestHelper.generateDoubleArray((int)3, (int)-932422568);
        double[] rgu_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1897436847);
        double[] rtdtemp_warnHi = TestHelper.generateDoubleArray((int)3, (int)1627716056);
        double[] rtdtemp_warnLo = TestHelper.generateDoubleArray((int)3, (int)-242333044);
        double[] rtdtemp_limitHi = TestHelper.generateDoubleArray((int)3, (int)997141376);
        double[] rtdtemp_limitLo = TestHelper.generateDoubleArray((int)3, (int)-2121076101);
        double[] ref05v_warnHi = TestHelper.generateDoubleArray((int)3, (int)602451439);
        double[] ref05v_warnLo = TestHelper.generateDoubleArray((int)3, (int)182509727);
        double[] ref05v_limitHi = TestHelper.generateDoubleArray((int)3, (int)1631187433);
        double[] ref05v_limitLo = TestHelper.generateDoubleArray((int)3, (int)1742445037);
        double[] ref125v_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1590532971);
        double[] ref125v_warnLo = TestHelper.generateDoubleArray((int)3, (int)-885857734);
        double[] ref125v_limitHi = TestHelper.generateDoubleArray((int)3, (int)63978123);
        double[] ref125v_limitLo = TestHelper.generateDoubleArray((int)3, (int)-27745770);
        double[] ref15v_warnHi = TestHelper.generateDoubleArray((int)3, (int)322789349);
        double[] ref15v_warnLo = TestHelper.generateDoubleArray((int)3, (int)-253594619);
        double[] ref15v_limitHi = TestHelper.generateDoubleArray((int)3, (int)-955605063);
        double[] ref15v_limitLo = TestHelper.generateDoubleArray((int)3, (int)436019067);
        double[] ref25v_warnHi = TestHelper.generateDoubleArray((int)3, (int)762945449);
        double[] ref25v_warnLo = TestHelper.generateDoubleArray((int)3, (int)509846796);
        double[] ref25v_limitHi = TestHelper.generateDoubleArray((int)3, (int)1065648226);
        double[] ref25v_limitLo = TestHelper.generateDoubleArray((int)3, (int)249118374);
        double[] refn12_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1770003900);
        double[] refn12_warnLo = TestHelper.generateDoubleArray((int)3, (int)1472309205);
        double[] refn12_limitHi = TestHelper.generateDoubleArray((int)3, (int)1918453139);
        double[] refn12_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1378519715);
        double[] refp12_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1830137902);
        double[] refp12_warnLo = TestHelper.generateDoubleArray((int)3, (int)1741818035);
        double[] refp12_limitHi = TestHelper.generateDoubleArray((int)3, (int)-600703937);
        double[] refp12_limitLo = TestHelper.generateDoubleArray((int)3, (int)911414039);
        double[] sclkl_warnHi = TestHelper.generateDoubleArray((int)3, (int)-345361523);
        double[] sclkl_warnLo = TestHelper.generateDoubleArray((int)3, (int)-63670948);
        double[] sclkl_limitHi = TestHelper.generateDoubleArray((int)3, (int)2129413954);
        double[] sclkl_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1218386773);
        double[] sclku_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1657444494);
        double[] sclku_warnLo = TestHelper.generateDoubleArray((int)3, (int)-2050037319);
        double[] sclku_limitHi = TestHelper.generateDoubleArray((int)3, (int)842001827);
        double[] sclku_limitLo = TestHelper.generateDoubleArray((int)3, (int)-605429942);
        double[] temp10_warnHi = TestHelper.generateDoubleArray((int)3, (int)-395553245);
        double[] temp10_warnLo = TestHelper.generateDoubleArray((int)3, (int)1981765117);
        double[] temp10_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1931966183);
        double[] temp10_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1724971345);
        double[] temp1_warnHi = TestHelper.generateDoubleArray((int)3, (int)1858320143);
        double[] temp1_warnLo = TestHelper.generateDoubleArray((int)3, (int)1975063033);
        double[] temp1_limitHi = TestHelper.generateDoubleArray((int)3, (int)-143845168);
        double[] temp1_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1103297900);
        double[] temp2_warnHi = TestHelper.generateDoubleArray((int)3, (int)1271621839);
        double[] temp2_warnLo = TestHelper.generateDoubleArray((int)3, (int)1859498413);
        double[] temp2_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1690862484);
        double[] temp2_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1189013657);
        double[] temp3_warnHi = TestHelper.generateDoubleArray((int)3, (int)31329747);
        double[] temp3_warnLo = TestHelper.generateDoubleArray((int)3, (int)1430654753);
        double[] temp3_limitHi = TestHelper.generateDoubleArray((int)3, (int)-97903794);
        double[] temp3_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1029147075);
        double[] temp4_warnHi = TestHelper.generateDoubleArray((int)3, (int)1230720829);
        double[] temp4_warnLo = TestHelper.generateDoubleArray((int)3, (int)478780790);
        double[] temp4_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1713226731);
        double[] temp4_limitLo = TestHelper.generateDoubleArray((int)3, (int)-290449401);
        double[] temp5_warnHi = TestHelper.generateDoubleArray((int)3, (int)-309794292);
        double[] temp5_warnLo = TestHelper.generateDoubleArray((int)3, (int)1251957047);
        double[] temp5_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1543909273);
        double[] temp5_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1128622077);
        double[] temp6_warnHi = TestHelper.generateDoubleArray((int)3, (int)-107681155);
        double[] temp6_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1685788172);
        double[] temp6_limitHi = TestHelper.generateDoubleArray((int)3, (int)130267376);
        double[] temp6_limitLo = TestHelper.generateDoubleArray((int)3, (int)-974864012);
        double[] temp7_warnHi = TestHelper.generateDoubleArray((int)3, (int)989182381);
        double[] temp7_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1685206767);
        double[] temp7_limitHi = TestHelper.generateDoubleArray((int)3, (int)565822890);
        double[] temp7_limitLo = TestHelper.generateDoubleArray((int)3, (int)296273044);
        double[] temp8_warnHi = TestHelper.generateDoubleArray((int)3, (int)587915650);
        double[] temp8_warnLo = TestHelper.generateDoubleArray((int)3, (int)1996849627);
        double[] temp8_limitHi = TestHelper.generateDoubleArray((int)3, (int)1402205791);
        double[] temp8_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1385478455);
        double[] temp9_warnHi = TestHelper.generateDoubleArray((int)3, (int)313240268);
        double[] temp9_warnLo = TestHelper.generateDoubleArray((int)3, (int)1227710171);
        double[] temp9_limitHi = TestHelper.generateDoubleArray((int)3, (int)829734763);
        double[] temp9_limitLo = TestHelper.generateDoubleArray((int)3, (int)181191191);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_LimitsConfigurationEvent(priority, version, anai_warnHi, anai_warnLo, anai_limitHi, anai_limitLo, anav_warnHi, anav_warnLo, anav_limitHi, anav_limitLo, aspicl_Temp0_warnHi, aspicl_Temp0_warnLo, aspicl_Temp0_limitHi, aspicl_Temp0_limitLo, aspicl_Temp1_warnHi, aspicl_Temp1_warnLo, aspicl_Temp1_limitHi, aspicl_Temp1_limitLo, aspicl_Temp2_warnHi, aspicl_Temp2_warnLo, aspicl_Temp2_limitHi, aspicl_Temp2_limitLo, aspicu_Temp0_warnHi, aspicu_Temp0_warnLo, aspicu_Temp0_limitHi, aspicu_Temp0_limitLo, aspicu_Temp1_warnHi, aspicu_Temp1_warnLo, aspicu_Temp1_limitHi, aspicu_Temp1_limitLo, aspicu_Temp2_warnHi, aspicu_Temp2_warnLo, aspicu_Temp2_limitHi, aspicu_Temp2_limitLo, clkhi_warnHi, clkhi_warnLo, clkhi_limitHi, clkhi_limitLo, clkhv_warnHi, clkhv_warnLo, clkhv_limitHi, clkhv_limitLo, clkli_warnHi, clkli_warnLo, clkli_limitHi, clkli_limitLo, clklv_warnHi, clklv_warnLo, clklv_limitHi, clklv_limitLo, digi_warnHi, digi_warnLo, digi_limitHi, digi_limitLo, digv_warnHi, digv_warnLo, digv_limitHi, digv_limitLo, hvbiasswitch_warnHi, hvbiasswitch_warnLo, hvbiasswitch_limitHi, hvbiasswitch_limitLo, htrv_warnHi, htrv_warnLo, htrv_limitHi, htrv_limitLo, htrw_warnHi, htrw_warnLo, htrw_limitHi, htrw_limitLo, location, odi_warnHi, odi_warnLo, odi_limitHi, odi_limitLo, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, pclkl_warnHi, pclkl_warnLo, pclkl_limitHi, pclkl_limitLo, pclku_warnHi, pclku_warnLo, pclku_limitHi, pclku_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo, rgl_warnHi, rgl_warnLo, rgl_limitHi, rgl_limitLo, rgu_warnHi, rgu_warnLo, rgu_limitHi, rgu_limitLo, rtdtemp_warnHi, rtdtemp_warnLo, rtdtemp_limitHi, rtdtemp_limitLo, ref05v_warnHi, ref05v_warnLo, ref05v_limitHi, ref05v_limitLo, ref125v_warnHi, ref125v_warnLo, ref125v_limitHi, ref125v_limitLo, ref15v_warnHi, ref15v_warnLo, ref15v_limitHi, ref15v_limitLo, ref25v_warnHi, ref25v_warnLo, ref25v_limitHi, ref25v_limitLo, refn12_warnHi, refn12_warnLo, refn12_limitHi, refn12_limitLo, refp12_warnHi, refp12_warnLo, refp12_limitHi, refp12_limitLo, sclkl_warnHi, sclkl_warnLo, sclkl_limitHi, sclkl_limitLo, sclku_warnHi, sclku_warnLo, sclku_limitHi, sclku_limitLo, temp10_warnHi, temp10_warnLo, temp10_limitHi, temp10_limitLo, temp1_warnHi, temp1_warnLo, temp1_limitHi, temp1_limitLo, temp2_warnHi, temp2_warnLo, temp2_limitHi, temp2_limitLo, temp3_warnHi, temp3_warnLo, temp3_limitHi, temp3_limitLo, temp4_warnHi, temp4_warnLo, temp4_limitHi, temp4_limitLo, temp5_warnHi, temp5_warnLo, temp5_limitHi, temp5_limitLo, temp6_warnHi, temp6_warnLo, temp6_limitHi, temp6_limitLo, temp7_warnHi, temp7_warnLo, temp7_limitHi, temp7_limitLo, temp8_warnHi, temp8_warnLo, temp8_limitHi, temp8_limitLo, temp9_warnHi, temp9_warnLo, temp9_limitHi, temp9_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_LimitsConfigurationEvent));
        Focal_plane_Reb_LimitsConfigurationEvent item_ = (Focal_plane_Reb_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])anai_warnHi, (double[])item_.getAnai_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_warnLo, (double[])item_.getAnai_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitHi, (double[])item_.getAnai_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitLo, (double[])item_.getAnai_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnHi, (double[])item_.getAnav_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnLo, (double[])item_.getAnav_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitHi, (double[])item_.getAnav_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitLo, (double[])item_.getAnav_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnHi, (double[])item_.getAspicl_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnLo, (double[])item_.getAspicl_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitHi, (double[])item_.getAspicl_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitLo, (double[])item_.getAspicl_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_warnHi, (double[])item_.getAspicl_Temp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_warnLo, (double[])item_.getAspicl_Temp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_limitHi, (double[])item_.getAspicl_Temp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_limitLo, (double[])item_.getAspicl_Temp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_warnHi, (double[])item_.getAspicl_Temp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_warnLo, (double[])item_.getAspicl_Temp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_limitHi, (double[])item_.getAspicl_Temp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_limitLo, (double[])item_.getAspicl_Temp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnHi, (double[])item_.getAspicu_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnLo, (double[])item_.getAspicu_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitHi, (double[])item_.getAspicu_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitLo, (double[])item_.getAspicu_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_warnHi, (double[])item_.getAspicu_Temp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_warnLo, (double[])item_.getAspicu_Temp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_limitHi, (double[])item_.getAspicu_Temp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_limitLo, (double[])item_.getAspicu_Temp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_warnHi, (double[])item_.getAspicu_Temp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_warnLo, (double[])item_.getAspicu_Temp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_limitHi, (double[])item_.getAspicu_Temp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_limitLo, (double[])item_.getAspicu_Temp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnHi, (double[])item_.getClkhi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnLo, (double[])item_.getClkhi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitHi, (double[])item_.getClkhi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitLo, (double[])item_.getClkhi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnHi, (double[])item_.getClkhv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnLo, (double[])item_.getClkhv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitHi, (double[])item_.getClkhv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitLo, (double[])item_.getClkhv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_warnHi, (double[])item_.getClkli_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_warnLo, (double[])item_.getClkli_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_limitHi, (double[])item_.getClkli_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_limitLo, (double[])item_.getClkli_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnHi, (double[])item_.getClklv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnLo, (double[])item_.getClklv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitHi, (double[])item_.getClklv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitLo, (double[])item_.getClklv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnHi, (double[])item_.getDigi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnLo, (double[])item_.getDigi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitHi, (double[])item_.getDigi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitLo, (double[])item_.getDigi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnHi, (double[])item_.getDigv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnLo, (double[])item_.getDigv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitHi, (double[])item_.getDigv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitLo, (double[])item_.getDigv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnHi, (double[])item_.getHvbiasswitch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnLo, (double[])item_.getHvbiasswitch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitHi, (double[])item_.getHvbiasswitch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitLo, (double[])item_.getHvbiasswitch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnHi, (double[])item_.getHtrv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnLo, (double[])item_.getHtrv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitHi, (double[])item_.getHtrv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitLo, (double[])item_.getHtrv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnHi, (double[])item_.getHtrw_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnLo, (double[])item_.getHtrw_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitHi, (double[])item_.getHtrw_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitLo, (double[])item_.getHtrw_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odi_warnHi, (double[])item_.getOdi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_warnLo, (double[])item_.getOdi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitHi, (double[])item_.getOdi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitLo, (double[])item_.getOdi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnHi, (double[])item_.getPclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnLo, (double[])item_.getPclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitHi, (double[])item_.getPclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitLo, (double[])item_.getPclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnHi, (double[])item_.getPclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnLo, (double[])item_.getPclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitHi, (double[])item_.getPclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitLo, (double[])item_.getPclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnHi, (double[])item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnLo, (double[])item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitHi, (double[])item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitLo, (double[])item_.getPower_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnHi, (double[])item_.getRgl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnLo, (double[])item_.getRgl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitHi, (double[])item_.getRgl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitLo, (double[])item_.getRgl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnHi, (double[])item_.getRgu_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnLo, (double[])item_.getRgu_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitHi, (double[])item_.getRgu_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitLo, (double[])item_.getRgu_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnHi, (double[])item_.getRtdtemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnLo, (double[])item_.getRtdtemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitHi, (double[])item_.getRtdtemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitLo, (double[])item_.getRtdtemp_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_warnHi, (double[])item_.getRef05v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_warnLo, (double[])item_.getRef05v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_limitHi, (double[])item_.getRef05v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_limitLo, (double[])item_.getRef05v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_warnHi, (double[])item_.getRef125v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_warnLo, (double[])item_.getRef125v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_limitHi, (double[])item_.getRef125v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_limitLo, (double[])item_.getRef125v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_warnHi, (double[])item_.getRef15v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_warnLo, (double[])item_.getRef15v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_limitHi, (double[])item_.getRef15v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_limitLo, (double[])item_.getRef15v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_warnHi, (double[])item_.getRef25v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_warnLo, (double[])item_.getRef25v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_limitHi, (double[])item_.getRef25v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_limitLo, (double[])item_.getRef25v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_warnHi, (double[])item_.getRefn12_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_warnLo, (double[])item_.getRefn12_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_limitHi, (double[])item_.getRefn12_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_limitLo, (double[])item_.getRefn12_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_warnHi, (double[])item_.getRefp12_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_warnLo, (double[])item_.getRefp12_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_limitHi, (double[])item_.getRefp12_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_limitLo, (double[])item_.getRefp12_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnHi, (double[])item_.getSclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnLo, (double[])item_.getSclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitHi, (double[])item_.getSclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitLo, (double[])item_.getSclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnHi, (double[])item_.getSclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnLo, (double[])item_.getSclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitHi, (double[])item_.getSclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitLo, (double[])item_.getSclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_warnHi, (double[])item_.getTemp10_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_warnLo, (double[])item_.getTemp10_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_limitHi, (double[])item_.getTemp10_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_limitLo, (double[])item_.getTemp10_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnHi, (double[])item_.getTemp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnLo, (double[])item_.getTemp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitHi, (double[])item_.getTemp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitLo, (double[])item_.getTemp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnHi, (double[])item_.getTemp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnLo, (double[])item_.getTemp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitHi, (double[])item_.getTemp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitLo, (double[])item_.getTemp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnHi, (double[])item_.getTemp3_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnLo, (double[])item_.getTemp3_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitHi, (double[])item_.getTemp3_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitLo, (double[])item_.getTemp3_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnHi, (double[])item_.getTemp4_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnLo, (double[])item_.getTemp4_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitHi, (double[])item_.getTemp4_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitLo, (double[])item_.getTemp4_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnHi, (double[])item_.getTemp5_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnLo, (double[])item_.getTemp5_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitHi, (double[])item_.getTemp5_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitLo, (double[])item_.getTemp5_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnHi, (double[])item_.getTemp6_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnLo, (double[])item_.getTemp6_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitHi, (double[])item_.getTemp6_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitLo, (double[])item_.getTemp6_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_warnHi, (double[])item_.getTemp7_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_warnLo, (double[])item_.getTemp7_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_limitHi, (double[])item_.getTemp7_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_limitLo, (double[])item_.getTemp7_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_warnHi, (double[])item_.getTemp8_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_warnLo, (double[])item_.getTemp8_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_limitHi, (double[])item_.getTemp8_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_limitLo, (double[])item_.getTemp8_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_warnHi, (double[])item_.getTemp9_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_warnLo, (double[])item_.getTemp9_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_limitHi, (double[])item_.getTemp9_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_limitLo, (double[])item_.getTemp9_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsConfigurationEvent() throws Exception {
        int priority = 947;
        String version = "";
        double[] bias0_csGateP = TestHelper.generateDoubleArray((int)3, (int)-586262842);
        double[] bias0_gdP = TestHelper.generateDoubleArray((int)3, (int)-915609642);
        double[] bias0_odP = TestHelper.generateDoubleArray((int)3, (int)181013538);
        double[] bias0_ogP = TestHelper.generateDoubleArray((int)3, (int)-85763947);
        double[] bias0_rdP = TestHelper.generateDoubleArray((int)3, (int)56708417);
        double[] bias1_csGateP = TestHelper.generateDoubleArray((int)3, (int)1098185380);
        double[] bias1_gdP = TestHelper.generateDoubleArray((int)3, (int)874118948);
        double[] bias1_odP = TestHelper.generateDoubleArray((int)3, (int)1074014218);
        double[] bias1_ogP = TestHelper.generateDoubleArray((int)3, (int)1693775888);
        double[] bias1_rdP = TestHelper.generateDoubleArray((int)3, (int)-266775652);
        double[] bias2_csGateP = TestHelper.generateDoubleArray((int)3, (int)-368689778);
        double[] bias2_gdP = TestHelper.generateDoubleArray((int)3, (int)-527394669);
        double[] bias2_odP = TestHelper.generateDoubleArray((int)3, (int)1332637320);
        double[] bias2_ogP = TestHelper.generateDoubleArray((int)3, (int)-846100793);
        double[] bias2_rdP = TestHelper.generateDoubleArray((int)3, (int)-1165476451);
        double[] dac_pclkHighP = TestHelper.generateDoubleArray((int)3, (int)-2143797095);
        double[] dac_pclkLowP = TestHelper.generateDoubleArray((int)3, (int)1920147496);
        double[] dac_rgHighP = TestHelper.generateDoubleArray((int)3, (int)1208605394);
        double[] dac_rgLowP = TestHelper.generateDoubleArray((int)3, (int)-985190254);
        double[] dac_sclkHighP = TestHelper.generateDoubleArray((int)3, (int)2033867771);
        double[] dac_sclkLowP = TestHelper.generateDoubleArray((int)3, (int)-1123006755);
        boolean[] disableRTDHardwareCheck = new boolean[]{true, false, false};
        String location = "h";
        long[] serialNum = TestHelper.generateLongArray((int)3, (int)2013296852);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsConfigurationEvent(priority, version, bias0_csGateP, bias0_gdP, bias0_odP, bias0_ogP, bias0_rdP, bias1_csGateP, bias1_gdP, bias1_odP, bias1_ogP, bias1_rdP, bias2_csGateP, bias2_gdP, bias2_odP, bias2_ogP, bias2_rdP, dac_pclkHighP, dac_pclkLowP, dac_rgHighP, dac_rgLowP, dac_sclkHighP, dac_sclkLowP, disableRTDHardwareCheck, location, serialNum));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsConfigurationEvent));
        Focal_plane_Reb_RaftsConfigurationEvent item_ = (Focal_plane_Reb_RaftsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_csGateP, (double[])item_.getBias0_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdP, (double[])item_.getBias0_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odP, (double[])item_.getBias0_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogP, (double[])item_.getBias0_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdP, (double[])item_.getBias0_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_csGateP, (double[])item_.getBias1_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdP, (double[])item_.getBias1_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odP, (double[])item_.getBias1_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogP, (double[])item_.getBias1_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdP, (double[])item_.getBias1_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_csGateP, (double[])item_.getBias2_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdP, (double[])item_.getBias2_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odP, (double[])item_.getBias2_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogP, (double[])item_.getBias2_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdP, (double[])item_.getBias2_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighP, (double[])item_.getDac_pclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowP, (double[])item_.getDac_pclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighP, (double[])item_.getDac_rgHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowP, (double[])item_.getDac_rgLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighP, (double[])item_.getDac_sclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowP, (double[])item_.getDac_sclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((boolean[])disableRTDHardwareCheck, (boolean[])item_.getDisableRTDHardwareCheck());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])serialNum, (long[])item_.getSerialNum());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsLimitsConfigurationEvent() throws Exception {
        int priority = 869;
        String version = "v";
        double[] bias0_gdMax = TestHelper.generateDoubleArray((int)3, (int)828101618);
        double[] bias0_gdMin = TestHelper.generateDoubleArray((int)3, (int)-1430241487);
        double[] bias0_odMax = TestHelper.generateDoubleArray((int)3, (int)-1347887217);
        double[] bias0_odMin = TestHelper.generateDoubleArray((int)3, (int)-1174108690);
        double[] bias0_ogMax = TestHelper.generateDoubleArray((int)3, (int)-1716589409);
        double[] bias0_ogMin = TestHelper.generateDoubleArray((int)3, (int)462331600);
        double[] bias0_rdMax = TestHelper.generateDoubleArray((int)3, (int)-1831269499);
        double[] bias0_rdMin = TestHelper.generateDoubleArray((int)3, (int)-8655999);
        double[] bias1_gdMax = TestHelper.generateDoubleArray((int)3, (int)-1642898302);
        double[] bias1_gdMin = TestHelper.generateDoubleArray((int)3, (int)-780151943);
        double[] bias1_odMax = TestHelper.generateDoubleArray((int)3, (int)328563532);
        double[] bias1_odMin = TestHelper.generateDoubleArray((int)3, (int)-1581278651);
        double[] bias1_ogMax = TestHelper.generateDoubleArray((int)3, (int)1025037663);
        double[] bias1_ogMin = TestHelper.generateDoubleArray((int)3, (int)933767471);
        double[] bias1_rdMax = TestHelper.generateDoubleArray((int)3, (int)-505598741);
        double[] bias1_rdMin = TestHelper.generateDoubleArray((int)3, (int)1185565708);
        double[] bias2_gdMax = TestHelper.generateDoubleArray((int)3, (int)-1990500234);
        double[] bias2_gdMin = TestHelper.generateDoubleArray((int)3, (int)-1126458828);
        double[] bias2_odMax = TestHelper.generateDoubleArray((int)3, (int)-159256652);
        double[] bias2_odMin = TestHelper.generateDoubleArray((int)3, (int)-738476050);
        double[] bias2_ogMax = TestHelper.generateDoubleArray((int)3, (int)-130830295);
        double[] bias2_ogMin = TestHelper.generateDoubleArray((int)3, (int)961145312);
        double[] bias2_rdMax = TestHelper.generateDoubleArray((int)3, (int)-1440069500);
        double[] bias2_rdMin = TestHelper.generateDoubleArray((int)3, (int)1424753465);
        double[] dac_pclkHighMax = TestHelper.generateDoubleArray((int)3, (int)1307076576);
        double[] dac_pclkHighMin = TestHelper.generateDoubleArray((int)3, (int)-1002366797);
        double[] dac_pclkLowMax = TestHelper.generateDoubleArray((int)3, (int)-942221751);
        double[] dac_pclkLowMin = TestHelper.generateDoubleArray((int)3, (int)-688532059);
        double[] dac_rgHighMax = TestHelper.generateDoubleArray((int)3, (int)-305037776);
        double[] dac_rgHighMin = TestHelper.generateDoubleArray((int)3, (int)1318749614);
        double[] dac_rgLowMax = TestHelper.generateDoubleArray((int)3, (int)-356844860);
        double[] dac_rgLowMin = TestHelper.generateDoubleArray((int)3, (int)-1821991732);
        double[] dac_sclkHighMax = TestHelper.generateDoubleArray((int)3, (int)-397599430);
        double[] dac_sclkHighMin = TestHelper.generateDoubleArray((int)3, (int)700993758);
        double[] dac_sclkLowMax = TestHelper.generateDoubleArray((int)3, (int)1039190927);
        double[] dac_sclkLowMin = TestHelper.generateDoubleArray((int)3, (int)-516580648);
        String location = "m";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsLimitsConfigurationEvent(priority, version, bias0_gdMax, bias0_gdMin, bias0_odMax, bias0_odMin, bias0_ogMax, bias0_ogMin, bias0_rdMax, bias0_rdMin, bias1_gdMax, bias1_gdMin, bias1_odMax, bias1_odMin, bias1_ogMax, bias1_ogMin, bias1_rdMax, bias1_rdMin, bias2_gdMax, bias2_gdMin, bias2_odMax, bias2_odMin, bias2_ogMax, bias2_ogMin, bias2_rdMax, bias2_rdMin, dac_pclkHighMax, dac_pclkHighMin, dac_pclkLowMax, dac_pclkLowMin, dac_rgHighMax, dac_rgHighMin, dac_rgLowMax, dac_rgLowMin, dac_sclkHighMax, dac_sclkHighMin, dac_sclkLowMax, dac_sclkLowMin, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsLimitsConfigurationEvent));
        Focal_plane_Reb_RaftsLimitsConfigurationEvent item_ = (Focal_plane_Reb_RaftsLimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdMax, (double[])item_.getBias0_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdMin, (double[])item_.getBias0_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMax, (double[])item_.getBias0_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMin, (double[])item_.getBias0_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMax, (double[])item_.getBias0_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMin, (double[])item_.getBias0_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMax, (double[])item_.getBias0_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMin, (double[])item_.getBias0_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdMax, (double[])item_.getBias1_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdMin, (double[])item_.getBias1_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odMax, (double[])item_.getBias1_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odMin, (double[])item_.getBias1_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogMax, (double[])item_.getBias1_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogMin, (double[])item_.getBias1_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdMax, (double[])item_.getBias1_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdMin, (double[])item_.getBias1_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdMax, (double[])item_.getBias2_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdMin, (double[])item_.getBias2_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odMax, (double[])item_.getBias2_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odMin, (double[])item_.getBias2_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogMax, (double[])item_.getBias2_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogMin, (double[])item_.getBias2_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdMax, (double[])item_.getBias2_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdMin, (double[])item_.getBias2_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMax, (double[])item_.getDac_pclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMin, (double[])item_.getDac_pclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMax, (double[])item_.getDac_pclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMin, (double[])item_.getDac_pclkLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMax, (double[])item_.getDac_rgHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMin, (double[])item_.getDac_rgHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMax, (double[])item_.getDac_rgLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMin, (double[])item_.getDac_rgLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMax, (double[])item_.getDac_sclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMin, (double[])item_.getDac_sclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMax, (double[])item_.getDac_sclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMin, (double[])item_.getDac_sclkLowMin(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsPowerConfigurationEvent() throws Exception {
        int priority = 432;
        String version = "";
        double[] bias0_gdCal = TestHelper.generateDoubleArray((int)3, (int)1049540063);
        double[] bias0_gdTestVolts = TestHelper.generateDoubleArray((int)3, (int)1078411180);
        double[] bias0_gdTol = TestHelper.generateDoubleArray((int)3, (int)-1374401647);
        double[] bias0_gdValueErr = TestHelper.generateDoubleArray((int)3, (int)-1434611159);
        double[] bias0_gdZeroErr = TestHelper.generateDoubleArray((int)3, (int)1073832072);
        double[] bias0_odCal = TestHelper.generateDoubleArray((int)3, (int)-1190018701);
        double[] bias0_odIMax = TestHelper.generateDoubleArray((int)3, (int)-1062984232);
        double[] bias0_odTol = TestHelper.generateDoubleArray((int)3, (int)-2028812166);
        double[] bias0_odZeroErr = TestHelper.generateDoubleArray((int)3, (int)565045903);
        double[] bias0_ogCal = TestHelper.generateDoubleArray((int)3, (int)937864108);
        double[] bias0_ogTestVolts = TestHelper.generateDoubleArray((int)3, (int)928030298);
        double[] bias0_ogTol = TestHelper.generateDoubleArray((int)3, (int)-1796951056);
        double[] bias0_ogValueErr = TestHelper.generateDoubleArray((int)3, (int)-974143367);
        double[] bias0_ogZeroErr = TestHelper.generateDoubleArray((int)3, (int)-2051961306);
        double[] bias0_rdCal = TestHelper.generateDoubleArray((int)3, (int)-253499929);
        double[] bias0_rdTestVolts = TestHelper.generateDoubleArray((int)3, (int)1743717347);
        double[] bias0_rdTol = TestHelper.generateDoubleArray((int)3, (int)-47808529);
        double[] bias0_rdValueErr = TestHelper.generateDoubleArray((int)3, (int)1108493183);
        double[] bias0_rdZeroErr = TestHelper.generateDoubleArray((int)3, (int)-383527811);
        double[] bias1_gdCal = TestHelper.generateDoubleArray((int)3, (int)998502583);
        double[] bias1_gdTestVolts = TestHelper.generateDoubleArray((int)3, (int)-292996120);
        double[] bias1_gdTol = TestHelper.generateDoubleArray((int)3, (int)1572424813);
        double[] bias1_gdValueErr = TestHelper.generateDoubleArray((int)3, (int)1436697617);
        double[] bias1_gdZeroErr = TestHelper.generateDoubleArray((int)3, (int)222230861);
        double[] bias1_odCal = TestHelper.generateDoubleArray((int)3, (int)-425238777);
        double[] bias1_odIMax = TestHelper.generateDoubleArray((int)3, (int)1054739547);
        double[] bias1_odTol = TestHelper.generateDoubleArray((int)3, (int)-1762536562);
        double[] bias1_odZeroErr = TestHelper.generateDoubleArray((int)3, (int)-144604228);
        double[] bias1_ogCal = TestHelper.generateDoubleArray((int)3, (int)1193988161);
        double[] bias1_ogTestVolts = TestHelper.generateDoubleArray((int)3, (int)1124318007);
        double[] bias1_ogTol = TestHelper.generateDoubleArray((int)3, (int)842356254);
        double[] bias1_ogValueErr = TestHelper.generateDoubleArray((int)3, (int)-611560128);
        double[] bias1_ogZeroErr = TestHelper.generateDoubleArray((int)3, (int)109395394);
        double[] bias1_rdCal = TestHelper.generateDoubleArray((int)3, (int)-1891950454);
        double[] bias1_rdTestVolts = TestHelper.generateDoubleArray((int)3, (int)1503687335);
        double[] bias1_rdTol = TestHelper.generateDoubleArray((int)3, (int)-1769728654);
        double[] bias1_rdValueErr = TestHelper.generateDoubleArray((int)3, (int)1416409617);
        double[] bias1_rdZeroErr = TestHelper.generateDoubleArray((int)3, (int)-1134793784);
        double[] bias2_gdCal = TestHelper.generateDoubleArray((int)3, (int)2128885655);
        double[] bias2_gdTestVolts = TestHelper.generateDoubleArray((int)3, (int)366891193);
        double[] bias2_gdTol = TestHelper.generateDoubleArray((int)3, (int)531224433);
        double[] bias2_gdValueErr = TestHelper.generateDoubleArray((int)3, (int)-124404247);
        double[] bias2_gdZeroErr = TestHelper.generateDoubleArray((int)3, (int)-655710492);
        double[] bias2_odCal = TestHelper.generateDoubleArray((int)3, (int)1415032320);
        double[] bias2_odIMax = TestHelper.generateDoubleArray((int)3, (int)-1795388022);
        double[] bias2_odTol = TestHelper.generateDoubleArray((int)3, (int)-1738524616);
        double[] bias2_odZeroErr = TestHelper.generateDoubleArray((int)3, (int)-890208690);
        double[] bias2_ogCal = TestHelper.generateDoubleArray((int)3, (int)7031721);
        double[] bias2_ogTestVolts = TestHelper.generateDoubleArray((int)3, (int)1409398089);
        double[] bias2_ogTol = TestHelper.generateDoubleArray((int)3, (int)-1078549398);
        double[] bias2_ogValueErr = TestHelper.generateDoubleArray((int)3, (int)1446821863);
        double[] bias2_ogZeroErr = TestHelper.generateDoubleArray((int)3, (int)500070336);
        double[] bias2_rdCal = TestHelper.generateDoubleArray((int)3, (int)1078941443);
        double[] bias2_rdTestVolts = TestHelper.generateDoubleArray((int)3, (int)377883121);
        double[] bias2_rdTol = TestHelper.generateDoubleArray((int)3, (int)-1784037676);
        double[] bias2_rdValueErr = TestHelper.generateDoubleArray((int)3, (int)2096314227);
        double[] bias2_rdZeroErr = TestHelper.generateDoubleArray((int)3, (int)548046560);
        double[] clkhiAmin = TestHelper.generateDoubleArray((int)3, (int)1107412114);
        double[] clkhiQmax = TestHelper.generateDoubleArray((int)3, (int)455849045);
        double[] clkliAmin = TestHelper.generateDoubleArray((int)3, (int)1323782593);
        double[] clkliQmax = TestHelper.generateDoubleArray((int)3, (int)-292770954);
        double[] dac_clkhIMax = TestHelper.generateDoubleArray((int)3, (int)-720768972);
        double[] dac_clklIMax = TestHelper.generateDoubleArray((int)3, (int)-1883430654);
        double[] dac_pclkHighCal = TestHelper.generateDoubleArray((int)3, (int)1057804658);
        double[] dac_pclkHighTestV = TestHelper.generateDoubleArray((int)3, (int)-211547468);
        double[] dac_pclkHighTol = TestHelper.generateDoubleArray((int)3, (int)1567374843);
        double[] dac_pclkHighValueErr = TestHelper.generateDoubleArray((int)3, (int)1574534742);
        double[] dac_pclkHighZeroErr = TestHelper.generateDoubleArray((int)3, (int)1652830790);
        double[] dac_pclkLowCal = TestHelper.generateDoubleArray((int)3, (int)-514473727);
        double[] dac_pclkLowTestV = TestHelper.generateDoubleArray((int)3, (int)1068795541);
        double[] dac_pclkLowTol = TestHelper.generateDoubleArray((int)3, (int)1781728369);
        double[] dac_pclkLowValueErr = TestHelper.generateDoubleArray((int)3, (int)1978641777);
        double[] dac_pclkLowZeroErr = TestHelper.generateDoubleArray((int)3, (int)-1459255644);
        double[] dac_rgHighCal = TestHelper.generateDoubleArray((int)3, (int)-389829165);
        double[] dac_rgHighTestV = TestHelper.generateDoubleArray((int)3, (int)-438794215);
        double[] dac_rgHighTol = TestHelper.generateDoubleArray((int)3, (int)-2135271099);
        double[] dac_rgHighValueErr = TestHelper.generateDoubleArray((int)3, (int)927590245);
        double[] dac_rgHighZeroErr = TestHelper.generateDoubleArray((int)3, (int)12102523);
        double[] dac_rgLowCal = TestHelper.generateDoubleArray((int)3, (int)1422701825);
        double[] dac_rgLowTestV = TestHelper.generateDoubleArray((int)3, (int)814026801);
        double[] dac_rgLowTol = TestHelper.generateDoubleArray((int)3, (int)-1158033292);
        double[] dac_rgLowValueErr = TestHelper.generateDoubleArray((int)3, (int)1461767516);
        double[] dac_rgLowZeroErr = TestHelper.generateDoubleArray((int)3, (int)-1134548914);
        double[] dac_sclkHighCal = TestHelper.generateDoubleArray((int)3, (int)1929794281);
        double[] dac_sclkHighTestV = TestHelper.generateDoubleArray((int)3, (int)-295004022);
        double[] dac_sclkHighTol = TestHelper.generateDoubleArray((int)3, (int)572622497);
        double[] dac_sclkHighValueErr = TestHelper.generateDoubleArray((int)3, (int)297021270);
        double[] dac_sclkHighZeroErr = TestHelper.generateDoubleArray((int)3, (int)-808871450);
        double[] dac_sclkLowCal = TestHelper.generateDoubleArray((int)3, (int)-536615346);
        double[] dac_sclkLowTestV = TestHelper.generateDoubleArray((int)3, (int)1654612074);
        double[] dac_sclkLowTol = TestHelper.generateDoubleArray((int)3, (int)-85709142);
        double[] dac_sclkLowValueErr = TestHelper.generateDoubleArray((int)3, (int)1225640465);
        double[] dac_sclkLowZeroErr = TestHelper.generateDoubleArray((int)3, (int)1002510585);
        String location = "";
        double[] maxDelta = TestHelper.generateDoubleArray((int)3, (int)-1867516586);
        double[] maxStep = TestHelper.generateDoubleArray((int)3, (int)-1832271686);
        double[] minTol = TestHelper.generateDoubleArray((int)3, (int)1791891260);
        int[] nPowerOnPub = TestHelper.generateIntArray((int)3, (int)1135965160);
        double[] odiAmin = TestHelper.generateDoubleArray((int)3, (int)1533116518);
        double[] odiQmax = TestHelper.generateDoubleArray((int)3, (int)-472306993);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsPowerConfigurationEvent(priority, version, bias0_gdCal, bias0_gdTestVolts, bias0_gdTol, bias0_gdValueErr, bias0_gdZeroErr, bias0_odCal, bias0_odIMax, bias0_odTol, bias0_odZeroErr, bias0_ogCal, bias0_ogTestVolts, bias0_ogTol, bias0_ogValueErr, bias0_ogZeroErr, bias0_rdCal, bias0_rdTestVolts, bias0_rdTol, bias0_rdValueErr, bias0_rdZeroErr, bias1_gdCal, bias1_gdTestVolts, bias1_gdTol, bias1_gdValueErr, bias1_gdZeroErr, bias1_odCal, bias1_odIMax, bias1_odTol, bias1_odZeroErr, bias1_ogCal, bias1_ogTestVolts, bias1_ogTol, bias1_ogValueErr, bias1_ogZeroErr, bias1_rdCal, bias1_rdTestVolts, bias1_rdTol, bias1_rdValueErr, bias1_rdZeroErr, bias2_gdCal, bias2_gdTestVolts, bias2_gdTol, bias2_gdValueErr, bias2_gdZeroErr, bias2_odCal, bias2_odIMax, bias2_odTol, bias2_odZeroErr, bias2_ogCal, bias2_ogTestVolts, bias2_ogTol, bias2_ogValueErr, bias2_ogZeroErr, bias2_rdCal, bias2_rdTestVolts, bias2_rdTol, bias2_rdValueErr, bias2_rdZeroErr, clkhiAmin, clkhiQmax, clkliAmin, clkliQmax, dac_clkhIMax, dac_clklIMax, dac_pclkHighCal, dac_pclkHighTestV, dac_pclkHighTol, dac_pclkHighValueErr, dac_pclkHighZeroErr, dac_pclkLowCal, dac_pclkLowTestV, dac_pclkLowTol, dac_pclkLowValueErr, dac_pclkLowZeroErr, dac_rgHighCal, dac_rgHighTestV, dac_rgHighTol, dac_rgHighValueErr, dac_rgHighZeroErr, dac_rgLowCal, dac_rgLowTestV, dac_rgLowTol, dac_rgLowValueErr, dac_rgLowZeroErr, dac_sclkHighCal, dac_sclkHighTestV, dac_sclkHighTol, dac_sclkHighValueErr, dac_sclkHighZeroErr, dac_sclkLowCal, dac_sclkLowTestV, dac_sclkLowTol, dac_sclkLowValueErr, dac_sclkLowZeroErr, location, maxDelta, maxStep, minTol, nPowerOnPub, odiAmin, odiQmax));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsPowerConfigurationEvent));
        Focal_plane_Reb_RaftsPowerConfigurationEvent item_ = (Focal_plane_Reb_RaftsPowerConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdCal, (double[])item_.getBias0_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTestVolts, (double[])item_.getBias0_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTol, (double[])item_.getBias0_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdValueErr, (double[])item_.getBias0_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdZeroErr, (double[])item_.getBias0_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odCal, (double[])item_.getBias0_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odIMax, (double[])item_.getBias0_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odTol, (double[])item_.getBias0_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odZeroErr, (double[])item_.getBias0_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogCal, (double[])item_.getBias0_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTestVolts, (double[])item_.getBias0_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTol, (double[])item_.getBias0_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogValueErr, (double[])item_.getBias0_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogZeroErr, (double[])item_.getBias0_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdCal, (double[])item_.getBias0_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTestVolts, (double[])item_.getBias0_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTol, (double[])item_.getBias0_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdValueErr, (double[])item_.getBias0_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdZeroErr, (double[])item_.getBias0_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdCal, (double[])item_.getBias1_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdTestVolts, (double[])item_.getBias1_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdTol, (double[])item_.getBias1_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdValueErr, (double[])item_.getBias1_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdZeroErr, (double[])item_.getBias1_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odCal, (double[])item_.getBias1_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odIMax, (double[])item_.getBias1_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odTol, (double[])item_.getBias1_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odZeroErr, (double[])item_.getBias1_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogCal, (double[])item_.getBias1_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogTestVolts, (double[])item_.getBias1_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogTol, (double[])item_.getBias1_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogValueErr, (double[])item_.getBias1_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogZeroErr, (double[])item_.getBias1_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdCal, (double[])item_.getBias1_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdTestVolts, (double[])item_.getBias1_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdTol, (double[])item_.getBias1_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdValueErr, (double[])item_.getBias1_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdZeroErr, (double[])item_.getBias1_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdCal, (double[])item_.getBias2_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdTestVolts, (double[])item_.getBias2_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdTol, (double[])item_.getBias2_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdValueErr, (double[])item_.getBias2_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdZeroErr, (double[])item_.getBias2_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odCal, (double[])item_.getBias2_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odIMax, (double[])item_.getBias2_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odTol, (double[])item_.getBias2_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odZeroErr, (double[])item_.getBias2_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogCal, (double[])item_.getBias2_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogTestVolts, (double[])item_.getBias2_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogTol, (double[])item_.getBias2_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogValueErr, (double[])item_.getBias2_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogZeroErr, (double[])item_.getBias2_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdCal, (double[])item_.getBias2_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdTestVolts, (double[])item_.getBias2_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdTol, (double[])item_.getBias2_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdValueErr, (double[])item_.getBias2_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdZeroErr, (double[])item_.getBias2_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiAmin, (double[])item_.getClkhiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiQmax, (double[])item_.getClkhiQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliAmin, (double[])item_.getClkliAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliQmax, (double[])item_.getClkliQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clkhIMax, (double[])item_.getDac_clkhIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clklIMax, (double[])item_.getDac_clklIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighCal, (double[])item_.getDac_pclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTestV, (double[])item_.getDac_pclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTol, (double[])item_.getDac_pclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighValueErr, (double[])item_.getDac_pclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighZeroErr, (double[])item_.getDac_pclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowCal, (double[])item_.getDac_pclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTestV, (double[])item_.getDac_pclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTol, (double[])item_.getDac_pclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowValueErr, (double[])item_.getDac_pclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowZeroErr, (double[])item_.getDac_pclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighCal, (double[])item_.getDac_rgHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTestV, (double[])item_.getDac_rgHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTol, (double[])item_.getDac_rgHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighValueErr, (double[])item_.getDac_rgHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighZeroErr, (double[])item_.getDac_rgHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowCal, (double[])item_.getDac_rgLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTestV, (double[])item_.getDac_rgLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTol, (double[])item_.getDac_rgLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowValueErr, (double[])item_.getDac_rgLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowZeroErr, (double[])item_.getDac_rgLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighCal, (double[])item_.getDac_sclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTestV, (double[])item_.getDac_sclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTol, (double[])item_.getDac_sclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighValueErr, (double[])item_.getDac_sclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighZeroErr, (double[])item_.getDac_sclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowCal, (double[])item_.getDac_sclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTestV, (double[])item_.getDac_sclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTol, (double[])item_.getDac_sclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowValueErr, (double[])item_.getDac_sclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowZeroErr, (double[])item_.getDac_sclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])maxDelta, (double[])item_.getMaxDelta(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])maxStep, (double[])item_.getMaxStep(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])minTol, (double[])item_.getMinTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((int[])nPowerOnPub, (int[])item_.getNPowerOnPub());
        Assert.assertArrayEquals((double[])odiAmin, (double[])item_.getOdiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odiQmax, (double[])item_.getOdiQmax(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_timersConfigurationEvent() throws Exception {
        int priority = 192;
        String version = "";
        String location = "";
        long[] periodictasks_monitor_check_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)-1497162935);
        long[] periodictasks_monitor_publish_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)-1090143313);
        long[] periodictasks_monitor_publish_biasVolt_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)-1950094253);
        long[] periodictasks_monitor_publish_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)-2047753023);
        long[] periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)-1330703127);
        long[] periodictasks_monitor_publish_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)441991698);
        long[] periodictasks_monitor_publish_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)-1374978215);
        long[] periodictasks_monitor_update_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)-1615826616);
        long[] periodictasks_monitor_update_biasVolt_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)758414116);
        long[] periodictasks_monitor_update_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)-872055301);
        long[] periodictasks_monitor_update_ccdCurrent_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)851076157);
        long[] periodictasks_monitor_update_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)930619769);
        long[] periodictasks_monitor_update_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)402366043);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_timersConfigurationEvent(priority, version, location, periodictasks_monitor_check_taskPeriodMillis, periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, periodictasks_monitor_publish_biasVolt_taskPeriodMillis, periodictasks_monitor_publish_boardPower_taskPeriodMillis, periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis, periodictasks_monitor_publish_rebTemp_taskPeriodMillis, periodictasks_monitor_publish_taskPeriodMillis, periodictasks_monitor_update_aspicTemp_taskPeriodMillis, periodictasks_monitor_update_biasVolt_taskPeriodMillis, periodictasks_monitor_update_boardPower_taskPeriodMillis, periodictasks_monitor_update_ccdCurrent_taskPeriodMillis, periodictasks_monitor_update_rebTemp_taskPeriodMillis, periodictasks_monitor_update_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_timersConfigurationEvent));
        Focal_plane_Reb_timersConfigurationEvent item_ = (Focal_plane_Reb_timersConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])periodictasks_monitor_check_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_check_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_biasVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_biasVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_ccdCurrent_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_biasVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_biasVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_ccdCurrent_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_ccdCurrent_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_Segment_LimitsConfigurationEvent() throws Exception {
        int priority = 58;
        String version = "o";
        double[] i_warnHi = TestHelper.generateDoubleArray((int)144, (int)1491523406);
        double[] i_warnLo = TestHelper.generateDoubleArray((int)144, (int)-1706020136);
        double[] i_limitHi = TestHelper.generateDoubleArray((int)144, (int)-924296501);
        double[] i_limitLo = TestHelper.generateDoubleArray((int)144, (int)1165559638);
        String location = "p";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Segment_LimitsConfigurationEvent(priority, version, i_warnHi, i_warnLo, i_limitHi, i_limitLo, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Segment_LimitsConfigurationEvent));
        Focal_plane_Segment_LimitsConfigurationEvent item_ = (Focal_plane_Segment_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])i_warnHi, (double[])item_.getI_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_warnLo, (double[])item_.getI_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_limitHi, (double[])item_.getI_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_limitLo, (double[])item_.getI_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_DAQConfigurationEvent() throws Exception {
        int priority = 525;
        String version = "v";
        int badPixelAlarmLimit = 297;
        String daqFolder = "";
        String daqPartition = "";
        boolean emulatedDAQ = true;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_DAQConfigurationEvent(priority, version, badPixelAlarmLimit, daqFolder, daqPartition, emulatedDAQ));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_DAQConfigurationEvent));
        Focal_plane_SequencerConfig_DAQConfigurationEvent item_ = (Focal_plane_SequencerConfig_DAQConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)badPixelAlarmLimit, (long)item_.getBadPixelAlarmLimit());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
        Assert.assertEquals((Object)emulatedDAQ, (Object)item_.isEmulatedDAQ());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_SequencerConfigurationEvent() throws Exception {
        int priority = 804;
        String version = "";
        String clearCountParameter = "";
        String clearMain = "t";
        String idleFlushMain = "";
        long idleFlushTimeout = 937L;
        String integrateMain = "";
        String metaDataRegisters = "";
        int overCols = 180;
        int overRows = 486;
        int postCols = 596;
        int postRows = 906;
        int preCols = 874;
        int preRows = 521;
        String pseudoReadMain = "";
        int readCols = 549;
        int readCols2 = 395;
        String readMain = "";
        int readRows = 969;
        String rowShiftForwardMain = "";
        String rowShiftReverseMain = "";
        boolean scanMode = false;
        String sequencer = "";
        String sequencerChecksums = "f";
        String shiftCountParameter = "c";
        boolean stepAfterIntegrate = false;
        int transparentMode = 641;
        int underCols = 965;
        boolean useParallelRegisters = false;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_SequencerConfigurationEvent(priority, version, clearCountParameter, clearMain, idleFlushMain, idleFlushTimeout, integrateMain, metaDataRegisters, overCols, overRows, postCols, postRows, preCols, preRows, pseudoReadMain, readCols, readCols2, readMain, readRows, rowShiftForwardMain, rowShiftReverseMain, scanMode, sequencer, sequencerChecksums, shiftCountParameter, stepAfterIntegrate, transparentMode, underCols, useParallelRegisters));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_SequencerConfigurationEvent));
        Focal_plane_SequencerConfig_SequencerConfigurationEvent item_ = (Focal_plane_SequencerConfig_SequencerConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)clearCountParameter, (Object)item_.getClearCountParameter());
        Assert.assertEquals((Object)clearMain, (Object)item_.getClearMain());
        Assert.assertEquals((Object)idleFlushMain, (Object)item_.getIdleFlushMain());
        Assert.assertEquals((long)idleFlushTimeout, (long)item_.getIdleFlushTimeout());
        Assert.assertEquals((Object)integrateMain, (Object)item_.getIntegrateMain());
        Assert.assertEquals((Object)metaDataRegisters, (Object)item_.getMetaDataRegisters());
        Assert.assertEquals((long)overCols, (long)item_.getOverCols());
        Assert.assertEquals((long)overRows, (long)item_.getOverRows());
        Assert.assertEquals((long)postCols, (long)item_.getPostCols());
        Assert.assertEquals((long)postRows, (long)item_.getPostRows());
        Assert.assertEquals((long)preCols, (long)item_.getPreCols());
        Assert.assertEquals((long)preRows, (long)item_.getPreRows());
        Assert.assertEquals((Object)pseudoReadMain, (Object)item_.getPseudoReadMain());
        Assert.assertEquals((long)readCols, (long)item_.getReadCols());
        Assert.assertEquals((long)readCols2, (long)item_.getReadCols2());
        Assert.assertEquals((Object)readMain, (Object)item_.getReadMain());
        Assert.assertEquals((long)readRows, (long)item_.getReadRows());
        Assert.assertEquals((Object)rowShiftForwardMain, (Object)item_.getRowShiftForwardMain());
        Assert.assertEquals((Object)rowShiftReverseMain, (Object)item_.getRowShiftReverseMain());
        Assert.assertEquals((Object)scanMode, (Object)item_.isScanMode());
        Assert.assertEquals((Object)sequencer, (Object)item_.getSequencer());
        Assert.assertEquals((Object)sequencerChecksums, (Object)item_.getSequencerChecksums());
        Assert.assertEquals((Object)shiftCountParameter, (Object)item_.getShiftCountParameter());
        Assert.assertEquals((Object)stepAfterIntegrate, (Object)item_.isStepAfterIntegrate());
        Assert.assertEquals((long)transparentMode, (long)item_.getTransparentMode());
        Assert.assertEquals((long)underCols, (long)item_.getUnderCols());
        Assert.assertEquals((Object)useParallelRegisters, (Object)item_.isUseParallelRegisters());
    }

    @Test
    public void sendReceiveFocal_plane_WebHooksConfig_VisualizationConfigurationEvent() throws Exception {
        int priority = 255;
        String version = "y";
        String webHooks = "n";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_WebHooksConfig_VisualizationConfigurationEvent(priority, version, webHooks));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_WebHooksConfig_VisualizationConfigurationEvent));
        Focal_plane_WebHooksConfig_VisualizationConfigurationEvent item_ = (Focal_plane_WebHooksConfig_VisualizationConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)webHooks, (Object)item_.getWebHooks());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_DAQConfigurationEvent() throws Exception {
        int priority = 321;
        String version = "";
        String imagehandlingconfig_daqFolder = "k";
        String imagehandlingconfig_daqPartition = "b";
        int imagehandlingconfig_daqThreads = 349;
        String imagehandlingconfig_locations = "e";
        boolean imagehandlingconfig_useStreaming = false;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_DAQConfigurationEvent(priority, version, imagehandlingconfig_daqFolder, imagehandlingconfig_daqPartition, imagehandlingconfig_daqThreads, imagehandlingconfig_locations, imagehandlingconfig_useStreaming));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_DAQConfigurationEvent));
        Image_handling_ImageHandler_DAQConfigurationEvent item_ = (Image_handling_ImageHandler_DAQConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)imagehandlingconfig_daqFolder, (Object)item_.getImagehandlingconfig_daqFolder());
        Assert.assertEquals((Object)imagehandlingconfig_daqPartition, (Object)item_.getImagehandlingconfig_daqPartition());
        Assert.assertEquals((long)imagehandlingconfig_daqThreads, (long)item_.getImagehandlingconfig_daqThreads());
        Assert.assertEquals((Object)imagehandlingconfig_locations, (Object)item_.getImagehandlingconfig_locations());
        Assert.assertEquals((Object)imagehandlingconfig_useStreaming, (Object)item_.isImagehandlingconfig_useStreaming());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_FitsHandlingConfigurationEvent() throws Exception {
        int priority = 626;
        String version = "w";
        boolean imagehandlingconfig_FITSAutoSave = false;
        String imagehandlingconfig_FITSDirectoryPattern = "";
        String imagehandlingconfig_FITSFilePattern = "";
        String imagehandlingconfig_FITSRootDirectory = "";
        String imagehandlingconfig_subsystemsToClearOnNewRun = "";
        String imagehandlingconfig_tempFileRelativeLocation = "n";
        boolean imagehandlingconfig_useTempFile = false;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_FitsHandlingConfigurationEvent(priority, version, imagehandlingconfig_FITSAutoSave, imagehandlingconfig_FITSDirectoryPattern, imagehandlingconfig_FITSFilePattern, imagehandlingconfig_FITSRootDirectory, imagehandlingconfig_subsystemsToClearOnNewRun, imagehandlingconfig_tempFileRelativeLocation, imagehandlingconfig_useTempFile));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_FitsHandlingConfigurationEvent));
        Image_handling_ImageHandler_FitsHandlingConfigurationEvent item_ = (Image_handling_ImageHandler_FitsHandlingConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)imagehandlingconfig_FITSAutoSave, (Object)item_.isImagehandlingconfig_FITSAutoSave());
        Assert.assertEquals((Object)imagehandlingconfig_FITSDirectoryPattern, (Object)item_.getImagehandlingconfig_FITSDirectoryPattern());
        Assert.assertEquals((Object)imagehandlingconfig_FITSFilePattern, (Object)item_.getImagehandlingconfig_FITSFilePattern());
        Assert.assertEquals((Object)imagehandlingconfig_FITSRootDirectory, (Object)item_.getImagehandlingconfig_FITSRootDirectory());
        Assert.assertEquals((Object)imagehandlingconfig_subsystemsToClearOnNewRun, (Object)item_.getImagehandlingconfig_subsystemsToClearOnNewRun());
        Assert.assertEquals((Object)imagehandlingconfig_tempFileRelativeLocation, (Object)item_.getImagehandlingconfig_tempFileRelativeLocation());
        Assert.assertEquals((Object)imagehandlingconfig_useTempFile, (Object)item_.isImagehandlingconfig_useTempFile());
    }

    @Test
    public void sendReceiveImage_handling_PeriodicTasksConfigurationEvent() throws Exception {
        int priority = 33;
        String version = "q";
        int schedulers_default_nTasks = 753;
        int schedulers_default_nThreads = 639;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_PeriodicTasksConfigurationEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads));
        Assert.assertTrue((boolean)(item instanceof Image_handling_PeriodicTasksConfigurationEvent));
        Image_handling_PeriodicTasksConfigurationEvent item_ = (Image_handling_PeriodicTasksConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
    }

    @Test
    public void sendReceiveImage_handling_PeriodicTasks_timersConfigurationEvent() throws Exception {
        int priority = 943;
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 446L;
        long heartbeat_taskPeriodMillis = 605L;
        long runtimeinfo_taskPeriodMillis = 83L;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_PeriodicTasks_timersConfigurationEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Image_handling_PeriodicTasks_timersConfigurationEvent));
        Image_handling_PeriodicTasks_timersConfigurationEvent item_ = (Image_handling_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveImage_handling_RebConfigurationEvent() throws Exception {
        int priority = 506;
        String version = "z";
        String fitsservice_headerFilesList = "";
        String location = "a";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_RebConfigurationEvent(priority, version, fitsservice_headerFilesList, location));
        Assert.assertTrue((boolean)(item instanceof Image_handling_RebConfigurationEvent));
        Image_handling_RebConfigurationEvent item_ = (Image_handling_RebConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)fitsservice_headerFilesList, (Object)item_.getFitsservice_headerFilesList());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveImage_handling_Reb_FitsHandlingConfigurationEvent() throws Exception {
        int priority = 387;
        String version = "z";
        boolean[] enabled = new boolean[]{true};
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_Reb_FitsHandlingConfigurationEvent(priority, version, enabled, location));
        Assert.assertTrue((boolean)(item instanceof Image_handling_Reb_FitsHandlingConfigurationEvent));
        Image_handling_Reb_FitsHandlingConfigurationEvent item_ = (Image_handling_Reb_FitsHandlingConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((boolean[])enabled, (boolean[])item_.getEnabled());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveShutterBladeMotionProfileEvent() throws Exception {
        int priority = 622;
        ShutterBladeMotionProfileEvent.Blade blade = ShutterBladeMotionProfileEvent.Blade.PLUS_X;
        ShutterBladeMotionProfileEvent.Direction direction = ShutterBladeMotionProfileEvent.Direction.CLOSE;
        double timestampStart = 0.452708f;
        double startPosition = 0.2126712203025818;
        double targetDuration = 0.9168487787246704;
        double targetPosition = 0.2955929f;
        double endPosition = 0.4381973147392273;
        double actualDuration = 0.7747090458869934;
        int hallSensorCount = 606;
        double[] timestampHallSensor = TestHelper.generateDoubleArray((int)240, (int)1273457989);
        int[] hallSensorID = TestHelper.generateIntArray((int)240, (int)1438210727);
        double[] hallSensorPosition = TestHelper.generateDoubleArray((int)240, (int)175641056);
        boolean[] hallSensorTransition = new boolean[]{true, false, true, true, false, true, true, true, false, true, false, true, false, true, true, true, false, false, false, true, true, true, true, false, true, true, false, true, true, false, true, false, true, false, false, false, false, true, false, false, true, false, false, true, false, true, false, true, false, false, false, false, false, false, false, true, true, false, true, false, true, false, false, true, true, true, true, false, true, true, true, false, true, false, true, true, true, true, false, false, true, false, false, true, false, true, false, false, true, true, true, false, false, false, true, false, true, true, true, true, false, false, true, true, false, true, false, false, true, false, true, false, false, true, true, true, true, true, true, true, true, true, false, false, false, true, false, true, true, true, true, false, false, false, true, true, false, false, false, true, false, true, false, false, true, false, false, true, true, true, true, true, true, true, true, false, true, true, true, true, true, false, false, false, false, true, false, true, true, true, false, false, true, false, false, true, false, true, true, true, false, true, false, false, false, false, false, false, true, true, false, false, false, false, false, true, false, true, true, false, true, true, true, true, false, true, false, true, true, false, true, true, false, true, true, false, false, false, false, true, false, false, true, false, false, true, true, true, false, false, true, true, false, false, true, true, true, true, true, true};
        int encoderCount = 822;
        double[] timestampEncoder = TestHelper.generateDoubleArray((int)240, (int)993051854);
        double[] encoderPosition = TestHelper.generateDoubleArray((int)240, (int)-1260624231);
        SALEvent item = this.testSendReceive((SALEvent)new ShutterBladeMotionProfileEvent(priority, blade, direction, timestampStart, startPosition, targetDuration, targetPosition, endPosition, actualDuration, hallSensorCount, timestampHallSensor, hallSensorID, hallSensorPosition, hallSensorTransition, encoderCount, timestampEncoder, encoderPosition));
        Assert.assertTrue((boolean)(item instanceof ShutterBladeMotionProfileEvent));
        ShutterBladeMotionProfileEvent item_ = (ShutterBladeMotionProfileEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)blade, (Object)item_.getBlade());
        Assert.assertEquals((Object)direction, (Object)item_.getDirection());
        Assert.assertEquals((double)timestampStart, (double)item_.getTimestampStart(), (double)1.0E-6f);
        Assert.assertEquals((double)startPosition, (double)item_.getStartPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)targetDuration, (double)item_.getTargetDuration(), (double)1.0E-6f);
        Assert.assertEquals((double)targetPosition, (double)item_.getTargetPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)endPosition, (double)item_.getEndPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)actualDuration, (double)item_.getActualDuration(), (double)1.0E-6f);
        Assert.assertEquals((long)hallSensorCount, (long)item_.getHallSensorCount());
        Assert.assertArrayEquals((double[])timestampHallSensor, (double[])item_.getTimestampHallSensor(), (double)1.0E-6f);
        Assert.assertArrayEquals((int[])hallSensorID, (int[])item_.getHallSensorID());
        Assert.assertArrayEquals((double[])hallSensorPosition, (double[])item_.getHallSensorPosition(), (double)1.0E-6f);
        Assert.assertArrayEquals((boolean[])hallSensorTransition, (boolean[])item_.getHallSensorTransition());
        Assert.assertEquals((long)encoderCount, (long)item_.getEncoderCount());
        Assert.assertArrayEquals((double[])timestampEncoder, (double[])item_.getTimestampEncoder(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])encoderPosition, (double[])item_.getEncoderPosition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageStoredEvent() throws Exception {
        int priority = 301;
        String imageName = "iudkkgalhgsvpsvezzh";
        double timestampImageStored = 0.4659762978553772;
        SALEvent item = this.testSendReceive((SALEvent)new ImageStoredEvent(priority, imageName, timestampImageStored));
        Assert.assertTrue((boolean)(item instanceof ImageStoredEvent));
        ImageStoredEvent item_ = (ImageStoredEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampImageStored, (double)item_.getTimestampImageStored(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFitsFilesWrittenEvent() throws Exception {
        int priority = 903;
        String imageName = "huwstkppshewoapenvg";
        double timestampFilesWritten = 0.9887987971305847;
        String rootFileName = "u";
        String relativeFileNames = "";
        String fileNode = "";
        SALEvent item = this.testSendReceive((SALEvent)new FitsFilesWrittenEvent(priority, imageName, timestampFilesWritten, rootFileName, relativeFileNames, fileNode));
        Assert.assertTrue((boolean)(item instanceof FitsFilesWrittenEvent));
        FitsFilesWrittenEvent item_ = (FitsFilesWrittenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampFilesWritten, (double)item_.getTimestampFilesWritten(), (double)1.0E-6f);
        Assert.assertEquals((Object)rootFileName, (Object)item_.getRootFileName());
        Assert.assertEquals((Object)relativeFileNames, (Object)item_.getRelativeFileNames());
        Assert.assertEquals((Object)fileNode, (Object)item_.getFileNode());
    }

    @Test
    public void sendReceiveFileCommandExecutionEvent() throws Exception {
        int priority = 30;
        String imageName = "uyapritluircfwgqcvl";
        double timestampCommandComplete = 0.8528434634208679;
        String command = "";
        int rc = 280;
        SALEvent item = this.testSendReceive((SALEvent)new FileCommandExecutionEvent(priority, imageName, timestampCommandComplete, command, rc));
        Assert.assertTrue((boolean)(item instanceof FileCommandExecutionEvent));
        FileCommandExecutionEvent item_ = (FileCommandExecutionEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampCommandComplete, (double)item_.getTimestampCommandComplete(), (double)1.0E-6f);
        Assert.assertEquals((Object)command, (Object)item_.getCommand());
        Assert.assertEquals((long)rc, (long)item_.getRc());
    }

    @Test
    public void sendReceiveImageVisualizationEvent() throws Exception {
        int priority = 736;
        String imageName = "cpmsylccjokqqhxm";
        double timestampVisualizationAvailable = 0.3508124351501465;
        String url = "e";
        String thumbnail = "";
        SALEvent item = this.testSendReceive((SALEvent)new ImageVisualizationEvent(priority, imageName, timestampVisualizationAvailable, url, thumbnail));
        Assert.assertTrue((boolean)(item instanceof ImageVisualizationEvent));
        ImageVisualizationEvent item_ = (ImageVisualizationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampVisualizationAvailable, (double)item_.getTimestampVisualizationAvailable(), (double)1.0E-6f);
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)thumbnail, (Object)item_.getThumbnail());
    }

    @Test
    public void sendReceiveConfigurationAppliedEvent() throws Exception {
        int priority = 875;
        String configurations = "h";
        String version = "";
        String url = "";
        String schemaVersion = "l";
        String otherInfo = "";
        SALEvent item = this.testSendReceive((SALEvent)new ConfigurationAppliedEvent(priority, configurations, version, url, schemaVersion, otherInfo));
        Assert.assertTrue((boolean)(item instanceof ConfigurationAppliedEvent));
        ConfigurationAppliedEvent item_ = (ConfigurationAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)configurations, (Object)item_.getConfigurations());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)schemaVersion, (Object)item_.getSchemaVersion());
        Assert.assertEquals((Object)otherInfo, (Object)item_.getOtherInfo());
    }

    @Test
    public void sendReceiveConfigurationsAvailableEvent() throws Exception {
        int priority = 144;
        String overrides = "";
        String version = "a";
        String url = "g";
        String schemaVersion = "";
        SALEvent item = this.testSendReceive((SALEvent)new ConfigurationsAvailableEvent(priority, overrides, version, url, schemaVersion));
        Assert.assertTrue((boolean)(item instanceof ConfigurationsAvailableEvent));
        ConfigurationsAvailableEvent item_ = (ConfigurationsAvailableEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)overrides, (Object)item_.getOverrides());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)schemaVersion, (Object)item_.getSchemaVersion());
    }

    @Test
    public void sendReceiveErrorCodeEvent() throws Exception {
        int priority = 501;
        int errorCode = 985;
        String errorReport = "";
        String traceback = "";
        SALEvent item = this.testSendReceive((SALEvent)new ErrorCodeEvent(priority, errorCode, errorReport, traceback));
        Assert.assertTrue((boolean)(item instanceof ErrorCodeEvent));
        ErrorCodeEvent item_ = (ErrorCodeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)errorCode, (long)item_.getErrorCode());
        Assert.assertEquals((Object)errorReport, (Object)item_.getErrorReport());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
    }

    @Test
    public void sendReceiveLogLevelEvent() throws Exception {
        int priority = 371;
        int level = 296;
        String subsystem = "";
        SALEvent item = this.testSendReceive((SALEvent)new LogLevelEvent(priority, level, subsystem));
        Assert.assertTrue((boolean)(item instanceof LogLevelEvent));
        LogLevelEvent item_ = (LogLevelEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)subsystem, (Object)item_.getSubsystem());
    }

    @Test
    public void sendReceiveLogMessageEvent() throws Exception {
        int priority = 37;
        String name = "";
        int level = 342;
        String message = "s";
        String traceback = "i";
        String filePath = "";
        String functionName = "g";
        int lineNumber = 559;
        int process = 605;
        double timestamp = 0.7525027394294739;
        SALEvent item = this.testSendReceive((SALEvent)new LogMessageEvent(priority, name, level, message, traceback, filePath, functionName, lineNumber, process, timestamp));
        Assert.assertTrue((boolean)(item instanceof LogMessageEvent));
        LogMessageEvent item_ = (LogMessageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)name, (Object)item_.getName());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)message, (Object)item_.getMessage());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
        Assert.assertEquals((Object)filePath, (Object)item_.getFilePath());
        Assert.assertEquals((Object)functionName, (Object)item_.getFunctionName());
        Assert.assertEquals((long)lineNumber, (long)item_.getLineNumber());
        Assert.assertEquals((long)process, (long)item_.getProcess());
        Assert.assertEquals((double)timestamp, (double)item_.getTimestamp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveSimulationModeEvent() throws Exception {
        int priority = 990;
        int mode = 551;
        SALEvent item = this.testSendReceive((SALEvent)new SimulationModeEvent(priority, mode));
        Assert.assertTrue((boolean)(item instanceof SimulationModeEvent));
        SimulationModeEvent item_ = (SimulationModeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)mode, (long)item_.getMode());
    }

    @Test
    public void sendReceiveSoftwareVersionsEvent() throws Exception {
        int priority = 274;
        String salVersion = "gqrbehdscepwhxmvkmfzxbywzkvvdwpdneimnnnsixrkvjbnlpnezxwubjqcttkadygrjzmarfgbbmfwpjagbpgydzuxqeadhsupppvdtuqnhujcmhhhsohdszawjbsjgdrjuebfzwbdmatcfqfcmcjgbxmyihihxpsmyievkzlpvwvjtqmxjfrdjghvq";
        String xmlVersion = "zdkbqolftkmqgbyctwbyltjtpojslrvqygvliyeusxsqvhxqmallgvbdariwdizmdsvaneypwtbyenawp";
        String openSpliceVersion = "tbxhivepqbdefckdrfcozgfanglnohyctjrzkxdjnzdsbmrjrckapmqzuhhkmmbxwypgnofrlqqqgquqmsygenfjxopcqrhqrccyewhzxmdehlhlmiwtdxkzrfomsurydqxqozczofzqdggsjnxv";
        String cscVersion = "szaitezrfzkvrdhfke";
        String subsystemVersions = "";
        SALEvent item = this.testSendReceive((SALEvent)new SoftwareVersionsEvent(priority, salVersion, xmlVersion, openSpliceVersion, cscVersion, subsystemVersions));
        Assert.assertTrue((boolean)(item instanceof SoftwareVersionsEvent));
        SoftwareVersionsEvent item_ = (SoftwareVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)salVersion, (Object)item_.getSalVersion());
        Assert.assertEquals((Object)xmlVersion, (Object)item_.getXmlVersion());
        Assert.assertEquals((Object)openSpliceVersion, (Object)item_.getOpenSpliceVersion());
        Assert.assertEquals((Object)cscVersion, (Object)item_.getCscVersion());
        Assert.assertEquals((Object)subsystemVersions, (Object)item_.getSubsystemVersions());
    }

    @Test
    public void sendReceiveHeartbeatEvent() throws Exception {
        int priority = 785;
        boolean heartbeat = false;
        SALEvent item = this.testSendReceive((SALEvent)new HeartbeatEvent(priority, heartbeat));
        Assert.assertTrue((boolean)(item instanceof HeartbeatEvent));
        HeartbeatEvent item_ = (HeartbeatEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
    }

    @Test
    public void sendReceiveAuthListEvent() throws Exception {
        int priority = 177;
        String authorizedUsers = "z";
        String nonAuthorizedCSCs = "i";
        SALEvent item = this.testSendReceive((SALEvent)new AuthListEvent(priority, authorizedUsers, nonAuthorizedCSCs));
        Assert.assertTrue((boolean)(item instanceof AuthListEvent));
        AuthListEvent item_ = (AuthListEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)authorizedUsers, (Object)item_.getAuthorizedUsers());
        Assert.assertEquals((Object)nonAuthorizedCSCs, (Object)item_.getNonAuthorizedCSCs());
    }

    @Test
    public void sendReceiveLargeFileObjectAvailableEvent() throws Exception {
        int priority = 724;
        String url = "pskmlwnjnoiawtuhibihxbvpovachsqojgomkvavxjzzgbttqkigmaslshbykwcsezaahoocmquqfwmvrdbfeynqgwjzutjtmiyxpissbjddrmakxmojjdtbbzotfrlryprfqrguaogxhsahtelupqwmsvgajfmwfnumigypsarrrkxbyzisqsbcumlkunzntlqkozzteykzmlxingxgntzwjdexucfshqoqmubaqjgvonhclnycssainytyqauu";
        String generator = "nsfckvdpshelccrmtoirzxqyoopzziiswvnrfolwdtagkeleuhhbztttdrsfjbgqdfsneofxskfdzvsqrtwmkxgioicdkgcpziuossdxmcxm";
        float version = 0.928351f;
        int byteSize = 700;
        String checkSum = "rosfkxcodszzakszruqckzqjtwiovgnykacsgwxhlgvhxrnqlwqlejqqincqyaheyukoixjxrficebtxgewpomwrufkjqfrgndwfaycrneiehwmdnkemwkgpehebirroscmsbtbwmgstsefxwruvrdbodloqasmdcokepctsdwlymchhttylhhxwrlwkcpyijysskjxrrbjnryaliwzsjmpudytfuylhcmrbjcningvartwwolaefsgtqejkkq";
        String mimeType = "iuxlogpawfuzgzhufvenutyztafirdzwezdwvbfwleprlnrkqddbwrhvcsgxkvgxpyxswzqpkaaqntloobhdkxrkxdoxagtoomlxvilfeafgnmwlmwphvexpbnsmshrgmbqpwemntzhumcznkheakygpmdfxqopslcwnprkthvghnlwdyztmjwojbermijzrsugxcznshxbbtujhdqwaesuwjzonoflujbkrmfaseypuateyavq";
        String id = "iwaeiyblxsffhsxbfemtixzzoinvduzyppwioookemrfdiqxrcngqmmgb";
        SALEvent item = this.testSendReceive((SALEvent)new LargeFileObjectAvailableEvent(priority, url, generator, version, byteSize, checkSum, mimeType, id));
        Assert.assertTrue((boolean)(item instanceof LargeFileObjectAvailableEvent));
        LargeFileObjectAvailableEvent item_ = (LargeFileObjectAvailableEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)generator, (Object)item_.getGenerator());
        Assert.assertEquals((float)version, (float)item_.getVersion(), (float)1.0E-6f);
        Assert.assertEquals((long)byteSize, (long)item_.getByteSize());
        Assert.assertEquals((Object)checkSum, (Object)item_.getCheckSum());
        Assert.assertEquals((Object)mimeType, (Object)item_.getMimeType());
        Assert.assertEquals((Object)id, (Object)item_.getId());
    }
}

