package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class Vacuum_TurboConfigurationEvent extends CameraEvent {
  private final String version;

  private final boolean activeStopMode;

  private final String devcId;

  private final boolean interlockType;

  private final boolean lowSpeedMode;

  private final boolean model304;

  private final boolean softStartMode;

  private final boolean ventValveByCmnd;

  private final boolean waterCooling;

  public Vacuum_TurboConfigurationEvent(int priority, String version, boolean activeStopMode,
      String devcId, boolean interlockType, boolean lowSpeedMode, boolean model304,
      boolean softStartMode, boolean ventValveByCmnd, boolean waterCooling) {
    super (priority);
    this.version = version;
    this.activeStopMode = activeStopMode;
    this.devcId = devcId;
    this.interlockType = interlockType;
    this.lowSpeedMode = lowSpeedMode;
    this.model304 = model304;
    this.softStartMode = softStartMode;
    this.ventValveByCmnd = ventValveByCmnd;
    this.waterCooling = waterCooling;
  }

  public String getVersion() {
    return version;
  }

  public boolean isActiveStopMode() {
    return activeStopMode;
  }

  public String getDevcId() {
    return devcId;
  }

  public boolean isInterlockType() {
    return interlockType;
  }

  public boolean isLowSpeedMode() {
    return lowSpeedMode;
  }

  public boolean isModel304() {
    return model304;
  }

  public boolean isSoftStartMode() {
    return softStartMode;
  }

  public boolean isVentValveByCmnd() {
    return ventValveByCmnd;
  }

  public boolean isWaterCooling() {
    return waterCooling;
  }

  @Override
  public String toString() {
    return "Vacuum_TurboConfigurationEvent{" + "version=" + version +
        ", activeStopMode=" + activeStopMode +", devcId=" + devcId +
        ", interlockType=" + interlockType +", lowSpeedMode=" + lowSpeedMode +
        ", model304=" + model304 +", softStartMode=" + softStartMode +
        ", ventValveByCmnd=" + ventValveByCmnd +", waterCooling=" + waterCooling +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private String version;

    private boolean activeStopMode;

    private String devcId;

    private boolean interlockType;

    private boolean lowSpeedMode;

    private boolean model304;

    private boolean softStartMode;

    private boolean ventValveByCmnd;

    private boolean waterCooling;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder activeStopMode(boolean activeStopMode) {
      this.activeStopMode = activeStopMode;
      return this;
    }

    public Builder devcId(String devcId) {
      this.devcId = devcId;
      return this;
    }

    public Builder interlockType(boolean interlockType) {
      this.interlockType = interlockType;
      return this;
    }

    public Builder lowSpeedMode(boolean lowSpeedMode) {
      this.lowSpeedMode = lowSpeedMode;
      return this;
    }

    public Builder model304(boolean model304) {
      this.model304 = model304;
      return this;
    }

    public Builder softStartMode(boolean softStartMode) {
      this.softStartMode = softStartMode;
      return this;
    }

    public Builder ventValveByCmnd(boolean ventValveByCmnd) {
      this.ventValveByCmnd = ventValveByCmnd;
      return this;
    }

    public Builder waterCooling(boolean waterCooling) {
      this.waterCooling = waterCooling;
      return this;
    }

    public Vacuum_TurboConfigurationEvent build() {
      return new Vacuum_TurboConfigurationEvent(priority, version, activeStopMode, devcId, interlockType, lowSpeedMode, model304, softStartMode, ventValveByCmnd, waterCooling);
    }
  }
}
