package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class Image_handling_ImageHandler_DAQConfigurationEvent extends CameraEvent {
  private final String version;

  private final String imagehandlingconfig_daqFolder;

  private final String imagehandlingconfig_daqPartition;

  private final int imagehandlingconfig_daqThreads;

  private final String imagehandlingconfig_locations;

  private final boolean imagehandlingconfig_useStreaming;

  public Image_handling_ImageHandler_DAQConfigurationEvent(int priority, String version,
      String imagehandlingconfig_daqFolder, String imagehandlingconfig_daqPartition,
      int imagehandlingconfig_daqThreads, String imagehandlingconfig_locations,
      boolean imagehandlingconfig_useStreaming) {
    super (priority);
    this.version = version;
    this.imagehandlingconfig_daqFolder = imagehandlingconfig_daqFolder;
    this.imagehandlingconfig_daqPartition = imagehandlingconfig_daqPartition;
    this.imagehandlingconfig_daqThreads = imagehandlingconfig_daqThreads;
    this.imagehandlingconfig_locations = imagehandlingconfig_locations;
    this.imagehandlingconfig_useStreaming = imagehandlingconfig_useStreaming;
  }

  public String getVersion() {
    return version;
  }

  public String getImagehandlingconfig_daqFolder() {
    return imagehandlingconfig_daqFolder;
  }

  public String getImagehandlingconfig_daqPartition() {
    return imagehandlingconfig_daqPartition;
  }

  public int getImagehandlingconfig_daqThreads() {
    return imagehandlingconfig_daqThreads;
  }

  public String getImagehandlingconfig_locations() {
    return imagehandlingconfig_locations;
  }

  public boolean isImagehandlingconfig_useStreaming() {
    return imagehandlingconfig_useStreaming;
  }

  @Override
  public String toString() {
    return "Image_handling_ImageHandler_DAQConfigurationEvent{" + "version=" + version +
        ", imagehandlingconfig_daqFolder=" + imagehandlingconfig_daqFolder +
        ", imagehandlingconfig_daqPartition=" + imagehandlingconfig_daqPartition +
        ", imagehandlingconfig_daqThreads=" + imagehandlingconfig_daqThreads +
        ", imagehandlingconfig_locations=" + imagehandlingconfig_locations +
        ", imagehandlingconfig_useStreaming=" + imagehandlingconfig_useStreaming +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private String version;

    private String imagehandlingconfig_daqFolder;

    private String imagehandlingconfig_daqPartition;

    private int imagehandlingconfig_daqThreads;

    private String imagehandlingconfig_locations;

    private boolean imagehandlingconfig_useStreaming;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder imagehandlingconfig_daqFolder(String imagehandlingconfig_daqFolder) {
      this.imagehandlingconfig_daqFolder = imagehandlingconfig_daqFolder;
      return this;
    }

    public Builder imagehandlingconfig_daqPartition(String imagehandlingconfig_daqPartition) {
      this.imagehandlingconfig_daqPartition = imagehandlingconfig_daqPartition;
      return this;
    }

    public Builder imagehandlingconfig_daqThreads(int imagehandlingconfig_daqThreads) {
      this.imagehandlingconfig_daqThreads = imagehandlingconfig_daqThreads;
      return this;
    }

    public Builder imagehandlingconfig_locations(String imagehandlingconfig_locations) {
      this.imagehandlingconfig_locations = imagehandlingconfig_locations;
      return this;
    }

    public Builder imagehandlingconfig_useStreaming(boolean imagehandlingconfig_useStreaming) {
      this.imagehandlingconfig_useStreaming = imagehandlingconfig_useStreaming;
      return this;
    }

    public Image_handling_ImageHandler_DAQConfigurationEvent build() {
      return new Image_handling_ImageHandler_DAQConfigurationEvent(priority, version, imagehandlingconfig_daqFolder, imagehandlingconfig_daqPartition, imagehandlingconfig_daqThreads, imagehandlingconfig_locations, imagehandlingconfig_useStreaming);
    }
  }
}
