package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class Focal_plane_SequencerConfig_DAQConfigurationEvent extends CameraEvent {
  private final String version;

  private final int badPixelAlarmLimit;

  private final String daqFolder;

  private final String daqPartition;

  private final boolean emulatedDAQ;

  public Focal_plane_SequencerConfig_DAQConfigurationEvent(int priority, String version,
      int badPixelAlarmLimit, String daqFolder, String daqPartition, boolean emulatedDAQ) {
    super (priority);
    this.version = version;
    this.badPixelAlarmLimit = badPixelAlarmLimit;
    this.daqFolder = daqFolder;
    this.daqPartition = daqPartition;
    this.emulatedDAQ = emulatedDAQ;
  }

  public String getVersion() {
    return version;
  }

  public int getBadPixelAlarmLimit() {
    return badPixelAlarmLimit;
  }

  public String getDaqFolder() {
    return daqFolder;
  }

  public String getDaqPartition() {
    return daqPartition;
  }

  public boolean isEmulatedDAQ() {
    return emulatedDAQ;
  }

  @Override
  public String toString() {
    return "Focal_plane_SequencerConfig_DAQConfigurationEvent{" + "version=" + version +
        ", badPixelAlarmLimit=" + badPixelAlarmLimit +", daqFolder=" + daqFolder +
        ", daqPartition=" + daqPartition +", emulatedDAQ=" + emulatedDAQ +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private String version;

    private int badPixelAlarmLimit;

    private String daqFolder;

    private String daqPartition;

    private boolean emulatedDAQ;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder badPixelAlarmLimit(int badPixelAlarmLimit) {
      this.badPixelAlarmLimit = badPixelAlarmLimit;
      return this;
    }

    public Builder daqFolder(String daqFolder) {
      this.daqFolder = daqFolder;
      return this;
    }

    public Builder daqPartition(String daqPartition) {
      this.daqPartition = daqPartition;
      return this;
    }

    public Builder emulatedDAQ(boolean emulatedDAQ) {
      this.emulatedDAQ = emulatedDAQ;
      return this;
    }

    public Focal_plane_SequencerConfig_DAQConfigurationEvent build() {
      return new Focal_plane_SequencerConfig_DAQConfigurationEvent(priority, version, badPixelAlarmLimit, daqFolder, daqPartition, emulatedDAQ);
    }
  }
}
