package org.lsst.sal.cccamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Quadbox_PDU_24VCTelemetry extends CameraTelemetry {
  private final double board_T;

  private final double body_Purge_I;

  private final double body_Purge_V;

  private final double bpu_Maq20_I;

  private final double bpu_Maq20_V;

  private final double fpga_T;

  private final double fes_Shu_HCU_I;

  private final double fes_Shu_HCU_V;

  private final double gauges_I;

  private final double gauges_V;

  private final double ion_Pumps_I;

  private final double ion_Pumps_V;

  private final double j10_I;

  private final double j10_V;

  private final double j11_I;

  private final double j11_V;

  private final double j12_I;

  private final double j12_V;

  private final double j6_I;

  private final double j6_V;

  private final double j7_I;

  private final double j7_V;

  private final double j9_I;

  private final double j9_V;

  private final double main_I;

  private final double main_T;

  private final double main_V;

  private final double pwr_Cry_HCU_I;

  private final double pwr_Cry_HCU_V;

  public Quadbox_PDU_24VCTelemetry(double board_T, double body_Purge_I, double body_Purge_V,
      double bpu_Maq20_I, double bpu_Maq20_V, double fpga_T, double fes_Shu_HCU_I,
      double fes_Shu_HCU_V, double gauges_I, double gauges_V, double ion_Pumps_I,
      double ion_Pumps_V, double j10_I, double j10_V, double j11_I, double j11_V, double j12_I,
      double j12_V, double j6_I, double j6_V, double j7_I, double j7_V, double j9_I, double j9_V,
      double main_I, double main_T, double main_V, double pwr_Cry_HCU_I, double pwr_Cry_HCU_V) {
    this.board_T = board_T;
    this.body_Purge_I = body_Purge_I;
    this.body_Purge_V = body_Purge_V;
    this.bpu_Maq20_I = bpu_Maq20_I;
    this.bpu_Maq20_V = bpu_Maq20_V;
    this.fpga_T = fpga_T;
    this.fes_Shu_HCU_I = fes_Shu_HCU_I;
    this.fes_Shu_HCU_V = fes_Shu_HCU_V;
    this.gauges_I = gauges_I;
    this.gauges_V = gauges_V;
    this.ion_Pumps_I = ion_Pumps_I;
    this.ion_Pumps_V = ion_Pumps_V;
    this.j10_I = j10_I;
    this.j10_V = j10_V;
    this.j11_I = j11_I;
    this.j11_V = j11_V;
    this.j12_I = j12_I;
    this.j12_V = j12_V;
    this.j6_I = j6_I;
    this.j6_V = j6_V;
    this.j7_I = j7_I;
    this.j7_V = j7_V;
    this.j9_I = j9_I;
    this.j9_V = j9_V;
    this.main_I = main_I;
    this.main_T = main_T;
    this.main_V = main_V;
    this.pwr_Cry_HCU_I = pwr_Cry_HCU_I;
    this.pwr_Cry_HCU_V = pwr_Cry_HCU_V;
  }

  public double getBoard_T() {
    return board_T;
  }

  public double getBody_Purge_I() {
    return body_Purge_I;
  }

  public double getBody_Purge_V() {
    return body_Purge_V;
  }

  public double getBpu_Maq20_I() {
    return bpu_Maq20_I;
  }

  public double getBpu_Maq20_V() {
    return bpu_Maq20_V;
  }

  public double getFpga_T() {
    return fpga_T;
  }

  public double getFes_Shu_HCU_I() {
    return fes_Shu_HCU_I;
  }

  public double getFes_Shu_HCU_V() {
    return fes_Shu_HCU_V;
  }

  public double getGauges_I() {
    return gauges_I;
  }

  public double getGauges_V() {
    return gauges_V;
  }

  public double getIon_Pumps_I() {
    return ion_Pumps_I;
  }

  public double getIon_Pumps_V() {
    return ion_Pumps_V;
  }

  public double getJ10_I() {
    return j10_I;
  }

  public double getJ10_V() {
    return j10_V;
  }

  public double getJ11_I() {
    return j11_I;
  }

  public double getJ11_V() {
    return j11_V;
  }

  public double getJ12_I() {
    return j12_I;
  }

  public double getJ12_V() {
    return j12_V;
  }

  public double getJ6_I() {
    return j6_I;
  }

  public double getJ6_V() {
    return j6_V;
  }

  public double getJ7_I() {
    return j7_I;
  }

  public double getJ7_V() {
    return j7_V;
  }

  public double getJ9_I() {
    return j9_I;
  }

  public double getJ9_V() {
    return j9_V;
  }

  public double getMain_I() {
    return main_I;
  }

  public double getMain_T() {
    return main_T;
  }

  public double getMain_V() {
    return main_V;
  }

  public double getPwr_Cry_HCU_I() {
    return pwr_Cry_HCU_I;
  }

  public double getPwr_Cry_HCU_V() {
    return pwr_Cry_HCU_V;
  }

  @Override
  public String toString() {
    return "Quadbox_PDU_24VCTelemetry{" + "board_T=" + board_T +", body_Purge_I=" + body_Purge_I +
        ", body_Purge_V=" + body_Purge_V +", bpu_Maq20_I=" + bpu_Maq20_I +
        ", bpu_Maq20_V=" + bpu_Maq20_V +", fpga_T=" + fpga_T +", fes_Shu_HCU_I=" + fes_Shu_HCU_I +
        ", fes_Shu_HCU_V=" + fes_Shu_HCU_V +", gauges_I=" + gauges_I +", gauges_V=" + gauges_V +
        ", ion_Pumps_I=" + ion_Pumps_I +", ion_Pumps_V=" + ion_Pumps_V +", j10_I=" + j10_I +
        ", j10_V=" + j10_V +", j11_I=" + j11_I +", j11_V=" + j11_V +", j12_I=" + j12_I +
        ", j12_V=" + j12_V +", j6_I=" + j6_I +", j6_V=" + j6_V +", j7_I=" + j7_I +", j7_V=" + j7_V +
        ", j9_I=" + j9_I +", j9_V=" + j9_V +", main_I=" + main_I +", main_T=" + main_T +
        ", main_V=" + main_V +", pwr_Cry_HCU_I=" + pwr_Cry_HCU_I +
        ", pwr_Cry_HCU_V=" + pwr_Cry_HCU_V +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double board_T;

    private double body_Purge_I;

    private double body_Purge_V;

    private double bpu_Maq20_I;

    private double bpu_Maq20_V;

    private double fpga_T;

    private double fes_Shu_HCU_I;

    private double fes_Shu_HCU_V;

    private double gauges_I;

    private double gauges_V;

    private double ion_Pumps_I;

    private double ion_Pumps_V;

    private double j10_I;

    private double j10_V;

    private double j11_I;

    private double j11_V;

    private double j12_I;

    private double j12_V;

    private double j6_I;

    private double j6_V;

    private double j7_I;

    private double j7_V;

    private double j9_I;

    private double j9_V;

    private double main_I;

    private double main_T;

    private double main_V;

    private double pwr_Cry_HCU_I;

    private double pwr_Cry_HCU_V;

    private Builder() {
    }

    public Builder board_T(double board_T) {
      this.board_T = board_T;
      return this;
    }

    public Builder body_Purge_I(double body_Purge_I) {
      this.body_Purge_I = body_Purge_I;
      return this;
    }

    public Builder body_Purge_V(double body_Purge_V) {
      this.body_Purge_V = body_Purge_V;
      return this;
    }

    public Builder bpu_Maq20_I(double bpu_Maq20_I) {
      this.bpu_Maq20_I = bpu_Maq20_I;
      return this;
    }

    public Builder bpu_Maq20_V(double bpu_Maq20_V) {
      this.bpu_Maq20_V = bpu_Maq20_V;
      return this;
    }

    public Builder fpga_T(double fpga_T) {
      this.fpga_T = fpga_T;
      return this;
    }

    public Builder fes_Shu_HCU_I(double fes_Shu_HCU_I) {
      this.fes_Shu_HCU_I = fes_Shu_HCU_I;
      return this;
    }

    public Builder fes_Shu_HCU_V(double fes_Shu_HCU_V) {
      this.fes_Shu_HCU_V = fes_Shu_HCU_V;
      return this;
    }

    public Builder gauges_I(double gauges_I) {
      this.gauges_I = gauges_I;
      return this;
    }

    public Builder gauges_V(double gauges_V) {
      this.gauges_V = gauges_V;
      return this;
    }

    public Builder ion_Pumps_I(double ion_Pumps_I) {
      this.ion_Pumps_I = ion_Pumps_I;
      return this;
    }

    public Builder ion_Pumps_V(double ion_Pumps_V) {
      this.ion_Pumps_V = ion_Pumps_V;
      return this;
    }

    public Builder j10_I(double j10_I) {
      this.j10_I = j10_I;
      return this;
    }

    public Builder j10_V(double j10_V) {
      this.j10_V = j10_V;
      return this;
    }

    public Builder j11_I(double j11_I) {
      this.j11_I = j11_I;
      return this;
    }

    public Builder j11_V(double j11_V) {
      this.j11_V = j11_V;
      return this;
    }

    public Builder j12_I(double j12_I) {
      this.j12_I = j12_I;
      return this;
    }

    public Builder j12_V(double j12_V) {
      this.j12_V = j12_V;
      return this;
    }

    public Builder j6_I(double j6_I) {
      this.j6_I = j6_I;
      return this;
    }

    public Builder j6_V(double j6_V) {
      this.j6_V = j6_V;
      return this;
    }

    public Builder j7_I(double j7_I) {
      this.j7_I = j7_I;
      return this;
    }

    public Builder j7_V(double j7_V) {
      this.j7_V = j7_V;
      return this;
    }

    public Builder j9_I(double j9_I) {
      this.j9_I = j9_I;
      return this;
    }

    public Builder j9_V(double j9_V) {
      this.j9_V = j9_V;
      return this;
    }

    public Builder main_I(double main_I) {
      this.main_I = main_I;
      return this;
    }

    public Builder main_T(double main_T) {
      this.main_T = main_T;
      return this;
    }

    public Builder main_V(double main_V) {
      this.main_V = main_V;
      return this;
    }

    public Builder pwr_Cry_HCU_I(double pwr_Cry_HCU_I) {
      this.pwr_Cry_HCU_I = pwr_Cry_HCU_I;
      return this;
    }

    public Builder pwr_Cry_HCU_V(double pwr_Cry_HCU_V) {
      this.pwr_Cry_HCU_V = pwr_Cry_HCU_V;
      return this;
    }

    public Quadbox_PDU_24VCTelemetry build() {
      return new Quadbox_PDU_24VCTelemetry(board_T, body_Purge_I, body_Purge_V, bpu_Maq20_I, bpu_Maq20_V, fpga_T, fes_Shu_HCU_I, fes_Shu_HCU_V, gauges_I, gauges_V, ion_Pumps_I, ion_Pumps_V, j10_I, j10_V, j11_I, j11_V, j12_I, j12_V, j6_I, j6_V, j7_I, j7_V, j9_I, j9_V, main_I, main_T, main_V, pwr_Cry_HCU_I, pwr_Cry_HCU_V);
    }
  }
}
