package org.lsst.sal.cccamera.event;

import java.util.Arrays;
import org.lsst.sal.camera.CameraEvent;

public class Rebpower_RebSettingsAppliedEvent extends CameraEvent {
  private final int version;

  private final int[] hvBias;

  private final String location;

  public Rebpower_RebSettingsAppliedEvent(int priority, int version, int[] hvBias,
      String location) {
    super (priority);
    this.version = version;
    this.hvBias = hvBias;
    this.location = location;
  }

  public int getVersion() {
    return version;
  }

  public int[] getHvBias() {
    return hvBias;
  }

  public String getLocation() {
    return location;
  }

  @Override
  public String toString() {
    return "Rebpower_RebSettingsAppliedEvent{" + "version=" + version +
        ", hvBias=" + Arrays.toString(hvBias) +", location=" + location +"}";
  }
}
