package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class Daq_monitor_StoreSettingsAppliedEvent extends CameraEvent {
  private final int version;

  private final int alarmPurgeFailures;

  private final String daqPartition;

  public Daq_monitor_StoreSettingsAppliedEvent(int priority, int version, int alarmPurgeFailures,
      String daqPartition) {
    super (priority);
    this.version = version;
    this.alarmPurgeFailures = alarmPurgeFailures;
    this.daqPartition = daqPartition;
  }

  public int getVersion() {
    return version;
  }

  public int getAlarmPurgeFailures() {
    return alarmPurgeFailures;
  }

  public String getDaqPartition() {
    return daqPartition;
  }

  @Override
  public String toString() {
    return "Daq_monitor_StoreSettingsAppliedEvent{" + "version=" + version +
        ", alarmPurgeFailures=" + alarmPurgeFailures +", daqPartition=" + daqPartition +"}";
  }
}
