package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class Bonn_shutter_GeneralSettingsAppliedEvent extends CameraEvent {
  private final int version;

  private final double maxExposureTime;

  private final double minExposureTime;

  private final int openCloseTimeMillis;

  public Bonn_shutter_GeneralSettingsAppliedEvent(int priority, int version, double maxExposureTime,
      double minExposureTime, int openCloseTimeMillis) {
    super (priority);
    this.version = version;
    this.maxExposureTime = maxExposureTime;
    this.minExposureTime = minExposureTime;
    this.openCloseTimeMillis = openCloseTimeMillis;
  }

  public int getVersion() {
    return version;
  }

  public double getMaxExposureTime() {
    return maxExposureTime;
  }

  public double getMinExposureTime() {
    return minExposureTime;
  }

  public int getOpenCloseTimeMillis() {
    return openCloseTimeMillis;
  }

  @Override
  public String toString() {
    return "Bonn_shutter_GeneralSettingsAppliedEvent{" + "version=" + version +
        ", maxExposureTime=" + maxExposureTime +", minExposureTime=" + minExposureTime +
        ", openCloseTimeMillis=" + openCloseTimeMillis +"}";
  }
}
