/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.cccamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AuthListEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.CCSConfiguredEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasksSettingsAppliedEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasks_timersSettingsAppliedEvent;
import org.lsst.sal.camera.event.Daq_monitor_Stats_StatisticsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Daq_monitor_Stats_buildSettingsAppliedEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_StoreSettingsAppliedEvent;
import org.lsst.sal.camera.event.EndInitializeGuiderEvent;
import org.lsst.sal.camera.event.EndInitializeImageEvent;
import org.lsst.sal.camera.event.EndLoadFilterEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndUnloadFilterEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.FocalPlaneSummaryInfoEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_RaftsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_ImageDatabaseServiceSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_ImageNameServiceSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_PeriodicTasksSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_RebTotalPower_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsLimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsPowerSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_Segment_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_SequencerSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.LargeFileObjectAvailableEvent;
import org.lsst.sal.camera.event.LogLevelEvent;
import org.lsst.sal.camera.event.LogMessageEvent;
import org.lsst.sal.camera.event.NotReadyToTakeImageEvent;
import org.lsst.sal.camera.event.PrepareToTakeImageEvent;
import org.lsst.sal.camera.event.Quadbox_BFR_QuadboxSettingsAppliedEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VC_QuadboxSettingsAppliedEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VD_QuadboxSettingsAppliedEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_48V_QuadboxSettingsAppliedEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_5V_QuadboxSettingsAppliedEvent;
import org.lsst.sal.camera.event.Quadbox_PeriodicTasksSettingsAppliedEvent;
import org.lsst.sal.camera.event.Quadbox_PeriodicTasks_timersSettingsAppliedEvent;
import org.lsst.sal.camera.event.Quadbox_REB_Bulk_PS_QuadboxSettingsAppliedEvent;
import org.lsst.sal.camera.event.ReadyToTakeImageEvent;
import org.lsst.sal.camera.event.RebpowerSettingsAppliedEvent;
import org.lsst.sal.camera.event.Rebpower_EmergencyResponseManagerSettingsAppliedEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartLoadFilterEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartRotateCarouselEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.event.StartUnloadFilterEvent;
import org.lsst.sal.cccamera.CCCamera;
import org.lsst.sal.cccamera.event.Bonn_shutter_Device_GeneralSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Bonn_shutter_Device_LimitsSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Bonn_shutter_GeneralSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Bonn_shutter_PeriodicTasksSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Bonn_shutter_PeriodicTasks_timersSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Daq_monitor_StoreSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.EndTakeImageEvent;
import org.lsst.sal.cccamera.event.FcsSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Fcs_LinearEncoderSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Fcs_LinearEncoder_LimitsSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Fcs_PeriodicTasksSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Fcs_PeriodicTasks_timersSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Fcs_StepperMotorSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Fcs_StepperMotor_LimitsSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Fcs_StepperMotor_MotorSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.FileCommandExecutionEvent;
import org.lsst.sal.cccamera.event.FitsFilesWrittenEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Ccd_HardwareIdSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Ccd_LimitsSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Focal_plane_PeriodicTasks_timersSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Raft_HardwareIdSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Raft_RaftTempControlSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Reb_HardwareIdSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Reb_LimitsSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Focal_plane_Reb_timersSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Focal_plane_SequencerConfig_DAQSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.ImageStoredEvent;
import org.lsst.sal.cccamera.event.ImageVisualizationEvent;
import org.lsst.sal.cccamera.event.Quadbox_BFR_LimitsSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Quadbox_PDU_24VC_LimitsSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Quadbox_PDU_24VD_LimitsSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Quadbox_PDU_48V_LimitsSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Quadbox_PDU_5V_LimitsSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Rebpower_PeriodicTasksSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Rebpower_PeriodicTasks_timersSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Rebpower_RebSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Rebpower_Reb_LimitsSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Rebpower_Rebps_PowerSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.ShutterBladeMotionProfileEvent;
import org.lsst.sal.cccamera.event.Vacuum_Cold1_CryoconSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Vacuum_Cold1_LimitsSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Vacuum_Cold2_CryoconSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Vacuum_Cold2_LimitsSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Vacuum_Cryo_CryoconSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Vacuum_Cryo_LimitsSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Vacuum_IonPumps_CryoSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Vacuum_IonPumps_LimitsSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Vacuum_PeriodicTasksSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Vacuum_PeriodicTasks_timersSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Vacuum_Rtds_DeviceSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Vacuum_Rtds_LimitsSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Vacuum_TurboSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Vacuum_Turbo_LimitsSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Vacuum_VQMonitor_CryoSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Vacuum_VQMonitor_LimitsSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Vacuum_VacPluto_DeviceSettingsAppliedEvent;

public class EventSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = CCCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALEvent testSendReceive(SALEvent item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALEvent> future = executor.submit(() -> sal.getNextEvent(Duration.ofSeconds(10L)));
        try {
            sal.logEvent(item);
            SALEvent sALEvent = future.get(10L, TimeUnit.SECONDS);
            return sALEvent;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws Exception {
        int priority = 494;
        String additionalKeys = "n";
        String additionalValues = "e";
        int imagesInSequence = 7;
        String imageName = "iyjgsyfqdeelosixirsmhnddyrhm";
        int imageIndex = 991;
        String imageSource = "l";
        String imageController = "";
        String imageDate = "tatg";
        int imageNumber = 404;
        double timestampAcquisitionStart = 0.726557195186615;
        double requestedExposureTime = 0.4349576234817505;
        double timestampEndOfReadout = 0.3086410164833069;
        SALEvent item = this.testSendReceive((SALEvent)new EndReadoutEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, requestedExposureTime, timestampEndOfReadout));
        Assert.assertTrue((boolean)(item instanceof EndReadoutEvent));
        EndReadoutEvent item_ = (EndReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)requestedExposureTime, (double)item_.getRequestedExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampEndOfReadout, (double)item_.getTimestampEndOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndTakeImageEvent() throws Exception {
        int priority = 172;
        SALEvent item = this.testSendReceive((SALEvent)new EndTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndTakeImageEvent));
        EndTakeImageEvent item_ = (EndTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartSetFilterEvent() throws Exception {
        int priority = 368;
        String filterName = "f";
        String filterType = "o";
        SALEvent item = this.testSendReceive((SALEvent)new StartSetFilterEvent(priority, filterName, filterType));
        Assert.assertTrue((boolean)(item instanceof StartSetFilterEvent));
        StartSetFilterEvent item_ = (StartSetFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
    }

    @Test
    public void sendReceiveStartUnloadFilterEvent() throws Exception {
        int priority = 796;
        double timestampTransition = 0.2500035762786865;
        SALEvent item = this.testSendReceive((SALEvent)new StartUnloadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartUnloadFilterEvent));
        StartUnloadFilterEvent item_ = (StartUnloadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveNotReadyToTakeImageEvent() throws Exception {
        int priority = 899;
        double timestampTransition = 0.4958488941192627;
        SALEvent item = this.testSendReceive((SALEvent)new NotReadyToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof NotReadyToTakeImageEvent));
        NotReadyToTakeImageEvent item_ = (NotReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws Exception {
        int priority = 588;
        double timestampTransition = 0.942844569683075;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterCloseEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterCloseEvent));
        StartShutterCloseEvent item_ = (StartShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeGuiderEvent() throws Exception {
        int priority = 783;
        double timestampTransition = 0.86098313331604;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeGuiderEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndInitializeGuiderEvent));
        EndInitializeGuiderEvent item_ = (EndInitializeGuiderEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws Exception {
        int priority = 27;
        double timestampTransition = 0.5015073418617249;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterCloseEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterCloseEvent));
        EndShutterCloseEvent item_ = (EndShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws Exception {
        int priority = 231;
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 902;
        String imageName = "stpmanw";
        int imageIndex = 564;
        String imageSource = "n";
        String imageController = "d";
        String imageDate = "sqfvxu";
        int imageNumber = 782;
        double timestampAcquisitionStart = 0.3559340238571167;
        double exposureTime = 0.24237751960754395;
        String imageTag = "siafomtyjrzxwfucnamoaezf";
        double timestampDateObs = 0.8620482683181763;
        double timestampDateEnd = 0.9991486668586731;
        double measuredShutterOpenTime = 0.31942546367645264;
        double darkTime = 0.7304308414459229;
        String emulatedImage = "";
        SALEvent item = this.testSendReceive((SALEvent)new EndOfImageTelemetryEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, measuredShutterOpenTime, darkTime, emulatedImage));
        Assert.assertTrue((boolean)(item instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent item_ = (EndOfImageTelemetryEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageTag, (Object)item_.getImageTag());
        Assert.assertEquals((double)timestampDateObs, (double)item_.getTimestampDateObs(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampDateEnd, (double)item_.getTimestampDateEnd(), (double)1.0E-6f);
        Assert.assertEquals((double)measuredShutterOpenTime, (double)item_.getMeasuredShutterOpenTime(), (double)1.0E-6f);
        Assert.assertEquals((double)darkTime, (double)item_.getDarkTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)emulatedImage, (Object)item_.getEmulatedImage());
    }

    @Test
    public void sendReceiveEndUnloadFilterEvent() throws Exception {
        int priority = 695;
        double timestampTransition = 0.8893335461616516;
        SALEvent item = this.testSendReceive((SALEvent)new EndUnloadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndUnloadFilterEvent));
        EndUnloadFilterEvent item_ = (EndUnloadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndRotateCarouselEvent() throws Exception {
        int priority = 802;
        double timestampTransition = 0.9800564646720886;
        SALEvent item = this.testSendReceive((SALEvent)new EndRotateCarouselEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndRotateCarouselEvent));
        EndRotateCarouselEvent item_ = (EndRotateCarouselEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartLoadFilterEvent() throws Exception {
        int priority = 943;
        double timestampTransition = 0.8460745811462402;
        SALEvent item = this.testSendReceive((SALEvent)new StartLoadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartLoadFilterEvent));
        StartLoadFilterEvent item_ = (StartLoadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveReadyToTakeImageEvent() throws Exception {
        int priority = 67;
        double timestampTransition = 0.17574453353881836;
        SALEvent item = this.testSendReceive((SALEvent)new ReadyToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof ReadyToTakeImageEvent));
        ReadyToTakeImageEvent item_ = (ReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePrepareToTakeImageEvent() throws Exception {
        int priority = 818;
        double timestampTransition = 0.31913596391677856;
        SALEvent item = this.testSendReceive((SALEvent)new PrepareToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof PrepareToTakeImageEvent));
        PrepareToTakeImageEvent item_ = (PrepareToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveCCSConfiguredEvent() throws Exception {
        int priority = 349;
        double timestampTransition = 0.8870211243629456;
        SALEvent item = this.testSendReceive((SALEvent)new CCSConfiguredEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof CCSConfiguredEvent));
        CCSConfiguredEvent item_ = (CCSConfiguredEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndLoadFilterEvent() throws Exception {
        int priority = 547;
        double timestampTransition = 0.4746529f;
        SALEvent item = this.testSendReceive((SALEvent)new EndLoadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndLoadFilterEvent));
        EndLoadFilterEvent item_ = (EndLoadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws Exception {
        int priority = 911;
        double timestampTransition = 0.39797717332839966;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterOpenEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterOpenEvent));
        EndShutterOpenEvent item_ = (EndShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartIntegrationEvent() throws Exception {
        int priority = 90;
        String additionalKeys = "t";
        String additionalValues = "";
        int imagesInSequence = 798;
        String imageName = "caageunvdyvuwxmpzbhnnlfao";
        int imageIndex = 23;
        String imageSource = "";
        String imageController = "a";
        String imageDate = "jfkyewrp";
        int imageNumber = 861;
        double timestampAcquisitionStart = 0.6435010433197021;
        double exposureTime = 0.5667428970336914;
        SALEvent item = this.testSendReceive((SALEvent)new StartIntegrationEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime));
        Assert.assertTrue((boolean)(item instanceof StartIntegrationEvent));
        StartIntegrationEvent item_ = (StartIntegrationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeImageEvent() throws Exception {
        int priority = 995;
        double timestampTransition = 0.8115205764770508;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndInitializeImageEvent));
        EndInitializeImageEvent item_ = (EndInitializeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndSetFilterEvent() throws Exception {
        int priority = 604;
        String filterName = "";
        String filterType = "";
        int filterSlot = 150;
        double filterPosition = 0.2524649500846863;
        SALEvent item = this.testSendReceive((SALEvent)new EndSetFilterEvent(priority, filterName, filterType, filterSlot, filterPosition));
        Assert.assertTrue((boolean)(item instanceof EndSetFilterEvent));
        EndSetFilterEvent item_ = (EndSetFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
        Assert.assertEquals((long)filterSlot, (long)item_.getFilterSlot());
        Assert.assertEquals((double)filterPosition, (double)item_.getFilterPosition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws Exception {
        int priority = 362;
        double timestampTransition = 0.6292307376861572;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterOpenEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterOpenEvent));
        StartShutterOpenEvent item_ = (StartShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAvailableFiltersEvent() throws Exception {
        int priority = 988;
        String filterNames = "zmyymnpodojhymuggilkxlhgpseuuibuyrlojdhzqoveaoljumwxnuioaorfjzvnqofqitxyuovvualrabkzcmdpadrmgbelsctwtzrcarsgmdvjvekeuiuydtesolnhtnyevpdyypbtxoocfivmsgrsfuvgtpclhgfkkmzaxdlilkirgkocdikkwpvrrtxwoodkupplkollcjrpomewlsbnekplueqilpcjekrkrzoxdddmstg";
        SALEvent item = this.testSendReceive((SALEvent)new AvailableFiltersEvent(priority, filterNames));
        Assert.assertTrue((boolean)(item instanceof AvailableFiltersEvent));
        AvailableFiltersEvent item_ = (AvailableFiltersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterNames, (Object)item_.getFilterNames());
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws Exception {
        int priority = 322;
        String additionalKeys = "v";
        String additionalValues = "";
        int imagesInSequence = 712;
        String imageName = "fhnbalwbbvpjj";
        int imageIndex = 137;
        String imageSource = "";
        String imageController = "";
        String imageDate = "jgeg";
        int imageNumber = 594;
        double timestampAcquisitionStart = 0.3791808f;
        double exposureTime = 0.8549120426177979;
        double timestampStartOfReadout = 0.041434288024902344;
        SALEvent item = this.testSendReceive((SALEvent)new StartReadoutEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, timestampStartOfReadout));
        Assert.assertTrue((boolean)(item instanceof StartReadoutEvent));
        StartReadoutEvent item_ = (StartReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampStartOfReadout, (double)item_.getTimestampStartOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartRotateCarouselEvent() throws Exception {
        int priority = 251;
        double timestampTransition = 0.8218094706535339;
        SALEvent item = this.testSendReceive((SALEvent)new StartRotateCarouselEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartRotateCarouselEvent));
        StartRotateCarouselEvent item_ = (StartRotateCarouselEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws Exception {
        int priority = 457;
        String imageName = "b";
        String ccdLocation = "i";
        String raftBay = "";
        String ccdSlot = "";
        Object[] ccdType = new ImageReadoutParametersEvent.CcdType[]{ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V};
        int[] overRows = TestHelper.generateIntArray((int)9, (int)-1754719726);
        int[] overCols = TestHelper.generateIntArray((int)9, (int)1223610368);
        int[] readRows = TestHelper.generateIntArray((int)9, (int)-1824186194);
        int[] readCols = TestHelper.generateIntArray((int)9, (int)1285800652);
        int[] readCols2 = TestHelper.generateIntArray((int)9, (int)-344217223);
        int[] preCols = TestHelper.generateIntArray((int)9, (int)-489878915);
        int[] preRows = TestHelper.generateIntArray((int)9, (int)1223133942);
        int[] postCols = TestHelper.generateIntArray((int)9, (int)1060260341);
        int[] underCols = TestHelper.generateIntArray((int)9, (int)-1288215810);
        String daqFolder = "";
        String daqAnnotation = "";
        SALEvent item = this.testSendReceive((SALEvent)new ImageReadoutParametersEvent(priority, imageName, ccdLocation, raftBay, ccdSlot, (ImageReadoutParametersEvent.CcdType[])ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols, underCols, daqFolder, daqAnnotation));
        Assert.assertTrue((boolean)(item instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent item_ = (ImageReadoutParametersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((int[])overRows, (int[])item_.getOverRows());
        Assert.assertArrayEquals((int[])overCols, (int[])item_.getOverCols());
        Assert.assertArrayEquals((int[])readRows, (int[])item_.getReadRows());
        Assert.assertArrayEquals((int[])readCols, (int[])item_.getReadCols());
        Assert.assertArrayEquals((int[])readCols2, (int[])item_.getReadCols2());
        Assert.assertArrayEquals((int[])preCols, (int[])item_.getPreCols());
        Assert.assertArrayEquals((int[])preRows, (int[])item_.getPreRows());
        Assert.assertArrayEquals((int[])postCols, (int[])item_.getPostCols());
        Assert.assertArrayEquals((int[])underCols, (int[])item_.getUnderCols());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqAnnotation, (Object)item_.getDaqAnnotation());
    }

    @Test
    public void sendReceiveFocalPlaneSummaryInfoEvent() throws Exception {
        int priority = 291;
        String ccdLocation = "";
        String raftBay = "m";
        String ccdSlot = "";
        String rebSerialNumber = "";
        String rebLSSTName = "";
        String ccdLSSTName = "";
        String raftLSSTName = "";
        String ccdManSerNum = "a";
        String ccdManufacturer = "b";
        Object[] ccdType = new FocalPlaneSummaryInfoEvent.CcdType[]{FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V};
        double[] ccdTempSetPoint = TestHelper.generateDoubleArray((int)9, (int)-1947213365);
        String sequencerKey = "";
        String sequencerChecksum = "w";
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneSummaryInfoEvent(priority, ccdLocation, raftBay, ccdSlot, rebSerialNumber, rebLSSTName, ccdLSSTName, raftLSSTName, ccdManSerNum, ccdManufacturer, (FocalPlaneSummaryInfoEvent.CcdType[])ccdType, ccdTempSetPoint, sequencerKey, sequencerChecksum));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneSummaryInfoEvent));
        FocalPlaneSummaryInfoEvent item_ = (FocalPlaneSummaryInfoEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)rebSerialNumber, (Object)item_.getRebSerialNumber());
        Assert.assertEquals((Object)rebLSSTName, (Object)item_.getRebLSSTName());
        Assert.assertEquals((Object)ccdLSSTName, (Object)item_.getCcdLSSTName());
        Assert.assertEquals((Object)raftLSSTName, (Object)item_.getRaftLSSTName());
        Assert.assertEquals((Object)ccdManSerNum, (Object)item_.getCcdManSerNum());
        Assert.assertEquals((Object)ccdManufacturer, (Object)item_.getCcdManufacturer());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((double[])ccdTempSetPoint, (double[])item_.getCcdTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((Object)sequencerKey, (Object)item_.getSequencerKey());
        Assert.assertEquals((Object)sequencerChecksum, (Object)item_.getSequencerChecksum());
    }

    @Test
    public void sendReceiveFcsSettingsAppliedEvent() throws Exception {
        int priority = 72;
        int version = 943;
        String filterNames = "e";
        String filterTypes = "";
        String nameFilter1 = "z";
        String nameFilter2 = "b";
        String nameFilter3 = "";
        int positionFilter1 = 58;
        int positionFilter2 = 201;
        int positionFilter3 = 271;
        int positionLoad1 = 604;
        int positionLoad3 = 759;
        double tolerance = 0.9245601296424866;
        SALEvent item = this.testSendReceive((SALEvent)new FcsSettingsAppliedEvent(priority, version, filterNames, filterTypes, nameFilter1, nameFilter2, nameFilter3, positionFilter1, positionFilter2, positionFilter3, positionLoad1, positionLoad3, tolerance));
        Assert.assertTrue((boolean)(item instanceof FcsSettingsAppliedEvent));
        FcsSettingsAppliedEvent item_ = (FcsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)filterNames, (Object)item_.getFilterNames());
        Assert.assertEquals((Object)filterTypes, (Object)item_.getFilterTypes());
        Assert.assertEquals((Object)nameFilter1, (Object)item_.getNameFilter1());
        Assert.assertEquals((Object)nameFilter2, (Object)item_.getNameFilter2());
        Assert.assertEquals((Object)nameFilter3, (Object)item_.getNameFilter3());
        Assert.assertEquals((long)positionFilter1, (long)item_.getPositionFilter1());
        Assert.assertEquals((long)positionFilter2, (long)item_.getPositionFilter2());
        Assert.assertEquals((long)positionFilter3, (long)item_.getPositionFilter3());
        Assert.assertEquals((long)positionLoad1, (long)item_.getPositionLoad1());
        Assert.assertEquals((long)positionLoad3, (long)item_.getPositionLoad3());
        Assert.assertEquals((double)tolerance, (double)item_.getTolerance(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_LinearEncoderSettingsAppliedEvent() throws Exception {
        int priority = 498;
        int version = 398;
        String devcId = "";
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_LinearEncoderSettingsAppliedEvent(priority, version, devcId));
        Assert.assertTrue((boolean)(item instanceof Fcs_LinearEncoderSettingsAppliedEvent));
        Fcs_LinearEncoderSettingsAppliedEvent item_ = (Fcs_LinearEncoderSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveFcs_LinearEncoder_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 584;
        int version = 756;
        double linearposition_warnHi = 0.2438182234764099;
        double linearposition_warnLo = 0.0923229455947876;
        double linearposition_limitHi = 0.8818138241767883;
        double linearposition_limitLo = 0.5860308408737183;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_LinearEncoder_LimitsSettingsAppliedEvent(priority, version, linearposition_warnHi, linearposition_warnLo, linearposition_limitHi, linearposition_limitLo));
        Assert.assertTrue((boolean)(item instanceof Fcs_LinearEncoder_LimitsSettingsAppliedEvent));
        Fcs_LinearEncoder_LimitsSettingsAppliedEvent item_ = (Fcs_LinearEncoder_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)linearposition_warnHi, (double)item_.getLinearposition_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)linearposition_warnLo, (double)item_.getLinearposition_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)linearposition_limitHi, (double)item_.getLinearposition_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)linearposition_limitLo, (double)item_.getLinearposition_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_PeriodicTasksSettingsAppliedEvent() throws Exception {
        int priority = 215;
        int version = 255;
        int schedulers_default_nTasks = 979;
        int schedulers_default_nThreads = 711;
        int schedulers_monitor_update_publish_scheduler_nTasks = 529;
        int schedulers_monitor_update_publish_scheduler_nThreads = 351;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_PeriodicTasksSettingsAppliedEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Fcs_PeriodicTasksSettingsAppliedEvent));
        Fcs_PeriodicTasksSettingsAppliedEvent item_ = (Fcs_PeriodicTasksSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveFcs_PeriodicTasks_timersSettingsAppliedEvent() throws Exception {
        int priority = 900;
        int version = 496;
        long agentmonitorservice_taskPeriodMillis = 0L;
        long heartbeat_taskPeriodMillis = 619L;
        long monitor_check_taskPeriodMillis = 931L;
        long monitor_publish_taskPeriodMillis = 700L;
        long monitor_update_taskPeriodMillis = 301L;
        long runtimeinfo_taskPeriodMillis = 216L;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_PeriodicTasks_timersSettingsAppliedEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Fcs_PeriodicTasks_timersSettingsAppliedEvent));
        Fcs_PeriodicTasks_timersSettingsAppliedEvent item_ = (Fcs_PeriodicTasks_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFcs_StepperMotorSettingsAppliedEvent() throws Exception {
        int priority = 566;
        int version = 611;
        String devcId = "s";
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_StepperMotorSettingsAppliedEvent(priority, version, devcId));
        Assert.assertTrue((boolean)(item instanceof Fcs_StepperMotorSettingsAppliedEvent));
        Fcs_StepperMotorSettingsAppliedEvent item_ = (Fcs_StepperMotorSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveFcs_StepperMotor_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 419;
        int version = 330;
        double motorencoder_warnHi = 0.5543696880340576;
        double motorencoder_warnLo = 0.7836690545082092;
        double motorencoder_limitHi = 0.40061742067337036;
        double motorencoder_limitLo = 0.4515455961227417;
        double motortemperature_warnHi = 0.786760687828064;
        double motortemperature_warnLo = 0.11390924453735352;
        double motortemperature_limitHi = 0.27820414304733276;
        double motortemperature_limitLo = 0.8154560327529907;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_StepperMotor_LimitsSettingsAppliedEvent(priority, version, motorencoder_warnHi, motorencoder_warnLo, motorencoder_limitHi, motorencoder_limitLo, motortemperature_warnHi, motortemperature_warnLo, motortemperature_limitHi, motortemperature_limitLo));
        Assert.assertTrue((boolean)(item instanceof Fcs_StepperMotor_LimitsSettingsAppliedEvent));
        Fcs_StepperMotor_LimitsSettingsAppliedEvent item_ = (Fcs_StepperMotor_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)motorencoder_warnHi, (double)item_.getMotorencoder_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)motorencoder_warnLo, (double)item_.getMotorencoder_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)motorencoder_limitHi, (double)item_.getMotorencoder_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)motorencoder_limitLo, (double)item_.getMotorencoder_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)motortemperature_warnHi, (double)item_.getMotortemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)motortemperature_warnLo, (double)item_.getMotortemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)motortemperature_limitHi, (double)item_.getMotortemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)motortemperature_limitLo, (double)item_.getMotortemperature_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFcs_StepperMotor_MotorSettingsAppliedEvent() throws Exception {
        int priority = 71;
        int version = 358;
        int accelRamp = 526;
        boolean backOff = true;
        int brakeRamp = 94;
        int iPhase = 934;
        int iPhaseStill = 434;
        int maxJerkAccel = 617;
        int maxJerkBrake = 630;
        double maxRampTime = 0.18111753463745117;
        int minStepFreq = 449;
        int quickRamp = 971;
        int rampType = 43;
        int reverseClearance = 968;
        int stepFreq = 480;
        int stepMode = 678;
        SALEvent item = this.testSendReceive((SALEvent)new Fcs_StepperMotor_MotorSettingsAppliedEvent(priority, version, accelRamp, backOff, brakeRamp, iPhase, iPhaseStill, maxJerkAccel, maxJerkBrake, maxRampTime, minStepFreq, quickRamp, rampType, reverseClearance, stepFreq, stepMode));
        Assert.assertTrue((boolean)(item instanceof Fcs_StepperMotor_MotorSettingsAppliedEvent));
        Fcs_StepperMotor_MotorSettingsAppliedEvent item_ = (Fcs_StepperMotor_MotorSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)accelRamp, (long)item_.getAccelRamp());
        Assert.assertEquals((Object)backOff, (Object)item_.isBackOff());
        Assert.assertEquals((long)brakeRamp, (long)item_.getBrakeRamp());
        Assert.assertEquals((long)iPhase, (long)item_.getIPhase());
        Assert.assertEquals((long)iPhaseStill, (long)item_.getIPhaseStill());
        Assert.assertEquals((long)maxJerkAccel, (long)item_.getMaxJerkAccel());
        Assert.assertEquals((long)maxJerkBrake, (long)item_.getMaxJerkBrake());
        Assert.assertEquals((double)maxRampTime, (double)item_.getMaxRampTime(), (double)1.0E-6f);
        Assert.assertEquals((long)minStepFreq, (long)item_.getMinStepFreq());
        Assert.assertEquals((long)quickRamp, (long)item_.getQuickRamp());
        Assert.assertEquals((long)rampType, (long)item_.getRampType());
        Assert.assertEquals((long)reverseClearance, (long)item_.getReverseClearance());
        Assert.assertEquals((long)stepFreq, (long)item_.getStepFreq());
        Assert.assertEquals((long)stepMode, (long)item_.getStepMode());
    }

    @Test
    public void sendReceiveBonn_shutter_Device_GeneralSettingsAppliedEvent() throws Exception {
        int priority = 128;
        int version = 596;
        String devcId = "z";
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_Device_GeneralSettingsAppliedEvent(priority, version, devcId));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_Device_GeneralSettingsAppliedEvent));
        Bonn_shutter_Device_GeneralSettingsAppliedEvent item_ = (Bonn_shutter_Device_GeneralSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveBonn_shutter_Device_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 591;
        int version = 309;
        double bonn_V36_warnHi = 0.9310056567192078;
        double bonn_V36_warnLo = 0.6005901098251343;
        double bonn_V36_limitHi = 0.20480185747146606;
        double bonn_V36_limitLo = 0.674481213092804;
        double bonn_V5_warnHi = 0.40960294008255005;
        double bonn_V5_warnLo = 0.7907758355140686;
        double bonn_V5_limitHi = 0.450225293636322;
        double bonn_V5_limitLo = 0.19921225309371948;
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_Device_LimitsSettingsAppliedEvent(priority, version, bonn_V36_warnHi, bonn_V36_warnLo, bonn_V36_limitHi, bonn_V36_limitLo, bonn_V5_warnHi, bonn_V5_warnLo, bonn_V5_limitHi, bonn_V5_limitLo));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_Device_LimitsSettingsAppliedEvent));
        Bonn_shutter_Device_LimitsSettingsAppliedEvent item_ = (Bonn_shutter_Device_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)bonn_V36_warnHi, (double)item_.getBonn_V36_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V36_warnLo, (double)item_.getBonn_V36_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V36_limitHi, (double)item_.getBonn_V36_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V36_limitLo, (double)item_.getBonn_V36_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5_warnHi, (double)item_.getBonn_V5_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5_warnLo, (double)item_.getBonn_V5_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5_limitHi, (double)item_.getBonn_V5_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bonn_V5_limitLo, (double)item_.getBonn_V5_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveBonn_shutter_GeneralSettingsAppliedEvent() throws Exception {
        int priority = 300;
        int version = 316;
        double maxExposureTime = 0.784142255783081;
        double minExposureTime = 0.5766582489013672;
        int openCloseTimeMillis = 760;
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_GeneralSettingsAppliedEvent(priority, version, maxExposureTime, minExposureTime, openCloseTimeMillis));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_GeneralSettingsAppliedEvent));
        Bonn_shutter_GeneralSettingsAppliedEvent item_ = (Bonn_shutter_GeneralSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)maxExposureTime, (double)item_.getMaxExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)minExposureTime, (double)item_.getMinExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((long)openCloseTimeMillis, (long)item_.getOpenCloseTimeMillis());
    }

    @Test
    public void sendReceiveBonn_shutter_PeriodicTasksSettingsAppliedEvent() throws Exception {
        int priority = 986;
        int version = 106;
        int schedulers_default_nTasks = 435;
        int schedulers_default_nThreads = 996;
        int schedulers_monitor_update_publish_scheduler_nTasks = 254;
        int schedulers_monitor_update_publish_scheduler_nThreads = 336;
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_PeriodicTasksSettingsAppliedEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_PeriodicTasksSettingsAppliedEvent));
        Bonn_shutter_PeriodicTasksSettingsAppliedEvent item_ = (Bonn_shutter_PeriodicTasksSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveBonn_shutter_PeriodicTasks_timersSettingsAppliedEvent() throws Exception {
        int priority = 114;
        int version = 390;
        long agentmonitorservice_taskPeriodMillis = 421L;
        long heartbeat_taskPeriodMillis = 563L;
        long monitor_check_taskPeriodMillis = 463L;
        long monitor_publish_taskPeriodMillis = 219L;
        long monitor_update_taskPeriodMillis = 25L;
        long runtimeinfo_taskPeriodMillis = 248L;
        SALEvent item = this.testSendReceive((SALEvent)new Bonn_shutter_PeriodicTasks_timersSettingsAppliedEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Bonn_shutter_PeriodicTasks_timersSettingsAppliedEvent));
        Bonn_shutter_PeriodicTasks_timersSettingsAppliedEvent item_ = (Bonn_shutter_PeriodicTasks_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasksSettingsAppliedEvent() throws Exception {
        int priority = 786;
        int version = 492;
        int schedulers_default_nTasks = 926;
        int schedulers_default_nThreads = 899;
        int schedulers_monitor_update_publish_scheduler_nTasks = 529;
        int schedulers_monitor_update_publish_scheduler_nThreads = 977;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasksSettingsAppliedEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasksSettingsAppliedEvent));
        Daq_monitor_PeriodicTasksSettingsAppliedEvent item_ = (Daq_monitor_PeriodicTasksSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasks_timersSettingsAppliedEvent() throws Exception {
        int priority = 371;
        int version = 824;
        long agentmonitorservice_taskPeriodMillis = 912L;
        long heartbeat_taskPeriodMillis = 184L;
        long monitor_check_taskPeriodMillis = 561L;
        long monitor_publish_taskPeriodMillis = 178L;
        long monitor_update_taskPeriodMillis = 630L;
        long publishstats_taskPeriodMillis = 614L;
        long purgedaq_taskPeriodMillis = 324L;
        long runtimeinfo_taskPeriodMillis = 185L;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasks_timersSettingsAppliedEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, publishstats_taskPeriodMillis, purgedaq_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasks_timersSettingsAppliedEvent));
        Daq_monitor_PeriodicTasks_timersSettingsAppliedEvent item_ = (Daq_monitor_PeriodicTasks_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)publishstats_taskPeriodMillis, (long)item_.getPublishstats_taskPeriodMillis());
        Assert.assertEquals((long)purgedaq_taskPeriodMillis, (long)item_.getPurgedaq_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveDaq_monitor_Stats_StatisticsSettingsAppliedEvent() throws Exception {
        int priority = 367;
        int version = 262;
        int minDiffAlertWarning = 138;
        int minDiffLogWarning = 166;
        String sumDriverChecks = "h";
        String sumDriverStats = "x";
        String sumFirmwareChecks = "";
        String sumFirmwareStats = "";
        String sumRdsChecks = "";
        String sumRdsStats = "";
        String sumRmsChecks = "";
        String sumRmsStats = "";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Stats_StatisticsSettingsAppliedEvent(priority, version, minDiffAlertWarning, minDiffLogWarning, sumDriverChecks, sumDriverStats, sumFirmwareChecks, sumFirmwareStats, sumRdsChecks, sumRdsStats, sumRmsChecks, sumRmsStats));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Stats_StatisticsSettingsAppliedEvent));
        Daq_monitor_Stats_StatisticsSettingsAppliedEvent item_ = (Daq_monitor_Stats_StatisticsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)minDiffAlertWarning, (long)item_.getMinDiffAlertWarning());
        Assert.assertEquals((long)minDiffLogWarning, (long)item_.getMinDiffLogWarning());
        Assert.assertEquals((Object)sumDriverChecks, (Object)item_.getSumDriverChecks());
        Assert.assertEquals((Object)sumDriverStats, (Object)item_.getSumDriverStats());
        Assert.assertEquals((Object)sumFirmwareChecks, (Object)item_.getSumFirmwareChecks());
        Assert.assertEquals((Object)sumFirmwareStats, (Object)item_.getSumFirmwareStats());
        Assert.assertEquals((Object)sumRdsChecks, (Object)item_.getSumRdsChecks());
        Assert.assertEquals((Object)sumRdsStats, (Object)item_.getSumRdsStats());
        Assert.assertEquals((Object)sumRmsChecks, (Object)item_.getSumRmsChecks());
        Assert.assertEquals((Object)sumRmsStats, (Object)item_.getSumRmsStats());
    }

    @Test
    public void sendReceiveDaq_monitor_Stats_buildSettingsAppliedEvent() throws Exception {
        int priority = 801;
        int version = 795;
        boolean enablePeriodicPublication = true;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Stats_buildSettingsAppliedEvent(priority, version, enablePeriodicPublication));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Stats_buildSettingsAppliedEvent));
        Daq_monitor_Stats_buildSettingsAppliedEvent item_ = (Daq_monitor_Stats_buildSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)enablePeriodicPublication, (Object)item_.isEnablePeriodicPublication());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreSettingsAppliedEvent() throws Exception {
        int priority = 149;
        int version = 989;
        int alarmPurgeFailures = 81;
        String daqPartition = "";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_StoreSettingsAppliedEvent(priority, version, alarmPurgeFailures, daqPartition));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreSettingsAppliedEvent));
        Daq_monitor_StoreSettingsAppliedEvent item_ = (Daq_monitor_StoreSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)alarmPurgeFailures, (long)item_.getAlarmPurgeFailures());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
    }

    @Test
    public void sendReceiveDaq_monitor_Store_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 637;
        int version = 713;
        double capacity_warnHi = 0.688093900680542;
        double capacity_warnLo = 0.7588313817977905;
        double capacity_limitHi = 0.4588811993598938;
        double capacity_limitLo = 0.3201286196708679;
        double freefraction_warnHi = 0.3820696473121643;
        double freefraction_warnLo = 0.7292030453681946;
        double freefraction_limitHi = 0.36418086290359497;
        double freefraction_limitLo = 0.02814584970474243;
        double freespace_warnHi = 0.382207453250885;
        double freespace_warnLo = 0.12228578329086304;
        double freespace_limitHi = 0.973324716091156;
        double freespace_limitLo = 0.38076627254486084;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_LimitsSettingsAppliedEvent(priority, version, capacity_warnHi, capacity_warnLo, capacity_limitHi, capacity_limitLo, freefraction_warnHi, freefraction_warnLo, freefraction_limitHi, freefraction_limitLo, freespace_warnHi, freespace_warnLo, freespace_limitHi, freespace_limitLo));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_LimitsSettingsAppliedEvent));
        Daq_monitor_Store_LimitsSettingsAppliedEvent item_ = (Daq_monitor_Store_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)capacity_warnHi, (double)item_.getCapacity_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_warnLo, (double)item_.getCapacity_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_limitHi, (double)item_.getCapacity_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_limitLo, (double)item_.getCapacity_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_warnHi, (double)item_.getFreefraction_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_warnLo, (double)item_.getFreefraction_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_limitHi, (double)item_.getFreefraction_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_limitLo, (double)item_.getFreefraction_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_warnHi, (double)item_.getFreespace_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_warnLo, (double)item_.getFreespace_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_limitHi, (double)item_.getFreespace_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_limitLo, (double)item_.getFreespace_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Store_StoreSettingsAppliedEvent() throws Exception {
        int priority = 143;
        int version = 22;
        String daqFolder = "d";
        boolean enableAutoPurge = false;
        double purgeTarget = 0.6217074990272522;
        double purgeThreshold = 0.1260806918144226;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_StoreSettingsAppliedEvent(priority, version, daqFolder, enableAutoPurge, purgeTarget, purgeThreshold));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_StoreSettingsAppliedEvent));
        Daq_monitor_Store_StoreSettingsAppliedEvent item_ = (Daq_monitor_Store_StoreSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)enableAutoPurge, (Object)item_.isEnableAutoPurge());
        Assert.assertEquals((double)purgeTarget, (double)item_.getPurgeTarget(), (double)1.0E-6f);
        Assert.assertEquals((double)purgeThreshold, (double)item_.getPurgeThreshold(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpowerSettingsAppliedEvent() throws Exception {
        int priority = 332;
        int version = 581;
        long powerOffSleepMillis = 351L;
        SALEvent item = this.testSendReceive((SALEvent)new RebpowerSettingsAppliedEvent(priority, version, powerOffSleepMillis));
        Assert.assertTrue((boolean)(item instanceof RebpowerSettingsAppliedEvent));
        RebpowerSettingsAppliedEvent item_ = (RebpowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)powerOffSleepMillis, (long)item_.getPowerOffSleepMillis());
    }

    @Test
    public void sendReceiveRebpower_EmergencyResponseManagerSettingsAppliedEvent() throws Exception {
        int priority = 821;
        int version = 59;
        boolean processOnlyClearedAlerts = true;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_EmergencyResponseManagerSettingsAppliedEvent(priority, version, processOnlyClearedAlerts));
        Assert.assertTrue((boolean)(item instanceof Rebpower_EmergencyResponseManagerSettingsAppliedEvent));
        Rebpower_EmergencyResponseManagerSettingsAppliedEvent item_ = (Rebpower_EmergencyResponseManagerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)processOnlyClearedAlerts, (Object)item_.isProcessOnlyClearedAlerts());
    }

    @Test
    public void sendReceiveRebpower_PeriodicTasksSettingsAppliedEvent() throws Exception {
        int priority = 954;
        int version = 799;
        int schedulers_default_nTasks = 664;
        int schedulers_default_nThreads = 533;
        int schedulers_monitor_update_publish_scheduler_nTasks = 391;
        int schedulers_monitor_update_publish_scheduler_nThreads = 671;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_PeriodicTasksSettingsAppliedEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Rebpower_PeriodicTasksSettingsAppliedEvent));
        Rebpower_PeriodicTasksSettingsAppliedEvent item_ = (Rebpower_PeriodicTasksSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveRebpower_PeriodicTasks_timersSettingsAppliedEvent() throws Exception {
        int priority = 676;
        int version = 440;
        long agentmonitorservice_taskPeriodMillis = 478L;
        long heartbeat_taskPeriodMillis = 3L;
        long monitor_check_taskPeriodMillis = 340L;
        long monitor_publish_taskPeriodMillis = 962L;
        long monitor_update_taskPeriodMillis = 86L;
        long reb_power_state_taskPeriodMillis = 14L;
        long runtimeinfo_taskPeriodMillis = 619L;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_PeriodicTasks_timersSettingsAppliedEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, reb_power_state_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Rebpower_PeriodicTasks_timersSettingsAppliedEvent));
        Rebpower_PeriodicTasks_timersSettingsAppliedEvent item_ = (Rebpower_PeriodicTasks_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)reb_power_state_taskPeriodMillis, (long)item_.getReb_power_state_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveRebpower_RebSettingsAppliedEvent() throws Exception {
        int priority = 68;
        int version = 333;
        int[] hvBias = TestHelper.generateIntArray((int)3, (int)2006262854);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_RebSettingsAppliedEvent(priority, version, hvBias, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebSettingsAppliedEvent));
        Rebpower_RebSettingsAppliedEvent item_ = (Rebpower_RebSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((int[])hvBias, (int[])item_.getHvBias());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveRebpower_Reb_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 880;
        int version = 253;
        double[] analog_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)-2027728826);
        double[] analog_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1676356190);
        double[] analog_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1482196585);
        double[] analog_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1870075857);
        double[] analog_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)-274764836);
        double[] analog_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-103718413);
        double[] analog_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1648656660);
        double[] analog_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1497529937);
        double[] analog_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)-896433604);
        double[] analog_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1184347117);
        double[] analog_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1396239170);
        double[] analog_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)710126697);
        double[] analog_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)3, (int)1226460318);
        double[] analog_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1235501548);
        double[] analog_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)3, (int)941091913);
        double[] analog_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)3, (int)-2117413851);
        double[] analog_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)1726309476);
        double[] analog_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)1495812485);
        double[] analog_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-410300769);
        double[] analog_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1906721907);
        double[] clockhi_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)118092674);
        double[] clockhi_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)362404357);
        double[] clockhi_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1139122773);
        double[] clockhi_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-708853029);
        double[] clockhi_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)228296474);
        double[] clockhi_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-773538536);
        double[] clockhi_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-2114264718);
        double[] clockhi_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-984128045);
        double[] clockhi_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)1084418149);
        double[] clockhi_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-307834051);
        double[] clockhi_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)1957242268);
        double[] clockhi_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)352199924);
        double[] clockhi_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)3, (int)-732880934);
        double[] clockhi_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)3, (int)-442352065);
        double[] clockhi_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)3, (int)997436211);
        double[] clockhi_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1460318742);
        double[] clockhi_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)-289601912);
        double[] clockhi_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)2084839627);
        double[] clockhi_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)795456169);
        double[] clockhi_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)1545754438);
        double[] clocklo_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)966658503);
        double[] clocklo_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)622805826);
        double[] clocklo_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)437903903);
        double[] clocklo_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1085488272);
        double[] clocklo_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1166211825);
        double[] clocklo_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1951682096);
        double[] clocklo_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-811693084);
        double[] clocklo_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)828554971);
        double[] clocklo_VaftLDO2_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1107405273);
        double[] clocklo_VaftLDO2_warnLo = TestHelper.generateDoubleArray((int)3, (int)421111741);
        double[] clocklo_VaftLDO2_limitHi = TestHelper.generateDoubleArray((int)3, (int)1917409595);
        double[] clocklo_VaftLDO2_limitLo = TestHelper.generateDoubleArray((int)3, (int)1336733051);
        double[] clocklo_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)662081409);
        double[] clocklo_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1692967933);
        double[] clocklo_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)454581601);
        double[] clocklo_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-563274892);
        double[] clocklo_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)3, (int)221080804);
        double[] clocklo_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1286700257);
        double[] clocklo_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1673866035);
        double[] clocklo_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)3, (int)703251731);
        double[] clocklo_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)969469515);
        double[] clocklo_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1369990613);
        double[] clocklo_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)713823417);
        double[] clocklo_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-391403007);
        double[] digital_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)513064205);
        double[] digital_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)1177440044);
        double[] digital_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1001427231);
        double[] digital_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1194991691);
        double[] digital_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)-2030551235);
        double[] digital_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1189897559);
        double[] digital_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-18870902);
        double[] digital_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-14936278);
        double[] digital_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)632290643);
        double[] digital_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)1736400508);
        double[] digital_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1632367675);
        double[] digital_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1087632942);
        double[] digital_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)3, (int)-159039989);
        double[] digital_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)3, (int)-745759253);
        double[] digital_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1656599052);
        double[] digital_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1339932215);
        double[] digital_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1517749108);
        double[] digital_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1352097030);
        double[] digital_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)1800330893);
        double[] digital_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1889160883);
        double[] heater_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)1434819789);
        double[] heater_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-2013354758);
        double[] heater_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1139158243);
        double[] heater_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)1560333678);
        double[] heater_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)2091713076);
        double[] heater_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)983483493);
        double[] heater_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1557594736);
        double[] heater_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1569382399);
        double[] heater_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)1186917503);
        double[] heater_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1862766611);
        double[] heater_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)2066017710);
        double[] heater_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)736199898);
        double[] heater_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)3, (int)1228783335);
        double[] heater_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)3, (int)867010258);
        double[] heater_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)3, (int)-591001880);
        double[] heater_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)3, (int)892503609);
        double[] heater_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)117839234);
        double[] heater_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)1380240499);
        double[] heater_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-648630699);
        double[] heater_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)748129412);
        double[] hvbias_IbefSwch_warnHi = TestHelper.generateDoubleArray((int)3, (int)385862888);
        double[] hvbias_IbefSwch_warnLo = TestHelper.generateDoubleArray((int)3, (int)1821868328);
        double[] hvbias_IbefSwch_limitHi = TestHelper.generateDoubleArray((int)3, (int)-249834250);
        double[] hvbias_IbefSwch_limitLo = TestHelper.generateDoubleArray((int)3, (int)-135342794);
        double[] hvbias_VbefSwch_warnHi = TestHelper.generateDoubleArray((int)3, (int)-203071463);
        double[] hvbias_VbefSwch_warnLo = TestHelper.generateDoubleArray((int)3, (int)792671310);
        double[] hvbias_VbefSwch_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1689951679);
        double[] hvbias_VbefSwch_limitLo = TestHelper.generateDoubleArray((int)3, (int)2139448599);
        String location = "l";
        double[] od_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)790381277);
        double[] od_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)-324572755);
        double[] od_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1060434707);
        double[] od_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1565672494);
        double[] od_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)490479529);
        double[] od_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)290504178);
        double[] od_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)653183249);
        double[] od_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-2138829231);
        double[] od_VaftLDO2_warnHi = TestHelper.generateDoubleArray((int)3, (int)2013462786);
        double[] od_VaftLDO2_warnLo = TestHelper.generateDoubleArray((int)3, (int)1192527430);
        double[] od_VaftLDO2_limitHi = TestHelper.generateDoubleArray((int)3, (int)-851280502);
        double[] od_VaftLDO2_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1518710678);
        double[] od_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)474047045);
        double[] od_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)1766725542);
        double[] od_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)966516849);
        double[] od_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)1316730776);
        double[] od_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)3, (int)1926855058);
        double[] od_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)3, (int)-2128830946);
        double[] od_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)3, (int)486141152);
        double[] od_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)3, (int)-2098903276);
        double[] od_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)3, (int)-643516461);
        double[] od_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)3, (int)466499196);
        double[] od_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)3, (int)572951696);
        double[] od_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)3, (int)-386637138);
        double[] power_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1578973956);
        double[] power_warnLo = TestHelper.generateDoubleArray((int)3, (int)-579440826);
        double[] power_limitHi = TestHelper.generateDoubleArray((int)3, (int)144095170);
        double[] power_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1307886880);
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Reb_LimitsSettingsAppliedEvent(priority, version, analog_IaftLDO_warnHi, analog_IaftLDO_warnLo, analog_IaftLDO_limitHi, analog_IaftLDO_limitLo, analog_IbefLDO_warnHi, analog_IbefLDO_warnLo, analog_IbefLDO_limitHi, analog_IbefLDO_limitLo, analog_VaftLDO_warnHi, analog_VaftLDO_warnLo, analog_VaftLDO_limitHi, analog_VaftLDO_limitLo, analog_VaftSwch_warnHi, analog_VaftSwch_warnLo, analog_VaftSwch_limitHi, analog_VaftSwch_limitLo, analog_VbefLDO_warnHi, analog_VbefLDO_warnLo, analog_VbefLDO_limitHi, analog_VbefLDO_limitLo, clockhi_IaftLDO_warnHi, clockhi_IaftLDO_warnLo, clockhi_IaftLDO_limitHi, clockhi_IaftLDO_limitLo, clockhi_IbefLDO_warnHi, clockhi_IbefLDO_warnLo, clockhi_IbefLDO_limitHi, clockhi_IbefLDO_limitLo, clockhi_VaftLDO_warnHi, clockhi_VaftLDO_warnLo, clockhi_VaftLDO_limitHi, clockhi_VaftLDO_limitLo, clockhi_VaftSwch_warnHi, clockhi_VaftSwch_warnLo, clockhi_VaftSwch_limitHi, clockhi_VaftSwch_limitLo, clockhi_VbefLDO_warnHi, clockhi_VbefLDO_warnLo, clockhi_VbefLDO_limitHi, clockhi_VbefLDO_limitLo, clocklo_IaftLDO_warnHi, clocklo_IaftLDO_warnLo, clocklo_IaftLDO_limitHi, clocklo_IaftLDO_limitLo, clocklo_IbefLDO_warnHi, clocklo_IbefLDO_warnLo, clocklo_IbefLDO_limitHi, clocklo_IbefLDO_limitLo, clocklo_VaftLDO2_warnHi, clocklo_VaftLDO2_warnLo, clocklo_VaftLDO2_limitHi, clocklo_VaftLDO2_limitLo, clocklo_VaftLDO_warnHi, clocklo_VaftLDO_warnLo, clocklo_VaftLDO_limitHi, clocklo_VaftLDO_limitLo, clocklo_VaftSwch_warnHi, clocklo_VaftSwch_warnLo, clocklo_VaftSwch_limitHi, clocklo_VaftSwch_limitLo, clocklo_VbefLDO_warnHi, clocklo_VbefLDO_warnLo, clocklo_VbefLDO_limitHi, clocklo_VbefLDO_limitLo, digital_IaftLDO_warnHi, digital_IaftLDO_warnLo, digital_IaftLDO_limitHi, digital_IaftLDO_limitLo, digital_IbefLDO_warnHi, digital_IbefLDO_warnLo, digital_IbefLDO_limitHi, digital_IbefLDO_limitLo, digital_VaftLDO_warnHi, digital_VaftLDO_warnLo, digital_VaftLDO_limitHi, digital_VaftLDO_limitLo, digital_VaftSwch_warnHi, digital_VaftSwch_warnLo, digital_VaftSwch_limitHi, digital_VaftSwch_limitLo, digital_VbefLDO_warnHi, digital_VbefLDO_warnLo, digital_VbefLDO_limitHi, digital_VbefLDO_limitLo, heater_IaftLDO_warnHi, heater_IaftLDO_warnLo, heater_IaftLDO_limitHi, heater_IaftLDO_limitLo, heater_IbefLDO_warnHi, heater_IbefLDO_warnLo, heater_IbefLDO_limitHi, heater_IbefLDO_limitLo, heater_VaftLDO_warnHi, heater_VaftLDO_warnLo, heater_VaftLDO_limitHi, heater_VaftLDO_limitLo, heater_VaftSwch_warnHi, heater_VaftSwch_warnLo, heater_VaftSwch_limitHi, heater_VaftSwch_limitLo, heater_VbefLDO_warnHi, heater_VbefLDO_warnLo, heater_VbefLDO_limitHi, heater_VbefLDO_limitLo, hvbias_IbefSwch_warnHi, hvbias_IbefSwch_warnLo, hvbias_IbefSwch_limitHi, hvbias_IbefSwch_limitLo, hvbias_VbefSwch_warnHi, hvbias_VbefSwch_warnLo, hvbias_VbefSwch_limitHi, hvbias_VbefSwch_limitLo, location, od_IaftLDO_warnHi, od_IaftLDO_warnLo, od_IaftLDO_limitHi, od_IaftLDO_limitLo, od_IbefLDO_warnHi, od_IbefLDO_warnLo, od_IbefLDO_limitHi, od_IbefLDO_limitLo, od_VaftLDO2_warnHi, od_VaftLDO2_warnLo, od_VaftLDO2_limitHi, od_VaftLDO2_limitLo, od_VaftLDO_warnHi, od_VaftLDO_warnLo, od_VaftLDO_limitHi, od_VaftLDO_limitLo, od_VaftSwch_warnHi, od_VaftSwch_warnLo, od_VaftSwch_limitHi, od_VaftSwch_limitLo, od_VbefLDO_warnHi, od_VbefLDO_warnLo, od_VbefLDO_limitHi, od_VbefLDO_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Reb_LimitsSettingsAppliedEvent));
        Rebpower_Reb_LimitsSettingsAppliedEvent item_ = (Rebpower_Reb_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])analog_IaftLDO_warnHi, (double[])item_.getAnalog_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_warnLo, (double[])item_.getAnalog_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_limitHi, (double[])item_.getAnalog_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_limitLo, (double[])item_.getAnalog_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_warnHi, (double[])item_.getAnalog_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_warnLo, (double[])item_.getAnalog_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_limitHi, (double[])item_.getAnalog_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_limitLo, (double[])item_.getAnalog_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_warnHi, (double[])item_.getAnalog_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_warnLo, (double[])item_.getAnalog_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_limitHi, (double[])item_.getAnalog_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_limitLo, (double[])item_.getAnalog_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_warnHi, (double[])item_.getAnalog_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_warnLo, (double[])item_.getAnalog_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_limitHi, (double[])item_.getAnalog_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_limitLo, (double[])item_.getAnalog_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_warnHi, (double[])item_.getAnalog_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_warnLo, (double[])item_.getAnalog_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_limitHi, (double[])item_.getAnalog_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_limitLo, (double[])item_.getAnalog_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_warnHi, (double[])item_.getClockhi_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_warnLo, (double[])item_.getClockhi_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_limitHi, (double[])item_.getClockhi_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_limitLo, (double[])item_.getClockhi_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_warnHi, (double[])item_.getClockhi_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_warnLo, (double[])item_.getClockhi_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_limitHi, (double[])item_.getClockhi_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_limitLo, (double[])item_.getClockhi_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_warnHi, (double[])item_.getClockhi_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_warnLo, (double[])item_.getClockhi_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_limitHi, (double[])item_.getClockhi_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_limitLo, (double[])item_.getClockhi_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_warnHi, (double[])item_.getClockhi_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_warnLo, (double[])item_.getClockhi_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_limitHi, (double[])item_.getClockhi_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_limitLo, (double[])item_.getClockhi_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_warnHi, (double[])item_.getClockhi_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_warnLo, (double[])item_.getClockhi_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_limitHi, (double[])item_.getClockhi_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_limitLo, (double[])item_.getClockhi_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_warnHi, (double[])item_.getClocklo_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_warnLo, (double[])item_.getClocklo_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_limitHi, (double[])item_.getClocklo_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_limitLo, (double[])item_.getClocklo_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_warnHi, (double[])item_.getClocklo_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_warnLo, (double[])item_.getClocklo_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_limitHi, (double[])item_.getClocklo_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_limitLo, (double[])item_.getClocklo_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_warnHi, (double[])item_.getClocklo_VaftLDO2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_warnLo, (double[])item_.getClocklo_VaftLDO2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_limitHi, (double[])item_.getClocklo_VaftLDO2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_limitLo, (double[])item_.getClocklo_VaftLDO2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_warnHi, (double[])item_.getClocklo_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_warnLo, (double[])item_.getClocklo_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_limitHi, (double[])item_.getClocklo_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_limitLo, (double[])item_.getClocklo_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_warnHi, (double[])item_.getClocklo_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_warnLo, (double[])item_.getClocklo_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_limitHi, (double[])item_.getClocklo_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_limitLo, (double[])item_.getClocklo_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_warnHi, (double[])item_.getClocklo_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_warnLo, (double[])item_.getClocklo_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_limitHi, (double[])item_.getClocklo_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_limitLo, (double[])item_.getClocklo_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_warnHi, (double[])item_.getDigital_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_warnLo, (double[])item_.getDigital_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_limitHi, (double[])item_.getDigital_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_limitLo, (double[])item_.getDigital_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_warnHi, (double[])item_.getDigital_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_warnLo, (double[])item_.getDigital_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_limitHi, (double[])item_.getDigital_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_limitLo, (double[])item_.getDigital_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_warnHi, (double[])item_.getDigital_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_warnLo, (double[])item_.getDigital_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_limitHi, (double[])item_.getDigital_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_limitLo, (double[])item_.getDigital_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_warnHi, (double[])item_.getDigital_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_warnLo, (double[])item_.getDigital_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_limitHi, (double[])item_.getDigital_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_limitLo, (double[])item_.getDigital_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_warnHi, (double[])item_.getDigital_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_warnLo, (double[])item_.getDigital_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_limitHi, (double[])item_.getDigital_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_limitLo, (double[])item_.getDigital_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_warnHi, (double[])item_.getHeater_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_warnLo, (double[])item_.getHeater_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_limitHi, (double[])item_.getHeater_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_limitLo, (double[])item_.getHeater_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_warnHi, (double[])item_.getHeater_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_warnLo, (double[])item_.getHeater_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_limitHi, (double[])item_.getHeater_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_limitLo, (double[])item_.getHeater_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_warnHi, (double[])item_.getHeater_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_warnLo, (double[])item_.getHeater_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_limitHi, (double[])item_.getHeater_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_limitLo, (double[])item_.getHeater_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_warnHi, (double[])item_.getHeater_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_warnLo, (double[])item_.getHeater_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_limitHi, (double[])item_.getHeater_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_limitLo, (double[])item_.getHeater_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_warnHi, (double[])item_.getHeater_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_warnLo, (double[])item_.getHeater_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_limitHi, (double[])item_.getHeater_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_limitLo, (double[])item_.getHeater_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_warnHi, (double[])item_.getHvbias_IbefSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_warnLo, (double[])item_.getHvbias_IbefSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_limitHi, (double[])item_.getHvbias_IbefSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_limitLo, (double[])item_.getHvbias_IbefSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_warnHi, (double[])item_.getHvbias_VbefSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_warnLo, (double[])item_.getHvbias_VbefSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_limitHi, (double[])item_.getHvbias_VbefSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_limitLo, (double[])item_.getHvbias_VbefSwch_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO_warnHi, (double[])item_.getOd_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_warnLo, (double[])item_.getOd_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_limitHi, (double[])item_.getOd_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_limitLo, (double[])item_.getOd_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_warnHi, (double[])item_.getOd_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_warnLo, (double[])item_.getOd_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_limitHi, (double[])item_.getOd_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_limitLo, (double[])item_.getOd_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_warnHi, (double[])item_.getOd_VaftLDO2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_warnLo, (double[])item_.getOd_VaftLDO2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_limitHi, (double[])item_.getOd_VaftLDO2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_limitLo, (double[])item_.getOd_VaftLDO2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_warnHi, (double[])item_.getOd_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_warnLo, (double[])item_.getOd_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_limitHi, (double[])item_.getOd_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_limitLo, (double[])item_.getOd_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_warnHi, (double[])item_.getOd_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_warnLo, (double[])item_.getOd_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_limitHi, (double[])item_.getOd_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_limitLo, (double[])item_.getOd_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_warnHi, (double[])item_.getOd_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_warnLo, (double[])item_.getOd_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_limitHi, (double[])item_.getOd_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_limitLo, (double[])item_.getOd_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnHi, (double[])item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnLo, (double[])item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitHi, (double[])item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitLo, (double[])item_.getPower_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_Rebps_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 842;
        int version = 38;
        double[] boardtemp0_warnHi = TestHelper.generateDoubleArray((int)1, (int)273821539);
        double[] boardtemp0_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1899534817);
        double[] boardtemp0_limitHi = TestHelper.generateDoubleArray((int)1, (int)149007987);
        double[] boardtemp0_limitLo = TestHelper.generateDoubleArray((int)1, (int)1099164993);
        double[] boardtemp1_warnHi = TestHelper.generateDoubleArray((int)1, (int)-593873558);
        double[] boardtemp1_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1378337932);
        double[] boardtemp1_limitHi = TestHelper.generateDoubleArray((int)1, (int)-2147178548);
        double[] boardtemp1_limitLo = TestHelper.generateDoubleArray((int)1, (int)303334952);
        double[] boardtemp2_warnHi = TestHelper.generateDoubleArray((int)1, (int)-1936136316);
        double[] boardtemp2_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1857568181);
        double[] boardtemp2_limitHi = TestHelper.generateDoubleArray((int)1, (int)1063962733);
        double[] boardtemp2_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1498416246);
        double[] boardtemp3_warnHi = TestHelper.generateDoubleArray((int)1, (int)1104748531);
        double[] boardtemp3_warnLo = TestHelper.generateDoubleArray((int)1, (int)230837131);
        double[] boardtemp3_limitHi = TestHelper.generateDoubleArray((int)1, (int)580102213);
        double[] boardtemp3_limitLo = TestHelper.generateDoubleArray((int)1, (int)-1853622129);
        double[] boardtemp4_warnHi = TestHelper.generateDoubleArray((int)1, (int)769720499);
        double[] boardtemp4_warnLo = TestHelper.generateDoubleArray((int)1, (int)1804994534);
        double[] boardtemp4_limitHi = TestHelper.generateDoubleArray((int)1, (int)1052021030);
        double[] boardtemp4_limitLo = TestHelper.generateDoubleArray((int)1, (int)1658386444);
        double[] boardtemp5_warnHi = TestHelper.generateDoubleArray((int)1, (int)2034732254);
        double[] boardtemp5_warnLo = TestHelper.generateDoubleArray((int)1, (int)1390751601);
        double[] boardtemp5_limitHi = TestHelper.generateDoubleArray((int)1, (int)1477595340);
        double[] boardtemp5_limitLo = TestHelper.generateDoubleArray((int)1, (int)1722828858);
        double[] boardtemp6_warnHi = TestHelper.generateDoubleArray((int)1, (int)2034234448);
        double[] boardtemp6_warnLo = TestHelper.generateDoubleArray((int)1, (int)-1323659657);
        double[] boardtemp6_limitHi = TestHelper.generateDoubleArray((int)1, (int)-157833442);
        double[] boardtemp6_limitLo = TestHelper.generateDoubleArray((int)1, (int)781325736);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_LimitsSettingsAppliedEvent(priority, version, boardtemp0_warnHi, boardtemp0_warnLo, boardtemp0_limitHi, boardtemp0_limitLo, boardtemp1_warnHi, boardtemp1_warnLo, boardtemp1_limitHi, boardtemp1_limitLo, boardtemp2_warnHi, boardtemp2_warnLo, boardtemp2_limitHi, boardtemp2_limitLo, boardtemp3_warnHi, boardtemp3_warnLo, boardtemp3_limitHi, boardtemp3_limitLo, boardtemp4_warnHi, boardtemp4_warnLo, boardtemp4_limitHi, boardtemp4_limitLo, boardtemp5_warnHi, boardtemp5_warnLo, boardtemp5_limitHi, boardtemp5_limitLo, boardtemp6_warnHi, boardtemp6_warnLo, boardtemp6_limitHi, boardtemp6_limitLo, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_LimitsSettingsAppliedEvent));
        Rebpower_Rebps_LimitsSettingsAppliedEvent item_ = (Rebpower_Rebps_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])boardtemp0_warnHi, (double[])item_.getBoardtemp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_warnLo, (double[])item_.getBoardtemp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_limitHi, (double[])item_.getBoardtemp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_limitLo, (double[])item_.getBoardtemp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_warnHi, (double[])item_.getBoardtemp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_warnLo, (double[])item_.getBoardtemp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_limitHi, (double[])item_.getBoardtemp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_limitLo, (double[])item_.getBoardtemp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_warnHi, (double[])item_.getBoardtemp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_warnLo, (double[])item_.getBoardtemp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_limitHi, (double[])item_.getBoardtemp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_limitLo, (double[])item_.getBoardtemp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_warnHi, (double[])item_.getBoardtemp3_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_warnLo, (double[])item_.getBoardtemp3_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_limitHi, (double[])item_.getBoardtemp3_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_limitLo, (double[])item_.getBoardtemp3_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_warnHi, (double[])item_.getBoardtemp4_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_warnLo, (double[])item_.getBoardtemp4_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_limitHi, (double[])item_.getBoardtemp4_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_limitLo, (double[])item_.getBoardtemp4_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_warnHi, (double[])item_.getBoardtemp5_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_warnLo, (double[])item_.getBoardtemp5_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_limitHi, (double[])item_.getBoardtemp5_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_limitLo, (double[])item_.getBoardtemp5_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_warnHi, (double[])item_.getBoardtemp6_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_warnLo, (double[])item_.getBoardtemp6_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_limitHi, (double[])item_.getBoardtemp6_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_limitLo, (double[])item_.getBoardtemp6_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveRebpower_Rebps_PowerSettingsAppliedEvent() throws Exception {
        int priority = 780;
        int version = 41;
        String ipAddr = "";
        String location = "";
        int[] nPowerOnPub = TestHelper.generateIntArray((int)1, (int)329251545);
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_PowerSettingsAppliedEvent(priority, version, ipAddr, location, nPowerOnPub));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_PowerSettingsAppliedEvent));
        Rebpower_Rebps_PowerSettingsAppliedEvent item_ = (Rebpower_Rebps_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)ipAddr, (Object)item_.getIpAddr());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((int[])nPowerOnPub, (int[])item_.getNPowerOnPub());
    }

    @Test
    public void sendReceiveVacuum_Cold1_CryoconSettingsAppliedEvent() throws Exception {
        int priority = 155;
        int version = 81;
        double d_gain = 0.779416024684906;
        double i_gain = 0.2768756151199341;
        double p_gain = 0.4441349506378174;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cold1_CryoconSettingsAppliedEvent(priority, version, d_gain, i_gain, p_gain));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold1_CryoconSettingsAppliedEvent));
        Vacuum_Cold1_CryoconSettingsAppliedEvent item_ = (Vacuum_Cold1_CryoconSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)d_gain, (double)item_.getD_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)i_gain, (double)item_.getI_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)p_gain, (double)item_.getP_gain(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold1_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 371;
        int version = 970;
        double autooffenabled_warnHi = 0.5889905095100403;
        double autooffenabled_warnLo = 0.862678587436676;
        double autooffenabled_limitHi = 0.759788f;
        double autooffenabled_limitLo = 0.24051225185394287;
        double autoofftemperature_warnHi = 0.5518115162849426;
        double autoofftemperature_warnLo = 0.5088573098182678;
        double autoofftemperature_limitHi = 0.8950796723365784;
        double autoofftemperature_limitLo = 0.17582905292510986;
        double autoontemperature_warnHi = 0.26496803760528564;
        double autoontemperature_warnLo = 0.4779793620109558;
        double autoontemperature_limitHi = 0.15224981307983398;
        double autoontemperature_limitLo = 0.10457044839859009;
        double power_warnHi = 0.7497748136520386;
        double power_warnLo = 0.1686194f;
        double power_limitHi = 0.30979394912719727;
        double power_limitLo = 0.21112632751464844;
        double rejecttemperature_warnHi = 0.3359434f;
        double rejecttemperature_warnLo = 0.147347092628479;
        double rejecttemperature_limitHi = 0.9024807214736938;
        double rejecttemperature_limitLo = 0.9873150587081909;
        double setpower_warnHi = 0.7804882526397705;
        double setpower_warnLo = 0.21205365657806396;
        double setpower_limitHi = 0.19770705699920654;
        double setpower_limitLo = 0.0017998814582824707;
        double setpoint_warnHi = 0.893978476524353;
        double setpoint_warnLo = 0.5026865005493164;
        double setpoint_limitHi = 0.2176659107208252;
        double setpoint_limitLo = 0.6090694069862366;
        double temp_Min_OFF = 0.9734766483306885;
        double temp_Min_ON = 0.8928537964820862;
        double temperature_warnHi = 0.0497211217880249;
        double temperature_warnLo = 0.2681116461753845;
        double temperature_limitHi = 0.529084324836731;
        double temperature_limitLo = 0.05878615379333496;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cold1_LimitsSettingsAppliedEvent(priority, version, autooffenabled_warnHi, autooffenabled_warnLo, autooffenabled_limitHi, autooffenabled_limitLo, autoofftemperature_warnHi, autoofftemperature_warnLo, autoofftemperature_limitHi, autoofftemperature_limitLo, autoontemperature_warnHi, autoontemperature_warnLo, autoontemperature_limitHi, autoontemperature_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo, rejecttemperature_warnHi, rejecttemperature_warnLo, rejecttemperature_limitHi, rejecttemperature_limitLo, setpower_warnHi, setpower_warnLo, setpower_limitHi, setpower_limitLo, setpoint_warnHi, setpoint_warnLo, setpoint_limitHi, setpoint_limitLo, temp_Min_OFF, temp_Min_ON, temperature_warnHi, temperature_warnLo, temperature_limitHi, temperature_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold1_LimitsSettingsAppliedEvent));
        Vacuum_Cold1_LimitsSettingsAppliedEvent item_ = (Vacuum_Cold1_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)autooffenabled_warnHi, (double)item_.getAutooffenabled_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_warnLo, (double)item_.getAutooffenabled_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_limitHi, (double)item_.getAutooffenabled_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_limitLo, (double)item_.getAutooffenabled_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_warnHi, (double)item_.getAutoofftemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_warnLo, (double)item_.getAutoofftemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_limitHi, (double)item_.getAutoofftemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_limitLo, (double)item_.getAutoofftemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_warnHi, (double)item_.getAutoontemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_warnLo, (double)item_.getAutoontemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_limitHi, (double)item_.getAutoontemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_limitLo, (double)item_.getAutoontemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)power_warnHi, (double)item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)power_warnLo, (double)item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)power_limitHi, (double)item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)power_limitLo, (double)item_.getPower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_warnHi, (double)item_.getRejecttemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_warnLo, (double)item_.getRejecttemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_limitHi, (double)item_.getRejecttemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_limitLo, (double)item_.getRejecttemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_warnHi, (double)item_.getSetpower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_warnLo, (double)item_.getSetpower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_limitHi, (double)item_.getSetpower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_limitLo, (double)item_.getSetpower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_warnHi, (double)item_.getSetpoint_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_warnLo, (double)item_.getSetpoint_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_limitHi, (double)item_.getSetpoint_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_limitLo, (double)item_.getSetpoint_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temp_Min_OFF, (double)item_.getTemp_Min_OFF(), (double)1.0E-6f);
        Assert.assertEquals((double)temp_Min_ON, (double)item_.getTemp_Min_ON(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_warnHi, (double)item_.getTemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_warnLo, (double)item_.getTemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_limitHi, (double)item_.getTemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_limitLo, (double)item_.getTemperature_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold2_CryoconSettingsAppliedEvent() throws Exception {
        int priority = 711;
        int version = 112;
        double d_gain = 0.928119f;
        double i_gain = 0.25203055143356323;
        double p_gain = 0.23448187112808228;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cold2_CryoconSettingsAppliedEvent(priority, version, d_gain, i_gain, p_gain));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold2_CryoconSettingsAppliedEvent));
        Vacuum_Cold2_CryoconSettingsAppliedEvent item_ = (Vacuum_Cold2_CryoconSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)d_gain, (double)item_.getD_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)i_gain, (double)item_.getI_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)p_gain, (double)item_.getP_gain(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cold2_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 478;
        int version = 757;
        double autooffenabled_warnHi = 0.35309863090515137;
        double autooffenabled_warnLo = 0.937881f;
        double autooffenabled_limitHi = 0.7643618583679199;
        double autooffenabled_limitLo = 0.35663992166519165;
        double autoofftemperature_warnHi = 0.7248210906982422;
        double autoofftemperature_warnLo = 0.00886458158493042;
        double autoofftemperature_limitHi = 0.8635683059692383;
        double autoofftemperature_limitLo = 0.525514f;
        double autoontemperature_warnHi = 0.4517327547073364;
        double autoontemperature_warnLo = 0.9946938753128052;
        double autoontemperature_limitHi = 0.11279827356338501;
        double autoontemperature_limitLo = 0.8843053579330444;
        double power_warnHi = 0.9963942170143127;
        double power_warnLo = 0.4767602f;
        double power_limitHi = 0.7324386835098267;
        double power_limitLo = 0.0687408447265625;
        double rejecttemperature_warnHi = 0.14175671339035034;
        double rejecttemperature_warnLo = 0.2010408f;
        double rejecttemperature_limitHi = 0.16168522834777832;
        double rejecttemperature_limitLo = 0.02596902847290039;
        double setpower_warnHi = 0.35271936655044556;
        double setpower_warnLo = 0.522193193435669;
        double setpower_limitHi = 0.05116891860961914;
        double setpower_limitLo = 0.8524715900421143;
        double setpoint_warnHi = 0.677761971950531;
        double setpoint_warnLo = 0.6856864094734192;
        double setpoint_limitHi = 0.15195822715759277;
        double setpoint_limitLo = 0.7192482352256775;
        double temp_Min_OFF = 0.8364443778991699;
        double temp_Min_ON = 0.161748468875885;
        double temperature_warnHi = 0.6321895122528076;
        double temperature_warnLo = 0.10460102558135986;
        double temperature_limitHi = 0.7797408103942871;
        double temperature_limitLo = 0.7016832828521729;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cold2_LimitsSettingsAppliedEvent(priority, version, autooffenabled_warnHi, autooffenabled_warnLo, autooffenabled_limitHi, autooffenabled_limitLo, autoofftemperature_warnHi, autoofftemperature_warnLo, autoofftemperature_limitHi, autoofftemperature_limitLo, autoontemperature_warnHi, autoontemperature_warnLo, autoontemperature_limitHi, autoontemperature_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo, rejecttemperature_warnHi, rejecttemperature_warnLo, rejecttemperature_limitHi, rejecttemperature_limitLo, setpower_warnHi, setpower_warnLo, setpower_limitHi, setpower_limitLo, setpoint_warnHi, setpoint_warnLo, setpoint_limitHi, setpoint_limitLo, temp_Min_OFF, temp_Min_ON, temperature_warnHi, temperature_warnLo, temperature_limitHi, temperature_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cold2_LimitsSettingsAppliedEvent));
        Vacuum_Cold2_LimitsSettingsAppliedEvent item_ = (Vacuum_Cold2_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)autooffenabled_warnHi, (double)item_.getAutooffenabled_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_warnLo, (double)item_.getAutooffenabled_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_limitHi, (double)item_.getAutooffenabled_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_limitLo, (double)item_.getAutooffenabled_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_warnHi, (double)item_.getAutoofftemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_warnLo, (double)item_.getAutoofftemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_limitHi, (double)item_.getAutoofftemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_limitLo, (double)item_.getAutoofftemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_warnHi, (double)item_.getAutoontemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_warnLo, (double)item_.getAutoontemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_limitHi, (double)item_.getAutoontemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_limitLo, (double)item_.getAutoontemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)power_warnHi, (double)item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)power_warnLo, (double)item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)power_limitHi, (double)item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)power_limitLo, (double)item_.getPower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_warnHi, (double)item_.getRejecttemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_warnLo, (double)item_.getRejecttemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_limitHi, (double)item_.getRejecttemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_limitLo, (double)item_.getRejecttemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_warnHi, (double)item_.getSetpower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_warnLo, (double)item_.getSetpower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_limitHi, (double)item_.getSetpower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_limitLo, (double)item_.getSetpower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_warnHi, (double)item_.getSetpoint_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_warnLo, (double)item_.getSetpoint_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_limitHi, (double)item_.getSetpoint_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_limitLo, (double)item_.getSetpoint_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temp_Min_OFF, (double)item_.getTemp_Min_OFF(), (double)1.0E-6f);
        Assert.assertEquals((double)temp_Min_ON, (double)item_.getTemp_Min_ON(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_warnHi, (double)item_.getTemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_warnLo, (double)item_.getTemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_limitHi, (double)item_.getTemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_limitLo, (double)item_.getTemperature_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cryo_CryoconSettingsAppliedEvent() throws Exception {
        int priority = 454;
        int version = 549;
        double d_gain = 0.3623538017272949;
        double i_gain = 0.33647865056991577;
        double p_gain = 0.10063028335571289;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cryo_CryoconSettingsAppliedEvent(priority, version, d_gain, i_gain, p_gain));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cryo_CryoconSettingsAppliedEvent));
        Vacuum_Cryo_CryoconSettingsAppliedEvent item_ = (Vacuum_Cryo_CryoconSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)d_gain, (double)item_.getD_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)i_gain, (double)item_.getI_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)p_gain, (double)item_.getP_gain(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Cryo_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 479;
        int version = 630;
        double autooffenabled_warnHi = 0.4579014182090759;
        double autooffenabled_warnLo = 0.2700703740119934;
        double autooffenabled_limitHi = 0.27534347772598267;
        double autooffenabled_limitLo = 0.5729556679725647;
        double autoofftemperature_warnHi = 0.8949098587036133;
        double autoofftemperature_warnLo = 0.7206348180770874;
        double autoofftemperature_limitHi = 0.8623384237289429;
        double autoofftemperature_limitLo = 0.4858793616294861;
        double autoontemperature_warnHi = 0.45777201652526855;
        double autoontemperature_warnLo = 0.5911467671394348;
        double autoontemperature_limitHi = 0.393549382686615;
        double autoontemperature_limitLo = 0.6219715476036072;
        double power_warnHi = 0.40645831823349;
        double power_warnLo = 0.0836363434791565;
        double power_limitHi = 0.748494029045105;
        double power_limitLo = 0.5268413424491882;
        double rejecttemperature_warnHi = 0.29950016736984253;
        double rejecttemperature_warnLo = 0.24664908647537231;
        double rejecttemperature_limitHi = 0.767871618270874;
        double rejecttemperature_limitLo = 0.2619808316230774;
        double setpower_warnHi = 0.48851585388183594;
        double setpower_warnLo = 0.3681f;
        double setpower_limitHi = 0.177703857421875;
        double setpower_limitLo = 0.8507076501846313;
        double setpoint_warnHi = 0.3890703320503235;
        double setpoint_warnLo = 0.8853934407234192;
        double setpoint_limitHi = 0.16424894332885742;
        double setpoint_limitLo = 0.582197368144989;
        double temp_Min_OFF = 0.5306582450866699;
        double temp_Min_ON = 0.2015218734741211;
        double temperature_warnHi = 0.5292513370513916;
        double temperature_warnLo = 0.5915347337722778;
        double temperature_limitHi = 0.17069f;
        double temperature_limitLo = 0.6826686859130859;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Cryo_LimitsSettingsAppliedEvent(priority, version, autooffenabled_warnHi, autooffenabled_warnLo, autooffenabled_limitHi, autooffenabled_limitLo, autoofftemperature_warnHi, autoofftemperature_warnLo, autoofftemperature_limitHi, autoofftemperature_limitLo, autoontemperature_warnHi, autoontemperature_warnLo, autoontemperature_limitHi, autoontemperature_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo, rejecttemperature_warnHi, rejecttemperature_warnLo, rejecttemperature_limitHi, rejecttemperature_limitLo, setpower_warnHi, setpower_warnLo, setpower_limitHi, setpower_limitLo, setpoint_warnHi, setpoint_warnLo, setpoint_limitHi, setpoint_limitLo, temp_Min_OFF, temp_Min_ON, temperature_warnHi, temperature_warnLo, temperature_limitHi, temperature_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Cryo_LimitsSettingsAppliedEvent));
        Vacuum_Cryo_LimitsSettingsAppliedEvent item_ = (Vacuum_Cryo_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)autooffenabled_warnHi, (double)item_.getAutooffenabled_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_warnLo, (double)item_.getAutooffenabled_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_limitHi, (double)item_.getAutooffenabled_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autooffenabled_limitLo, (double)item_.getAutooffenabled_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_warnHi, (double)item_.getAutoofftemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_warnLo, (double)item_.getAutoofftemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_limitHi, (double)item_.getAutoofftemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoofftemperature_limitLo, (double)item_.getAutoofftemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_warnHi, (double)item_.getAutoontemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_warnLo, (double)item_.getAutoontemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_limitHi, (double)item_.getAutoontemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)autoontemperature_limitLo, (double)item_.getAutoontemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)power_warnHi, (double)item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)power_warnLo, (double)item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)power_limitHi, (double)item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)power_limitLo, (double)item_.getPower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_warnHi, (double)item_.getRejecttemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_warnLo, (double)item_.getRejecttemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_limitHi, (double)item_.getRejecttemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rejecttemperature_limitLo, (double)item_.getRejecttemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_warnHi, (double)item_.getSetpower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_warnLo, (double)item_.getSetpower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_limitHi, (double)item_.getSetpower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpower_limitLo, (double)item_.getSetpower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_warnHi, (double)item_.getSetpoint_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_warnLo, (double)item_.getSetpoint_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_limitHi, (double)item_.getSetpoint_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)setpoint_limitLo, (double)item_.getSetpoint_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temp_Min_OFF, (double)item_.getTemp_Min_OFF(), (double)1.0E-6f);
        Assert.assertEquals((double)temp_Min_ON, (double)item_.getTemp_Min_ON(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_warnHi, (double)item_.getTemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_warnLo, (double)item_.getTemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_limitHi, (double)item_.getTemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperature_limitLo, (double)item_.getTemperature_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_IonPumps_CryoSettingsAppliedEvent() throws Exception {
        int priority = 787;
        int version = 81;
        double cip1c_current = 0.05587393045425415;
        double cip1c_power = 0.5080180764198303;
        double cip1c_voltage = 0.3663373f;
        String ipAddr = "b";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_IonPumps_CryoSettingsAppliedEvent(priority, version, cip1c_current, cip1c_power, cip1c_voltage, ipAddr));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumps_CryoSettingsAppliedEvent));
        Vacuum_IonPumps_CryoSettingsAppliedEvent item_ = (Vacuum_IonPumps_CryoSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)cip1c_current, (double)item_.getCip1c_current(), (double)1.0E-6f);
        Assert.assertEquals((double)cip1c_power, (double)item_.getCip1c_power(), (double)1.0E-6f);
        Assert.assertEquals((double)cip1c_voltage, (double)item_.getCip1c_voltage(), (double)1.0E-6f);
        Assert.assertEquals((Object)ipAddr, (Object)item_.getIpAddr());
    }

    @Test
    public void sendReceiveVacuum_IonPumps_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 311;
        int version = 992;
        double current_warnHi = 0.5887249112129211;
        double current_warnLo = 0.47140854597091675;
        double current_limitHi = 0.10862231254577637;
        double current_limitLo = 0.3732417821884155;
        double voltage_warnHi = 0.376612f;
        double voltage_warnLo = 0.562292f;
        double voltage_limitHi = 0.11836177110671997;
        double voltage_limitLo = 0.11182254552841187;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_IonPumps_LimitsSettingsAppliedEvent(priority, version, current_warnHi, current_warnLo, current_limitHi, current_limitLo, voltage_warnHi, voltage_warnLo, voltage_limitHi, voltage_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumps_LimitsSettingsAppliedEvent));
        Vacuum_IonPumps_LimitsSettingsAppliedEvent item_ = (Vacuum_IonPumps_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current_warnHi, (double)item_.getCurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)current_warnLo, (double)item_.getCurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)current_limitHi, (double)item_.getCurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)current_limitLo, (double)item_.getCurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage_warnHi, (double)item_.getVoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage_warnLo, (double)item_.getVoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage_limitHi, (double)item_.getVoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage_limitLo, (double)item_.getVoltage_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_PeriodicTasksSettingsAppliedEvent() throws Exception {
        int priority = 202;
        int version = 369;
        int schedulers_default_nTasks = 298;
        int schedulers_default_nThreads = 89;
        int schedulers_monitor_update_publish_scheduler_nTasks = 237;
        int schedulers_monitor_update_publish_scheduler_nThreads = 798;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PeriodicTasksSettingsAppliedEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PeriodicTasksSettingsAppliedEvent));
        Vacuum_PeriodicTasksSettingsAppliedEvent item_ = (Vacuum_PeriodicTasksSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveVacuum_PeriodicTasks_timersSettingsAppliedEvent() throws Exception {
        int priority = 786;
        int version = 330;
        long agentmonitorservice_taskPeriodMillis = 684L;
        long heartbeat_taskPeriodMillis = 6L;
        long monitor_check_taskPeriodMillis = 358L;
        long monitor_publish_taskPeriodMillis = 422L;
        long monitor_update_taskPeriodMillis = 378L;
        long runtimeinfo_taskPeriodMillis = 522L;
        long vacuum_state_taskPeriodMillis = 595L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_PeriodicTasks_timersSettingsAppliedEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis, vacuum_state_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_PeriodicTasks_timersSettingsAppliedEvent));
        Vacuum_PeriodicTasks_timersSettingsAppliedEvent item_ = (Vacuum_PeriodicTasks_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)vacuum_state_taskPeriodMillis, (long)item_.getVacuum_state_taskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_Rtds_DeviceSettingsAppliedEvent() throws Exception {
        int priority = 262;
        int version = 382;
        String node = "r";
        String serials = "";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Rtds_DeviceSettingsAppliedEvent(priority, version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Rtds_DeviceSettingsAppliedEvent));
        Vacuum_Rtds_DeviceSettingsAppliedEvent item_ = (Vacuum_Rtds_DeviceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveVacuum_Rtds_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 435;
        int version = 560;
        double temperaturecold1_warnHi = 0.590442f;
        double temperaturecold1_warnLo = 0.808464765548706;
        double temperaturecold1_limitHi = 0.5955008864402771;
        double temperaturecold1_limitLo = 0.18658453226089478;
        double temperaturecold2_warnHi = 0.3638281226158142;
        double temperaturecold2_warnLo = 0.6111805438995361;
        double temperaturecold2_limitHi = 0.5877537727355957;
        double temperaturecold2_limitLo = 0.22770464420318604;
        double temperaturecryo_warnHi = 0.08397293090820312;
        double temperaturecryo_warnLo = 0.705195426940918;
        double temperaturecryo_limitHi = 0.5745881199836731;
        double temperaturecryo_limitLo = 0.3399214f;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Rtds_LimitsSettingsAppliedEvent(priority, version, temperaturecold1_warnHi, temperaturecold1_warnLo, temperaturecold1_limitHi, temperaturecold1_limitLo, temperaturecold2_warnHi, temperaturecold2_warnLo, temperaturecold2_limitHi, temperaturecold2_limitLo, temperaturecryo_warnHi, temperaturecryo_warnLo, temperaturecryo_limitHi, temperaturecryo_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Rtds_LimitsSettingsAppliedEvent));
        Vacuum_Rtds_LimitsSettingsAppliedEvent item_ = (Vacuum_Rtds_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)temperaturecold1_warnHi, (double)item_.getTemperaturecold1_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecold1_warnLo, (double)item_.getTemperaturecold1_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecold1_limitHi, (double)item_.getTemperaturecold1_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecold1_limitLo, (double)item_.getTemperaturecold1_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecold2_warnHi, (double)item_.getTemperaturecold2_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecold2_warnLo, (double)item_.getTemperaturecold2_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecold2_limitHi, (double)item_.getTemperaturecold2_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecold2_limitLo, (double)item_.getTemperaturecold2_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecryo_warnHi, (double)item_.getTemperaturecryo_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecryo_warnLo, (double)item_.getTemperaturecryo_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecryo_limitHi, (double)item_.getTemperaturecryo_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)temperaturecryo_limitLo, (double)item_.getTemperaturecryo_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboSettingsAppliedEvent() throws Exception {
        int priority = 646;
        int version = 277;
        boolean activeStopMode = false;
        String devcId = "";
        boolean interlockType = true;
        boolean lowSpeedMode = false;
        boolean model304 = false;
        boolean softStartMode = true;
        boolean ventValveByCmnd = true;
        boolean waterCooling = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboSettingsAppliedEvent(priority, version, activeStopMode, devcId, interlockType, lowSpeedMode, model304, softStartMode, ventValveByCmnd, waterCooling));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboSettingsAppliedEvent));
        Vacuum_TurboSettingsAppliedEvent item_ = (Vacuum_TurboSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)activeStopMode, (Object)item_.isActiveStopMode());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((Object)interlockType, (Object)item_.isInterlockType());
        Assert.assertEquals((Object)lowSpeedMode, (Object)item_.isLowSpeedMode());
        Assert.assertEquals((Object)model304, (Object)item_.isModel304());
        Assert.assertEquals((Object)softStartMode, (Object)item_.isSoftStartMode());
        Assert.assertEquals((Object)ventValveByCmnd, (Object)item_.isVentValveByCmnd());
        Assert.assertEquals((Object)waterCooling, (Object)item_.isWaterCooling());
    }

    @Test
    public void sendReceiveVacuum_Turbo_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 379;
        int version = 40;
        double cntrlrairtemperature_warnHi = 0.0288409f;
        double cntrlrairtemperature_warnLo = 0.39329564571380615;
        double cntrlrairtemperature_limitHi = 0.22851771116256714;
        double cntrlrairtemperature_limitLo = 0.21255344152450562;
        double cntrlrsinktemperature_warnHi = 0.011912405490875244;
        double cntrlrsinktemperature_warnLo = 0.5514242649078369;
        double cntrlrsinktemperature_limitHi = 0.6508852243423462;
        double cntrlrsinktemperature_limitLo = 0.568288266658783;
        double current_warnHi = 0.637826144695282;
        double current_warnLo = 0.09007900953292847;
        double current_limitHi = 0.8701666593551636;
        double current_limitLo = 0.36637115478515625;
        double drivefrequency_warnHi = 0.03323858976364136;
        double drivefrequency_warnLo = 0.8563101887702942;
        double drivefrequency_limitHi = 0.8666839003562927;
        double drivefrequency_limitLo = 0.45781224966049194;
        double power_warnHi = 0.3513185381889343;
        double power_warnLo = 0.4714767336845398;
        double power_limitHi = 0.46924442052841187;
        double power_limitLo = 0.2972654700279236;
        double pumptemperature_warnHi = 0.6357949376106262;
        double pumptemperature_warnLo = 0.5301083922386169;
        double pumptemperature_limitHi = 0.7822174429893494;
        double pumptemperature_limitLo = 0.5979655385017395;
        double rpm_warnHi = 0.7027034163475037;
        double rpm_warnLo = 0.9898995161056519;
        double rpm_limitHi = 0.12456047534942627;
        double rpm_limitLo = 0.8187646269798279;
        double status_warnHi = 0.4652571678161621;
        double status_warnLo = 0.3246997594833374;
        double status_limitHi = 0.7379271984100342;
        double status_limitLo = 0.006887316703796387;
        double voltage_warnHi = 0.4530452489852905;
        double voltage_warnLo = 0.3875085115432739;
        double voltage_limitHi = 0.721917450428009;
        double voltage_limitLo = 0.27117353677749634;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Turbo_LimitsSettingsAppliedEvent(priority, version, cntrlrairtemperature_warnHi, cntrlrairtemperature_warnLo, cntrlrairtemperature_limitHi, cntrlrairtemperature_limitLo, cntrlrsinktemperature_warnHi, cntrlrsinktemperature_warnLo, cntrlrsinktemperature_limitHi, cntrlrsinktemperature_limitLo, current_warnHi, current_warnLo, current_limitHi, current_limitLo, drivefrequency_warnHi, drivefrequency_warnLo, drivefrequency_limitHi, drivefrequency_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo, pumptemperature_warnHi, pumptemperature_warnLo, pumptemperature_limitHi, pumptemperature_limitLo, rpm_warnHi, rpm_warnLo, rpm_limitHi, rpm_limitLo, status_warnHi, status_warnLo, status_limitHi, status_limitLo, voltage_warnHi, voltage_warnLo, voltage_limitHi, voltage_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Turbo_LimitsSettingsAppliedEvent));
        Vacuum_Turbo_LimitsSettingsAppliedEvent item_ = (Vacuum_Turbo_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)cntrlrairtemperature_warnHi, (double)item_.getCntrlrairtemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrairtemperature_warnLo, (double)item_.getCntrlrairtemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrairtemperature_limitHi, (double)item_.getCntrlrairtemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrairtemperature_limitLo, (double)item_.getCntrlrairtemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrsinktemperature_warnHi, (double)item_.getCntrlrsinktemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrsinktemperature_warnLo, (double)item_.getCntrlrsinktemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrsinktemperature_limitHi, (double)item_.getCntrlrsinktemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cntrlrsinktemperature_limitLo, (double)item_.getCntrlrsinktemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)current_warnHi, (double)item_.getCurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)current_warnLo, (double)item_.getCurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)current_limitHi, (double)item_.getCurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)current_limitLo, (double)item_.getCurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)drivefrequency_warnHi, (double)item_.getDrivefrequency_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)drivefrequency_warnLo, (double)item_.getDrivefrequency_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)drivefrequency_limitHi, (double)item_.getDrivefrequency_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)drivefrequency_limitLo, (double)item_.getDrivefrequency_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)power_warnHi, (double)item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)power_warnLo, (double)item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)power_limitHi, (double)item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)power_limitLo, (double)item_.getPower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumptemperature_warnHi, (double)item_.getPumptemperature_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumptemperature_warnLo, (double)item_.getPumptemperature_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pumptemperature_limitHi, (double)item_.getPumptemperature_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pumptemperature_limitLo, (double)item_.getPumptemperature_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rpm_warnHi, (double)item_.getRpm_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rpm_warnLo, (double)item_.getRpm_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rpm_limitHi, (double)item_.getRpm_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rpm_limitLo, (double)item_.getRpm_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)status_warnHi, (double)item_.getStatus_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)status_warnLo, (double)item_.getStatus_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)status_limitHi, (double)item_.getStatus_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)status_limitLo, (double)item_.getStatus_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage_warnHi, (double)item_.getVoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage_warnLo, (double)item_.getVoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage_limitHi, (double)item_.getVoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage_limitLo, (double)item_.getVoltage_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_VQMonitor_CryoSettingsAppliedEvent() throws Exception {
        int priority = 197;
        int version = 105;
        int busAddr = 46;
        String devcId = "i";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VQMonitor_CryoSettingsAppliedEvent(priority, version, busAddr, devcId));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VQMonitor_CryoSettingsAppliedEvent));
        Vacuum_VQMonitor_CryoSettingsAppliedEvent item_ = (Vacuum_VQMonitor_CryoSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveVacuum_VQMonitor_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 217;
        int version = 536;
        double vqmpressure_warnHi = 0.5524739623069763;
        double vqmpressure_warnLo = 0.17146915197372437;
        double vqmpressure_limitHi = 0.312854528427124;
        double vqmpressure_limitLo = 0.6501095294952393;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VQMonitor_LimitsSettingsAppliedEvent(priority, version, vqmpressure_warnHi, vqmpressure_warnLo, vqmpressure_limitHi, vqmpressure_limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VQMonitor_LimitsSettingsAppliedEvent));
        Vacuum_VQMonitor_LimitsSettingsAppliedEvent item_ = (Vacuum_VQMonitor_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)vqmpressure_warnHi, (double)item_.getVqmpressure_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vqmpressure_warnLo, (double)item_.getVqmpressure_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vqmpressure_limitHi, (double)item_.getVqmpressure_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vqmpressure_limitLo, (double)item_.getVqmpressure_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_VacPluto_DeviceSettingsAppliedEvent() throws Exception {
        int priority = 647;
        int version = 461;
        String node = "";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VacPluto_DeviceSettingsAppliedEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VacPluto_DeviceSettingsAppliedEvent));
        Vacuum_VacPluto_DeviceSettingsAppliedEvent item_ = (Vacuum_VacPluto_DeviceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_BFR_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 277;
        int version = 806;
        double clean_5_24V_I_warnHi = 0.4632687568664551;
        double clean_5_24V_I_warnLo = 0.9889718294143677;
        double clean_5_24V_I_limitHi = 0.019225597381591797;
        double clean_5_24V_I_limitLo = 0.7258667349815369;
        double dirty_24V_I_warnHi = 0.16032713651657104;
        double dirty_24V_I_warnLo = 0.747619f;
        double dirty_24V_I_limitHi = 0.5122162699699402;
        double dirty_24V_I_limitLo = 0.9605627059936523;
        double dirty_28V_I_warnHi = 0.487312376499176;
        double dirty_28V_I_warnLo = 0.576705813407898;
        double dirty_28V_I_limitHi = 0.13985759019851685;
        double dirty_28V_I_limitLo = 0.6057502627372742;
        double dirty_48V_I_warnHi = 0.9010071754455566;
        double dirty_48V_I_warnLo = 0.9271302223205566;
        double dirty_48V_I_limitHi = 0.7254574298858643;
        double dirty_48V_I_limitLo = 0.7387614846229553;
        double heater_I_warnHi = 0.7340636253356934;
        double heater_I_warnLo = 0.6733422875404358;
        double heater_I_limitHi = 0.912837028503418;
        double heater_I_limitLo = 0.7502734661102295;
        double protection_I_warnHi = 0.3962177038192749;
        double protection_I_warnLo = 0.8504967093467712;
        double protection_I_limitHi = 0.6118409037590027;
        double protection_I_limitLo = 0.6346777081489563;
        double rebps_0_warnHi = 0.6007689237594604;
        double rebps_0_warnLo = 0.3154820203781128;
        double rebps_0_limitHi = 0.6184857487678528;
        double rebps_0_limitLo = 0.3816053867340088;
        double sensor_PWS_17_I_warnHi = 0.5990188121795654;
        double sensor_PWS_17_I_warnLo = 0.7066761255264282;
        double sensor_PWS_17_I_limitHi = 0.7915622591972351;
        double sensor_PWS_17_I_limitLo = 0.9401387572288513;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_BFR_LimitsSettingsAppliedEvent(priority, version, clean_5_24V_I_warnHi, clean_5_24V_I_warnLo, clean_5_24V_I_limitHi, clean_5_24V_I_limitLo, dirty_24V_I_warnHi, dirty_24V_I_warnLo, dirty_24V_I_limitHi, dirty_24V_I_limitLo, dirty_28V_I_warnHi, dirty_28V_I_warnLo, dirty_28V_I_limitHi, dirty_28V_I_limitLo, dirty_48V_I_warnHi, dirty_48V_I_warnLo, dirty_48V_I_limitHi, dirty_48V_I_limitLo, heater_I_warnHi, heater_I_warnLo, heater_I_limitHi, heater_I_limitLo, protection_I_warnHi, protection_I_warnLo, protection_I_limitHi, protection_I_limitLo, rebps_0_warnHi, rebps_0_warnLo, rebps_0_limitHi, rebps_0_limitLo, sensor_PWS_17_I_warnHi, sensor_PWS_17_I_warnLo, sensor_PWS_17_I_limitHi, sensor_PWS_17_I_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFR_LimitsSettingsAppliedEvent));
        Quadbox_BFR_LimitsSettingsAppliedEvent item_ = (Quadbox_BFR_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)clean_5_24V_I_warnHi, (double)item_.getClean_5_24V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_warnLo, (double)item_.getClean_5_24V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_limitHi, (double)item_.getClean_5_24V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_limitLo, (double)item_.getClean_5_24V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_warnHi, (double)item_.getDirty_24V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_warnLo, (double)item_.getDirty_24V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_limitHi, (double)item_.getDirty_24V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_limitLo, (double)item_.getDirty_24V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_warnHi, (double)item_.getDirty_28V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_warnLo, (double)item_.getDirty_28V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_limitHi, (double)item_.getDirty_28V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_limitLo, (double)item_.getDirty_28V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_warnHi, (double)item_.getDirty_48V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_warnLo, (double)item_.getDirty_48V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_limitHi, (double)item_.getDirty_48V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_limitLo, (double)item_.getDirty_48V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_warnHi, (double)item_.getHeater_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_warnLo, (double)item_.getHeater_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_limitHi, (double)item_.getHeater_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_limitLo, (double)item_.getHeater_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_warnHi, (double)item_.getProtection_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_warnLo, (double)item_.getProtection_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_limitHi, (double)item_.getProtection_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_limitLo, (double)item_.getProtection_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_warnHi, (double)item_.getRebps_0_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_warnLo, (double)item_.getRebps_0_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_limitHi, (double)item_.getRebps_0_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_limitLo, (double)item_.getRebps_0_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)sensor_PWS_17_I_warnHi, (double)item_.getSensor_PWS_17_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)sensor_PWS_17_I_warnLo, (double)item_.getSensor_PWS_17_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)sensor_PWS_17_I_limitHi, (double)item_.getSensor_PWS_17_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)sensor_PWS_17_I_limitLo, (double)item_.getSensor_PWS_17_I_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_BFR_QuadboxSettingsAppliedEvent() throws Exception {
        int priority = 719;
        int version = 98;
        int node = 484;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_BFR_QuadboxSettingsAppliedEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFR_QuadboxSettingsAppliedEvent));
        Quadbox_BFR_QuadboxSettingsAppliedEvent item_ = (Quadbox_BFR_QuadboxSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VC_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 102;
        int version = 647;
        double board_T_warnHi = 0.5723358392715454;
        double board_T_warnLo = 0.48923712968826294;
        double board_T_limitHi = 0.09669744968414307;
        double board_T_limitLo = 0.512495f;
        double body_Purge_I_warnHi = 0.014815092086791992;
        double body_Purge_I_warnLo = 0.11774694919586182;
        double body_Purge_I_limitHi = 0.7637425661087036;
        double body_Purge_I_limitLo = 0.0013309121131896973;
        double body_Purge_V_warnHi = 0.1103748083114624;
        double body_Purge_V_warnLo = 0.7935634851455688;
        double body_Purge_V_limitHi = 0.695536732673645;
        double body_Purge_V_limitLo = 0.5241841077804565;
        double bpu_Maq20_I_warnHi = 0.8185601234436035;
        double bpu_Maq20_I_warnLo = 0.02027106285095215;
        double bpu_Maq20_I_limitHi = 0.8648861050605774;
        double bpu_Maq20_I_limitLo = 0.86362f;
        double bpu_Maq20_V_warnHi = 0.4383272f;
        double bpu_Maq20_V_warnLo = 0.7694481611251831;
        double bpu_Maq20_V_limitHi = 0.20988517999649048;
        double bpu_Maq20_V_limitLo = 0.28067994117736816;
        double fpga_T_warnHi = 0.16905808448791504;
        double fpga_T_warnLo = 0.83838f;
        double fpga_T_limitHi = 0.23789077997207642;
        double fpga_T_limitLo = 0.1053884f;
        double fes_Shu_HCU_I_warnHi = 0.9961449503898621;
        double fes_Shu_HCU_I_warnLo = 0.697284996509552;
        double fes_Shu_HCU_I_limitHi = 0.0728883147239685;
        double fes_Shu_HCU_I_limitLo = 0.976794421672821;
        double fes_Shu_HCU_V_warnHi = 0.4362572431564331;
        double fes_Shu_HCU_V_warnLo = 0.1906307339668274;
        double fes_Shu_HCU_V_limitHi = 0.5290064215660095;
        double fes_Shu_HCU_V_limitLo = 0.8240458965301514;
        double gauges_I_warnHi = 0.6852403879165649;
        double gauges_I_warnLo = 0.43380147218704224;
        double gauges_I_limitHi = 0.6640772223472595;
        double gauges_I_limitLo = 0.5545397996902466;
        double gauges_V_warnHi = 0.3085957169532776;
        double gauges_V_warnLo = 0.9116076231002808;
        double gauges_V_limitHi = 0.2826339602470398;
        double gauges_V_limitLo = 0.2424364686012268;
        double ion_Pumps_I_warnHi = 0.8993031978607178;
        double ion_Pumps_I_warnLo = 0.389864444732666;
        double ion_Pumps_I_limitHi = 0.87402f;
        double ion_Pumps_I_limitLo = 0.24330562353134155;
        double ion_Pumps_V_warnHi = 0.5271173715591431;
        double ion_Pumps_V_warnLo = 0.8121272325515747;
        double ion_Pumps_V_limitHi = 0.7979332804679871;
        double ion_Pumps_V_limitLo = 0.3415534496307373;
        double j10_I_warnHi = 0.3222883939743042;
        double j10_I_warnLo = 0.9028640389442444;
        double j10_I_limitHi = 0.17943823337554932;
        double j10_I_limitLo = 0.6503531336784363;
        double j10_V_warnHi = 0.00792855f;
        double j10_V_warnLo = 0.03374302387237549;
        double j10_V_limitHi = 0.9140632152557373;
        double j10_V_limitLo = 0.3034737f;
        double j11_I_warnHi = 0.5301044583320618;
        double j11_I_warnLo = 0.8447704315185547;
        double j11_I_limitHi = 0.5800148248672485;
        double j11_I_limitLo = 0.9197233319282532;
        double j11_V_warnHi = 0.3724360466003418;
        double j11_V_warnLo = 0.7258525490760803;
        double j11_V_limitHi = 0.5308462977409363;
        double j11_V_limitLo = 0.689347505569458;
        double j12_I_warnHi = 0.4999144673347473;
        double j12_I_warnLo = 0.15168523788452148;
        double j12_I_limitHi = 0.3233150839805603;
        double j12_I_limitLo = 0.6739442944526672;
        double j12_V_warnHi = 0.8003124594688416;
        double j12_V_warnLo = 0.8840603828430176;
        double j12_V_limitHi = 0.1999720335006714;
        double j12_V_limitLo = 0.3641918897628784;
        double j6_I_warnHi = 0.1045953f;
        double j6_I_warnLo = 0.586685299873352;
        double j6_I_limitHi = 0.07568937540054321;
        double j6_I_limitLo = 0.6804636716842651;
        double j6_V_warnHi = 0.4218956232070923;
        double j6_V_warnLo = 0.5800520777702332;
        double j6_V_limitHi = 0.306423f;
        double j6_V_limitLo = 0.7984023094177246;
        double j7_I_warnHi = 0.549782395362854;
        double j7_I_warnLo = 0.45498377084732056;
        double j7_I_limitHi = 0.08471924066543579;
        double j7_I_limitLo = 0.4435202479362488;
        double j7_V_warnHi = 0.1747344732284546;
        double j7_V_warnLo = 0.4860857129096985;
        double j7_V_limitHi = 0.20062655210494995;
        double j7_V_limitLo = 0.5253089070320129;
        double j9_I_warnHi = 0.49706172943115234;
        double j9_I_warnLo = 0.1789099f;
        double j9_I_limitHi = 0.922715425491333;
        double j9_I_limitLo = 0.21220701932907104;
        double j9_V_warnHi = 0.16325223445892334;
        double j9_V_warnLo = 0.5513094067573547;
        double j9_V_limitHi = 0.13890838623046875;
        double j9_V_limitLo = 0.21476882696151733;
        double main_I_warnHi = 0.3092518448829651;
        double main_I_warnLo = 0.6099345684051514;
        double main_I_limitHi = 0.600970983505249;
        double main_I_limitLo = 0.21676874160766602;
        double main_T_warnHi = 0.08100646734237671;
        double main_T_warnLo = 0.9224645495414734;
        double main_T_limitHi = 0.04314148426055908;
        double main_T_limitLo = 0.03470128774642944;
        double main_V_warnHi = 0.45235252380371094;
        double main_V_warnLo = 0.7059468626976013;
        double main_V_limitHi = 0.2009183168411255;
        double main_V_limitLo = 0.29771554470062256;
        double pwr_Cry_HCU_I_warnHi = 0.1817813515663147;
        double pwr_Cry_HCU_I_warnLo = 0.7181359529495239;
        double pwr_Cry_HCU_I_limitHi = 0.9000556468963623;
        double pwr_Cry_HCU_I_limitLo = 0.7156334519386292;
        double pwr_Cry_HCU_V_warnHi = 0.5936198234558105;
        double pwr_Cry_HCU_V_warnLo = 0.7342118620872498;
        double pwr_Cry_HCU_V_limitHi = 0.6810342669487;
        double pwr_Cry_HCU_V_limitLo = 0.476121723651886;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VC_LimitsSettingsAppliedEvent(priority, version, board_T_warnHi, board_T_warnLo, board_T_limitHi, board_T_limitLo, body_Purge_I_warnHi, body_Purge_I_warnLo, body_Purge_I_limitHi, body_Purge_I_limitLo, body_Purge_V_warnHi, body_Purge_V_warnLo, body_Purge_V_limitHi, body_Purge_V_limitLo, bpu_Maq20_I_warnHi, bpu_Maq20_I_warnLo, bpu_Maq20_I_limitHi, bpu_Maq20_I_limitLo, bpu_Maq20_V_warnHi, bpu_Maq20_V_warnLo, bpu_Maq20_V_limitHi, bpu_Maq20_V_limitLo, fpga_T_warnHi, fpga_T_warnLo, fpga_T_limitHi, fpga_T_limitLo, fes_Shu_HCU_I_warnHi, fes_Shu_HCU_I_warnLo, fes_Shu_HCU_I_limitHi, fes_Shu_HCU_I_limitLo, fes_Shu_HCU_V_warnHi, fes_Shu_HCU_V_warnLo, fes_Shu_HCU_V_limitHi, fes_Shu_HCU_V_limitLo, gauges_I_warnHi, gauges_I_warnLo, gauges_I_limitHi, gauges_I_limitLo, gauges_V_warnHi, gauges_V_warnLo, gauges_V_limitHi, gauges_V_limitLo, ion_Pumps_I_warnHi, ion_Pumps_I_warnLo, ion_Pumps_I_limitHi, ion_Pumps_I_limitLo, ion_Pumps_V_warnHi, ion_Pumps_V_warnLo, ion_Pumps_V_limitHi, ion_Pumps_V_limitLo, j10_I_warnHi, j10_I_warnLo, j10_I_limitHi, j10_I_limitLo, j10_V_warnHi, j10_V_warnLo, j10_V_limitHi, j10_V_limitLo, j11_I_warnHi, j11_I_warnLo, j11_I_limitHi, j11_I_limitLo, j11_V_warnHi, j11_V_warnLo, j11_V_limitHi, j11_V_limitLo, j12_I_warnHi, j12_I_warnLo, j12_I_limitHi, j12_I_limitLo, j12_V_warnHi, j12_V_warnLo, j12_V_limitHi, j12_V_limitLo, j6_I_warnHi, j6_I_warnLo, j6_I_limitHi, j6_I_limitLo, j6_V_warnHi, j6_V_warnLo, j6_V_limitHi, j6_V_limitLo, j7_I_warnHi, j7_I_warnLo, j7_I_limitHi, j7_I_limitLo, j7_V_warnHi, j7_V_warnLo, j7_V_limitHi, j7_V_limitLo, j9_I_warnHi, j9_I_warnLo, j9_I_limitHi, j9_I_limitLo, j9_V_warnHi, j9_V_warnLo, j9_V_limitHi, j9_V_limitLo, main_I_warnHi, main_I_warnLo, main_I_limitHi, main_I_limitLo, main_T_warnHi, main_T_warnLo, main_T_limitHi, main_T_limitLo, main_V_warnHi, main_V_warnLo, main_V_limitHi, main_V_limitLo, pwr_Cry_HCU_I_warnHi, pwr_Cry_HCU_I_warnLo, pwr_Cry_HCU_I_limitHi, pwr_Cry_HCU_I_limitLo, pwr_Cry_HCU_V_warnHi, pwr_Cry_HCU_V_warnLo, pwr_Cry_HCU_V_limitHi, pwr_Cry_HCU_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VC_LimitsSettingsAppliedEvent));
        Quadbox_PDU_24VC_LimitsSettingsAppliedEvent item_ = (Quadbox_PDU_24VC_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)board_T_warnHi, (double)item_.getBoard_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_warnLo, (double)item_.getBoard_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitHi, (double)item_.getBoard_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitLo, (double)item_.getBoard_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_warnHi, (double)item_.getBody_Purge_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_warnLo, (double)item_.getBody_Purge_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_limitHi, (double)item_.getBody_Purge_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_limitLo, (double)item_.getBody_Purge_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_warnHi, (double)item_.getBody_Purge_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_warnLo, (double)item_.getBody_Purge_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_limitHi, (double)item_.getBody_Purge_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_limitLo, (double)item_.getBody_Purge_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_warnHi, (double)item_.getBpu_Maq20_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_warnLo, (double)item_.getBpu_Maq20_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_limitHi, (double)item_.getBpu_Maq20_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_limitLo, (double)item_.getBpu_Maq20_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_warnHi, (double)item_.getBpu_Maq20_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_warnLo, (double)item_.getBpu_Maq20_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_limitHi, (double)item_.getBpu_Maq20_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_limitLo, (double)item_.getBpu_Maq20_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnHi, (double)item_.getFpga_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnLo, (double)item_.getFpga_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitHi, (double)item_.getFpga_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitLo, (double)item_.getFpga_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_warnHi, (double)item_.getFes_Shu_HCU_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_warnLo, (double)item_.getFes_Shu_HCU_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_limitHi, (double)item_.getFes_Shu_HCU_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_limitLo, (double)item_.getFes_Shu_HCU_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_warnHi, (double)item_.getFes_Shu_HCU_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_warnLo, (double)item_.getFes_Shu_HCU_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_limitHi, (double)item_.getFes_Shu_HCU_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_limitLo, (double)item_.getFes_Shu_HCU_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_warnHi, (double)item_.getGauges_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_warnLo, (double)item_.getGauges_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_limitHi, (double)item_.getGauges_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_limitLo, (double)item_.getGauges_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_warnHi, (double)item_.getGauges_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_warnLo, (double)item_.getGauges_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_limitHi, (double)item_.getGauges_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_limitLo, (double)item_.getGauges_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_warnHi, (double)item_.getIon_Pumps_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_warnLo, (double)item_.getIon_Pumps_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_limitHi, (double)item_.getIon_Pumps_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_limitLo, (double)item_.getIon_Pumps_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_warnHi, (double)item_.getIon_Pumps_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_warnLo, (double)item_.getIon_Pumps_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_limitHi, (double)item_.getIon_Pumps_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_limitLo, (double)item_.getIon_Pumps_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j10_I_warnHi, (double)item_.getJ10_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j10_I_warnLo, (double)item_.getJ10_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j10_I_limitHi, (double)item_.getJ10_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j10_I_limitLo, (double)item_.getJ10_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j10_V_warnHi, (double)item_.getJ10_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j10_V_warnLo, (double)item_.getJ10_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j10_V_limitHi, (double)item_.getJ10_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j10_V_limitLo, (double)item_.getJ10_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_I_warnHi, (double)item_.getJ11_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_I_warnLo, (double)item_.getJ11_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_I_limitHi, (double)item_.getJ11_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_I_limitLo, (double)item_.getJ11_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_V_warnHi, (double)item_.getJ11_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_V_warnLo, (double)item_.getJ11_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_V_limitHi, (double)item_.getJ11_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j11_V_limitLo, (double)item_.getJ11_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_I_warnHi, (double)item_.getJ12_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_I_warnLo, (double)item_.getJ12_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_I_limitHi, (double)item_.getJ12_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_I_limitLo, (double)item_.getJ12_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_V_warnHi, (double)item_.getJ12_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_V_warnLo, (double)item_.getJ12_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_V_limitHi, (double)item_.getJ12_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j12_V_limitLo, (double)item_.getJ12_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_I_warnHi, (double)item_.getJ6_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_I_warnLo, (double)item_.getJ6_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_I_limitHi, (double)item_.getJ6_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_I_limitLo, (double)item_.getJ6_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_V_warnHi, (double)item_.getJ6_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_V_warnLo, (double)item_.getJ6_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_V_limitHi, (double)item_.getJ6_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j6_V_limitLo, (double)item_.getJ6_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_I_warnHi, (double)item_.getJ7_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_I_warnLo, (double)item_.getJ7_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_I_limitHi, (double)item_.getJ7_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_I_limitLo, (double)item_.getJ7_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_V_warnHi, (double)item_.getJ7_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_V_warnLo, (double)item_.getJ7_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_V_limitHi, (double)item_.getJ7_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j7_V_limitLo, (double)item_.getJ7_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_I_warnHi, (double)item_.getJ9_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_I_warnLo, (double)item_.getJ9_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_I_limitHi, (double)item_.getJ9_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_I_limitLo, (double)item_.getJ9_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_V_warnHi, (double)item_.getJ9_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_V_warnLo, (double)item_.getJ9_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_V_limitHi, (double)item_.getJ9_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)j9_V_limitLo, (double)item_.getJ9_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnHi, (double)item_.getMain_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnLo, (double)item_.getMain_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitHi, (double)item_.getMain_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitLo, (double)item_.getMain_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnHi, (double)item_.getMain_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnLo, (double)item_.getMain_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitHi, (double)item_.getMain_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitLo, (double)item_.getMain_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnHi, (double)item_.getMain_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnLo, (double)item_.getMain_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitHi, (double)item_.getMain_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitLo, (double)item_.getMain_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_warnHi, (double)item_.getPwr_Cry_HCU_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_warnLo, (double)item_.getPwr_Cry_HCU_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_limitHi, (double)item_.getPwr_Cry_HCU_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_limitLo, (double)item_.getPwr_Cry_HCU_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_warnHi, (double)item_.getPwr_Cry_HCU_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_warnLo, (double)item_.getPwr_Cry_HCU_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_limitHi, (double)item_.getPwr_Cry_HCU_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_limitLo, (double)item_.getPwr_Cry_HCU_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VC_QuadboxSettingsAppliedEvent() throws Exception {
        int priority = 216;
        int version = 327;
        int node = 892;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VC_QuadboxSettingsAppliedEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VC_QuadboxSettingsAppliedEvent));
        Quadbox_PDU_24VC_QuadboxSettingsAppliedEvent item_ = (Quadbox_PDU_24VC_QuadboxSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VD_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 616;
        int version = 11;
        double board_T_warnHi = 0.47391778230667114;
        double board_T_warnLo = 0.18728214502334595;
        double board_T_limitHi = 0.4285205602645874;
        double board_T_limitLo = 0.7102625370025635;
        double fes_I_warnHi = 0.8721213340759277;
        double fes_I_warnLo = 0.028969526290893555;
        double fes_I_limitHi = 0.025536537170410156;
        double fes_I_limitLo = 0.929409384727478;
        double fes_V_warnHi = 0.9869453310966492;
        double fes_V_warnLo = 0.020075678825378418;
        double fes_V_limitHi = 0.276092529296875;
        double fes_V_limitLo = 0.8361074328422546;
        double fpga_T_warnHi = 0.21995443105697632;
        double fpga_T_warnLo = 0.38420385122299194;
        double fpga_T_limitHi = 0.31224966049194336;
        double fpga_T_limitLo = 0.23293238878250122;
        double main_I_warnHi = 0.40147173404693604;
        double main_I_warnLo = 0.39219456911087036;
        double main_I_limitHi = 0.5753852725028992;
        double main_I_limitLo = 0.22028517723083496;
        double main_T_warnHi = 0.8018012642860413;
        double main_T_warnLo = 0.36188453435897827;
        double main_T_limitHi = 0.3241550326347351;
        double main_T_limitLo = 0.9119870662689209;
        double main_V_warnHi = 0.8102445602416992;
        double main_V_warnLo = 0.24977731704711914;
        double main_V_limitHi = 0.9065913558006287;
        double main_V_limitLo = 0.813798725605011;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VD_LimitsSettingsAppliedEvent(priority, version, board_T_warnHi, board_T_warnLo, board_T_limitHi, board_T_limitLo, fes_I_warnHi, fes_I_warnLo, fes_I_limitHi, fes_I_limitLo, fes_V_warnHi, fes_V_warnLo, fes_V_limitHi, fes_V_limitLo, fpga_T_warnHi, fpga_T_warnLo, fpga_T_limitHi, fpga_T_limitLo, main_I_warnHi, main_I_warnLo, main_I_limitHi, main_I_limitLo, main_T_warnHi, main_T_warnLo, main_T_limitHi, main_T_limitLo, main_V_warnHi, main_V_warnLo, main_V_limitHi, main_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VD_LimitsSettingsAppliedEvent));
        Quadbox_PDU_24VD_LimitsSettingsAppliedEvent item_ = (Quadbox_PDU_24VD_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)board_T_warnHi, (double)item_.getBoard_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_warnLo, (double)item_.getBoard_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitHi, (double)item_.getBoard_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitLo, (double)item_.getBoard_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_I_warnHi, (double)item_.getFes_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_I_warnLo, (double)item_.getFes_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_I_limitHi, (double)item_.getFes_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_I_limitLo, (double)item_.getFes_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_V_warnHi, (double)item_.getFes_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_V_warnLo, (double)item_.getFes_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_V_limitHi, (double)item_.getFes_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_V_limitLo, (double)item_.getFes_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnHi, (double)item_.getFpga_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnLo, (double)item_.getFpga_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitHi, (double)item_.getFpga_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitLo, (double)item_.getFpga_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnHi, (double)item_.getMain_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnLo, (double)item_.getMain_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitHi, (double)item_.getMain_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitLo, (double)item_.getMain_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnHi, (double)item_.getMain_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnLo, (double)item_.getMain_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitHi, (double)item_.getMain_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitLo, (double)item_.getMain_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnHi, (double)item_.getMain_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnLo, (double)item_.getMain_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitHi, (double)item_.getMain_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitLo, (double)item_.getMain_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VD_QuadboxSettingsAppliedEvent() throws Exception {
        int priority = 345;
        int version = 353;
        int node = 335;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VD_QuadboxSettingsAppliedEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VD_QuadboxSettingsAppliedEvent));
        Quadbox_PDU_24VD_QuadboxSettingsAppliedEvent item_ = (Quadbox_PDU_24VD_QuadboxSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_48V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 998;
        int version = 981;
        double board_T_warnHi = 0.7224611043930054;
        double board_T_warnLo = 0.995449960231781;
        double board_T_limitHi = 0.8556565046310425;
        double board_T_limitLo = 0.3343989849090576;
        double cryotel0_I_warnHi = 0.16390752792358398;
        double cryotel0_I_warnLo = 0.4870567321777344;
        double cryotel0_I_limitHi = 0.8007899522781372;
        double cryotel0_I_limitLo = 0.5389488339424133;
        double cryotel0_V_warnHi = 0.21893548965454102;
        double cryotel0_V_warnLo = 0.8761265277862549;
        double cryotel0_V_limitHi = 0.46057581901550293;
        double cryotel0_V_limitLo = 0.9353818297386169;
        double cryotel1_I_warnHi = 0.19551920890808105;
        double cryotel1_I_warnLo = 0.39240384101867676;
        double cryotel1_I_limitHi = 0.0318138f;
        double cryotel1_I_limitLo = 0.6826966404914856;
        double cryotel1_V_warnHi = 0.7906205654144287;
        double cryotel1_V_warnLo = 0.2049654722213745;
        double cryotel1_V_limitHi = 0.7586924433708191;
        double cryotel1_V_limitLo = 0.6705963611602783;
        double cryotel2_I_warnHi = 0.6947575211524963;
        double cryotel2_I_warnLo = 0.250831663608551;
        double cryotel2_I_limitHi = 0.21544432640075684;
        double cryotel2_I_limitLo = 0.47625845670700073;
        double cryotel2_V_warnHi = 0.14887607097625732;
        double cryotel2_V_warnLo = 0.4687969f;
        double cryotel2_V_limitHi = 0.6955842971801758;
        double cryotel2_V_limitLo = 0.0765959620475769;
        double fpga_T_warnHi = 0.511004f;
        double fpga_T_warnLo = 0.013155996799468994;
        double fpga_T_limitHi = 0.389645516872406;
        double fpga_T_limitLo = 0.3244718313217163;
        double main_I_warnHi = 0.6400936245918274;
        double main_I_warnLo = 0.4965214133262634;
        double main_I_limitHi = 0.5901732444763184;
        double main_I_limitLo = 0.797491f;
        double main_T_warnHi = 0.8905333876609802;
        double main_T_warnLo = 0.7440076470375061;
        double main_T_limitHi = 0.04605609178543091;
        double main_T_limitLo = 0.7829034328460693;
        double main_V_warnHi = 0.5582185387611389;
        double main_V_warnLo = 0.3789821267127991;
        double main_V_limitHi = 0.9435774087905884;
        double main_V_limitLo = 0.23216503858566284;
        double reb_BULK_I_warnHi = 0.5061484575271606;
        double reb_BULK_I_warnLo = 0.1402691f;
        double reb_BULK_I_limitHi = 0.04249382019042969;
        double reb_BULK_I_limitLo = 0.37979036569595337;
        double reb_BULK_V_warnHi = 0.40569454431533813;
        double reb_BULK_V_warnLo = 0.6296751499176025;
        double reb_BULK_V_limitHi = 0.7937451601028442;
        double reb_BULK_V_limitLo = 0.014896035194396973;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_48V_LimitsSettingsAppliedEvent(priority, version, board_T_warnHi, board_T_warnLo, board_T_limitHi, board_T_limitLo, cryotel0_I_warnHi, cryotel0_I_warnLo, cryotel0_I_limitHi, cryotel0_I_limitLo, cryotel0_V_warnHi, cryotel0_V_warnLo, cryotel0_V_limitHi, cryotel0_V_limitLo, cryotel1_I_warnHi, cryotel1_I_warnLo, cryotel1_I_limitHi, cryotel1_I_limitLo, cryotel1_V_warnHi, cryotel1_V_warnLo, cryotel1_V_limitHi, cryotel1_V_limitLo, cryotel2_I_warnHi, cryotel2_I_warnLo, cryotel2_I_limitHi, cryotel2_I_limitLo, cryotel2_V_warnHi, cryotel2_V_warnLo, cryotel2_V_limitHi, cryotel2_V_limitLo, fpga_T_warnHi, fpga_T_warnLo, fpga_T_limitHi, fpga_T_limitLo, main_I_warnHi, main_I_warnLo, main_I_limitHi, main_I_limitLo, main_T_warnHi, main_T_warnLo, main_T_limitHi, main_T_limitLo, main_V_warnHi, main_V_warnLo, main_V_limitHi, main_V_limitLo, reb_BULK_I_warnHi, reb_BULK_I_warnLo, reb_BULK_I_limitHi, reb_BULK_I_limitLo, reb_BULK_V_warnHi, reb_BULK_V_warnLo, reb_BULK_V_limitHi, reb_BULK_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48V_LimitsSettingsAppliedEvent));
        Quadbox_PDU_48V_LimitsSettingsAppliedEvent item_ = (Quadbox_PDU_48V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)board_T_warnHi, (double)item_.getBoard_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_warnLo, (double)item_.getBoard_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitHi, (double)item_.getBoard_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)board_T_limitLo, (double)item_.getBoard_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_I_warnHi, (double)item_.getCryotel0_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_I_warnLo, (double)item_.getCryotel0_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_I_limitHi, (double)item_.getCryotel0_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_I_limitLo, (double)item_.getCryotel0_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_V_warnHi, (double)item_.getCryotel0_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_V_warnLo, (double)item_.getCryotel0_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_V_limitHi, (double)item_.getCryotel0_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel0_V_limitLo, (double)item_.getCryotel0_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_I_warnHi, (double)item_.getCryotel1_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_I_warnLo, (double)item_.getCryotel1_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_I_limitHi, (double)item_.getCryotel1_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_I_limitLo, (double)item_.getCryotel1_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_V_warnHi, (double)item_.getCryotel1_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_V_warnLo, (double)item_.getCryotel1_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_V_limitHi, (double)item_.getCryotel1_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel1_V_limitLo, (double)item_.getCryotel1_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_I_warnHi, (double)item_.getCryotel2_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_I_warnLo, (double)item_.getCryotel2_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_I_limitHi, (double)item_.getCryotel2_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_I_limitLo, (double)item_.getCryotel2_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_V_warnHi, (double)item_.getCryotel2_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_V_warnLo, (double)item_.getCryotel2_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_V_limitHi, (double)item_.getCryotel2_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryotel2_V_limitLo, (double)item_.getCryotel2_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnHi, (double)item_.getFpga_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_warnLo, (double)item_.getFpga_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitHi, (double)item_.getFpga_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fpga_T_limitLo, (double)item_.getFpga_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnHi, (double)item_.getMain_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_warnLo, (double)item_.getMain_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitHi, (double)item_.getMain_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_I_limitLo, (double)item_.getMain_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnHi, (double)item_.getMain_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_warnLo, (double)item_.getMain_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitHi, (double)item_.getMain_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_T_limitLo, (double)item_.getMain_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnHi, (double)item_.getMain_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_warnLo, (double)item_.getMain_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitHi, (double)item_.getMain_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)main_V_limitLo, (double)item_.getMain_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_I_warnHi, (double)item_.getReb_BULK_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_I_warnLo, (double)item_.getReb_BULK_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_I_limitHi, (double)item_.getReb_BULK_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_I_limitLo, (double)item_.getReb_BULK_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_V_warnHi, (double)item_.getReb_BULK_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_V_warnLo, (double)item_.getReb_BULK_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_V_limitHi, (double)item_.getReb_BULK_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)reb_BULK_V_limitLo, (double)item_.getReb_BULK_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48V_QuadboxSettingsAppliedEvent() throws Exception {
        int priority = 763;
        int version = 674;
        int node = 338;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_48V_QuadboxSettingsAppliedEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48V_QuadboxSettingsAppliedEvent));
        Quadbox_PDU_48V_QuadboxSettingsAppliedEvent item_ = (Quadbox_PDU_48V_QuadboxSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_5V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 116;
        int version = 533;
        double otm_3_A_I_warnHi = 0.1776370406150818;
        double otm_3_A_I_warnLo = 0.11870795488357544;
        double otm_3_A_I_limitHi = 0.24811553955078125;
        double otm_3_A_I_limitLo = 0.058002352714538574;
        double otm_3_A_V_warnHi = 0.5878888368606567;
        double otm_3_A_V_warnLo = 0.34279865026474;
        double otm_3_A_V_limitHi = 0.446674644947052;
        double otm_3_A_V_limitLo = 0.6790383458137512;
        double otm_3_B_I_warnHi = 0.5738877654075623;
        double otm_3_B_I_warnLo = 0.4055485725402832;
        double otm_3_B_I_limitHi = 0.8601377010345459;
        double otm_3_B_I_limitLo = 0.21220511198043823;
        double otm_3_B_V_warnHi = 0.9195892214775085;
        double otm_3_B_V_warnLo = 0.9851754307746887;
        double otm_3_B_V_limitHi = 0.4957928f;
        double otm_3_B_V_limitLo = 0.7163221836090088;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_5V_LimitsSettingsAppliedEvent(priority, version, otm_3_A_I_warnHi, otm_3_A_I_warnLo, otm_3_A_I_limitHi, otm_3_A_I_limitLo, otm_3_A_V_warnHi, otm_3_A_V_warnLo, otm_3_A_V_limitHi, otm_3_A_V_limitLo, otm_3_B_I_warnHi, otm_3_B_I_warnLo, otm_3_B_I_limitHi, otm_3_B_I_limitLo, otm_3_B_V_warnHi, otm_3_B_V_warnLo, otm_3_B_V_limitHi, otm_3_B_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5V_LimitsSettingsAppliedEvent));
        Quadbox_PDU_5V_LimitsSettingsAppliedEvent item_ = (Quadbox_PDU_5V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)otm_3_A_I_warnHi, (double)item_.getOtm_3_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_warnLo, (double)item_.getOtm_3_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_limitHi, (double)item_.getOtm_3_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_limitLo, (double)item_.getOtm_3_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_warnHi, (double)item_.getOtm_3_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_warnLo, (double)item_.getOtm_3_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_limitHi, (double)item_.getOtm_3_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_limitLo, (double)item_.getOtm_3_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_warnHi, (double)item_.getOtm_3_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_warnLo, (double)item_.getOtm_3_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_limitHi, (double)item_.getOtm_3_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_limitLo, (double)item_.getOtm_3_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_warnHi, (double)item_.getOtm_3_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_warnLo, (double)item_.getOtm_3_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_limitHi, (double)item_.getOtm_3_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_limitLo, (double)item_.getOtm_3_B_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5V_QuadboxSettingsAppliedEvent() throws Exception {
        int priority = 401;
        int version = 988;
        int node = 913;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_5V_QuadboxSettingsAppliedEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5V_QuadboxSettingsAppliedEvent));
        Quadbox_PDU_5V_QuadboxSettingsAppliedEvent item_ = (Quadbox_PDU_5V_QuadboxSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PeriodicTasksSettingsAppliedEvent() throws Exception {
        int priority = 677;
        int version = 25;
        int schedulers_default_nTasks = 558;
        int schedulers_default_nThreads = 556;
        int schedulers_monitor_update_publish_scheduler_nTasks = 975;
        int schedulers_monitor_update_publish_scheduler_nThreads = 71;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PeriodicTasksSettingsAppliedEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PeriodicTasksSettingsAppliedEvent));
        Quadbox_PeriodicTasksSettingsAppliedEvent item_ = (Quadbox_PeriodicTasksSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveQuadbox_PeriodicTasks_timersSettingsAppliedEvent() throws Exception {
        int priority = 516;
        int version = 64;
        long agentmonitorservice_taskPeriodMillis = 698L;
        long heartbeat_taskPeriodMillis = 919L;
        long monitor_check_taskPeriodMillis = 206L;
        long monitor_publish_taskPeriodMillis = 406L;
        long monitor_update_taskPeriodMillis = 819L;
        long runtimeinfo_taskPeriodMillis = 873L;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PeriodicTasks_timersSettingsAppliedEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PeriodicTasks_timersSettingsAppliedEvent));
        Quadbox_PeriodicTasks_timersSettingsAppliedEvent item_ = (Quadbox_PeriodicTasks_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PS_QuadboxSettingsAppliedEvent() throws Exception {
        int priority = 376;
        int version = 751;
        int node = 110;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_REB_Bulk_PS_QuadboxSettingsAppliedEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PS_QuadboxSettingsAppliedEvent));
        Quadbox_REB_Bulk_PS_QuadboxSettingsAppliedEvent item_ = (Quadbox_REB_Bulk_PS_QuadboxSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_HardwareIdSettingsAppliedEvent() throws Exception {
        int priority = 414;
        int version = 395;
        String location = "n";
        String manSerNum = "b";
        String name = "f";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_HardwareIdSettingsAppliedEvent(priority, version, location, manSerNum, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_HardwareIdSettingsAppliedEvent));
        Focal_plane_Ccd_HardwareIdSettingsAppliedEvent item_ = (Focal_plane_Ccd_HardwareIdSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)manSerNum, (Object)item_.getManSerNum());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 70;
        int version = 562;
        double[] gdv_warnHi = TestHelper.generateDoubleArray((int)9, (int)130267376);
        double[] gdv_warnLo = TestHelper.generateDoubleArray((int)9, (int)-974864012);
        double[] gdv_limitHi = TestHelper.generateDoubleArray((int)9, (int)989182381);
        double[] gdv_limitLo = TestHelper.generateDoubleArray((int)9, (int)-1685206767);
        String location = "";
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)9, (int)296273044);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)9, (int)587915650);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)9, (int)1996849627);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)9, (int)1402205791);
        double[] ogv_warnHi = TestHelper.generateDoubleArray((int)9, (int)-1385478455);
        double[] ogv_warnLo = TestHelper.generateDoubleArray((int)9, (int)313240268);
        double[] ogv_limitHi = TestHelper.generateDoubleArray((int)9, (int)1227710171);
        double[] ogv_limitLo = TestHelper.generateDoubleArray((int)9, (int)829734763);
        double[] rdv_warnHi = TestHelper.generateDoubleArray((int)9, (int)181191191);
        double[] rdv_warnLo = TestHelper.generateDoubleArray((int)9, (int)897513894);
        double[] rdv_limitHi = TestHelper.generateDoubleArray((int)9, (int)1423382639);
        double[] rdv_limitLo = TestHelper.generateDoubleArray((int)9, (int)-586262842);
        double[] temp_warnHi = TestHelper.generateDoubleArray((int)9, (int)-915609642);
        double[] temp_warnLo = TestHelper.generateDoubleArray((int)9, (int)181013538);
        double[] temp_limitHi = TestHelper.generateDoubleArray((int)9, (int)-85763947);
        double[] temp_limitLo = TestHelper.generateDoubleArray((int)9, (int)56708417);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_LimitsSettingsAppliedEvent(priority, version, gdv_warnHi, gdv_warnLo, gdv_limitHi, gdv_limitLo, location, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, ogv_warnHi, ogv_warnLo, ogv_limitHi, ogv_limitLo, rdv_warnHi, rdv_warnLo, rdv_limitHi, rdv_limitLo, temp_warnHi, temp_warnLo, temp_limitHi, temp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_LimitsSettingsAppliedEvent));
        Focal_plane_Ccd_LimitsSettingsAppliedEvent item_ = (Focal_plane_Ccd_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])gdv_warnHi, (double[])item_.getGdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_warnLo, (double[])item_.getGdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitHi, (double[])item_.getGdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitLo, (double[])item_.getGdv_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnHi, (double[])item_.getOgv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnLo, (double[])item_.getOgv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitHi, (double[])item_.getOgv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitLo, (double[])item_.getOgv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnHi, (double[])item_.getRdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnLo, (double[])item_.getRdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitHi, (double[])item_.getRdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitLo, (double[])item_.getRdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnHi, (double[])item_.getTemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnLo, (double[])item_.getTemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitHi, (double[])item_.getTemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitLo, (double[])item_.getTemp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_RaftsSettingsAppliedEvent() throws Exception {
        int priority = 690;
        int version = 474;
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_RaftsSettingsAppliedEvent(priority, version, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_RaftsSettingsAppliedEvent));
        Focal_plane_Ccd_RaftsSettingsAppliedEvent item_ = (Focal_plane_Ccd_RaftsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_ImageDatabaseServiceSettingsAppliedEvent() throws Exception {
        int priority = 944;
        int version = 822;
        String dbURL = "t";
        boolean enabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageDatabaseServiceSettingsAppliedEvent(priority, version, dbURL, enabled));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageDatabaseServiceSettingsAppliedEvent));
        Focal_plane_ImageDatabaseServiceSettingsAppliedEvent item_ = (Focal_plane_ImageDatabaseServiceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)enabled, (Object)item_.isEnabled());
    }

    @Test
    public void sendReceiveFocal_plane_ImageNameServiceSettingsAppliedEvent() throws Exception {
        int priority = 251;
        int version = 422;
        String controller = "k";
        String dbURL = "";
        String offset = "t";
        String source = "s";
        String timeZoneId = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageNameServiceSettingsAppliedEvent(priority, version, controller, dbURL, offset, source, timeZoneId));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageNameServiceSettingsAppliedEvent));
        Focal_plane_ImageNameServiceSettingsAppliedEvent item_ = (Focal_plane_ImageNameServiceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)controller, (Object)item_.getController());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)offset, (Object)item_.getOffset());
        Assert.assertEquals((Object)source, (Object)item_.getSource());
        Assert.assertEquals((Object)timeZoneId, (Object)item_.getTimeZoneId());
    }

    @Test
    public void sendReceiveFocal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent() throws Exception {
        int priority = 471;
        int version = 352;
        String instrument = "";
        String telescope = "";
        String testStand = "a";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent(priority, version, instrument, telescope, testStand));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent));
        Focal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent item_ = (Focal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)instrument, (Object)item_.getInstrument());
        Assert.assertEquals((Object)telescope, (Object)item_.getTelescope());
        Assert.assertEquals((Object)testStand, (Object)item_.getTestStand());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasksSettingsAppliedEvent() throws Exception {
        int priority = 883;
        int version = 809;
        int schedulers_default_nTasks = 904;
        int schedulers_default_nThreads = 39;
        int schedulers_monitor_check_scheduler_nTasks = 303;
        int schedulers_monitor_check_scheduler_nThreads = 943;
        int schedulers_monitor_update_publish_scheduler_nTasks = 800;
        int schedulers_monitor_update_publish_scheduler_nThreads = 898;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasksSettingsAppliedEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasksSettingsAppliedEvent));
        Focal_plane_PeriodicTasksSettingsAppliedEvent item_ = (Focal_plane_PeriodicTasksSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasks_timersSettingsAppliedEvent() throws Exception {
        int priority = 648;
        int version = 497;
        long agentmonitorservice_taskPeriodMillis = 676L;
        long heartbeat_taskPeriodMillis = 766L;
        long monitor_publish_taskPeriodMillis = 322L;
        long monitor_update_taskPeriodMillis = 831L;
        long runtimeinfo_taskPeriodMillis = 735L;
        long tempcontrol_R22_taskPeriodMillis = 277L;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasks_timersSettingsAppliedEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis, tempcontrol_R22_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasks_timersSettingsAppliedEvent));
        Focal_plane_PeriodicTasks_timersSettingsAppliedEvent item_ = (Focal_plane_PeriodicTasks_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R22_taskPeriodMillis, (long)item_.getTempcontrol_R22_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_HardwareIdSettingsAppliedEvent() throws Exception {
        int priority = 854;
        int version = 531;
        String location = "a";
        String name = "s";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_HardwareIdSettingsAppliedEvent(priority, version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_HardwareIdSettingsAppliedEvent));
        Focal_plane_Raft_HardwareIdSettingsAppliedEvent item_ = (Focal_plane_Raft_HardwareIdSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlSettingsAppliedEvent() throws Exception {
        int priority = 656;
        int version = 898;
        String location = "";
        double[] tempcontrol_basePower = TestHelper.generateDoubleArray((int)1, (int)1307076576);
        double[] tempcontrol_coefD = TestHelper.generateDoubleArray((int)1, (int)-1002366797);
        double[] tempcontrol_coefI = TestHelper.generateDoubleArray((int)1, (int)-942221751);
        double[] tempcontrol_coefP = TestHelper.generateDoubleArray((int)1, (int)-688532059);
        double[] tempcontrol_maxInput = TestHelper.generateDoubleArray((int)1, (int)-305037776);
        double[] tempcontrol_maxOutput = TestHelper.generateDoubleArray((int)1, (int)1318749614);
        double[] tempcontrol_minInput = TestHelper.generateDoubleArray((int)1, (int)-356844860);
        double[] tempcontrol_minOutput = TestHelper.generateDoubleArray((int)1, (int)-1821991732);
        String tempcontrol_rebs = "f";
        double[] tempcontrol_setTemp = TestHelper.generateDoubleArray((int)1, (int)1039190927);
        double[] tempcontrol_smoothTime = TestHelper.generateDoubleArray((int)1, (int)-516580648);
        String tempcontrol_tempChans = "m";
        double[] tempcontrol_timeConst = TestHelper.generateDoubleArray((int)1, (int)1183616865);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlSettingsAppliedEvent(priority, version, location, tempcontrol_basePower, tempcontrol_coefD, tempcontrol_coefI, tempcontrol_coefP, tempcontrol_maxInput, tempcontrol_maxOutput, tempcontrol_minInput, tempcontrol_minOutput, tempcontrol_rebs, tempcontrol_setTemp, tempcontrol_smoothTime, tempcontrol_tempChans, tempcontrol_timeConst));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlSettingsAppliedEvent));
        Focal_plane_Raft_RaftTempControlSettingsAppliedEvent item_ = (Focal_plane_Raft_RaftTempControlSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])tempcontrol_basePower, (double[])item_.getTempcontrol_basePower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefD, (double[])item_.getTempcontrol_coefD(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefI, (double[])item_.getTempcontrol_coefI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefP, (double[])item_.getTempcontrol_coefP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxInput, (double[])item_.getTempcontrol_maxInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxOutput, (double[])item_.getTempcontrol_maxOutput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minInput, (double[])item_.getTempcontrol_minInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minOutput, (double[])item_.getTempcontrol_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_rebs, (Object)item_.getTempcontrol_rebs());
        Assert.assertArrayEquals((double[])tempcontrol_setTemp, (double[])item_.getTempcontrol_setTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_smoothTime, (double[])item_.getTempcontrol_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_tempChans, (Object)item_.getTempcontrol_tempChans());
        Assert.assertArrayEquals((double[])tempcontrol_timeConst, (double[])item_.getTempcontrol_timeConst(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent() throws Exception {
        int priority = 206;
        int version = 31;
        String location = "";
        boolean[] tempcontrol_active = new boolean[]{true};
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent(priority, version, location, tempcontrol_active));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent));
        Focal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent item_ = (Focal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((boolean[])tempcontrol_active, (boolean[])item_.getTempcontrol_active());
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPower_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 68;
        int version = 36;
        double warnHi = 0.7229271531105042;
        double warnLo = 0.7525046467781067;
        double limitHi = 0.5276303291320801;
        double limitLo = 0.13155996799468994;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_RebTotalPower_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPower_LimitsSettingsAppliedEvent));
        Focal_plane_RebTotalPower_LimitsSettingsAppliedEvent item_ = (Focal_plane_RebTotalPower_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_HardwareIdSettingsAppliedEvent() throws Exception {
        int priority = 54;
        int version = 149;
        String location = "q";
        String name = "h";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_HardwareIdSettingsAppliedEvent(priority, version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_HardwareIdSettingsAppliedEvent));
        Focal_plane_Reb_HardwareIdSettingsAppliedEvent item_ = (Focal_plane_Reb_HardwareIdSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 673;
        int version = 383;
        double[] anai_warnHi = TestHelper.generateDoubleArray((int)3, (int)1108493183);
        double[] anai_warnLo = TestHelper.generateDoubleArray((int)3, (int)-383527811);
        double[] anai_limitHi = TestHelper.generateDoubleArray((int)3, (int)998502583);
        double[] anai_limitLo = TestHelper.generateDoubleArray((int)3, (int)-292996120);
        double[] anav_warnHi = TestHelper.generateDoubleArray((int)3, (int)1572424813);
        double[] anav_warnLo = TestHelper.generateDoubleArray((int)3, (int)1436697617);
        double[] anav_limitHi = TestHelper.generateDoubleArray((int)3, (int)222230861);
        double[] anav_limitLo = TestHelper.generateDoubleArray((int)3, (int)-425238777);
        double[] aspicl_Temp0_warnHi = TestHelper.generateDoubleArray((int)3, (int)1054739547);
        double[] aspicl_Temp0_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1762536562);
        double[] aspicl_Temp0_limitHi = TestHelper.generateDoubleArray((int)3, (int)-144604228);
        double[] aspicl_Temp0_limitLo = TestHelper.generateDoubleArray((int)3, (int)1193988161);
        double[] aspicl_Temp1_warnHi = TestHelper.generateDoubleArray((int)3, (int)1124318007);
        double[] aspicl_Temp1_warnLo = TestHelper.generateDoubleArray((int)3, (int)842356254);
        double[] aspicl_Temp1_limitHi = TestHelper.generateDoubleArray((int)3, (int)-611560128);
        double[] aspicl_Temp1_limitLo = TestHelper.generateDoubleArray((int)3, (int)109395394);
        double[] aspicl_Temp2_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1891950454);
        double[] aspicl_Temp2_warnLo = TestHelper.generateDoubleArray((int)3, (int)1503687335);
        double[] aspicl_Temp2_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1769728654);
        double[] aspicl_Temp2_limitLo = TestHelper.generateDoubleArray((int)3, (int)1416409617);
        double[] aspicu_Temp0_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1134793784);
        double[] aspicu_Temp0_warnLo = TestHelper.generateDoubleArray((int)3, (int)2128885655);
        double[] aspicu_Temp0_limitHi = TestHelper.generateDoubleArray((int)3, (int)366891193);
        double[] aspicu_Temp0_limitLo = TestHelper.generateDoubleArray((int)3, (int)531224433);
        double[] aspicu_Temp1_warnHi = TestHelper.generateDoubleArray((int)3, (int)-124404247);
        double[] aspicu_Temp1_warnLo = TestHelper.generateDoubleArray((int)3, (int)-655710492);
        double[] aspicu_Temp1_limitHi = TestHelper.generateDoubleArray((int)3, (int)1415032320);
        double[] aspicu_Temp1_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1795388022);
        double[] aspicu_Temp2_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1738524616);
        double[] aspicu_Temp2_warnLo = TestHelper.generateDoubleArray((int)3, (int)-890208690);
        double[] aspicu_Temp2_limitHi = TestHelper.generateDoubleArray((int)3, (int)7031721);
        double[] aspicu_Temp2_limitLo = TestHelper.generateDoubleArray((int)3, (int)1409398089);
        double[] clkhi_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1078549398);
        double[] clkhi_warnLo = TestHelper.generateDoubleArray((int)3, (int)1446821863);
        double[] clkhi_limitHi = TestHelper.generateDoubleArray((int)3, (int)500070336);
        double[] clkhi_limitLo = TestHelper.generateDoubleArray((int)3, (int)1078941443);
        double[] clkhv_warnHi = TestHelper.generateDoubleArray((int)3, (int)377883121);
        double[] clkhv_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1784037676);
        double[] clkhv_limitHi = TestHelper.generateDoubleArray((int)3, (int)2096314227);
        double[] clkhv_limitLo = TestHelper.generateDoubleArray((int)3, (int)548046560);
        double[] clkli_warnHi = TestHelper.generateDoubleArray((int)3, (int)1107412114);
        double[] clkli_warnLo = TestHelper.generateDoubleArray((int)3, (int)455849045);
        double[] clkli_limitHi = TestHelper.generateDoubleArray((int)3, (int)1323782593);
        double[] clkli_limitLo = TestHelper.generateDoubleArray((int)3, (int)-292770954);
        double[] clklv_warnHi = TestHelper.generateDoubleArray((int)3, (int)-720768972);
        double[] clklv_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1883430654);
        double[] clklv_limitHi = TestHelper.generateDoubleArray((int)3, (int)1057804658);
        double[] clklv_limitLo = TestHelper.generateDoubleArray((int)3, (int)-211547468);
        double[] digi_warnHi = TestHelper.generateDoubleArray((int)3, (int)1567374843);
        double[] digi_warnLo = TestHelper.generateDoubleArray((int)3, (int)1574534742);
        double[] digi_limitHi = TestHelper.generateDoubleArray((int)3, (int)1652830790);
        double[] digi_limitLo = TestHelper.generateDoubleArray((int)3, (int)-514473727);
        double[] digv_warnHi = TestHelper.generateDoubleArray((int)3, (int)1068795541);
        double[] digv_warnLo = TestHelper.generateDoubleArray((int)3, (int)1781728369);
        double[] digv_limitHi = TestHelper.generateDoubleArray((int)3, (int)1978641777);
        double[] digv_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1459255644);
        double[] hvbiasswitch_warnHi = TestHelper.generateDoubleArray((int)3, (int)-389829165);
        double[] hvbiasswitch_warnLo = TestHelper.generateDoubleArray((int)3, (int)-438794215);
        double[] hvbiasswitch_limitHi = TestHelper.generateDoubleArray((int)3, (int)-2135271099);
        double[] hvbiasswitch_limitLo = TestHelper.generateDoubleArray((int)3, (int)927590245);
        double[] htrv_warnHi = TestHelper.generateDoubleArray((int)3, (int)12102523);
        double[] htrv_warnLo = TestHelper.generateDoubleArray((int)3, (int)1422701825);
        double[] htrv_limitHi = TestHelper.generateDoubleArray((int)3, (int)814026801);
        double[] htrv_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1158033292);
        double[] htrw_warnHi = TestHelper.generateDoubleArray((int)3, (int)1461767516);
        double[] htrw_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1134548914);
        double[] htrw_limitHi = TestHelper.generateDoubleArray((int)3, (int)1929794281);
        double[] htrw_limitLo = TestHelper.generateDoubleArray((int)3, (int)-295004022);
        String location = "";
        double[] odi_warnHi = TestHelper.generateDoubleArray((int)3, (int)297021270);
        double[] odi_warnLo = TestHelper.generateDoubleArray((int)3, (int)-808871450);
        double[] odi_limitHi = TestHelper.generateDoubleArray((int)3, (int)-536615346);
        double[] odi_limitLo = TestHelper.generateDoubleArray((int)3, (int)1654612074);
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)3, (int)-85709142);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)3, (int)1225640465);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)3, (int)1002510585);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)3, (int)596303768);
        double[] pclkl_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1867516586);
        double[] pclkl_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1832271686);
        double[] pclkl_limitHi = TestHelper.generateDoubleArray((int)3, (int)1791891260);
        double[] pclkl_limitLo = TestHelper.generateDoubleArray((int)3, (int)1135965160);
        double[] pclku_warnHi = TestHelper.generateDoubleArray((int)3, (int)1533116518);
        double[] pclku_warnLo = TestHelper.generateDoubleArray((int)3, (int)-472306993);
        double[] pclku_limitHi = TestHelper.generateDoubleArray((int)3, (int)1760012384);
        double[] pclku_limitLo = TestHelper.generateDoubleArray((int)3, (int)1159578691);
        double[] power_warnHi = TestHelper.generateDoubleArray((int)3, (int)1481437868);
        double[] power_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1497162935);
        double[] power_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1090143313);
        double[] power_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1950094253);
        double[] rgl_warnHi = TestHelper.generateDoubleArray((int)3, (int)-2047753023);
        double[] rgl_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1330703127);
        double[] rgl_limitHi = TestHelper.generateDoubleArray((int)3, (int)441991698);
        double[] rgl_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1374978215);
        double[] rgu_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1615826616);
        double[] rgu_warnLo = TestHelper.generateDoubleArray((int)3, (int)758414116);
        double[] rgu_limitHi = TestHelper.generateDoubleArray((int)3, (int)-872055301);
        double[] rgu_limitLo = TestHelper.generateDoubleArray((int)3, (int)851076157);
        double[] rtdtemp_warnHi = TestHelper.generateDoubleArray((int)3, (int)930619769);
        double[] rtdtemp_warnLo = TestHelper.generateDoubleArray((int)3, (int)402366043);
        double[] rtdtemp_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1683821180);
        double[] rtdtemp_limitLo = TestHelper.generateDoubleArray((int)3, (int)-503259418);
        double[] ref05v_warnHi = TestHelper.generateDoubleArray((int)3, (int)-536601123);
        double[] ref05v_warnLo = TestHelper.generateDoubleArray((int)3, (int)1491523406);
        double[] ref05v_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1706020136);
        double[] ref05v_limitLo = TestHelper.generateDoubleArray((int)3, (int)-924296501);
        double[] ref125v_warnHi = TestHelper.generateDoubleArray((int)3, (int)1165559638);
        double[] ref125v_warnLo = TestHelper.generateDoubleArray((int)3, (int)-2014485038);
        double[] ref125v_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1863475502);
        double[] ref125v_limitLo = TestHelper.generateDoubleArray((int)3, (int)776719050);
        double[] ref15v_warnHi = TestHelper.generateDoubleArray((int)3, (int)-793895838);
        double[] ref15v_warnLo = TestHelper.generateDoubleArray((int)3, (int)439944898);
        double[] ref15v_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1621212701);
        double[] ref15v_limitLo = TestHelper.generateDoubleArray((int)3, (int)123056696);
        double[] ref25v_warnHi = TestHelper.generateDoubleArray((int)3, (int)862916256);
        double[] ref25v_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1917684429);
        double[] ref25v_limitHi = TestHelper.generateDoubleArray((int)3, (int)929015608);
        double[] ref25v_limitLo = TestHelper.generateDoubleArray((int)3, (int)1420634936);
        double[] refn12_warnHi = TestHelper.generateDoubleArray((int)3, (int)902245522);
        double[] refn12_warnLo = TestHelper.generateDoubleArray((int)3, (int)-768062742);
        double[] refn12_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1182818789);
        double[] refn12_limitLo = TestHelper.generateDoubleArray((int)3, (int)708607568);
        double[] refp12_warnHi = TestHelper.generateDoubleArray((int)3, (int)-2043747421);
        double[] refp12_warnLo = TestHelper.generateDoubleArray((int)3, (int)595522578);
        double[] refp12_limitHi = TestHelper.generateDoubleArray((int)3, (int)811251096);
        double[] refp12_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1089396935);
        double[] sclkl_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1535058324);
        double[] sclkl_warnLo = TestHelper.generateDoubleArray((int)3, (int)726641193);
        double[] sclkl_limitHi = TestHelper.generateDoubleArray((int)3, (int)1809075812);
        double[] sclkl_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1703009547);
        double[] sclku_warnHi = TestHelper.generateDoubleArray((int)3, (int)1110197042);
        double[] sclku_warnLo = TestHelper.generateDoubleArray((int)3, (int)885500475);
        double[] sclku_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1381800198);
        double[] sclku_limitLo = TestHelper.generateDoubleArray((int)3, (int)-190348505);
        double[] temp10_warnHi = TestHelper.generateDoubleArray((int)3, (int)1701697203);
        double[] temp10_warnLo = TestHelper.generateDoubleArray((int)3, (int)-2053629357);
        double[] temp10_limitHi = TestHelper.generateDoubleArray((int)3, (int)815629831);
        double[] temp10_limitLo = TestHelper.generateDoubleArray((int)3, (int)1814938270);
        double[] temp1_warnHi = TestHelper.generateDoubleArray((int)3, (int)162662178);
        double[] temp1_warnLo = TestHelper.generateDoubleArray((int)3, (int)1566200365);
        double[] temp1_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1227135224);
        double[] temp1_limitLo = TestHelper.generateDoubleArray((int)3, (int)-568932558);
        double[] temp2_warnHi = TestHelper.generateDoubleArray((int)3, (int)-388095122);
        double[] temp2_warnLo = TestHelper.generateDoubleArray((int)3, (int)1544780592);
        double[] temp2_limitHi = TestHelper.generateDoubleArray((int)3, (int)2120830256);
        double[] temp2_limitLo = TestHelper.generateDoubleArray((int)3, (int)562691283);
        double[] temp3_warnHi = TestHelper.generateDoubleArray((int)3, (int)543113930);
        double[] temp3_warnLo = TestHelper.generateDoubleArray((int)3, (int)322812826);
        double[] temp3_limitHi = TestHelper.generateDoubleArray((int)3, (int)720314510);
        double[] temp3_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1547495970);
        double[] temp4_warnHi = TestHelper.generateDoubleArray((int)3, (int)-708730775);
        double[] temp4_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1487118083);
        double[] temp4_limitHi = TestHelper.generateDoubleArray((int)3, (int)1792719215);
        double[] temp4_limitLo = TestHelper.generateDoubleArray((int)3, (int)-218104654);
        double[] temp5_warnHi = TestHelper.generateDoubleArray((int)3, (int)830173065);
        double[] temp5_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1098662423);
        double[] temp5_limitHi = TestHelper.generateDoubleArray((int)3, (int)307822080);
        double[] temp5_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1771844989);
        double[] temp6_warnHi = TestHelper.generateDoubleArray((int)3, (int)-1748866125);
        double[] temp6_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1986744598);
        double[] temp6_limitHi = TestHelper.generateDoubleArray((int)3, (int)-1408190920);
        double[] temp6_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1777215635);
        double[] temp7_warnHi = TestHelper.generateDoubleArray((int)3, (int)385067328);
        double[] temp7_warnLo = TestHelper.generateDoubleArray((int)3, (int)-1116276044);
        double[] temp7_limitHi = TestHelper.generateDoubleArray((int)3, (int)-782485004);
        double[] temp7_limitLo = TestHelper.generateDoubleArray((int)3, (int)-1621018676);
        double[] temp8_warnHi = TestHelper.generateDoubleArray((int)3, (int)1971939871);
        double[] temp8_warnLo = TestHelper.generateDoubleArray((int)3, (int)2124218780);
        double[] temp8_limitHi = TestHelper.generateDoubleArray((int)3, (int)401431907);
        double[] temp8_limitLo = TestHelper.generateDoubleArray((int)3, (int)507132618);
        double[] temp9_warnHi = TestHelper.generateDoubleArray((int)3, (int)118684372);
        double[] temp9_warnLo = TestHelper.generateDoubleArray((int)3, (int)-154242998);
        double[] temp9_limitHi = TestHelper.generateDoubleArray((int)3, (int)-879149149);
        double[] temp9_limitLo = TestHelper.generateDoubleArray((int)3, (int)733265464);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_LimitsSettingsAppliedEvent(priority, version, anai_warnHi, anai_warnLo, anai_limitHi, anai_limitLo, anav_warnHi, anav_warnLo, anav_limitHi, anav_limitLo, aspicl_Temp0_warnHi, aspicl_Temp0_warnLo, aspicl_Temp0_limitHi, aspicl_Temp0_limitLo, aspicl_Temp1_warnHi, aspicl_Temp1_warnLo, aspicl_Temp1_limitHi, aspicl_Temp1_limitLo, aspicl_Temp2_warnHi, aspicl_Temp2_warnLo, aspicl_Temp2_limitHi, aspicl_Temp2_limitLo, aspicu_Temp0_warnHi, aspicu_Temp0_warnLo, aspicu_Temp0_limitHi, aspicu_Temp0_limitLo, aspicu_Temp1_warnHi, aspicu_Temp1_warnLo, aspicu_Temp1_limitHi, aspicu_Temp1_limitLo, aspicu_Temp2_warnHi, aspicu_Temp2_warnLo, aspicu_Temp2_limitHi, aspicu_Temp2_limitLo, clkhi_warnHi, clkhi_warnLo, clkhi_limitHi, clkhi_limitLo, clkhv_warnHi, clkhv_warnLo, clkhv_limitHi, clkhv_limitLo, clkli_warnHi, clkli_warnLo, clkli_limitHi, clkli_limitLo, clklv_warnHi, clklv_warnLo, clklv_limitHi, clklv_limitLo, digi_warnHi, digi_warnLo, digi_limitHi, digi_limitLo, digv_warnHi, digv_warnLo, digv_limitHi, digv_limitLo, hvbiasswitch_warnHi, hvbiasswitch_warnLo, hvbiasswitch_limitHi, hvbiasswitch_limitLo, htrv_warnHi, htrv_warnLo, htrv_limitHi, htrv_limitLo, htrw_warnHi, htrw_warnLo, htrw_limitHi, htrw_limitLo, location, odi_warnHi, odi_warnLo, odi_limitHi, odi_limitLo, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, pclkl_warnHi, pclkl_warnLo, pclkl_limitHi, pclkl_limitLo, pclku_warnHi, pclku_warnLo, pclku_limitHi, pclku_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo, rgl_warnHi, rgl_warnLo, rgl_limitHi, rgl_limitLo, rgu_warnHi, rgu_warnLo, rgu_limitHi, rgu_limitLo, rtdtemp_warnHi, rtdtemp_warnLo, rtdtemp_limitHi, rtdtemp_limitLo, ref05v_warnHi, ref05v_warnLo, ref05v_limitHi, ref05v_limitLo, ref125v_warnHi, ref125v_warnLo, ref125v_limitHi, ref125v_limitLo, ref15v_warnHi, ref15v_warnLo, ref15v_limitHi, ref15v_limitLo, ref25v_warnHi, ref25v_warnLo, ref25v_limitHi, ref25v_limitLo, refn12_warnHi, refn12_warnLo, refn12_limitHi, refn12_limitLo, refp12_warnHi, refp12_warnLo, refp12_limitHi, refp12_limitLo, sclkl_warnHi, sclkl_warnLo, sclkl_limitHi, sclkl_limitLo, sclku_warnHi, sclku_warnLo, sclku_limitHi, sclku_limitLo, temp10_warnHi, temp10_warnLo, temp10_limitHi, temp10_limitLo, temp1_warnHi, temp1_warnLo, temp1_limitHi, temp1_limitLo, temp2_warnHi, temp2_warnLo, temp2_limitHi, temp2_limitLo, temp3_warnHi, temp3_warnLo, temp3_limitHi, temp3_limitLo, temp4_warnHi, temp4_warnLo, temp4_limitHi, temp4_limitLo, temp5_warnHi, temp5_warnLo, temp5_limitHi, temp5_limitLo, temp6_warnHi, temp6_warnLo, temp6_limitHi, temp6_limitLo, temp7_warnHi, temp7_warnLo, temp7_limitHi, temp7_limitLo, temp8_warnHi, temp8_warnLo, temp8_limitHi, temp8_limitLo, temp9_warnHi, temp9_warnLo, temp9_limitHi, temp9_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_LimitsSettingsAppliedEvent));
        Focal_plane_Reb_LimitsSettingsAppliedEvent item_ = (Focal_plane_Reb_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])anai_warnHi, (double[])item_.getAnai_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_warnLo, (double[])item_.getAnai_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitHi, (double[])item_.getAnai_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitLo, (double[])item_.getAnai_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnHi, (double[])item_.getAnav_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnLo, (double[])item_.getAnav_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitHi, (double[])item_.getAnav_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitLo, (double[])item_.getAnav_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnHi, (double[])item_.getAspicl_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnLo, (double[])item_.getAspicl_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitHi, (double[])item_.getAspicl_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitLo, (double[])item_.getAspicl_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_warnHi, (double[])item_.getAspicl_Temp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_warnLo, (double[])item_.getAspicl_Temp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_limitHi, (double[])item_.getAspicl_Temp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_limitLo, (double[])item_.getAspicl_Temp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_warnHi, (double[])item_.getAspicl_Temp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_warnLo, (double[])item_.getAspicl_Temp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_limitHi, (double[])item_.getAspicl_Temp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_limitLo, (double[])item_.getAspicl_Temp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnHi, (double[])item_.getAspicu_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnLo, (double[])item_.getAspicu_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitHi, (double[])item_.getAspicu_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitLo, (double[])item_.getAspicu_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_warnHi, (double[])item_.getAspicu_Temp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_warnLo, (double[])item_.getAspicu_Temp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_limitHi, (double[])item_.getAspicu_Temp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_limitLo, (double[])item_.getAspicu_Temp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_warnHi, (double[])item_.getAspicu_Temp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_warnLo, (double[])item_.getAspicu_Temp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_limitHi, (double[])item_.getAspicu_Temp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_limitLo, (double[])item_.getAspicu_Temp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnHi, (double[])item_.getClkhi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnLo, (double[])item_.getClkhi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitHi, (double[])item_.getClkhi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitLo, (double[])item_.getClkhi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnHi, (double[])item_.getClkhv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnLo, (double[])item_.getClkhv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitHi, (double[])item_.getClkhv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitLo, (double[])item_.getClkhv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_warnHi, (double[])item_.getClkli_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_warnLo, (double[])item_.getClkli_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_limitHi, (double[])item_.getClkli_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_limitLo, (double[])item_.getClkli_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnHi, (double[])item_.getClklv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnLo, (double[])item_.getClklv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitHi, (double[])item_.getClklv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitLo, (double[])item_.getClklv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnHi, (double[])item_.getDigi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnLo, (double[])item_.getDigi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitHi, (double[])item_.getDigi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitLo, (double[])item_.getDigi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnHi, (double[])item_.getDigv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnLo, (double[])item_.getDigv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitHi, (double[])item_.getDigv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitLo, (double[])item_.getDigv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnHi, (double[])item_.getHvbiasswitch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnLo, (double[])item_.getHvbiasswitch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitHi, (double[])item_.getHvbiasswitch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitLo, (double[])item_.getHvbiasswitch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnHi, (double[])item_.getHtrv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnLo, (double[])item_.getHtrv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitHi, (double[])item_.getHtrv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitLo, (double[])item_.getHtrv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnHi, (double[])item_.getHtrw_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnLo, (double[])item_.getHtrw_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitHi, (double[])item_.getHtrw_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitLo, (double[])item_.getHtrw_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odi_warnHi, (double[])item_.getOdi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_warnLo, (double[])item_.getOdi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitHi, (double[])item_.getOdi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitLo, (double[])item_.getOdi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnHi, (double[])item_.getPclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnLo, (double[])item_.getPclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitHi, (double[])item_.getPclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitLo, (double[])item_.getPclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnHi, (double[])item_.getPclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnLo, (double[])item_.getPclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitHi, (double[])item_.getPclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitLo, (double[])item_.getPclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnHi, (double[])item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnLo, (double[])item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitHi, (double[])item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitLo, (double[])item_.getPower_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnHi, (double[])item_.getRgl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnLo, (double[])item_.getRgl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitHi, (double[])item_.getRgl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitLo, (double[])item_.getRgl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnHi, (double[])item_.getRgu_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnLo, (double[])item_.getRgu_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitHi, (double[])item_.getRgu_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitLo, (double[])item_.getRgu_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnHi, (double[])item_.getRtdtemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnLo, (double[])item_.getRtdtemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitHi, (double[])item_.getRtdtemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitLo, (double[])item_.getRtdtemp_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_warnHi, (double[])item_.getRef05v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_warnLo, (double[])item_.getRef05v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_limitHi, (double[])item_.getRef05v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_limitLo, (double[])item_.getRef05v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_warnHi, (double[])item_.getRef125v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_warnLo, (double[])item_.getRef125v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_limitHi, (double[])item_.getRef125v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_limitLo, (double[])item_.getRef125v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_warnHi, (double[])item_.getRef15v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_warnLo, (double[])item_.getRef15v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_limitHi, (double[])item_.getRef15v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_limitLo, (double[])item_.getRef15v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_warnHi, (double[])item_.getRef25v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_warnLo, (double[])item_.getRef25v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_limitHi, (double[])item_.getRef25v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_limitLo, (double[])item_.getRef25v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_warnHi, (double[])item_.getRefn12_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_warnLo, (double[])item_.getRefn12_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_limitHi, (double[])item_.getRefn12_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_limitLo, (double[])item_.getRefn12_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_warnHi, (double[])item_.getRefp12_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_warnLo, (double[])item_.getRefp12_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_limitHi, (double[])item_.getRefp12_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_limitLo, (double[])item_.getRefp12_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnHi, (double[])item_.getSclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnLo, (double[])item_.getSclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitHi, (double[])item_.getSclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitLo, (double[])item_.getSclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnHi, (double[])item_.getSclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnLo, (double[])item_.getSclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitHi, (double[])item_.getSclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitLo, (double[])item_.getSclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_warnHi, (double[])item_.getTemp10_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_warnLo, (double[])item_.getTemp10_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_limitHi, (double[])item_.getTemp10_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_limitLo, (double[])item_.getTemp10_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnHi, (double[])item_.getTemp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnLo, (double[])item_.getTemp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitHi, (double[])item_.getTemp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitLo, (double[])item_.getTemp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnHi, (double[])item_.getTemp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnLo, (double[])item_.getTemp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitHi, (double[])item_.getTemp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitLo, (double[])item_.getTemp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnHi, (double[])item_.getTemp3_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnLo, (double[])item_.getTemp3_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitHi, (double[])item_.getTemp3_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitLo, (double[])item_.getTemp3_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnHi, (double[])item_.getTemp4_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnLo, (double[])item_.getTemp4_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitHi, (double[])item_.getTemp4_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitLo, (double[])item_.getTemp4_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnHi, (double[])item_.getTemp5_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnLo, (double[])item_.getTemp5_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitHi, (double[])item_.getTemp5_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitLo, (double[])item_.getTemp5_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnHi, (double[])item_.getTemp6_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnLo, (double[])item_.getTemp6_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitHi, (double[])item_.getTemp6_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitLo, (double[])item_.getTemp6_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_warnHi, (double[])item_.getTemp7_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_warnLo, (double[])item_.getTemp7_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_limitHi, (double[])item_.getTemp7_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_limitLo, (double[])item_.getTemp7_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_warnHi, (double[])item_.getTemp8_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_warnLo, (double[])item_.getTemp8_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_limitHi, (double[])item_.getTemp8_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_limitLo, (double[])item_.getTemp8_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_warnHi, (double[])item_.getTemp9_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_warnLo, (double[])item_.getTemp9_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_limitHi, (double[])item_.getTemp9_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_limitLo, (double[])item_.getTemp9_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsSettingsAppliedEvent() throws Exception {
        int priority = 33;
        int version = 814;
        double[] bias0_csGateP = TestHelper.generateDoubleArray((int)3, (int)-1497374804);
        double[] bias0_gdP = TestHelper.generateDoubleArray((int)3, (int)472345506);
        double[] bias0_odP = TestHelper.generateDoubleArray((int)3, (int)2135407278);
        double[] bias0_ogP = TestHelper.generateDoubleArray((int)3, (int)1724963886);
        double[] bias0_rdP = TestHelper.generateDoubleArray((int)3, (int)345873261);
        double[] bias1_csGateP = TestHelper.generateDoubleArray((int)3, (int)1631924893);
        double[] bias1_gdP = TestHelper.generateDoubleArray((int)3, (int)-2103902085);
        double[] bias1_odP = TestHelper.generateDoubleArray((int)3, (int)-499911129);
        double[] bias1_ogP = TestHelper.generateDoubleArray((int)3, (int)1829961012);
        double[] bias1_rdP = TestHelper.generateDoubleArray((int)3, (int)-1863871390);
        double[] bias2_csGateP = TestHelper.generateDoubleArray((int)3, (int)-91752646);
        double[] bias2_gdP = TestHelper.generateDoubleArray((int)3, (int)127004054);
        double[] bias2_odP = TestHelper.generateDoubleArray((int)3, (int)-615417006);
        double[] bias2_ogP = TestHelper.generateDoubleArray((int)3, (int)-1275489120);
        double[] bias2_rdP = TestHelper.generateDoubleArray((int)3, (int)512412775);
        double[] dac_pclkHighP = TestHelper.generateDoubleArray((int)3, (int)-944533747);
        double[] dac_pclkLowP = TestHelper.generateDoubleArray((int)3, (int)-157151746);
        double[] dac_rgHighP = TestHelper.generateDoubleArray((int)3, (int)-1545575539);
        double[] dac_rgLowP = TestHelper.generateDoubleArray((int)3, (int)36107115);
        double[] dac_sclkHighP = TestHelper.generateDoubleArray((int)3, (int)-1884076051);
        double[] dac_sclkLowP = TestHelper.generateDoubleArray((int)3, (int)1482997625);
        boolean[] disableRTDHardwareCheck = new boolean[]{true, false, false};
        String location = "d";
        long[] serialNum = TestHelper.generateLongArray((int)3, (int)1882043189);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsSettingsAppliedEvent(priority, version, bias0_csGateP, bias0_gdP, bias0_odP, bias0_ogP, bias0_rdP, bias1_csGateP, bias1_gdP, bias1_odP, bias1_ogP, bias1_rdP, bias2_csGateP, bias2_gdP, bias2_odP, bias2_ogP, bias2_rdP, dac_pclkHighP, dac_pclkLowP, dac_rgHighP, dac_rgLowP, dac_sclkHighP, dac_sclkLowP, disableRTDHardwareCheck, location, serialNum));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsSettingsAppliedEvent));
        Focal_plane_Reb_RaftsSettingsAppliedEvent item_ = (Focal_plane_Reb_RaftsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_csGateP, (double[])item_.getBias0_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdP, (double[])item_.getBias0_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odP, (double[])item_.getBias0_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogP, (double[])item_.getBias0_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdP, (double[])item_.getBias0_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_csGateP, (double[])item_.getBias1_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdP, (double[])item_.getBias1_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odP, (double[])item_.getBias1_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogP, (double[])item_.getBias1_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdP, (double[])item_.getBias1_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_csGateP, (double[])item_.getBias2_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdP, (double[])item_.getBias2_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odP, (double[])item_.getBias2_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogP, (double[])item_.getBias2_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdP, (double[])item_.getBias2_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighP, (double[])item_.getDac_pclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowP, (double[])item_.getDac_pclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighP, (double[])item_.getDac_rgHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowP, (double[])item_.getDac_rgLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighP, (double[])item_.getDac_sclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowP, (double[])item_.getDac_sclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((boolean[])disableRTDHardwareCheck, (boolean[])item_.getDisableRTDHardwareCheck());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])serialNum, (long[])item_.getSerialNum());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsLimitsSettingsAppliedEvent() throws Exception {
        int priority = 48;
        int version = 606;
        double[] bias0_gdMax = TestHelper.generateDoubleArray((int)3, (int)1273457989);
        double[] bias0_gdMin = TestHelper.generateDoubleArray((int)3, (int)1438210727);
        double[] bias0_odMax = TestHelper.generateDoubleArray((int)3, (int)175641056);
        double[] bias0_odMin = TestHelper.generateDoubleArray((int)3, (int)-395279394);
        double[] bias0_ogMax = TestHelper.generateDoubleArray((int)3, (int)1127557771);
        double[] bias0_ogMin = TestHelper.generateDoubleArray((int)3, (int)-897017838);
        double[] bias0_rdMax = TestHelper.generateDoubleArray((int)3, (int)-1777080043);
        double[] bias0_rdMin = TestHelper.generateDoubleArray((int)3, (int)841663194);
        double[] bias1_gdMax = TestHelper.generateDoubleArray((int)3, (int)-1495759909);
        double[] bias1_gdMin = TestHelper.generateDoubleArray((int)3, (int)-812072177);
        double[] bias1_odMax = TestHelper.generateDoubleArray((int)3, (int)-2138761453);
        double[] bias1_odMin = TestHelper.generateDoubleArray((int)3, (int)398114033);
        double[] bias1_ogMax = TestHelper.generateDoubleArray((int)3, (int)-1246951865);
        double[] bias1_ogMin = TestHelper.generateDoubleArray((int)3, (int)1989938558);
        double[] bias1_rdMax = TestHelper.generateDoubleArray((int)3, (int)-1671253439);
        double[] bias1_rdMin = TestHelper.generateDoubleArray((int)3, (int)1012609429);
        double[] bias2_gdMax = TestHelper.generateDoubleArray((int)3, (int)-744594185);
        double[] bias2_gdMin = TestHelper.generateDoubleArray((int)3, (int)-462227506);
        double[] bias2_odMax = TestHelper.generateDoubleArray((int)3, (int)-900185029);
        double[] bias2_odMin = TestHelper.generateDoubleArray((int)3, (int)32412223);
        double[] bias2_ogMax = TestHelper.generateDoubleArray((int)3, (int)87276859);
        double[] bias2_ogMin = TestHelper.generateDoubleArray((int)3, (int)621954427);
        double[] bias2_rdMax = TestHelper.generateDoubleArray((int)3, (int)-1385333235);
        double[] bias2_rdMin = TestHelper.generateDoubleArray((int)3, (int)-279087982);
        double[] dac_pclkHighMax = TestHelper.generateDoubleArray((int)3, (int)-779974685);
        double[] dac_pclkHighMin = TestHelper.generateDoubleArray((int)3, (int)-164284968);
        double[] dac_pclkLowMax = TestHelper.generateDoubleArray((int)3, (int)1687714718);
        double[] dac_pclkLowMin = TestHelper.generateDoubleArray((int)3, (int)-479755585);
        double[] dac_rgHighMax = TestHelper.generateDoubleArray((int)3, (int)-246494258);
        double[] dac_rgHighMin = TestHelper.generateDoubleArray((int)3, (int)1039402254);
        double[] dac_rgLowMax = TestHelper.generateDoubleArray((int)3, (int)-1469298070);
        double[] dac_rgLowMin = TestHelper.generateDoubleArray((int)3, (int)-890728917);
        double[] dac_sclkHighMax = TestHelper.generateDoubleArray((int)3, (int)1617126848);
        double[] dac_sclkHighMin = TestHelper.generateDoubleArray((int)3, (int)-850200220);
        double[] dac_sclkLowMax = TestHelper.generateDoubleArray((int)3, (int)1520215923);
        double[] dac_sclkLowMin = TestHelper.generateDoubleArray((int)3, (int)-846616497);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsLimitsSettingsAppliedEvent(priority, version, bias0_gdMax, bias0_gdMin, bias0_odMax, bias0_odMin, bias0_ogMax, bias0_ogMin, bias0_rdMax, bias0_rdMin, bias1_gdMax, bias1_gdMin, bias1_odMax, bias1_odMin, bias1_ogMax, bias1_ogMin, bias1_rdMax, bias1_rdMin, bias2_gdMax, bias2_gdMin, bias2_odMax, bias2_odMin, bias2_ogMax, bias2_ogMin, bias2_rdMax, bias2_rdMin, dac_pclkHighMax, dac_pclkHighMin, dac_pclkLowMax, dac_pclkLowMin, dac_rgHighMax, dac_rgHighMin, dac_rgLowMax, dac_rgLowMin, dac_sclkHighMax, dac_sclkHighMin, dac_sclkLowMax, dac_sclkLowMin, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsLimitsSettingsAppliedEvent));
        Focal_plane_Reb_RaftsLimitsSettingsAppliedEvent item_ = (Focal_plane_Reb_RaftsLimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdMax, (double[])item_.getBias0_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdMin, (double[])item_.getBias0_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMax, (double[])item_.getBias0_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMin, (double[])item_.getBias0_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMax, (double[])item_.getBias0_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMin, (double[])item_.getBias0_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMax, (double[])item_.getBias0_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMin, (double[])item_.getBias0_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdMax, (double[])item_.getBias1_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdMin, (double[])item_.getBias1_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odMax, (double[])item_.getBias1_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odMin, (double[])item_.getBias1_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogMax, (double[])item_.getBias1_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogMin, (double[])item_.getBias1_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdMax, (double[])item_.getBias1_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdMin, (double[])item_.getBias1_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdMax, (double[])item_.getBias2_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdMin, (double[])item_.getBias2_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odMax, (double[])item_.getBias2_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odMin, (double[])item_.getBias2_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogMax, (double[])item_.getBias2_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogMin, (double[])item_.getBias2_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdMax, (double[])item_.getBias2_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdMin, (double[])item_.getBias2_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMax, (double[])item_.getDac_pclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMin, (double[])item_.getDac_pclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMax, (double[])item_.getDac_pclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMin, (double[])item_.getDac_pclkLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMax, (double[])item_.getDac_rgHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMin, (double[])item_.getDac_rgHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMax, (double[])item_.getDac_rgLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMin, (double[])item_.getDac_rgLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMax, (double[])item_.getDac_sclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMin, (double[])item_.getDac_sclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMax, (double[])item_.getDac_sclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMin, (double[])item_.getDac_sclkLowMin(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsPowerSettingsAppliedEvent() throws Exception {
        int priority = 624;
        int version = 28;
        double[] bias0_gdCal = TestHelper.generateDoubleArray((int)3, (int)1089496544);
        double[] bias0_gdTestVolts = TestHelper.generateDoubleArray((int)3, (int)-1894031358);
        double[] bias0_gdTol = TestHelper.generateDoubleArray((int)3, (int)732766829);
        double[] bias0_gdValueErr = TestHelper.generateDoubleArray((int)3, (int)597771368);
        double[] bias0_gdZeroErr = TestHelper.generateDoubleArray((int)3, (int)-1627606993);
        double[] bias0_odCal = TestHelper.generateDoubleArray((int)3, (int)432318281);
        double[] bias0_odIMax = TestHelper.generateDoubleArray((int)3, (int)694700317);
        double[] bias0_odTol = TestHelper.generateDoubleArray((int)3, (int)-1493307631);
        double[] bias0_odZeroErr = TestHelper.generateDoubleArray((int)3, (int)1237829841);
        double[] bias0_ogCal = TestHelper.generateDoubleArray((int)3, (int)-798099728);
        double[] bias0_ogTestVolts = TestHelper.generateDoubleArray((int)3, (int)310978866);
        double[] bias0_ogTol = TestHelper.generateDoubleArray((int)3, (int)-332088292);
        double[] bias0_ogValueErr = TestHelper.generateDoubleArray((int)3, (int)236807042);
        double[] bias0_ogZeroErr = TestHelper.generateDoubleArray((int)3, (int)525266529);
        double[] bias0_rdCal = TestHelper.generateDoubleArray((int)3, (int)705120056);
        double[] bias0_rdTestVolts = TestHelper.generateDoubleArray((int)3, (int)344440125);
        double[] bias0_rdTol = TestHelper.generateDoubleArray((int)3, (int)760347206);
        double[] bias0_rdValueErr = TestHelper.generateDoubleArray((int)3, (int)1660244005);
        double[] bias0_rdZeroErr = TestHelper.generateDoubleArray((int)3, (int)1737122486);
        double[] bias1_gdCal = TestHelper.generateDoubleArray((int)3, (int)-303788122);
        double[] bias1_gdTestVolts = TestHelper.generateDoubleArray((int)3, (int)-1075331119);
        double[] bias1_gdTol = TestHelper.generateDoubleArray((int)3, (int)1182142070);
        double[] bias1_gdValueErr = TestHelper.generateDoubleArray((int)3, (int)-1811298010);
        double[] bias1_gdZeroErr = TestHelper.generateDoubleArray((int)3, (int)1191201980);
        double[] bias1_odCal = TestHelper.generateDoubleArray((int)3, (int)-1650076632);
        double[] bias1_odIMax = TestHelper.generateDoubleArray((int)3, (int)768216338);
        double[] bias1_odTol = TestHelper.generateDoubleArray((int)3, (int)1893684544);
        double[] bias1_odZeroErr = TestHelper.generateDoubleArray((int)3, (int)-294301172);
        double[] bias1_ogCal = TestHelper.generateDoubleArray((int)3, (int)-1411670137);
        double[] bias1_ogTestVolts = TestHelper.generateDoubleArray((int)3, (int)-1907053487);
        double[] bias1_ogTol = TestHelper.generateDoubleArray((int)3, (int)-663445890);
        double[] bias1_ogValueErr = TestHelper.generateDoubleArray((int)3, (int)2061571200);
        double[] bias1_ogZeroErr = TestHelper.generateDoubleArray((int)3, (int)-1446742139);
        double[] bias1_rdCal = TestHelper.generateDoubleArray((int)3, (int)-253791879);
        double[] bias1_rdTestVolts = TestHelper.generateDoubleArray((int)3, (int)-1256907556);
        double[] bias1_rdTol = TestHelper.generateDoubleArray((int)3, (int)523203277);
        double[] bias1_rdValueErr = TestHelper.generateDoubleArray((int)3, (int)-610405771);
        double[] bias1_rdZeroErr = TestHelper.generateDoubleArray((int)3, (int)1899454545);
        double[] bias2_gdCal = TestHelper.generateDoubleArray((int)3, (int)-1579662112);
        double[] bias2_gdTestVolts = TestHelper.generateDoubleArray((int)3, (int)-819709137);
        double[] bias2_gdTol = TestHelper.generateDoubleArray((int)3, (int)-2126148337);
        double[] bias2_gdValueErr = TestHelper.generateDoubleArray((int)3, (int)-850535949);
        double[] bias2_gdZeroErr = TestHelper.generateDoubleArray((int)3, (int)658694105);
        double[] bias2_odCal = TestHelper.generateDoubleArray((int)3, (int)1544214616);
        double[] bias2_odIMax = TestHelper.generateDoubleArray((int)3, (int)-346519984);
        double[] bias2_odTol = TestHelper.generateDoubleArray((int)3, (int)1904743654);
        double[] bias2_odZeroErr = TestHelper.generateDoubleArray((int)3, (int)1768891499);
        double[] bias2_ogCal = TestHelper.generateDoubleArray((int)3, (int)-1283499611);
        double[] bias2_ogTestVolts = TestHelper.generateDoubleArray((int)3, (int)2082149790);
        double[] bias2_ogTol = TestHelper.generateDoubleArray((int)3, (int)-1224375700);
        double[] bias2_ogValueErr = TestHelper.generateDoubleArray((int)3, (int)746541898);
        double[] bias2_ogZeroErr = TestHelper.generateDoubleArray((int)3, (int)969099923);
        double[] bias2_rdCal = TestHelper.generateDoubleArray((int)3, (int)-1910874322);
        double[] bias2_rdTestVolts = TestHelper.generateDoubleArray((int)3, (int)-1672039145);
        double[] bias2_rdTol = TestHelper.generateDoubleArray((int)3, (int)-1240015804);
        double[] bias2_rdValueErr = TestHelper.generateDoubleArray((int)3, (int)960761200);
        double[] bias2_rdZeroErr = TestHelper.generateDoubleArray((int)3, (int)1540278954);
        double[] clkhiAmin = TestHelper.generateDoubleArray((int)3, (int)1453563042);
        double[] clkhiQmax = TestHelper.generateDoubleArray((int)3, (int)-204320891);
        double[] clkliAmin = TestHelper.generateDoubleArray((int)3, (int)1763683669);
        double[] clkliQmax = TestHelper.generateDoubleArray((int)3, (int)-1078288371);
        double[] dac_clkhIMax = TestHelper.generateDoubleArray((int)3, (int)-103208195);
        double[] dac_clklIMax = TestHelper.generateDoubleArray((int)3, (int)-1619615978);
        double[] dac_pclkHighCal = TestHelper.generateDoubleArray((int)3, (int)-1479517357);
        double[] dac_pclkHighTestV = TestHelper.generateDoubleArray((int)3, (int)1171984081);
        double[] dac_pclkHighTol = TestHelper.generateDoubleArray((int)3, (int)1063499433);
        double[] dac_pclkHighValueErr = TestHelper.generateDoubleArray((int)3, (int)-837520218);
        double[] dac_pclkHighZeroErr = TestHelper.generateDoubleArray((int)3, (int)-1258943765);
        double[] dac_pclkLowCal = TestHelper.generateDoubleArray((int)3, (int)1006633804);
        double[] dac_pclkLowTestV = TestHelper.generateDoubleArray((int)3, (int)-713249210);
        double[] dac_pclkLowTol = TestHelper.generateDoubleArray((int)3, (int)1743036301);
        double[] dac_pclkLowValueErr = TestHelper.generateDoubleArray((int)3, (int)683205059);
        double[] dac_pclkLowZeroErr = TestHelper.generateDoubleArray((int)3, (int)-1996394921);
        double[] dac_rgHighCal = TestHelper.generateDoubleArray((int)3, (int)577204585);
        double[] dac_rgHighTestV = TestHelper.generateDoubleArray((int)3, (int)-1351688435);
        double[] dac_rgHighTol = TestHelper.generateDoubleArray((int)3, (int)1203138199);
        double[] dac_rgHighValueErr = TestHelper.generateDoubleArray((int)3, (int)1225712432);
        double[] dac_rgHighZeroErr = TestHelper.generateDoubleArray((int)3, (int)-1604164941);
        double[] dac_rgLowCal = TestHelper.generateDoubleArray((int)3, (int)-2323238);
        double[] dac_rgLowTestV = TestHelper.generateDoubleArray((int)3, (int)-82388115);
        double[] dac_rgLowTol = TestHelper.generateDoubleArray((int)3, (int)-641683551);
        double[] dac_rgLowValueErr = TestHelper.generateDoubleArray((int)3, (int)-707885282);
        double[] dac_rgLowZeroErr = TestHelper.generateDoubleArray((int)3, (int)-932385828);
        double[] dac_sclkHighCal = TestHelper.generateDoubleArray((int)3, (int)-192508148);
        double[] dac_sclkHighTestV = TestHelper.generateDoubleArray((int)3, (int)-513813919);
        double[] dac_sclkHighTol = TestHelper.generateDoubleArray((int)3, (int)-228505958);
        double[] dac_sclkHighValueErr = TestHelper.generateDoubleArray((int)3, (int)236527410);
        double[] dac_sclkHighZeroErr = TestHelper.generateDoubleArray((int)3, (int)1621356974);
        double[] dac_sclkLowCal = TestHelper.generateDoubleArray((int)3, (int)1414296505);
        double[] dac_sclkLowTestV = TestHelper.generateDoubleArray((int)3, (int)-1688657448);
        double[] dac_sclkLowTol = TestHelper.generateDoubleArray((int)3, (int)819072378);
        double[] dac_sclkLowValueErr = TestHelper.generateDoubleArray((int)3, (int)-147306252);
        double[] dac_sclkLowZeroErr = TestHelper.generateDoubleArray((int)3, (int)-809450390);
        String location = "z";
        double[] maxDelta = TestHelper.generateDoubleArray((int)3, (int)1653464857);
        double[] maxStep = TestHelper.generateDoubleArray((int)3, (int)1017669325);
        double[] minTol = TestHelper.generateDoubleArray((int)3, (int)260997625);
        int[] nPowerOnPub = TestHelper.generateIntArray((int)3, (int)-224022510);
        double[] odiAmin = TestHelper.generateDoubleArray((int)3, (int)-39523990);
        double[] odiQmax = TestHelper.generateDoubleArray((int)3, (int)1579337276);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsPowerSettingsAppliedEvent(priority, version, bias0_gdCal, bias0_gdTestVolts, bias0_gdTol, bias0_gdValueErr, bias0_gdZeroErr, bias0_odCal, bias0_odIMax, bias0_odTol, bias0_odZeroErr, bias0_ogCal, bias0_ogTestVolts, bias0_ogTol, bias0_ogValueErr, bias0_ogZeroErr, bias0_rdCal, bias0_rdTestVolts, bias0_rdTol, bias0_rdValueErr, bias0_rdZeroErr, bias1_gdCal, bias1_gdTestVolts, bias1_gdTol, bias1_gdValueErr, bias1_gdZeroErr, bias1_odCal, bias1_odIMax, bias1_odTol, bias1_odZeroErr, bias1_ogCal, bias1_ogTestVolts, bias1_ogTol, bias1_ogValueErr, bias1_ogZeroErr, bias1_rdCal, bias1_rdTestVolts, bias1_rdTol, bias1_rdValueErr, bias1_rdZeroErr, bias2_gdCal, bias2_gdTestVolts, bias2_gdTol, bias2_gdValueErr, bias2_gdZeroErr, bias2_odCal, bias2_odIMax, bias2_odTol, bias2_odZeroErr, bias2_ogCal, bias2_ogTestVolts, bias2_ogTol, bias2_ogValueErr, bias2_ogZeroErr, bias2_rdCal, bias2_rdTestVolts, bias2_rdTol, bias2_rdValueErr, bias2_rdZeroErr, clkhiAmin, clkhiQmax, clkliAmin, clkliQmax, dac_clkhIMax, dac_clklIMax, dac_pclkHighCal, dac_pclkHighTestV, dac_pclkHighTol, dac_pclkHighValueErr, dac_pclkHighZeroErr, dac_pclkLowCal, dac_pclkLowTestV, dac_pclkLowTol, dac_pclkLowValueErr, dac_pclkLowZeroErr, dac_rgHighCal, dac_rgHighTestV, dac_rgHighTol, dac_rgHighValueErr, dac_rgHighZeroErr, dac_rgLowCal, dac_rgLowTestV, dac_rgLowTol, dac_rgLowValueErr, dac_rgLowZeroErr, dac_sclkHighCal, dac_sclkHighTestV, dac_sclkHighTol, dac_sclkHighValueErr, dac_sclkHighZeroErr, dac_sclkLowCal, dac_sclkLowTestV, dac_sclkLowTol, dac_sclkLowValueErr, dac_sclkLowZeroErr, location, maxDelta, maxStep, minTol, nPowerOnPub, odiAmin, odiQmax));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsPowerSettingsAppliedEvent));
        Focal_plane_Reb_RaftsPowerSettingsAppliedEvent item_ = (Focal_plane_Reb_RaftsPowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdCal, (double[])item_.getBias0_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTestVolts, (double[])item_.getBias0_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTol, (double[])item_.getBias0_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdValueErr, (double[])item_.getBias0_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdZeroErr, (double[])item_.getBias0_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odCal, (double[])item_.getBias0_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odIMax, (double[])item_.getBias0_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odTol, (double[])item_.getBias0_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odZeroErr, (double[])item_.getBias0_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogCal, (double[])item_.getBias0_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTestVolts, (double[])item_.getBias0_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTol, (double[])item_.getBias0_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogValueErr, (double[])item_.getBias0_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogZeroErr, (double[])item_.getBias0_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdCal, (double[])item_.getBias0_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTestVolts, (double[])item_.getBias0_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTol, (double[])item_.getBias0_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdValueErr, (double[])item_.getBias0_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdZeroErr, (double[])item_.getBias0_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdCal, (double[])item_.getBias1_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdTestVolts, (double[])item_.getBias1_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdTol, (double[])item_.getBias1_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdValueErr, (double[])item_.getBias1_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdZeroErr, (double[])item_.getBias1_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odCal, (double[])item_.getBias1_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odIMax, (double[])item_.getBias1_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odTol, (double[])item_.getBias1_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odZeroErr, (double[])item_.getBias1_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogCal, (double[])item_.getBias1_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogTestVolts, (double[])item_.getBias1_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogTol, (double[])item_.getBias1_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogValueErr, (double[])item_.getBias1_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogZeroErr, (double[])item_.getBias1_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdCal, (double[])item_.getBias1_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdTestVolts, (double[])item_.getBias1_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdTol, (double[])item_.getBias1_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdValueErr, (double[])item_.getBias1_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdZeroErr, (double[])item_.getBias1_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdCal, (double[])item_.getBias2_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdTestVolts, (double[])item_.getBias2_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdTol, (double[])item_.getBias2_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdValueErr, (double[])item_.getBias2_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdZeroErr, (double[])item_.getBias2_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odCal, (double[])item_.getBias2_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odIMax, (double[])item_.getBias2_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odTol, (double[])item_.getBias2_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odZeroErr, (double[])item_.getBias2_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogCal, (double[])item_.getBias2_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogTestVolts, (double[])item_.getBias2_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogTol, (double[])item_.getBias2_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogValueErr, (double[])item_.getBias2_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogZeroErr, (double[])item_.getBias2_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdCal, (double[])item_.getBias2_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdTestVolts, (double[])item_.getBias2_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdTol, (double[])item_.getBias2_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdValueErr, (double[])item_.getBias2_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdZeroErr, (double[])item_.getBias2_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiAmin, (double[])item_.getClkhiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiQmax, (double[])item_.getClkhiQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliAmin, (double[])item_.getClkliAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliQmax, (double[])item_.getClkliQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clkhIMax, (double[])item_.getDac_clkhIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clklIMax, (double[])item_.getDac_clklIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighCal, (double[])item_.getDac_pclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTestV, (double[])item_.getDac_pclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTol, (double[])item_.getDac_pclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighValueErr, (double[])item_.getDac_pclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighZeroErr, (double[])item_.getDac_pclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowCal, (double[])item_.getDac_pclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTestV, (double[])item_.getDac_pclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTol, (double[])item_.getDac_pclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowValueErr, (double[])item_.getDac_pclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowZeroErr, (double[])item_.getDac_pclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighCal, (double[])item_.getDac_rgHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTestV, (double[])item_.getDac_rgHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTol, (double[])item_.getDac_rgHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighValueErr, (double[])item_.getDac_rgHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighZeroErr, (double[])item_.getDac_rgHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowCal, (double[])item_.getDac_rgLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTestV, (double[])item_.getDac_rgLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTol, (double[])item_.getDac_rgLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowValueErr, (double[])item_.getDac_rgLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowZeroErr, (double[])item_.getDac_rgLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighCal, (double[])item_.getDac_sclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTestV, (double[])item_.getDac_sclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTol, (double[])item_.getDac_sclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighValueErr, (double[])item_.getDac_sclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighZeroErr, (double[])item_.getDac_sclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowCal, (double[])item_.getDac_sclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTestV, (double[])item_.getDac_sclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTol, (double[])item_.getDac_sclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowValueErr, (double[])item_.getDac_sclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowZeroErr, (double[])item_.getDac_sclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])maxDelta, (double[])item_.getMaxDelta(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])maxStep, (double[])item_.getMaxStep(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])minTol, (double[])item_.getMinTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((int[])nPowerOnPub, (int[])item_.getNPowerOnPub());
        Assert.assertArrayEquals((double[])odiAmin, (double[])item_.getOdiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odiQmax, (double[])item_.getOdiQmax(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_timersSettingsAppliedEvent() throws Exception {
        int priority = 144;
        int version = 918;
        String location = "g";
        long[] periodictasks_monitor_check_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)-1885211463);
        long[] periodictasks_monitor_publish_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)1613180437);
        long[] periodictasks_monitor_publish_biasVolt_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)1412909184);
        long[] periodictasks_monitor_publish_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)-835303765);
        long[] periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)363339182);
        long[] periodictasks_monitor_publish_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)1428010062);
        long[] periodictasks_monitor_publish_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)-1929380163);
        long[] periodictasks_monitor_update_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)-220474024);
        long[] periodictasks_monitor_update_biasVolt_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)-1315956059);
        long[] periodictasks_monitor_update_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)-2086939468);
        long[] periodictasks_monitor_update_ccdCurrent_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)-1095846982);
        long[] periodictasks_monitor_update_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)-250089744);
        long[] periodictasks_monitor_update_taskPeriodMillis = TestHelper.generateLongArray((int)3, (int)-1080304154);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_timersSettingsAppliedEvent(priority, version, location, periodictasks_monitor_check_taskPeriodMillis, periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, periodictasks_monitor_publish_biasVolt_taskPeriodMillis, periodictasks_monitor_publish_boardPower_taskPeriodMillis, periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis, periodictasks_monitor_publish_rebTemp_taskPeriodMillis, periodictasks_monitor_publish_taskPeriodMillis, periodictasks_monitor_update_aspicTemp_taskPeriodMillis, periodictasks_monitor_update_biasVolt_taskPeriodMillis, periodictasks_monitor_update_boardPower_taskPeriodMillis, periodictasks_monitor_update_ccdCurrent_taskPeriodMillis, periodictasks_monitor_update_rebTemp_taskPeriodMillis, periodictasks_monitor_update_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_timersSettingsAppliedEvent));
        Focal_plane_Reb_timersSettingsAppliedEvent item_ = (Focal_plane_Reb_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])periodictasks_monitor_check_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_check_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_biasVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_biasVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_ccdCurrent_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_biasVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_biasVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_ccdCurrent_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_ccdCurrent_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_Segment_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 531;
        int version = 231;
        double[] i_warnHi = TestHelper.generateDoubleArray((int)144, (int)-1340508834);
        double[] i_warnLo = TestHelper.generateDoubleArray((int)144, (int)-1624343012);
        double[] i_limitHi = TestHelper.generateDoubleArray((int)144, (int)-1540818842);
        double[] i_limitLo = TestHelper.generateDoubleArray((int)144, (int)-580605806);
        String location = "b";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Segment_LimitsSettingsAppliedEvent(priority, version, i_warnHi, i_warnLo, i_limitHi, i_limitLo, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Segment_LimitsSettingsAppliedEvent));
        Focal_plane_Segment_LimitsSettingsAppliedEvent item_ = (Focal_plane_Segment_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])i_warnHi, (double[])item_.getI_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_warnLo, (double[])item_.getI_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_limitHi, (double[])item_.getI_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_limitLo, (double[])item_.getI_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_DAQSettingsAppliedEvent() throws Exception {
        int priority = 584;
        int version = 726;
        int badPixelAlarmLimit = 648;
        String daqFolder = "k";
        String daqPartition = "o";
        boolean emulatedDAQ = true;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_DAQSettingsAppliedEvent(priority, version, badPixelAlarmLimit, daqFolder, daqPartition, emulatedDAQ));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_DAQSettingsAppliedEvent));
        Focal_plane_SequencerConfig_DAQSettingsAppliedEvent item_ = (Focal_plane_SequencerConfig_DAQSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)badPixelAlarmLimit, (long)item_.getBadPixelAlarmLimit());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
        Assert.assertEquals((Object)emulatedDAQ, (Object)item_.isEmulatedDAQ());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_SequencerSettingsAppliedEvent() throws Exception {
        int priority = 948;
        int version = 462;
        String clearCountParameter = "o";
        String clearMain = "";
        String idleFlushMain = "e";
        long idleFlushTimeout = 873L;
        String integrateMain = "q";
        String metaDataRegisters = "";
        int overCols = 68;
        int overRows = 197;
        int postCols = 123;
        int postRows = 849;
        int preCols = 993;
        int preRows = 917;
        String pseudoReadMain = "";
        int readCols = 784;
        int readCols2 = 467;
        String readMain = "";
        int readRows = 963;
        String rowShiftForwardMain = "";
        String rowShiftReverseMain = "";
        boolean scanMode = false;
        String sequencer = "y";
        String sequencerChecksums = "i";
        String shiftCountParameter = "";
        boolean stepAfterIntegrate = true;
        int transparentMode = 378;
        int underCols = 555;
        boolean useParallelRegisters = true;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_SequencerSettingsAppliedEvent(priority, version, clearCountParameter, clearMain, idleFlushMain, idleFlushTimeout, integrateMain, metaDataRegisters, overCols, overRows, postCols, postRows, preCols, preRows, pseudoReadMain, readCols, readCols2, readMain, readRows, rowShiftForwardMain, rowShiftReverseMain, scanMode, sequencer, sequencerChecksums, shiftCountParameter, stepAfterIntegrate, transparentMode, underCols, useParallelRegisters));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_SequencerSettingsAppliedEvent));
        Focal_plane_SequencerConfig_SequencerSettingsAppliedEvent item_ = (Focal_plane_SequencerConfig_SequencerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)clearCountParameter, (Object)item_.getClearCountParameter());
        Assert.assertEquals((Object)clearMain, (Object)item_.getClearMain());
        Assert.assertEquals((Object)idleFlushMain, (Object)item_.getIdleFlushMain());
        Assert.assertEquals((long)idleFlushTimeout, (long)item_.getIdleFlushTimeout());
        Assert.assertEquals((Object)integrateMain, (Object)item_.getIntegrateMain());
        Assert.assertEquals((Object)metaDataRegisters, (Object)item_.getMetaDataRegisters());
        Assert.assertEquals((long)overCols, (long)item_.getOverCols());
        Assert.assertEquals((long)overRows, (long)item_.getOverRows());
        Assert.assertEquals((long)postCols, (long)item_.getPostCols());
        Assert.assertEquals((long)postRows, (long)item_.getPostRows());
        Assert.assertEquals((long)preCols, (long)item_.getPreCols());
        Assert.assertEquals((long)preRows, (long)item_.getPreRows());
        Assert.assertEquals((Object)pseudoReadMain, (Object)item_.getPseudoReadMain());
        Assert.assertEquals((long)readCols, (long)item_.getReadCols());
        Assert.assertEquals((long)readCols2, (long)item_.getReadCols2());
        Assert.assertEquals((Object)readMain, (Object)item_.getReadMain());
        Assert.assertEquals((long)readRows, (long)item_.getReadRows());
        Assert.assertEquals((Object)rowShiftForwardMain, (Object)item_.getRowShiftForwardMain());
        Assert.assertEquals((Object)rowShiftReverseMain, (Object)item_.getRowShiftReverseMain());
        Assert.assertEquals((Object)scanMode, (Object)item_.isScanMode());
        Assert.assertEquals((Object)sequencer, (Object)item_.getSequencer());
        Assert.assertEquals((Object)sequencerChecksums, (Object)item_.getSequencerChecksums());
        Assert.assertEquals((Object)shiftCountParameter, (Object)item_.getShiftCountParameter());
        Assert.assertEquals((Object)stepAfterIntegrate, (Object)item_.isStepAfterIntegrate());
        Assert.assertEquals((long)transparentMode, (long)item_.getTransparentMode());
        Assert.assertEquals((long)underCols, (long)item_.getUnderCols());
        Assert.assertEquals((Object)useParallelRegisters, (Object)item_.isUseParallelRegisters());
    }

    @Test
    public void sendReceiveFocal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent() throws Exception {
        int priority = 811;
        int version = 716;
        String webHooks = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent(priority, version, webHooks));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent));
        Focal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent item_ = (Focal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)webHooks, (Object)item_.getWebHooks());
    }

    @Test
    public void sendReceiveShutterBladeMotionProfileEvent() throws Exception {
        int priority = 530;
        ShutterBladeMotionProfileEvent.Blade blade = ShutterBladeMotionProfileEvent.Blade.MINUS_X;
        ShutterBladeMotionProfileEvent.Direction direction = ShutterBladeMotionProfileEvent.Direction.OPEN;
        double timestampStart = 0.58169f;
        double startPosition = 0.9305132627487183;
        double targetDuration = 0.49988818168640137;
        double targetPosition = 0.9259874224662781;
        double endPosition = 0.7411353588104248;
        double actualDuration = 0.370410680770874;
        int hallSensorCount = 257;
        double[] timestampHallSensor = TestHelper.generateDoubleArray((int)240, (int)482438521);
        int[] hallSensorID = TestHelper.generateIntArray((int)240, (int)495848102);
        double[] hallSensorPosition = TestHelper.generateDoubleArray((int)240, (int)-2011303117);
        boolean[] hallSensorTransition = new boolean[]{false, false, true, false, false, true, true, true, false, false, true, true, false, false, true, true, true, true, true, true, false, false, true, true, true, true, true, false, false, true, false, false, false, true, false, true, false, true, false, false, false, true, false, false, false, true, false, true, true, false, true, true, true, true, false, true, true, false, true, true, false, true, true, false, true, true, true, true, true, false, false, false, true, false, true, true, false, false, false, false, false, false, false, true, false, true, false, true, true, false, false, true, true, false, false, false, true, false, true, false, true, true, false, false, false, true, false, true, true, true, true, true, true, false, true, false, false, false, true, true, false, false, true, false, false, false, false, true, false, true, true, false, false, true, false, false, true, false, false, false, false, false, true, false, true, false, false, true, true, false, true, true, true, true, true, true, true, false, false, true, true, true, false, false, false, true, true, false, false, false, true, true, false, false, true, true, false, true, true, true, false, true, true, false, false, false, false, false, true, false, true, false, false, false, true, true, true, true, false, false, true, false, false, true, true, true, false, false, false, true, false, false, true, false, false, false, true, true, false, false, false, false, false, true, false, false, true, false, true, false, false, false, true, true, false, false, true, false, false, true};
        int encoderCount = 489;
        double[] timestampEncoder = TestHelper.generateDoubleArray((int)240, (int)1811184419);
        double[] encoderPosition = TestHelper.generateDoubleArray((int)240, (int)2107152593);
        SALEvent item = this.testSendReceive((SALEvent)new ShutterBladeMotionProfileEvent(priority, blade, direction, timestampStart, startPosition, targetDuration, targetPosition, endPosition, actualDuration, hallSensorCount, timestampHallSensor, hallSensorID, hallSensorPosition, hallSensorTransition, encoderCount, timestampEncoder, encoderPosition));
        Assert.assertTrue((boolean)(item instanceof ShutterBladeMotionProfileEvent));
        ShutterBladeMotionProfileEvent item_ = (ShutterBladeMotionProfileEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)blade, (Object)item_.getBlade());
        Assert.assertEquals((Object)direction, (Object)item_.getDirection());
        Assert.assertEquals((double)timestampStart, (double)item_.getTimestampStart(), (double)1.0E-6f);
        Assert.assertEquals((double)startPosition, (double)item_.getStartPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)targetDuration, (double)item_.getTargetDuration(), (double)1.0E-6f);
        Assert.assertEquals((double)targetPosition, (double)item_.getTargetPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)endPosition, (double)item_.getEndPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)actualDuration, (double)item_.getActualDuration(), (double)1.0E-6f);
        Assert.assertEquals((long)hallSensorCount, (long)item_.getHallSensorCount());
        Assert.assertArrayEquals((double[])timestampHallSensor, (double[])item_.getTimestampHallSensor(), (double)1.0E-6f);
        Assert.assertArrayEquals((int[])hallSensorID, (int[])item_.getHallSensorID());
        Assert.assertArrayEquals((double[])hallSensorPosition, (double[])item_.getHallSensorPosition(), (double)1.0E-6f);
        Assert.assertArrayEquals((boolean[])hallSensorTransition, (boolean[])item_.getHallSensorTransition());
        Assert.assertEquals((long)encoderCount, (long)item_.getEncoderCount());
        Assert.assertArrayEquals((double[])timestampEncoder, (double[])item_.getTimestampEncoder(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])encoderPosition, (double[])item_.getEncoderPosition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageStoredEvent() throws Exception {
        int priority = 248;
        String imageName = "zuxqeadhsupp";
        double timestampImageStored = 0.40995967388153076;
        SALEvent item = this.testSendReceive((SALEvent)new ImageStoredEvent(priority, imageName, timestampImageStored));
        Assert.assertTrue((boolean)(item instanceof ImageStoredEvent));
        ImageStoredEvent item_ = (ImageStoredEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampImageStored, (double)item_.getTimestampImageStored(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFitsFilesWrittenEvent() throws Exception {
        int priority = 49;
        String imageName = "tu";
        double timestampFilesWritten = 0.4469099f;
        String rootFileName = "";
        String relativeFileNames = "";
        String fileNode = "j";
        SALEvent item = this.testSendReceive((SALEvent)new FitsFilesWrittenEvent(priority, imageName, timestampFilesWritten, rootFileName, relativeFileNames, fileNode));
        Assert.assertTrue((boolean)(item instanceof FitsFilesWrittenEvent));
        FitsFilesWrittenEvent item_ = (FitsFilesWrittenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampFilesWritten, (double)item_.getTimestampFilesWritten(), (double)1.0E-6f);
        Assert.assertEquals((Object)rootFileName, (Object)item_.getRootFileName());
        Assert.assertEquals((Object)relativeFileNames, (Object)item_.getRelativeFileNames());
        Assert.assertEquals((Object)fileNode, (Object)item_.getFileNode());
    }

    @Test
    public void sendReceiveFileCommandExecutionEvent() throws Exception {
        int priority = 938;
        String imageName = "hhhsohdszawjbsjgdrjuebfzwbdm";
        double timestampCommandComplete = 0.3773950934410095;
        String command = "";
        int rc = 262;
        SALEvent item = this.testSendReceive((SALEvent)new FileCommandExecutionEvent(priority, imageName, timestampCommandComplete, command, rc));
        Assert.assertTrue((boolean)(item instanceof FileCommandExecutionEvent));
        FileCommandExecutionEvent item_ = (FileCommandExecutionEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampCommandComplete, (double)item_.getTimestampCommandComplete(), (double)1.0E-6f);
        Assert.assertEquals((Object)command, (Object)item_.getCommand());
        Assert.assertEquals((long)rc, (long)item_.getRc());
    }

    @Test
    public void sendReceiveImageVisualizationEvent() throws Exception {
        int priority = 857;
        String imageName = "fcmcjgb";
        double timestampVisualizationAvailable = 0.30031102895736694;
        String url = "y";
        String thumbnail = "";
        SALEvent item = this.testSendReceive((SALEvent)new ImageVisualizationEvent(priority, imageName, timestampVisualizationAvailable, url, thumbnail));
        Assert.assertTrue((boolean)(item instanceof ImageVisualizationEvent));
        ImageVisualizationEvent item_ = (ImageVisualizationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampVisualizationAvailable, (double)item_.getTimestampVisualizationAvailable(), (double)1.0E-6f);
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)thumbnail, (Object)item_.getThumbnail());
    }

    @Test
    public void sendReceiveSettingVersionsEvent() throws Exception {
        int priority = 61;
        String recommendedSettingsVersion = "h";
        String recommendedSettingsLabels = "p";
        String settingsUrl = "";
        SALEvent item = this.testSendReceive((SALEvent)new SettingVersionsEvent(priority, recommendedSettingsVersion, recommendedSettingsLabels, settingsUrl));
        Assert.assertTrue((boolean)(item instanceof SettingVersionsEvent));
        SettingVersionsEvent item_ = (SettingVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)recommendedSettingsVersion, (Object)item_.getRecommendedSettingsVersion());
        Assert.assertEquals((Object)recommendedSettingsLabels, (Object)item_.getRecommendedSettingsLabels());
        Assert.assertEquals((Object)settingsUrl, (Object)item_.getSettingsUrl());
    }

    @Test
    public void sendReceiveErrorCodeEvent() throws Exception {
        int priority = 108;
        int errorCode = 478;
        String errorReport = "";
        String traceback = "v";
        SALEvent item = this.testSendReceive((SALEvent)new ErrorCodeEvent(priority, errorCode, errorReport, traceback));
        Assert.assertTrue((boolean)(item instanceof ErrorCodeEvent));
        ErrorCodeEvent item_ = (ErrorCodeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)errorCode, (long)item_.getErrorCode());
        Assert.assertEquals((Object)errorReport, (Object)item_.getErrorReport());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
    }

    @Test
    public void sendReceiveAppliedSettingsMatchStartEvent() throws Exception {
        int priority = 950;
        boolean appliedSettingsMatchStartIsTrue = false;
        SALEvent item = this.testSendReceive((SALEvent)new AppliedSettingsMatchStartEvent(priority, appliedSettingsMatchStartIsTrue));
        Assert.assertTrue((boolean)(item instanceof AppliedSettingsMatchStartEvent));
        AppliedSettingsMatchStartEvent item_ = (AppliedSettingsMatchStartEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)appliedSettingsMatchStartIsTrue, (Object)item_.isAppliedSettingsMatchStartIsTrue());
    }

    @Test
    public void sendReceiveLogLevelEvent() throws Exception {
        int priority = 37;
        int level = 513;
        String subsystem = "w";
        SALEvent item = this.testSendReceive((SALEvent)new LogLevelEvent(priority, level, subsystem));
        Assert.assertTrue((boolean)(item instanceof LogLevelEvent));
        LogLevelEvent item_ = (LogLevelEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)subsystem, (Object)item_.getSubsystem());
    }

    @Test
    public void sendReceiveLogMessageEvent() throws Exception {
        int priority = 185;
        String name = "";
        int level = 813;
        String message = "";
        String traceback = "";
        String filePath = "j";
        String functionName = "r";
        int lineNumber = 45;
        int process = 377;
        double timestamp = 0.4011055827140808;
        SALEvent item = this.testSendReceive((SALEvent)new LogMessageEvent(priority, name, level, message, traceback, filePath, functionName, lineNumber, process, timestamp));
        Assert.assertTrue((boolean)(item instanceof LogMessageEvent));
        LogMessageEvent item_ = (LogMessageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)name, (Object)item_.getName());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)message, (Object)item_.getMessage());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
        Assert.assertEquals((Object)filePath, (Object)item_.getFilePath());
        Assert.assertEquals((Object)functionName, (Object)item_.getFunctionName());
        Assert.assertEquals((long)lineNumber, (long)item_.getLineNumber());
        Assert.assertEquals((long)process, (long)item_.getProcess());
        Assert.assertEquals((double)timestamp, (double)item_.getTimestamp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveSettingsAppliedEvent() throws Exception {
        int priority = 389;
        String settingsVersion = "qyzdkbqolftkmqgbyctwbyltjtpojslrvqygvliyeusxsqvhxqmallgvbdariwdizmdsvaneypwtbyenawpytbxhivepqbdefckdrfcozg";
        String otherSettingsEvents = "a";
        SALEvent item = this.testSendReceive((SALEvent)new SettingsAppliedEvent(priority, settingsVersion, otherSettingsEvents));
        Assert.assertTrue((boolean)(item instanceof SettingsAppliedEvent));
        SettingsAppliedEvent item_ = (SettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)settingsVersion, (Object)item_.getSettingsVersion());
        Assert.assertEquals((Object)otherSettingsEvents, (Object)item_.getOtherSettingsEvents());
    }

    @Test
    public void sendReceiveSimulationModeEvent() throws Exception {
        int priority = 347;
        int mode = 780;
        SALEvent item = this.testSendReceive((SALEvent)new SimulationModeEvent(priority, mode));
        Assert.assertTrue((boolean)(item instanceof SimulationModeEvent));
        SimulationModeEvent item_ = (SimulationModeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)mode, (long)item_.getMode());
    }

    @Test
    public void sendReceiveSoftwareVersionsEvent() throws Exception {
        int priority = 735;
        String salVersion = "ohyctjrzkxdjnzdsbmrjrckapmqzuhhkmmbxwypgnofrlqqqgquqmsygenfjxopcqrhqrccyewhzxmdehlhlmiwtdxkzrfomsurydqxqozc";
        String xmlVersion = "ofzqdggsj";
        String openSpliceVersion = "xvpszaitezrfzkvrdhfkeetaxqziiovpskmlwnjnoiawtuhibihxbvpovachsqojgomkvavxjzzgbttqkigmaslshbykwcsezaahoocmquqfwmvrdbfeynqgwjzutjtmiyxpissbjddrmakxmojjd";
        String cscVersion = "bbzotfrlryprfqrguaogxhsahtelupqwmsvgajfmwfnumigypsarrrkxbyzisqsbcumlkunzntlqkozzteykzmlxingxgntzwjdexucfshqoqmubaqjgvonhclnycssainytyqauucnsfckvdpshelccrmtoirzxqyoopzziiswvnrfolwdtagkeleuhhbztttdrsfjbgqdfsneofx";
        String subsystemVersions = "k";
        SALEvent item = this.testSendReceive((SALEvent)new SoftwareVersionsEvent(priority, salVersion, xmlVersion, openSpliceVersion, cscVersion, subsystemVersions));
        Assert.assertTrue((boolean)(item instanceof SoftwareVersionsEvent));
        SoftwareVersionsEvent item_ = (SoftwareVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)salVersion, (Object)item_.getSalVersion());
        Assert.assertEquals((Object)xmlVersion, (Object)item_.getXmlVersion());
        Assert.assertEquals((Object)openSpliceVersion, (Object)item_.getOpenSpliceVersion());
        Assert.assertEquals((Object)cscVersion, (Object)item_.getCscVersion());
        Assert.assertEquals((Object)subsystemVersions, (Object)item_.getSubsystemVersions());
    }

    @Test
    public void sendReceiveHeartbeatEvent() throws Exception {
        int priority = 773;
        boolean heartbeat = true;
        SALEvent item = this.testSendReceive((SALEvent)new HeartbeatEvent(priority, heartbeat));
        Assert.assertTrue((boolean)(item instanceof HeartbeatEvent));
        HeartbeatEvent item_ = (HeartbeatEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
    }

    @Test
    public void sendReceiveAuthListEvent() throws Exception {
        int priority = 833;
        String authorizedUsers = "s";
        String nonAuthorizedCSCs = "";
        SALEvent item = this.testSendReceive((SALEvent)new AuthListEvent(priority, authorizedUsers, nonAuthorizedCSCs));
        Assert.assertTrue((boolean)(item instanceof AuthListEvent));
        AuthListEvent item_ = (AuthListEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)authorizedUsers, (Object)item_.getAuthorizedUsers());
        Assert.assertEquals((Object)nonAuthorizedCSCs, (Object)item_.getNonAuthorizedCSCs());
    }

    @Test
    public void sendReceiveLargeFileObjectAvailableEvent() throws Exception {
        int priority = 563;
        String url = "wmkxgioicdkgcpziuossdxmcxmlcxrosfkxcodszzakszruqckzqjtwiovgnykacsg";
        String generator = "xhlgvhxrnqlwqlejqqincqyaheyukoixjxrficebtxgewpomwrufkjqfrgndwfaycrneiehwmdnkemwkgpehebirroscmsbtbwmgstsefxwruvrdbodloqasmdcokepctsdwlymchhttylhhxwrlwkcpyijysskjxrrbjnryaliwzsjmpudytfuylhcmrbjcningvartwwolaefsgtqejkkqkiuxlogpawfuzgzhufvenutyztafirdzwezdwvbf";
        float version = 0.18300074f;
        int byteSize = 605;
        String checkSum = "prlnrkqddbwrhvcsgxkvgxpyxswzqpkaaqntloobhdkxrkxdoxagtoomlxvilfeafgnmwlmwphvexpbnsmshrgmbqpwemntzhumcznkheakygpmdfxqopslcwnprkthvghnlwdyztmjwojbermijzrsugxcznshxbbtujhdqwaesuwjzonoflujbkrmfaseypuateyavqbiwaeiyblxsffhsxbfemtixzzoinvduzyp";
        String mimeType = "wioookemrfdiqxrcngqmmgbluuyuybarqvaodqvcxfplcga";
        String id = "zhdyxrnhpkgqirnwuwnujzcujqpkwcbzsdjarsbqvbgwxscukmhfkvqaejcefntgkyiuhnfalzpqqkkokltcreubjixkmrcvzdjlmmfgbwnevlxwssmvgkyhmaeggadfjzvqlkw";
        SALEvent item = this.testSendReceive((SALEvent)new LargeFileObjectAvailableEvent(priority, url, generator, version, byteSize, checkSum, mimeType, id));
        Assert.assertTrue((boolean)(item instanceof LargeFileObjectAvailableEvent));
        LargeFileObjectAvailableEvent item_ = (LargeFileObjectAvailableEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)generator, (Object)item_.getGenerator());
        Assert.assertEquals((float)version, (float)item_.getVersion(), (float)1.0E-6f);
        Assert.assertEquals((long)byteSize, (long)item_.getByteSize());
        Assert.assertEquals((Object)checkSum, (Object)item_.getCheckSum());
        Assert.assertEquals((Object)mimeType, (Object)item_.getMimeType());
        Assert.assertEquals((Object)id, (Object)item_.getId());
    }
}

