package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class ImageVisualizationEvent extends CameraEvent {
  private final String imageName;

  private final double timestampVisualizationAvailable;

  private final String url;

  private final String thumbnail;

  public ImageVisualizationEvent(int priority, String imageName,
      double timestampVisualizationAvailable, String url, String thumbnail) {
    super (priority);
    this.imageName = imageName;
    this.timestampVisualizationAvailable = timestampVisualizationAvailable;
    this.url = url;
    this.thumbnail = thumbnail;
  }

  public String getImageName() {
    return imageName;
  }

  public double getTimestampVisualizationAvailable() {
    return timestampVisualizationAvailable;
  }

  public String getUrl() {
    return url;
  }

  public String getThumbnail() {
    return thumbnail;
  }

  @Override
  public String toString() {
    return "ImageVisualizationEvent{" + "imageName=" + imageName +
        ", timestampVisualizationAvailable=" + timestampVisualizationAvailable +", url=" + url +
        ", thumbnail=" + thumbnail +"}";
  }
}
