package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class Fcs_StepperMotor_MotorSettingsAppliedEvent extends CameraEvent {
  private final int version;

  private final int accelRamp;

  private final boolean backOff;

  private final int brakeRamp;

  private final int iPhase;

  private final int iPhaseStill;

  private final int maxJerkAccel;

  private final int maxJerkBrake;

  private final double maxRampTime;

  private final int minStepFreq;

  private final int quickRamp;

  private final int rampType;

  private final int reverseClearance;

  private final int stepFreq;

  private final int stepMode;

  public Fcs_StepperMotor_MotorSettingsAppliedEvent(int priority, int version, int accelRamp,
      boolean backOff, int brakeRamp, int iPhase, int iPhaseStill, int maxJerkAccel,
      int maxJerkBrake, double maxRampTime, int minStepFreq, int quickRamp, int rampType,
      int reverseClearance, int stepFreq, int stepMode) {
    super (priority);
    this.version = version;
    this.accelRamp = accelRamp;
    this.backOff = backOff;
    this.brakeRamp = brakeRamp;
    this.iPhase = iPhase;
    this.iPhaseStill = iPhaseStill;
    this.maxJerkAccel = maxJerkAccel;
    this.maxJerkBrake = maxJerkBrake;
    this.maxRampTime = maxRampTime;
    this.minStepFreq = minStepFreq;
    this.quickRamp = quickRamp;
    this.rampType = rampType;
    this.reverseClearance = reverseClearance;
    this.stepFreq = stepFreq;
    this.stepMode = stepMode;
  }

  public int getVersion() {
    return version;
  }

  public int getAccelRamp() {
    return accelRamp;
  }

  public boolean isBackOff() {
    return backOff;
  }

  public int getBrakeRamp() {
    return brakeRamp;
  }

  public int getIPhase() {
    return iPhase;
  }

  public int getIPhaseStill() {
    return iPhaseStill;
  }

  public int getMaxJerkAccel() {
    return maxJerkAccel;
  }

  public int getMaxJerkBrake() {
    return maxJerkBrake;
  }

  public double getMaxRampTime() {
    return maxRampTime;
  }

  public int getMinStepFreq() {
    return minStepFreq;
  }

  public int getQuickRamp() {
    return quickRamp;
  }

  public int getRampType() {
    return rampType;
  }

  public int getReverseClearance() {
    return reverseClearance;
  }

  public int getStepFreq() {
    return stepFreq;
  }

  public int getStepMode() {
    return stepMode;
  }

  @Override
  public String toString() {
    return "Fcs_StepperMotor_MotorSettingsAppliedEvent{" + "version=" + version +
        ", accelRamp=" + accelRamp +", backOff=" + backOff +", brakeRamp=" + brakeRamp +
        ", iPhase=" + iPhase +", iPhaseStill=" + iPhaseStill +", maxJerkAccel=" + maxJerkAccel +
        ", maxJerkBrake=" + maxJerkBrake +", maxRampTime=" + maxRampTime +
        ", minStepFreq=" + minStepFreq +", quickRamp=" + quickRamp +", rampType=" + rampType +
        ", reverseClearance=" + reverseClearance +", stepFreq=" + stepFreq +
        ", stepMode=" + stepMode +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private int version;

    private int accelRamp;

    private boolean backOff;

    private int brakeRamp;

    private int iPhase;

    private int iPhaseStill;

    private int maxJerkAccel;

    private int maxJerkBrake;

    private double maxRampTime;

    private int minStepFreq;

    private int quickRamp;

    private int rampType;

    private int reverseClearance;

    private int stepFreq;

    private int stepMode;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder version(int version) {
      this.version = version;
      return this;
    }

    public Builder accelRamp(int accelRamp) {
      this.accelRamp = accelRamp;
      return this;
    }

    public Builder backOff(boolean backOff) {
      this.backOff = backOff;
      return this;
    }

    public Builder brakeRamp(int brakeRamp) {
      this.brakeRamp = brakeRamp;
      return this;
    }

    public Builder iPhase(int iPhase) {
      this.iPhase = iPhase;
      return this;
    }

    public Builder iPhaseStill(int iPhaseStill) {
      this.iPhaseStill = iPhaseStill;
      return this;
    }

    public Builder maxJerkAccel(int maxJerkAccel) {
      this.maxJerkAccel = maxJerkAccel;
      return this;
    }

    public Builder maxJerkBrake(int maxJerkBrake) {
      this.maxJerkBrake = maxJerkBrake;
      return this;
    }

    public Builder maxRampTime(double maxRampTime) {
      this.maxRampTime = maxRampTime;
      return this;
    }

    public Builder minStepFreq(int minStepFreq) {
      this.minStepFreq = minStepFreq;
      return this;
    }

    public Builder quickRamp(int quickRamp) {
      this.quickRamp = quickRamp;
      return this;
    }

    public Builder rampType(int rampType) {
      this.rampType = rampType;
      return this;
    }

    public Builder reverseClearance(int reverseClearance) {
      this.reverseClearance = reverseClearance;
      return this;
    }

    public Builder stepFreq(int stepFreq) {
      this.stepFreq = stepFreq;
      return this;
    }

    public Builder stepMode(int stepMode) {
      this.stepMode = stepMode;
      return this;
    }

    public Fcs_StepperMotor_MotorSettingsAppliedEvent build() {
      return new Fcs_StepperMotor_MotorSettingsAppliedEvent(priority, version, accelRamp, backOff, brakeRamp, iPhase, iPhaseStill, maxJerkAccel, maxJerkBrake, maxRampTime, minStepFreq, quickRamp, rampType, reverseClearance, stepFreq, stepMode);
    }
  }
}
