package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class Vacuum_Cryo_CryoconSettingsAppliedEvent extends CameraEvent {
  private final int version;

  private final double d_gain;

  private final double i_gain;

  private final double p_gain;

  public Vacuum_Cryo_CryoconSettingsAppliedEvent(int priority, int version, double d_gain,
      double i_gain, double p_gain) {
    super (priority);
    this.version = version;
    this.d_gain = d_gain;
    this.i_gain = i_gain;
    this.p_gain = p_gain;
  }

  public int getVersion() {
    return version;
  }

  public double getD_gain() {
    return d_gain;
  }

  public double getI_gain() {
    return i_gain;
  }

  public double getP_gain() {
    return p_gain;
  }

  @Override
  public String toString() {
    return "Vacuum_Cryo_CryoconSettingsAppliedEvent{" + "version=" + version +", d_gain=" + d_gain +
        ", i_gain=" + i_gain +", p_gain=" + p_gain +"}";
  }
}
