package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class Rebpower_PeriodicTasks_timersSettingsAppliedEvent extends CameraEvent {
  private final int version;

  private final long agentmonitorservice_taskPeriodMillis;

  private final long heartbeat_taskPeriodMillis;

  private final long monitor_check_taskPeriodMillis;

  private final long monitor_publish_taskPeriodMillis;

  private final long monitor_update_taskPeriodMillis;

  private final long reb_power_state_taskPeriodMillis;

  private final long runtimeinfo_taskPeriodMillis;

  public Rebpower_PeriodicTasks_timersSettingsAppliedEvent(int priority, int version,
      long agentmonitorservice_taskPeriodMillis, long heartbeat_taskPeriodMillis,
      long monitor_check_taskPeriodMillis, long monitor_publish_taskPeriodMillis,
      long monitor_update_taskPeriodMillis, long reb_power_state_taskPeriodMillis,
      long runtimeinfo_taskPeriodMillis) {
    super (priority);
    this.version = version;
    this.agentmonitorservice_taskPeriodMillis = agentmonitorservice_taskPeriodMillis;
    this.heartbeat_taskPeriodMillis = heartbeat_taskPeriodMillis;
    this.monitor_check_taskPeriodMillis = monitor_check_taskPeriodMillis;
    this.monitor_publish_taskPeriodMillis = monitor_publish_taskPeriodMillis;
    this.monitor_update_taskPeriodMillis = monitor_update_taskPeriodMillis;
    this.reb_power_state_taskPeriodMillis = reb_power_state_taskPeriodMillis;
    this.runtimeinfo_taskPeriodMillis = runtimeinfo_taskPeriodMillis;
  }

  public int getVersion() {
    return version;
  }

  public long getAgentmonitorservice_taskPeriodMillis() {
    return agentmonitorservice_taskPeriodMillis;
  }

  public long getHeartbeat_taskPeriodMillis() {
    return heartbeat_taskPeriodMillis;
  }

  public long getMonitor_check_taskPeriodMillis() {
    return monitor_check_taskPeriodMillis;
  }

  public long getMonitor_publish_taskPeriodMillis() {
    return monitor_publish_taskPeriodMillis;
  }

  public long getMonitor_update_taskPeriodMillis() {
    return monitor_update_taskPeriodMillis;
  }

  public long getReb_power_state_taskPeriodMillis() {
    return reb_power_state_taskPeriodMillis;
  }

  public long getRuntimeinfo_taskPeriodMillis() {
    return runtimeinfo_taskPeriodMillis;
  }

  @Override
  public String toString() {
    return "Rebpower_PeriodicTasks_timersSettingsAppliedEvent{" + "version=" + version +
        ", agentmonitorservice_taskPeriodMillis=" + agentmonitorservice_taskPeriodMillis +
        ", heartbeat_taskPeriodMillis=" + heartbeat_taskPeriodMillis +
        ", monitor_check_taskPeriodMillis=" + monitor_check_taskPeriodMillis +
        ", monitor_publish_taskPeriodMillis=" + monitor_publish_taskPeriodMillis +
        ", monitor_update_taskPeriodMillis=" + monitor_update_taskPeriodMillis +
        ", reb_power_state_taskPeriodMillis=" + reb_power_state_taskPeriodMillis +
        ", runtimeinfo_taskPeriodMillis=" + runtimeinfo_taskPeriodMillis +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private int version;

    private long agentmonitorservice_taskPeriodMillis;

    private long heartbeat_taskPeriodMillis;

    private long monitor_check_taskPeriodMillis;

    private long monitor_publish_taskPeriodMillis;

    private long monitor_update_taskPeriodMillis;

    private long reb_power_state_taskPeriodMillis;

    private long runtimeinfo_taskPeriodMillis;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder version(int version) {
      this.version = version;
      return this;
    }

    public Builder agentmonitorservice_taskPeriodMillis(long agentmonitorservice_taskPeriodMillis) {
      this.agentmonitorservice_taskPeriodMillis = agentmonitorservice_taskPeriodMillis;
      return this;
    }

    public Builder heartbeat_taskPeriodMillis(long heartbeat_taskPeriodMillis) {
      this.heartbeat_taskPeriodMillis = heartbeat_taskPeriodMillis;
      return this;
    }

    public Builder monitor_check_taskPeriodMillis(long monitor_check_taskPeriodMillis) {
      this.monitor_check_taskPeriodMillis = monitor_check_taskPeriodMillis;
      return this;
    }

    public Builder monitor_publish_taskPeriodMillis(long monitor_publish_taskPeriodMillis) {
      this.monitor_publish_taskPeriodMillis = monitor_publish_taskPeriodMillis;
      return this;
    }

    public Builder monitor_update_taskPeriodMillis(long monitor_update_taskPeriodMillis) {
      this.monitor_update_taskPeriodMillis = monitor_update_taskPeriodMillis;
      return this;
    }

    public Builder reb_power_state_taskPeriodMillis(long reb_power_state_taskPeriodMillis) {
      this.reb_power_state_taskPeriodMillis = reb_power_state_taskPeriodMillis;
      return this;
    }

    public Builder runtimeinfo_taskPeriodMillis(long runtimeinfo_taskPeriodMillis) {
      this.runtimeinfo_taskPeriodMillis = runtimeinfo_taskPeriodMillis;
      return this;
    }

    public Rebpower_PeriodicTasks_timersSettingsAppliedEvent build() {
      return new Rebpower_PeriodicTasks_timersSettingsAppliedEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, reb_power_state_taskPeriodMillis, runtimeinfo_taskPeriodMillis);
    }
  }
}
