package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class Daq_monitor_StoreSettingsAppliedEvent extends CameraEvent {
  private final int version;

  private final String daqFolder;

  private final boolean enableAutoPurge;

  private final double purgeTarget;

  private final double purgeThreshold;

  public Daq_monitor_StoreSettingsAppliedEvent(int priority, int version, String daqFolder,
      boolean enableAutoPurge, double purgeTarget, double purgeThreshold) {
    super (priority);
    this.version = version;
    this.daqFolder = daqFolder;
    this.enableAutoPurge = enableAutoPurge;
    this.purgeTarget = purgeTarget;
    this.purgeThreshold = purgeThreshold;
  }

  public int getVersion() {
    return version;
  }

  public String getDaqFolder() {
    return daqFolder;
  }

  public boolean isEnableAutoPurge() {
    return enableAutoPurge;
  }

  public double getPurgeTarget() {
    return purgeTarget;
  }

  public double getPurgeThreshold() {
    return purgeThreshold;
  }

  @Override
  public String toString() {
    return "Daq_monitor_StoreSettingsAppliedEvent{" + "version=" + version +
        ", daqFolder=" + daqFolder +", enableAutoPurge=" + enableAutoPurge +
        ", purgeTarget=" + purgeTarget +", purgeThreshold=" + purgeThreshold +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private int version;

    private String daqFolder;

    private boolean enableAutoPurge;

    private double purgeTarget;

    private double purgeThreshold;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder version(int version) {
      this.version = version;
      return this;
    }

    public Builder daqFolder(String daqFolder) {
      this.daqFolder = daqFolder;
      return this;
    }

    public Builder enableAutoPurge(boolean enableAutoPurge) {
      this.enableAutoPurge = enableAutoPurge;
      return this;
    }

    public Builder purgeTarget(double purgeTarget) {
      this.purgeTarget = purgeTarget;
      return this;
    }

    public Builder purgeThreshold(double purgeThreshold) {
      this.purgeThreshold = purgeThreshold;
      return this;
    }

    public Daq_monitor_StoreSettingsAppliedEvent build() {
      return new Daq_monitor_StoreSettingsAppliedEvent(priority, version, daqFolder, enableAutoPurge, purgeTarget, purgeThreshold);
    }
  }
}
