/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.cccamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Vacuum_TurboTelemetry
extends CameraTelemetry {
    private final double rpm;
    private final double power;
    private final double voltage;
    private final double pumpTemperature;
    private final double status;
    private final double cntrlrSinkTemperature;
    private final double driveFrequency;
    private final double current;
    private final double cntrlrAirTemperature;

    public Vacuum_TurboTelemetry(double rpm, double power, double voltage, double pumpTemperature, double status, double cntrlrSinkTemperature, double driveFrequency, double current, double cntrlrAirTemperature) {
        this.rpm = rpm;
        this.power = power;
        this.voltage = voltage;
        this.pumpTemperature = pumpTemperature;
        this.status = status;
        this.cntrlrSinkTemperature = cntrlrSinkTemperature;
        this.driveFrequency = driveFrequency;
        this.current = current;
        this.cntrlrAirTemperature = cntrlrAirTemperature;
    }

    public double getRpm() {
        return this.rpm;
    }

    public double getPower() {
        return this.power;
    }

    public double getVoltage() {
        return this.voltage;
    }

    public double getPumpTemperature() {
        return this.pumpTemperature;
    }

    public double getStatus() {
        return this.status;
    }

    public double getCntrlrSinkTemperature() {
        return this.cntrlrSinkTemperature;
    }

    public double getDriveFrequency() {
        return this.driveFrequency;
    }

    public double getCurrent() {
        return this.current;
    }

    public double getCntrlrAirTemperature() {
        return this.cntrlrAirTemperature;
    }

    public String toString() {
        return "Vacuum_TurboTelemetry{rpm=" + this.rpm + ", power=" + this.power + ", voltage=" + this.voltage + ", pumpTemperature=" + this.pumpTemperature + ", status=" + this.status + ", cntrlrSinkTemperature=" + this.cntrlrSinkTemperature + ", driveFrequency=" + this.driveFrequency + ", current=" + this.current + ", cntrlrAirTemperature=" + this.cntrlrAirTemperature + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private double rpm;
        private double power;
        private double voltage;
        private double pumpTemperature;
        private double status;
        private double cntrlrSinkTemperature;
        private double driveFrequency;
        private double current;
        private double cntrlrAirTemperature;

        private Builder() {
        }

        public Builder rpm(double rpm) {
            this.rpm = rpm;
            return this;
        }

        public Builder power(double power) {
            this.power = power;
            return this;
        }

        public Builder voltage(double voltage) {
            this.voltage = voltage;
            return this;
        }

        public Builder pumpTemperature(double pumpTemperature) {
            this.pumpTemperature = pumpTemperature;
            return this;
        }

        public Builder status(double status) {
            this.status = status;
            return this;
        }

        public Builder cntrlrSinkTemperature(double cntrlrSinkTemperature) {
            this.cntrlrSinkTemperature = cntrlrSinkTemperature;
            return this;
        }

        public Builder driveFrequency(double driveFrequency) {
            this.driveFrequency = driveFrequency;
            return this;
        }

        public Builder current(double current) {
            this.current = current;
            return this;
        }

        public Builder cntrlrAirTemperature(double cntrlrAirTemperature) {
            this.cntrlrAirTemperature = cntrlrAirTemperature;
            return this;
        }

        public Vacuum_TurboTelemetry build() {
            return new Vacuum_TurboTelemetry(this.rpm, this.power, this.voltage, this.pumpTemperature, this.status, this.cntrlrSinkTemperature, this.driveFrequency, this.current, this.cntrlrAirTemperature);
        }
    }
}

