package org.lsst.sal.cccamera.telemetry;

import java.util.Arrays;
import org.lsst.sal.camera.CameraTelemetry;

public class Fp_CcdTelemetry extends CameraTelemetry {
  private final double[] gDV;

  private final String location;

  private final double[] oDV;

  private final double[] oGV;

  private final double[] rDV;

  private final double[] temp;

  public Fp_CcdTelemetry(double[] gDV, String location, double[] oDV, double[] oGV, double[] rDV,
      double[] temp) {
    this.gDV = gDV;
    this.location = location;
    this.oDV = oDV;
    this.oGV = oGV;
    this.rDV = rDV;
    this.temp = temp;
  }

  public double[] getGDV() {
    return gDV;
  }

  public String getLocation() {
    return location;
  }

  public double[] getODV() {
    return oDV;
  }

  public double[] getOGV() {
    return oGV;
  }

  public double[] getRDV() {
    return rDV;
  }

  public double[] getTemp() {
    return temp;
  }

  @Override
  public String toString() {
    return "Fp_CcdTelemetry{" + "gDV=" + Arrays.toString(gDV) +", location=" + location +
        ", oDV=" + Arrays.toString(oDV) +", oGV=" + Arrays.toString(oGV) +
        ", rDV=" + Arrays.toString(rDV) +", temp=" + Arrays.toString(temp) +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double[] gDV;

    private String location;

    private double[] oDV;

    private double[] oGV;

    private double[] rDV;

    private double[] temp;

    private Builder() {
    }

    public Builder gDV(double[] gDV) {
      this.gDV = gDV;
      return this;
    }

    public Builder location(String location) {
      this.location = location;
      return this;
    }

    public Builder oDV(double[] oDV) {
      this.oDV = oDV;
      return this;
    }

    public Builder oGV(double[] oGV) {
      this.oGV = oGV;
      return this;
    }

    public Builder rDV(double[] rDV) {
      this.rDV = rDV;
      return this;
    }

    public Builder temp(double[] temp) {
      this.temp = temp;
      return this;
    }

    public Fp_CcdTelemetry build() {
      return new Fp_CcdTelemetry(gDV, location, oDV, oGV, rDV, temp);
    }
  }
}
