package org.lsst.sal.cccamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class FilterChangerTelemetry extends CameraTelemetry {
  private final float motorTemperature;

  private final float motorEncoder;

  private final float linearPosition;

  public FilterChangerTelemetry(float motorTemperature, float motorEncoder, float linearPosition) {
    this.motorTemperature = motorTemperature;
    this.motorEncoder = motorEncoder;
    this.linearPosition = linearPosition;
  }

  public float getMotorTemperature() {
    return motorTemperature;
  }

  public float getMotorEncoder() {
    return motorEncoder;
  }

  public float getLinearPosition() {
    return linearPosition;
  }

  @Override
  public String toString() {
    return "FilterChangerTelemetry{" + "motorTemperature=" + motorTemperature +
        ", motorEncoder=" + motorEncoder +", linearPosition=" + linearPosition +"}";
  }
}
