package org.lsst.sal.cccamera.event;

import org.lsst.sal.camera.CameraEvent;

public class FocalPlaneRaftTempControlSettingsAppliedEvent extends CameraEvent {
  private final int version;

  private final String raftLocation;

  private final double raft_TempControl_awGain;

  private final double raft_TempControl_basePower;

  private final double raft_TempControl_gain;

  private final double raft_TempControl_maxInput;

  private final double raft_TempControl_maxOutput;

  private final double raft_TempControl_minInput;

  private final double raft_TempControl_minOutput;

  private final String raft_TempControl_rebs;

  private final double raft_TempControl_setTemp;

  private final double raft_TempControl_smoothTime;

  private final String raft_TempControl_tempChans;

  private final double raft_TempControl_timeConst;

  private final double raft_TempControl_tolerance;

  public FocalPlaneRaftTempControlSettingsAppliedEvent(int priority, int version,
      String raftLocation, double raft_TempControl_awGain, double raft_TempControl_basePower,
      double raft_TempControl_gain, double raft_TempControl_maxInput,
      double raft_TempControl_maxOutput, double raft_TempControl_minInput,
      double raft_TempControl_minOutput, String raft_TempControl_rebs,
      double raft_TempControl_setTemp, double raft_TempControl_smoothTime,
      String raft_TempControl_tempChans, double raft_TempControl_timeConst,
      double raft_TempControl_tolerance) {
    super (priority);
    this.version = version;
    this.raftLocation = raftLocation;
    this.raft_TempControl_awGain = raft_TempControl_awGain;
    this.raft_TempControl_basePower = raft_TempControl_basePower;
    this.raft_TempControl_gain = raft_TempControl_gain;
    this.raft_TempControl_maxInput = raft_TempControl_maxInput;
    this.raft_TempControl_maxOutput = raft_TempControl_maxOutput;
    this.raft_TempControl_minInput = raft_TempControl_minInput;
    this.raft_TempControl_minOutput = raft_TempControl_minOutput;
    this.raft_TempControl_rebs = raft_TempControl_rebs;
    this.raft_TempControl_setTemp = raft_TempControl_setTemp;
    this.raft_TempControl_smoothTime = raft_TempControl_smoothTime;
    this.raft_TempControl_tempChans = raft_TempControl_tempChans;
    this.raft_TempControl_timeConst = raft_TempControl_timeConst;
    this.raft_TempControl_tolerance = raft_TempControl_tolerance;
  }

  public int getVersion() {
    return version;
  }

  public String getRaftLocation() {
    return raftLocation;
  }

  public double getRaft_TempControl_awGain() {
    return raft_TempControl_awGain;
  }

  public double getRaft_TempControl_basePower() {
    return raft_TempControl_basePower;
  }

  public double getRaft_TempControl_gain() {
    return raft_TempControl_gain;
  }

  public double getRaft_TempControl_maxInput() {
    return raft_TempControl_maxInput;
  }

  public double getRaft_TempControl_maxOutput() {
    return raft_TempControl_maxOutput;
  }

  public double getRaft_TempControl_minInput() {
    return raft_TempControl_minInput;
  }

  public double getRaft_TempControl_minOutput() {
    return raft_TempControl_minOutput;
  }

  public String getRaft_TempControl_rebs() {
    return raft_TempControl_rebs;
  }

  public double getRaft_TempControl_setTemp() {
    return raft_TempControl_setTemp;
  }

  public double getRaft_TempControl_smoothTime() {
    return raft_TempControl_smoothTime;
  }

  public String getRaft_TempControl_tempChans() {
    return raft_TempControl_tempChans;
  }

  public double getRaft_TempControl_timeConst() {
    return raft_TempControl_timeConst;
  }

  public double getRaft_TempControl_tolerance() {
    return raft_TempControl_tolerance;
  }

  @Override
  public String toString() {
    return "FocalPlaneRaftTempControlSettingsAppliedEvent{" + "version=" + version +
        ", raftLocation=" + raftLocation +", raft_TempControl_awGain=" + raft_TempControl_awGain +
        ", raft_TempControl_basePower=" + raft_TempControl_basePower +
        ", raft_TempControl_gain=" + raft_TempControl_gain +
        ", raft_TempControl_maxInput=" + raft_TempControl_maxInput +
        ", raft_TempControl_maxOutput=" + raft_TempControl_maxOutput +
        ", raft_TempControl_minInput=" + raft_TempControl_minInput +
        ", raft_TempControl_minOutput=" + raft_TempControl_minOutput +
        ", raft_TempControl_rebs=" + raft_TempControl_rebs +
        ", raft_TempControl_setTemp=" + raft_TempControl_setTemp +
        ", raft_TempControl_smoothTime=" + raft_TempControl_smoothTime +
        ", raft_TempControl_tempChans=" + raft_TempControl_tempChans +
        ", raft_TempControl_timeConst=" + raft_TempControl_timeConst +
        ", raft_TempControl_tolerance=" + raft_TempControl_tolerance +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private int version;

    private String raftLocation;

    private double raft_TempControl_awGain;

    private double raft_TempControl_basePower;

    private double raft_TempControl_gain;

    private double raft_TempControl_maxInput;

    private double raft_TempControl_maxOutput;

    private double raft_TempControl_minInput;

    private double raft_TempControl_minOutput;

    private String raft_TempControl_rebs;

    private double raft_TempControl_setTemp;

    private double raft_TempControl_smoothTime;

    private String raft_TempControl_tempChans;

    private double raft_TempControl_timeConst;

    private double raft_TempControl_tolerance;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder version(int version) {
      this.version = version;
      return this;
    }

    public Builder raftLocation(String raftLocation) {
      this.raftLocation = raftLocation;
      return this;
    }

    public Builder raft_TempControl_awGain(double raft_TempControl_awGain) {
      this.raft_TempControl_awGain = raft_TempControl_awGain;
      return this;
    }

    public Builder raft_TempControl_basePower(double raft_TempControl_basePower) {
      this.raft_TempControl_basePower = raft_TempControl_basePower;
      return this;
    }

    public Builder raft_TempControl_gain(double raft_TempControl_gain) {
      this.raft_TempControl_gain = raft_TempControl_gain;
      return this;
    }

    public Builder raft_TempControl_maxInput(double raft_TempControl_maxInput) {
      this.raft_TempControl_maxInput = raft_TempControl_maxInput;
      return this;
    }

    public Builder raft_TempControl_maxOutput(double raft_TempControl_maxOutput) {
      this.raft_TempControl_maxOutput = raft_TempControl_maxOutput;
      return this;
    }

    public Builder raft_TempControl_minInput(double raft_TempControl_minInput) {
      this.raft_TempControl_minInput = raft_TempControl_minInput;
      return this;
    }

    public Builder raft_TempControl_minOutput(double raft_TempControl_minOutput) {
      this.raft_TempControl_minOutput = raft_TempControl_minOutput;
      return this;
    }

    public Builder raft_TempControl_rebs(String raft_TempControl_rebs) {
      this.raft_TempControl_rebs = raft_TempControl_rebs;
      return this;
    }

    public Builder raft_TempControl_setTemp(double raft_TempControl_setTemp) {
      this.raft_TempControl_setTemp = raft_TempControl_setTemp;
      return this;
    }

    public Builder raft_TempControl_smoothTime(double raft_TempControl_smoothTime) {
      this.raft_TempControl_smoothTime = raft_TempControl_smoothTime;
      return this;
    }

    public Builder raft_TempControl_tempChans(String raft_TempControl_tempChans) {
      this.raft_TempControl_tempChans = raft_TempControl_tempChans;
      return this;
    }

    public Builder raft_TempControl_timeConst(double raft_TempControl_timeConst) {
      this.raft_TempControl_timeConst = raft_TempControl_timeConst;
      return this;
    }

    public Builder raft_TempControl_tolerance(double raft_TempControl_tolerance) {
      this.raft_TempControl_tolerance = raft_TempControl_tolerance;
      return this;
    }

    public FocalPlaneRaftTempControlSettingsAppliedEvent build() {
      return new FocalPlaneRaftTempControlSettingsAppliedEvent(priority, version, raftLocation, raft_TempControl_awGain, raft_TempControl_basePower, raft_TempControl_gain, raft_TempControl_maxInput, raft_TempControl_maxOutput, raft_TempControl_minInput, raft_TempControl_minOutput, raft_TempControl_rebs, raft_TempControl_setTemp, raft_TempControl_smoothTime, raft_TempControl_tempChans, raft_TempControl_timeConst, raft_TempControl_tolerance);
    }
  }
}
