/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.cccamera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AuthListEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.CCSConfiguredEvent;
import org.lsst.sal.camera.event.EndInitializeGuiderEvent;
import org.lsst.sal.camera.event.EndInitializeImageEvent;
import org.lsst.sal.camera.event.EndLoadFilterEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndUnloadFilterEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.FocalPlaneSummaryInfoEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.LogLevelEvent;
import org.lsst.sal.camera.event.LogMessageEvent;
import org.lsst.sal.camera.event.NotReadyToTakeImageEvent;
import org.lsst.sal.camera.event.PrepareToTakeImageEvent;
import org.lsst.sal.camera.event.ReadyToTakeImageEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartLoadFilterEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartRotateCarouselEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.event.StartUnloadFilterEvent;
import org.lsst.sal.cccamera.CCCamera;
import org.lsst.sal.cccamera.event.Daq_monitorSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Daq_monitor_StatsSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.Daq_monitor_StoreSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.EndTakeImageEvent;
import org.lsst.sal.cccamera.event.FileCommandExecutionEvent;
import org.lsst.sal.cccamera.event.FitsFilesWrittenEvent;
import org.lsst.sal.cccamera.event.FocalPlaneDAQSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.FocalPlaneHardwareIdSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.FocalPlaneRaftTempControlSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.FocalPlaneRaftTempControlStatusSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.FocalPlaneRebRaftsPowerSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.FocalPlaneRebRaftsSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.FocalPlaneSequencerConfigSettingsAppliedEvent;
import org.lsst.sal.cccamera.event.ImageStoredEvent;
import org.lsst.sal.cccamera.event.ImageVisualizationEvent;
import org.lsst.sal.cccamera.event.ShutterBladeMotionProfileEvent;

public class EventSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = CCCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALEvent testSendReceive(SALEvent item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALEvent> future = executor.submit(() -> sal.getNextEvent(Duration.ofSeconds(10L)));
        try {
            sal.logEvent(item);
            SALEvent sALEvent = future.get(10L, TimeUnit.SECONDS);
            return sALEvent;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws Exception {
        int priority = 495;
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 74;
        String imageName = "irsmhnddyrhmpolaa";
        int imageIndex = 337;
        String imageSource = "";
        String imageController = "g";
        String imageDate = "ejj";
        int imageNumber = 172;
        double timestampAcquisitionStart = 0.4246455430984497;
        double requestedExposureTime = 0.9393898248672485;
        double timestampEndOfReadout = 0.9142882227897644;
        SALEvent item = this.testSendReceive((SALEvent)new EndReadoutEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, requestedExposureTime, timestampEndOfReadout));
        Assert.assertTrue((boolean)(item instanceof EndReadoutEvent));
        EndReadoutEvent item_ = (EndReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)requestedExposureTime, (double)item_.getRequestedExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampEndOfReadout, (double)item_.getTimestampEndOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndTakeImageEvent() throws Exception {
        int priority = 794;
        SALEvent item = this.testSendReceive((SALEvent)new EndTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndTakeImageEvent));
        EndTakeImageEvent item_ = (EndTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartSetFilterEvent() throws Exception {
        int priority = 676;
        String filterName = "c";
        String filterType = "w";
        SALEvent item = this.testSendReceive((SALEvent)new StartSetFilterEvent(priority, filterName, filterType));
        Assert.assertTrue((boolean)(item instanceof StartSetFilterEvent));
        StartSetFilterEvent item_ = (StartSetFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
    }

    @Test
    public void sendReceiveStartUnloadFilterEvent() throws Exception {
        int priority = 588;
        double timestampTransition = 0.942844569683075;
        SALEvent item = this.testSendReceive((SALEvent)new StartUnloadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartUnloadFilterEvent));
        StartUnloadFilterEvent item_ = (StartUnloadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveNotReadyToTakeImageEvent() throws Exception {
        int priority = 783;
        double timestampTransition = 0.86098313331604;
        SALEvent item = this.testSendReceive((SALEvent)new NotReadyToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof NotReadyToTakeImageEvent));
        NotReadyToTakeImageEvent item_ = (NotReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws Exception {
        int priority = 27;
        double timestampTransition = 0.5015073418617249;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterCloseEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterCloseEvent));
        StartShutterCloseEvent item_ = (StartShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeGuiderEvent() throws Exception {
        int priority = 231;
        double timestampTransition = 0.354770302772522;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeGuiderEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndInitializeGuiderEvent));
        EndInitializeGuiderEvent item_ = (EndInitializeGuiderEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws Exception {
        int priority = 675;
        double timestampTransition = 0.8005862236022949;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterCloseEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterCloseEvent));
        EndShutterCloseEvent item_ = (EndShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws Exception {
        int priority = 648;
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 787;
        String imageName = "anwcangdisqfvxuqwqysi";
        int imageIndex = 184;
        String imageSource = "";
        String imageController = "m";
        String imageDate = "yjrzx";
        int imageNumber = 796;
        double timestampAcquisitionStart = 0.8657287359237671;
        double exposureTime = 0.4734336733818054;
        String imageTag = "namoaezfanauhnnootuhjusprpmldiutxsqcaageu";
        double timestampDateObs = 0.6832115650177002;
        double timestampDateEnd = 0.3940030336380005;
        double measuredShutterOpenTime = 0.46446192264556885;
        double darkTime = 0.6667547225952148;
        SALEvent item = this.testSendReceive((SALEvent)new EndOfImageTelemetryEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, measuredShutterOpenTime, darkTime));
        Assert.assertTrue((boolean)(item instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent item_ = (EndOfImageTelemetryEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageTag, (Object)item_.getImageTag());
        Assert.assertEquals((double)timestampDateObs, (double)item_.getTimestampDateObs(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampDateEnd, (double)item_.getTimestampDateEnd(), (double)1.0E-6f);
        Assert.assertEquals((double)measuredShutterOpenTime, (double)item_.getMeasuredShutterOpenTime(), (double)1.0E-6f);
        Assert.assertEquals((double)darkTime, (double)item_.getDarkTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndUnloadFilterEvent() throws Exception {
        int priority = 859;
        double timestampTransition = 0.05614161491394043;
        SALEvent item = this.testSendReceive((SALEvent)new EndUnloadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndUnloadFilterEvent));
        EndUnloadFilterEvent item_ = (EndUnloadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndRotateCarouselEvent() throws Exception {
        int priority = 498;
        double timestampTransition = 0.2241965f;
        SALEvent item = this.testSendReceive((SALEvent)new EndRotateCarouselEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndRotateCarouselEvent));
        EndRotateCarouselEvent item_ = (EndRotateCarouselEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartLoadFilterEvent() throws Exception {
        int priority = 270;
        double timestampTransition = 0.3308407f;
        SALEvent item = this.testSendReceive((SALEvent)new StartLoadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartLoadFilterEvent));
        StartLoadFilterEvent item_ = (StartLoadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveReadyToTakeImageEvent() throws Exception {
        int priority = 835;
        double timestampTransition = 0.19930672645568848;
        SALEvent item = this.testSendReceive((SALEvent)new ReadyToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof ReadyToTakeImageEvent));
        ReadyToTakeImageEvent item_ = (ReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePrepareToTakeImageEvent() throws Exception {
        int priority = 163;
        double timestampTransition = 0.29876023530960083;
        SALEvent item = this.testSendReceive((SALEvent)new PrepareToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof PrepareToTakeImageEvent));
        PrepareToTakeImageEvent item_ = (PrepareToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveCCSConfiguredEvent() throws Exception {
        int priority = 21;
        double timestampTransition = 0.9616172313690186;
        SALEvent item = this.testSendReceive((SALEvent)new CCSConfiguredEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof CCSConfiguredEvent));
        CCSConfiguredEvent item_ = (CCSConfiguredEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndLoadFilterEvent() throws Exception {
        int priority = 267;
        double timestampTransition = 0.5977584719657898;
        SALEvent item = this.testSendReceive((SALEvent)new EndLoadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndLoadFilterEvent));
        EndLoadFilterEvent item_ = (EndLoadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws Exception {
        int priority = 128;
        double timestampTransition = 0.5300258994102478;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterOpenEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterOpenEvent));
        EndShutterOpenEvent item_ = (EndShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartIntegrationEvent() throws Exception {
        int priority = 521;
        String additionalKeys = "a";
        String additionalValues = "j";
        int imagesInSequence = 533;
        String imageName = "y";
        int imageIndex = 892;
        String imageSource = "r";
        String imageController = "j";
        String imageDate = "wrtkaig";
        int imageNumber = 453;
        double timestampAcquisitionStart = 0.637143075466156;
        double exposureTime = 0.6292307376861572;
        SALEvent item = this.testSendReceive((SALEvent)new StartIntegrationEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime));
        Assert.assertTrue((boolean)(item instanceof StartIntegrationEvent));
        StartIntegrationEvent item_ = (StartIntegrationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeImageEvent() throws Exception {
        int priority = 988;
        double timestampTransition = 0.36793702840805054;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndInitializeImageEvent));
        EndInitializeImageEvent item_ = (EndInitializeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndSetFilterEvent() throws Exception {
        int priority = 665;
        String filterName = "";
        String filterType = "";
        int filterSlot = 78;
        double filterPosition = 0.2701908349990845;
        SALEvent item = this.testSendReceive((SALEvent)new EndSetFilterEvent(priority, filterName, filterType, filterSlot, filterPosition));
        Assert.assertTrue((boolean)(item instanceof EndSetFilterEvent));
        EndSetFilterEvent item_ = (EndSetFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
        Assert.assertEquals((long)filterSlot, (long)item_.getFilterSlot());
        Assert.assertEquals((double)filterPosition, (double)item_.getFilterPosition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws Exception {
        int priority = 543;
        double timestampTransition = 0.1770975f;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterOpenEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterOpenEvent));
        StartShutterOpenEvent item_ = (StartShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAvailableFiltersEvent() throws Exception {
        int priority = 546;
        String filterNames = "ojhymuggilkxlhgpseuuibuyrlojdhzqoveaoljumwxnuioaorfjzvnqofqitxyuovvu";
        SALEvent item = this.testSendReceive((SALEvent)new AvailableFiltersEvent(priority, filterNames));
        Assert.assertTrue((boolean)(item instanceof AvailableFiltersEvent));
        AvailableFiltersEvent item_ = (AvailableFiltersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterNames, (Object)item_.getFilterNames());
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws Exception {
        int priority = 876;
        String additionalKeys = "r";
        String additionalValues = "";
        int imagesInSequence = 755;
        String imageName = "zcmd";
        int imageIndex = 801;
        String imageSource = "dr";
        String imageController = "g";
        String imageDate = "elsctwtz";
        int imageNumber = 265;
        double timestampAcquisitionStart = 0.575219452381134;
        double exposureTime = 0.4674455523490906;
        double timestampStartOfReadout = 0.5843941569328308;
        SALEvent item = this.testSendReceive((SALEvent)new StartReadoutEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, timestampStartOfReadout));
        Assert.assertTrue((boolean)(item instanceof StartReadoutEvent));
        StartReadoutEvent item_ = (StartReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampStartOfReadout, (double)item_.getTimestampStartOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartRotateCarouselEvent() throws Exception {
        int priority = 448;
        double timestampTransition = 0.026497721672058105;
        SALEvent item = this.testSendReceive((SALEvent)new StartRotateCarouselEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartRotateCarouselEvent));
        StartRotateCarouselEvent item_ = (StartRotateCarouselEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws Exception {
        int priority = 756;
        String imageName = "";
        String ccdLocation = "j";
        String raftBay = "e";
        String ccdSlot = "";
        Object[] ccdType = new ImageReadoutParametersEvent.CcdType[]{ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V};
        int[] overRows = new int[]{378, 923, 751, 299, 529, 171, 412, 610, 181};
        int[] overCols = new int[]{375, 653, 264, 100, 943, 927, 283, 299, 56};
        int[] readRows = new int[]{404, 560, 283, 288, 935, 822, 888, 682, 757};
        int[] readCols = new int[]{270, 991, 10, 743, 610, 663, 509, 972, 823};
        int[] readCols2 = new int[]{321, 888, 515, 768, 714, 396, 311, 680, 255};
        int[] preCols = new int[]{563, 635, 28, 871, 538, 68, 163, 812, 618};
        int[] preRows = new int[]{246, 50, 459, 692, 630, 680, 116, 305, 95};
        int[] postCols = new int[]{979, 907, 203, 345, 934, 444, 484, 523, 472};
        int[] underCols = new int[]{966, 449, 177, 97, 638, 218, 945, 75, 796};
        String daqFolder = "r";
        String daqAnnotation = "";
        SALEvent item = this.testSendReceive((SALEvent)new ImageReadoutParametersEvent(priority, imageName, ccdLocation, raftBay, ccdSlot, (ImageReadoutParametersEvent.CcdType[])ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols, underCols, daqFolder, daqAnnotation));
        Assert.assertTrue((boolean)(item instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent item_ = (ImageReadoutParametersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((int[])overRows, (int[])item_.getOverRows());
        Assert.assertArrayEquals((int[])overCols, (int[])item_.getOverCols());
        Assert.assertArrayEquals((int[])readRows, (int[])item_.getReadRows());
        Assert.assertArrayEquals((int[])readCols, (int[])item_.getReadCols());
        Assert.assertArrayEquals((int[])readCols2, (int[])item_.getReadCols2());
        Assert.assertArrayEquals((int[])preCols, (int[])item_.getPreCols());
        Assert.assertArrayEquals((int[])preRows, (int[])item_.getPreRows());
        Assert.assertArrayEquals((int[])postCols, (int[])item_.getPostCols());
        Assert.assertArrayEquals((int[])underCols, (int[])item_.getUnderCols());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqAnnotation, (Object)item_.getDaqAnnotation());
    }

    @Test
    public void sendReceiveFocalPlaneSummaryInfoEvent() throws Exception {
        int priority = 570;
        String ccdLocation = "e";
        String raftBay = "l";
        String ccdSlot = "";
        String rebSerialNumber = "";
        String rebLSSTName = "e";
        String ccdLSSTName = "p";
        String raftLSSTName = "";
        String ccdManSerNum = "e";
        String ccdManufacturer = "";
        Object[] ccdType = new FocalPlaneSummaryInfoEvent.CcdType[]{FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL};
        double[] ccdTempSetPoint = new double[]{0.010107755661010742, 0.4159959554672241, 0.18105238676071167, 0.5045515298843384, 0.002496778964996338, 0.3206069f, 0.5314055681228638, 0.7548640966415405, 0.3945449f};
        String sequencerKey = "";
        String sequencerChecksum = "";
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneSummaryInfoEvent(priority, ccdLocation, raftBay, ccdSlot, rebSerialNumber, rebLSSTName, ccdLSSTName, raftLSSTName, ccdManSerNum, ccdManufacturer, (FocalPlaneSummaryInfoEvent.CcdType[])ccdType, ccdTempSetPoint, sequencerKey, sequencerChecksum));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneSummaryInfoEvent));
        FocalPlaneSummaryInfoEvent item_ = (FocalPlaneSummaryInfoEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)rebSerialNumber, (Object)item_.getRebSerialNumber());
        Assert.assertEquals((Object)rebLSSTName, (Object)item_.getRebLSSTName());
        Assert.assertEquals((Object)ccdLSSTName, (Object)item_.getCcdLSSTName());
        Assert.assertEquals((Object)raftLSSTName, (Object)item_.getRaftLSSTName());
        Assert.assertEquals((Object)ccdManSerNum, (Object)item_.getCcdManSerNum());
        Assert.assertEquals((Object)ccdManufacturer, (Object)item_.getCcdManufacturer());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((double[])ccdTempSetPoint, (double[])item_.getCcdTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((Object)sequencerKey, (Object)item_.getSequencerKey());
        Assert.assertEquals((Object)sequencerChecksum, (Object)item_.getSequencerChecksum());
    }

    @Test
    public void sendReceiveFocalPlaneHardwareIdSettingsAppliedEvent() throws Exception {
        int priority = 322;
        int version = 972;
        String rebLocation = "";
        String rebLSSTName = "";
        String ccdLocation = "";
        String ccdLSSTName = "f";
        String ccdManSerNum = "n";
        String raftLocation = "";
        String raftLSSTName = "l";
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneHardwareIdSettingsAppliedEvent(priority, version, rebLocation, rebLSSTName, ccdLocation, ccdLSSTName, ccdManSerNum, raftLocation, raftLSSTName));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneHardwareIdSettingsAppliedEvent));
        FocalPlaneHardwareIdSettingsAppliedEvent item_ = (FocalPlaneHardwareIdSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)rebLocation, (Object)item_.getRebLocation());
        Assert.assertEquals((Object)rebLSSTName, (Object)item_.getRebLSSTName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)ccdLSSTName, (Object)item_.getCcdLSSTName());
        Assert.assertEquals((Object)ccdManSerNum, (Object)item_.getCcdManSerNum());
        Assert.assertEquals((Object)raftLocation, (Object)item_.getRaftLocation());
        Assert.assertEquals((Object)raftLSSTName, (Object)item_.getRaftLSSTName());
    }

    @Test
    public void sendReceiveFocalPlaneRaftTempControlStatusSettingsAppliedEvent() throws Exception {
        int priority = 822;
        int version = 293;
        String raftLocation = "v";
        boolean raft_TempControl_active = false;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneRaftTempControlStatusSettingsAppliedEvent(priority, version, raftLocation, raft_TempControl_active));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneRaftTempControlStatusSettingsAppliedEvent));
        FocalPlaneRaftTempControlStatusSettingsAppliedEvent item_ = (FocalPlaneRaftTempControlStatusSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)raftLocation, (Object)item_.getRaftLocation());
        Assert.assertEquals((Object)raft_TempControl_active, (Object)item_.isRaft_TempControl_active());
    }

    @Test
    public void sendReceiveFocalPlaneRaftTempControlSettingsAppliedEvent() throws Exception {
        int priority = 677;
        int version = 483;
        String raftLocation = "";
        double raft_TempControl_awGain = 0.2364257f;
        double raft_TempControl_basePower = 0.06057637929916382;
        double raft_TempControl_gain = 0.2795097231864929;
        double raft_TempControl_maxInput = 0.6227433681488037;
        double raft_TempControl_maxOutput = 0.5955899357795715;
        double raft_TempControl_minInput = 0.07762682437896729;
        double raft_TempControl_minOutput = 0.22366827726364136;
        String raft_TempControl_rebs = "j";
        double raft_TempControl_setTemp = 0.8549120426177979;
        double raft_TempControl_smoothTime = 0.041434288024902344;
        String raft_TempControl_tempChans = "";
        double raft_TempControl_timeConst = 0.8218094706535339;
        double raft_TempControl_tolerance = 0.8981080651283264;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneRaftTempControlSettingsAppliedEvent(priority, version, raftLocation, raft_TempControl_awGain, raft_TempControl_basePower, raft_TempControl_gain, raft_TempControl_maxInput, raft_TempControl_maxOutput, raft_TempControl_minInput, raft_TempControl_minOutput, raft_TempControl_rebs, raft_TempControl_setTemp, raft_TempControl_smoothTime, raft_TempControl_tempChans, raft_TempControl_timeConst, raft_TempControl_tolerance));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneRaftTempControlSettingsAppliedEvent));
        FocalPlaneRaftTempControlSettingsAppliedEvent item_ = (FocalPlaneRaftTempControlSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)raftLocation, (Object)item_.getRaftLocation());
        Assert.assertEquals((double)raft_TempControl_awGain, (double)item_.getRaft_TempControl_awGain(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_basePower, (double)item_.getRaft_TempControl_basePower(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_gain, (double)item_.getRaft_TempControl_gain(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_maxInput, (double)item_.getRaft_TempControl_maxInput(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_maxOutput, (double)item_.getRaft_TempControl_maxOutput(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_minInput, (double)item_.getRaft_TempControl_minInput(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_minOutput, (double)item_.getRaft_TempControl_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((Object)raft_TempControl_rebs, (Object)item_.getRaft_TempControl_rebs());
        Assert.assertEquals((double)raft_TempControl_setTemp, (double)item_.getRaft_TempControl_setTemp(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_smoothTime, (double)item_.getRaft_TempControl_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)raft_TempControl_tempChans, (Object)item_.getRaft_TempControl_tempChans());
        Assert.assertEquals((double)raft_TempControl_timeConst, (double)item_.getRaft_TempControl_timeConst(), (double)1.0E-6f);
        Assert.assertEquals((double)raft_TempControl_tolerance, (double)item_.getRaft_TempControl_tolerance(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocalPlaneDAQSettingsAppliedEvent() throws Exception {
        int priority = 24;
        int version = 485;
        String daqFolder = "i";
        String daqPartition = "";
        boolean emulatedDAQ = false;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneDAQSettingsAppliedEvent(priority, version, daqFolder, daqPartition, emulatedDAQ));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneDAQSettingsAppliedEvent));
        FocalPlaneDAQSettingsAppliedEvent item_ = (FocalPlaneDAQSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
        Assert.assertEquals((Object)emulatedDAQ, (Object)item_.isEmulatedDAQ());
    }

    @Test
    public void sendReceiveFocalPlaneSequencerConfigSettingsAppliedEvent() throws Exception {
        int priority = 373;
        String clearCountParameter = "c";
        String clearMain = "v";
        String idleFlushMain = "e";
        String integrateMain = "";
        String metaDataRegisters = "";
        int overCols = 785;
        int overRows = 184;
        int postCols = 551;
        int postRows = 326;
        int preCols = 36;
        int preRows = 190;
        String pseudoReadMain = "";
        int readCols = 170;
        int readCols2 = 743;
        String readMain = "";
        int readRows = 434;
        String rowShiftForwardMain = "";
        String rowShiftReverseMain = "";
        boolean scanMode = true;
        String sequencer = "s";
        String sequencerChecksums = "";
        String shiftCountParameter = "";
        int transparentMode = 947;
        int underCols = 281;
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneSequencerConfigSettingsAppliedEvent(priority, clearCountParameter, clearMain, idleFlushMain, integrateMain, metaDataRegisters, overCols, overRows, postCols, postRows, preCols, preRows, pseudoReadMain, readCols, readCols2, readMain, readRows, rowShiftForwardMain, rowShiftReverseMain, scanMode, sequencer, sequencerChecksums, shiftCountParameter, transparentMode, underCols));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneSequencerConfigSettingsAppliedEvent));
        FocalPlaneSequencerConfigSettingsAppliedEvent item_ = (FocalPlaneSequencerConfigSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)clearCountParameter, (Object)item_.getClearCountParameter());
        Assert.assertEquals((Object)clearMain, (Object)item_.getClearMain());
        Assert.assertEquals((Object)idleFlushMain, (Object)item_.getIdleFlushMain());
        Assert.assertEquals((Object)integrateMain, (Object)item_.getIntegrateMain());
        Assert.assertEquals((Object)metaDataRegisters, (Object)item_.getMetaDataRegisters());
        Assert.assertEquals((long)overCols, (long)item_.getOverCols());
        Assert.assertEquals((long)overRows, (long)item_.getOverRows());
        Assert.assertEquals((long)postCols, (long)item_.getPostCols());
        Assert.assertEquals((long)postRows, (long)item_.getPostRows());
        Assert.assertEquals((long)preCols, (long)item_.getPreCols());
        Assert.assertEquals((long)preRows, (long)item_.getPreRows());
        Assert.assertEquals((Object)pseudoReadMain, (Object)item_.getPseudoReadMain());
        Assert.assertEquals((long)readCols, (long)item_.getReadCols());
        Assert.assertEquals((long)readCols2, (long)item_.getReadCols2());
        Assert.assertEquals((Object)readMain, (Object)item_.getReadMain());
        Assert.assertEquals((long)readRows, (long)item_.getReadRows());
        Assert.assertEquals((Object)rowShiftForwardMain, (Object)item_.getRowShiftForwardMain());
        Assert.assertEquals((Object)rowShiftReverseMain, (Object)item_.getRowShiftReverseMain());
        Assert.assertEquals((Object)scanMode, (Object)item_.isScanMode());
        Assert.assertEquals((Object)sequencer, (Object)item_.getSequencer());
        Assert.assertEquals((Object)sequencerChecksums, (Object)item_.getSequencerChecksums());
        Assert.assertEquals((Object)shiftCountParameter, (Object)item_.getShiftCountParameter());
        Assert.assertEquals((long)transparentMode, (long)item_.getTransparentMode());
        Assert.assertEquals((long)underCols, (long)item_.getUnderCols());
    }

    @Test
    public void sendReceiveFocalPlaneRebRaftsSettingsAppliedEvent() throws Exception {
        int priority = 691;
        int version = 84;
        double[] bias0_csGateP = new double[]{0.6142090559005737, 0.8862087726593018, 0.15819251537322998, 0.8272294402122498, 0.3811434f, 0.7041372656822205, 0.5663792490959167, 0.5089836716651917, 0.4212055802345276};
        double[] bias0_gdP = new double[]{0.6497701406478882, 0.3321990370750427, 0.546629011631012, 0.03093355894088745, 0.8810170888900757, 0.770524263381958, 0.19247084856033325, 0.6888233423233032, 0.8093852400779724};
        double[] bias0_odP = new double[]{0.7401184439659119, 0.2639627f, 0.9439328908920288, 0.5324458479881287, 0.6846141219139099, 0.08638501167297363, 0.3942340612411499, 0.1649875044822693, 0.9467206597328186};
        double[] bias0_ogP = new double[]{0.6553415060043335, 0.6646828651428223, 0.9512182474136353, 0.9245601296424866, 0.01287013292312622, 0.0018898248672485352, 0.13100403547286987, 0.5621614456176758, 0.348626971244812};
        double[] bias0_rdP = new double[]{0.2438182234764099, 0.0923229455947876, 0.8818138241767883, 0.5860308408737183, 0.6875885128974915, 0.41382116079330444, 0.06423187255859375, 0.3067221f, 0.7203307151794434};
        double[] bias1_csGateP = new double[]{0.4826417565345764, 0.6439829468727112, 0.497566282749176, 0.9668222069740295, 0.663765013217926, 0.033656537532806396, 0.2932351231575012, 0.37873637676239014, 0.6512604355812073};
        double[] bias1_gdP = new double[]{0.03273433446884155, 0.23275268077850342, 0.8946744203567505, 0.0055582523345947266, 0.5685842633247375, 0.4770635962486267, 0.5543696880340576, 0.7836690545082092, 0.40061742067337036};
        double[] bias1_odP = new double[]{0.4515455961227417, 0.786760687828064, 0.11390924453735352, 0.27820414304733276, 0.8154560327529907, 0.8078804016113281, 0.01894927f, 0.3528527021408081, 0.9307073354721069};
        double[] bias1_ogP = new double[]{0.974181592464447, 0.41983598470687866, 0.9204593300819397, 0.844366192817688, 0.6191104650497437, 0.18111753463745117, 0.6157971620559692, 0.5302456617355347, 0.45018547773361206};
        double[] bias1_rdP = new double[]{0.1085214f, 0.44511836767196655, 0.9004220366477966, 0.36087822914123535, 0.7641117572784424, 0.8607092499732971, 0.12108564376831055, 0.39221322536468506, 0.8009426593780518};
        double[] bias2_csGateP = new double[]{0.9310056567192078, 0.6005901098251343, 0.20480185747146606, 0.674481213092804, 0.40960294008255005, 0.7907758355140686, 0.450225293636322, 0.19921225309371948, 0.6649788618087769};
        double[] bias2_gdP = new double[]{0.6136229634284973, 0.784142255783081, 0.5766582489013672, 0.3993929f, 0.9301658272743225, 0.380687f, 0.5195137858390808, 0.4002823829650879, 0.37163597345352173};
        double[] bias2_odP = new double[]{0.8927491903305054, 0.6827614307403564, 0.16119670867919922, 0.9963732957839966, 0.07531487941741943, 0.2367112f, 0.6531934142112732, 0.3906674385070801, 0.2345457673072815};
        double[] bias2_ogP = new double[]{0.482200026512146, 0.2835758328437805, 0.8459919691085815, 0.2846637964248657, 0.5211543440818787, 0.7494170665740967, 0.29583287239074707, 0.25458717346191406, 0.2159196138381958};
        double[] bias2_rdP = new double[]{0.07165837287902832, 0.53737473487854, 0.3688596487045288, 0.7609010338783264, 0.2154766321182251, 0.4796936511993408, 0.380581796169281, 0.8659494519233704, 0.8885037302970886};
        double[] dac_pclkHighP = new double[]{0.4119594097137451, 0.2212618f, 0.7315186858177185, 0.02538210153579712, 0.5617164969444275, 0.5828642249107361, 0.05298245f, 0.17073094844818115, 0.08198577165603638};
        double[] dac_pclkLowP = new double[]{0.10556250810623169, 0.300825834274292, 0.15915173292160034, 0.4622097f, 0.021161377429962158, 0.5130382180213928, 0.7473477721214294, 0.6755883693695068, 0.5228105187416077};
        double[] dac_rgHighP = new double[]{0.037378907203674316, 0.9072979688644409, 0.9558776617050171, 0.688093900680542, 0.7588313817977905, 0.4588811993598938, 0.3201286196708679, 0.3820696473121643, 0.7292030453681946};
        double[] dac_rgLowP = new double[]{0.36418086290359497, 0.02814584970474243, 0.382207453250885, 0.12228578329086304, 0.973324716091156, 0.38076627254486084, 0.6869021058082581, 0.6132139563560486, 0.5931679606437683};
        double[] dac_sclkHighP = new double[]{0.22166311740875244, 0.04742974042892456, 0.6217074990272522, 0.1260806918144226, 0.41364985704421997, 0.6695913672447205, 0.06597131490707397, 0.01783144474029541, 0.4308992028236389};
        double[] dac_sclkLowP = new double[]{0.5011999607086182, 4.4840574264526367E-4, 0.07299137115478516, 0.14174103736877441, 0.8059961199760437, 0.6128490567207336, 0.6959515810012817, 0.2795097231864929, 0.8401201963424683};
        boolean[] disableRTDHardwareCheck = new boolean[]{true, false, false, false, false, false, false, false, true};
        String location = "";
        int[] serialNum = new int[]{605, 880, 253, 235, 553, 355, 719, 230, 441};
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneRebRaftsSettingsAppliedEvent(priority, version, bias0_csGateP, bias0_gdP, bias0_odP, bias0_ogP, bias0_rdP, bias1_csGateP, bias1_gdP, bias1_odP, bias1_ogP, bias1_rdP, bias2_csGateP, bias2_gdP, bias2_odP, bias2_ogP, bias2_rdP, dac_pclkHighP, dac_pclkLowP, dac_rgHighP, dac_rgLowP, dac_sclkHighP, dac_sclkLowP, disableRTDHardwareCheck, location, serialNum));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneRebRaftsSettingsAppliedEvent));
        FocalPlaneRebRaftsSettingsAppliedEvent item_ = (FocalPlaneRebRaftsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_csGateP, (double[])item_.getBias0_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdP, (double[])item_.getBias0_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odP, (double[])item_.getBias0_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogP, (double[])item_.getBias0_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdP, (double[])item_.getBias0_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_csGateP, (double[])item_.getBias1_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdP, (double[])item_.getBias1_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odP, (double[])item_.getBias1_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogP, (double[])item_.getBias1_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdP, (double[])item_.getBias1_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_csGateP, (double[])item_.getBias2_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdP, (double[])item_.getBias2_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odP, (double[])item_.getBias2_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogP, (double[])item_.getBias2_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdP, (double[])item_.getBias2_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighP, (double[])item_.getDac_pclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowP, (double[])item_.getDac_pclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighP, (double[])item_.getDac_rgHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowP, (double[])item_.getDac_rgLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighP, (double[])item_.getDac_sclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowP, (double[])item_.getDac_sclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((boolean[])disableRTDHardwareCheck, (boolean[])item_.getDisableRTDHardwareCheck());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((int[])serialNum, (int[])item_.getSerialNum());
    }

    @Test
    public void sendReceiveFocalPlaneRebRaftsPowerSettingsAppliedEvent() throws Exception {
        int priority = 318;
        int version = 679;
        double[] bias0_gdCal = new double[]{0.7912827730178833, 0.7242476940155029, 0.674912691116333, 0.16533923149108887, 0.2855575f, 0.7123373746871948, 0.2191150188446045, 0.5070011615753174, 0.40193772315979004};
        double[] bias0_gdTestVolts = new double[]{0.3482709527015686, 0.90446937084198, 0.5560566782951355, 0.02749556303024292, 0.08437883853912354, 0.7347772717475891, 0.8349572420120239, 0.05315440893173218, 0.8198965191841125};
        double[] bias0_gdTol = new double[]{0.5077343583106995, 0.7708647847175598, 0.2524857521057129, 0.9283267855644226, 0.4557059407234192, 0.08200287818908691, 0.8293628096580505, 0.8970068693161011, 0.2322337031364441};
        double[] bias0_gdValueErr = new double[]{0.659993f, 0.9325717687606812, 0.4854145050048828, 0.18520653247833252, 0.35989898443222046, 0.22506767511367798, 0.14500826597213745, 0.10195744037628174, 0.7472650408744812};
        double[] bias0_gdZeroErr = new double[]{0.7284701466560364, 0.5455885529518127, 0.8110129237174988, 0.19291293621063232, 0.7421621084213257, 0.09804767370223999, 0.4464316964149475, 0.3112324f, 0.15415281057357788};
        double[] bias0_odCal = new double[]{0.6058251857757568, 0.10584050416946411, 0.8688523173332214, 0.05147433280944824, 0.7004167437553406, 0.6102726459503174, 0.16373854875564575, 0.2257222f, 0.6810241937637329};
        double[] bias0_odIMax = new double[]{0.1661999225616455, 0.9088693857192993, 0.11945706605911255, 0.2741441f, 0.766837f, 0.7217692732810974, 0.5272254347801208, 0.7229553461074829, 0.9956062436103821};
        double[] bias0_odTol = new double[]{0.9965223670005798, 0.14721661806106567, 0.4042872190475464, 0.6199347376823425, 0.746765673160553, 0.9629706144332886, 0.8263643383979797, 0.6142929196357727, 0.6880226731300354};
        double[] bias0_odZeroErr = new double[]{0.6466214656829834, 0.6851903200149536, 0.41917216777801514, 0.5601454377174377, 0.33406996726989746, 0.5312292575836182, 0.7347690463066101, 0.36329346895217896, 0.4870149f};
        double[] bias0_ogCal = new double[]{0.22898507118225098, 0.6373441815376282, 0.6345996856689453, 0.276350736618042, 0.5662907958030701, 0.4810322f, 0.17140984535217285, 0.2860983610153198, 0.2018665075302124};
        double[] bias0_ogTestVolts = new double[]{0.8623965978622437, 0.2078021764755249, 0.027436554431915283, 0.3213622570037842, 0.8489788770675659, 0.17418742179870605, 0.08984065055847168, 0.4241867661476135, 0.9418308734893799};
        double[] bias0_ogTol = new double[]{0.9684880375862122, 0.9527187347412109, 0.18455815315246582, 0.6065274477005005, 0.4981291890144348, 0.8888053894042969, 0.24716395139694214, 0.18402493000030518, 0.9244294762611389};
        double[] bias0_ogValueErr = new double[]{0.7530982494354248, 0.6354634165763855, 0.11419862508773804, 0.06763821840286255, 0.15208107233047485, 0.502015f, 0.4687958359718323, 0.2776569128036499, 0.8017957806587219};
        double[] bias0_ogZeroErr = new double[]{0.646397590637207, 0.11037266254425049, 0.4113478f, 0.2250347137451172, 0.3065752387046814, 0.4486308693885803, 0.5043429136276245, 0.11318850517272949, 0.511311f};
        double[] bias0_rdCal = new double[]{0.8501695990562439, 0.10861527919769287, 0.13340067863464355, 0.909978985786438, 0.632366418838501, 0.8650884032249451, 0.033549726009368896, 0.6954838037490845, 0.11287665367126465};
        double[] bias0_rdTestVolts = new double[]{0.674673318862915, 0.06375402212142944, 0.5577300786972046, 0.0346936f, 0.25591927766799927, 0.861728f, 0.6790806651115417, 0.500071f, 0.0706256628036499};
        double[] bias0_rdTol = new double[]{0.5492081046104431, 0.5675011873245239, 0.2477231f, 0.6511227488517761, 0.25721925497055054, 0.053745925426483154, 0.13506555557250977, 0.5684199333190918, 0.1792144775390625};
        double[] bias0_rdValueErr = new double[]{0.420258f, 0.24494272470474243, 0.3861231803894043, 0.47374796867370605, 0.32380956411361694, 0.34402942657470703, 0.40112733840942383, 0.4736320972442627, 0.6918114423751831};
        double[] bias0_rdZeroErr = new double[]{0.963251531124115, 0.18191653490066528, 0.16838771104812622, 0.9623038172721863, 0.15011334419250488, 0.48530107736587524, 0.4137721657752991, 0.0766598f, 0.7253578305244446};
        double[] bias1_gdCal = new double[]{0.1221545934677124, 0.779416024684906, 0.2768756151199341, 0.4441349506378174, 0.5148841738700867, 0.00691455602645874, 0.5889905095100403, 0.862678587436676, 0.759788f};
        double[] bias1_gdTestVolts = new double[]{0.24051225185394287, 0.5518115162849426, 0.5088573098182678, 0.8950796723365784, 0.17582905292510986, 0.26496803760528564, 0.4779793620109558, 0.15224981307983398, 0.10457044839859009};
        double[] bias1_gdTol = new double[]{0.7497748136520386, 0.1686194f, 0.30979394912719727, 0.21112632751464844, 0.3359434f, 0.147347092628479, 0.9024807214736938, 0.9873150587081909, 0.7804882526397705};
        double[] bias1_gdValueErr = new double[]{0.21205365657806396, 0.19770705699920654, 0.0017998814582824707, 0.893978476524353, 0.5026865005493164, 0.2176659107208252, 0.6090694069862366, 0.9734766483306885, 0.8928537964820862};
        double[] bias1_gdZeroErr = new double[]{0.0497211217880249, 0.2681116461753845, 0.529084324836731, 0.05878615379333496, 0.5883772969245911, 0.6124424338340759, 0.928119f, 0.25203055143356323, 0.23448187112808228};
        double[] bias1_odCal = new double[]{0.06101113557815552, 0.2818338871002197, 0.35309863090515137, 0.937881f, 0.7643618583679199, 0.35663992166519165, 0.7248210906982422, 0.00886458158493042, 0.8635683059692383};
        double[] bias1_odIMax = new double[]{0.525514f, 0.4517327547073364, 0.9946938753128052, 0.11279827356338501, 0.8843053579330444, 0.9963942170143127, 0.4767602f, 0.7324386835098267, 0.0687408447265625};
        double[] bias1_odTol = new double[]{0.14175671339035034, 0.2010408f, 0.16168522834777832, 0.02596902847290039, 0.35271936655044556, 0.522193193435669, 0.05116891860961914, 0.8524715900421143, 0.677761971950531};
        double[] bias1_odZeroErr = new double[]{0.6856864094734192, 0.15195822715759277, 0.7192482352256775, 0.8364443778991699, 0.161748468875885, 0.6321895122528076, 0.10460102558135986, 0.7797408103942871, 0.7016832828521729};
        double[] bias1_ogCal = new double[]{0.0922970175743103, 0.8619933128356934, 0.3623538017272949, 0.33647865056991577, 0.10063028335571289, 0.710841f, 0.6896804571151733, 0.4579014182090759, 0.2700703740119934};
        double[] bias1_ogTestVolts = new double[]{0.27534347772598267, 0.5729556679725647, 0.8949098587036133, 0.7206348180770874, 0.8623384237289429, 0.4858793616294861, 0.45777201652526855, 0.5911467671394348, 0.393549382686615};
        double[] bias1_ogTol = new double[]{0.6219715476036072, 0.40645831823349, 0.0836363434791565, 0.748494029045105, 0.5268413424491882, 0.29950016736984253, 0.24664908647537231, 0.767871618270874, 0.2619808316230774};
        double[] bias1_ogValueErr = new double[]{0.48851585388183594, 0.3681f, 0.177703857421875, 0.8507076501846313, 0.3890703320503235, 0.8853934407234192, 0.16424894332885742, 0.582197368144989, 0.5306582450866699};
        double[] bias1_ogZeroErr = new double[]{0.2015218734741211, 0.5292513370513916, 0.5915347337722778, 0.17069f, 0.6826686859130859, 0.6330636143684387, 0.49333226680755615, 0.05587393045425415, 0.5080180764198303};
        double[] bias1_rdCal = new double[]{0.3663373f, 0.9903306365013123, 0.28888654708862305, 0.43917596340179443, 0.4342119097709656, 0.5887249112129211, 0.47140854597091675, 0.10862231254577637, 0.3732417821884155};
        double[] bias1_rdTestVolts = new double[]{0.376612f, 0.562292f, 0.11836177110671997, 0.11182254552841187, 0.32439786195755005, 0.630763053894043, 0.2564527988433838, 0.018869996070861816, 0.5753469467163086};
        double[] bias1_rdTol = new double[]{0.7712225317955017, 0.03604203462600708, 0.3303477168083191, 0.5554215312004089, 0.4535815119743347, 0.7351964116096497, 0.49444258213043213, 0.5544989109039307, 0.03947758674621582};
        double[] bias1_rdValueErr = new double[]{0.2531300187110901, 0.307384f, 0.3419477939605713, 0.8316075205802917, 0.6268974542617798, 0.02484762668609619, 0.7699902057647705, 0.025355935096740723, 0.590442f};
        double[] bias1_rdZeroErr = new double[]{0.808464765548706, 0.5955008864402771, 0.18658453226089478, 0.3638281226158142, 0.6111805438995361, 0.5877537727355957, 0.22770464420318604, 0.08397293090820312, 0.705195426940918};
        double[] bias2_gdCal = new double[]{0.5745881199836731, 0.3399214f, 0.2192559838294983, 0.6262549161911011, 0.3666437268257141, 0.45988816022872925, 0.6296939253807068, 0.040489912033081055, 0.45842164754867554};
        double[] bias2_gdTestVolts = new double[]{0.8041380643844604, 0.963213324546814, 0.4553758502006531, 0.2713279128074646, 0.947884738445282, 0.0288409f, 0.39329564571380615, 0.22851771116256714, 0.21255344152450562};
        double[] bias2_gdTol = new double[]{0.011912405490875244, 0.5514242649078369, 0.6508852243423462, 0.568288266658783, 0.637826144695282, 0.09007900953292847, 0.8701666593551636, 0.36637115478515625, 0.03323858976364136};
        double[] bias2_gdValueErr = new double[]{0.8563101887702942, 0.8666839003562927, 0.45781224966049194, 0.3513185381889343, 0.4714767336845398, 0.46924442052841187, 0.2972654700279236, 0.6357949376106262, 0.5301083922386169};
        double[] bias2_gdZeroErr = new double[]{0.7822174429893494, 0.5979655385017395, 0.7027034163475037, 0.9898995161056519, 0.12456047534942627, 0.8187646269798279, 0.4652571678161621, 0.3246997594833374, 0.7379271984100342};
        double[] bias2_odCal = new double[]{0.006887316703796387, 0.4530452489852905, 0.3875085115432739, 0.721917450428009, 0.27117353677749634, 0.7593408823013306, 0.7404987812042236, 0.7256408929824829, 0.854900598526001};
        double[] bias2_odIMax = new double[]{0.157843f, 0.583867609500885, 0.5232800841331482, 0.5524739623069763, 0.17146915197372437, 0.312854528427124, 0.6501095294952393, 0.161163330078125, 0.8502786159515381};
        double[] bias2_odTol = new double[]{0.1887073516845703, 0.21293115615844727, 0.07158505916595459, 0.4632687568664551, 0.9889718294143677, 0.019225597381591797, 0.7258667349815369, 0.16032713651657104, 0.747619f};
        double[] bias2_odZeroErr = new double[]{0.5122162699699402, 0.9605627059936523, 0.487312376499176, 0.576705813407898, 0.13985759019851685, 0.6057502627372742, 0.9010071754455566, 0.9271302223205566, 0.7254574298858643};
        double[] bias2_ogCal = new double[]{0.7387614846229553, 0.7340636253356934, 0.6733422875404358, 0.912837028503418, 0.7502734661102295, 0.3962177038192749, 0.8504967093467712, 0.6118409037590027, 0.6346777081489563};
        double[] bias2_ogTestVolts = new double[]{0.6007689237594604, 0.3154820203781128, 0.6184857487678528, 0.3816053867340088, 0.5990188121795654, 0.7066761255264282, 0.7915622591972351, 0.9401387572288513, 0.4550822377204895};
        double[] bias2_ogTol = new double[]{0.8304072618484497, 0.6631735563278198, 0.3236621022224426, 0.3548798f, 0.5723358392715454, 0.48923712968826294, 0.09669744968414307, 0.512495f, 0.014815092086791992};
        double[] bias2_ogValueErr = new double[]{0.11774694919586182, 0.7637425661087036, 0.0013309121131896973, 0.1103748083114624, 0.7935634851455688, 0.695536732673645, 0.5241841077804565, 0.8185601234436035, 0.02027106285095215};
        double[] bias2_ogZeroErr = new double[]{0.8648861050605774, 0.86362f, 0.4383272f, 0.7694481611251831, 0.20988517999649048, 0.28067994117736816, 0.16905808448791504, 0.83838f, 0.23789077997207642};
        double[] bias2_rdCal = new double[]{0.1053884f, 0.9961449503898621, 0.697284996509552, 0.0728883147239685, 0.976794421672821, 0.4362572431564331, 0.1906307339668274, 0.5290064215660095, 0.8240458965301514};
        double[] bias2_rdTestVolts = new double[]{0.6852403879165649, 0.43380147218704224, 0.6640772223472595, 0.5545397996902466, 0.3085957169532776, 0.9116076231002808, 0.2826339602470398, 0.2424364686012268, 0.8993031978607178};
        double[] bias2_rdTol = new double[]{0.389864444732666, 0.87402f, 0.24330562353134155, 0.5271173715591431, 0.8121272325515747, 0.7979332804679871, 0.3415534496307373, 0.3222883939743042, 0.9028640389442444};
        double[] bias2_rdValueErr = new double[]{0.17943823337554932, 0.6503531336784363, 0.00792855f, 0.03374302387237549, 0.9140632152557373, 0.3034737f, 0.5301044583320618, 0.8447704315185547, 0.5800148248672485};
        double[] bias2_rdZeroErr = new double[]{0.9197233319282532, 0.3724360466003418, 0.7258525490760803, 0.5308462977409363, 0.689347505569458, 0.4999144673347473, 0.15168523788452148, 0.3233150839805603, 0.6739442944526672};
        double[] clkhiAmin = new double[]{0.8003124594688416, 0.8840603828430176, 0.1999720335006714, 0.3641918897628784, 0.1045953f, 0.586685299873352, 0.07568937540054321, 0.6804636716842651, 0.4218956232070923};
        double[] clkhiQmax = new double[]{0.5800520777702332, 0.306423f, 0.7984023094177246, 0.549782395362854, 0.45498377084732056, 0.08471924066543579, 0.4435202479362488, 0.1747344732284546, 0.4860857129096985};
        double[] clkliAmin = new double[]{0.20062655210494995, 0.5253089070320129, 0.49706172943115234, 0.1789099f, 0.922715425491333, 0.21220701932907104, 0.16325223445892334, 0.5513094067573547, 0.13890838623046875};
        double[] clkliQmax = new double[]{0.21476882696151733, 0.3092518448829651, 0.6099345684051514, 0.600970983505249, 0.21676874160766602, 0.08100646734237671, 0.9224645495414734, 0.04314148426055908, 0.03470128774642944};
        double[] dac_clkhIMax = new double[]{0.45235252380371094, 0.7059468626976013, 0.2009183168411255, 0.29771554470062256, 0.1817813515663147, 0.7181359529495239, 0.9000556468963623, 0.7156334519386292, 0.5936198234558105};
        double[] dac_clklIMax = new double[]{0.7342118620872498, 0.6810342669487, 0.476121723651886, 0.6187577247619629, 0.06356239318847656, 0.08649373054504395, 0.007741868495941162, 0.3463588356971741, 0.47391778230667114};
        double[] dac_pclkHighCal = new double[]{0.18728214502334595, 0.4285205602645874, 0.7102625370025635, 0.8721213340759277, 0.028969526290893555, 0.025536537170410156, 0.929409384727478, 0.9869453310966492, 0.020075678825378418};
        double[] dac_pclkHighTestV = new double[]{0.276092529296875, 0.8361074328422546, 0.21995443105697632, 0.38420385122299194, 0.31224966049194336, 0.23293238878250122, 0.40147173404693604, 0.39219456911087036, 0.5753852725028992};
        double[] dac_pclkHighTol = new double[]{0.22028517723083496, 0.8018012642860413, 0.36188453435897827, 0.3241550326347351, 0.9119870662689209, 0.8102445602416992, 0.24977731704711914, 0.9065913558006287, 0.813798725605011};
        double[] dac_pclkHighValueErr = new double[]{0.8789604902267456, 0.9017178416252136, 0.4344574213027954, 0.1655225157737732, 0.8238404393196106, 0.7224611043930054, 0.995449960231781, 0.8556565046310425, 0.3343989849090576};
        double[] dac_pclkHighZeroErr = new double[]{0.16390752792358398, 0.4870567321777344, 0.8007899522781372, 0.5389488339424133, 0.21893548965454102, 0.8761265277862549, 0.46057581901550293, 0.9353818297386169, 0.19551920890808105};
        double[] dac_pclkLowCal = new double[]{0.39240384101867676, 0.0318138f, 0.6826966404914856, 0.7906205654144287, 0.2049654722213745, 0.7586924433708191, 0.6705963611602783, 0.6947575211524963, 0.250831663608551};
        double[] dac_pclkLowTestV = new double[]{0.21544432640075684, 0.47625845670700073, 0.14887607097625732, 0.4687969f, 0.6955842971801758, 0.0765959620475769, 0.511004f, 0.013155996799468994, 0.389645516872406};
        double[] dac_pclkLowTol = new double[]{0.3244718313217163, 0.6400936245918274, 0.4965214133262634, 0.5901732444763184, 0.797491f, 0.8905333876609802, 0.7440076470375061, 0.04605609178543091, 0.7829034328460693};
        double[] dac_pclkLowValueErr = new double[]{0.5582185387611389, 0.3789821267127991, 0.9435774087905884, 0.23216503858566284, 0.5061484575271606, 0.1402691f, 0.04249382019042969, 0.37979036569595337, 0.40569454431533813};
        double[] dac_pclkLowZeroErr = new double[]{0.6296751499176025, 0.7937451601028442, 0.014896035194396973, 0.9935399293899536, 0.0751552f, 0.940955400466919, 0.7775058150291443, 0.10151857137680054, 0.1776370406150818};
        double[] dac_rgHighCal = new double[]{0.11870795488357544, 0.24811553955078125, 0.058002352714538574, 0.5878888368606567, 0.34279865026474, 0.446674644947052, 0.6790383458137512, 0.5738877654075623, 0.4055485725402832};
        double[] dac_rgHighTestV = new double[]{0.8601377010345459, 0.21220511198043823, 0.9195892214775085, 0.9851754307746887, 0.4957928f, 0.7163221836090088, 0.6140961050987244, 0.5226884484291077, 0.19604378938674927};
        double[] dac_rgHighTol = new double[]{0.8590373396873474, 0.9079030752182007, 0.4614155888557434, 0.5501790642738342, 0.5983737707138062, 0.4326738715171814, 0.4598551392555237, 0.9665083885192871, 0.743118405342102};
        double[] dac_rgHighValueErr = new double[]{0.29607248306274414, 0.43294817209243774, 0.6063153743743896, 0.7231611609458923, 0.00729447603225708, 0.33310025930404663, 0.977205f, 0.760383f, 0.2865495f};
        double[] dac_rgHighZeroErr = new double[]{0.11147481203079224, 0.6011083126068115, 0.9323744773864746, 0.9278703927993774, 0.2914939522743225, 0.6405305862426758, 0.7372221946716309, 0.9749284982681274, 0.6074967980384827};
        double[] dac_rgLowCal = new double[]{0.030330181121826172, 0.7730217576026917, 0.23031193017959595, 0.6076322197914124, 0.13174086809158325, 0.06898140907287598, 0.13688474893569946, 0.4649277329444885, 0.32647645473480225};
        double[] dac_rgLowTestV = new double[]{0.6774181127548218, 0.07293188571929932, 0.2858484983444214, 0.1931876540184021, 0.042186856269836426, 0.2089687f, 0.3314070701599121, 0.8635f, 0.7868179678916931};
        double[] dac_rgLowTol = new double[]{0.04214549f, 0.9800314903259277, 0.013203442096710205, 0.25569117069244385, 0.20352166891098022, 0.250063419342041, 0.3943629264831543, 0.9378864169120789, 0.9141576886177063};
        double[] dac_rgLowValueErr = new double[]{0.8772063255310059, 0.3102787733078003, 0.8030017614364624, 0.7286413311958313, 0.5008583068847656, 0.4470691680908203, 0.28140032291412354, 0.7706174850463867, 0.47354668378829956};
        double[] dac_rgLowZeroErr = new double[]{0.7385295629501343, 0.7813725471496582, 0.24604082107543945, 0.2682746648788452, 0.7058215737342834, 0.1090155839920044, 0.46875715255737305, 0.8462410569190979, 0.9970532655715942};
        double[] dac_sclkHighCal = new double[]{0.25281256437301636, 0.1928073763847351, 0.6669959425926208, 0.6861705183982849, 0.7266314625740051, 0.600325345993042, 0.10764491558074951, 0.573624312877655, 0.9979845881462097};
        double[] dac_sclkHighTestV = new double[]{0.6174829006195068, 0.8183566927909851, 0.07649964094161987, 0.6318298578262329, 0.23866015672683716, 0.2174096703529358, 0.8822810649871826, 0.27603602409362793, 0.5365505218505859};
        double[] dac_sclkHighTol = new double[]{0.7377258539199829, 0.9629201292991638, 0.8280600905418396, 0.969538688659668, 0.22378402948379517, 0.6647076606750488, 0.3317262530326843, 0.30432742834091187, 0.7666182518005371};
        double[] dac_sclkHighValueErr = new double[]{0.7806218862533569, 0.8396885991096497, 0.9289778470993042, 0.3070452809333801, 0.9169155359268188, 0.57578444480896, 0.907426655292511, 0.16321277618408203, 0.2419554591178894};
        double[] dac_sclkHighZeroErr = new double[]{0.8797241449356079, 0.8299506306648254, 0.7060214877128601, 0.2755822539329529, 0.20525145530700684, 0.24436503648757935, 0.25108712911605835, 0.6799971461296082, 0.6659785509109497};
        double[] dac_sclkLowCal = new double[]{0.25002098083496094, 0.7229271531105042, 0.7525046467781067, 0.5276303291320801, 0.13155996799468994, 0.2183634638786316, 0.2160738706588745, 0.5816146731376648, 0.7731895446777344};
        double[] dac_sclkLowTestV = new double[]{0.5222405195236206, 0.9409773945808411, 0.4059907793998718, 0.9888686537742615, 0.25809115171432495, 0.9107029438018799, 0.2324819564819336, 0.9317814707756042, 0.36610865592956543};
        double[] dac_sclkLowTol = new double[]{0.3345072269439697, 0.05174213647842407, 0.9009913802146912, 0.2455756664276123, 0.5896274447441101, 0.9663316607475281, 0.2779970169067383, 0.2617756724357605, 0.19612634181976318};
        double[] dac_sclkLowValueErr = new double[]{0.8576100468635559, 0.0254705548286438, 0.5594959259033203, 0.3501044511795044, 0.5879529118537903, 0.32978355884552, 0.735785186290741, 0.49566978216171265, 0.08542346954345703};
        double[] dac_sclkLowZeroErr = new double[]{0.1236853f, 0.971034824848175, 0.8473304510116577, 0.3294628858566284, 0.5819786190986633, 0.5952181816101074, 0.7927321195602417, 0.0016371607780456543, 0.32815104722976685};
        String location = "j";
        double[] maxDelta = new double[]{0.11643165349960327, 0.25121062994003296, 0.08798271417617798, 0.5846213102340698, 0.48808616399765015, 0.1276019811630249, 0.2578394412994385, 0.10613560676574707, 0.3082171082496643};
        double[] maxStep = new double[]{0.9318339228630066, 0.8321828842163086, 0.5614796280860901, 0.24628931283950806, 0.9507452249526978, 0.3649328351020813, 0.3665999174118042, 0.38482964038848877, 0.8802147507667542};
        double[] minTol = new double[]{0.2488483190536499, 0.4148409366607666, 0.4606884f, 0.6602405309677124, 0.9092357754707336, 0.8978352546691895, 0.50284343957901, 0.21597141027450562, 0.002817809581756592};
        int[] nPowerOnPub = new int[]{912, 400, 2, 758, 191, 140, 637, 248, 635};
        double[] odiAmin = new double[]{0.8116698861122131, 0.8750594854354858, 0.38524436950683594, 0.9800442457199097, 0.28536665439605713, 0.2334151268005371, 0.1388377547264099, 0.5651848912239075, 0.5733909606933594};
        double[] odiQmax = new double[]{0.41720718145370483, 0.26448744535446167, 0.35695648193359375, 0.8900324106216431, 0.4097848f, 0.2699854373931885, 0.3449241f, 0.6514145731925964, 0.7461811900138855};
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneRebRaftsPowerSettingsAppliedEvent(priority, version, bias0_gdCal, bias0_gdTestVolts, bias0_gdTol, bias0_gdValueErr, bias0_gdZeroErr, bias0_odCal, bias0_odIMax, bias0_odTol, bias0_odZeroErr, bias0_ogCal, bias0_ogTestVolts, bias0_ogTol, bias0_ogValueErr, bias0_ogZeroErr, bias0_rdCal, bias0_rdTestVolts, bias0_rdTol, bias0_rdValueErr, bias0_rdZeroErr, bias1_gdCal, bias1_gdTestVolts, bias1_gdTol, bias1_gdValueErr, bias1_gdZeroErr, bias1_odCal, bias1_odIMax, bias1_odTol, bias1_odZeroErr, bias1_ogCal, bias1_ogTestVolts, bias1_ogTol, bias1_ogValueErr, bias1_ogZeroErr, bias1_rdCal, bias1_rdTestVolts, bias1_rdTol, bias1_rdValueErr, bias1_rdZeroErr, bias2_gdCal, bias2_gdTestVolts, bias2_gdTol, bias2_gdValueErr, bias2_gdZeroErr, bias2_odCal, bias2_odIMax, bias2_odTol, bias2_odZeroErr, bias2_ogCal, bias2_ogTestVolts, bias2_ogTol, bias2_ogValueErr, bias2_ogZeroErr, bias2_rdCal, bias2_rdTestVolts, bias2_rdTol, bias2_rdValueErr, bias2_rdZeroErr, clkhiAmin, clkhiQmax, clkliAmin, clkliQmax, dac_clkhIMax, dac_clklIMax, dac_pclkHighCal, dac_pclkHighTestV, dac_pclkHighTol, dac_pclkHighValueErr, dac_pclkHighZeroErr, dac_pclkLowCal, dac_pclkLowTestV, dac_pclkLowTol, dac_pclkLowValueErr, dac_pclkLowZeroErr, dac_rgHighCal, dac_rgHighTestV, dac_rgHighTol, dac_rgHighValueErr, dac_rgHighZeroErr, dac_rgLowCal, dac_rgLowTestV, dac_rgLowTol, dac_rgLowValueErr, dac_rgLowZeroErr, dac_sclkHighCal, dac_sclkHighTestV, dac_sclkHighTol, dac_sclkHighValueErr, dac_sclkHighZeroErr, dac_sclkLowCal, dac_sclkLowTestV, dac_sclkLowTol, dac_sclkLowValueErr, dac_sclkLowZeroErr, location, maxDelta, maxStep, minTol, nPowerOnPub, odiAmin, odiQmax));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneRebRaftsPowerSettingsAppliedEvent));
        FocalPlaneRebRaftsPowerSettingsAppliedEvent item_ = (FocalPlaneRebRaftsPowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdCal, (double[])item_.getBias0_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTestVolts, (double[])item_.getBias0_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTol, (double[])item_.getBias0_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdValueErr, (double[])item_.getBias0_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdZeroErr, (double[])item_.getBias0_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odCal, (double[])item_.getBias0_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odIMax, (double[])item_.getBias0_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odTol, (double[])item_.getBias0_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odZeroErr, (double[])item_.getBias0_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogCal, (double[])item_.getBias0_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTestVolts, (double[])item_.getBias0_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTol, (double[])item_.getBias0_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogValueErr, (double[])item_.getBias0_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogZeroErr, (double[])item_.getBias0_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdCal, (double[])item_.getBias0_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTestVolts, (double[])item_.getBias0_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTol, (double[])item_.getBias0_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdValueErr, (double[])item_.getBias0_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdZeroErr, (double[])item_.getBias0_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdCal, (double[])item_.getBias1_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdTestVolts, (double[])item_.getBias1_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdTol, (double[])item_.getBias1_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdValueErr, (double[])item_.getBias1_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdZeroErr, (double[])item_.getBias1_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odCal, (double[])item_.getBias1_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odIMax, (double[])item_.getBias1_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odTol, (double[])item_.getBias1_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odZeroErr, (double[])item_.getBias1_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogCal, (double[])item_.getBias1_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogTestVolts, (double[])item_.getBias1_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogTol, (double[])item_.getBias1_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogValueErr, (double[])item_.getBias1_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogZeroErr, (double[])item_.getBias1_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdCal, (double[])item_.getBias1_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdTestVolts, (double[])item_.getBias1_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdTol, (double[])item_.getBias1_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdValueErr, (double[])item_.getBias1_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdZeroErr, (double[])item_.getBias1_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdCal, (double[])item_.getBias2_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdTestVolts, (double[])item_.getBias2_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdTol, (double[])item_.getBias2_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdValueErr, (double[])item_.getBias2_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdZeroErr, (double[])item_.getBias2_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odCal, (double[])item_.getBias2_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odIMax, (double[])item_.getBias2_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odTol, (double[])item_.getBias2_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odZeroErr, (double[])item_.getBias2_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogCal, (double[])item_.getBias2_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogTestVolts, (double[])item_.getBias2_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogTol, (double[])item_.getBias2_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogValueErr, (double[])item_.getBias2_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogZeroErr, (double[])item_.getBias2_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdCal, (double[])item_.getBias2_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdTestVolts, (double[])item_.getBias2_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdTol, (double[])item_.getBias2_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdValueErr, (double[])item_.getBias2_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdZeroErr, (double[])item_.getBias2_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiAmin, (double[])item_.getClkhiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiQmax, (double[])item_.getClkhiQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliAmin, (double[])item_.getClkliAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliQmax, (double[])item_.getClkliQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clkhIMax, (double[])item_.getDac_clkhIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clklIMax, (double[])item_.getDac_clklIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighCal, (double[])item_.getDac_pclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTestV, (double[])item_.getDac_pclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTol, (double[])item_.getDac_pclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighValueErr, (double[])item_.getDac_pclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighZeroErr, (double[])item_.getDac_pclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowCal, (double[])item_.getDac_pclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTestV, (double[])item_.getDac_pclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTol, (double[])item_.getDac_pclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowValueErr, (double[])item_.getDac_pclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowZeroErr, (double[])item_.getDac_pclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighCal, (double[])item_.getDac_rgHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTestV, (double[])item_.getDac_rgHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTol, (double[])item_.getDac_rgHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighValueErr, (double[])item_.getDac_rgHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighZeroErr, (double[])item_.getDac_rgHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowCal, (double[])item_.getDac_rgLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTestV, (double[])item_.getDac_rgLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTol, (double[])item_.getDac_rgLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowValueErr, (double[])item_.getDac_rgLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowZeroErr, (double[])item_.getDac_rgLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighCal, (double[])item_.getDac_sclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTestV, (double[])item_.getDac_sclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTol, (double[])item_.getDac_sclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighValueErr, (double[])item_.getDac_sclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighZeroErr, (double[])item_.getDac_sclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowCal, (double[])item_.getDac_sclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTestV, (double[])item_.getDac_sclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTol, (double[])item_.getDac_sclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowValueErr, (double[])item_.getDac_sclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowZeroErr, (double[])item_.getDac_sclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])maxDelta, (double[])item_.getMaxDelta(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])maxStep, (double[])item_.getMaxStep(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])minTol, (double[])item_.getMinTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((int[])nPowerOnPub, (int[])item_.getNPowerOnPub());
        Assert.assertArrayEquals((double[])odiAmin, (double[])item_.getOdiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odiQmax, (double[])item_.getOdiQmax(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitorSettingsAppliedEvent() throws Exception {
        int priority = 521;
        int version = 136;
        String daqPartition = "j";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitorSettingsAppliedEvent(priority, version, daqPartition));
        Assert.assertTrue((boolean)(item instanceof Daq_monitorSettingsAppliedEvent));
        Daq_monitorSettingsAppliedEvent item_ = (Daq_monitorSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
    }

    @Test
    public void sendReceiveDaq_monitor_StatsSettingsAppliedEvent() throws Exception {
        int priority = 540;
        int version = 340;
        boolean enablePeriodicPublication = false;
        int minDiffAlertWarning = 997;
        int minDiffLogWarning = 78;
        String sumDriverChecks = "";
        String sumDriverStats = "";
        String sumFirmwareChecks = "f";
        String sumFirmwareStats = "l";
        String sumRdsChecks = "f";
        String sumRdsStats = "";
        String sumRmsChecks = "p";
        String sumRmsStats = "";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_StatsSettingsAppliedEvent(priority, version, enablePeriodicPublication, minDiffAlertWarning, minDiffLogWarning, sumDriverChecks, sumDriverStats, sumFirmwareChecks, sumFirmwareStats, sumRdsChecks, sumRdsStats, sumRmsChecks, sumRmsStats));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StatsSettingsAppliedEvent));
        Daq_monitor_StatsSettingsAppliedEvent item_ = (Daq_monitor_StatsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)enablePeriodicPublication, (Object)item_.isEnablePeriodicPublication());
        Assert.assertEquals((long)minDiffAlertWarning, (long)item_.getMinDiffAlertWarning());
        Assert.assertEquals((long)minDiffLogWarning, (long)item_.getMinDiffLogWarning());
        Assert.assertEquals((Object)sumDriverChecks, (Object)item_.getSumDriverChecks());
        Assert.assertEquals((Object)sumDriverStats, (Object)item_.getSumDriverStats());
        Assert.assertEquals((Object)sumFirmwareChecks, (Object)item_.getSumFirmwareChecks());
        Assert.assertEquals((Object)sumFirmwareStats, (Object)item_.getSumFirmwareStats());
        Assert.assertEquals((Object)sumRdsChecks, (Object)item_.getSumRdsChecks());
        Assert.assertEquals((Object)sumRdsStats, (Object)item_.getSumRdsStats());
        Assert.assertEquals((Object)sumRmsChecks, (Object)item_.getSumRmsChecks());
        Assert.assertEquals((Object)sumRmsStats, (Object)item_.getSumRmsStats());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreSettingsAppliedEvent() throws Exception {
        int priority = 729;
        int version = 449;
        String daqFolder = "y";
        boolean enableAutoPurge = false;
        double purgeTarget = 0.5535042881965637;
        double purgeThreshold = 0.216303288936615;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_StoreSettingsAppliedEvent(priority, version, daqFolder, enableAutoPurge, purgeTarget, purgeThreshold));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreSettingsAppliedEvent));
        Daq_monitor_StoreSettingsAppliedEvent item_ = (Daq_monitor_StoreSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)enableAutoPurge, (Object)item_.isEnableAutoPurge());
        Assert.assertEquals((double)purgeTarget, (double)item_.getPurgeTarget(), (double)1.0E-6f);
        Assert.assertEquals((double)purgeThreshold, (double)item_.getPurgeThreshold(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveShutterBladeMotionProfileEvent() throws Exception {
        int priority = 468;
        ShutterBladeMotionProfileEvent.Blade blade = ShutterBladeMotionProfileEvent.Blade.PLUS_X;
        ShutterBladeMotionProfileEvent.Direction direction = ShutterBladeMotionProfileEvent.Direction.CLOSE;
        double timestampStart = 0.724603533744812;
        double startPosition = 0.1649855375289917;
        double targetDuration = 0.524152934551239;
        double targetPosition = 0.1386559009552002;
        double endPosition = 0.18888407945632935;
        double actualDuration = 0.746355f;
        int hallSensorCount = 486;
        double[] timestampHallSensor = new double[]{0.16918432712554932, 0.4212082624435425, 0.6034871339797974, 0.25848788022994995, 0.20617163181304932, 0.6782745122909546, 0.955681f, 0.3962072f, 0.5218521356582642, 0.1899036169052124, 0.4225732088088989, 0.03787273168563843, 0.3646594285964966, 0.7142853140830994, 0.8675350546836853, 0.9096395373344421, 0.3596722483634949, 0.4937942624092102, 0.1310117244720459, 0.12645351886749268, 0.0751606822013855, 0.1677112579345703, 0.6396954655647278, 0.8349857330322266, 0.6537532806396484, 0.41739994287490845, 0.9492185115814209, 0.1932897f, 0.74419766664505, 0.07167041301727295, 0.5874601602554321, 0.592810332775116, 0.5374249219894409, 0.67213f, 0.5862097144126892, 0.08965545892715454, 0.7400966882705688, 0.8178134560585022, 0.6225771307945251, 0.4591280221939087, 0.4945831894874573, 0.09346562623977661, 0.11807596683502197, 0.02763331f, 0.9640874862670898, 0.7953070998191833, 0.17072665691375732, 0.6420723795890808, 0.8862138390541077, 0.6513652205467224, 0.10997647047042847, 0.4971882104873657, 0.4016244411468506, 0.08052986860275269, 0.3799621f, 0.5101470947265625, 0.8836053609848022, 0.426071f, 0.5660336017608643, 0.978637158870697, 0.0295704f, 0.8567120432853699, 0.703027f, 0.11930537223815918, 0.7800835967063904, 0.9634101986885071, 0.6401426196098328, 0.00840681791305542, 0.5613293051719666, 0.3452872633934021, 0.6132214665412903, 0.452708f, 0.2126712203025818, 0.9168487787246704, 0.2955929f, 0.4381973147392273, 0.7747090458869934, 0.1645141839981079, 0.296500027179718, 0.3348594903945923, 0.04089456796646118, 0.9079667925834656, 0.26252996921539307, 0.7911467552185059, 0.5862413048744202, 0.19596493244171143, 0.6517412066459656, 0.8109247088432312, 0.5020307898521423, 0.09269309043884277, 0.7096713781356812, 0.4633186459541321, 0.610880970954895, 0.2357664704322815, 0.8266355991363525, 0.8923792243003845, 0.7904093265533447, 0.007546544075012207, 0.02032071352005005, 0.1448100209236145, 0.6774519681930542, 0.9350197315216064, 0.8183979392051697, 0.9617493748664856, 0.3929516673088074, 0.8882981538772583, 0.9426085352897644, 0.2420047f, 0.6579023599624634, 0.792611f, 0.3765166401863098, 0.8020473122596741, 0.3539528250694275, 0.8028817176818848, 0.17002063989639282, 0.2709732f, 0.012377262115478516, 0.2536681294441223, 0.5590114593505859, 0.17061054706573486, 0.13917946815490723, 0.6210432052612305, 0.10065692663192749, 0.1617475152015686, 0.6523122191429138, 0.2882046699523926, 0.8141778707504272, 0.0724054f, 0.9226796627044678, 0.055135905742645264, 0.12229812145233154, 0.16417354345321655, 0.0801962f, 0.17703211307525635, 0.38655567169189453, 0.404455304145813, 0.9292687773704529, 0.7496299147605896, 0.27523887157440186, 0.5782743096351624, 0.27734827995300293, 0.6158115863800049, 0.1788643f, 0.4409077763557434, 0.9314776659011841, 0.6713199019432068, 0.5559794902801514, 0.8455294370651245, 0.479996919631958, 0.6631540656089783, 0.9409094452857971, 0.7073533535003662, 0.1218177080154419, 0.8578788042068481, 0.4422512f, 0.6322062015533447, 0.8091465830802917, 0.5049675107002258, 0.8019691109657288, 0.1533641219139099, 0.3595404624938965, 0.9193195104598999, 0.4434826374053955, 0.4118521213531494, 0.7011619210243225, 0.4847882390022278, 0.7149277925491333, 0.17381781339645386, 0.22563612461090088, 0.5550898909568787, 0.6106980443000793, 0.7112863063812256, 0.22369462251663208, 0.3586241f, 0.33843398094177246, 0.9524278044700623, 0.41063958406448364, 0.7489414215087891, 0.9759699106216431, 0.6229037642478943, 0.655523f, 0.27287375926971436, 0.24761521816253662, 0.804999589920044, 0.7068792581558228, 0.23437517881393433, 0.8339337110519409, 0.4058322310447693, 0.15907102823257446, 0.5351780652999878, 0.13439089059829712, 0.6852855086326599, 0.2801274061203003, 0.285383403301239, 0.626501202583313, 0.999459f, 0.9808174967765808, 0.8505963683128357, 0.8351826071739197, 0.7829119563102722, 0.9551782011985779, 0.8803683519363403, 0.9467967748641968, 0.05507081747055054, 0.37750154733657837, 0.32929152250289917, 0.6068287491798401, 0.19070512056350708, 0.9657025337219238, 0.811535120010376, 0.839469f, 0.6548264026641846, 0.3849772810935974, 0.2369445562362671, 0.060768187046051025, 0.947840690612793, 0.9907975792884827, 0.3677181005477905, 0.1419163942337036, 0.23200958967208862, 0.621763288974762, 0.1554107666015625, 0.5610649585723877, 0.37559783458709717, 0.32896852493286133, 0.8055156469345093, 0.08459645509719849, 0.33248448371887207, 0.5507811307907104, 0.9486668705940247, 0.6936050653457642, 0.5140964984893799, 0.7448531985282898, 0.941771388053894, 0.7484720349311829, 0.7645028829574585, 0.010468602180480957, 0.6878884434700012, 0.6218031644821167, 0.6412501335144043};
        int[] hallSensorID = new int[]{745, 954, 391, 584, 726, 648, 496, 76, 697, 910, 683, 948, 462, 249, 366, 196, 598, 916, 873, 456, 230, 757, 68, 197, 123, 849, 993, 917, 243, 784, 467, 761, 963, 939, 50, 10, 929, 914, 876, 272, 893, 378, 378, 555, 385, 811, 716, 512, 530, 736, 778, 843, 89, 696, 952, 107, 923, 257, 260, 51, 89, 804, 848, 548, 781, 931, 238, 656, 482, 271, 685, 937, 934, 847, 599, 448, 847, 834, 68, 18, 430, 822, 927, 532, 301, 25, 442, 720, 329, 836, 808, 344, 836, 871, 295, 918, 914, 399, 369, 102, 629, 572, 21, 883, 951, 552, 903, 990, 907, 642, 40, 934, 345, 352, 587, 145, 844, 187, 638, 312, 754, 940, 521, 208, 615, 341, 326, 301, 70, 506, 925, 481, 30, 117, 706, 114, 100, 321, 749, 946, 923, 143, 510, 312, 805, 108, 763, 828, 620, 420, 976, 191, 249, 487, 594, 280, 736, 177, 272, 435, 494, 624, 30, 925, 560, 78, 23, 794, 554, 486, 958, 879, 185, 244, 1, 772, 358, 469, 875, 673, 767, 966, 629, 737, 955, 304, 144, 932, 593, 296, 865, 198, 182, 501, 985, 645, 489, 371, 296, 336, 37, 780, 342, 570, 258, 806, 446, 910, 160, 672, 559, 605, 442, 990, 551, 274, 707, 212, 806, 47, 487, 710, 269, 417, 112, 190, 666, 733, 484, 415, 505, 934, 895, 574, 904, 975, 683, 25, 599, 698};
        double[] hallSensorPosition = new double[]{0.7711588144302368, 0.22900527715682983, 0.6242959499359131, 0.796847939491272, 0.19282597303390503, 0.22758746147155762, 0.4324553608894348, 0.3753041625022888, 0.16835826635360718, 0.5050604343414307, 0.06370240449905396, 0.7674635052680969, 0.06612330675125122, 0.24641722440719604, 0.4908837676048279, 0.5330145359039307, 0.7250893115997314, 0.9086655378341675, 0.5705804228782654, 0.3904784321784973, 0.3178486227989197, 0.8363955616950989, 0.01528573f, 0.19582092761993408, 0.6402224898338318, 0.7362356781959534, 0.9210574626922607, 0.2001828f, 0.2087729573249817, 0.0972716212272644, 0.5894113183021545, 0.14540356397628784, 0.48003554344177246, 0.9238985776901245, 0.4512117f, 0.33633846044540405, 0.3604347f, 0.716579020023346, 0.8807411193847656, 0.22478598356246948, 0.01323777437210083, 0.48775774240493774, 0.3348802924156189, 0.03337627649307251, 0.5512261986732483, 0.3685334324836731, 0.14840304851531982, 0.5868754982948303, 0.2468433380126953, 0.5710065364837646, 0.1229315996170044, 0.36650723218917847, 0.3143569827079773, 0.7865678668022156, 0.7533522248268127, 0.189189612865448, 0.4931233525276184, 0.5774151682853699, 0.10885119438171387, 0.18275481462478638, 0.6625542044639587, 0.65358f, 0.4216992259025574, 0.49060964584350586, 0.576188862323761, 0.7076285481452942, 0.8091249465942383, 0.5208961963653564, 0.745803952217102, 0.4315042495727539, 0.06382858753204346, 0.44760453701019287, 0.22132503986358643, 0.582874059677124, 0.47678375244140625, 0.9815229177474976, 0.8861351013183594, 0.26060914993286133, 0.40995967388153076, 0.3302185535430908, 0.2610187530517578, 0.540095865726471, 0.1026091f, 0.4469099f, 0.22739005088806152, 0.09896194934844971, 0.5870565176010132, 0.5822194218635559, 0.5386918187141418, 0.6131938695907593, 0.8008796572685242, 0.2701093554496765, 0.18812376260757446, 0.3437894f, 0.0325050950050354, 0.9351528882980347, 0.2944710850715637, 0.17696022987365723, 0.8251739144325256, 0.5536596179008484, 0.012217521667480469, 0.2790037989616394, 0.8167297840118408, 0.2526538372039795, 0.37689924240112305, 0.72347092628479, 0.7146243453025818, 0.4205285906791687, 0.9744883179664612, 0.8269518613815308, 0.5299327373504639, 0.12921392917633057, 0.8403084874153137, 0.2651034f, 0.2321536f, 0.24338674545288086, 0.2175209f, 0.24748414754867554, 0.3773950934410095, 0.0967077f, 0.3596503f, 0.41401517391204834, 0.8236048221588135, 0.64303f, 0.7711450457572937, 0.6237296462059021, 0.023287057876586914, 0.40233057737350464, 0.4228951930999756, 0.2748332f, 0.30031102895736694, 0.6927521824836731, 0.037424683570861816, 0.2015022f, 0.024693548679351807, 0.7132042646408081, 0.4456857442855835, 0.9054670929908752, 0.3275317f, 0.17269080877304077, 0.9117224216461182, 0.9080513715744019, 0.40556687116622925, 0.7757561802864075, 0.793748f, 0.250373f, 0.08731728792190552, 0.9066471457481384, 0.7543467879295349, 0.6659121513366699, 0.03457885980606079, 0.012080729007720947, 0.1956343650817871, 0.1312609314918518, 0.17674553394317627, 0.1836094856262207, 0.6274861693382263, 0.4388948678970337, 0.9913501739501953, 0.27084267139434814, 0.18169403076171875, 0.09214985370635986, 0.4011055827140808, 0.017182588577270508, 0.568577766418457, 0.2997971177101135, 0.03229391574859619, 0.46688413619995117, 0.9947351813316345, 0.6388403177261353, 0.6264894604682922, 0.5283551812171936, 0.18395566940307617, 0.1932077407836914, 0.6003178954124451, 0.6415472626686096, 0.8836649656295776, 0.6872890591621399, 0.26738274097442627, 0.05051279067993164, 0.5155674815177917, 0.4818124771118164, 0.5618872046470642, 0.05482828617095947, 0.8134623169898987, 0.8410322666168213, 0.3022293448448181, 0.6503296494483948, 0.9587438702583313, 0.8108999133110046, 4.579425E-4f, 0.28082817792892456, 0.4031602740287781, 0.4547199010848999, 0.9335781931877136, 0.6341502070426941, 0.9904511570930481, 0.30330485105514526, 0.9470493793487549, 0.9195677042007446, 0.3380838632583618, 0.3089866042137146, 0.1393022f, 0.2666983f, 0.605151891708374, 0.6058160662651062, 0.8867303133010864, 0.4610862731933594, 0.5934098958969116, 0.12129944562911987, 0.3975124955177307, 0.36742645502090454, 0.6493446826934814, 0.8481138944625854, 0.24405282735824585, 0.04184520244598389, 0.553186297416687, 0.04808610677719116, 0.8101748824119568, 0.669546365737915, 0.6960483193397522, 0.14659267663955688, 0.8209753632545471, 0.3188077211380005, 0.5122677683830261, 0.7953612804412842, 0.699066162109375, 0.8277574181556702, 0.7069417238235474, 0.8879616260528564, 0.33757346868515015, 0.4531694f, 0.10819530487060547, 0.948234498500824, 0.5025935769081116, 0.7429161667823792, 0.49256646633148193, 0.6613069176673889, 0.808845579624176, 0.24356502294540405};
        boolean[] hallSensorTransition = new boolean[]{true, true, false, false, true, false, false, true, false, true, false, false, true, true, false, true, true, true, false, true, true, false, true, false, true, true, true, true, true, false, true, true, true, false, true, false, false, false, true, true, false, false, true, true, false, false, false, true, true, false, true, false, false, false, false, false, false, true, false, false, false, true, false, false, true, false, false, true, true, true, false, true, false, false, false, false, true, true, false, true, false, false, false, true, false, false, true, false, false, false, false, false, false, false, true, false, true, false, true, true, true, true, true, false, true, true, true, false, true, true, false, false, false, true, true, true, false, true, false, false, false, false, false, true, true, false, true, true, false, true, false, false, false, false, true, false, true, false, true, false, false, false, false, true, false, true, true, false, false, true, false, false, false, false, true, true, false, false, true, false, true, false, false, false, true, false, false, false, true, true, false, true, true, false, true, false, false, true, false, true, true, false, true, true, true, false, false, false, false, true, false, true, true, true, true, false, false, false, true, true, true, true, false, true, false, false, false, false, false, true, false, true, true, true, false, false, true, true, true, false, false, true, true, true, true, false, true, false, false, false, true, false, true, true, true, false, true, false, true, false};
        int encoderCount = 296;
        double[] timestampEncoder = new double[]{0.01391238f, 0.43761688470840454, 0.8390809297561646, 0.36190032958984375, 0.3067666292190552, 0.9353718161582947, 0.8341261148452759, 0.8316114544868469, 0.1850796341896057, 0.059637486934661865, 0.832711398601532, 0.37604063749313354, 0.03953767f, 0.8931769132614136, 0.34542137384414673, 0.09803193807601929, 0.6892715096473694, 0.398157000541687, 0.13042718172073364, 0.034231483936309814, 0.6972344517707825, 0.631290853023529, 0.4155048727989197, 0.19414716958999634, 0.7746595144271851, 0.8212222456932068, 0.8613449335098267, 0.944949209690094, 0.8186742067337036, 0.0631251335144043, 0.731778f, 0.24170565605163574, 0.976365327835083, 0.8153178691864014, 0.8984127044677734, 0.6960815787315369, 0.5096038579940796, 0.12239694595336914, 0.7142266035079956, 0.7880451679229736, 0.015918374061584473, 0.668856680393219, 0.10010641813278198, 0.7925052046775818, 0.25043708086013794, 0.344391405582428, 0.32303881645202637, 0.3068814277648926, 0.7918167114257812, 0.01320219f, 0.3430965542793274, 0.9203203916549683, 0.6411802172660828, 0.9889153242111206, 0.4726397395133972, 0.3076918125152588, 0.4680584f, 0.26654428243637085, 0.6449887752532959, 0.31182122230529785, 0.19246304035186768, 0.6237963438034058, 0.3165757f, 0.7989621162414551, 0.37942272424697876, 0.12457782030105591, 0.9272174835205078, 0.8417255282402039, 0.12413114309310913, 0.5145398378372192, 0.6842864155769348, 0.16013747453689575, 0.7154470682144165, 0.24681884050369263, 3.97861E-4f, 0.4978829026222229, 0.016645967960357666, 0.9987613558769226, 0.24865102767944336, 0.44293713569641113, 0.71945720911026, 0.1985260248184204, 0.16791987419128418, 0.03862518072128296, 0.07557564973831177, 0.26327353715896606, 0.5822992920875549, 0.7447644472122192, 0.44467437267303467, 0.525576114654541, 0.43829184770584106, 0.9741195440292358, 0.7157511115074158, 0.5872114896774292, 0.12102806568145752, 0.5752629637718201, 0.9463352560997009, 0.5632772445678711, 0.7127206921577454, 0.4905286431312561, 0.14919966459274292, 0.16633951663970947, 0.19426536560058594, 0.071639f, 0.1569261f, 0.20998424291610718, 0.47163963317871094, 0.5734783411026001, 0.6697577834129333, 0.0916903018951416, 0.7053773999214172, 0.5091942548751831, 0.591046f, 0.4325159788131714, 0.4223732352256775, 0.38127797842025757, 0.36730343103408813, 0.9199444651603699, 0.7487133145332336, 0.8005784153938293, 0.4570775032043457, 0.7127537727355957, 0.2898542284965515, 0.8685352206230164, 0.07583820819854736, 0.5434670448303223, 0.4356348514556885, 0.5805953741073608, 0.7147592306137085, 0.9934367537498474, 0.4332842230796814, 0.767250120639801, 0.4621874f, 0.7446750998497009, 0.46838104724884033, 0.03296506404876709, 0.11091488599777222, 0.9360492825508118, 0.2538573145866394, 0.29517167806625366, 0.29587697982788086, 0.902417778968811, 0.5484668612480164, 0.831264f, 0.25001317262649536, 0.4648313f, 0.4221401810646057, 0.3801417946815491, 0.10578268766403198, 0.8073093295097351, 0.5354187488555908, 0.43833786249160767, 0.3118906021118164, 0.6383227705955505, 0.7984318733215332, 0.7643505334854126, 0.6254391074180603, 0.4384617209434509, 0.3820006251335144, 0.536798894405365, 0.11588871479034424, 0.8634887337684631, 0.5453997850418091, 0.08386844396591187, 0.6564322710037231, 0.855823f, 0.26368457078933716, 0.5477932691574097, 0.8488180637359619, 0.3473512f, 0.33951807022094727, 0.906520426273346, 0.23809117078781128, 0.0703339f, 0.9929743409156799, 0.0360414981842041, 0.9235764741897583, 0.4671905040740967, 0.7763080596923828, 0.755107581615448, 0.3017298f, 0.8683740496635437, 0.7632885575294495, 0.2962263822555542, 0.11591315269470215, 0.4327585f, 0.03410977125167847, 0.3431814908981323, 0.3089836835861206, 0.08747595548629761, 0.5024642944335938, 0.5691242218017578, 0.3387439250946045, 0.2125802f, 0.6120885610580444, 0.6070190668106079, 0.726321f, 0.7670446038246155, 0.6325418949127197, 0.14544326066970825, 0.15658771991729736, 0.20130383968353271, 0.4904070496559143, 0.6301425099372864, 0.5715990662574768, 0.9308252334594727, 0.8303444981575012, 0.08115541934967041, 0.4171072840690613, 0.516190230846405, 0.37397074699401855, 0.2256726f, 0.6835756301879883, 0.4971230626106262, 0.46246641874313354, 0.37017685174942017, 0.18240207433700562, 0.1282173991203308, 0.775881290435791, 0.7670015096664429, 0.8115732073783875, 0.9582842588424683, 0.728636f, 0.19857323169708252, 0.4796156883239746, 0.25690704584121704, 0.5727071166038513, 0.8387136459350586, 0.10003447532653809, 0.02270621f, 0.18902206420898438, 0.3390364f, 0.2585823f, 0.5878645181655884, 0.3209095597267151, 0.41738057136535645, 0.051495134830474854, 0.37065207958221436, 0.2739010453224182, 0.835198700428009};
        double[] encoderPosition = new double[]{0.3436535f, 0.9081546664237976, 0.06223797798156738, 0.5858002305030823, 0.5915391445159912, 0.039404332637786865, 0.5782076120376587, 0.8724223375320435, 0.09750860929489136, 0.6970198750495911, 0.5656335949897766, 0.2344464f, 0.4305928945541382, 0.7237974405288696, 0.2288394570350647, 0.1350204348564148, 0.9766664505004883, 0.0580796f, 0.9541594386100769, 0.81034f, 0.5199496746063232, 0.45492905378341675, 0.37919121980667114, 0.009437978267669678, 0.1515814f, 0.1340326f, 0.4477001428604126, 0.9362475872039795, 0.03321004f, 0.7028568983078003, 0.9332424402236938, 0.7087405920028687, 0.8886187672615051, 0.8060168623924255, 0.5156503915786743, 0.6420605778694153, 0.9693571925163269, 0.938345730304718, 0.9306267499923706, 0.765828549861908, 0.4468708634376526, 0.047164082527160645, 0.07853960990905762, 0.0254004f, 0.1699807047843933, 0.0842371f, 0.6344608664512634, 0.37111544609069824, 0.8296870589256287, 0.7735193371772766, 0.5235157012939453, 0.38994354009628296, 0.2706971764564514, 0.08877182006835938, 0.2553131f, 0.7149799466133118, 0.8489567041397095, 0.4153788685798645, 0.20583730936050415, 0.29765355587005615, 0.8656077980995178, 0.06120413541793823, 0.417543888092041, 0.8361196517944336, 0.6095972061157227, 0.718231201171875, 0.7970010638237, 0.5150529146194458, 0.9536701440811157, 0.024302244186401367, 0.928351f, 0.4740072f, 0.7023636102676392, 0.47487103939056396, 0.30985623598098755, 0.5338637828826904, 0.5571523904800415, 0.3588405251502991, 0.14520412683486938, 0.07696706056594849, 0.10501044988632202, 0.9888868927955627, 0.8820364475250244, 0.20279055833816528, 0.2548753619194031, 0.4419432282447815, 0.2539557218551636, 0.4269649386405945, 0.0349997878074646, 0.0746063f, 0.43126481771469116, 0.019913554191589355, 0.25673872232437134, 0.814150869846344, 0.06776583194732666, 0.3080184f, 0.771365225315094, 0.3097168207168579, 0.10956346988677979, 0.8041086792945862, 0.5610645413398743, 0.4493351f, 0.53608f, 0.2672106f, 0.7690035104751587, 0.07416129112243652, 0.07812845706939697, 0.7891014814376831, 0.6825827956199646, 0.3470977544784546, 0.013252198696136475, 0.79560786485672, 0.2255808711051941, 0.6325410604476929, 0.5006039142608643, 0.6652114987373352, 0.416421f, 0.7190467119216919, 0.47800445556640625, 0.19095176458358765, 0.6294053196907043, 0.14714211225509644, 0.809719f, 0.7315372824668884, 0.11224913597106934, 0.4983493f, 0.3177680969238281, 0.954818844795227, 0.7160290479660034, 0.044832468032836914, 0.24072521924972534, 0.11527639627456665, 0.9727713465690613, 0.7662213444709778, 0.9960518479347229, 0.8240083456039429, 0.6920108199119568, 0.6034621596336365, 0.3448001f, 0.9650728106498718, 0.9620434045791626, 0.959519f, 0.9063345789909363, 0.43924105167388916, 0.54618f, 0.9720296859741211, 0.6965588927268982, 0.6317267417907715, 0.011635422706604004, 0.4003561f, 0.982580840587616, 0.2138221263885498, 0.7619112730026245, 0.09376120567321777, 0.2920429f, 0.11229926347732544, 0.34644657373428345, 0.7716800570487976, 0.18433094024658203, 0.1807397f, 0.768328845500946, 0.16238272190093994, 0.1970287f, 0.4525873064994812, 0.9170206785202026, 0.6519956588745117, 0.8034157156944275, 0.4687437415122986, 0.024027645587921143, 0.3092470169067383, 0.8502306342124939, 0.378143f, 0.1214962f, 0.11793404817581177, 0.6497014164924622, 0.58626788854599, 0.7138089537620544, 0.19261091947555542, 0.05194437503814697, 0.1554529070854187, 0.22786778211593628, 0.7251222729682922, 0.5648685097694397, 0.8766284584999084, 0.6570948958396912, 0.040240466594696045, 0.07590585947036743, 0.5725908875465393, 0.16602236032485962, 0.8858169317245483, 0.38608187437057495, 0.348754346370697, 0.17609864473342896, 0.4826553f, 0.530617356300354, 0.9726027250289917, 0.649053f, 0.7760222554206848, 0.43550997972488403, 0.584773f, 0.352492094039917, 0.20670539140701294, 0.5661183595657349, 0.4730755090713501, 0.9046435356140137, 0.42532211542129517, 0.8470034599304199, 0.5790963768959045, 0.31322646141052246, 0.05780661106109619, 0.7731549143791199, 0.8617904782295227, 0.6498541235923767, 0.5694113969802856, 0.5578445196151733, 0.173223078250885, 0.9293252229690552, 0.7240447402000427, 0.6539296507835388, 0.17105340957641602, 0.3264291286468506, 0.17832279205322266, 0.591329038143158, 0.21629053354263306, 0.585883f, 0.5464896559715271, 0.8570885062217712, 0.6022422313690186, 0.028786122798919678, 0.312599241733551, 0.33504724502563477, 0.7034846544265747, 0.48716872930526733, 0.3174442f, 0.46432948112487793, 0.29730546474456787, 0.003134608268737793, 0.1051740050315857, 0.8800785541534424, 0.9227315187454224};
        SALEvent item = this.testSendReceive((SALEvent)new ShutterBladeMotionProfileEvent(priority, blade, direction, timestampStart, startPosition, targetDuration, targetPosition, endPosition, actualDuration, hallSensorCount, timestampHallSensor, hallSensorID, hallSensorPosition, hallSensorTransition, encoderCount, timestampEncoder, encoderPosition));
        Assert.assertTrue((boolean)(item instanceof ShutterBladeMotionProfileEvent));
        ShutterBladeMotionProfileEvent item_ = (ShutterBladeMotionProfileEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)blade, (Object)item_.getBlade());
        Assert.assertEquals((Object)direction, (Object)item_.getDirection());
        Assert.assertEquals((double)timestampStart, (double)item_.getTimestampStart(), (double)1.0E-6f);
        Assert.assertEquals((double)startPosition, (double)item_.getStartPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)targetDuration, (double)item_.getTargetDuration(), (double)1.0E-6f);
        Assert.assertEquals((double)targetPosition, (double)item_.getTargetPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)endPosition, (double)item_.getEndPosition(), (double)1.0E-6f);
        Assert.assertEquals((double)actualDuration, (double)item_.getActualDuration(), (double)1.0E-6f);
        Assert.assertEquals((long)hallSensorCount, (long)item_.getHallSensorCount());
        Assert.assertArrayEquals((double[])timestampHallSensor, (double[])item_.getTimestampHallSensor(), (double)1.0E-6f);
        Assert.assertArrayEquals((int[])hallSensorID, (int[])item_.getHallSensorID());
        Assert.assertArrayEquals((double[])hallSensorPosition, (double[])item_.getHallSensorPosition(), (double)1.0E-6f);
        Assert.assertArrayEquals((boolean[])hallSensorTransition, (boolean[])item_.getHallSensorTransition());
        Assert.assertEquals((long)encoderCount, (long)item_.getEncoderCount());
        Assert.assertArrayEquals((double[])timestampEncoder, (double[])item_.getTimestampEncoder(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])encoderPosition, (double[])item_.getEncoderPosition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageStoredEvent() throws Exception {
        int priority = 32;
        String imageName = "wlymchhttylhhx";
        double timestampImageStored = 0.5537099242210388;
        SALEvent item = this.testSendReceive((SALEvent)new ImageStoredEvent(priority, imageName, timestampImageStored));
        Assert.assertTrue((boolean)(item instanceof ImageStoredEvent));
        ImageStoredEvent item_ = (ImageStoredEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampImageStored, (double)item_.getTimestampImageStored(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFitsFilesWrittenEvent() throws Exception {
        int priority = 617;
        String imageName = "wkcpyijysskjxrr";
        double timestampFilesWritten = 0.008130431175231934;
        String rootFileName = "n";
        String relativeFileNames = "y";
        String fileNode = "";
        SALEvent item = this.testSendReceive((SALEvent)new FitsFilesWrittenEvent(priority, imageName, timestampFilesWritten, rootFileName, relativeFileNames, fileNode));
        Assert.assertTrue((boolean)(item instanceof FitsFilesWrittenEvent));
        FitsFilesWrittenEvent item_ = (FitsFilesWrittenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampFilesWritten, (double)item_.getTimestampFilesWritten(), (double)1.0E-6f);
        Assert.assertEquals((Object)rootFileName, (Object)item_.getRootFileName());
        Assert.assertEquals((Object)relativeFileNames, (Object)item_.getRelativeFileNames());
        Assert.assertEquals((Object)fileNode, (Object)item_.getFileNode());
    }

    @Test
    public void sendReceiveFileCommandExecutionEvent() throws Exception {
        int priority = 965;
        String imageName = "wzsjmpudytfuylhcmrbjcningvartww";
        double timestampCommandComplete = 0.42665135860443115;
        String command = "";
        int rc = 98;
        SALEvent item = this.testSendReceive((SALEvent)new FileCommandExecutionEvent(priority, imageName, timestampCommandComplete, command, rc));
        Assert.assertTrue((boolean)(item instanceof FileCommandExecutionEvent));
        FileCommandExecutionEvent item_ = (FileCommandExecutionEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampCommandComplete, (double)item_.getTimestampCommandComplete(), (double)1.0E-6f);
        Assert.assertEquals((Object)command, (Object)item_.getCommand());
        Assert.assertEquals((long)rc, (long)item_.getRc());
    }

    @Test
    public void sendReceiveImageVisualizationEvent() throws Exception {
        int priority = 20;
        String imageName = "sgtqejkkqkiuxlogpaw";
        double timestampVisualizationAvailable = 0.3559845f;
        String url = "z";
        String thumbnail = "";
        SALEvent item = this.testSendReceive((SALEvent)new ImageVisualizationEvent(priority, imageName, timestampVisualizationAvailable, url, thumbnail));
        Assert.assertTrue((boolean)(item instanceof ImageVisualizationEvent));
        ImageVisualizationEvent item_ = (ImageVisualizationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((double)timestampVisualizationAvailable, (double)item_.getTimestampVisualizationAvailable(), (double)1.0E-6f);
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)thumbnail, (Object)item_.getThumbnail());
    }

    @Test
    public void sendReceiveSettingVersionsEvent() throws Exception {
        int priority = 391;
        String recommendedSettingsVersion = "u";
        String recommendedSettingsLabels = "v";
        String settingsUrl = "";
        SALEvent item = this.testSendReceive((SALEvent)new SettingVersionsEvent(priority, recommendedSettingsVersion, recommendedSettingsLabels, settingsUrl));
        Assert.assertTrue((boolean)(item instanceof SettingVersionsEvent));
        SettingVersionsEvent item_ = (SettingVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)recommendedSettingsVersion, (Object)item_.getRecommendedSettingsVersion());
        Assert.assertEquals((Object)recommendedSettingsLabels, (Object)item_.getRecommendedSettingsLabels());
        Assert.assertEquals((Object)settingsUrl, (Object)item_.getSettingsUrl());
    }

    @Test
    public void sendReceiveErrorCodeEvent() throws Exception {
        int priority = 587;
        int errorCode = 988;
        String errorReport = "";
        String traceback = "z";
        SALEvent item = this.testSendReceive((SALEvent)new ErrorCodeEvent(priority, errorCode, errorReport, traceback));
        Assert.assertTrue((boolean)(item instanceof ErrorCodeEvent));
        ErrorCodeEvent item_ = (ErrorCodeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)errorCode, (long)item_.getErrorCode());
        Assert.assertEquals((Object)errorReport, (Object)item_.getErrorReport());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
    }

    @Test
    public void sendReceiveAppliedSettingsMatchStartEvent() throws Exception {
        int priority = 627;
        boolean appliedSettingsMatchStartIsTrue = true;
        SALEvent item = this.testSendReceive((SALEvent)new AppliedSettingsMatchStartEvent(priority, appliedSettingsMatchStartIsTrue));
        Assert.assertTrue((boolean)(item instanceof AppliedSettingsMatchStartEvent));
        AppliedSettingsMatchStartEvent item_ = (AppliedSettingsMatchStartEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)appliedSettingsMatchStartIsTrue, (Object)item_.isAppliedSettingsMatchStartIsTrue());
    }

    @Test
    public void sendReceiveLogLevelEvent() throws Exception {
        int priority = 471;
        int level = 202;
        SALEvent item = this.testSendReceive((SALEvent)new LogLevelEvent(priority, level));
        Assert.assertTrue((boolean)(item instanceof LogLevelEvent));
        LogLevelEvent item_ = (LogLevelEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)level, (long)item_.getLevel());
    }

    @Test
    public void sendReceiveLogMessageEvent() throws Exception {
        int priority = 591;
        String name = "z";
        int level = 478;
        String message = "";
        String traceback = "";
        String filePath = "w";
        String functionName = "";
        int lineNumber = 89;
        int process = 343;
        SALEvent item = this.testSendReceive((SALEvent)new LogMessageEvent(priority, name, level, message, traceback, filePath, functionName, lineNumber, process));
        Assert.assertTrue((boolean)(item instanceof LogMessageEvent));
        LogMessageEvent item_ = (LogMessageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)name, (Object)item_.getName());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)message, (Object)item_.getMessage());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
        Assert.assertEquals((Object)filePath, (Object)item_.getFilePath());
        Assert.assertEquals((Object)functionName, (Object)item_.getFunctionName());
        Assert.assertEquals((long)lineNumber, (long)item_.getLineNumber());
        Assert.assertEquals((long)process, (long)item_.getProcess());
    }

    @Test
    public void sendReceiveSettingsAppliedEvent() throws Exception {
        int priority = 192;
        String settingsVersion = "eprlnrkqddbwrhvcsgxkvgxpyxswzqpkaaqntloobhdkxrkxdoxagtoomlxvilfeafgnmwlmwphvexpbnsmshrgmbqpwemntzhumcznkheakygpmdfxqopslcwnprkt";
        String otherSettingsEvents = "";
        SALEvent item = this.testSendReceive((SALEvent)new SettingsAppliedEvent(priority, settingsVersion, otherSettingsEvents));
        Assert.assertTrue((boolean)(item instanceof SettingsAppliedEvent));
        SettingsAppliedEvent item_ = (SettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)settingsVersion, (Object)item_.getSettingsVersion());
        Assert.assertEquals((Object)otherSettingsEvents, (Object)item_.getOtherSettingsEvents());
    }

    @Test
    public void sendReceiveSimulationModeEvent() throws Exception {
        int priority = 907;
        int mode = 538;
        SALEvent item = this.testSendReceive((SALEvent)new SimulationModeEvent(priority, mode));
        Assert.assertTrue((boolean)(item instanceof SimulationModeEvent));
        SimulationModeEvent item_ = (SimulationModeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)mode, (long)item_.getMode());
    }

    @Test
    public void sendReceiveSoftwareVersionsEvent() throws Exception {
        int priority = 995;
        String salVersion = "lwdyztmjwojbermijzrsugxcznshxbbtujhdqwaesuwjzonoflujbkrmfaseypuatey";
        String xmlVersion = "vqbiwaeiyblxsffhsxbfemtixzzoinvduzyppwioookemrfdiqxrcngqmmgbluuyuybarqvaodqvcxfplcgar";
        String openSpliceVersion = "hdyxrnhpkgqirnwuwn";
        String cscVersion = "jzcujqpkwcbzsdjarsbqvbgwxscukmhfkvqaejcefntgkyiuhnfalzpqqkkokltcreubjixkmrcvzdjlmmfgbwnevlxwssmvgkyhmaeggadfjzvqlkwikumaqtksyswzlqqqooynumkuqwwprxbzvezlwjuviqrlfocphdwqyejsuflbcjgnkcfemjbnyzebsgnkguovfsplmrhvdcpmujhsxzjkhissokivbkevvoxddtcbiyqy";
        String subsystemVersions = "";
        SALEvent item = this.testSendReceive((SALEvent)new SoftwareVersionsEvent(priority, salVersion, xmlVersion, openSpliceVersion, cscVersion, subsystemVersions));
        Assert.assertTrue((boolean)(item instanceof SoftwareVersionsEvent));
        SoftwareVersionsEvent item_ = (SoftwareVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)salVersion, (Object)item_.getSalVersion());
        Assert.assertEquals((Object)xmlVersion, (Object)item_.getXmlVersion());
        Assert.assertEquals((Object)openSpliceVersion, (Object)item_.getOpenSpliceVersion());
        Assert.assertEquals((Object)cscVersion, (Object)item_.getCscVersion());
        Assert.assertEquals((Object)subsystemVersions, (Object)item_.getSubsystemVersions());
    }

    @Test
    public void sendReceiveHeartbeatEvent() throws Exception {
        int priority = 680;
        boolean heartbeat = true;
        SALEvent item = this.testSendReceive((SALEvent)new HeartbeatEvent(priority, heartbeat));
        Assert.assertTrue((boolean)(item instanceof HeartbeatEvent));
        HeartbeatEvent item_ = (HeartbeatEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
    }

    @Test
    public void sendReceiveAuthListEvent() throws Exception {
        int priority = 611;
        String authorizedUsers = "";
        String nonAuthorizedCSCs = "e";
        SALEvent item = this.testSendReceive((SALEvent)new AuthListEvent(priority, authorizedUsers, nonAuthorizedCSCs));
        Assert.assertTrue((boolean)(item instanceof AuthListEvent));
        AuthListEvent item_ = (AuthListEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)authorizedUsers, (Object)item_.getAuthorizedUsers());
        Assert.assertEquals((Object)nonAuthorizedCSCs, (Object)item_.getNonAuthorizedCSCs());
    }
}

