package org.lsst.sal.cccamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Vacuum_TurboTelemetry extends CameraTelemetry {
  private final double rpm;

  private final double power;

  private final double voltage;

  private final double turboSpeed;

  private final double pumpTemperature;

  private final double status;

  private final double cntrlrSinkTemperature;

  private final double driveFrequency;

  private final double current;

  private final double cntrlrAirTemperature;

  public Vacuum_TurboTelemetry(double rpm, double power, double voltage, double turboSpeed,
      double pumpTemperature, double status, double cntrlrSinkTemperature, double driveFrequency,
      double current, double cntrlrAirTemperature) {
    this.rpm = rpm;
    this.power = power;
    this.voltage = voltage;
    this.turboSpeed = turboSpeed;
    this.pumpTemperature = pumpTemperature;
    this.status = status;
    this.cntrlrSinkTemperature = cntrlrSinkTemperature;
    this.driveFrequency = driveFrequency;
    this.current = current;
    this.cntrlrAirTemperature = cntrlrAirTemperature;
  }

  public double getRpm() {
    return rpm;
  }

  public double getPower() {
    return power;
  }

  public double getVoltage() {
    return voltage;
  }

  public double getTurboSpeed() {
    return turboSpeed;
  }

  public double getPumpTemperature() {
    return pumpTemperature;
  }

  public double getStatus() {
    return status;
  }

  public double getCntrlrSinkTemperature() {
    return cntrlrSinkTemperature;
  }

  public double getDriveFrequency() {
    return driveFrequency;
  }

  public double getCurrent() {
    return current;
  }

  public double getCntrlrAirTemperature() {
    return cntrlrAirTemperature;
  }

  @Override
  public String toString() {
    return "Vacuum_TurboTelemetry{" + "rpm=" + rpm +", power=" + power +", voltage=" + voltage +
        ", turboSpeed=" + turboSpeed +", pumpTemperature=" + pumpTemperature +", status=" + status +
        ", cntrlrSinkTemperature=" + cntrlrSinkTemperature +", driveFrequency=" + driveFrequency +
        ", current=" + current +", cntrlrAirTemperature=" + cntrlrAirTemperature +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double rpm;

    private double power;

    private double voltage;

    private double turboSpeed;

    private double pumpTemperature;

    private double status;

    private double cntrlrSinkTemperature;

    private double driveFrequency;

    private double current;

    private double cntrlrAirTemperature;

    private Builder() {
    }

    public Builder rpm(double rpm) {
      this.rpm = rpm;
      return this;
    }

    public Builder power(double power) {
      this.power = power;
      return this;
    }

    public Builder voltage(double voltage) {
      this.voltage = voltage;
      return this;
    }

    public Builder turboSpeed(double turboSpeed) {
      this.turboSpeed = turboSpeed;
      return this;
    }

    public Builder pumpTemperature(double pumpTemperature) {
      this.pumpTemperature = pumpTemperature;
      return this;
    }

    public Builder status(double status) {
      this.status = status;
      return this;
    }

    public Builder cntrlrSinkTemperature(double cntrlrSinkTemperature) {
      this.cntrlrSinkTemperature = cntrlrSinkTemperature;
      return this;
    }

    public Builder driveFrequency(double driveFrequency) {
      this.driveFrequency = driveFrequency;
      return this;
    }

    public Builder current(double current) {
      this.current = current;
      return this;
    }

    public Builder cntrlrAirTemperature(double cntrlrAirTemperature) {
      this.cntrlrAirTemperature = cntrlrAirTemperature;
      return this;
    }

    public Vacuum_TurboTelemetry build() {
      return new Vacuum_TurboTelemetry(rpm, power, voltage, turboSpeed, pumpTemperature, status, cntrlrSinkTemperature, driveFrequency, current, cntrlrAirTemperature);
    }
  }
}
