package org.lsst.sal.cccamera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Vacuum_Cold1Telemetry extends CameraTelemetry {
  private final double setPower;

  private final double power;

  private final double rejectTemperature;

  private final double autoOnTemperature;

  private final double autoOffTemperature;

  private final double temperature;

  private final double autoOffEnabled;

  private final double setpoint;

  public Vacuum_Cold1Telemetry(double setPower, double power, double rejectTemperature,
      double autoOnTemperature, double autoOffTemperature, double temperature,
      double autoOffEnabled, double setpoint) {
    this.setPower = setPower;
    this.power = power;
    this.rejectTemperature = rejectTemperature;
    this.autoOnTemperature = autoOnTemperature;
    this.autoOffTemperature = autoOffTemperature;
    this.temperature = temperature;
    this.autoOffEnabled = autoOffEnabled;
    this.setpoint = setpoint;
  }

  public double getSetPower() {
    return setPower;
  }

  public double getPower() {
    return power;
  }

  public double getRejectTemperature() {
    return rejectTemperature;
  }

  public double getAutoOnTemperature() {
    return autoOnTemperature;
  }

  public double getAutoOffTemperature() {
    return autoOffTemperature;
  }

  public double getTemperature() {
    return temperature;
  }

  public double getAutoOffEnabled() {
    return autoOffEnabled;
  }

  public double getSetpoint() {
    return setpoint;
  }

  @Override
  public String toString() {
    return "Vacuum_Cold1Telemetry{" + "setPower=" + setPower +", power=" + power +
        ", rejectTemperature=" + rejectTemperature +", autoOnTemperature=" + autoOnTemperature +
        ", autoOffTemperature=" + autoOffTemperature +", temperature=" + temperature +
        ", autoOffEnabled=" + autoOffEnabled +", setpoint=" + setpoint +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double setPower;

    private double power;

    private double rejectTemperature;

    private double autoOnTemperature;

    private double autoOffTemperature;

    private double temperature;

    private double autoOffEnabled;

    private double setpoint;

    private Builder() {
    }

    public Builder setPower(double setPower) {
      this.setPower = setPower;
      return this;
    }

    public Builder power(double power) {
      this.power = power;
      return this;
    }

    public Builder rejectTemperature(double rejectTemperature) {
      this.rejectTemperature = rejectTemperature;
      return this;
    }

    public Builder autoOnTemperature(double autoOnTemperature) {
      this.autoOnTemperature = autoOnTemperature;
      return this;
    }

    public Builder autoOffTemperature(double autoOffTemperature) {
      this.autoOffTemperature = autoOffTemperature;
      return this;
    }

    public Builder temperature(double temperature) {
      this.temperature = temperature;
      return this;
    }

    public Builder autoOffEnabled(double autoOffEnabled) {
      this.autoOffEnabled = autoOffEnabled;
      return this;
    }

    public Builder setpoint(double setpoint) {
      this.setpoint = setpoint;
      return this;
    }

    public Vacuum_Cold1Telemetry build() {
      return new Vacuum_Cold1Telemetry(setPower, power, rejectTemperature, autoOnTemperature, autoOffTemperature, temperature, autoOffEnabled, setpoint);
    }
  }
}
